<?php
function nasa_header_icons_sc($atts = array(), $content = null) {
    $dfAttr = array(
        'show_mini_cart' => 'yes',
        'show_mini_compare' => 'yes',
        'show_mini_wishlist' => 'yes',
        'el_class' => ''
    );
    extract(shortcode_atts($dfAttr, $atts));
    
    $nasa_function = defined('NASA_THEME_PREFIX') && function_exists(NASA_THEME_PREFIX . '_header_icons') ? NASA_THEME_PREFIX . '_header_icons' : false;
    if($nasa_function) {
        $cart = $show_mini_cart == 'yes' ? true : false;
        $compare = $show_mini_compare == 'yes' ? true : false;
        $wishlist = $show_mini_wishlist == 'yes' ? true : false;

        $content = '<div class="nasa-header-icons-wrap' . esc_attr($el_class != '' ? ' ' . $el_class : '') . '">' .
            $nasa_function(false, $cart, $compare, $wishlist, false) .
        '</div>';
    } else {
        $content = esc_html__('Please active Theme of NasaTheme to using this element.', 'nasa-core');
    }

    return $content;
}

function nasa_header_search_sc($atts = array(), $content = null) {
    $dfAttr = array(
        'el_class' => ''
    );
    extract(shortcode_atts($dfAttr, $atts));
    
    $nasa_function = defined('NASA_THEME_PREFIX') && function_exists(NASA_THEME_PREFIX . '_search') ? NASA_THEME_PREFIX . '_search' : false;
    
    if($nasa_function) {
        $content = '<div class="nasa-header-search-wrap' . esc_attr($el_class != '' ? ' ' . $el_class : '') . '">' .
            $nasa_function('full') .
        '</div>';
    } else {
        $content = esc_html__('Please active Theme of NasaTheme to using this element.', 'nasa-core');
    }

    return $content;
}

function nasa_register_sc_header(){
    // **********************************************************************// 
    // ! Register New Element: Group icons in header
    // **********************************************************************//
    $param_nasa_sc_icons = array(
        "name" => esc_html__("Header icons", 'nasa-core'),
        "base" => "nasa_sc_icons",
        'icon' => 'icon-wpb-nasatheme',
        'description' => esc_html__("Header icons Cart | Wishlist | Compare", 'nasa-core'),
        "category" => 'Header Builder',
        "params" => array(
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Show Mini Cart", 'nasa-core'),
                "param_name" => "show_mini_cart",
                "value" => array(
                    esc_html__('Yes', 'nasa-core') => 'yes',
                    esc_html__('No', 'nasa-core') => 'no'
                ),
                "std" => 'yes',
                "admin_label" => true
            ),

            array(
                "type" => "dropdown",
                "heading" => esc_html__("Show Mini Compare", 'nasa-core'),
                "param_name" => "show_mini_compare",
                "value" => array(
                    esc_html__('Yes', 'nasa-core') => 'yes',
                    esc_html__('No', 'nasa-core') => 'no'
                ),
                "std" => 'yes',
                "admin_label" => true
            ),

            array(
                "type" => "dropdown",
                "heading" => esc_html__("Show Mini Wishlist", 'nasa-core'),
                "param_name" => "show_mini_wishlist",
                "value" => array(
                    esc_html__('Yes', 'nasa-core') => 'yes',
                    esc_html__('No', 'nasa-core') => 'no'
                ),
                "std" => 'yes',
                "admin_label" => true
            ),

            array(
                "type" => "textfield",
                "heading" => esc_html__("Extra class name", 'nasa-core'),
                "param_name" => "el_class",
                "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'nasa-core')
            )
        )
    );
    vc_map($param_nasa_sc_icons);
    
    // **********************************************************************// 
    // ! Register New Element: Search form in header
    // **********************************************************************//
    $param_nasa_search = array(
        "name" => esc_html__("Header Search", 'nasa-core'),
        "base" => "nasa_sc_search_form",
        'icon' => 'icon-wpb-nasatheme',
        'description' => esc_html__("Header search form", 'nasa-core'),
        "category" => 'Header Builder',
        "params" => array(
            array(
                "type" => "textfield",
                "heading" => esc_html__("Extra class name", 'nasa-core'),
                "param_name" => "el_class",
                "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'nasa-core')
            )
        )
    );
    
    vc_map($param_nasa_search);
}
