<?php
function nasa_sc_products_deal($atts, $content = null) {
    global $woocommerce, $nasa_opt;
    
    if (!$woocommerce) {
        return $content;
    }
    
    $dfAttr = array(
        'id' => '',
        'type_grid' => 'best_selling',
        'type_show' => 'grid',
        'title' => '',
        'auto_slide' => "false",
        'arrows' => 1,
        'deal_grid_limit' => 3,
        'deal_pos' => 'left',
        'el_class' => ''
    );
    extract(shortcode_atts($dfAttr, $atts));
    
    if(!(int) $id) {
        return '';
    }

    $deal_grid_limit = (int) $deal_grid_limit < 3 ? 3 : (int) $deal_grid_limit;
    
    $_id = rand();
    $product = nasa_getProductDeals($id);
    $catids = array();
    
    $type_show = in_array($type_show, array('grid', 'carousel')) ? $type_show : 'grid';
    
    ob_start();
    if ($product && $product->is_visible()) :
        $main_id = $product->get_type() == 'variation' ? wp_get_post_parent_id($id) : $id;
        $product_error = $main_id ? false : true;
        
        $nasa_animated_products = isset($_REQUEST['effect-product']) && in_array($_REQUEST['effect-product'], array('hover-fade', 'hover-flip', 'hover-bottom-to-top')) ? $_REQUEST['effect-product'] : (isset($nasa_opt['animated_products']) ? $nasa_opt['animated_products'] : '');
        
        $attachment_ids = $nasa_animated_products != '' ? $product->get_gallery_image_ids() : array();
        $count_imgs = count($attachment_ids);
        $img_thumbs = $img_disp = array();
        $thumbs = '';
        $product_title = $product->get_title() . ($product_error ? esc_html__(' - Has been error. You need rebuilt this product.', 'nasa-core') : '');
        $link = $product_error ? '#' : get_the_permalink($id);

        $image_pri = array();
        if ($primaryImg = get_post_thumbnail_id($product->get_id())) {
            $imgSize = $type_show == 'grid' ? 'shop_single' : 'shop_catalog';
            $image_pri['src'] = wp_get_attachment_image_src($primaryImg, apply_filters('single_product_normal_thumbnail_size', $imgSize));
        } else {
            $image_pri['src'][0] = wc_placeholder_img_src();
        }

        $terms = get_the_terms($main_id, 'product_cat');
        if (!empty($terms)) {
            foreach ($terms as $v) {
                $catids[] = $v->term_taxonomy_id;
            }
        }

        if ($count_imgs) {
            // primary image
            foreach ($attachment_ids as $key => $img) {
                $img_disp[$key]['src'] = wp_get_attachment_image_src(
                    $img,
                    apply_filters('catalog_product_large_thumbnail_size', 'shop_catalog'), array(
                        'title' => $title
                    )
                );
                break;
            }
        }
        ?>
        <div class="woocommerce nasa-products-deal<?php echo ' nasa-products-deal-' . $_id . ($el_class != '' ? ' ' . $el_class : ''); ?>">
            <div class="inner-content">
                <?php
                if(is_file(NASA_CORE_PRODUCT_LAYOUTS . 'nasa_products_deal/product_deal_' . $type_show . '.php')) :
                    include NASA_CORE_PRODUCT_LAYOUTS . 'nasa_products_deal/product_deal_' . $type_show . '.php';
                endif;
                ?>
            </div>
        </div>
    <?php
    endif;
    wp_reset_postdata();
    $content = ob_get_clean();

    return $content;
}

// **********************************************************************// 
// ! Register New Element: Nasa product Deal
// **********************************************************************//
function nasa_register_products_deals(){
    vc_map(array(
        "name" => esc_html__("Products Deal Schedule", 'nasa-core'),
        "base" => "nasa_products_deal",
        'icon' => 'icon-wpb-nasatheme',
        'description' => esc_html__("Display product deal and more.", 'nasa-core'),
        "class" => "",
        "category" => 'Nasa Core',
        "params" => array(
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Select a product deal", 'nasa-core'),
                "param_name" => "id",
                "value" => nasa_getListProductDeals(),
                "admin_label" => true
            ),
            
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Type show for extra", 'nasa-core'),
                "param_name" => "type_grid",
                "value" => array(
                    esc_html__('Best Selling', 'nasa-core') => 'best_selling',
                    esc_html__('Featured Products', 'nasa-core') => 'featured_product',
                    esc_html__('Top Rate', 'nasa-core') => 'top_rate',
                    esc_html__('Recent Products', 'nasa-core') => 'recent_product',
                    esc_html__('On Sale', 'nasa-core') => 'on_sale',
                    esc_html__('Recent Review', 'nasa-core') => 'recent_review',
                    esc_html__('Product Deals', 'nasa-core') => 'deals'
                ),
                "std" => 'best_selling',
                "admin_label" => true,
                "description" => esc_html__("Select type extra products to show.", 'nasa-core')
            ),
            
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Style show for extra", 'nasa-core'),
                "param_name" => "type_show",
                "value" => array(
                    esc_html__('Grid', 'nasa-core') => 'grid',
                    esc_html__('Carousel', 'nasa-core') => 'carousel'
                ),
                "std" => 'grid',
                "admin_label" => true,
                "description" => esc_html__("Select style extra products to show.", 'nasa-core')
            ),
            
            array(
                "type" => "textfield",
                "heading" => esc_html__("Title", 'nasa-core'),
                "param_name" => "title",
                "value" => '',
                "dependency" => array(
                    "element" => "type_show",
                    "value" => array(
                        "grid"
                    )
                )
            ),
            
            array(
                "type" => "dropdown",
                "heading" => esc_html__('Deal Position', 'nasa-core'),
                "param_name" => 'deal_pos',
                "value" => array(
                    esc_html__('Left', 'nasa-core') => 'left',
                    esc_html__('Right', 'nasa-core') => 'right'
                ),
                "std" => 'false',
                "dependency" => array(
                    "element" => "type_show",
                    "value" => array(
                        "grid"
                    )
                )
            ),
            
            array(
                "type" => "textfield",
                "heading" => esc_html__("Carousel limit", 'nasa-core'),
                "param_name" => "deal_grid_limit",
                "value" => 3,
                "dependency" => array(
                    "element" => "type_show",
                    "value" => array(
                        "carousel"
                    )
                )
            ),
            
            array(
                "type" => "dropdown",
                "heading" => esc_html__('Slide auto', 'nasa-core'),
                "param_name" => 'auto_slide',
                "value" => array(
                    esc_html__('Yes, please', 'nasa-core') => 'true',
                    esc_html__('No, thank', 'nasa-core') => 'false'
                ),
                "std" => 'false',
                "dependency" => array(
                    "element" => "type_show",
                    "value" => array(
                        "carousel"
                    )
                )
            ),
            
            array(
                "type" => "dropdown",
                "heading" => esc_html__('Show arrows', 'nasa-core'),
                "param_name" => 'arrows',
                "value" => array(
                    esc_html__('Yes, please', 'nasa-core') => 1,
                    esc_html__('No, thank', 'nasa-core') => 0
                ),
                "std" => 1,
                "dependency" => array(
                    "element" => "type_show",
                    "value" => array(
                        "carousel"
                    )
                ),
                "description" => esc_html__("Show arrows.", 'nasa-core')
            ),
            
            array(
                "type" => "textfield",
                "heading" => esc_html__("Extra class name", 'nasa-core'),
                "param_name" => "el_class",
                "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'nasa-core')
            )
        )
    ));
}
