<?php if(isset($title) && $title != '') : ?>
    <div class="row text-center">
        <div class="large-12 columns">
            <div class="nasa-title">
                <h3 class="nasa-heading-title">
                    <span class="nasa-title-wrap">
                        <span><?php echo esc_attr($title); ?></span>
                    </span>
                </h3>
            </div>
        </div>
    </div>
<?php endif; ?>

<div class="row text-center">
    <div class="large-12 columns nasa-sc-p-price margin-bottom-5">
        <span class="price"><?php echo $product->get_price_html();?></span>
    </div>
    
    <div class="large-12 columns nasa-sc-p-title">
        <h3>
            <a href="<?php echo esc_url($link); ?>" title="<?php echo esc_attr($product_name); ?>">
                <?php echo $product_name;?>
            </a>
        </h3>
    </div>
    
    <?php if($product->time_sale) : ?>
        <div class="large-12 columns nasa-sc-p-countdown">
            <div class="product-deal-special-countdown nasa-single-product-deal-countdown">
                <table>
                    <tr>
                        <td class="text-center">
                            <?php echo nasa_time_sale($product->time_sale); ?>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
    <?php endif;?>
    
    <?php if($stock_available) :?>
        <div class="large-12 columns nasa-products-special-deal">
            <div class="product-deal-special-progress">
                <div class="deal-stock-label">
                    <span class="stock-available text-left"><?php echo esc_html__('Available:', 'nasa-core');?> <strong><?php echo esc_html($stock_available); ?></strong></span>
                    <span class="stock-sold text-right"><?php echo esc_html__('Already Sold:', 'nasa-core');?> <strong><?php echo esc_html($stock_sold); ?></strong></span>
                </div>
                <div class="deal-progress">
                    <span class="deal-progress-bar" style="<?php echo esc_attr('width:' . $percentage . '%'); ?>"><?php echo $percentage; ?></span>
                </div>
            </div>
        </div>
    <?php endif; ?>
    
    <?php if($btn_url != '') :?>
        <div class="large-12 columns nasa-product-deal-btn">
            <a class="button small" href="<?php echo esc_url($btn_url); ?>" title="<?php echo esc_attr($btn_text); ?>">
                <?php echo $btn_text; ?>
            </a>
        </div>
    <?php endif; ?>
</div>
