<?php
if($type_grid == ''){
    $type_grid = 'best_selling';
}

$product_grid = nasa_woocommerce_query($type_grid, 4, $catids, 1, array($main_id));
$products_cats = function_exists('wc_get_product_category_list') ? wc_get_product_category_list($main_id) : $product->get_categories();
$_delay_item = (isset($nasa_opt['delay_overlay']) && (int) $nasa_opt['delay_overlay']) ? (int) $nasa_opt['delay_overlay'] : 100;
$title_top = true;
$GLOBALS['product'] = $product;
$rating = false;
if ($main_id != $id) {
    $parentProduct = wc_get_product($main_id);
    $rating = $parentProduct ? $parentProduct->get_average_rating() : $rating;
} else {
    $rating = $product->get_average_rating();
}

$deal_pos = !isset($deal_pos) || $deal_pos !== 'right' ? 'left' : 'right';

$class_wrap = 'wow fadeInUp product-item nasa-type-1 grid';
$class_wrap .= $nasa_animated_products ? ' ' . $nasa_animated_products : '';

$save_price = false;
if(!$product_error) {
    $regular_price = $product->get_regular_price();
    $sale_price = $product->get_sale_price();
    $save_price = '<span class="price">' . wc_price($regular_price - $sale_price) . '</span>';
}
?>
<div class="row nasa-row-deal-grid-4">
    <!-- Deal -->
    <div class="columns large-6 main-deal-block <?php echo $deal_pos; ?>">
        <div class="nasa-warper-border padding-45 products">
            <div class="<?php echo esc_attr($class_wrap); ?>" data-wow-duration="1s" data-wow-delay="<?php echo $_delay_item; ?>ms">
                <div class="inner-wrap">
                    <div class="product-outner">
                        <div class="product-inner">
                            <div class="row">
                                <div class="nasa-sc-p-img large-12 columns">
                                    <div class="row margin-bottom-15">
                                        <div class="large-7 small-7 medium-7 columns">
                                            <div class="nasa-title">
                                                <h2 class="nasa-title-heading margin-top-0">
                                                    <span><?php echo $title; ?></span>
                                                </h2>
                                            </div>
                                        </div>
                                        <div class="large-5 small-5 medium-5 columns text-right rtl-text-left">
                                            <?php echo $save_price ? '<span class="nasa-save-price">' . esc_html__('SAVE ', 'nasa-core') . $save_price . '</span>' : ''; ?>
                                        </div>
                                    </div>
                                    
                                    <div class="images-popups-gallery">
                                        <div class="nasa-sc-product-img product-img hover-overlay main-images-<?php echo $_id;?>">
                                            <?php
                                            if($image_pri): ?>
                                                <a href="<?php echo esc_url($link);?>" title="<?php echo esc_attr($product_title);?>" class="woocommerce-additional-image">
                                                    <div class="main-img">
                                                        <img src="<?php echo esc_attr($image_pri['src'][0]);?>" alt="<?php echo esc_attr($product_title);?>" />
                                                    </div>                              
                                                    <?php
                                                        if($count_imgs) :
                                                            foreach($img_disp as $key => $img): ?>
                                                                <div class="back-img back">
                                                                    <img src="<?php echo esc_attr($img['src'][0]);?>" alt="<?php echo esc_attr($product_title);?>" />
                                                                </div>
                                                            <?php 
                                                            break;
                                                            endforeach;
                                                        endif;
                                                    ?>
                                                </a>
                                            <?php
                                            endif;
                                            
                                            wc_get_template('loop/sale-flash.php');
                                            /*
                                             * Nasa Gift icon
                                             */
                                            do_action('nasa_gift_featured');
                                            
                                            /**
                                             * Group buttons
                                             */
                                            $buttons = '';
                                            $nasa_function = defined('NASA_THEME_PREFIX') && function_exists(NASA_THEME_PREFIX . '_product_group_button') ? NASA_THEME_PREFIX . '_product_group_button' : false;

                                            if($nasa_function) :
                                                $buttons = $nasa_function('popup'); ?>
                                                <div class="info columns nasa-info-main-block">
                                                    <div class="nasa-product-grid">
                                                        <?php echo $buttons; ?>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="large-12 columns margin-top-25">
                                    <div class="row">
                                        <div class="large-6 medium-12 columns">
                                            <div class="nasa-categories">
                                                <p><?php echo $products_cats; ?></p>
                                            </div>
                                            
                                            <div class="nasa-sc-p-title">
                                                <h4>
                                                    <a href="<?php echo esc_url($link); ?>" title="<?php echo esc_attr($product_title); ?>">
                                                        <?php echo $product_title;?>
                                                    </a>
                                                </h4>
                                            </div>
                                            
                                            <?php echo $rating ? wc_get_rating_html($rating) : ''; ?>
                                            
                                            <div class="nasa-sc-p-price">
                                                <span class="price"><?php echo $product->get_price_html();?></span>
                                            </div>
                                        </div>
                                        
                                        <?php if($product->time_sale):?>
                                            <div class="large-6 medium-12 columns nasa-sc-pdeal-countdown margin-top-5 nasa-deal-grid text-right rtl-text-left">
                                                <span class="nasa-label nasa-block"><?php echo esc_html__('Offer is time limited'); ?></span>
                                                <?php echo nasa_time_sale($product->time_sale); ?>
                                            </div>
                                        <?php endif;?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Grid -->
    <div class="columns large-6 products nasa-sc-product-deals-grid">
        <div class="row">
            <div class="large-12 columns">
                <?php 
                if($product_grid->post_count) :
                    echo '<ul class="large-block-grid-2 medium-block-grid-2 small-block-grid-2">';
                    $count = 0;
                    $_delay = $_delay_item;

                    while ($product_grid->have_posts()) :
                        $product_grid->the_post();
                        wc_get_template(
                            'content-product.php',
                            array(
                                '_delay' => $_delay,
                                'wrapper' => 'li'
                            )
                        );
                        $_delay += $_delay_item;
                        $count++;
                    endwhile;
                    echo '</ul>';

                endif;
                ?>
            </div>
        </div>
    </div>
</div>
