<?php
$infinite_id = rand(1, 999999);
$class_ul = 'large-block-grid-' . ((int) $columns_number) . ' medium-block-grid-' . ((int) $columns_number_tablet) . ' small-block-grid-' . ((int) $columns_number_small);
?>
<div class="product_list_widget row">
    <div
        data-next-page="2"
        data-is-deals="0"
        data-layout="list"
        data-product-type="<?php echo $type; ?>"
        data-post-per-page="<?php echo $number; ?>"
        data-post-per-row="<?php echo $columns_number; ?>"
        data-post-per-row-medium="<?php echo $columns_number_tablet; ?>"
        data-post-per-row-small="<?php echo $columns_number_small; ?>"
        data-max-pages="<?php echo $loop->max_num_pages; ?>"
        data-cat="<?php echo esc_attr($cat); ?>"
        class="large-12 columns shortcode_<?php echo $infinite_id; ?>">
        <ul class="<?php echo $class_ul; ?> nasa-layout-wrap-content">
            <?php include NASA_CORE_PRODUCT_LAYOUTS . 'globals/list_layout.php'; ?>
        </ul>
    </div>
    
    <div class="large-12 columns text-center margin-top-20 margin-bottom-20">
        <?php if ($loop->max_num_pages > 1) :
            $style_viewmore = ' nasa-more-type-' . (isset($style_viewmore) ? $style_viewmore : '1');
            ?>
            <div class="load-more-btn load-more<?php echo esc_attr($style_viewmore); ?>" data-infinite="<?php echo $infinite_id; ?>" data-nodata="<?php esc_attr_e('ALL PRODUCTS LOADED', 'nasa-core'); ?>">
                <div class="load-more-content">
                    <span class="load-more-icon icon-nasa-refresh"></span>
                    <span class="load-more-text"><?php esc_html_e('LOAD MORE ...', 'nasa-core'); ?></span>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>