<?php

/**
 * Include and setup custom metaboxes and fields.
 *
 * @category nasa-core
 * @package  Metaboxes
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/webdevstudios/Custom-Metaboxes-and-Fields-for-WordPress
 */
add_filter('cmb_meta_boxes', 'nasa_metaboxes');

/**
 * Define the metabox and field configurations.
 *
 * @param  array $meta_boxes
 * @return array
 */
function nasa_metaboxes(array $meta_boxes) {
    // Start with an underscore to hide fields from custom fields list
    $prefix = '_nasa_';
    
    /* Get Footers style */
    $footers_option = nasa_get_footers_options();
    
    /* Get Headers custom */
    $headers_option = nasa_get_headers_options();
    
    /* Get header block */
    $header_blocks = nasa_get_header_blocks_options();
    
    $meta_boxes['nasa_metabox_general'] = array(
        'id' => 'nasa_metabox',
        'title' => esc_html__('General Page Options', 'nasa-core'),
        'pages' => array('page'), // Post type
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true, // Show field names on the left
        'fields' => array(
            array(
                'name' => esc_html__("Site Fullwidth", 'nasa-core'),
                'desc' => esc_html__('Site Fullwidth (max-width: 1870px).', 'nasa-core'),
                'id' => $prefix . 'site_fullwidth',
                'type' => 'select',
                'options' => array(
                    '' => esc_html__('Default', 'nasa-core'),
                    '1' => esc_html__('Yes', 'nasa-core'),
                    '-1' => esc_html__('No', 'nasa-core')
                ),
                'default' => ''
            ),
            array(
                'name' => esc_html__('Override Logo', 'nasa-core'),
                'desc' => esc_html__('Upload an image for override default logo.', 'nasa-core'),
                'id' => $prefix . 'custom_logo',
                'allow' => false,
                'type' => 'file',
            ),
            array(
                'name' => esc_html__('Override Retina Logo', 'nasa-core'),
                'desc' => esc_html__('Upload an image for override default retina logo.', 'nasa-core'),
                'id' => $prefix . 'custom_logo_retina',
                'allow' => false,
                'type' => 'file',
            ),
            array(
                'name' => esc_html__('Override Primary color.', 'nasa-core'),
                'desc' => esc_html__('Yes, please', 'nasa-core'),
                'id' => $prefix . 'pri_color_flag',
                'default' => '0',
                'type' => 'checkbox',
                'class' => 'nasa-override-pri-color-flag'
            ),
            
            array(
                'name' => esc_html__('Primary color', 'nasa-core'),
                'desc' => esc_html__('Primary color', 'nasa-core'),
                'id' => $prefix . 'pri_color',
                'type' => 'text',
                'default' => '#ffc501',
                'class' => 'hidden-tag nasa-option-color nasa-override-pri-color'
            )
        )
    );
    
    $meta_boxes['nasa_metabox_header'] = array(
        'id' => 'nasa_metabox_header',
        'title' => esc_html__('Header Page Options', 'nasa-core'),
        'pages' => array('page'), // Post type
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true, // Show field names on the left
        'fields' => array(
            array(
                'name' => esc_html__("Header Fullwidth", 'nasa-core'),
                'desc' => esc_html__('Header Fullwidth (max-width: 1870px).', 'nasa-core'),
                'id' => $prefix . 'header_fullwidth',
                'type' => 'select',
                'options' => array(
                    '' => esc_html__('Default', 'nasa-core'),
                    '1' => esc_html__('Yes', 'nasa-core'),
                    '-1' => esc_html__('No', 'nasa-core')
                ),
                'default' => ''
            ),
            
            array(
                'name' => esc_html__('Header Type', 'nasa-core'),
                'desc' => esc_html__('Description (optional)', 'nasa-core'),
                'id' => $prefix . 'custom_header',
                'type' => 'select',
                'options' => array(
                    '' => esc_html__('Default', 'nasa-core'),
                    '1' => esc_html__('Header Type 1', 'nasa-core'),
                    '2' => esc_html__('Header Type 2', 'nasa-core'),
                    '3' => esc_html__('Header Type 3', 'nasa-core'),
                    '4' => esc_html__('Header Type 4', 'nasa-core'),
                    '5' => esc_html__('Header Type 5', 'nasa-core'),
                    '6' => esc_html__('Header Type 6', 'nasa-core'),
                    'nasa-custom' => esc_html__('Header Builder', 'nasa-core')
                ),
                'default' => '',
                'class' => 'nasa-core-option-parent'
            ),
            
            array(
                'name' => esc_html__("Sticky", 'nasa-core'),
                'desc' => esc_html__('Header sticky (Not use for Header Builder).', 'nasa-core'),
                'id' => $prefix . 'fixed_nav',
                'type' => 'select',
                'options' => array(
                    '' => esc_html__('Default', 'nasa-core'),
                    '1' => esc_html__('Yes', 'nasa-core'),
                    '-1' => esc_html__('No', 'nasa-core')
                ),
                'default' => ''
            ),
            
            array(
                'name' => esc_html__('Header Builder', 'nasa-core'),
                'desc' => esc_html__('Header Builder.', 'nasa-core'),
                'id' => $prefix . 'header_builder',
                'type' => 'select',
                'options' => $headers_option,
                'default' => '',
                'class' => 'hidden-tag nasa-core-option-child core' . $prefix . 'custom_header core' . $prefix . 'custom_header-nasa-custom'
            ),
            
            array(
                'name' => esc_html__('Main menu fullwidth', 'nasa-core'),
                'desc' => esc_html__('Main menu fullwidth', 'nasa-core'),
                'id' => $prefix . 'fullwidth_main_menu',
                'type' => 'select',
                'options' => array(
                    '' => esc_html__('Default', 'nasa-core'),
                    '1' => esc_html__('Yes', 'nasa-core'),
                    '-1' => esc_html__('No', 'nasa-core')
                ),
                'default' => '',
                'class' => 'hidden-tag nasa-core-option-child core' . $prefix . 'custom_header core' . $prefix . 'custom_header-5 core' . $prefix . 'custom_header-6'
            ),
            
            array(
                "name" => esc_html__("Extra class name header", 'nasa-core'),
                'desc' => esc_html__('Custom add more class name for header page', 'nasa-core'),
                "id" => $prefix . "el_class_header",
                "default" => '',
                "type" => "text",
                'class' => 'hidden-tag nasa-core-option-child core' . $prefix . 'custom_header core' . $prefix . 'custom_header-4 core' . $prefix . 'custom_header-5 core' . $prefix . 'custom_header-6'
            ),
            
            array(
                'name' => esc_html__('Header transparent', 'nasa-core'),
                'desc' => esc_html__('Header transparent', 'nasa-core'),
                'id' => $prefix . 'header_transparent',
                'type' => 'select',
                'options' => array(
                    '' => esc_html__('Default', 'nasa-core'),
                    '1' => esc_html__('Yes', 'nasa-core'),
                    '-1' => esc_html__('No', 'nasa-core')
                ),
                'default' => '',
                'class' => 'hidden-tag nasa-core-option-child core' . $prefix . 'custom_header core' . $prefix . 'custom_header-1 core' . $prefix . 'custom_header-2 core' . $prefix . 'custom_header-3 core' . $prefix . 'custom_header-4 core' . $prefix . 'custom_header-5 core' . $prefix . 'custom_header-6'
            ),
            
            array(
                'name' => esc_html__('Block Header', 'nasa-core'),
                'desc' => esc_html__('Add static block to Header', 'nasa-core'),
                'id' => $prefix . 'header_block',
                'type' => 'select',
                'options' => $header_blocks,
                'default' => '',
                'class' => 'hidden-tag nasa-core-option-child core' . $prefix . 'custom_header core' . $prefix . 'custom_header-1 core' . $prefix . 'custom_header-2 core' . $prefix . 'custom_header-3 core' . $prefix . 'custom_header-4 core' . $prefix . 'custom_header-5 core' . $prefix . 'custom_header-6'
            ),
            
            array(
                'name' => esc_html__('Toggle Top Bar', 'nasa-core'),
                'desc' => esc_html__('Toggle bar page', 'nasa-core'),
                'id' => $prefix . 'topbar_toggle',
                'type' => 'select',
                'options' => array(
                    '' => esc_html__('Default', 'nasa-core'),
                    '1' => esc_html__('Yes', 'nasa-core'),
                    '2' => esc_html__('No', 'nasa-core')
                ),
                'default' => '',
                'class' => 'nasa-core-option-parent'
            ),
            
            array(
                'name' => esc_html__('Init show Top Bar', 'nasa-core'),
                'desc' => esc_html__('Default init show Top Bar in page', 'nasa-core'),
                'id' => $prefix . 'topbar_default_show',
                'type' => 'select',
                'options' => array(
                    '' => esc_html__('Default', 'nasa-core'),
                    '1' => esc_html__('Yes', 'nasa-core'),
                    '2' => esc_html__('No', 'nasa-core')
                ),
                'default' => '',
                'class' => 'hidden-tag nasa-core-option-child core' . $prefix . 'topbar_toggle core' . $prefix . 'topbar_toggle-1'
            ),
            
            array(
                'name' => esc_html__('Header Background', 'nasa-core'),
                'desc' => esc_html__('Header Background', 'nasa-core'),
                'id' => $prefix . 'bg_color_header',
                'type' => 'text',
                'default' => '',
                'class' => 'nasa-option-color hidden-tag nasa-core-option-child core' . $prefix . 'custom_header core' . $prefix . 'custom_header-1 core' . $prefix . 'custom_header-2 core' . $prefix . 'custom_header-3 core' . $prefix . 'custom_header-4 core' . $prefix . 'custom_header-5 core' . $prefix . 'custom_header-6'
            ),
            
            array(
                'name' => esc_html__('Header Text color', 'nasa-core'),
                'desc' => esc_html__('Override Text color items in header', 'nasa-core'),
                'id' => $prefix . 'text_color_header',
                'type' => 'text',
                'default' => '',
                'class' => 'nasa-option-color hidden-tag nasa-core-option-child core' . $prefix . 'custom_header core' . $prefix . 'custom_header-1 core' . $prefix . 'custom_header-2 core' . $prefix . 'custom_header-3 core' . $prefix . 'custom_header-4 core' . $prefix . 'custom_header-5 core' . $prefix . 'custom_header-6'
            ),
            
            array(
                'name' => esc_html__('Header Text color hover', 'nasa-core'),
                'desc' => esc_html__('Override Text color hover items in header', 'nasa-core'),
                'id' => $prefix . 'text_color_hover_header',
                'type' => 'text',
                'default' => '',
                'class' => 'nasa-option-color hidden-tag nasa-core-option-child core' . $prefix . 'custom_header core' . $prefix . 'custom_header-1 core' . $prefix . 'custom_header-2 core' . $prefix . 'custom_header-3 core' . $prefix . 'custom_header-4 core' . $prefix . 'custom_header-5 core' . $prefix . 'custom_header-6'
            ),
            
            array(
                'name' => esc_html__('Top bar Background', 'nasa-core'),
                'desc' => esc_html__('Top bar Background', 'nasa-core'),
                'id' => $prefix . 'bg_color_topbar',
                'type' => 'text',
                'default' => '',
                'class' => 'nasa-option-color'
            ),
            
            array(
                'name' => esc_html__('Top bar Text color', 'nasa-core'),
                'desc' => esc_html__('Override Text color items in Top bar', 'nasa-core'),
                'id' => $prefix . 'text_color_topbar',
                'type' => 'text',
                'default' => '',
                'class' => 'nasa-option-color'
            ),
            
            array(
                'name' => esc_html__('Top bar Text color hover', 'nasa-core'),
                'desc' => esc_html__('Override Text color hover items in Top bar', 'nasa-core'),
                'id' => $prefix . 'text_color_hover_topbar',
                'type' => 'text',
                'default' => '',
                'class' => 'nasa-option-color'
            ),
            
            array(
                'name' => esc_html__('Background Main menu', 'nasa-core'),
                'desc' => esc_html__('Override background color for Main menu (Only use header type 2)', 'nasa-core'),
                'id' => $prefix . 'bg_color_main_menu',
                'type' => 'text',
                'default' => '',
                'class' => 'nasa-option-color hidden-tag nasa-core-option-child core' . $prefix . 'custom_header core' . $prefix . 'custom_header-5 core' . $prefix . 'custom_header-6'
            ),
            
            array(
                'name' => esc_html__('Main menu Text color', 'nasa-core'),
                'desc' => esc_html__('Override text color for Main menu', 'nasa-core'),
                'id' => $prefix . 'text_color_main_menu',
                'type' => 'text',
                'default' => '',
                'class' => 'nasa-option-color hidden-tag nasa-core-option-child core' . $prefix . 'custom_header core' . $prefix . 'custom_header-1 core' . $prefix . 'custom_header-2 core' . $prefix . 'custom_header-3 core' . $prefix . 'custom_header-4 core' . $prefix . 'custom_header-5 core' . $prefix . 'custom_header-6'
            )
        )
    );
    
    $meta_boxes['nasa_metabox_breadcrumb'] = array(
        'id' => 'nasa_metabox_breadcrumb',
        'title' => esc_html__('Breadcrumb Page Options', 'nasa-core'),
        'pages' => array('page'), // Post type
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true, // Show field names on the left
        'fields' => array(
            array(
                'name' => esc_html__('Show Breadcrumb', 'nasa-core'),
                'desc' => esc_html__('Yes, please', 'nasa-core'),
                'id' => $prefix . 'show_breadcrumb',
                'default' => '0',
                'type' => 'checkbox',
                'class' => 'nasa-breadcrumb-flag'
            ),
            
            array(
                'name' => esc_html__('Type', 'nasa-core'),
                'desc' => esc_html__('Type', 'nasa-core'),
                'id' => $prefix . 'type_breadcrumb',
                'type' => 'select',
                'options' => array(
                    '' => esc_html__('Default', 'nasa-core'),
                    '1' => esc_html__('Has breadcrumb background', 'nasa-core')
                ),
                'default' => '',
                'class' => 'hidden-tag nasa-breadcrumb-type'
            ),
            
            array(
                'name' => esc_html__('Override background', 'nasa-core'),
                'desc' => esc_html__('Override Background', 'nasa-core'),
                'id' => $prefix . 'bg_breadcrumb',
                'allow' => false,
                'type' => 'file',
                'class' => 'hidden-tag nasa-breadcrumb-bg'
            ),
            
            array(
                'name' => esc_html__('Background color', 'nasa-core'),
                'desc' => esc_html__('Background color', 'nasa-core'),
                'id' => $prefix . 'bg_color_breadcrumb',
                'type' => 'text',
                'default' => '',
                'class' => 'hidden-tag nasa-breadcrumb-bg-color'
            ),
            
            array(
                'name' => esc_html__('Height', 'nasa-core'),
                'desc' => esc_html__('Height (Pixel)', 'nasa-core'),
                'id' => $prefix . 'height_breadcrumb',
                'type' => 'text',
                'default' => '',
                'class' => 'hidden-tag nasa-breadcrumb-height'
            ),
            
            array(
                'name' => esc_html__('Breadcrumb text color', 'nasa-core'),
                'desc' => esc_html__('Text color', 'nasa-core'),
                'id' => $prefix . 'color_breadcrumb',
                'type' => 'text',
                'default' => '',
                'class' => 'hidden-tag nasa-breadcrumb-color'
            )
        )
    );
    
    $meta_boxes['nasa_metabox_footer'] = array(
        'id' => 'nasa_metabox_footer',
        'title' => esc_html__('Footer Page Options', 'nasa-core'),
        'pages' => array('page'), // Post type
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true, // Show field names on the left
        'fields' => array(
            array(
                'name' => esc_html__('Type', 'nasa-core'),
                'desc' => esc_html__('Select Type', 'nasa-core'),
                'id' => $prefix . 'custom_footer',
                'type' => 'select',
                'options' => $footers_option,
                'default' => ''
            ),
            
            array(
                'name' => esc_html__('Footer Mobile', 'nasa-core'),
                'desc' => esc_html__('Description (optional)', 'nasa-core'),
                'id' => $prefix . 'custom_footer_mobile',
                'type' => 'select',
                'options' => $footers_option,
                'default' => ''
            ),
            
            array(
                'name' => esc_html__("Fullwidth", 'nasa-core'),
                'desc' => esc_html__('(max-width: 1870px).', 'nasa-core'),
                'id' => $prefix . 'footer_fullwidth',
                'type' => 'select',
                'options' => array(
                    '' => esc_html__('Default', 'nasa-core'),
                    '1' => esc_html__('Yes', 'nasa-core'),
                    '-1' => esc_html__('No', 'nasa-core')
                ),
                'default' => ''
            )
        )
    );

    return $meta_boxes;
}

/**
 * Initialize the meta box class.
 */
add_action('init', 'nasa_init_cmb_meta_boxes');
function nasa_init_cmb_meta_boxes() {
    if (!class_exists('cmb_Meta_Box')){
        require_once NASA_CORE_PLUGIN_PATH . 'admin/metabox/init.php';
    }
}
