<?php
/**
 *
 * The template for displaying product content within loops
 *
 * 
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.6.0
 */
global $product, $nasa_opt, $nasa_animated_products, $nasa_type_grid;
if (empty($product) || !$product->is_visible()) :
    return;
endif;

$productId = $product->get_id();

$time_from = get_post_meta($productId, '_sale_price_dates_from', true);
$time_to = get_post_meta($productId, '_sale_price_dates_to', true);
$time_sale = ((int) $time_to < NASA_TIME_NOW || (int) $time_from > NASA_TIME_NOW) ? false : (int) $time_to;

$class_wrap = 'product-item grid';
if (!isset($nasa_opt['nasa_in_mobile']) || !$nasa_opt['nasa_in_mobile']) {
    $class_wrap .= ' wow fadeInUp';
}

$class_wrap .= $nasa_animated_products ? ' ' . $nasa_animated_products : '';

$stock_status = $product->get_stock_status();
$class_wrap .= $stock_status == "outofstock" ? ' out-of-stock' : '';
$stock_label = $stock_status == 'outofstock' ? esc_html__('Out of stock', 'zella-theme') : esc_html__('In stock', 'zella-theme');

$class_wrap .= $nasa_type_grid;

if(!isset($_delay)) {
    $_delay = '0';
}

echo (!isset($wrapper) || $wrapper == 'li') ? '<li class="product-warp-item">' : '';
echo '<div class="' . esc_attr($class_wrap) . '" data-wow-duration="1s" data-wow-delay="' . esc_attr($_delay) . 'ms" data-wow="fadeInUp">';

do_action('woocommerce_before_shop_loop_item');
?>
<div class="inner-wrap<?php echo esc_attr($time_sale ? ' product-deals' : ''); ?>">
    <div class="product-outner">
        <div class="product-inner">
            <div class="product-img-wrap">
                <div class="product-img-wrap-inner">
                    <?php do_action('woocommerce_before_shop_loop_item_title'); ?>
                </div>
            </div>
            
            <div class="product-info-wrap">
                <div class="info">
                    <?php do_action('woocommerce_shop_loop_item_title'); ?>
                    <?php do_action('woocommerce_after_shop_loop_item_title'); ?>
                </div>
            </div>
            
            <?php if (!isset($nasa_opt['nasa_in_mobile']) || !$nasa_opt['nasa_in_mobile']) : ?>
                <!-- Clone Group buttons for layout List -->
                <div class="hidden-tag nasa-list-stock-wrap">
                    <p class="nasa-list-stock-status <?php echo esc_attr($stock_status); ?>">
                        <?php echo esc_html__('AVAILABILITY: ', 'zella-theme') . '<span>' . $stock_label . '</span>'; ?>
                    </p>
                </div>
                <div class="group-btn-in-list-wrap hidden-tag">
                    <div class="group-btn-in-list"></div>
                </div>
            <?php endif; ?>
            <?php echo $time_sale ? zella_time_sale($time_sale) : '<div class="nasa-sc-pdeal-countdown hidden-tag"></div>'; ?>
        </div>
    </div>
</div>
<?php

do_action('woocommerce_after_shop_loop_item');
echo '</div>';
echo (!isset($wrapper) || $wrapper == 'li') ? '</li>' : '';
