<?php
/* Check if WooCommerce is active */
defined('NASA_WOO_ACTIVED') or define('NASA_WOO_ACTIVED', (bool) class_exists('WooCommerce'));

defined('NASA_WISHLIST_ENABLE') or define('NASA_WISHLIST_ENABLE', (bool) defined('YITH_WCWL'));

$wishlist_loop = NASA_WISHLIST_ENABLE ? true : false;
$wishlist_new = false;
if (NASA_WISHLIST_ENABLE && defined('YITH_WCWL_VERSION')) {
    if (version_compare(YITH_WCWL_VERSION, '3.0', ">=")) {
        $wishlist_loop = get_option('yith_wcwl_show_on_loop') !== 'yes' ? false : true;
        $wishlist_new = true;
    }
}
define('NASA_WISHLIST_NEW_VER', $wishlist_new);
define('NASA_WISHLIST_IN_LIST', $wishlist_loop);

/* Check if nasa-core is active */
defined('NASA_CORE_ACTIVED') or define('NASA_CORE_ACTIVED', false);
defined('NASA_CORE_IN_ADMIN') or define('NASA_CORE_IN_ADMIN', is_admin());

/* user info */
defined('NASA_CORE_USER_LOGIGED') or define('NASA_CORE_USER_LOGIGED', is_user_logged_in());

/* bundle type product */
defined('NASA_COMBO_TYPE') or define('NASA_COMBO_TYPE', 'yith_bundle');

/* Nasa theme prefix use for nasa-core */
defined('NASA_THEME_PREFIX') or define('NASA_THEME_PREFIX', 'zella');

/* Time now */
defined('NASA_TIME_NOW') or define('NASA_TIME_NOW', time());

/* Max-width */
defined('NASA_MAXWIDTH') or define('NASA_MAXWIDTH', '1870');
defined('NASA_PADDING_ROW') or define('NASA_PADDING_ROW', '50px');
defined('NASA_PADDING_COLUMN') or define('NASA_PADDING_COLUMN', '60px');

/**
 * nasa_upload_dir
 */
if (!isset($nasa_upload_dir)) {
    $nasa_upload_dir = wp_upload_dir();
}

/**
 * Cache plugin support
 */
function zella_plugins_cache_support() {
    /**
     * Check WP Super Cache active
     */
    global $super_cache_enabled;
    $super_cache_enabled = isset($super_cache_enabled) ? $super_cache_enabled : false;

    $plugin_cache_support = (
        /**
         * Check W3 Total Cache active
         */
        (defined('W3TC') && W3TC) ||

        /**
         * Check WP Fastest Cache
         */
        class_exists('WpFastestCache') ||

        /**
         * Check WP Super Cache active
         */
        (defined('WP_CACHE') && WP_CACHE && $super_cache_enabled) ||

        /**
         * Check AutoptimizeCache active
         */
        class_exists('autoptimizeCache') ||

        /**
         * Check WP_ROCKET active
         */
        (defined('WP_ROCKET_SLUG') && WP_ROCKET_SLUG) ||

        /**
         * Check SG_CachePress
         */
        class_exists('SG_CachePress') ||

        /**
         * Check LiteSpeed Cache
         */
        class_exists('LiteSpeed_Cache')
    );

    return apply_filters('zella_plugins_cache_support', $plugin_cache_support);
}

// Init $nasa_opt
$GLOBALS['nasa_opt'] = zella_options();
function zella_options() {
    $options = get_theme_mods();

    if(!empty($options)) {
        foreach ($options as $key => $value) {
            if (is_string($value)) {
                $options[$key] = str_replace(
                    array(
                        '[site_url]', 
                        '[site_url_secure]',
                    ),
                    array(
                        site_url('', 'http'),
                        site_url('', 'https'),
                    ),
                    $value
                );
            }
        }
    }

    /**
     * Check WP Super Cache active
     */
    global $super_cache_enabled;
    $super_cache_enabled = isset($super_cache_enabled) ? $super_cache_enabled : false;

    if(!defined('NASA_PLG_CACHE_ACTIVE') && zella_plugins_cache_support()) {
        define('NASA_PLG_CACHE_ACTIVE', true);
    }

    if(defined('NASA_PLG_CACHE_ACTIVE') && NASA_PLG_CACHE_ACTIVE) {
        /**
         * Disable optimized speed
         */
        $options['enable_optimized_speed'] = '0';
    }
    
    /**
     * Check Mobile Detect
     */
    $options['nasa_in_mobile'] = false;
    if (defined('NASA_IS_PHONE') && NASA_IS_PHONE && (!isset($options['enable_nasa_mobile']) || $options['enable_nasa_mobile'])) {
        $options['nasa_in_mobile'] = true;
        
        $options['showing_info_top'] = false;
        $options['enable_change_view'] = false;
        $options['breadcrumb_row'] = 'single';
    }

    return apply_filters('nasa_theme_options', $options);
}

function zella_init_global() {
    global $nasa_opt;
    
    $hoverProductEffect = array('hover-fade', 'hover-zoom', 'hover-flip', 'hover-bottom-to-top', 'hover-top-to-bottom', 'hover-left-to-right', 'hover-right-to-left', 'no');
    
    /**
     * Animated effect
     */
    $nasa_animated_products = 
        isset($_REQUEST['effect-product']) && in_array(
            $_REQUEST['effect-product'],
            $hoverProductEffect
        ) ? $_REQUEST['effect-product'] :
        (isset($nasa_opt['animated_products']) ? $nasa_opt['animated_products'] : '');
    
    if($nasa_animated_products == 'no') {
        $nasa_animated_products = '';
    }
    
    $GLOBALS['nasa_animated_products'] = $nasa_animated_products;
    
    /**
     * Type style content product grid
     */
    if (isset($_REQUEST['style-product']) && in_array((int) $_REQUEST['style-product'], array('1', '2'))) {
        $GLOBALS['nasa_type_grid'] = ' nasa-type-' . (int) $_REQUEST['style-product'];
    } else {
        $GLOBALS['nasa_type_grid'] = !isset($nasa_opt['style_product']) ? ' nasa-type-1' : ' nasa-type-' . (int) $nasa_opt['style_product'];
    }
    
    /**
     * $loadmoreStyle 
     */
    $GLOBALS['loadmoreStyle'] = array('infinite', 'load-more');
}

zella_init_global();

/**
 * Convert css content
 * 
 * @param type $css
 * @return type
 */
function zella_convert_css($css) {
    $css = strip_tags($css);
    $css = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $css);
    $css = str_replace(': ', ':', $css);
    $css = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css);

    return $css;
}

/**
 * @param string
 * Rerurn string
 */
function zella_str($string) {
    return trim($string);
}

/* wp-admin loading $nasa-opt =============== */
if(NASA_CORE_IN_ADMIN){
    require_once ZELLA_THEME_PATH . '/admin/index.php';
}

/**
 * Register Google font
 */
require_once ZELLA_THEME_PATH . '/includes/nasa-google-fonts.php';

/*
 * Includes Woocommerce widgets custom
 */
require_once ZELLA_THEME_PATH . '/widgets/wg-nasa-recent-posts.php';
require_once ZELLA_THEME_PATH . '/widgets/wg-nasa-product-categories.php';
require_once ZELLA_THEME_PATH . '/widgets/wg-nasa-product-brands.php';
require_once ZELLA_THEME_PATH . '/widgets/wg-nasa-product-filter-price.php';
require_once ZELLA_THEME_PATH . '/widgets/wg-nasa-product-filter-price-list.php';
require_once ZELLA_THEME_PATH . '/widgets/wg-nasa-product-filter-variations.php';
require_once ZELLA_THEME_PATH . '/widgets/wg-nasa-tag-cloud.php';
require_once ZELLA_THEME_PATH . '/widgets/wg-nasa-reset-filter.php';
