<?php
if (!function_exists('zella_blog_heading')) {
    add_action('init', 'zella_blog_heading');
    function zella_blog_heading() {
        /* ======================================================================= */
        /* The Options Array */
        /* ======================================================================= */
        global $of_options;
        if(empty($of_options)) {
            $of_options = array();
        }
        
        $of_options[] = array(
            "name" => esc_html__("Blog", 'zella-theme'),
            "target" => 'blog',
            "type" => "heading"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Single Blog layout", 'zella-theme'),
            "id" => "single_blog_layout",
            "std" => "left",
            "type" => "select",
            "options" => array(
                "left" => esc_html__("Left sidebar", 'zella-theme'),
                "right" => esc_html__("Right sidebar", 'zella-theme'),
                "no" => esc_html__("No sidebar (Centered)", 'zella-theme')
            )
        );

        $of_options[] = array(
            "name" => esc_html__("Blog layout", 'zella-theme'),
            "id" => "blog_layout",
            "std" => "left",
            "type" => "select",
            "options" => array(
                "left" => esc_html__("Left sidebar", 'zella-theme'),
                "right" => esc_html__("Right sidebar", 'zella-theme'),
                "no" => esc_html__("No sidebar (Centered)", 'zella-theme')
            )
        );

        $of_options[] = array(
            "name" => esc_html__("Blog style", 'zella-theme'),
            "id" => "blog_type",
            "std" => "blog-standard",
            "type" => "select",
            "options" => array(
                "masonry-isotope" => esc_html__("Masonry isotope", 'zella-theme'),
                "blog-grid" => esc_html__("Grid", 'zella-theme'),
                "blog-standard" => esc_html__("Standard", 'zella-theme'),
                "blog-list" => esc_html__("List", 'zella-theme')
            )
        );
        
        /* ======================================================================= */
        
        $of_options[] = array(
            "name" => esc_html__("Masonry isotope - Grid - Blog style", 'zella-theme'),
            "std" => "<h4>" . esc_html__("Masonry isotope - Grid - Blog style", 'zella-theme') . "</h4>",
            "type" => "info"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Columns in desktop", 'zella-theme'),
            "id" => "masonry_blogs_columns_desk",
            "std" => "3-cols",
            "type" => "select",
            "options" => array(
                "2-cols" => esc_html__("2 columns", 'zella-theme'),
                "3-cols" => esc_html__("3 columns", 'zella-theme'),
                "4-cols" => esc_html__("4 columns", 'zella-theme'),
                "5-cols" => esc_html__("5 columns", 'zella-theme')
            )
        );
        
        $of_options[] = array(
            "name" => esc_html__("Columns in mobile", 'zella-theme'),
            "id" => "masonry_blogs_columns_small",
            "std" => "1-col",
            "type" => "select",
            "options" => array(
                "1-cols" => esc_html__("1 column", 'zella-theme'),
                "2-cols" => esc_html__("2 columns", 'zella-theme')
            )
        );
        
        $of_options[] = array(
            "name" => esc_html__("Columns in Tablet", 'zella-theme'),
            "id" => "masonry_blogs_columns_tablet",
            "std" => "2-cols",
            "type" => "select",
            "options" => array(
                "1-col" => esc_html__("1 column", 'zella-theme'),
                "2-cols" => esc_html__("2 columns", 'zella-theme'),
                "3-cols" => esc_html__("3 columns", 'zella-theme')
            )
        );
        
        /* ======================================================================= */
        
        $of_options[] = array(
            "name" => esc_html__("Standard - Blog style", 'zella-theme'),
            "std" => "<h4>" . esc_html__("Standard - Blog style", 'zella-theme') . "</h4>",
            "type" => "info"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Parallax effect", 'zella-theme'),
            "id" => "blog_parallax",
            "std" => 0,
            "type" => "switch"
        );
        
        /* ======================================================================= */
        
        $of_options[] = array(
            "name" => esc_html__("Meta Info - Blog style", 'zella-theme'),
            "std" => "<h4>" . esc_html__("Meta Info - Blog style", 'zella-theme') . "</h4>",
            "type" => "info"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Show author info", 'zella-theme'),
            "id" => "show_author_info",
            "std" => 1,
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Show datetime info", 'zella-theme'),
            "id" => "show_date_info",
            "std" => 1,
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Show Categories info", 'zella-theme'),
            "id" => "show_cat_info",
            "std" => 0,
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Show Tags info", 'zella-theme'),
            "id" => "show_tag_info",
            "std" => 0,
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Show Readmore blog", 'zella-theme'),
            "id" => "show_readmore_blog",
            "std" => 1,
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Show Short description (Only use for Blog Grid layout)", 'zella-theme'),
            "id" => "show_desc_blog",
            "std" => 1,
            "type" => "switch"
        );
        
        /* ======================================================================= */
        
        $of_options[] = array(
            "name" => esc_html__("Single Blog page", 'zella-theme'),
            "std" => "<h4>" . esc_html__("Single Blog page", 'zella-theme') . "</h4>",
            "type" => "info"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Show Related post", 'zella-theme'),
            "id" => "relate_blogs",
            "std" => 1,
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Number for relate blog", 'zella-theme'),
            "id" => "relate_blogs_number",
            "std" => "10",
            "type" => "text"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Columns Relate in desktop", 'zella-theme'),
            "id" => "relate_blogs_columns_desk",
            "std" => "3-cols",
            "type" => "select",
            "options" => array(
                "3-cols" => esc_html__("3 columns", 'zella-theme'),
                "4-cols" => esc_html__("4 columns", 'zella-theme'),
                "5-cols" => esc_html__("5 columns", 'zella-theme')
            )
        );
        
        $of_options[] = array(
            "name" => esc_html__("Columns Relate in mobile", 'zella-theme'),
            "id" => "relate_blogs_columns_small",
            "std" => "1-col",
            "type" => "select",
            "options" => array(
                "1-cols" => esc_html__("1 column", 'zella-theme'),
                "2-cols" => esc_html__("2 columns", 'zella-theme')
            )
        );
        
        $of_options[] = array(
            "name" => esc_html__("Columns Relate in Tablet", 'zella-theme'),
            "id" => "relate_blogs_columns_tablet",
            "std" => "2-cols",
            "type" => "select",
            "options" => array(
                "1-col" => esc_html__("1 column", 'zella-theme'),
                "2-cols" => esc_html__("2 columns", 'zella-theme'),
                "3-cols" => esc_html__("3 columns", 'zella-theme')
            )
        );
    }
}
