<?php
/**
 * Mini-cart
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.7.0
 */
if (!defined('ABSPATH')) {
    exit;
}

do_action('woocommerce_before_mini_cart');
?>

<?php if (!WC()->cart->is_empty()) : ?>
    <div class="nasa-cart-list-wrap rtl-right">
        <div class="woocommerce-mini-cart cart_list product_list_widget nasa-cart-wishlist-slider owl-carousel <?php echo esc_attr($args['list_class']); ?>" data-columns-max="6">

            <?php
            do_action('woocommerce_before_mini_cart_contents');

            foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
                $_product = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
                $product_id = apply_filters('woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key);

                if ($_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key)) {
                    $product_name = apply_filters('woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key);
                    $thumbnail = apply_filters('woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key);
                    $product_price = apply_filters('woocommerce_cart_item_price', WC()->cart->get_product_price($_product), $cart_item, $cart_item_key);
                    $product_permalink = apply_filters('woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink($cart_item) : '', $cart_item, $cart_item_key);
                    ?>
                    <div class="row mini-cart-item woocommerce-mini-cart-item collapse <?php echo esc_attr(apply_filters('woocommerce_mini_cart_item_class', 'mini_cart_item', $cart_item, $cart_item_key)); ?>" id="item-<?php echo (int) $product_id; ?>">
                        <div class="small-3 large-3 columns nasa-image-cart-item">
                            <?php echo $thumbnail; ?>
                        </div>

                        <div class="small-7 large-8 columns nasa-info-cart-item">
                            <div class="mini-cart-info">
                                <?php if (empty($product_permalink)) : ?>
                                    <?php echo $product_name; ?>
                                <?php else : ?>
                                    <a href="<?php echo esc_url($product_permalink); ?>">
                                        <?php echo $product_name; ?>
                                    </a>
                                <?php endif; ?>

                                <?php echo wc_get_formatted_cart_item_data($cart_item); ?>
                                <?php echo apply_filters('woocommerce_widget_cart_item_quantity', '<div class="cart_list_product_quantity">' . sprintf('%s &times; %s', $cart_item['quantity'], $product_price) . '</div>', $cart_item, $cart_item_key); ?>
                            </div>
                        </div>

                        <div class="small-2 large-1 columns text-right nasa-remove-cart-item">
                            <?php
                            echo apply_filters('woocommerce_cart_item_remove_link', sprintf(
                                    '<a href="%s" class="remove remove_from_cart_button item-in-cart" aria-label="%s" data-product_id="%s" data-cart_item_key="%s" data-product_sku="%s"><i class="pe-7s-close"></i></a>',
                                    esc_url(wc_get_cart_remove_url($cart_item_key)),
                                    esc_attr__('Remove this item', 'zella-theme'),
                                    esc_attr($product_id ),
                                    esc_attr($cart_item_key ),
                                    esc_attr($_product->get_sku())
                                ), $cart_item_key);
                            ?>
                        </div>
                    </div>
                <?php
                }
            }

            do_action('woocommerce_mini_cart_contents');
            ?>
        </div>
    </div>

    <div class="nasa-checkout-wrap">
        <div class="minicart_total_checkout">
            <span class="total-price-label"><?php esc_html_e('Subtotal', 'zella-theme'); ?></span>
            <span class="total-price right"><?php wc_cart_totals_subtotal_html(); ?></span>
        </div>

        <div class="btn-mini-cart inline-lists text-center">
            <a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="button small btn-viewcart" title="<?php esc_attr_e('VIEW CART', 'zella-theme'); ?>"><?php esc_html_e('VIEW CART', 'zella-theme'); ?></a>
            <a href="<?php echo esc_url(wc_get_checkout_url()); ?>" class="button small btn-checkout" title="<?php esc_attr_e('CHECKOUT', 'zella-theme'); ?>"><?php esc_html_e('CHECKOUT', 'zella-theme'); ?></a>
        </div>
    </div>

<?php
/**
 * Empty cart
 */
else :
    
    echo '<p class="empty woocommerce-mini-cart__empty-message"><i class="nasa-empty-icon icon-nasa-cart-2"></i>' . esc_html__('No products in the cart.', 'zella-theme') . '<a href="javascript:void(0);" class="button small nasa-sidebar-return-shop">' . esc_html__('RETURN TO SHOP', 'zella-theme') . '</a></p>';

endif;

do_action('woocommerce_after_mini_cart');
