<?php
/**
 * Wishlist page template
 *
 * @author Your Inspiration Themes
 * @package YITH WooCommerce Wishlist
 */
if (!defined('YITH_WCWL_PREMIUM')) {
    global $woocommerce, $nasa_opt;
    ?>
    <?php /* div id="yith-wcwl-messages"></div */?>
    <form id="yith-wcwl-form" action="<?php echo esc_url(YITH_WCWL()->get_wishlist_url('view' . ($wishlist_meta['is_default'] != 1 ? '/' . $wishlist_meta['wishlist_token'] : ''))); ?>" method="post">
        <?php do_action('yith_wcwl_before_wishlist'); ?>
        <!-- WISHLIST TABLE -->
        <div class="shop_table cart wishlist_table" data-pagination="<?php echo esc_attr($pagination); ?>" data-per-page="<?php echo esc_attr($per_page); ?>" data-page="<?php echo esc_attr($current_page); ?>" data-id="<?php echo esc_attr($wishlist_meta['ID']); ?>">
            <?php if (count($wishlist_items) > 0) : ?>
                <div class="nasa-tbody nasa-cart-wishlist-slider owl-carousel" data-columns-max="8">
                    <?php
                    foreach ($wishlist_items as $item) :
                        global $product;
                        $product = wc_get_product($item['prod_id']);

                        if ($product !== false && $product->exists()) :
                            $productId = $product->get_id();
                            ?>
                            <div class="nasa-tr-wishlist-item" id="yith-wcwl-row-<?php echo (int) $productId; ?>" data-row-id="<?php echo (int) $productId; ?>">
                                <div class="product-wishlist-info">
                                    <div class="wishlist-item-warper nasa-relative">
                                        <div class="row wishlist-item">
                                            <div class="image-wishlist large-4 small-4 columns padding-left-0">
                                                <a href="<?php echo esc_url(get_permalink(apply_filters('woocommerce_in_cart_product', $productId))); ?>">
                <?php echo zella_str($product->get_image('thumbnail')); ?>
                                                </a>
                                            </div>

                                            <div class="info-wishlist large-8 small-8 columns padding-right-0">
                                                <div class="row">
                                                    <div class="large-12 columns nasa-wishlist-title">
                                                        <a href="<?php echo esc_url(get_permalink(apply_filters('woocommerce_in_cart_product', $productId))); ?>">
                <?php echo apply_filters('woocommerce_in_cartproduct_obj_title', $product->get_name(), $product); ?>
                                                        </a>
                                                    </div>

                                                    <div class="wishlist-price large-12 columns">
                                                            <?php if ($show_price) : ?>
                                                            <span class="price">
                                                            <?php echo zella_str($product->get_price_html()); ?>
                                                            </span>
                                                            <?php
                                                        endif;

                                                        if ($show_stock_status) :

                                                            $availability = $product->get_availability();
                                                            $stock_status = $availability['class'];

                                                            if ($stock_status == 'out-of-stock') :
                                                                $stock_status = "Out";
                                                                echo '<span class="wishlist-out-of-stock">' . esc_html__(' - Out of Stock', 'zella-theme') . '</span>';
                                                            else :
                                                                $stock_status = "In";
                                                                echo '<span class="wishlist-in-stock">' . esc_html__(' - In Stock', 'zella-theme') . '</span>';
                                                            endif;

                                                        endif;
                                                        ?>
                                                    </div>

                                                        <?php if (!isset($nasa_opt['disable-cart']) || !$nasa_opt['disable-cart']) : ?>
                                                        <div class="add-to-cart-wishlist large-12 columns">
                                                            <?php
                                                            if ($show_add_to_cart && isset($stock_status) && $stock_status != 'Out'):
                                                                echo zella_add_to_cart_in_wishlist();
                                                            endif;
                                                            ?>
                                                            <div class="quick-view nasa-view-from-wishlist hidden-tag" data-prod="<?php echo (int) $productId; ?>" data-tip="<?php echo esc_attr__('Quick View', 'zella-theme'); ?>" title="<?php echo esc_attr__('Quick View', 'zella-theme'); ?>" data-from_wishlist="1">
                                                                <div class="btn-link">
                                                                    <div class="quick-view-icon">
                                                                        <span class="nasa-icon-text">
                                                                            <i class="pe-icon pe-7s-look"></i>
                                                                        </span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                <?php if ($is_user_owner) : ?>
                                    <div class="product-remove">
                                        <div>
                                            <a href="javascrip:void(0);" class="remove nasa-remove_from_wishlist" title="<?php echo esc_attr__('Remove this product', 'zella-theme'); ?>" data-logined="<?php echo (int) NASA_CORE_USER_LOGIGED; ?>" data-prod_id="<?php echo (int) $productId ?>"><i class="pe-7s-close"></i></a>
                                        </div>
                                    </div>
                            <?php endif; ?>
                            </div>
                    <?php endif;
                endforeach;
                ?>
                </div>
    <?php else: ?>
                <div class="pagination-row">
                    <div class="wishlist-empty">
                        <p class="empty">
                            <i class="nasa-empty-icon icon-nasa-like"></i>
                            <?php esc_html_e('No products were added to the wishlist.', 'zella-theme') ?>
                            <a href="javascript:void(0);" class="button small nasa-sidebar-return-shop">
                                <?php echo esc_html__('RETURN TO SHOP', 'zella-theme'); ?>
                            </a>
                        </p>
                    </div>
                </div>
            <?php
            endif;

            echo!empty($page_links) ? '<div>' . $page_links . '</div>' : '';
            ?>

        </div>

        <?php wp_nonce_field('yith_wcwl_edit_wishlist_action', 'yith_wcwl_edit_wishlist'); ?>

        <?php if ($wishlist_meta['is_default'] != 1) : ?>
            <input type="hidden" value="<?php echo esc_attr($wishlist_meta['wishlist_token']); ?>" name="wishlist_id" id="wishlist_id" />
    <?php endif; ?>

    <?php do_action('yith_wcwl_after_wishlist'); ?>
    </form>

    <?php
} else {
    if (function_exists('yith_wcwl_get_template')) {
        echo '<div class="nasa_yith_wishlist_premium-wrap">';
        echo '<div id="yith-wcwl-messages"></div>';
        yith_wcwl_get_template('wishlist-' . $template_part . '.php', $atts);
        echo '</div>';
    }
}
