<?php
/**
 *
 * The template for displaying product gifts content within loops
 */
$product_gift = $bundle_item->product;

if (!$product_gift->is_visible() && (!isset($_REQUEST['nasa_load_ajax']) || !$_REQUEST['nasa_load_ajax'])) :
    return;
endif;

$post_gift = get_post($product_gift->get_id());
$productId = $product_gift->get_id();

$time_sale = (isset($is_deals) && $is_deals) ? get_post_meta($productId, '_sale_price_dates_to', true) : false;
$main_img = $product_gift->get_image('shop_catalog');

/**
 * $attachment_ids = !NASA_IS_PHONE ? $product_gift->get_gallery_image_ids() : false;
 */
$attachment_ids = $product_gift->get_gallery_image_ids();

$nasa_title = get_the_title($post_gift); // Title
$nasa_link = get_permalink($post_gift); // permalink

$product_category = function_exists('wc_get_product_category_list') ? wc_get_product_category_list($productId, ', ') : $product_gift->get_categories(', '); // Categories list

$class_wrap = 'wow fadeInUp product-item grid';
$class_wrap .= isset($nasa_opt['animated_products']) ? ' ' . $nasa_opt['animated_products'] : '';

$stock_status = $product_gift->get_stock_status();
$class_wrap .= $stock_status == "outofstock" ? ' out-of-stock' : '';

echo '<div class="' . esc_attr($class_wrap) . '" data-wow-duration="1s" data-wow-delay="' . esc_attr($_delay) . 'ms" data-wow="fadeInUp">';
?>

<div class="inner-wrap<?php echo !$time_sale ? '' : ' product-deals'; ?> nasa-title-bottom">
    <div class="product-outner">
        <div class="product-inner">
            <div class="product-img">
                <a href="<?php echo esc_url($nasa_link); ?>" title="<?php echo esc_attr($nasa_title); ?>">
                    <div class="main-img">
                        <?php echo zella_str($main_img); ?>
                    </div>
                    <?php if ($attachment_ids) :
                        $loop = 0;
                        foreach ($attachment_ids as $attachment_id) :
                            $image_link = wp_get_attachment_url($attachment_id);
                            if (!$image_link):
                                continue;
                            endif;
                            $loop++;
                            printf('<div class="back-img back">%s</div>', wp_get_attachment_image($attachment_id, 'shop_catalog'));
                            if ($loop == 1):
                                break;
                            endif;
                        endforeach;
                    else : ?>
                        <div class="back-img">
                            <?php echo zella_str($main_img); ?>
                        </div>
                    <?php endif; ?>
                </a>

                <?php if ($stock_status == "outofstock"): ?>
                    <div class="badge">
                        <div class="badge-inner out-of-stock-label">
                            <div class="inner-text">
                                <?php esc_html_e('Sold out', 'zella-theme'); ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <div class="info">
                <div class="name nasa-name text-center">
                    <a href="<?php echo esc_url($nasa_link); ?>" title="<?php echo esc_attr($nasa_title); ?>">
                        <?php echo zella_str($nasa_title); ?>
                    </a>
                    <?php do_action('woocommerce_after_shop_loop_item_title'); ?>
                </div>
            </div>
            
            <?php echo zella_time_sale($time_sale); ?>
        </div>
    </div>
</div>
<?php
echo '</div>';
