<?php $class_col = 'large-12 columns'; ?>
<div class="blog-list-style">
    <article id="post-<?php echo absint($postId); ?>" <?php post_class(); ?>>
        <div class="row">
            <?php if (has_post_thumbnail()) : ?>
                <div class="large-4 columns">
                    <div class="entry-image">
                        <a href="<?php echo esc_url($link); ?>" title="<?php echo esc_attr($title); ?>">
                            <?php the_post_thumbnail('medium'); ?>
                            <div class="image-overlay"></div>
                        </a>
                    </div>
                </div>
            <?php
            $class_col = 'large-8 columns';
            endif; ?>

            <div class="<?php echo esc_attr($class_col); ?>">
                <div class="entry-content">
                    <h3 class="entry-title">
                        <a href="<?php echo esc_url($link); ?>" title="<?php echo esc_attr($title); ?>" rel="bookmark">
                            <?php echo zella_str($title); ?>
                        </a>
                    </h3>
                    <?php the_excerpt(); ?>
                    <?php if ('post' == get_post_type()) : ?>
                        <div class="entry-meta">
                            <?php zella_posted_on(); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </article>
</div>