<?php 
/**
 * Top bar Toggle
 */
$topbar_toggle = get_post_meta($wp_query->get_queried_object_id(), '_nasa_topbar_toggle', true);
$topbar_df_show = $topbar_toggle == 1 ? get_post_meta($wp_query->get_queried_object_id(), '_nasa_topbar_default_show', true) : '';

$topbar_toggle_val = $topbar_toggle == '' ? (isset($nasa_opt['topbar_toggle']) && $nasa_opt['topbar_toggle'] ? true : false) : ($topbar_toggle == 1 ? true : false);
$topbar_df_show_val = $topbar_df_show == '' ? (!isset($nasa_opt['topbar_default_show']) || $nasa_opt['topbar_default_show'] ? true : false) : ($topbar_df_show == 1 ? true : false);

$class_topbar = $topbar_toggle_val ? ' nasa-topbar-toggle' : '';
$class_topbar .= $topbar_df_show_val ? '' : ' nasa-topbar-hide';

/**
 * Top bar Content
 */
$topbar_content = (isset($nasa_opt['topbar_content']) && $nasa_opt['topbar_content'] != '') ? do_shortcode($nasa_opt['topbar_content']) : '';
?>
<div class="nasa-topbar-wrap<?php echo esc_attr($class_topbar); ?>">
    <div id="top-bar" class="top-bar ">
        <div class="row">
            <div class="large-12 columns">
                <div class="left-text left">
                    <div class="inner-block">
                        <?php echo zella_str($topbar_content); ?>
                    </div>
                </div>
                <div class="right-text right">
                    <div class="topbar-menu-container">
                        <?php echo zella_language_flages(); ?>
                        <?php zella_menu('topbar-menu', 'nasa-topbar-menu', 1); ?>
                        <?php echo zella_tiny_account(true); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="nasa-hide-for-mobile">
        <a class="nasa-icon-toggle" href="javascript:void(0);">
            <i class="nasa-topbar-up pe-7s-angle-up"></i>
            <i class="nasa-topbar-down pe-7s-angle-down"></i>
        </a>
    </div>
</div>
