<?php
/*
 *
 * @package nasatheme - zella-theme
 */

/* Define DIR AND URI OF THEME */
define('ZELLA_THEME_PATH', get_template_directory());
define('ZELLA_CHILD_PATH', get_stylesheet_directory());
define('ZELLA_THEME_URI', get_template_directory_uri());

/* Global $content_width */
if (!isset($content_width)){
    $content_width = 1200; /* pixels */
}

/**
 * Options theme
 */
require_once ZELLA_THEME_PATH . '/options/nasa-options.php';

/**
 * Setup theme
 */
add_action('after_setup_theme', 'zella_setup');
if (!function_exists('zella_setup')) :

    function zella_setup() {
        load_theme_textdomain('zella-theme', ZELLA_THEME_PATH . '/languages');
        add_theme_support('woocommerce');
        add_theme_support('automatic-feed-links');
        add_theme_support('post-thumbnails');
        add_theme_support('title-tag');
        add_theme_support('custom-background');
        add_theme_support('custom-header');

        register_nav_menus(array(
            'primary' => esc_html__('Main Menu', 'zella-theme'),
            'topbar-menu' => esc_html__('Top Menu - Only show level 1', 'zella-theme')
        ));

        require_once ZELLA_THEME_PATH . '/cores/nasa-custom-wc-ajax.php';
        require_once ZELLA_THEME_PATH . '/cores/nasa-dynamic-style.php';
        require_once ZELLA_THEME_PATH . '/cores/nasa-widget-functions.php';
        require_once ZELLA_THEME_PATH . '/cores/nasa-theme-options.php';
        require_once ZELLA_THEME_PATH . '/cores/nasa-theme-functions.php';
        require_once ZELLA_THEME_PATH . '/cores/nasa-woo-functions.php';
        require_once ZELLA_THEME_PATH . '/cores/nasa-shop-ajax.php';
        require_once ZELLA_THEME_PATH . '/cores/nasa-theme-headers.php';
        require_once ZELLA_THEME_PATH . '/cores/nasa-theme-footers.php';
    }

endif;
