<?php
/* ============================================================================ */
/* Remove - Add action, filter WooCommerce ==================================== */
/* ============================================================================ */
/*
 * Remove action woocommerce
 */
add_action('init', 'zella_remove_action_woo');
if(!function_exists('zella_remove_action_woo')) :
    function zella_remove_action_woo() {
        if(!NASA_WOO_ACTIVED) {
            return;
        }
        
        global $nasa_opt, $yith_woocompare;
        
        /* UNREGISTRER DEFAULT WOOCOMMERCE HOOKS */
        remove_action('woocommerce_single_product_summary', 'woocommerce_breadcrumb', 20);
        remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
        
        remove_action('woocommerce_before_shop_loop', 'woocommerce_show_messages', 10);
        remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
        
        remove_action('woocommerce_cart_collaterals', 'woocommerce_cart_totals');
        
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_title', 5);
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 10);
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20);
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50);
        
        if (isset($nasa_opt['disable-cart']) && $nasa_opt['disable-cart']) {
            remove_action('woocommerce_simple_add_to_cart', 'woocommerce_simple_add_to_cart', 30);
            remove_action('woocommerce_grouped_add_to_cart', 'woocommerce_grouped_add_to_cart', 30);
            remove_action('woocommerce_external_add_to_cart', 'woocommerce_external_add_to_cart', 30);
        }
        
        // Remove compare default
        if($yith_woocompare) {
            $nasa_compare = isset($yith_woocompare->obj) ? $yith_woocompare->obj : $yith_woocompare;
            remove_action('woocommerce_after_shop_loop_item', array($nasa_compare, 'add_compare_link'), 20);
            remove_action('woocommerce_single_product_summary', array($nasa_compare, 'add_compare_link'), 35);
        }
        
        /**
         * For content-product
         */
        remove_action('woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10);
        remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5);
        remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
        remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail');
        remove_action('woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title');
        
        /**
         * Shop page
         */
        remove_action('woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
        remove_action('woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);
        remove_action('woocommerce_archive_description', 'woocommerce_taxonomy_archive_description', 10);
        remove_action('woocommerce_archive_description', 'woocommerce_product_archive_description', 10);

        remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price');
        // remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating');
        
        /**
         * Remove wishlist btn in detail product
         */
        if(NASA_WISHLIST_ENABLE) {
            add_filter('yith_wcwl_positions', 'zella_remove_btn_wishlist_single_product');
        }
    }
endif;

/*
 * Add action woocommerce
 */
add_action('init', 'zella_add_action_woo');
if(!function_exists('zella_add_action_woo')) :
    function zella_add_action_woo() {
        if(!NASA_WOO_ACTIVED) {
            return;
        }
        
        global $nasa_opt, $yith_woocompare, $loadmoreStyle;
        
        add_action('nasa_root_cats', 'zella_root_categories');
        add_action('nasa_child_cat', 'zella_childs_category', 10, 2);
        
        // Results count in shop page
        $disable_ajax_product = false;
        if(
            (isset($nasa_opt['disable_ajax_product']) && $nasa_opt['disable_ajax_product']) ||
            get_option('woocommerce_shop_page_display', '') != '' || 
            get_option('woocommerce_category_archive_display', '') != ''
        ) :
            $disable_ajax_product = true;
        endif;
        
        $pagination_style = isset($nasa_opt['pagination_style']) ? $nasa_opt['pagination_style'] : 'style-2';
        
        if(isset($_REQUEST['paging-style']) && in_array($_REQUEST['paging-style'], $loadmoreStyle)) {
            $pagination_style = $_REQUEST['paging-style'];
        }
        
        if($disable_ajax_product) :
            $pagination_style = $pagination_style == 'style-2' ? 'style-2' : 'style-1';
        endif;
        
        if(in_array($pagination_style, $loadmoreStyle)) {
            add_action('nasa_shop_category_count', 'zella_result_count', 20);
        } else {
            add_action('nasa_shop_category_count', 'woocommerce_result_count', 20);
        }
        
        add_action('nasa_change_view', 'zella_nasa_change_view', 10, 2);
        
        add_action('woocommerce_cart_collaterals', 'woocommerce_cart_totals', 9);
        
        add_action('woocommerce_single_product_lightbox_summary', 'woocommerce_template_loop_rating', 10);
        add_action('woocommerce_single_product_lightbox_summary', 'woocommerce_template_single_price', 15);
        add_action('woocommerce_single_product_lightbox_summary', 'woocommerce_template_single_excerpt', 20);
        
        // Deal time for Detail product
        if(isset($nasa_opt['single-product-deal']) && $nasa_opt['single-product-deal']) {
            add_action('woocommerce_single_product_lightbox_summary', 'zella_deal_time_quickview', 25);
        }
        
        if (!isset($nasa_opt['disable-cart']) || !$nasa_opt['disable-cart']) {
            add_action('woocommerce_single_product_lightbox_summary', 'woocommerce_template_single_add_to_cart', 30);
        }
        
        add_action('woocommerce_single_product_lightbox_summary', 'woocommerce_template_single_meta', 40);
        add_action('woocommerce_single_product_lightbox_summary', 'zella_combo_in_quickview', 31);
        add_action('woocommerce_single_product_lightbox_summary', 'woocommerce_template_single_sharing', 50);
        
        add_action('nasa_single_product_layout', 'zella_single_product_layout', 1);
        
        /**
         * Add class for single product page layout
         */
        add_filter('body_class', 'zella_product_body_add_class');
        
        /**
         * add_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 1);
         */
        add_action('woocommerce_after_single_product_summary', 'woocommerce_template_single_meta', 11);
        
        add_action('woocommerce_single_product_summary', 'woocommerce_template_single_title', 5);
        /**
         * add_action('woocommerce_single_product_summary', 'zella_single_availability', 15);
         */
        add_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 20);
        add_action('woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 25);
        
        // Deal time for Detail product
        if(isset($nasa_opt['single-product-deal']) && $nasa_opt['single-product-deal']) {
            add_action('woocommerce_single_product_summary', 'zella_deal_time_single', 29);
        }
        
        add_action('woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 40);
        
        // add nasa compare in detail product
        if($yith_woocompare) {
            if (get_option('yith_woocompare_compare_button_in_product_page') == 'yes') {
                add_action('product_video_btn', 'zella_add_compare_in_detail', 32);
            }
            
            if (get_option('yith_woocompare_compare_button_in_products_list') == 'yes') {
                add_action('nasa_show_buttons_loop', 'zella_add_compare_in_list', 50);
            }
        }
        
        add_action('nasa_show_buttons_loop', 'zella_add_to_cart_in_list', 10);
        add_action('nasa_show_buttons_loop', 'zella_add_wishlist_in_list', 20);
        if (!isset($nasa_opt['disable-quickview']) || !$nasa_opt['disable-quickview']) {
            add_action('nasa_show_buttons_loop', 'zella_quickview_in_list', 40);
        }
        add_action('nasa_show_buttons_loop', 'zella_bundle_in_list', 60, 1);
        
        // Nasa ADD BUTTON BUY NOW
        add_action('woocommerce_after_add_to_cart_button', 'zella_add_buy_now_btn');
        
        // Nasa Add Custom fields form
        add_action('woocommerce_after_add_to_cart_button', 'zella_add_custom_field_detail_product', 25);
        
        add_action('nasa_price_list_loop', 'zella_price_list_loop');
        
        // nasa_top_sidebar_shop
        add_action('nasa_top_sidebar_shop', 'zella_top_sidebar_shop', 10, 1);
        add_action('nasa_sidebar_shop', 'zella_side_sidebar_shop', 10 , 1);
        
        // For Product content
        add_action('nasa_get_content_products', 'zella_content_products', 10, 1);
        add_action('woocommerce_before_shop_loop_item_title', 'zella_loop_product_content_thumbnail', 10);
        add_action('woocommerce_before_shop_loop_item_title', 'zella_loop_product_content_btns', 15);
        add_action('woocommerce_before_shop_loop_item_title', 'zella_gift_featured', 20);
        
        /**
         * Sale flash
         */
        add_filter('woocommerce_sale_flash', 'zella_filter_sale_flash');
        add_action('woocommerce_before_shop_loop_item_title', 'zella_add_custom_sale_flash', 11);
        add_action('woocommerce_before_single_product_summary', 'zella_add_custom_sale_flash', 11);
        
        add_action('nasa_widget_product_item_safe', 'zella_add_custom_sale_flash', 11);
        
        add_action('woocommerce_shop_loop_item_title', 'zella_loop_product_cats', 5);
        add_action('woocommerce_shop_loop_item_title', 'zella_loop_product_content_title', 10);
        
        add_action('woocommerce_after_shop_loop_item_title', 'zella_loop_product_price', 10);
        add_action('woocommerce_after_shop_loop_item_title', 'zella_loop_product_description', 15);
        
        /**
         * Add to wishlist in detail
         */
        add_action('product_video_btn', 'zella_add_wishlist_in_detail', 31);
        
        add_filter('woocommerce_checkout_coupon_message', 'zella_wrap_coupon_toggle');
        
        // for woo 3.3
        if(version_compare(wc()->version, '3.3.0', ">=")) {
            if(!isset($nasa_opt['show_uncategorized']) || !$nasa_opt['show_uncategorized']) {
                add_filter('woocommerce_product_subcategories_args', 'zella_hide_uncategorized');
            }
        }
        
        /**
         * Share icon in Detail
         */
        add_action('woocommerce_share', 'zella_before_woocommerce_share', 5);
        add_action('woocommerce_share', 'zella_woocommerce_share', 10);
        add_action('woocommerce_share', 'zella_after_woocommerce_share', 15);
        
        /**
         * Add src image large for variation
         */
        add_filter('woocommerce_available_variation', 'zella_src_large_image_single_product');
        
        /**
         * Add class Sub Categories
         */
        add_filter('product_cat_class', 'zella_add_class_sub_categories');
        
        /**
         * Filter redirect checkout buy now
         */
        add_filter('woocommerce_add_to_cart_redirect', 'zella_buy_now_to_checkout');
        
        /**
         * Filter Single Stock
         */
        if(!isset($nasa_opt['enable_progess_stock']) || $nasa_opt['enable_progess_stock']) {
            add_filter('woocommerce_get_stock_html', 'zella_single_stock', 10, 2);
        }
        
        /**
         * Disable redirect Search one product to single product
         */
        add_filter('woocommerce_redirect_single_search_result', '__return_false');
        
        /**
         * Support Yith WooCommerce Product Add ons in Quick view
         */
        if(class_exists('YITH_WAPO')) {
            $yith_wapo = YITH_WAPO::instance();
            $yith_wapo_frontend = $yith_wapo->frontend;
            add_action('woocommerce_single_product_lightbox_summary', array($yith_wapo_frontend, 'check_variable_product'));
        }
    }
endif;
/* ============================================================================ */
/* END Remove - Add action, filter WooCommerce ================================ */
/* ============================================================================ */

/**
 * Single Product stock
 */
if(!function_exists('zella_single_stock')) :
    function zella_single_stock($html, $product) {
        if($html == '' || !$product) {
            return $html;
        }
        
        $productId = $product->get_id();
        $type = $product->get_type();
        $stock = get_post_meta($productId, '_stock', true);
        
        if(!$stock && $type == 'variation') {
            global $product;
            if ($product) {
                $productId = $product->get_id();
                $stock = get_post_meta($productId, '_stock', true);
            }
        }
        
        if(!$stock) {
            return $html;
        }
        
        $total_sales = get_post_meta($productId, 'total_sales', true);
        $stock_sold = $total_sales ? round($total_sales) : 0;
        $stock_available = $stock ? round($stock) : 0;
        $percentage = $stock_available > 0 ? round($stock_sold/($stock_available + $stock_sold) * 100) : 0;
        $html = '<div class="stock nasa-single-product-stock text-left rtl-text-right">';
        $html .= '<span class="stock-sold text-left rtl-text-right">' . esc_html__('SOLD', 'zella-theme') . ' <strong class="primary-color">' . $stock_sold . '</strong></span>';
        $html .= '<span class="stock-available text-right rtl-text-left">' . esc_html__('ONLY', 'zella-theme') . ' <strong class="primary-color">' . $stock_available . '</strong> ' . esc_html__('LEFT', 'zella-theme') . '</span>';
        $html .= '<div class="nasa-product-stock-progress">';
        $html .= '<span class="nasa-product-stock-progress-bar" style="width:' . $percentage . '%"></span>';
        $html .= '</div>';
        $html .= '</div>';
        
        return $html;
    }
endif;

/**
 * Add class Sub Categories
 */
if(!function_exists('zella_add_class_sub_categories')) :
    function zella_add_class_sub_categories($classes) {
        $classes[] = 'product-warp-item';
        return $classes;
    }
endif;

/**
 * Buy Now button
 */
if(!function_exists('zella_add_buy_now_btn')) :
    function zella_add_buy_now_btn() {
        global $nasa_opt;
        
        if ((isset($nasa_opt['disable-cart']) && $nasa_opt['disable-cart']) ||
            (isset($nasa_opt['enable_buy_now']) && !$nasa_opt['enable_buy_now'])) {
            return;
        }
        
        echo '<input type="hidden" name="nasa_buy_now" value="0" />';
        echo '<button class="nasa-buy-now margin-top-20">' . esc_html__('Buy Now', 'zella-theme') . '</button>';
    }
endif;

/**
 * Redirect to Checkout page after click buy now
 */
if(!function_exists('zella_buy_now_to_checkout')) :
    function zella_buy_now_to_checkout($redirect_url) {
        if (isset($_REQUEST['nasa_buy_now']) && $_REQUEST['nasa_buy_now'] === '1') {
            $redirect_url = wc_get_checkout_url();
        }

        return $redirect_url;
    }
endif;

/**
 * Deal time in Single product page
 */
if(!function_exists('zella_deal_time_single')) :
    function zella_deal_time_single() {
        global $product;
        
        if($product->get_stock_status() == 'outofstock') {
            return;
        }
        
        $product_type = $product->get_type();
        
        // For variation of Variation product
        if($product_type == 'variable') {
            echo '<div class="nasa-detail-product-deal-countdown nasa-product-variation-countdown"></div>';
            return;
        }
        
        if($product_type != 'simple') {
            return;
        }
        
        $productId = $product->get_id();

        $time_from = get_post_meta($productId, '_sale_price_dates_from', true);
        $time_to = get_post_meta($productId, '_sale_price_dates_to', true);
        $time_sale = ((int) $time_to < NASA_TIME_NOW || (int) $time_from > NASA_TIME_NOW) ? false : (int) $time_to;
        if (!$time_sale) {
            return;
        }
        
        echo '<div class="nasa-detail-product-deal-countdown">';
        echo zella_time_sale($time_sale);
        echo '</div>';
    }
endif;

/**
 * Deal time in Quick view product page
 */
if(!function_exists('zella_deal_time_quickview')) :
    function zella_deal_time_quickview() {
        global $product;
        
        if($product->get_stock_status() == 'outofstock') {
            return;
        }
        
        $product_type = $product->get_type();
        
        // For variation of Variation product
        if($product_type == 'variable') {
            echo '<div class="nasa-quickview-product-deal-countdown nasa-product-variation-countdown"></div>';
            return;
        }
        
        if($product_type != 'simple') {
            return;
        }
        
        $productId = $product->get_id();

        $time_from = get_post_meta($productId, '_sale_price_dates_from', true);
        $time_to = get_post_meta($productId, '_sale_price_dates_to', true);
        $time_sale = ((int) $time_to < NASA_TIME_NOW || (int) $time_from > NASA_TIME_NOW) ? false : (int) $time_to;
        if (!$time_sale) {
            return;
        }
        
        echo '<div class="nasa-quickview-product-deal-countdown">';
        echo zella_time_sale($time_sale);
        echo '</div>';
    }
endif;

if(!function_exists('zella_src_large_image_single_product')) :
    function zella_src_large_image_single_product($variation) {
        if(!isset($variation['image_single_page'])) {
            $image = wp_get_attachment_image_src($variation['image_id'], 'shop_single');
            $variation['image_single_page'] = isset($image[0]) ? $image[0] : '';
        }
        
        return $variation;
    }
endif;

if(!function_exists('zella_result_count')) :
    function zella_result_count() {
        if (! wc_get_loop_prop('is_paginated') || !woocommerce_products_will_display()) {
            return;
        }
        
        $total = wc_get_loop_prop('total');
        $per_page = wc_get_loop_prop('per_page');
        
        echo '<p class="woocommerce-result-count">';
        if ($total <= $per_page || -1 === $per_page) {
            printf(_n('Showing the single result', 'Showing all %d results', $total, 'zella-theme'), $total);
	} else {
            $current = wc_get_loop_prop('current_page');
            $showed = $per_page * $current;
            if($showed > $total) {
                $showed = $total;
            }
            
            printf(_n('Showing the single result', 'Showing %d results', $total, 'zella-theme' ), $showed);
	}
        echo '</p>';
    }
endif;

// **********************************************************************//
// ! Tiny account
// **********************************************************************//
if (!function_exists('zella_tiny_account')) {

    function zella_tiny_account($icon = false, $user = false, $redirect = false) {
        global $nasa_opt;
        if(isset($nasa_opt['hide_tini_menu_acc']) && $nasa_opt['hide_tini_menu_acc']) {
            return '';
        }
        
        $login_url = '#';
        $register_url = '#';
        $profile_url = '#';
        
        /* Active woocommerce */
        if (NASA_WOO_ACTIVED) {
            $myaccount_page_id = get_option('woocommerce_myaccount_page_id');
            if ($myaccount_page_id) {
                $login_url = get_permalink($myaccount_page_id);
                $register_url = $login_url;
                $profile_url = $login_url;
            }
        } else {
            $login_url = wp_login_url();
            $register_url = wp_registration_url();
            $profile_url = admin_url('profile.php');
        }

        $result = '<ul class="nasa-menus-account">';
        if (!NASA_CORE_USER_LOGIGED && !$user) {
            global $nasa_opt;
            $span = $icon ? '<span class="nasa-icon pe7-icon pe-7s-user"></span>' : '';
            $result .= '<li class="menu-item color"><a class="nasa-login-register-ajax" data-enable="' . ((!isset($nasa_opt['login_ajax']) || $nasa_opt['login_ajax'] == 1) ? '1' : '0') . '" href="' . esc_url($login_url) . '" title="' . esc_attr__('Register or sign in', 'zella-theme') . '">' . $span . '<span class="nasa-login-title">' . esc_html__('Register or sign in', 'zella-theme') . '</span></a></li>';
        } else {
            if(!$redirect) {
                global $wp;
                $redirect = home_url(add_query_arg(array(), $wp->request));
            }
            $logout_url = wp_logout_url($redirect);
        
            $span1 = $icon ? '<span class="nasa-icon pe7-icon pe-7s-user"></span>' : '';
            $span2 = $icon ? '<span class="nasa-icon pe7-icon pe-7s-back"></span>' : '';
            
            $result .= 
                '<li class="menu-item"><a href="' . esc_url($profile_url) . '" title="' . esc_attr__('My Account', 'zella-theme') . '">' . $span1 . esc_html__('My Account', 'zella-theme') . '</a></li>' .
                '<li class="menu-item"><a class="nav-top-link" href="' . esc_url($logout_url) . '" title="' . esc_attr__('Logout', 'zella-theme') . '">' . $span2 . esc_html__('Logout', 'zella-theme') . '</a></li>';
        }
        
        $result .= '</ul>';
        
        return apply_filters('nasa_tiny_account_ajax', $result);
    }

}

// **********************************************************************//
// Mini cart icon *******************************************************//
// **********************************************************************//
if (!function_exists('zella_mini_cart')) {

    function zella_mini_cart() {
        global $woocommerce, $nasa_opt, $nasa_mini_cart;
        
        if (!$woocommerce || (isset($nasa_opt['disable-cart']) && $nasa_opt['disable-cart'])) {
            return;
        }
        
        if (!$nasa_mini_cart) {
            $hasEmpty = $woocommerce->cart->cart_contents_count == 0 ? ' nasa-product-empty' : '';
            $numberCart = $woocommerce->cart->cart_contents_count < 10 ? '<span class="nasa-first-number-cart hidden-tag">0</span>' . $woocommerce->cart->cart_contents_count : $woocommerce->cart->cart_contents_count;
            
            $icon_number = isset($nasa_opt['mini-cart-icon']) ? $nasa_opt['mini-cart-icon'] : '2';

            switch ($icon_number) {
                case '1':
                    $icon_class = 'icon-nasa-cart-3';
                    break;
                case '3':
                    $icon_class = 'icon-nasa-cart-4';
                    break;
                case '4':
                    $icon_class = 'pe-7s-cart';
                    break;
                case '5':
                    $icon_class = 'fa fa-shopping-cart';
                    break;
                case '2':
                default:
                    $icon_class = 'icon-nasa-cart-2';
                    break;
            }
            
            $GLOBALS['nasa_mini_cart'] = 
            '<div class="mini-cart cart-inner mini-cart-type-full inline-block">' .
                '<a href="javascript:void(0);" class="cart-link" title="' . esc_attr__('Cart', 'zella-theme') . '">' .
                    '<div>' .
                        '<span class="nasa-icon cart-icon icon ' . $icon_class . '"></span>' .
                        '<span class="products-number' . $hasEmpty . '">' .
                            '<span class="nasa-sl">' .
                                $numberCart .
                            '</span>' .
                            '<span class="hidden-tag nasa-sl-label last">' . esc_html__('Items', 'zella-theme') . '</span>' .
                        '</span>' .
                    '</div>' .
                '</a>' .
            '</div>';
        }
        
        return $nasa_mini_cart ? apply_filters('nasa_mini_cart', $nasa_mini_cart) : '';
    }

}

// *************************************************************************//
// ! Add to cart dropdown - Refresh mini cart content. Input from header type
// *************************************************************************//
add_filter('woocommerce_add_to_cart_fragments', 'zella_add_to_cart_refresh');
if (!function_exists('zella_add_to_cart_refresh')) :
    function zella_add_to_cart_refresh($fragments) {

        $fragments['.cart-inner'] = zella_mini_cart();

        return $fragments;
    }
endif;

// **********************************************************************//
// ! Mini wishlist sidebar
// **********************************************************************//
if (!function_exists('zella_mini_wishlist_sidebar')) {

    function zella_mini_wishlist_sidebar($return = false) {
        global $woocommerce;
        if (!$woocommerce){
            return '';
        }
        
        ob_start();
        $file = ZELLA_CHILD_PATH . '/includes/nasa-sidebar-wishlist.php';
        include is_file($file) ? $file : ZELLA_THEME_PATH . '/includes/nasa-sidebar-wishlist.php';
        $content = ob_get_clean();
        
        if ($return) {
            return $content;
        }
        echo zella_str($content);
    }

}

if(!function_exists('zella_add_to_cart_in_wishlist')) :
    function zella_add_to_cart_in_wishlist() {
        global $product, $nasa_opt;

        if (isset($nasa_opt['disable-cart']) && $nasa_opt['disable-cart']) {
            return '';
        }

        $title = $product->add_to_cart_text();
        $product_type = $product->get_type();
        $productId = $product->get_id();
        $enable_button_ajax = false;
        if ($product->is_in_stock() && $product->is_purchasable()) {
            if ($product_type == 'simple' || ($product_type == NASA_COMBO_TYPE && $product->all_items_in_stock())) {
                $url = 'javascript:void(0);';
                $enable_button_ajax = true;
            } else {
                /**
                 * Bundle product
                 */
                if($product_type == 'woosb') {
                    $url = '?add-to-cart=' . $productId;
                    if (NASA_CORE_USER_LOGIGED && get_option('yith_wcwl_remove_after_add_to_cart') == 'yes') {
                        $url .= '&remove_from_wishlist_after_add_to_cart=' . $productId;
                    }
                }
                /**
                 * Normal product
                 */
                else {
                    $url = esc_url($product->add_to_cart_url());
                }
            }
        }
        else {
            return '';
        }

        return apply_filters(
            'woocommerce_loop_add_to_cart_link',
            sprintf(
                '<a href="%s" rel="nofollow" data-quantity="1" data-product_id="%s" data-product_sku="%s" class="button-in-wishlist small btn-from-wishlist %s product_type_%s add-to-cart-grid" data-type="%s" title="%s">' .
                    '<span class="cart-icon nasa-icon icon-nasa-cart-3"></span>' .
                    '<span class="add_to_cart_text">%s</span>' .
                    '<span class="cart-icon-handle"></span>' .
                '</a>',
                $url, //link
                esc_attr($product->get_id()), //product id
                esc_attr($product->get_sku()), //product sku
                $enable_button_ajax ? 'nasa_add_to_cart_from_wishlist' : '', //class name
                esc_attr($product_type), esc_attr($product_type), //product type
                $title, $title
            ),
            $product
        );
    }
endif;

// **********************************************************************//
// ! Add to cart button
// **********************************************************************//
if (!function_exists('zella_add_to_cart_btn')):
    function zella_add_to_cart_btn($type = 'small', $echo = true, $tiptop = true, $customClass = '') {
        global $product, $nasa_opt;

        if (isset($nasa_opt['disable-cart']) && $nasa_opt['disable-cart']) {
            return '';
        }

        $productId = $product->get_id();
        $product_type = $product->get_type();
        $productVariable = null;
        $class_btn = $data_type = '';
        if($product->is_purchasable() && $product->is_in_stock()) {
            if($product_type == 'simple') {
                $class_btn .= 'add_to_cart_button ajax_add_to_cart';
            } elseif ($product_type == NASA_COMBO_TYPE) {
                $class_btn .= 'yes' === get_option('woocommerce_enable_ajax_add_to_cart') ? 'add_to_cart_button nasa_bundle_add_to_cart' : 'add_to_cart_button';
                $data_type = ' data-type="' . esc_attr($product_type) . '" ';
            }
            elseif ($product_type == 'variation') {
                $product_type = 'variable';
                $parent_id = wp_get_post_parent_id($productId);
                $productVariable = wc_get_product($parent_id);
            }
        }
        $class_btn .= $customClass != '' ? ' ' . $customClass : $customClass;
        $result = '';
        
        //add to cart text;
        $title = !$productVariable ? $product->add_to_cart_text() : $productVariable->add_to_cart_text();
        switch ($type) {
            case 'large':
                $result .= apply_filters(
                    'woocommerce_loop_add_to_cart_link',
                    sprintf(
                        '<div class="add-to-cart-btn nasa-product_type_%s">' .
                            '<a href="%s" rel="nofollow" data-product_id="%s" class="%s button small product_type_%s add-to-cart-grid" ' . $data_type . ' title="%s">' .
                                '<span class="add_to_cart_text">%s</span>' .
                                '<span class="cart-icon-handle"></span>' .
                            '</a>' .
                        '</div>',
                        esc_attr($product_type), //product type
                        esc_url($product->add_to_cart_url()), //link
                        esc_attr($productId), //product id
                        esc_attr($class_btn), //class name
                        esc_attr($product_type), //product type
                        $title, $title
                    ),
                    $product
                );
                break;
            case 'small':
            default:
                $result .= apply_filters(
                    'woocommerce_loop_add_to_cart_link',
                    sprintf(
                        '<div class="add-to-cart-btn nasa-product_type_%s">' .
                            '<div class="btn-link">' .
                                '<a href="%s" rel="nofollow" data-quantity="1" data-product_id="%s" data-product_sku="%s" class="%s product_type_%s add-to-cart-grid" ' . $data_type . ' title="%s">' .
                                    '<span class="add_to_cart_text">%s</span>' .
                                    '<span class="cart-icon-handle"></span>' .
                                    '<span class="cart-icon nasa-icon icon-nasa-icons-plus"></span>' .
                                '</a>' .
                            '</div>' .
                        '</div>',
                        esc_attr($product_type), //product type
                        esc_url($product->add_to_cart_url()), //link
                        esc_attr($productId), //product id
                        esc_attr($product->get_sku()), //product sku
                        esc_attr($class_btn), //class name
                        esc_attr($product_type), //product type
                        $title, $title
                    ),
                    $product
                );
                break;
        }

        if (!$echo) {
            return $result;
        }
        echo zella_str($result);
    }
endif;

// Product group button
if (!function_exists('zella_product_group_button')):
    function zella_product_group_button($combo_show_type = 'rowdown') {
        ob_start();
        $file = ZELLA_CHILD_PATH . '/includes/nasa-product-buttons.php';
        include is_file($file) ? $file : ZELLA_THEME_PATH . '/includes/nasa-product-buttons.php';

        return ob_get_clean();
    }
endif;

// **********************************************************************//
// ! Wishlist link
// **********************************************************************//
if (!function_exists('zella_tini_wishlist')):
    function zella_tini_wishlist($icon = false) {
        if (!NASA_WOO_ACTIVED || !NASA_WISHLIST_ENABLE) {
            return;
        }

        $tini_wishlist = '';
        $wishlist_page_id = get_option('yith_wcwl_wishlist_page_id');
        if (function_exists('icl_object_id')) {
            $wishlist_page_id = icl_object_id($wishlist_page_id, 'page', true);
        }
        $wishlist_page = get_permalink($wishlist_page_id);

        $span = $icon ? '<span class="icon-nasa-like"></span>' : '';
        $tini_wishlist .= '<a href="' . esc_url($wishlist_page) . '" title="' . esc_attr__('Wishlist', 'zella-theme') . '">' . $span . esc_html__('Wishlist', 'zella-theme') . '</a>';

        return $tini_wishlist;
    }
endif;

// **********************************************************************//
// ! Wishlist link
// **********************************************************************//
if (!function_exists('zella_icon_wishlist')):
    function zella_icon_wishlist() {
        if (!NASA_WOO_ACTIVED || !NASA_WISHLIST_ENABLE) {
            return;
        }

        global $nasa_icon_wishlist;
        if(!$nasa_icon_wishlist) {
            $show = defined('NASA_PLG_CACHE_ACTIVE') && NASA_PLG_CACHE_ACTIVE ? false : true;
            $count = zella_count_wishlist($show);
            $href = '';
            $class = 'wishlist-link';
            if(defined('YITH_WCWL_PREMIUM')) {
                $class .= ' wishlist-link-premium';
                $wishlist_page_id = get_option('yith_wcwl_wishlist_page_id');
                if (function_exists('icl_object_id')) {
                    $wishlist_page_id = icl_object_id($wishlist_page_id, 'page', true);
                }
                $href = get_permalink($wishlist_page_id);
            }
            
            $GLOBALS['nasa_icon_wishlist'] = 
            '<a class="' . $class . '" href="' . ($href != '' ? esc_url($href) : 'javascript:void(0);') . '" title="' . esc_attr__('Wishlist', 'zella-theme') . '">' .
                '<i class="nasa-icon icon-nasa-like"></i>' .
                $count .
            '</a>';
        }

        return $nasa_icon_wishlist ? $nasa_icon_wishlist : '';
    }
endif;

if (!function_exists('zella_count_wishlist')):
    function zella_count_wishlist($show = true) {
        if (!NASA_WOO_ACTIVED || !NASA_WISHLIST_ENABLE) {
            return '';
        }
        
        $count = yith_wcwl_count_products();
        $hasEmpty = (int) $count == 0 ? ' nasa-product-empty' : '';
        $sl = $show ? '' : ' hidden-tag';
        
        return '<span class="nasa-wishlist-count wishlist-number' . $hasEmpty . '">' .
                    '<span class="nasa-text hidden-tag">' . esc_html__('Wishlist', 'zella-theme') . '</span>' .
                    '<span class="nasa-sl' . $sl . '">' . (int) $count . '</span>' .
                '</span>';
    }
endif;

// **********************************************************************//
// ! Compare link
// **********************************************************************//
if (!function_exists('zella_icon_compare')):

    function zella_icon_compare() {
        if (!NASA_WOO_ACTIVED || !defined('YITH_WOOCOMPARE')) {
            return;
        }

        global $nasa_icon_compare, $nasa_opt;
        if(!$nasa_icon_compare) {
            global $yith_woocompare;
            
            if(!isset($nasa_opt['nasa-product-compare']) || $nasa_opt['nasa-product-compare']) {
                $view_href = isset($nasa_opt['nasa-page-view-compage']) && (int) $nasa_opt['nasa-page-view-compage'] ? get_permalink((int) $nasa_opt['nasa-page-view-compage']) : home_url('/');
                $class = 'nasa-show-compare';
            } else {
                $view_href = add_query_arg(array('iframe' => 'true'), $yith_woocompare->obj->view_table_url());
                $class = 'compare';
            }
            
            $show = defined('NASA_PLG_CACHE_ACTIVE') && NASA_PLG_CACHE_ACTIVE ? false : true;
            $count = zella_count_compare($show);
            
            $GLOBALS['nasa_icon_compare'] = 
            '<span class="yith-woocompare-widget">' .
                '<a href="' . esc_url($view_href) . '" title="' . esc_attr__('Compare', 'zella-theme') . '" class="' . esc_attr($class) . '">' .
                    '<i class="nasa-icon icon-nasa-refresh"></i>' .
                    $count .
                '</a>' .
            '</span>';
        }
        
        return $nasa_icon_compare ? $nasa_icon_compare : '';
    }

endif;

if (!function_exists('zella_count_compare')):
    function zella_count_compare($show = true) {
        if (!NASA_WOO_ACTIVED || !defined('YITH_WOOCOMPARE')) {
            return '';
        }
        
        global $yith_woocompare;
        
        $count = count($yith_woocompare->obj->products_list);
        $hasEmpty = (int) $count == 0 ? ' nasa-product-empty' : '';
        
        $sl = $show ? '' : ' hidden-tag';
        
        return '<span class="nasa-compare-count compare-number' . $hasEmpty . '">' .
                    '<span class="nasa-text hidden-tag">' . esc_html__('Compare ', 'zella-theme') . ' </span>' .
                    '<span class="nasa-sl' . $sl . '">' . (int) $count . '</span>' .
                '</span>';
    }
endif;

if (!function_exists('zella_cat_header')):

    function zella_cat_header($catId = null) {
        global $nasa_opt;
        if (isset($nasa_opt['enable_cat_header']) && $nasa_opt['enable_cat_header'] != '1') {
            return '';
        }

        $content = '<div class="cat-header nasa-cat-header margin-top-30">';
        $do_content = '';
        
        if ((int) $catId > 0) {
            $shortcode = function_exists('get_term_meta') ? get_term_meta($catId, 'cat_header', false) : get_woocommerce_term_meta($catId, 'cat_header', false);
            $do_content = isset($shortcode[0]) ? do_shortcode($shortcode[0]) : '';
        }

        if (trim($do_content) === '') {
            if (isset($nasa_opt['cat_header']) && $nasa_opt['cat_header'] != '') {
                $do_content = do_shortcode($nasa_opt['cat_header']);
            }
        }

        if (trim($do_content) === '') {
            return '';
        }

        $content .= $do_content . '</div>';

        return $content;
    }

endif;

if (!function_exists('zella_product_meta_value')):

    function zella_product_meta_value($post_id, $field_id = null) {
        $meta_value = get_post_meta($post_id, 'wc_productdata_options', true);
        if (isset($meta_value[0]) && $field_id) {
            return isset($meta_value[0][$field_id]) ? $meta_value[0][$field_id] : '';
        }

        return isset($meta_value[0]) ? $meta_value[0] : $meta_value;
    }

endif;

add_action('nasa_search_by_cat', 'zella_search_by_cat', 10, 1);
if (!function_exists('zella_search_by_cat')):
    function zella_search_by_cat($echo = true) {
        global $nasa_opt;
        
        $select = '';
        if(NASA_WOO_ACTIVED && (!isset($nasa_opt['search_by_cat']) || $nasa_opt['search_by_cat'] == 1)){
            $select .= '<select name="product_cat">';
            $select .= '<option value="">' . esc_html__('Categories', 'zella-theme') . '</option>';
            
            $slug = get_query_var('product_cat');
            $nasa_catActive = $slug ? $slug : '';
            $nasa_terms = get_terms(apply_filters('woocommerce_product_attribute_terms', array(
                'taxonomy' => 'product_cat',
                'parent' => 0,
                'hide_empty' => false,
                'orderby' => 'name'
            )));
            
            if($nasa_terms) {
                foreach ($nasa_terms as $v) {
                    $select .= '<option data-term_id="' . esc_attr($v->term_id) . '" value="' . esc_attr($v->slug) . '"' . (($nasa_catActive == $v->slug) ? ' selected' : '') . '>' . esc_attr($v->name) . '</option>';
                    zella_child($v, $select, $nasa_catActive);
                }
            }
            
            $select .= '</select>';
        }
        
        if(!$echo){
            return $select;
        }
        
        echo zella_str($select);
    }

endif;

if (!function_exists('zella_child')):
    function zella_child($obj, &$select, $nasa_catActive, $pad = '') {
        $childs = get_terms(apply_filters('woocommerce_product_attribute_terms', array(
            'taxonomy' => 'product_cat',
            'parent' => $obj->term_id,
            'hide_empty' => false,
            'orderby' => 'name'
        )));

        if(!empty($childs)){
            $pad .= '&nbsp;&nbsp;&nbsp;';
            foreach ($childs as $v){
                $select .= '<option data-term_id="' . esc_attr($v->term_id) . '" value="' . esc_attr($v->slug) . '"' . (($nasa_catActive == $v->slug) ? ' selected' : '') . '>' . $pad . esc_attr($v->name) . '</option>';
                zella_child($v, $select, $nasa_catActive, $pad);
            }
        }
    }
endif;

// Nasa root categories in Shop Top bar
if (!function_exists('zella_root_categories')):
    
    function zella_root_categories() {
        global $nasa_opt;
        
        $content = '';
        
        if(isset($nasa_opt['top_filter_rootcat']) && !$nasa_opt['top_filter_rootcat']) {
            echo zella_str($content);
            return;
        }
        
        if (!is_post_type_archive('product') && !is_tax(get_object_taxonomies('product'))) {
            echo zella_str($content);
            return;
        }
        
        if(NASA_WOO_ACTIVED){
            $nasa_terms = get_terms(apply_filters('woocommerce_product_attribute_terms', array(
                'taxonomy' => 'product_cat',
                'parent' => 0,
                'hide_empty' => false,
                'orderby' => 'name'
            )));
            
            if($nasa_terms) {
                $slug = get_query_var('product_cat');
                $nasa_catActive = $slug ? $slug : '';
                $content .= '<div class="nasa-transparent-topbar"></div>';
                $content .= '<div class="nasa-root-cat-topbar-warp hidden-tag"><ul class="nasa-root-cat product-categories">';
                $content .= '<li class="nasa_odd"><span class="nasa-root-cat-header">' . esc_html__('CATEGORIES', 'zella-theme'). '</span></li>';
                $li_class = 'nasa_even';
                foreach ($nasa_terms as $v) {
                    $class_active = $nasa_catActive == $v->slug ? ' nasa-active' : '';
                    $content .= '<li class="cat-item cat-item-' . esc_attr($v->term_id) . ' cat-item-accessories root-item ' . $li_class . '">';
                    $content .= '<a href="' . esc_url(get_term_link($v)) . '" data-id="' . esc_attr($v->term_id) . '" class="nasa-filter-by-cat' . $class_active . '" title="' . esc_attr($v->name) . '" data-taxonomy="product_cat">' . esc_attr($v->name) . '</a>';
                    $content .= '</li>';
                    $li_class = $li_class == 'nasa_even' ? 'nasa_odd' : 'nasa_even';
                }
                
                $content .= '</ul></div>';
            }
        }
        
        $icon = $content != '' ? '<div class="nasa-icon-cat-topbar"><a href="javascript:void(0);"><i class="pe-7s-menu"></i><span class="inline-block">' . esc_html__('BROWSE', 'zella-theme') . '</span></a></div>' : '';
        $content = $icon . $content;
        
        echo zella_str($content);
    }

endif;

// Nasa childs category in Shop Top bar
if (!function_exists('zella_childs_category')):
    
    function zella_childs_category($term = null, $instance = array()) {
        $content = '';
        
        if(NASA_WOO_ACTIVED){
            global $wp_query;
            
            $term = $term == null ? $wp_query->get_queried_object() : $term;
            $parent_id = is_numeric($term) ? $term : (isset($term->term_id) ? $term->term_id : 0);
            
            $nasa_terms = get_terms(apply_filters('woocommerce_product_attribute_terms', array(
                'taxonomy' => 'product_cat',
                'parent' => $parent_id,
                'hierarchical' => true,
                'hide_empty' => false,
                'orderby' => 'name'
            )));
            
            if (!$nasa_terms) {
                $term_root = get_ancestors($parent_id, 'product_cat');
                $term_parent = isset($term_root[0]) ? $term_root[0] : 0;
                $nasa_terms = get_terms(apply_filters('woocommerce_product_attribute_terms', array(
                    'taxonomy' => 'product_cat',
                    'parent' => $term_parent,
                    'hierarchical' => true,
                    'hide_empty' => false,
                    'orderby' => 'name'
                )));
            }
            
            if($nasa_terms) {
                $show = isset($instance['show_items']) ? (int) $instance['show_items'] : 0;
                $content .= '<ul class="nasa-children-cat product-categories nasa-product-child-cat-top-sidebar">';
                $items = 0;
                foreach ($nasa_terms as $v) {
                    $class_active = $parent_id == $v->term_id ? ' nasa-active' : '';
                    $class_li = ($show && $items >= $show) ? ' nasa-show-less' : '';
                    
                    $icon = '';
                    if (isset($instance['cat_' . $v->slug]) && trim($instance['cat_' . $v->slug]) != '') {
                        $icon = '<i class="' . $instance['cat_' . $v->slug] . '"></i>';
                        $icon .= '&nbsp;&nbsp;';
                    }
                    
                    $content .= '<li class="cat-item cat-item-' . esc_attr($v->term_id) . ' cat-item-accessories root-item' . $class_li . '">';
                    $content .= '<a href="' . esc_url(get_term_link($v)) . '" data-id="' . esc_attr($v->term_id) . '" class="nasa-filter-by-cat' . $class_active . '" title="' . esc_attr($v->name) . '" data-taxonomy="product_cat">';
                    $content .= '<div class="nasa-cat-warp">';
                    $content .= '<h5 class="nasa-cat-title">';
                    $content .= $icon . esc_attr($v->name);
                    $content .= '</h5>';
                    $content .= '</div>';
                    $content .= '</a>';
                    $content .= '</li>';
                    $items++;
                }
                
                if ($show && ($items > $show)) {
                    $content .= '<li class="nasa_show_manual"><a data-show="1" class="nasa-show" href="javascript:void(0);">' . esc_html__('+ Show more', 'zella-theme') . '</a><a data-show="0" class="nasa-hidden" href="javascript:void(0);">' . esc_html__('- Show less', 'zella-theme') . '</a></li>';
                }
                
                $content .= '</ul>';
            }
        }
        
        echo zella_str($content);
    }

endif;

function zella_category_thumbnail($category, $type = 'shop_thumbnail') {
    $small_thumbnail_size = apply_filters('single_product_small_thumbnail_size', $type);
    $thumbnail_id = function_exists('get_term_meta') ? get_term_meta($category->term_id, 'thumbnail_id', true) : get_woocommerce_term_meta($category->term_id, 'thumbnail_id', true);

    if ($thumbnail_id) {
        $image = wp_get_attachment_image_src($thumbnail_id, $small_thumbnail_size);
        $image = $image[0];
    } else {
        $image = wc_placeholder_img_src();
    }

    if ($image) {
        $image = str_replace(' ', '%20', $image);
        return '<img src="' . esc_url($image) . '" alt="' . esc_attr($category->name) . '" />';
    }
    
    return '';
}

// Login Or Register Form
add_action('nasa_login_register_form', 'zella_login_register_form', 10, 1);
if(!function_exists('zella_login_register_form')) :
    function zella_login_register_form($prefix = false) {
        global $woocommerce, $nasa_opt;
        if(!$woocommerce) {
            return;
        }
        
        $file = ZELLA_THEME_PATH . '/includes/nasa-login-register-form.php';
        include is_file($file) ? $file : ZELLA_THEME_PATH . '/includes/nasa-login-register-form.php';
    }
endif;

// Get term description
if(!function_exists('zella_term_description')) :
    function zella_term_description($term_id, $type_taxonomy) {
        if(!NASA_WOO_ACTIVED) {
            return '';
        }
        
        if((int) $term_id < 1) {
            $shop_page_id = get_option('woocommerce_shop_page_id', 0);
            $shop_page = $shop_page_id ? get_post($shop_page_id) : false;
            $desc = $shop_page ? wc_format_content($shop_page->post_content) : '';
        } else {
            $term = get_term($term_id, $type_taxonomy);
            $desc = isset($term->description) ? $term->description : '';
        }
        
        return trim($desc) != '' ? '<div class="page-description">' . do_shortcode($desc) . '</div>' : '';
    }
endif;

// get value custom field nasa-core
if(!function_exists('zella_custom_field_value')) :
function zella_custom_field_value($post_id, $field_id) {
    $meta_value = get_post_meta($post_id, 'wc_productdata_options', true);
    if ($meta_value) {
        $meta_value = $meta_value[0];
    }

    return isset($meta_value[$field_id]) ? $meta_value[$field_id] : '';
}
endif;

// Add action archive-product get content product.
if(!function_exists('zella_content_products')) :
    function zella_content_products($nasa_sidebar = 'top') {
        global $nasa_opt, $wp_query;

        $file = ZELLA_CHILD_PATH . '/includes/nasa-get-content-products.php';
        include is_file($file) ? $file : ZELLA_THEME_PATH . '/includes/nasa-get-content-products.php';
    }
endif;

// Number post_per_page shop/archive_product
add_filter('loop_shop_per_page', 'zella_loop_shop_per_page', 20);
if(!function_exists('zella_loop_shop_per_page')) :
    function zella_loop_shop_per_page($post_per_page) {
        global $nasa_opt;
        $post_per_page = (isset($nasa_opt['products_pr_page']) && (int) $nasa_opt['products_pr_page']) ? (int) $nasa_opt['products_pr_page'] : get_option('posts_per_page');
        
        return $post_per_page;
    }
endif;

// Number relate products
add_filter('woocommerce_output_related_products_args', 'zella_output_related_products_args');
if(!function_exists('zella_output_related_products_args')) :
    function zella_output_related_products_args($args) {
        global $nasa_opt;
        $args['posts_per_page'] = (isset($nasa_opt['release_product_number']) && (int) $nasa_opt['release_product_number']) ? (int) $nasa_opt['release_product_number'] : 12;
        return $args;
    }
endif;

// Compare list in bot site
add_action('nasa_show_mini_compare', 'zella_show_mini_compare');
if(!function_exists('zella_show_mini_compare')) :
    function zella_show_mini_compare() {
        global $nasa_opt, $yith_woocompare;
        
        if(isset($nasa_opt['nasa-product-compare']) && !$nasa_opt['nasa-product-compare']) {
            echo '';
            return;
        }
        
        $nasa_compare = isset($yith_woocompare->obj) ? $yith_woocompare->obj : $yith_woocompare;
        if(!$nasa_compare) {
            echo '';
            return;
        }
        
        if(!isset($nasa_opt['nasa-page-view-compage']) || !(int) $nasa_opt['nasa-page-view-compage']) {
            $pages = get_pages(array(
                'meta_key' => '_wp_page_template',
                'meta_value' => 'page-view-compare.php'
            ));
            
            if($pages) {
                foreach ($pages as $page) {
                    $nasa_opt['nasa-page-view-compage'] = (int) $page->ID;
                    break;
                }
            }
        }
        
        $view_href = isset($nasa_opt['nasa-page-view-compage']) && (int) $nasa_opt['nasa-page-view-compage'] ? get_permalink((int) $nasa_opt['nasa-page-view-compage']) : home_url('/');

        $nasa_compare_list = $nasa_compare->get_products_list();
        $max_compare = isset($nasa_opt['max_compare']) ? (int) $nasa_opt['max_compare'] : 4;
        
        $file = ZELLA_CHILD_PATH . '/includes/nasa-mini-compare.php';
        include is_file($file) ? $file : ZELLA_THEME_PATH . '/includes/nasa-mini-compare.php';
    }
endif;

/**
 * Default page compare
 */
if(!function_exists('zella_products_compare_content')) :
    function zella_products_compare_content() {
        global $nasa_opt, $yith_woocompare;
        
        if(isset($nasa_opt['nasa-product-compare']) && !$nasa_opt['nasa-product-compare']) {
            return '';
        }
        
        $nasa_compare = isset($yith_woocompare->obj) ? $yith_woocompare->obj : $yith_woocompare;
        if(!$nasa_compare) {
            return '';
        }
        
        ob_start();
        $file = ZELLA_CHILD_PATH . '/includes/nasa-view-compare.php';
        include is_file($file) ? $file : ZELLA_THEME_PATH . '/includes/nasa-view-compare.php';
        
        return ob_get_clean();
    }
endif;

/* ======================================================================= */
/* NEXT - PREV PRODUCTS */
/* ======================================================================= */

/* NEXT / PREV NAV ON PRODUCT PAGES */
if(!function_exists('zella_next_product')) :
    function zella_next_product() {
        $next_post = get_next_post(true, '', 'product_cat');
        if (is_a($next_post, 'WP_Post')) {
            $product_obj = new WC_Product($next_post->ID);
            $title = get_the_title($next_post->ID);
            $link = get_the_permalink($next_post->ID);
            ?>
            <div class="next-product next-prev-buttons">
                <a href="<?php echo esc_url($link); ?>" rel="next" class="icon-next-prev pe-7s-angle-right next" title="<?php echo esc_attr($title); ?>"></a>
                <div class="dropdown-wrap">
                    <a title="<?php echo esc_attr($title); ?>" href="<?php echo esc_url($link); ?>">
                        <?php echo get_the_post_thumbnail($next_post->ID, apply_filters('single_product_small_thumbnail_size', 'shop_thumbnail')); ?>
                        <div>
                            <span class="product-name"><?php echo zella_str($title); ?></span>
                            <span class="price"><?php echo zella_str($product_obj->get_price_html()); ?></span>
                        </div>
                    </a>
                </div>
            </div>
            <?php
        }
    }
endif;

if(!function_exists('zella_prev_product')) :
    function zella_prev_product() {
        $prev_post = get_previous_post(true, '', 'product_cat');
        if (is_a($prev_post, 'WP_Post')) {
            $product_obj = new WC_Product($prev_post->ID);
            $title = get_the_title($prev_post->ID);
            $link = get_the_permalink($prev_post->ID);
            ?>
            <div class="prev-product next-prev-buttons">
                <a href="<?php echo esc_url($link); ?>" rel="prev" class="icon-next-prev pe-7s-angle-left prev" title="<?php echo esc_attr($title); ?>"></a>
                <div class="dropdown-wrap">
                    <a title="<?php echo esc_attr($title); ?>" href="<?php echo esc_url($link); ?>">
                        <?php echo get_the_post_thumbnail($prev_post->ID, apply_filters('single_product_small_thumbnail_size', 'shop_thumbnail')); ?>
                        <div>
                            <span class="product-name"><?php echo zella_str($title); ?></span>
                            <span class="price"><?php echo zella_str($product_obj->get_price_html()); ?></span>
                        </div>
                    </a>
                </div>
            </div>
            <?php
        }
    }
endif;

/* ==========================================================================
 * ADD VIDEO PLAY BUTTON ON PRODUCT DETAIL PAGE
 * ======================================================================= */
add_action('product_video_btn', 'zella_product_video_btn_function', 1);
if (!function_exists('zella_product_video_btn_function')) {

    function zella_product_video_btn_function() {
        $id = get_the_ID();
        if ($video_link = zella_custom_field_value($id, '_product_video_link')) {
            ?>
            <a class="product-video-popup tip-top" data-tip="<?php esc_attr_e('View video', 'zella-theme'); ?>" href="<?php echo esc_url($video_link); ?>">
                <span class="pe-7s-play"></span>
                <span class="nasa-play-video-text"><?php esc_html_e('Play Video', 'zella-theme'); ?></span>
            </a>

            <?php
            $height = '800';
            $width = '800';
            $iframe_scale = '100%';
            $custom_size = zella_custom_field_value($id, '_product_video_size');
            if ($custom_size) {
                $split = explode("x", $custom_size);
                $height = $split[0];
                $width = $split[1];
                $iframe_scale = ($width / $height * 100) . '%';
            }
            $style = '.has-product-video .mfp-iframe-holder .mfp-content{max-width: ' . $width . 'px;}';
            $style .= '.has-product-video .mfp-iframe-scaler{padding-top: ' . $iframe_scale . ';}';
            wp_add_inline_style('product_detail_css_custom', $style);
        }
    }
}

/*
 * Add wishlist in list
 */
if(!function_exists('zella_add_wishlist_in_list')) :
    function zella_add_wishlist_in_list() {
        if(NASA_WISHLIST_ENABLE) {
            global $product, $yith_wcwl;
            if(!$yith_wcwl) {
                return;
            }
            $variation = false;
            $productId = $product->get_id();
            if($product->get_type() == 'variation') {
                $variation_product = $product;
                $productId = wp_get_post_parent_id($productId);
                $product = $GLOBALS['product'] = wc_get_product($productId);
                $variation = true;
            }

            ?>
            <a href="javascript:void(0);" class="btn-wishlist nasa-like-animation tip-top" data-prod="<?php echo (int) $productId; ?>" data-tip="<?php esc_attr_e('Wishlist', 'zella-theme'); ?>" title="<?php esc_attr_e('Wishlist', 'zella-theme'); ?>">
                <div class="btn-link">
                    <div class="wishlist-icon">
                        <span class="nasa-icon nasa-bg-like"></span>
                        <span class="nasa-icon icon-nasa-like"></span>
                        <span class="hidden-tag nasa-icon-text no-added"><?php esc_html_e('Wishlist', 'zella-theme'); ?></span>
                    </div>
                </div>
            </a>
            <div class="add-to-link hidden-tag">
                <?php echo do_shortcode('[yith_wcwl_add_to_wishlist]'); ?>
            </div>

            <?php

            if($variation) {
                $GLOBALS['product'] = $variation_product;
            }
        }
    }
endif;

/*
 * Add wishlist in list
 */
if(!function_exists('zella_add_wishlist_in_detail')) :
    function zella_add_wishlist_in_detail() {
        echo '<div class="product-interactions">';
            zella_add_wishlist_in_list();
        echo '</div>';
    }
endif;

/*
 * Quickview in list
 */
if(!function_exists('zella_quickview_in_list')) :
    function zella_quickview_in_list() {
        global $product;
        $type = $product->get_type();
        ?>
        <a href="javascript:void(0);" class="quick-view tip-top<?php echo !NASA_WISHLIST_ENABLE ? ' nasa-no-wishlist' : ''; ?>" data-prod="<?php echo (int) $product->get_id(); ?>" data-tip="<?php echo $type !== 'woosb' ? esc_attr__('Quick View', 'zella-theme') : esc_attr__('View', 'zella-theme'); ?>" title="<?php echo $type !== 'woosb' ? esc_attr__('Quick View', 'zella-theme') : esc_attr__('View', 'zella-theme'); ?>" data-product_type="<?php echo esc_attr($type); ?>" data-href="<?php the_permalink(); ?>">
            <div class="btn-link">
                <div class="quick-view-icon">
                    <span class="pe-icon pe-7s-look"></span>
                    <span class="hidden-tag nasa-icon-text"><?php echo $type !== 'woosb' ? esc_html__('Quick View', 'zella-theme') : esc_html__('View', 'zella-theme'); ?></span>
                </div>
            </div>
        </a>
        <?php
    }
endif;

/*
 * Add to cart in list
 */
if(!function_exists('zella_add_to_cart_in_list')) :
    function zella_add_to_cart_in_list() {
        zella_add_to_cart_btn('small');
    }
endif;

/*
 * Gift icon in list
 */
if(!function_exists('zella_bundle_in_list')) :
    function zella_bundle_in_list($combo_show_type) {
        global $product;
        if(!defined('YITH_WCPB') || $product->get_type() != NASA_COMBO_TYPE) {
            return;
        }
        ?>
        <div class="btn-combo-link tip-top" data-prod="<?php echo (int) $product->get_id(); ?>" data-tip="<?php esc_attr_e('Promotion Gifts', 'zella-theme'); ?>" title="<?php esc_attr_e('Promotion Gifts', 'zella-theme'); ?>" data-show_type="<?php echo esc_attr($combo_show_type); ?>">
            <div class="btn-link">
                <div class="gift-icon">
                    <span class="pe-icon pe-7s-gift"></span>
                    <span class="hidden-tag nasa-icon-text"><?php esc_html_e('Promotion Gifts', 'zella-theme'); ?></span>
                </div>
            </div>
        </div>
        <?php
    }
endif;

/*
 * Nasa Gift icon Featured
 */
if(!function_exists('zella_gift_featured')) :
    function zella_gift_featured() {
        global $product, $nasa_opt;
        
        if(isset($nasa_opt['enable_gift_featured']) && !$nasa_opt['enable_gift_featured']) {
            return;
        }
        
        $product_type = $product->get_type();
        if(!defined('YITH_WCPB') || $product_type != NASA_COMBO_TYPE) {
            return;
        }
        
        $class_effect = isset($nasa_opt['enable_gift_effect']) && $nasa_opt['enable_gift_effect'] == 1 ? '' : ' nasa-transition';
        
        echo 
        '<div class="nasa-gift-featured-wrap">' .
            '<div class="nasa-gift-featured">' .
                '<div class="gift-icon">' .
                    '<a href="javascript:void(0);" class="nasa-gift-featured-event' . $class_effect . '" title="' . esc_attr__('View the promotion gifts', 'zella-theme') . '">' .
                        '<span class="pe-icon pe-7s-gift"></span>' .
                        '<span class="hidden-tag nasa-icon-text">' . 
                            esc_html__('Promotion Gifts', 'zella-theme') . 
                        '</span>' .
                    '</a>' .
                '</div>' .
            '</div>' .
        '</div>';
    }
endif;

/*
 * Add compare in list
 */
if(!function_exists('zella_add_compare_in_list')) :
    function zella_add_compare_in_list() {
        global $product, $nasa_opt;
        $productId = $product->get_id();
        
        $nasa_compare = (!isset($nasa_opt['nasa-product-compare']) || $nasa_opt['nasa-product-compare']) ? true : false;
        ?>
        <a href="javascript:void(0);" class="btn-compare tip-top<?php echo !$nasa_compare ? '' : ' nasa-compare'; ?>" data-prod="<?php echo (int) $productId; ?>" data-tip="<?php esc_attr_e('Compare', 'zella-theme'); ?>" title="<?php esc_attr_e('Compare', 'zella-theme'); ?>">
            <div class="btn-link">
                <div class="compare-icon">
                    <span class="nasa-icon icon-nasa-refresh"></span>
                    <span class="hidden-tag nasa-icon-text"><?php esc_html_e('Compare', 'zella-theme'); ?></span>
                </div>
            </div>
        </a>
        
        <?php if(!$nasa_compare) : ?>
            <div class="add-to-link hidden-tag">
                <div class="woocommerce-compare-button">
                    <?php echo do_shortcode('[yith_compare_button]'); ?>
                </div>
            </div>
        <?php endif;
    }
endif;

/*
 * Add compare in detail
 */
if(!function_exists('zella_add_compare_in_detail')) :
    function zella_add_compare_in_detail() {
        global $product, $nasa_opt;
        $productId = $product->get_id();
        
        $nasa_compare = (!isset($nasa_opt['nasa-product-compare']) || $nasa_opt['nasa-product-compare']) ? true : false;
        ?>
        <div class="product-interactions">
            <a href="javascript:void(0);" class="btn-compare<?php echo !$nasa_compare ? '' : ' nasa-compare'; ?> tip-top" data-prod="<?php echo (int) $productId; ?>" data-tip="<?php esc_attr_e('Compare', 'zella-theme'); ?>" title="<?php esc_attr_e('Compare', 'zella-theme'); ?>">
                <div class="btn-link">
                    <div class="compare-icon">
                        <span class="nasa-icon icon-nasa-compare-2"></span>
                        <span class="nasa-icon-text"><?php esc_html_e('Add to Compare', 'zella-theme'); ?></span>
                    </div>
                </div>
            </a>
        
            <?php if(!$nasa_compare) : ?>
                <div class="add-to-link hidden-tag">
                    <div class="woocommerce-compare-button">
                        <?php echo do_shortcode('[yith_compare_button]'); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    <?php
    }
endif;

if(!function_exists('zella_single_availability')) :
    function zella_single_availability() {
        global $product;
        // Availability
        $availability = $product->get_availability();

        if ($availability['availability']) :
            echo apply_filters('woocommerce_stock_html', '<p class="stock ' . esc_attr($availability['class']) . '">' . wp_kses(__('<span>Availability:</span> ', 'zella-theme'), array('span' => array())) . esc_html($availability['availability']) . '</p>', $availability['availability']);
        endif;
    }
endif;

// custom fields product
if(!function_exists('zella_add_custom_field_detail_product')) :
    function zella_add_custom_field_detail_product() {
        global $product, $product_lightbox;
        if($product_lightbox) {
            $product = $product_lightbox;
        }
        
        $product_type = $product->get_type();
        
        // 'woosb' Bundle product
        if(
            in_array($product_type, array('external', 'woosb')) ||
            (!defined('YITH_WCPB') && $product_type == NASA_COMBO_TYPE)) {
            return;
        }
        
        global $nasa_opt;

        $nasa_btn_ajax_value = ('yes' === get_option('woocommerce_enable_ajax_add_to_cart') && (!isset($nasa_opt['enable_ajax_addtocart']) || $nasa_opt['enable_ajax_addtocart'] == '1')) ? '1' : '0';
        echo '<div class="nasa-custom-fields hidden-tag">';
        echo '<input type="hidden" name="nasa-enable-addtocart-ajax" value="' . $nasa_btn_ajax_value . '" />';
        echo '<input type="hidden" name="data-product_id" value="' . esc_attr($product->get_id()) . '" />';
        echo '<input type="hidden" name="data-type" value="' . esc_attr($product_type) . '" />';
        echo '<input type="hidden" name="data-from_wishlist" value="' . ((isset($_REQUEST['nasa_wishlist']) && $_REQUEST['nasa_wishlist'] == '1') ? '1' : '0') . '" />';
        echo '</div>';
    }
endif;

if(!function_exists('zella_single_hr')) :
    function zella_single_hr() {
        echo '<hr class="nasa-single-hr" />';
    }
endif;

if(!function_exists('zella_price_list_loop')) :
    function zella_price_list_loop() {
        wc_get_template('loop/price.php');
    }
endif;

/**
 * Before - After wrap extra buttons (quick view - wishlist - combo)
 */
if(!function_exists('zella_before_wrap_extra_btn')) :
    function zella_before_wrap_extra_btn() {
        echo '<div class="nasa-wrap-extra-btns"><div class="nasa-inner-extra-btns">';
    }
endif;

if(!function_exists('zella_after_wrap_extra_btn')) :
    function zella_after_wrap_extra_btn() {
        echo '</div></div>';
    }
endif;

/**
 * Toggle coupon
 */
if(!function_exists('zella_wrap_coupon_toggle')) :
    function zella_wrap_coupon_toggle($content) {
        return '<div class="nasa-toggle-coupon-checkout text-right">' . $content . '</div>';
    }
endif;

/**
 * Images in content product
 */
if(!function_exists('zella_loop_product_content_thumbnail')) :
    function zella_loop_product_content_thumbnail() {
        global $product, $nasa_animated_products;
        
        $nasa_link = $product->get_permalink(); // permalink
        $nasa_title = $product->get_name(); // Title
        $main_img = $product->get_image('shop_catalog');
        
        /**
         *  $attachment_ids = !NASA_IS_PHONE ? $product->get_gallery_image_ids() : false;
         */
        $attachment_ids = $nasa_animated_products != '' ? $product->get_gallery_image_ids() : false;
        ?>
        <div class="product-img">
            <a href="<?php echo esc_url($nasa_link); ?>" title="<?php echo esc_attr($nasa_title); ?>">
                <div class="main-img"><?php echo zella_str($main_img); ?></div>
                <?php if ($attachment_ids) :
                    foreach ($attachment_ids as $attachment_id) :
                        $image_link = wp_get_attachment_url($attachment_id);
                        if (!$image_link):
                            continue;
                        endif;
                        printf('<div class="back-img back">%s</div>', wp_get_attachment_image($attachment_id, 'shop_catalog'));
                        break;
                    endforeach;
                endif; ?>
            </a>
        </div>
    <?php
    }
endif;

/**
 * Buttons in content product
 */
if(!function_exists('zella_loop_product_content_btns')) :
    function zella_loop_product_content_btns() {
        echo '<div class="nasa-product-grid nasa-btns-product-item">';
        echo zella_product_group_button('popup');
        echo '</div>';
    }
endif;

/**
 * Categories in content product
 */
if(!function_exists('zella_loop_product_cats')) :
    function zella_loop_product_cats() {
        global $product;
        echo '<div class="nasa-list-category hidden-tag">';
        echo wc_get_product_category_list($product->get_id(), ', ');
        echo '</div>';
    }
endif;

/**
 * Title in content product
 */
if(!function_exists('zella_loop_product_content_title')) :
    function zella_loop_product_content_title() {
        global $product, $nasa_opt;
        
        $nasa_link = $product->get_permalink(); // permalink
        $nasa_title = $product->get_name(); // Title
        $class_title = (!isset($nasa_opt['cutting_product_name']) || $nasa_opt['cutting_product_name'] == '1') ? ' nasa-show-one-line' : '';
        ?>
        <div class="name<?php echo esc_attr($class_title); ?>">
            <a href="<?php echo esc_url($nasa_link); ?>" title="<?php echo esc_attr($nasa_title); ?>">
                <?php echo zella_str($nasa_title); ?>
            </a>
        </div>
    <?php
    }
endif;

/**
 * Price in content product
 */
if(!function_exists('zella_loop_product_price')) :
    function zella_loop_product_price() {
        echo '<div class="price-wrap">';
        woocommerce_template_loop_price();
        echo '</div>';
    }
endif;

/**
 * Description in content product
 */
if(!function_exists('zella_loop_product_description')) :
    function zella_loop_product_description() {
        global $post;
        echo 
        '<div class="info_main product-des-wrap">' .
            '<hr class="nasa-list-hr hidden-tag" />' .
            '<div class="product-des">' .
                apply_filters('woocommerce_short_description', $post->post_excerpt) .
            '</div>' .
        '</div>';
    }
endif;

if (!function_exists('zella_combo_tab')) :
    function zella_combo_tab($nasa_viewmore = true) {
        global $woocommerce, $nasa_opt, $product;

        if (!$woocommerce || !$product || $product->get_type() != NASA_COMBO_TYPE || !($combo = $product->get_bundled_items())) {
            return false;
        }

        $file = ZELLA_CHILD_PATH . '/includes/nasa-combo-products-in-detail.php';
        $file = is_file($file) ? $file : ZELLA_THEME_PATH . '/includes/nasa-combo-products-in-detail.php';
        ob_start();
        include $file;

        return ob_get_clean();
    }
endif;

/**
 * nasa product budles in quickview
 */
if(!function_exists('zella_combo_in_quickview')) :
    function zella_combo_in_quickview() {
        global $woocommerce, $nasa_opt, $product;

        if (!$woocommerce || !$product || $product->get_type() != NASA_COMBO_TYPE || !($combo = $product->get_bundled_items())) {
            echo '';
        }
        else {
            $file = ZELLA_CHILD_PATH . '/includes/nasa-combo-products-quickview.php';
            $file = is_file($file) ? $file : ZELLA_THEME_PATH . '/includes/nasa-combo-products-quickview.php';

            include $file;
        }
    }
endif;

/**
 * nasa_top_sidebar_shop
 */
if(!function_exists('zella_top_sidebar_shop')) :
    function zella_top_sidebar_shop($nasa_sidebar = 'top-1') {
        $class = 'large-12 columns nasa-top-sidebar nasa-relative';
        switch ($nasa_sidebar) :
            case 'top-1' :
                $class .= ' nasa-top-1';
                break;
            
            case 'top-2' :
                $class .= ' nasa-top-2 hidden-tag';
                break;
            
            default:
                return;
        endswitch;
    
        $sidebar_run = 'shop-sidebar';
        if(is_tax('product_cat')) {
            global $wp_query;
            $query_obj = $wp_query->get_queried_object();
            $sidebar_cats = get_option('nasa_sidebars_cats');
            if(isset($sidebar_cats[$query_obj->slug])) {
                $sidebar_run = $query_obj->slug;
            }
        } ?>

        <div class="<?php echo esc_attr($class); ?>">
            <div class="row">
                <?php
                if (is_active_sidebar($sidebar_run)) :
                    dynamic_sidebar($sidebar_run);
                endif;
                ?>
            </div>
        </div>
    <?php
    }
endif;

/**
 * nasa_sidebar_shop
 */
if(!function_exists('zella_side_sidebar_shop')) :
    function zella_side_sidebar_shop($nasa_sidebar = 'left') {
        switch ($nasa_sidebar) :
            case 'left' :
                $class = 'nasa-side-sidebar nasa-sidebar-left';
                break;
            
            case 'right' :
                $class = 'nasa-side-sidebar nasa-sidebar-right';
                break;
            
            case 'left-classic' :
                $class = 'large-3 left columns col-sidebar';
                break;
            
            case 'right-classic' :
                $class = 'large-3 right columns col-sidebar';
                break;
            
            default:
                return;
        endswitch;
        
        $sidebar_run = 'shop-sidebar';
        if(is_tax('product_cat')) {
            global $wp_query;
            $query_obj = $wp_query->get_queried_object();
            $sidebar_cats = get_option('nasa_sidebars_cats');
            if(isset($sidebar_cats[$query_obj->slug])) {
                $sidebar_run = $query_obj->slug;
            }
        }
        ?>
        
        <div class="<?php echo esc_attr($class); ?>">
            <?php
            if (is_active_sidebar($sidebar_run)) :
                dynamic_sidebar($sidebar_run);
            endif;
            ?>
        </div>
    <?php
    }
endif;

/**
 * Sale flash
 */
if(!function_exists('zella_filter_sale_flash')):
    function zella_filter_sale_flash() {
        return '';
    }
endif;

if(!function_exists('zella_add_custom_sale_flash')) :
    function zella_add_custom_sale_flash() {
        global $product;
        if ($nasa_bubble_hot = zella_custom_field_value($product->get_id(), '_bubble_hot')):
            ?>
            <div class="badge">
                <div class="badge-inner hot-label">
                    <div class="inner-text">
                        <?php echo zella_str($nasa_bubble_hot); ?>
                    </div>
                </div>
            </div>
            <?php
        endif;

        if ($product->is_on_sale()): ?>
            <div class="badge deal-label-outner">
                <div class="badge-inner deal-label">
                    <div class="inner-text">
                        <?php echo esc_html__('LIMITED', 'zella-theme'); ?>
                    </div>
                </div>
            </div>

            <?php
            $product_type = $product->get_type();
            if ($product_type == 'variable') :
                ?>
                <div class="badge">
                    <div class="badge-inner sale-label">
                        <div class="inner-text">
                            <span class="sale-label-text sale-variable"><?php echo esc_html__('SALE', 'zella-theme'); ?></span>
                        </div>
                    </div>
                </div>
            <?php else :
                $maximumper = 0;
                $regular_price = $product->get_regular_price();
                $sales_price = $product->get_sale_price();
                if(is_numeric($sales_price)) :
                    $percentage = $regular_price ? round(((($regular_price - $sales_price) / $regular_price) * 100), 0) : 0;
                    if ($percentage > $maximumper) :
                        $maximumper = $percentage;
                    endif;
                    ?>
                    <div class="badge">
                        <div class="badge-inner sale-label">
                            <div class="inner-text">
                                <span class="sale-label-text"><?php echo esc_html__('SALE', 'zella-theme'); ?></span>
                                <?php echo '-' . sprintf(esc_html__('%s', 'zella-theme'), $maximumper) . '%'; ?>
                            </div>
                        </div>
                    </div>
                    <?php
                endif;
            endif;
        endif;
        
        $stock_status = $product->get_stock_status();
        if ($stock_status == "outofstock"): ?>
            <div class="badge">
                <div class="badge-inner out-of-stock-label">
                    <div class="inner-text"><?php esc_html_e('Sold Out', 'zella-theme'); ?></div>
                </div>
            </div>
        <?php endif;
    }
endif;

/**
 * Get All categories product filter in top
 */
if(!function_exists('zella_all_categories')) :
    function zella_all_categories($only_show_child = false, $main = false, $hierarchical = true, $order = 'order') {
        if(!NASA_WOO_ACTIVED) {
            return;
        }
        
        if(!$only_show_child) {
            global $nasa_top_filter;
        }
        
        if(!isset($nasa_top_filter)) {
            global $nasa_opt, $wp_query, $post;

            $current_cat = false;
            $cat_ancestors = array();
            
            $rootId = 0;
            if (is_tax('product_cat')) {
                $current_cat = $wp_query->queried_object;
                $cat_ancestors = get_ancestors($current_cat->term_id, 'product_cat');
            } elseif (is_singular('product')) {
                $productId = isset($wp_query->queried_object->ID) ? $wp_query->queried_object->ID : $post->ID;
                
                $product_category = wc_get_product_terms($productId, 'product_cat', array(
                    'orderby' => 'parent',
                    'order'   => 'DESC'
                ));
                
                if ($product_category) {
                    $main_term = apply_filters('woocommerce_product_categories_widget_main_term', $product_category[0], $product_category);
                    $current_cat = $main_term;
                    $cat_ancestors = get_ancestors($main_term->term_id, 'product_cat');
                }
            }
            
            if($only_show_child && $current_cat && $current_cat->term_id) {
                $terms_chilren = get_terms(apply_filters('woocommerce_product_attribute_terms', array(
                    'taxonomy' => 'product_cat',
                    'parent' => $current_cat->term_id,
                    'hierarchical' => $hierarchical,
                    'hide_empty' => false
                )));

                if(! $terms_chilren) {
                    $term_root = get_ancestors($current_cat->term_id, 'product_cat');
                    $rootId = isset($term_root[0]) ? $term_root[0] : $rootId;
                } else {
                    $rootId = $current_cat->term_id;
                }
            }
            
            elseif((isset($nasa_opt['disable_top_level_cat']) && $nasa_opt['disable_top_level_cat'])) {
                $rootId = $cat_ancestors ? end($cat_ancestors) : ($current_cat ? $current_cat->term_id : $rootId);
            }
            
            $menu_cat = new Zella_Product_Cat_List_Walker();
            $args = array(
                'taxonomy' => 'product_cat',
                'show_count' => 0,
                'hierarchical' => 1,
                'hide_empty' => false
            );
            
            $args['menu_order'] = false;
            if ($order == 'order') {
                $args['menu_order'] = 'asc';
            } else {
                $args['orderby'] = 'title';
            }
            
            $args['walker'] = $menu_cat;
            $args['title_li'] = '';
            $args['pad_counts'] = 1;
            $args['show_option_none'] = esc_html__('No product categories exist.', 'zella-theme');
            $args['current_category'] = $current_cat ? $current_cat->term_id : '';
            $args['current_category_ancestors'] = $cat_ancestors;
            $args['child_of'] = $rootId;
            
            if(version_compare(wc()->version, '3.3.0', ">=") && (!isset($nasa_opt['show_uncategorized']) || !$nasa_opt['show_uncategorized'])) {
                $args['exclude'] = get_option('default_product_cat');
            }

            $nasa_top_filter = '<ul class="nasa-top-cat-filter product-categories nasa-accordion">';
            
            ob_start();
            wp_list_categories(apply_filters('woocommerce_product_categories_widget_args', $args));
            $nasa_top_filter .= ob_get_clean();
            
            $nasa_top_filter .= '<li class="nasa-current-note"></li>';
            $nasa_top_filter .= '</ul>';
            
            if(!$only_show_child) {
                $GLOBALS['nasa_top_filter'] = $nasa_top_filter;
            }
        }
        
        $result = $nasa_top_filter;
        if($main) {
            $result = '<div id="nasa-main-cat-filter">' . $result . '</div>';
        }
        
        return $result;
    }
endif;

/**
 * zella_nasa_change_view
 */
if(!function_exists('zella_nasa_change_view')) :
    function zella_nasa_change_view($nasa_change_view = true, $typeShow = 'grid-5') {
        if(!$nasa_change_view) :
            return;
        endif;
        
        $maxColumns = apply_filters('nasa_change_view_max_coulumns', '6');
        $maxColumns = (int)$maxColumns > 6 ? 6 : ((int)$maxColumns < 3 ? 3 : (int)$maxColumns);
        
        $changeView = '<ul class="filter-tabs">';
        for ($i = $maxColumns; $i >= 3; $i--) :
            $changeView .= 
                '<li class="nasa-change-layout productGrid grid-' . $i . (($typeShow == 'grid-' . $i) ? ' active' : '') . '" data-columns="' . $i . '">' .
                    '<i class="icon-nasa-' . $i . 'column"></i>' .
                '</li>';
        endfor;
        $changeView .= 
            '<li class="nasa-change-layout productList list' . (($typeShow == 'list') ? ' active' : '') . '" data-columns="1">' .
                '<i class="icon-nasa-list"></i>' .
            '</li>';
        $changeView .= '</ul>';
        
        echo zella_str($changeView);
    }
endif;

/**
 * Remove wishlit btn in detail product
 */
if(!function_exists('zella_remove_btn_wishlist_single_product')) :
    function zella_remove_btn_wishlist_single_product($hook) {
        $hook['add-to-cart'] = array('hook' => '', 'priority' => 0);
        return $hook;
    }
endif;

/**
 * Add class to body for page product
 */
if(!function_exists('zella_product_body_add_class')) :
    function zella_product_body_add_class($classes) {
        if (NASA_WOO_ACTIVED) {
            if(is_product()) {
                $classes[] = 'nasa-page-single-product';
                /**
                 * Layout: New | Classic
                 */
                global $nasa_opt;
                
                $layout = (isset($nasa_opt['product_detail_layout']) && in_array($nasa_opt['product_detail_layout'], array('full', 'new', 'classic'))) ? $nasa_opt['product_detail_layout'] : 'full';
                $layout = (isset($_REQUEST['layout']) && in_array($_REQUEST['layout'], array('full', 'new', 'classic'))) ? $_REQUEST['layout'] : $layout;

                $classes[] = $layout === 'full' ? 'nasa-single-product-full-width' : 'nasa-single-product-wide';
            }
            
            if (is_post_type_archive('product') || is_tax(get_object_taxonomies('product'))) {
                $classes[] = 'nasa-page-products';
            }
        }
        
        return $classes;
    }
endif;

/**
 * zella_single_product_layout
 */
if(!function_exists('zella_single_product_layout')) :
    function zella_single_product_layout() {
        global $product, $nasa_opt;

        /**
         * Layout: New | Classic
         */
        $layout = (isset($nasa_opt['product_detail_layout']) && in_array($nasa_opt['product_detail_layout'], array('full', 'new', 'classic'))) ? $nasa_opt['product_detail_layout'] : 'full';
        $layout = (isset($_REQUEST['layout']) && in_array($_REQUEST['layout'], array('full', 'new', 'classic'))) ? $_REQUEST['layout'] : $layout;
        $alignment = '';

        /**
         * Image Layout Style
         */
        if ($layout == 'full') {
            $image_layout = 'full-row';
            $image_style = 'slide';
            // Remove thumbs
            remove_action('woocommerce_product_thumbnails', 'woocommerce_show_product_thumbnails', 20);
            $alignment = ' text-' . (isset($nasa_opt['product_info_align']) ? $nasa_opt['product_info_align'] : 'center');
        }
        
        else {
            $image_layout = (!isset($nasa_opt['product_image_layout']) || $nasa_opt['product_image_layout'] == 'double') ? 'double' : 'single';
            $image_layout = (isset($_REQUEST['image-layout']) && in_array($_REQUEST['image-layout'], array('double', 'single'))) ? $_REQUEST['image-layout'] : $image_layout;
            $image_style = 'slide';
            if($layout == 'new') {
                $image_style = (!isset($nasa_opt['product_image_style']) || $nasa_opt['product_image_style'] == 'slide') ? 'slide' : 'scroll';
                $image_style = (isset($_REQUEST['image-style']) && in_array($_REQUEST['image-style'], array('slide', 'scroll'))) ? $_REQUEST['image-style'] : $image_style;
            }
        }

        $nasa_sidebar = isset($nasa_opt['product_sidebar']) ? $nasa_opt['product_sidebar'] : 'no';
        $nasa_actsidebar = is_active_sidebar('product-sidebar');

        // Check $_GET['sidebar']
        if (isset($_GET['sidebar'])):
            switch ($_GET['sidebar']) :
                case 'right' :
                    $nasa_sidebar = 'right';
                    break;

                case 'left' :
                    $nasa_sidebar = 'left';
                    break;

                case 'no' :
                default:
                    $nasa_sidebar = 'no';
                    break;
            endswitch;
        endif;

        // Class
        switch ($nasa_sidebar) :
            case 'right' :
                if($layout == 'classic') {
                    $main_class = 'large-9 columns left';
                    $bar_class = 'large-3 columns desktop-padding-left-30 col-sidebar product-sidebar-right right';
                } else {
                    $main_class = 'large-12 columns';
                    $bar_class = 'nasa-side-sidebar nasa-sidebar-right';
                }

                break;

            case 'no' :
                $main_class = 'large-12 columns';
                $bar_class = '';
                break;

            default:
            case 'left' :
                if($layout == 'classic') {
                    $main_class = 'large-9 columns right';
                    $bar_class = 'large-3 columns desktop-padding-right-30 col-sidebar product-sidebar-left left';
                }  else {
                    $main_class = 'large-12 columns';
                    $bar_class = 'nasa-side-sidebar nasa-sidebar-left';
                }

                break;

        endswitch;
        
        $main_class .= ' nasa-single-product-' . $image_style;
        $main_class .= $image_style == 'scroll' && $image_layout == 'double' ? ' nasa-single-product-2-columns': '';
        
        $file = ZELLA_CHILD_PATH . '/includes/nasa-single-product-' . $layout . '.php';
        $file = is_file($file) ? $file : ZELLA_THEME_PATH . '/includes/nasa-single-product-' . $layout . '.php';
        
        include_once $file;
    }
endif;

/**
 * nasa_archive_get_sub_categories
 */
add_action('nasa_archive_get_sub_categories', 'nasa_archive_get_sub_categories');
if(!function_exists('nasa_archive_get_sub_categories')) :
    function nasa_archive_get_sub_categories() {
        $GLOBALS['nasa_cat_loop_delay'] = 0;
        
        echo '<div class="nasa-archive-sub-categories-wrap">';
        woocommerce_product_subcategories(array(
            'before' => '<div class="row"><div class="large-12 columns"><h3>' . esc_html__('Subcategories: ', 'zella-theme') . '</h3></div></div><div class="row">',
            'after' => '</div><div class="row"><div class="large-12 columns margin-bottom-20 margin-top-20 text-center"><hr class="margin-left-20 margin-right-20" /></div></div>'
        ));
        echo '</div>';
    }
endif;

if(!function_exists('zella_maybe_show_product_subcategories') && NASA_WOO_ACTIVED && version_compare(wc()->version, '3.3.0', ">=")) :
    function zella_maybe_show_product_subcategories($loop_html) {
        $display_type = woocommerce_get_loop_display_mode();
        
        // If displaying categories, append to the loop.
        if ('subcategories' === $display_type || 'both' === $display_type) {
            $before = '<div class="row"><div class="large-12 columns"><h3>' . esc_html__('Subcategories: ', 'zella-theme') . '</h3></div></div><div class="row">';
            $after = '</div><div class="row"><div class="large-12 columns margin-bottom-20 margin-top-20 text-center"><hr class="margin-left-20 margin-right-20" /></div></div>';
            ob_start();
            woocommerce_output_product_categories(array(
                'parent_id' => is_product_category() ? get_queried_object_id() : 0,
            ));
            $loop_html .= $before . ob_get_clean() . $after;

            if ('subcategories' === $display_type) {
                wc_set_loop_prop('total', 0);

                // This removes pagination and products from display for themes not using wc_get_loop_prop in their product loops. @todo Remove in future major version.
                global $wp_query;

                if ($wp_query->is_main_query()) {
                    $wp_query->post_count    = 0;
                    $wp_query->max_num_pages = 0;
                }
            }
        }

        return $loop_html;
    }
endif;

/**
 * Hide Uncategorized
 */
if(!function_exists('zella_hide_uncategorized')) :
    function zella_hide_uncategorized($args) {
        $args['exclude'] = get_option('default_product_cat');
        return $args;
    }
endif;

/**
 * Pagination product pages
 */
if(!function_exists('zella_pagination_ajax')) :
    function zella_pagination_ajax(
        $total = 1,
        $current = 1,
        $type = 'list',
        $prev_text = 'PREV', 
        $next_text = 'NEXT',
        $end_size = 3, 
        $mid_size = 3,
        $prev_next = true,
        $show_all = false
    ) {

        if ($total < 2) {
            return;
        }

        if ($end_size < 1) {
            $end_size = 1;
        }

        if ($mid_size < 0) {
            $mid_size = 2;
        }

        $r = '';
        $page_links = array();

        // PREV Button
        if ($prev_next && $current && 1 < $current){
            $page_links[] = '<a class="nasa-prev prev page-numbers" data-page="' . ((int)$current - 1) . '" href="javascript:void(0);">' . $prev_text . '</a>';
        }

        // PAGE Button
        $moreStart = false;
        $moreEnd = false;
        for ($n = 1; $n <= $total; $n++){
            $page = number_format_i18n($n);
            if ($n == $current){
                $page_links[] = '<a class="nasa-current current page-numbers" data-page="' . $page . '" href="javascript:void(0);">' . $page . '</a>';
            }
            
            else {
                if ($show_all || ($current && $n >= $current - $mid_size && $n <= $current + $mid_size)) {
                    $page_links[] = '<a class="nasa-page page-numbers" data-page="' . $page . '" href="javascript:void(0);">' . $page . "</a>";
                }
                
                elseif ($n == 1 || $n == $total) {
                    $page_links[] = '<a class="nasa-page page-numbers" data-page="' . $page . '" href="javascript:void(0);">' . $page . "</a>";
                }
                
                elseif (!$moreStart && $n <= $end_size + 1) {
                    $moreStart = true;
                    $page_links[] = '<span class="nasa-page-more">' . esc_html__('...', 'zella-theme') . '</span>';
                }
                
                elseif (!$moreEnd && $n > $total - $end_size - 1) {
                    $moreEnd = true;
                    $page_links[] = '<span class="nasa-page-more">' . esc_html__('...', 'zella-theme') . '</span>';
                }
            }
        }

        // NEXT Button
        if ($prev_next && $current && ($current < $total || -1 == $total)){
            $page_links[] = '<a class="nasa-next next page-numbers" data-page="' . ((int)$current + 1)  . '" href="javascript:void(0);">' . $next_text . '</a>';
        }

        // DATA Return
        switch ($type) {
            case 'array' :
                return $page_links;

            case 'list' :
                $r .= '<ul class="page-numbers nasa-pagination-ajax"><li>';
                $r .= implode('</li><li>', $page_links);
                $r .= '</li></ul>';
                break;

            default :
                $r = implode('', $page_links);
                break;
        }

        return $r;
    }
endif;

/**
 * Before Share WooCommerce
 */
if(!function_exists('zella_before_woocommerce_share')) :
    function zella_before_woocommerce_share() {
        echo '<hr class="nasa-single-hr" /><div class="nasa-single-share">';
    }
endif;

/**
 * Custom Share WooCommerce
 */
if(!function_exists('zella_woocommerce_share')) :
    function zella_woocommerce_share() {
        echo shortcode_exists('nasa_share') ? do_shortcode('[nasa_share]') : '';
    }
endif;

/**
 * After Share WooCommerce
 */
if(!function_exists('zella_after_woocommerce_share')) :
    function zella_after_woocommerce_share() {
        echo '</div>';
    }
endif;
