<?php

/**
 * Render Time sale Countdown
 */
if(!function_exists('zella_time_sale')) :
    function zella_time_sale($time_sale) {
        return $time_sale ? 
        '<div class="nasa-sc-pdeal-countdown">' .
            '<span class="countdown" data-countdown="' . esc_attr(get_date_from_gmt(date('Y-m-d H:i:s', $time_sale), 'M j Y H:i:s O')) . '"></span>' .
        '</div>' : '';
    }
endif;

// **********************************************************************//
// ! Get logo
// **********************************************************************//
if (!function_exists('zella_logo')) :

    function zella_logo($h1 = false) {
        global $nasa_logo;
        $h1 = apply_filters('nasa_logo_h1_tag', $h1);
        
        if(!isset($nasa_logo) || !$nasa_logo) {
            global $nasa_opt, $wp_query;
            
            $logo_link = get_post_meta($wp_query->get_queried_object_id(), '_nasa_custom_logo', true);
            if ($logo_link == '') {
                $logo_link = isset($nasa_opt['site_logo']) ? $nasa_opt['site_logo'] : '';
            }
            
            $logo_retina = get_post_meta($wp_query->get_queried_object_id(), '_nasa_custom_logo_retina', true);
            if ($logo_retina == '') {
                $logo_retina = isset($nasa_opt['site_logo_retina']) ? $nasa_opt['site_logo_retina'] : '';
            }

            $content = '<a class="logo nasa-logo-retina" href="' . esc_url(home_url('/')) . '" title="' . get_bloginfo('name', 'display') . ' - ' . esc_attr(get_bloginfo('description', 'display')) . '" rel="' . esc_attr__('Home', 'zella-theme') . '">';
            $content .= $logo_link != '' ? 
                '<img src="' . esc_attr($logo_link) . '" class="header_logo" alt="' . get_bloginfo('name', 'display') . '"' . ($logo_retina != '' ? ' data-src-retina="' . esc_attr($logo_retina) . '"' : '') . ' />' :
                get_bloginfo('name', 'display');
            $content .= '</a>';
            
            $GLOBALS['nasa_logo'] = $content;
            
            return $h1 ? '<h1 class="nasa-logo-img">' . $content . '</h1>' : $content;
        }
        
        return $h1 ? '<h1 class="nasa-logo-img">' . $nasa_logo . '</h1>' : $nasa_logo;
    }

endif;

// **********************************************************************//
// ! Get header search
// **********************************************************************//
if (!function_exists('zella_search')) :

    function zella_search($search_type = 'icon', $return = true) {
        $class_wrap = ' nasa_search_' . $search_type;
        $class = $search_type == 'icon' ? ' nasa-over-hide' : ' nasa-search-relative';
        $search = '';

        $search .= '<div class="nasa-search-space' . esc_attr($class_wrap) . '">';
        $search .= '<div class="nasa-show-search-form' . $class . '">';
        
        ob_start();
        $file = ZELLA_CHILD_PATH . '/includes/nasa-desktop-product-searchform.php';
        include is_file($file) ? $file : ZELLA_THEME_PATH . '/includes/nasa-desktop-product-searchform.php';
        $search .= ob_get_clean();
        
        $search .= '</div>';
        $search .= '</div>';
        
        if($return) {
            return $search;
        }
        
        echo zella_str($search);
    }

endif;

// **********************************************************************// 
// ! Get main menu
// **********************************************************************// 
if (!function_exists('zella_main_menu')) :

    function zella_main_menu($main = true) {
        global $nasa_main_menu;
        
        $mega = class_exists('Nasa_Nav_Menu');
        $walker = $mega ? new Nasa_Nav_Menu() : new Walker_Nav_Menu();
        if(!$nasa_main_menu) {
            if (has_nav_menu('primary')) :
                $GLOBALS['nasa_main_menu'] = wp_nav_menu(array(
                    'echo' => false,
                    'theme_location' => 'primary',
                    'container' => false,
                    'items_wrap' => '%3$s',
                    'depth' => 3,
                    'walker' => $walker
                ));
            else:
                $allowed_html = array(
                    'li' => array(),
                    'b' => array()
                );
                
                $GLOBALS['nasa_main_menu'] = wp_kses(__('<li>Please Define menu in <b>Apperance > Menus</b></li>', 'zella-theme'), $allowed_html);
            endif;
        }
        
        echo '<div class="nav-wrapper inline-block main-menu-warpper">';
        echo '<ul' . ($main ? ' id="site-navigation" ' : ' ') . 'class="header-nav' . ($mega ? '' : ' nasa-wp-simple-nav-menu') . '">';
        echo zella_str($nasa_main_menu);
        echo '</ul>';
        echo '</div><!-- nav-wrapper -->';
    }

endif;

if (!function_exists('zella_menu')) :

    function zella_menu($menu_location, $class = "", $depth = 3) {
        if (has_nav_menu($menu_location)) :
            $mega = class_exists('Nasa_Nav_Menu');
            $walker = $mega ? new Nasa_Nav_Menu() : new Walker_Nav_Menu();
            $class .= $mega ? ' nasa-nav-menu' : ' nasa-wp-simple-nav-menu';
            echo '<ul class="' . esc_attr($class) . '">';
            wp_nav_menu(array(
                'theme_location' => $menu_location,
                'container' => false,
                'items_wrap' => '%3$s',
                'depth' => (int) $depth,
                'walker' => $walker
            ));
            echo '</ul>';
        endif;
    }

endif;
// **********************************************************************// 
// ! Get Vertical menu
// **********************************************************************// 
if (!function_exists('zella_vertical_menu')) :

    function zella_vertical_menu() {
        global $nasa_opt, $wp_query;

        $menu = ($menu_overr = get_post_meta($wp_query->get_queried_object_id(), '_nasa_vertical_menu_selected', true)) ? $menu_overr : (isset($nasa_opt['vertical_menu_selected']) ? $nasa_opt['vertical_menu_selected'] : false);

        if (!$menu) {
            $locations = get_theme_mod('nav_menu_locations');
            $menu = isset($locations['vetical-menu']) && $locations['vetical-menu'] ? $locations['vetical-menu'] : null;
        }

        if ($menu && $menu != '-1') {
            $title = ($title_overr = get_post_meta($wp_query->get_queried_object_id(), '_nasa_title_ver_menu', true)) ? $title_overr : (isset($nasa_opt['title_ver_menu']) ? $nasa_opt['title_ver_menu'] : false);

            $vertical_menu_allways_show = get_post_meta($wp_query->get_queried_object_id(), '_nasa_vertical_menu_allways_show', true);
            $nasa_class_menu_vertical = ($vertical_menu_allways_show) ? ' nasa-allways-show' : '';
            $nasa_class_menu_vertical_warp = ($vertical_menu_allways_show) ? ' nasa-allways-show-warp' : '';
            
            $mega = class_exists('Nasa_Nav_Menu');
            $walker = $mega ? new Nasa_Nav_Menu() : new Walker_Nav_Menu();
            $class = $mega ? '' : ' nasa-wp-simple-nav-menu';
            ?>
            <div class="vertical-menu nasa-vertical-header<?php echo esc_attr($nasa_class_menu_vertical_warp); ?>">
                <div class="title-inner">
                    <h5 class="section-title nasa-title-vertical-menu">
                        <span>
                            <?php echo !empty($title) ? esc_attr($title) : esc_html__('CATEGORIES', 'zella-theme'); ?>
                        </span>
                    </h5>
                </div>
                <div class="vertical-menu-container<?php echo esc_attr($nasa_class_menu_vertical); ?>">
                    <ul class="vertical-menu-wrapper<?php echo esc_attr($class); ?>">
                        <?php
                        wp_nav_menu(array(
                            'menu' => $menu,
                            'container' => false,
                            'items_wrap' => '%3$s',
                            'depth' => 3,
                            'walker' => $walker
                        ));
                        ?>
                    </ul>
                </div>
            </div>
            <?php
        }
    }

endif;

if (!function_exists('zella_tpl2id')) :

    function zella_tpl2id($tpl) {
        $pages = get_pages(array(
            'meta_key' => '_wp_page_template',
            'meta_value' => $tpl
        ));

        if (empty($pages)) {
            return null;
        }

        foreach ($pages as $page) {
            return $page->ID;
        }
    }

endif;

if (!function_exists('zella_back_to_page')) :

    function zella_back_to_page() {
        echo '<a class="back-history" href="javascript: history.go(-1)">' . esc_html__('Return to Previous Page', 'zella-theme') . '</a>';
    }

endif;

// **********************************************************************// 
// ! Get breadcrumb
// **********************************************************************//
if (!function_exists('zella_breadcrumb')) :

    function zella_breadcrumb() {
        if (!NASA_WOO_ACTIVED) {
            return;
        }

        global $post, $nasa_opt, $wp_query;
        $enable = (isset($nasa_opt['breadcrumb_show']) && !$nasa_opt['breadcrumb_show']) ? false : true;
        $override = false;
        
        // Theme option
        $has_bg = (isset($nasa_opt['breadcrumb_type']) && $nasa_opt['breadcrumb_type'] == 'has-background') ? true : false;

        $bg = (isset($nasa_opt['breadcrumb_bg']) && trim($nasa_opt['breadcrumb_bg']) != '') ?
            $nasa_opt['breadcrumb_bg'] : false;

        $bg_cl = (isset($nasa_opt['breadcrumb_bg_color']) && $nasa_opt['breadcrumb_bg_color']) ?
            $nasa_opt['breadcrumb_bg_color'] : false;
        
        $bg_lax = (isset($nasa_opt['breadcrumb_bg_lax']) && $nasa_opt['breadcrumb_bg_lax'] == 1) ? true : false;

        $h_bg = (isset($nasa_opt['breadcrumb_height']) && (int) $nasa_opt['breadcrumb_height']) ?
            (int) $nasa_opt['breadcrumb_height'] : false;

        $txt_color = (isset($nasa_opt['breadcrumb_color']) && $nasa_opt['breadcrumb_color']) ?
            $nasa_opt['breadcrumb_color'] : false;

        /*
         * Category breadcrumb BG
         */
        $pageShop = wc_get_page_id('shop');
        if($tax_cat = is_tax('product_cat')) {
            $show_breadcrumb = get_post_meta($pageShop, '_nasa_show_breadcrumb', true);
            $enable = ($show_breadcrumb != 'on') ? false : true;
            if ($enable === false) {
                return;
            }
            
            $query_obj = get_queried_object();
            $term_id = isset($query_obj->term_id) ? $query_obj->term_id : false;
            if($term_id) {
                $bg_cat_enable = get_term_meta($term_id, 'cat_breadcrumb', true);
                
                if($bg_cat_enable) {
                    $bgImgId = get_term_meta($term_id, 'cat_breadcrumb_bg', true);
                    if ($bgImgId) {
                        $bg = wp_get_attachment_image_url($bgImgId, 'full');
                        $has_bg = true;
                    }

                    $text_color_cat = get_term_meta($term_id, 'cat_breadcrumb_text_color', true);
                    $txt_color = $text_color_cat != '' ? $text_color_cat : $txt_color;
                } else {
                    $queryObj = $pageShop;
                    $override = true;
                }
            }
        }
        
        else {
            $pageBlog = get_option('page_for_posts');
            /**
             * Check page
             */
            if (isset($post->ID) && $post->post_type == 'page') {
                $queryObj = $post->ID;
                $show_breadcrumb = get_post_meta($queryObj, '_nasa_show_breadcrumb', true);
                $enable = ($show_breadcrumb != 'on') ? false : true;
                $override = true;
            }
            
            /**
             * Check Blog | archive post | single post
             */
            elseif($pageBlog && isset($post->post_type) && $post->post_type == 'post' && (is_category() || is_tag() || is_date() || is_home() || is_single())) {
                $show_breadcrumb = get_post_meta($pageBlog, '_nasa_show_breadcrumb', true);
                $enable = ($show_breadcrumb != 'on') ? false : true;
                $queryObj = $pageBlog;
                $override = true;
            }
            
            /**
             * Check Single product
             */
            elseif(is_post_type_archive('product') || is_tax(get_object_taxonomies('product'))) {
                $show_breadcrumb = get_post_meta($pageShop, '_nasa_show_breadcrumb', true);
                $enable = ($show_breadcrumb != 'on') ? false : true;
                $queryObj = $pageShop;
                $override = true;
            }

            if ($enable === false) {
                return;
            }
        }
        
        // Override
        if ($override) {
            $type_bg = get_post_meta($queryObj, '_nasa_type_breadcrumb', true);
            $bg_override = get_post_meta($queryObj, '_nasa_bg_breadcrumb', true);
            $bg_cl_override = get_post_meta($queryObj, '_nasa_bg_color_breadcrumb', true);
            $h_override = get_post_meta($queryObj, '_nasa_height_breadcrumb', true);
            $color_override = get_post_meta($queryObj, '_nasa_color_breadcrumb', true);

            if ($type_bg == '1') {
                $bg = $bg_override ? $bg_override : $bg;
            }

            $bg_cl = $bg_cl_override ? $bg_cl_override : $bg_cl;
            $txt_color = $color_override ? $color_override : $txt_color;
            $h_bg = (int) $h_override ? (int) $h_override : $h_bg;
        }

        // set style by option breadcrumb
        $style_custom = '';
        if ($has_bg) {
            $style_custom .= $bg ? 'background:url(\'' . esc_url($bg) . '\') center center repeat-y;' : '';
        }
        
        $style_custom .= $bg_cl ? 'background-color:' . $bg_cl . ';' : '';
        $style_custom .= $txt_color ? 'color:' . $txt_color . ';' : '';
        $style_height = $h_bg ? 'height:' . $h_bg . 'px;' : 'height:auto;';
        
        $defaults = apply_filters('nasa_breadcrumb_args', array(
            'delimiter' => '<span class="nasa-bolder">/</span>',
            'wrap_before' => '<h3 class="breadcrumb">',
            'wrap_after' => '</h3>',
            'before' => '',
            'after' => '',
            'home' => esc_html__('Home', 'zella-theme')
        ));
        
        $parallax = $has_bg && $bg && $bg_lax ? true : false;
        
        $class_wrap_breadcrumb = 'bread nasa-breadcrumb';
        $class_wrap_breadcrumb .= $has_bg ? ' nasa-breadcrumb-has-bg' : '';
        $class_wrap_breadcrumb .= $parallax ? ' nasa-parallax': '';
        
        $bread_align = !isset($nasa_opt['breadcrumb_align']) ? 'text-left' : $nasa_opt['breadcrumb_align'];
        $args = wp_parse_args($defaults);
        
        $wc_breadcrumbs = new WC_Breadcrumb();

        if (!empty($args['home'])) {
            $wc_breadcrumbs->add_crumb(
                $args['home'],
                apply_filters('woocommerce_breadcrumb_home_url', home_url('/'))
            );
        }
        $args['breadcrumb'] = $wc_breadcrumbs->generate();
        do_action('woocommerce_breadcrumb', $wc_breadcrumbs, $args);
        ?>
        <div id="nasa-breadcrumb-site" class="<?php echo esc_attr($class_wrap_breadcrumb); ?>"<?php echo !empty($style_custom) ? ' style="' . esc_attr($style_custom) . '"' : ''; ?><?php echo !empty($parallax) ? ' data-stellar-background-ratio="0.6"' : ''; ?>>
            <div class="row">
                <div class="large-12 columns nasa-display-table">
                    <div class="breadcrumb-row <?php echo esc_attr($bread_align); ?>" style="<?php echo esc_attr($style_height); ?>">
                        <?php wc_get_template('global/breadcrumb.php', $args); ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }

endif;

/**
 * Build breadcrumb Portfolio
 */
if(!function_exists('zella_rebuilt_breadcrumb_portfolio')) :
    function zella_rebuilt_breadcrumb_portfolio($orgBreadcrumb, $single = true) {
        global $nasa_opt, $post;
        
        $breadcrumb = array($orgBreadcrumb[0]);
        
        $portfolio = null;
        if(isset($nasa_opt['nasa-page-view-portfolio']) && (int) $nasa_opt['nasa-page-view-portfolio']) {
            $portfolio = get_post((int) $nasa_opt['nasa-page-view-portfolio']);
        } else {
            $pages = get_pages(array(
                'meta_key' => '_wp_page_template',
                'meta_value' => 'portfolio.php'
            ));

            if($pages) {
                foreach ($pages as $page) {
                    $portfolio = get_post((int) $page->ID);
                    break;
                }
            }
        }

        if ($portfolio) {
            $breadcrumb[] = array(
                0 => $portfolio->post_title,
                1 => get_permalink($portfolio)
            );
        }

        $terms = wp_get_post_terms(
            $post->ID,
            'portfolio_category',
            array(
                'orderby' => 'parent',
                'order' => 'DESC'
            )
        );

        if ($terms) {
            $main_term = $terms[0];
            $ancestors = get_ancestors($main_term->term_id, 'portfolio_category');
            $ancestors = array_reverse($ancestors);
            if (count($ancestors)) {
                foreach ($ancestors as $ancestor) {
                    $ancestor = get_term($ancestor, 'portfolio_category');

                    if($ancestor) {
                        $breadcrumb[] = array(
                            0 => $ancestor->name,
                            1 => get_term_link($ancestor, 'portfolio_category')
                        );
                    }
                }
            }

            $breadcrumb[] = array(
                0 => $main_term->name,
                1 => get_term_link($main_term, 'portfolio_category')
            );
        }
        
        if($single) {
            $breadcrumb[] = array(
                0 => get_the_title()
            );
        }

        return $breadcrumb;
    }
endif;

// **********************************************************************// 
// ! Add body class
// **********************************************************************//
add_filter('body_class', 'zella_body_classes');
if (!function_exists('zella_body_classes')) :

    function zella_body_classes($classes) {
        global $nasa_opt;

        $classes[] = 'antialiased';
        if (is_multi_author()) {
            $classes[] = 'group-blog';
        }

        if (isset($nasa_opt['site_layout']) && $nasa_opt['site_layout'] == 'boxed') {
            $classes[] = 'boxed';
        }

        if (isset($nasa_opt['promo_popup']) && $nasa_opt['promo_popup'] == 1) {
            $classes[] = 'open-popup';
        }
        
        if (isset($nasa_opt['product-image-lightbox']) && !$nasa_opt['product-image-lightbox']) {
            $classes[] = 'nasa-disable-lightbox-image';
        }

        if (NASA_WOO_ACTIVED && function_exists('is_product')) {
            if (is_product() && isset($nasa_opt['product-zoom']) && $nasa_opt['product-zoom']) {
                $classes[] = 'product-zoom';
            }
        }

        if (
            (isset($nasa_opt['nasa_rtl']) && $nasa_opt['nasa_rtl']) ||
            (isset($_REQUEST['rtl']) && $_REQUEST['rtl'] == '1')
        ) {
            $classes[] = 'nasa-rtl';
        }

        return $classes;
    }

endif;

// **********************************************************************// 
// ! Add hr to the widget title
// **********************************************************************//
if (!function_exists('zella_widget_title')) :

    function zella_widget_title($title) {
        return !empty($title) ? $title . '<span class="nasa-hr small primary-color"></span>' : '';
    }

endif;

// **********************************************************************// 
// ! Comments
// **********************************************************************//  
if (!function_exists('zella_comment')) :

    function zella_comment($comment, $args, $depth) {
        $GLOBALS['comment'] = $comment;
        switch ($comment->comment_type) :
            case 'pingback' :
            case 'trackback' : ?>
                <li class="post pingback">
                    <p><?php esc_html_e('Pingback:', 'zella-theme'); ?> <?php comment_author_link(); ?><?php edit_comment_link(esc_html__('Edit', 'zella-theme'), '<span class="edit-link">', '<span>'); ?></p>
                <?php
                break;
            default : ?>
                <li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
                    <article id="comment-<?php comment_ID(); ?>" class="comment-inner">
                        <div class="row collapse">
                            <div class="large-2 columns">
                                <div class="comment-author">
                                    <?php echo get_avatar($comment, 80); ?>
                                </div>
                            </div>
                            <div class="large-10 columns">
                                <?php printf('<cite class="fn">%s</cite>', get_comment_author_link()); ?>
                                <div class="comment-meta commentmetadata right">
                                        <i class="fa fa-clock-o"></i>
                                        <time datetime="<?php comment_time('c'); ?>">
                                            <?php printf(_x('%1$s at %2$s', '1: date, 2: time', 'zella-theme'), get_comment_date(), get_comment_time()); ?>
                                        </time>
                                    <?php edit_comment_link(esc_html__('Edit', 'zella-theme'), '<span class="edit-link">', '<span>'); ?>
                                </div>
                                <div class="reply">
                                    <?php
                                    comment_reply_link(array_merge($args, array(
                                        'depth' => $depth,
                                        'max_depth' => $args['max_depth'],
                                    )));
                                    ?>
                                </div>
                                <?php if ($comment->comment_approved == '0') : ?>
                                    <em><?php esc_html_e('Your comment is awaiting moderation.', 'zella-theme'); ?></em>
                                    <br />
                                <?php endif; ?>

                                <div class="comment-content"><?php comment_text(); ?></div>
                            </div>
                        </div>
                    </article>
                <?php
                break;
        endswitch;
    }

endif;

// **********************************************************************// 
// ! Post meta top
// **********************************************************************//  
if (!function_exists('zella_posted_on')) :

    function zella_posted_on() {
        $allowed_html = array(
            'span' => array('class' => array()),
            'strong' => array(),
            'a' => array('class' => array(), 'href' => array(), 'title' => array(), 'rel' => array()),
            'time' => array('class' => array(), 'datetime' => array())
        );
        $day = get_the_date('d');
        $month = get_the_date('m');
        $year = get_the_date('Y');
        $author = get_the_author();
        printf(
            wp_kses(
                __('<span class="meta-author">By <strong><a class="url fn n" href="%5$s" title="%6$s" rel="author">%7$s</a></strong>.</span> Posted on <a href="%1$s" title="%2$s" rel="bookmark"><time class="entry-date" datetime="%3$s">%4$s</time></a>', 'zella-theme'), $allowed_html
            ),
            esc_url(get_day_link($year, $month, $day)),
            esc_attr(get_the_time()),
            esc_attr(get_the_date('c')),
            esc_html(get_the_date()),
            esc_url(get_author_posts_url(get_the_author_meta('ID'))),
            esc_attr(
                sprintf(
                    esc_html__('View all posts by %s', 'zella-theme'),
                    $author
                )
            ),
            $author
        );
    }

endif;


// **********************************************************************// 
// ! Promo Popup
// **********************************************************************// 
add_action('nasa_before_page_wrapper', 'zella_promo_popup');
if (!function_exists('zella_promo_popup')) :

    function zella_promo_popup() {
        global $nasa_opt;
        if(!isset($nasa_opt['promo_popup']) || !$nasa_opt['promo_popup']) {
            return;
        }
        
        $popup_closed = isset($_COOKIE['nasatheme_popup_closed']) ? $_COOKIE['nasatheme_popup_closed'] : '';
        if($popup_closed === 'do-not-show') {
            return;
        }
        
        $nasa_opt['pp_background_image'] = (isset($nasa_opt['pp_background_image']) && $nasa_opt['pp_background_image'] != '') ? $nasa_opt['pp_background_image'] : ZELLA_THEME_URI . '/assets/images/newsletter_bg.jpg';
        
        $delay = (!isset($nasa_opt['delay_promo_popup']) || (int) $nasa_opt['delay_promo_popup'] <= 0) ? 0 : (int) $nasa_opt['delay_promo_popup'];
        
        //disable_popup_mobile
        $disableMobile = (isset($nasa_opt['disable_popup_mobile']) && (int) $nasa_opt['disable_popup_mobile']) ? 'true' : 'false';
        
        echo '<div class="popup_link hidden-tag"><a class="nasa-popup open-click" href="#nasa-popup" data-delay="' . esc_attr($delay) . '" data-disable_mobile="' . esc_attr($disableMobile) . '">' . esc_html__('Newsletter', 'zella-theme') . '</a></div>';
        
        $file = ZELLA_CHILD_PATH . '/includes/nasa-promo-popup.php';
        include is_file($file) ? $file : ZELLA_THEME_PATH . '/includes/nasa-promo-popup.php';
    }

endif;

add_filter('wp_nav_menu_objects', 'zella_add_menu_parent_class');
if (!function_exists('zella_add_menu_parent_class')) :
    function zella_add_menu_parent_class($items) {
        $parents = array();
        foreach ($items as $item) {
            if ($item->menu_item_parent && $item->menu_item_parent > 0) {
                $parents[] = $item->menu_item_parent;
            }
        }

        foreach ($items as $item) {
            if (in_array($item->ID, $parents)) {
                $item->classes[] = 'menu-parent-item';
            }
        }

        return $items;
    }
endif;

// add_action('woocommerce_single_product_summary', 'zella_ProductShowReviews', 15);
// add_action('woocommerce_single_review', 'zella_ProductShowReviews', 10);
if (!function_exists('zella_ProductShowReviews')) :
    function zella_ProductShowReviews() {
        if (comments_open()) {
            global $wpdb, $post;

            $count = $wpdb->get_var($wpdb->prepare("
                SELECT COUNT(meta_value) FROM $wpdb->commentmeta
                LEFT JOIN $wpdb->comments ON $wpdb->commentmeta.comment_id = $wpdb->comments.comment_ID
                WHERE meta_key = %s
                AND comment_post_ID = %s
                AND comment_approved = %s
                AND meta_value > %s", 'rating', $post->ID, '1', '0'
            ));

            $rating = $wpdb->get_var($wpdb->prepare("
                SELECT SUM(meta_value) FROM $wpdb->commentmeta
                LEFT JOIN $wpdb->comments ON $wpdb->commentmeta.comment_id = $wpdb->comments.comment_ID
                WHERE meta_key = %s
                AND comment_post_ID = %s
                AND comment_approved = %s", 'rating', $post->ID, '1'
            ));

            if ($count > 0) {
                $average = number_format($rating / $count, 2);

                echo '<a href="#tab-reviews" class="scroll-to-reviews"><div class="star-rating tip-top" data-tip="' . $count . ' review(s)"><span style="width:' . ($average * 16) . 'px"><span class="rating"><span>' . $average . '</span><span class="hidden">' . $count . '</span></span> ' . esc_html__('out of 5', 'zella-theme') . '</span></div></a>';
            }
        }
    }
endif;

if (!function_exists('zella_adjacent_post_product')) :
    function zella_adjacent_post_product($in_same_cat = false, $excluded_categories = '', $previous = true) {
        global $wpdb;

        if (!$post = get_post()) {
            return null;
        }

        $current_post_date = $post->post_date;
        $join = '';
        $posts_in_ex_cats_sql = '';
        if ($in_same_cat || !empty($excluded_categories)) {
            $join .= " INNER JOIN $wpdb->term_relationships AS tr ON p.ID = tr.object_id INNER JOIN $wpdb->term_taxonomy tt ON tr.term_taxonomy_id = tt.term_taxonomy_id";

            if ($in_same_cat) {
                if (!is_object_in_taxonomy($post->post_type, 'product_cat')) {
                    return '';
                }
                $cat_array = wp_get_object_terms($post->ID, 'product_cat', array('fields' => 'ids'));
                if (!$cat_array || is_wp_error($cat_array)) {
                    return '';
                }
                $join .= " AND tt.taxonomy='product_cat' AND tt.term_id IN (" . implode(',', $cat_array) . ")";
            }

            $posts_in_ex_cats_sql = "AND tt.taxonomy = 'product_cat'";
            if (!empty($excluded_categories)) {
                if (!is_array($excluded_categories)) {
                    if (strpos($excluded_categories, ' and ') !== false) {
                        _deprecated_argument(__FUNCTION__, '3.3', esc_html_e('Use commas instead of and to separate excluded categories.', 'zella-theme'));
                        $excluded_categories = explode(' and ', $excluded_categories);
                    } else {
                        $excluded_categories = explode(',', $excluded_categories);
                    }
                }

                $excluded_categories = array_map('intval', $excluded_categories);

                if (!empty($cat_array)) {
                    $excluded_categories = array_diff($excluded_categories, $cat_array);
                    $posts_in_ex_cats_sql = '';
                }

                if (!empty($excluded_categories)) {
                    $posts_in_ex_cats_sql = " AND tt.taxonomy = 'product_cat' AND tt.term_id NOT IN (" . implode($excluded_categories, ',') . ')';
                }
            }
        }

        $adjacent = $previous ? 'previous' : 'next';
        $op = $previous ? '<' : '>';
        $order = $previous ? 'DESC' : 'ASC';

        $join = apply_filters("get_{$adjacent}_post_join", $join, $in_same_cat, $excluded_categories);
        $where = apply_filters("get_{$adjacent}_post_where", $wpdb->prepare("WHERE p.post_date $op %s AND p.post_type = %s AND p.post_status = 'publish' $posts_in_ex_cats_sql", $current_post_date, $post->post_type), $in_same_cat, $excluded_categories);
        $sort = apply_filters("get_{$adjacent}_post_sort", "ORDER BY p.post_date $order LIMIT 1");

        $query = "SELECT p.id FROM $wpdb->posts AS p $join $where $sort";
        $query_key = 'adjacent_post_' . md5($query);
        $result = wp_cache_get($query_key, 'counts');
        if (false !== $result) {
            if ($result) {
                $result = get_post($result);
            }
            return $result;
        }

        $result = $wpdb->get_var($wpdb->prepare($query));
        if (null === $result) {
            $result = '';
        }

        wp_cache_set($query_key, $result, 'counts');

        if ($result) {
            $result = get_post($result);
        }

        return $result;
    }
endif;

// **********************************************************************// 
// ! Blog - Add "Read more" links
// **********************************************************************//
add_action('the_content_more_link', 'zella_add_morelink_class', 10, 2);
if (!function_exists('zella_add_morelink_class')) :
    function zella_add_morelink_class($link, $text) {
        return str_replace('more-link', 'more-link button small', $link);
    }
endif;

// **********************************************************************// 
// ! Language Flags
// **********************************************************************//
if (!function_exists('zella_language_flages')) :

    function zella_language_flages() {
        global $nasa_opt;
        
        if(!isset($nasa_opt['switch_lang']) || $nasa_opt['switch_lang'] != 1) {
            return '';
        }
        
        $language_output = '<select name="nasa_switch_languages" class="nasa-select-language" data-active="0">';
        $options = '';
        if (function_exists('icl_get_languages')) {
            $current = defined('ICL_LANGUAGE_CODE') ? ICL_LANGUAGE_CODE : 'en';
            
            $language_output = '<select name="nasa_switch_languages" class="nasa-select-language" data-active="1">';
            $languages = icl_get_languages('skip_missing=0&orderby=code');
            if (!empty($languages)) {
                foreach ($languages as $l) {
                    $selected = $current == $l['language_code'] ? ' selected' : '';
                    $options .= '<option data-code="' . $l['language_code'] . '" value="' . $l['url'] . '"' . $selected . '>' . $l['native_name'] . '</option>';
                }
            }
        } else {
            $options .=
                '<option value="en">' . esc_html__('English', 'zella-theme') . '</option>' .
                '<option value="gr">' . esc_html__('German', 'zella-theme') . '</option>' .
                '<option value="fr">' . esc_html__('French', 'zella-theme') . '</option>';
        }
        
        $language_output .= $options;
        $language_output .= '</select>';

        echo '<ul class="header-switch-languages"><li>' . $language_output . '</li></ul>';
    }

endif;

add_action('pre_get_posts', 'zella_pre_get_posts_action');
if (!function_exists('zella_pre_get_posts_action')) :
    function zella_pre_get_posts_action($query) {
        $action = isset($_GET['action']) ? $_GET['action'] : '';
        if ($action == 'woocommerce_json_search_products') {
            return;
        }
        if (defined('DOING_AJAX') && DOING_AJAX && !empty($query->query_vars['s'])) {
            if (isset($query->query_vars['post_type'])) {
                $query->query_vars['post_type'] = array($query->query_vars['post_type'], 'post', 'page');
            }
            if (isset($query->query_vars['meta_query'])) {
                $query->query_vars['meta_query'] = new WP_Meta_Query(array('relation' => 'OR', $query->query_vars['meta_query']));
            }
        }
    }
endif;

/* cut string limit */
if (!function_exists('zella_limit_words')) :

    function zella_limit_words($string, $word_limit) {
        $words = explode(' ', $string, ($word_limit + 1));
        if (count($words) <= $word_limit) {
            return $string;
        }
        array_pop($words);
        return implode(' ', $words) . ' ...';
    }

endif;

// **********************************************************************// 
// ! Blog post navigation
// **********************************************************************//  
if (!function_exists('zella_content_nav')) :

    function zella_content_nav($nav_id) {
        global $wp_query, $post;
        $allowed_html = array(
            'span' => array('class' => array())
        );
        
        $is_single = is_single();

        if ($is_single) {
            $previous = (is_attachment()) ? get_post($post->post_parent) : get_adjacent_post(false, '', true);
            $next = get_adjacent_post(false, '', false);

            if (!$next && !$previous) {
                return;
            }
        }

        if ($wp_query->max_num_pages < 2 && (is_home() || is_archive() || is_search())) {
            return;
        }

        $nav_class = $is_single ? 'navigation-post' : 'navigation-paging';
        ?>
        <nav role="navigation" id="<?php echo esc_attr($nav_id); ?>" class="<?php echo esc_attr($nav_class); ?>">
            <?php
            if ($is_single) {
                previous_post_link('<div class="nav-previous left">%link</div>', '<span class="fa fa-caret-left">' . _x('', 'Previous post link', 'zella-theme') . '</span> %title');
                next_post_link('<div class="nav-next right">%link</div>', '%title <span class="fa fa-caret-right">' . _x('', 'Next post link', 'zella-theme') . '</span>');
            } elseif ($wp_query->max_num_pages > 1 && (is_home() || is_archive() || is_search())) {
                // navigation links for home, archive, and search pages
                if (get_next_posts_link()) {
                    ?>
                    <div class="nav-previous"><?php next_posts_link(wp_kses(__('Next <span class="fa fa-caret-right"></span>', 'zella-theme'), $allowed_html)); ?></div>
                    <?php
                }
                if (get_previous_posts_link()) {
                    ?>
                    <div class="nav-next"><?php previous_posts_link(wp_kses(__('<span class="fa fa-caret-left"></span> Previous', 'zella-theme'), $allowed_html)); ?></div>
                    <?php
                }
            }
            ?>
        </nav>
        <?php
    }

endif;

/**
 * Get relates post
 */
add_action('nasa_after_single_post', 'zella_relate_post');
if(!function_exists('zella_relate_post')) :
    function zella_relate_post() {
        global $nasa_opt, $post;
        
        if(isset($nasa_opt['relate_blogs']) && !$nasa_opt['relate_blogs']) {
            return;
        }
        
        $numberPost = isset($nasa_opt['relate_blogs_number']) && (int) $nasa_opt['relate_blogs_number'] ? (int) $nasa_opt['relate_blogs_number'] : 10;
        
        $relate = get_posts(
            array(
                'post_status' => 'publish',
                'post_type' => 'post',
                'category__in' => wp_get_post_categories($post->ID),
                'numberposts' => $numberPost,
                'post__not_in' => array($post->ID),
                'orderby' => 'date',
                'order' => 'DESC'
            )
        );
        $columns_number_small = isset($nasa_opt['relate_blogs_columns_small']) && (int) $nasa_opt['relate_blogs_columns_small'] ? (int) $nasa_opt['relate_blogs_columns_small'] : 1;
        $columns_number_tablet = isset($nasa_opt['relate_blogs_columns_tablet']) && (int) $nasa_opt['relate_blogs_columns_tablet'] ? (int) $nasa_opt['relate_blogs_columns_tablet'] : 2;
        $columns_number = isset($nasa_opt['relate_blogs_columns_desk']) && (int) $nasa_opt['relate_blogs_columns_desk'] ? (int) $nasa_opt['relate_blogs_columns_desk'] : 3;
        
        $file = ZELLA_CHILD_PATH . '/includes/nasa-blog-relate.php';
        include is_file($file) ? $file : ZELLA_THEME_PATH . '/includes/nasa-blog-relate.php';
    }
endif;

//Add shortcode Top bar Promotion news
if (!function_exists('zella_promotion_recent_post')):
    function zella_promotion_recent_post() {
        global $nasa_opt;

        if (isset($nasa_opt['enable_post_top']) && !$nasa_opt['enable_post_top']) {
            return '';
        }

        $content = '';
        $posts = null;

        if (!isset($nasa_opt['type_display']) || $nasa_opt['type_display'] == 'custom') {
            $content = isset($nasa_opt['content_custom']) ? $nasa_opt['content_custom'] : '';
        } elseif (isset($nasa_opt['type_display']) && $nasa_opt['type_display'] == 'list-posts') {
            if (!isset($nasa_opt['category_post']) || !$nasa_opt['category_post']) {
                $nasa_opt['category_post'] = null;
            }

            if (!isset($nasa_opt['number_post']) || !$nasa_opt['number_post']) {
                $nasa_opt['number_post'] = 4;
            }

            $args = array(
                'post_status' => 'publish',
                'post_type' => 'post',
                'orderby' => 'date',
                'order' => 'DESC',
                'category' => ((int) $nasa_opt['category_post'] != 0) ? (int) $nasa_opt['category_post'] : null,
                'posts_per_page' => $nasa_opt['number_post']
            );

            $posts = get_posts($args);
        }

        $file = ZELLA_CHILD_PATH . '/includes/nasa-blog-promotion.php';
        include is_file($file) ? $file : ZELLA_THEME_PATH . '/includes/nasa-blog-promotion.php';
    }
endif;

/**
 * Nasa Block
 */
if (!function_exists('zella_block')):

    function zella_block($slug) {
        $post = $slug ? get_posts(
            array(
                'name'              => $slug,
                'posts_per_page'    => 1,
                'post_type'         => 'nasa_block',
                'post_status'       => 'publish'
            )
        ) : null;
        
        /**
         * With WPML
         */
        if (class_exists('SitePress') && function_exists('icl_object_id') && isset($post->ID)) {
            $postLangID = icl_object_id($post->ID, 'nasa_block', true);
            
            if($postLangID) {
                $postLang = get_post($postLangID);
                $post = $postLang && $postLang->post_status == 'publish' ? $postLang : $post;
            }
        }
        
        $postReal = !empty($post) ? $post[0] : null;
        return isset($postReal->post_content) ? do_shortcode($postReal->post_content) : '';
    }

endif;

/**
 * Before load effect site
 */
add_action('nasa_theme_before_load', 'zella_theme_before_load');
if (!function_exists('zella_theme_before_load')):

    function zella_theme_before_load() {
        global $nasa_opt;

        if (!isset($nasa_opt['effect_before_load']) || $nasa_opt['effect_before_load'] == 1) {
            echo 
            '<div id="nasa-before-load">' .
                '<div class="nasa-relative nasa-center">' .
                    '<div class="nasa-loader">' .
                        '<div class="nasa-line"></div>' .
                        '<div class="nasa-line"></div>' .
                        '<div class="nasa-line"></div>' .
                        '<div class="nasa-line"></div>' .
                    '</div>' .
                '</div>' .
            '</div>';
        }
    }

endif;

if (!function_exists('zella_loader_html')) :
    function zella_loader_html($id_attr = null, $relative = true) {
        $id = $id_attr != null ? ' id="' . esc_attr($id_attr) . '"' : '';
        $class = $relative ? ' class="nasa-relative"' : '';
        return 
            '<div' . $id . $class . '>' .
                '<div class="nasa-loader">' .
                    '<div class="nasa-line"></div>' .
                    '<div class="nasa-line"></div>' .
                    '<div class="nasa-line"></div>' .
                    '<div class="nasa-line"></div>' .
                '</div>' .
            '</div>';
    }
endif;

// **********************************************************************// 
// ! Other functions
// **********************************************************************// 
add_filter('attachment_link', 'zella_enhanced_image_navigation', 10, 2);
if(!function_exists('zella_enhanced_image_navigation')) :
    function zella_enhanced_image_navigation($url, $id) {
        if (!is_attachment() && !wp_attachment_is_image($id)){
            return $url;
        }

        $image = get_post($id);
        $url .= (!empty($image->post_parent) && $image->post_parent != $id) ? '#main' : '';

        return $url;
    }
endif;

if(!function_exists('zella_short_excerpt')):
    function zella_short_excerpt($limit) {
        $excerpt = explode(' ', get_the_excerpt(), $limit);
        $count = count($excerpt);
        if ($count >= $limit) {
            array_pop($excerpt);
            $excerpt = implode(" ", $excerpt) . '...';
        } else {
            $excerpt = implode(" ", $excerpt);
        }
        $excerpt = preg_replace('`\[[^\]]*\]`', '', $excerpt);
        return $excerpt;
    }
endif;

if(!function_exists('zella_content')):
    function zella_content($limit) {
        $content = explode(' ', get_the_content(), $limit);
        $count = count($content);
        if ($count >= $limit) {
            array_pop($content);
            $content = implode(" ", $content) . '...';
        } else {
            $content = implode(" ", $content);
        }
        $content = preg_replace('/\[.+\]/', '', $content);
        $content = apply_filters('the_content', $content);
        $content = str_replace(']]>', ']]&gt;', $content);
        return $content;
    }
endif;

if(!function_exists('zella_hex2rgba')):
    function zella_hex2rgba($color, $opacity = false) {
        $default = 'rgb(0,0,0)';
        if (empty($color)) {
            return $default;
        }
        if ($color[0] == '#') {
            $color = substr($color, 1);
        }

        if (strlen($color) == 6) {
            $hex = array($color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5]);
        } elseif (strlen($color) == 3) {
            $hex = array($color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2]);
        } else {
            return $default;
        }

        $rgb = array_map('hexdec', $hex);

        if ($opacity) {
            $opacity = (abs($opacity) > 1) ? '1.0' : $opacity;
            $output = 'rgba(' . implode(",", $rgb) . ',' . $opacity . ')';
        } else {
            $output = 'rgb(' . implode(",", $rgb) . ')';
        }

        return $output;
    }
endif;

// **********************************************************************// 
// ! Header get link current page
// **********************************************************************//
if (!function_exists('zella_link_page')) :

    function zella_link_page() {
        global $wp;
        return home_url($wp->request);
    }

endif;
