<?php

/*
 * Required Plugins use in theme
 * 
 */
require_once ZELLA_THEME_PATH . '/admin/classes/class-tgm-plugin-activation.php';
add_action('tgmpa_register', 'zella_register_required_plugins');
function zella_register_required_plugins() {
    $plugins = array(
        array(
            'name' => esc_html__('WooCommerce', 'zella-theme'),
            'slug' => 'woocommerce',
            'required' => true
        ),
        array(
            'name' => esc_html__('Nasa Core', 'zella-theme'),
            'slug' => 'nasa-core',
            'source' => ZELLA_THEME_PATH . '/admin/plugins/nasa-core_v1.3.4.zip',
            'required' => true,
            'version' => '1.3.4'
        ),
        array(
            'name' => esc_html__('WPBakery Page Builder', 'zella-theme'),
            'slug' => 'js_composer',
            'source' => ZELLA_THEME_PATH . '/admin/plugins/js_composer.zip',
            'required' => true,
            'version' => '6.0.5'
        ),
        array(
            'name' => esc_html__('YITH WooCommerce Wishlist', 'zella-theme'),
            'slug' => 'yith-woocommerce-wishlist',
            'required' => true
        ),
        array(
            'name' => esc_html__('YITH WooCommerce Compare', 'zella-theme'),
            'slug' => 'yith-woocommerce-compare',
            'required' => true
        ),
        array(
            'name' => esc_html__('Contact Form 7', 'zella-theme'),
            'slug' => 'contact-form-7',
            'required' => true
        ),
        array(
            'name' => esc_html__('Revolution Slider', 'zella-theme'),
            'slug' => 'revslider',
            'source' => ZELLA_THEME_PATH . '/admin/plugins/revslider.zip',
            'required' => true,
            'version' => '6.1.1'
        )
    );

    $config = array(
        'domain' => 'zella-theme', // Text domain - likely want to be the same as your theme.
        'default_path' => '', // Default absolute path to pre-packaged plugins
        'parent_slug' => 'themes.php', // Default parent menu slug
        'menu' => 'install-required-plugins', // Menu slug
        'has_notices' => true, // Show admin notices or not
        'is_automatic' => false, // Automatically activate plugins after installation or not
        'message' => '', // Message to output right before the plugins table
    );

    tgmpa($plugins, $config);
}

/*
 * Title	: SMOF
 * Description	: Slightly Modified Options Framework
 * Version	: 1.5.2
 * Author	: Syamil MJ
 * Author URI	: http://aquagraphite.com
 * License	: GPLv3 - http://www.gnu.org/copyleft/gpl.html

 * define( 'SMOF_VERSION', '1.5.2' );
 * Definitions
 *
 * @since 1.4.0
 */
$smof_output = '';

if (function_exists('wp_get_theme')) {
    if (is_child_theme()) {
        $temp_obj = wp_get_theme();
        $theme_obj = wp_get_theme($temp_obj->get('Template'));
    } else {
        $theme_obj = wp_get_theme();
    }

    $theme_name = $theme_obj->get('Name');
} else {
    $theme_data = wp_get_theme(ZELLA_THEME_PATH . '/style.css');
    $theme_name = $theme_data['Name'];
}

defined('ZELLA_ADMIN_PATH') or define('ZELLA_ADMIN_PATH', ZELLA_THEME_PATH . '/admin/');
defined('ZELLA_ADMIN_DIR_URI') or define('ZELLA_ADMIN_DIR_URI', ZELLA_THEME_URI . '/admin/');

define('ZELLA_ADMIN_THEMENAME', $theme_name);
define('ZELLA_ADMIN_SUPPORT_FORUMS', 'http://www.nasatheme.com/support/zella-documentation/');

define('ZELLA_ADMIN_BACKUPS', 'backups');

/**
 * Functions Load
 *
 * @package     WordPress
 * @subpackage  SMOF
 * @since       1.4.0
 * @author      Syamil MJ
 */

// In Admin
require_once ZELLA_THEME_PATH . '/admin/dynamic-style.php';
require_once ZELLA_THEME_PATH . '/admin/functions/functions.interface.php';
require_once ZELLA_THEME_PATH . '/admin/functions/functions.options.php';
require_once ZELLA_THEME_PATH . '/admin/functions/functions.admin.php';

add_action('admin_head', 'optionsframework_admin_message');
add_action('admin_init', 'optionsframework_admin_init');
add_action('admin_menu', 'optionsframework_add_admin');

/**
 * Required Files
 *
 * @since 1.0.0
 */
require_once ZELLA_THEME_PATH . '/admin/classes/class.options_machine.php';

/**
 * AJAX Saving Options
 *
 * @since 1.0.0
 */
add_action('wp_ajax_of_ajax_post_action', 'of_ajax_callback');

/**
 * Add editor style
 */
add_editor_style();