<?php
if (!function_exists('zella_promotion_news_heading')) {
    add_action('init', 'zella_promotion_news_heading');
    function zella_promotion_news_heading() {
        /* ----------------------------------------------------------------------------------- */
        /* The Options Array */
        /* ----------------------------------------------------------------------------------- */
        // Set the Options Array
        global $of_options;
        if(empty($of_options)) {
            $of_options = array();
        }
        
        $of_options[] = array(
            "name" => esc_html__("Promotion news", 'zella-theme'),
            "target" => "promotion-news",
            "type" => "heading"
        );

        $of_options[] = array(
            "name" => esc_html__("Enable Top bar Promotion news", 'zella-theme'),
            "desc" => esc_html__("Checked is Enable", 'zella-theme'),
            "id" => "enable_post_top",
            "std" => 0,
            "type" => "checkbox"
        );

        $of_options[] = array(
            "name" => esc_html__("Type display selected", 'zella-theme'),
            "desc" => esc_html__('Type display "My content custom" or "List posts"', 'zella-theme'),
            "id" => "type_display",
            "std" => 'custom',
            "type" => "select",
            "options" => array(
                'custom' => esc_html__('My content custom', 'zella-theme'),
                'list-posts' => esc_html__('List posts', 'zella-theme')
            ),
            'class' => 'type_promotion'
        );

        $of_options[] = array(
            "name" => esc_html__("My content custom", 'zella-theme'),
            "desc" => '<a href="javascript:void(0);" class="reset_content_custom"><b>Default value</b></a> for My content custom.<br /><a href="javascript:void(0);" class="restore_content_custom"><b>Restore text</b></a> for My content custom.<br />',
            "id" => "content_custom",
            "std" => '',
            'type' => 'textarea',
            'class' => 'hidden-tag nasa-custom_content'
        );

        $of_options[] = array(
            "name" => esc_html__("Category post", 'zella-theme'),
            "desc" => esc_html__("Post in category selected", 'zella-theme'),
            "id" => "category_post",
            "std" => '',
            "type" => "select",
            "options" => zella_cats_array(),
            'class' => 'hidden-tag nasa-list_post'
        );

        $of_options[] = array(
            "name" => esc_html__("Limit posts", 'zella-theme'),
            "desc" => esc_html__("Number posts display", 'zella-theme'),
            "id" => "number_post",
            "std" => 4,
            "type" => "text",
            'class' => 'hidden-tag nasa-list_post'
        );

        $of_options[] = array(
            "name" => esc_html__("Slide display", 'zella-theme'),
            "desc" => esc_html__("Number posts display in slide", 'zella-theme'),
            "id" => "number_post_slide",
            "std" => 1,
            "type" => "text",
            'class' => 'hidden-tag nasa-list_post'
        );

        $of_options[] = array(
            "name" => esc_html__("Display full width", 'zella-theme'),
            "desc" => esc_html__("Display full width", 'zella-theme'),
            "id" => "enable_fullwidth",
            "std" => 1,
            "type" => "checkbox"
        );

        $of_options[] = array(
            "name" => esc_html__("Text promotion color", 'zella-theme'),
            "desc" => esc_html__("Text promotion color", 'zella-theme'),
            "id" => "t_promotion_color",
            "std" => "#333",
            "type" => "color"
        );

        $of_options[] = array(
            "name" => esc_html__("Background", 'zella-theme'),
            "desc" => esc_html__("Background", 'zella-theme'),
            "id" => "background_area",
            "std" => ZELLA_THEME_URI . '/assets/images/promo_bg.jpg',
            "type" => "media"
        );
    }
}
