<?php
if (!function_exists('zella_product_global_heading')) {
    add_action('init', 'zella_product_global_heading');
    function zella_product_global_heading() {
        /* ----------------------------------------------------------------------------------- */
        /* The Options Array */
        /* ----------------------------------------------------------------------------------- */
        // Set the Options Array
        global $of_options;
        if(empty($of_options)) {
            $of_options = array();
        }
        
        $of_options[] = array(
            "name" => esc_html__("Product Global Options", 'zella-theme'),
            "target" => 'product-global',
            "type" => "heading",
        );
        
        $of_options[] = array(
            "name" => esc_html__("Content Product Style", 'zella-theme'),
            "desc" => esc_html__("Content Product Style.", 'zella-theme'),
            "id" => "style_product",
            "std" => "1-type",
            "type" => "select",
            "options" => array(
                '1-type' => esc_html__('Type 1', 'zella-theme'),
                '2-type' => esc_html__('Type 2', 'zella-theme')
            )
        );
        
        $of_options[] = array(
            "name" => esc_html__("Hover product effect", 'zella-theme'),
            "desc" => esc_html__("Select if you want change hover product image.", 'zella-theme'),
            "id" => "animated_products",
            "std" => "hover-fade",
            "type" => "select",
            "options" => array(
                "hover-fade" => esc_html__("Fade", 'zella-theme'),
                "hover-flip" => esc_html__("Flip Horizontal", 'zella-theme'),
                "hover-bottom-to-top" => esc_html__("Bottom to top", 'zella-theme'),
                "" => esc_html__("No effect", 'zella-theme')
            )
        );

        $of_options[] = array(
            "name" => esc_html__("Catalog Mode", 'zella-theme'),
            "id" => "disable-cart",
            "desc" => esc_html__("Disable.", 'zella-theme'),
            "std" => "0",
            "type" => "checkbox"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Icon Mini Cart in Header", 'zella-theme'),
            "desc" => esc_html__("Select Icon Mini Cart", 'zella-theme'),
            "id" => "mini-cart-icon",
            "std" => "2",
            "type" => "images",
            "options" => array(
                // icon-nasa-cart-2 - default
                '2' => ZELLA_ADMIN_DIR_URI . 'assets/images/mini-cart-2.jpg',
                // icon-nasa-cart-3
                '1' => ZELLA_ADMIN_DIR_URI . 'assets/images/mini-cart-1.jpg',
                // icon-nasa-cart-4
                '3' => ZELLA_ADMIN_DIR_URI . 'assets/images/mini-cart-3.jpg',
                // pe-7s-cart
                '4' => ZELLA_ADMIN_DIR_URI . 'assets/images/mini-cart-4.jpg',
                // fa fa-shopping-cart
                '5' => ZELLA_ADMIN_DIR_URI . 'assets/images/mini-cart-5.jpg'
            )
        );
        
        $of_options[] = array(
            "name" => esc_html__("Hide quickview icon in loop products", 'zella-theme'),
            "id" => "disable-quickview",
            "desc" => esc_html__("Hide quickview icon in loop products.", 'zella-theme'),
            "std" => "0",
            "type" => "checkbox"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Style Quickview", 'zella-theme'),
            "desc" => esc_html__("Style Quickview.", 'zella-theme'),
            "id" => "style_quickview",
            "std" => "sidebar",
            "type" => "select",
            "options" => array(
                'popup' => esc_html__('Popup Classical', 'zella-theme'),
                'sidebar' => esc_html__('Sidebar holder', 'zella-theme')
            )
        );
        
        $of_options[] = array(
            "name" => esc_html__("Style cart sidebar", 'zella-theme'),
            "desc" => esc_html__("Style cart sidebar.", 'zella-theme'),
            "id" => "style-cart",
            "std" => "style-1",
            "type" => "select",
            "options" => array(
                'style-1' => esc_html__('Light', 'zella-theme'),
                'style-2' => esc_html__('Dark', 'zella-theme')
            )
        );
        
        $of_options[] = array(
            "name" => esc_html__("Style wishlist sidebar", 'zella-theme'),
            "desc" => esc_html__("Style wishlist sidebar.", 'zella-theme'),
            "id" => "style-wishlist",
            "std" => "style-1",
            "type" => "select",
            "options" => array(
                'style-1' => esc_html__('Light', 'zella-theme'),
                'style-2' => esc_html__('Dark', 'zella-theme')
            )
        );
        
        $of_options[] = array(
            "name" => esc_html__("Position Cart - Wishlist sidebar", 'zella-theme'),
            "desc" => esc_html__("Position Cart - Wishlist sidebar.", 'zella-theme'),
            "id" => "position_cart_wishlist",
            "std" => "bot",
            "type" => "select",
            "options" => array(
                'bot' => esc_html__('Bottom Off-canvas', 'zella-theme'),
                'right' => esc_html__('Right Off-canvas', 'zella-theme')
            )
        );
        
        if(defined('YITH_WCPB')) {
            // Enable Gift in grid
            $of_options[] = array(
                "name" => esc_html__("Enable Promotion Gifts featured icon - Use", 'zella-theme'),
                "desc" => esc_html__("Enable Promotion Gifts featured icon products", 'zella-theme'),
                "id" => "enable_gift_featured",
                "std" => 1,
                "type" => "checkbox"
            );

            // Enable effect Gift featured
            $of_options[] = array(
                "name" => esc_html__("Enable Promotion Gifts effect featured icon", 'zella-theme'),
                "desc" => esc_html__("Enable Promotion Gifts effect featured icon.", 'zella-theme'),
                "id" => "enable_gift_effect",
                "std" => 0,
                "type" => "checkbox"
            );
        }

        // Options live search products
        $of_options[] = array(
            "name" => esc_html__("Enable live search products", 'zella-theme'),
            "desc" => esc_html__("Enable live search ajax", 'zella-theme'),
            "id" => "enable_live_search",
            "std" => 1,
            "type" => "checkbox"
        );
        
        // limit_results_search
        $of_options[] = array(
            "name" => esc_html__("Results Ajax search products limit", 'zella-theme'),
            "id" => "limit_results_search",
            "desc" => esc_html__("Input number limit products ajax search result.", 'zella-theme'),
            "std" => "5",
            "type" => "text"
        );
        // End Options live search products
        
        $of_options[] = array(
            "name" => esc_html__("Disable ajax Shop", 'zella-theme'),
            "id" => "disable_ajax_product",
            "desc" => esc_html__("Disable ajax archive product", 'zella-theme'),
            "std" => 0,
            "type" => "checkbox"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Disable ajax Shop Progress bar loading", 'zella-theme'),
            "id" => "disable_ajax_product_progress_bar",
            "desc" => esc_html__("Disable ajax Shop Progress bar loading.", 'zella-theme'),
            "std" => 0,
            "type" => "checkbox"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Display top icon filter categories", 'zella-theme'),
            "desc" => esc_html__("Display top icon filter categories. (Not use for Header 1, 2, 3)", 'zella-theme'),
            "id" => "show_icon_cat_top",
            "std" => "show-in-shop",
            "type" => "select",
            "options" => array(
                'show-in-shop' => esc_html__('Only show in shop', 'zella-theme'),
                'show-all-site' => esc_html__('Always show all pages', 'zella-theme'),
                'not-show' => esc_html__('Disabled', 'zella-theme'),
            )
        );
        
        $of_options[] = array(
            "name" => esc_html__("Disable top level of categories follow current category archive (Use for Multi stores)", 'zella-theme'),
            "desc" => esc_html__("Disable", 'zella-theme'),
            "id" => "disable_top_level_cat",
            "std" => 0,
            "type" => "checkbox"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Show Uncategorized", 'zella-theme'),
            "id" => "show_uncategorized",
            "desc" => esc_html__("Show Uncategorized", 'zella-theme'),
            "std" => 0,
            "type" => "checkbox"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Disable Viewed products", 'zella-theme'),
            "id" => "disable-viewed",
            "desc" => esc_html__("Disable Viewed products", 'zella-theme'),
            "std" => 0,
            "type" => "checkbox"
        );
        
        // limit_product_viewed
        $of_options[] = array(
            "name" => esc_html__("Viewed products limit", 'zella-theme'),
            "id" => "limit_product_viewed",
            "desc" => esc_html__("Input number limit product viewed.", 'zella-theme'),
            "std" => "12",
            "type" => "text"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Style viewed icon", 'zella-theme'),
            "desc" => esc_html__("Style viewed icon.", 'zella-theme'),
            "id" => "style-viewed-icon",
            "std" => "style-1",
            "type" => "select",
            "options" => array(
                'style-1' => esc_html__('Light', 'zella-theme'),
                'style-2' => esc_html__('Dark', 'zella-theme')
            )
        );
        
        $of_options[] = array(
            "name" => esc_html__("Style viewed sidebar", 'zella-theme'),
            "desc" => esc_html__("Style viewed sidebar.", 'zella-theme'),
            "id" => "style-viewed",
            "std" => "style-1",
            "type" => "select",
            "options" => array(
                'style-1' => esc_html__('Light', 'zella-theme'),
                'style-2' => esc_html__('Dark', 'zella-theme')
            )
        );
    }
}
