<?php
if (!function_exists('zella_breadcrumb_heading')) {
    add_action('init', 'zella_breadcrumb_heading');
    function zella_breadcrumb_heading() {
        /* ----------------------------------------------------------------------------------- */
        /* The Options Array */
        /* ----------------------------------------------------------------------------------- */
        // Set the Options Array
        global $of_options;
        if(empty($of_options)) {
            $of_options = array();
        }
        
        $of_options[] = array(
            "name" => esc_html__("Breadcrumb", 'zella-theme'),
            "target" => 'breadcumb',
            "type" => "heading"
        );

        $of_options[] = array(
            "name" => esc_html__("Show breadcrumb", 'zella-theme'),
            "desc" => esc_html__("Show breadcrumb", 'zella-theme'),
            "id" => "breadcrumb_show",
            "std" => 1,
            "type" => "checkbox",
            'class' => 'nasa-breadcrumb-flag-option'
        );

        $of_options[] = array(
            "name" => esc_html__("Breadcrumb type", 'zella-theme'),
            "desc" => esc_html__("Choose breadcrumb type.", 'zella-theme'),
            "id" => "breadcrumb_type",
            "std" => "has-background",
            "type" => "select",
            "options" => array(
                "default" => esc_html__("Without Background", 'zella-theme'),
                "has-background" => esc_html__("With Background", 'zella-theme')
            ),
            'class' => 'hidden-tag nasa-breadcrumb-type-option'
        );

        $of_options[] = array(
            "name" => esc_html__("Breadcrumb background image.", 'zella-theme'),
            "desc" => esc_html__("Breadcrumb background image.", 'zella-theme'),
            "id" => "breadcrumb_bg",
            "std" => ZELLA_THEME_URI . '/assets/images/breadcrumb-bg.jpg',
            "type" => "media",
            'class' => 'hidden-tag nasa-breadcrumb-bg-option'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Breadcrumb background parallax", 'zella-theme'),
            "desc" => esc_html__("Enable breadcrumb background parallax", 'zella-theme'),
            "id" => "breadcrumb_bg_lax",
            "std" => 1,
            "type" => "checkbox",
            'class' => 'hidden-tag nasa-breadcrumb-bg-lax'
        );

        $of_options[] = array(
            "name" => esc_html__("Breadcrumb background color.", 'zella-theme'),
            "desc" => esc_html__("Breadcrumb background color.", 'zella-theme'),
            "id" => "breadcrumb_bg_color",
            "std" => "",
            "type" => "color"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Breadcrumb Text Color", 'zella-theme'),
            "desc" => esc_html__("Change Breadcrumb Text Color", 'zella-theme'),
            "id" => "breadcrumb_color",
            "std" => "",
            "type" => "color"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Breadcrumb Text Align", 'zella-theme'),
            "desc" => esc_html__("Select if you want change Text Align.", 'zella-theme'),
            "id" => "breadcrumb_align",
            "std" => "text-left",
            "type" => "select",
            "options" => array(
                "text-center" => esc_html__("Center", 'zella-theme'),
                "text-left" => esc_html__("Left", 'zella-theme'),
                "text-right" => esc_html__("Right", 'zella-theme')
            ),
            'class' => 'hidden-tag nasa-breadcrumb-align-option'
        );

        $of_options[] = array(
            "name" => esc_html__("Height breadcrumb", 'zella-theme'),
            "desc" => esc_html__("Height breadcrumb. (px)", 'zella-theme'),
            "id" => "breadcrumb_height",
            "std" => "130",
            "type" => "text"
        );
    }
}
