<?php
if (!function_exists('zella_type_heading')) {
    add_action('init', 'zella_type_heading');
    function zella_type_heading() {
        /* ----------------------------------------------------------------------------------- */
        /* The Options Array */
        /* ----------------------------------------------------------------------------------- */
        // Set the Options Array
        global $of_options;
        if(empty($of_options)) {
            $of_options = array();
        }
        
        $google_fonts = zella_fonts();
        $custom_fonts = zella_custom_fonts();
        
        $of_options[] = array(
            "name" => esc_html__("Fonts", 'zella-theme'),
            "target" => 'fonts',
            "type" => "heading"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Font use in site", 'zella-theme'),
            "desc" => esc_html__("Select font use in your site.", 'zella-theme'),
            "id" => "type_font_select",
            "std" => "custom",
            "type" => "select",
            "options" => array(
                "" => esc_html__("Default font", 'zella-theme'),
                "custom" => esc_html__("Custom font", 'zella-theme'),
                "google" => esc_html__("Google font", 'zella-theme')
            ),
            'class' => 'nasa-type-font'
        );

        $of_options[] = array(
            "name" => esc_html__("Heading fonts (H1, H2)", 'zella-theme'),
            "desc" => esc_html__("Select heading fonts.", 'zella-theme'),
            "id" => "type_headings",
            "std" => "",
            "type" => "select_google_font",
            "preview" => array(
                "text" => '<strong>' . esc_html__("NasaTheme", 'zella-theme') . '</strong><br /><span style="font-size:60%!important">' . esc_html__("UPPERCASE TEXT", 'zella-theme') . '</span>',
                "size" => "30px"
            ),
            "options" => $google_fonts,
            'class' => 'hidden-tag nasa-type-font-glb nasa-type-font-google'
        );

        $of_options[] = array(
            "name" => esc_html__("Text fonts (paragraphs, buttons, sub-navigations)", 'zella-theme'),
            "desc" => esc_html__("Select heading fonts", 'zella-theme'),
            "id" => "type_texts",
            "std" => "",
            "type" => "select_google_font",
            "preview" => array(
                "text" => esc_html__("Lorem ipsum dosectetur adipisicing elit, sed do.Lorem ipsum dolor sit amet, consectetur Nulla fringilla purus at leo dignissim congue. Mauris elementum accumsan leo vel tempor. Sit amet cursus nisl aliquam. Aliquam et elit eu nunc rhoncus viverra quis at felis..", 'zella-theme'),
                "size" => "14px"
            ),
            "options" => $google_fonts,
            'class' => 'hidden-tag nasa-type-font-glb nasa-type-font-google'
        );

        $of_options[] = array(
            "name" => esc_html__("Main navigation", 'zella-theme'),
            "desc" => esc_html__("Select navigation fonts", 'zella-theme'),
            "id" => "type_nav",
            "std" => "",
            "type" => "select_google_font",
            "preview" => array(
                "text" => "<span style='font-size:45%'>" . esc_html__("THIS IS THE TEXT.", 'zella-theme') . "</span>",
                "size" => "30px"
            ),
            "options" => $google_fonts,
            'class' => 'hidden-tag nasa-type-font-glb nasa-type-font-google'
        );

        $of_options[] = array(
            "name" => esc_html__("Banner font", 'zella-theme'),
            "desc" => esc_html__("Select banners font", 'zella-theme'),
            "id" => "type_banner",
            "std" => "",
            "type" => "select_google_font",
            "preview" => array(
                "text" => esc_html__("This is the text.", 'zella-theme'),
                "size" => "30px"
            ),
            "options" => $google_fonts,
            'class' => 'hidden-tag nasa-type-font-glb nasa-type-font-google'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Price font", 'zella-theme'),
            "desc" => esc_html__("Select price font", 'zella-theme'),
            "id" => "type_price",
            "std" => "",
            "type" => "select_google_font",
            "preview" => array(
                "text" => esc_html__("$999.", 'zella-theme'),
                "size" => "30px"
            ),
            "options" => $google_fonts,
            'class' => 'hidden-tag nasa-type-font-glb nasa-type-font-google'
        );

        $of_options[] = array(
            "name" => esc_html__("Character Sub-sets", 'zella-theme'),
            "desc" => esc_html__("Choose the character sets you want.", 'zella-theme'),
            "id" => "type_subset",
            "std" => array("latin"),
            "type" => "multicheck",
            "options" => array(
                "latin"         => esc_html__("Latin", 'zella-theme'),
                "latin-ext"     => esc_html__("Latin Extended", 'zella-theme'),
                "cyrillic"      => esc_html__("Cyrillic", 'zella-theme'),
                "cyrillic-ext"  => esc_html__("Cyrillic Extended", 'zella-theme'),
                "greek"         => esc_html__("Greek", 'zella-theme'),
                "greek-ext"     => esc_html__("Greek Extended", 'zella-theme'),
                "arabic"        => esc_html__("Arabic", 'zella-theme'),
            ),
            'class' => 'hidden-tag nasa-type-font-glb nasa-type-font-google'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Upload new font", 'zella-theme'),
            "desc" => esc_html__("Upload new custom font.", 'zella-theme'),
            "std" => "",
            "type" => "nasa_upload_custom_font",
            'class' => 'hidden-tag nasa-type-font-glb nasa-type-font-custom'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Select custom font", 'zella-theme'),
            "desc" => esc_html__("Custom font use in site.", 'zella-theme'),
            "id" => "custom_font",
            "std" => "Zella-NS-True",
            "type" => "select",
            "options" => $custom_fonts,
            'class' => 'hidden-tag nasa-type-font-glb nasa-type-font-custom'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Include FontAwesome 5.0.13", 'zella-theme'),
            "desc" => esc_html__("Include FontAwesome 5.0.13 (Note: You only can use Free icons)", 'zella-theme'),
            "id" => "include_font_awesome_new",
            "std" => 0,
            "type" => "checkbox"
        );
    }
}
