<?php
if (!function_exists('zella_style_color_heading')) {
    add_action('init', 'zella_style_color_heading');
    function zella_style_color_heading() {
        /* ----------------------------------------------------------------------------------- */
        /* The Options Array */
        /* ----------------------------------------------------------------------------------- */
        // Set the Options Array
        global $of_options;
        if(empty($of_options)) {
            $of_options = array();
        }
        
        $of_options[] = array(
            "name" => esc_html__("Style and Colors", 'zella-theme'),
            "target" => 'style-color',
            "type" => "heading",
        );

        $of_options[] = array(
            "name" => esc_html__("Style and Colors Global Option", 'zella-theme'),
            "std" => "<h4>" . esc_html__("Style and Colors Global Option", 'zella-theme') . "</h4>",
            "type" => "info"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Primary Color", 'zella-theme'),
            "desc" => esc_html__("Change primary color. Used for primary buttons, link hover, background, etc.", 'zella-theme'),
            "id" => "color_primary",
            "std" => "",
            "type" => "color"
        );

        $of_options[] = array(
            "name" => esc_html__("Secondary Color", 'zella-theme'),
            "desc" => esc_html__("Change secondary color. Used for sale bubble.", 'zella-theme'),
            "id" => "color_secondary",
            "std" => "",
            "type" => "color"
        );

        $of_options[] = array(
            "name" => esc_html__("Success Color", 'zella-theme'),
            "desc" => esc_html__("Change the success color. Used for global success messages.", 'zella-theme'),
            "id" => "color_success",
            "std" => "",
            "type" => "color"
        );

        $of_options[] = array(
            "name" => esc_html__("Hot label Color", 'zella-theme'),
            "desc" => esc_html__("Change the hot label color. Used for product hot.", 'zella-theme'),
            "id" => "color_hot_label",
            "std" => "",
            "type" => "color"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Deal label Color", 'zella-theme'),
            "desc" => esc_html__("Change the deal label color. Used for product deal.", 'zella-theme'),
            "id" => "color_deal_label",
            "std" => "",
            "type" => "color"
        );

        $of_options[] = array(
            "name" => esc_html__("Sale label Color", 'zella-theme'),
            "desc" => esc_html__("Change the sale label color. Used for product sale.", 'zella-theme'),
            "id" => "color_sale_label",
            "std" => "",
            "type" => "color"
        );

        $of_options[] = array(
            "name" => esc_html__("Price Color", 'zella-theme'),
            "desc" => esc_html__("Change the Price color. Used for product.", 'zella-theme'),
            "id" => "color_price_label",
            "std" => "",
            "type" => "color"
        );

        $of_options[] = array(
            "name" => esc_html__("Buttons Style and Color", 'zella-theme'),
            "std" => "<h4>" . esc_html__("Buttons Style and Color", 'zella-theme') . "</h4>",
            "type" => "info"
        );
        
        $of_options[] = array(
            "name" => esc_html__("3D Style", 'zella-theme'),
            "desc" => esc_html__("Yes, please!", 'zella-theme'),
            "id" => "3d_button",
            "std" => 0,
            "type" => "checkbox"
        );

        $of_options[] = array(
            "name" => esc_html__("Buttons Background Color", 'zella-theme'),
            "desc" => esc_html__("Change background color for buttons.", 'zella-theme'),
            "id" => "color_button",
            "std" => "",
            "type" => "color"
        );

        $of_options[] = array(
            "name" => esc_html__("Buttons Background Color Hover", 'zella-theme'),
            "desc" => esc_html__("Change background color hover for buttons. Default is primary color", 'zella-theme'),
            "id" => "color_hover",
            "std" => "",
            "type" => "color"
        );

        $of_options[] = array(
            "name" => esc_html__("Buttons Border Color", 'zella-theme'),
            "desc" => esc_html__("Change border color for buttons.", 'zella-theme'),
            "id" => "button_border_color",
            "std" => "",
            "type" => "color"
        );

        $of_options[] = array(
            "name" => esc_html__("Buttons Border Color Hover", 'zella-theme'),
            "desc" => esc_html__("Change border color hover for buttons.", 'zella-theme'),
            "id" => "button_border_color_hover",
            "std" => "",
            "type" => "color"
        );

        $of_options[] = array(
            "name" => esc_html__("Buttons Text Color", 'zella-theme'),
            "desc" => esc_html__("Change text color for buttons. Default is primary color", 'zella-theme'),
            "id" => "button_text_color",
            "std" => "",
            "type" => "color"
        );

        $of_options[] = array(
            "name" => esc_html__("Buttons Text Color Hover", 'zella-theme'),
            "desc" => esc_html__("Change text color hover for buttons.", 'zella-theme'),
            "id" => "button_text_color_hover",
            "std" => "",
            "type" => "color"
        );
        $of_options[] = array(
            "name" => esc_html__("Buttons radius", 'zella-theme'),
            "desc" => esc_html__("Change Buttons Radius. (px)", 'zella-theme'),
            "id" => "button_radius",
            "std" => "0",
            "step" => "1",
            "max" => '100',
            "type" => "sliderui"
        );

        $of_options[] = array(
            "name" => esc_html__("Buttons border", 'zella-theme'),
            "desc" => esc_html__("Change Buttons Border. (px)", 'zella-theme'),
            "id" => "button_border",
            "std" => "3",
            "step" => "1",
            "max" => '5',
            "type" => "sliderui"
        );

        $of_options[] = array(
            "name" => esc_html__("Inputs radius", 'zella-theme'),
            "desc" => esc_html__("Change Radius Inputs. (px)", 'zella-theme'),
            "id" => "input_radius",
            "std" => "0",
            "step" => "1",
            "max" => "100",
            "type" => "sliderui"
        );
    }
}
