<?php
if (!function_exists('zella_logo_icon_heading')) {
    add_action('init', 'zella_logo_icon_heading');
    function zella_logo_icon_heading() {
        /* ----------------------------------------------------------------------------------- */
        /* The Options Array */
        /* ----------------------------------------------------------------------------------- */
        // Set the Options Array
        global $of_options;
        if(empty($of_options)) {
            $of_options = array();
        }
        
        $of_options[] = array(
            "name" => esc_html__("Logo and Favicon", 'zella-theme'),
            "target" => 'logo-icons',
            "type" => "heading"
        );

        $of_options[] = array(
            "name" => esc_html__("Logo", 'zella-theme'),
            "desc" => esc_html__("Upload logo here.", 'zella-theme'),
            "id" => "site_logo",
            "std" => ZELLA_THEME_URI . "/assets/images/logo.png",
            "type" => "media"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Retina Logo", 'zella-theme'),
            "desc" => esc_html__("Upload retina logo.", 'zella-theme'),
            "id" => "site_logo_retina",
            "std" => ZELLA_THEME_URI . "/assets/images/logo-retina.png",
            "type" => "media"
        );

        $of_options[] = array(
            "name" => esc_html__("Max height logo", 'zella-theme'),
            "desc" => esc_html__("Max height logo", 'zella-theme'),
            "id" => "max_height_logo",
            "std" => "40px",
            "type" => "text"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Max height logo in Mobile", 'zella-theme'),
            "desc" => esc_html__("Max height logo in Mobile", 'zella-theme'),
            "id" => "max_height_mobile_logo",
            "std" => "25px",
            "type" => "text"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Max height logo in header Sticky", 'zella-theme'),
            "desc" => esc_html__("Max height logo in header Sticky", 'zella-theme'),
            "id" => "max_height_sticky_logo",
            "std" => "25px",
            "type" => "text"
        );

        $of_options[] = array(
            "name" => esc_html__("Favicon", 'zella-theme'),
            "desc" => esc_html__("Add your custom Favicon image. 16x16px .ico or .png required. (Recommend *.ico)", 'zella-theme'),
            "id" => "site_favicon",
            "std" => "",
            "type" => "media"
        );
    }
}
