<?php
if (!function_exists('zella_general_heading')) {
    add_action('init', 'zella_general_heading');
    function zella_general_heading() {
        /* ----------------------------------------------------------------------------------- */
        /* The Options Array */
        /* ----------------------------------------------------------------------------------- */
        // Set the Options Array
        global $of_options;
        if(empty($of_options)) {
            $of_options = array();
        }
        
        $of_options[] = array(
            "name" => esc_html__("General", 'zella-theme'),
            "target" => 'general',
            "type" => "heading"
        );

        if(get_option('nasatheme_imported') !== 'imported') {
            $of_options[] = array(
                "name" => esc_html__("Import Demo Content", 'zella-theme'),
                "desc" => esc_html__("Click for import. Please ensure our plugins are activated before content is imported.", 'zella-theme'),
                "id" => "demo_data",
                'href' => '#',
                "std" => "",
                "btntext" => esc_html__("Import Demo Content", 'zella-theme'),
                "type" => "button"
            );
        }
        else {
            $of_options[] = array(
                "name" => esc_html__("Demo data imported", 'zella-theme'),
                "std" => '<h3 style="background: #fff; margin: 0; padding: 5px 10px;">' . esc_html__("Demo data was imported. If you want import demo data again, You should need reset data of your site.", 'zella-theme') . "</h3>",
                "type" => "info"
            );
        }

        $of_options[] = array(
            "name" => esc_html__("Site Layout", 'zella-theme'),
            "desc" => esc_html__("Selects site layout.", 'zella-theme'),
            "id" => "site_layout",
            "std" => "wide",
            "type" => "select",
            "options" => array(
                "wide" => esc_html__("Wide", 'zella-theme'),
                "boxed" => esc_html__("Boxed", 'zella-theme')
            ),
            'class' => 'nasa-theme-option-parent'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Site Fullwidth (max-width: 1870px)", 'zella-theme'),
            "desc" => esc_html__("Yes, please!", 'zella-theme'),
            "id" => "site_fullwidth",
            "std" => 0,
            "type" => "checkbox"
        );

        $of_options[] = array(
            "name" => esc_html__("Site Background Color", 'zella-theme'),
            "id" => "site_bg_color",
            "std" => "#eee",
            "type" => "color",
            'class' => 'nasa-site_layout nasa-site_layout-boxed nasa-theme-option-child'
        );

        $of_options[] = array(
            "name" => esc_html__("Site Background Image", 'zella-theme'),
            "id" => "site_bg_image",
            "std" => ZELLA_THEME_URI . "/assets/images/bkgd1.jpg",
            "type" => "media",
            'class' => 'nasa-site_layout nasa-site_layout-boxed nasa-theme-option-child'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Site RTL", 'zella-theme'),
            "desc" => esc_html__("Yes, please!", 'zella-theme'),
            "id" => "nasa_rtl",
            "std" => 0,
            "type" => "checkbox"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Hide Login or Register menu", 'zella-theme'),
            "desc" => esc_html__("Hide Login or Register menu.", 'zella-theme'),
            "id" => "hide_tini_menu_acc",
            "std" => 0,
            "type" => "checkbox"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Login or register by Ajax form", 'zella-theme'),
            "desc" => esc_html__("Enable Login or register by Ajax form", 'zella-theme'),
            "id" => "login_ajax",
            "std" => 1,
            "type" => "checkbox"
        );

        $of_options[] = array(
            "name" => esc_html__("Disable Transition Loading", 'zella-theme'),
            "desc" => esc_html__("Disable transition loading for all page", 'zella-theme'),
            "id" => "disable_wow",
            "std" => 0,
            "type" => "checkbox"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Delay overlay items", 'zella-theme'),
            "desc" => esc_html__("(ms) Delay overlay items.", 'zella-theme'),
            "id" => "delay_overlay",
            "std" => "100",
            "type" => "text"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Effect before load site", 'zella-theme'),
            "desc" => esc_html__("Enable Effect before load site", 'zella-theme'),
            "id" => "effect_before_load",
            "std" => 1,
            "type" => "checkbox"
        );
    }
}
