<?php 

define( 'CDVZ_TXD', esc_html__( 'xtra', 'xtra' ) );

/**
 *
 * TGMPA Configuration
 *
 * @return array
 *
 */
add_action( 'tgmpa_register', 'codevz_tgmpa' );
function codevz_tgmpa() {
	tgmpa( array(
		array(
			'name'               => 'Codevz Plus',
			'slug'               => 'codevz-plus',
			'source'             => 'http://xtratheme.com/plugins18/codevz-plus.zip',
			'version'            => '1.8',
			'required'           => true,
			'force_activation'   => false
		),
		array(
			'name'               => 'WPBakery Page Builder',
			'slug'               => 'js_composer',
			'source'             => 'http://xtratheme.com/plugins18/js_composer.zip',
			'required'           => true,
			'force_activation'   => false
		),
		array(
			'name'               => 'Revolution Slider',
			'slug'               => 'revslider',
			'source'            => 'http://xtratheme.com/plugins18/revslider.zip',
			'required'          => true,
			'force_activation'  => false
		),
		array(
			'name'              => 'Contact form 7',
			'slug'              => 'contact-form-7',
			'required'          => false,
		),
		array(
			'name'               => 'Woocommerce',
			'slug'                => 'woocommerce',
			'required'          => false,
		),
	), array(
		'id'          		=> 'tgmpa',
		'default_path'      => '', 
		'menu'          	=> 'tgmpa-install-plugins',
		'parent_slug'       => 'themes.php',
		'capability'      	=> 'edit_theme_options',
		'has_notices'       => true,
		'dismissable'       => true,
		'dismiss_msg'       => '',
		'is_automatic'      => false, 
		'message'         	=> ''
	));
}


/**
 *
 * Presets
 *
 * @return array
 *
 */
require_once( $dir . 'config/presets/_presets.php' );
add_filter( 'codevz_presets__________', 'codevz_presets_filter', 10, 2 );
function codevz_presets_filter( $p, $color ) {

	// Add Preset
	$p['cz_button']['default']['s'] = '[cz_button title="Hello World !" link="url:%23|||" btn_position="cz_btn_inline" icon="fa fa-phone-square" icon_position="before" text_effect="cz_btn_txt_no_fx" btn_effect="cz_btn_zoom_in" scale="1" sk_button="border-radius:30px 0 30px 0;padding-left:30px;padding-right:30px;font-size:22px;background:' . $color . ';" sk_hover="color:#ffffff;"]';

	return $p;
}


/**
 *
 * Templates
 *
 * @return array
 *
 */
require_once( $dir . 'config/templates/_templates.php' );
add_filter( 'codevz_presets__________', 'codevz_templates_filter', 10, 2 );
function codevz_templates_filter( $p, $color ) {

	// Add Template
	$p[] = array(
		'f' => 'test 1_jpg',
		'c' =>'[vc_row][vc_column width="1/2" offset="vc_col-lg-3"][cz_service_box icon="fa fa-check-circle" id="cz_21291" sk_icon_con="margin-top:-10px;margin-left:30px;" sk_icon="color:#1e73be;" sk_overall="margin-left:-50px;" sk_overall_mobile="margin-bottom:30px;margin-left:0px;"]<div style="line-height: 1.4; text-align: justify;"><span style="font-size: 13px;">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliq.</span></div>[/cz_service_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_service_box icon="fa fa-pencil-square-o" id="cz_52881" sk_icon_con="margin-top:-10px;margin-left:30px;" sk_icon="color:#1e73be;" sk_overall="margin-left:-50px;" sk_overall_mobile="margin-bottom:30px;margin-left:0px;"]<div style="line-height: 1.4; text-align: justify;"><span style="font-size: 13px;">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliq.</span></div>[/cz_service_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_service_box icon="fa fa-globe" id="cz_83546" sk_icon_con="margin-top:-10px;margin-left:30px;" sk_icon="color:#1e73be;" sk_overall="margin-left:-50px;" sk_overall_mobile="margin-bottom:30px;margin-left:0px;"]<div style="line-height: 1.4; text-align: justify;"><span style="font-size: 13px;">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliq.</span></div>[/cz_service_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_service_box icon="fa fa-cogs" id="cz_50444" sk_icon_con="margin-left:30px;" sk_icon="color:#1e73be;" sk_overall="margin-left:-50px;" sk_overall_mobile="margin-bottom:30px;margin-left:0px;"]<div style="line-height: 1.4; text-align: justify;"><span style="font-size: 13px;">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliq.</span></div>[/cz_service_box][/vc_column][/vc_row]',
	);

	return $p;
}