<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.

/**
 * Premium WPB Templates
 */

if ( ! class_exists( 'Codevz_Templates' ) ) {

	class Codevz_Templates {

		use Codevz_Plus_Instance;

		// Core functionality.
		public function __construct() {

			add_action( 'vc_load_default_templates_action', [ $this, 'append_templates' ] );

		}

		/**
		 * Premium wpbakery templates filters.
		 * 
		 * @return string
		 */
		public function filters() {
			?><ul class="cz_vc_filters hidden" data-tab-title="<?php esc_html_e( 'Premium Templates', 'codevz-plus' ); ?>">
				<li data-filter="vc_ui-template" class="cz_active"><?php esc_html_e( 'All Templates', 'codevz-plus' ); ?></li>
				<li data-filter="about"><?php esc_html_e( 'About', 'codevz-plus' ); ?></li>
				<li data-filter="accordion"><?php esc_html_e( 'Accordion', 'codevz-plus' ); ?></li>
				<li data-filter="banner"><?php esc_html_e( 'Banner', 'codevz-plus' ); ?></li>
				<li data-filter="blog"><?php esc_html_e( 'Blog', 'codevz-plus' ); ?></li>
				<li data-filter="cta"><?php esc_html_e( 'Call to Action', 'codevz-plus' ); ?></li>
				<li data-filter="clients"><?php esc_html_e( 'Clients', 'codevz-plus' ); ?></li>
				<li data-filter="contact"><?php esc_html_e( 'Contact', 'codevz-plus' ); ?></li>
				<li data-filter="counter"><?php esc_html_e( 'Counter', 'codevz-plus' ); ?></li>
				<li data-filter="countdown"><?php esc_html_e( 'Countdown', 'codevz-plus' ); ?></li>
				<li data-filter="gallery"><?php esc_html_e( 'Gallery', 'codevz-plus' ); ?></li>
				<li data-filter="googlemap"><?php esc_html_e( 'Google Map', 'codevz-plus' ); ?></li>
				<li data-filter="hero"><?php esc_html_e( 'Hero Section', 'codevz-plus' ); ?></li>
				<li data-filter="pricing"><?php esc_html_e( 'Pricing', 'codevz-plus' ); ?></li>
				<li data-filter="quote"><?php esc_html_e( 'Quote', 'codevz-plus' ); ?></li>
				<li data-filter="services"><?php esc_html_e( 'Services', 'codevz-plus' ); ?></li>
				<li data-filter="skills"><?php esc_html_e( 'Skill', 'codevz-plus' ); ?></li>
				<li data-filter="shop"><?php esc_html_e( 'Shop', 'codevz-plus' ); ?></li>
				<li data-filter="social"><?php esc_html_e( 'Social Icons', 'codevz-plus' ); ?></li>
				<li data-filter="tabs"><?php esc_html_e( 'Tabs', 'codevz-plus' ); ?></li>
				<li data-filter="team"><?php esc_html_e( 'Team', 'codevz-plus' ); ?></li>
				<li data-filter="testimonial"><?php esc_html_e( 'Testimonial', 'codevz-plus' ); ?></li>
				<li data-filter="video"><?php esc_html_e( 'Video', 'codevz-plus' ); ?></li>
				<li data-filter="misc"><?php esc_html_e( 'Misc', 'codevz-plus' ); ?></li>
			</ul><?php
		}

		/**
		 * Append templates tp WPBakery templates library.
		 * 
		 * @return array
		 */
		public function append_templates() {

			if ( Codevz_Plus::is_free() ) {
				//echo Codevz_Plus::pro_message( esc_html__( 'To access all the theme premium templates', 'codevz-plus' ) );
				return false;
			}

			add_action( 'admin_footer', [ $this, 'filters' ] );

			foreach ( $this->templates() as $t ) {
				
				$data               = [];
				$data['name']       = $t['f'];
				$data['custom_class'] = $t['f'];
				$data['content']    = $t['c'] . '[vc_row][vc_column][cz_gap height="100px"][/vc_column][/vc_row]';

				vc_add_default_templates( $data );
			}

		}

		/**
		 * List of all premium templates.
		 * 
		 * @return array
		 */
		public function templates( $n = 'x' ) {

			// Set theme default color.
			if ( Codevz_Plus::option( 'site_color' ) ) {
				$color = Codevz_Plus::option( 'site_color' );
			} else {
				$color = '#000000';
			}

			/* Set theme default Image & Video */
			$imgu = 'https://xtratheme.com/img/';
			$img = 'https://xtratheme.com/img/1000x1000.jpg';
			$vid = 'https://youtube.com/watch?v=AvWjf_RUy4c';

			$p = array(
					array(
						'f' => 'service box services icon blue 4 columns minimal simple 1_jpg',
						'c' =>'[vc_row][vc_column width="1/2" offset="vc_col-lg-3"][cz_service_box icon="fa fa-check-circle" id="cz_21291" sk_icon_con="margin-top:-10px;margin-left:30px;" sk_icon="color:#1e73be;" sk_overall="margin-left:-50px;" sk_overall_mobile="margin-bottom:30px;margin-left:0px;"]<div style="line-height: 1.4; text-align: justify;"><span style="font-size: 13px;">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliq.</span></div>[/cz_service_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_service_box icon="fa fa-pencil-square-o" id="cz_52881" sk_icon_con="margin-top:-10px;margin-left:30px;" sk_icon="color:#1e73be;" sk_overall="margin-left:-50px;" sk_overall_mobile="margin-bottom:30px;margin-left:0px;"]<div style="line-height: 1.4; text-align: justify;"><span style="font-size: 13px;">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliq.</span></div>[/cz_service_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_service_box icon="fa fa-globe" id="cz_83546" sk_icon_con="margin-top:-10px;margin-left:30px;" sk_icon="color:#1e73be;" sk_overall="margin-left:-50px;" sk_overall_mobile="margin-bottom:30px;margin-left:0px;"]<div style="line-height: 1.4; text-align: justify;"><span style="font-size: 13px;">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliq.</span></div>[/cz_service_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_service_box icon="fa fa-cogs" id="cz_50444" sk_icon_con="margin-left:30px;" sk_icon="color:#1e73be;" sk_overall="margin-left:-50px;" sk_overall_mobile="margin-bottom:30px;margin-left:0px;"]<div style="line-height: 1.4; text-align: justify;"><span style="font-size: 13px;">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliq.</span></div>[/cz_service_box][/vc_column][/vc_row]',
					),
					array(
						'f' => 'service box services icon blue 3 columns border rounded 2_jpg',
						'c' =>'[vc_row][vc_column width="1/3"][cz_service_box icon="fa fa-check-square" title="Best Service" id="cz_96129" sk_icon_con="padding:5px;margin-top:8px;border-style:solid;border-width:2px;border-color:#1e73be;border-radius:5px;" sk_icon="font-size:2em;color:#1e73be;" sk_title="font-size:24px;border-style:solid;"]<div style="line-height: 1.5; text-align: justify; font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore.</div>[/cz_service_box][cz_button title="Learn More" btn_position="cz_btn_right cz_mobile_btn_center" btn_effect="cz_btn_fill_right" icon_position="after" id="cz_98648" link="url:%23|||" sk_button="font-size:11px;color:#1e73be;background-color:#ffffff;padding:5px 12px;margin-top:15px;margin-bottom:30px;border-style:solid;border-width:2px;border-color:#1e73be;border-radius:4px;" sk_hover="color:#ffffff;background-color:#1e73be;" sk_icon_hover="color:#ffffff;"][/vc_column][vc_column width="1/3"][cz_service_box icon="fa fa-check-square" title="Best Service" id="cz_38362" sk_icon_con="padding:5px;margin-top:8px;border-style:solid;border-width:2px;border-color:#1e73be;border-radius:5px;" sk_icon="font-size:2em;color:#1e73be;" sk_title="font-size:24px;border-style:solid;"]<div style="line-height: 1.5; text-align: justify; font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore.</div>[/cz_service_box][cz_button title="Learn More" btn_position="cz_btn_right cz_mobile_btn_center" btn_effect="cz_btn_fill_right" icon_position="after" id="cz_26481" link="url:%23|||" sk_button="font-size:11px;color:#1e73be;background-color:#ffffff;padding:5px 12px;margin-top:15px;margin-bottom:30px;border-style:solid;border-width:2px;border-color:#1e73be;border-radius:4px;" sk_hover="color:#ffffff;background-color:#1e73be;" sk_icon_hover="color:#ffffff;"][/vc_column][vc_column width="1/3"][cz_service_box icon="fa fa-check-square" title="Best Service" id="cz_32247" sk_icon_con="padding:5px;margin-top:8px;border-style:solid;border-width:2px;border-color:#1e73be;border-radius:5px;" sk_icon="font-size:2em;color:#1e73be;" sk_title="font-size:24px;border-style:solid;"]<div style="line-height: 1.5; text-align: justify; font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore.</div>[/cz_service_box][cz_button title="Learn More" btn_position="cz_btn_right cz_mobile_btn_center" btn_effect="cz_btn_fill_right" icon_position="after" id="cz_65089" link="url:%23|||" sk_button="font-size:11px;color:#1e73be;background-color:#ffffff;padding:5px 12px;margin-top:15px;margin-bottom:30px;border-style:solid;border-width:2px;border-color:#1e73be;border-radius:4px;" sk_hover="color:#ffffff;background-color:#1e73be;" sk_icon_hover="color:#ffffff;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'service box services icon columns solid circle pink 3_jpg',
						'c' =>'[vc_row][vc_column width="1/3"][cz_service_box icon="fa fa-check-circle" title="Best Service" id="cz_82206" sk_icon_con="background-color:#e91e63;padding:5px;margin-top:8px;border-radius:100px;" sk_icon="font-size:2em;color:#ffffff;" sk_title="font-size:24px;border-style:solid;"]<div style="line-height: 1.5; text-align: justify; font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore.</div>[/cz_service_box][cz_button title="Learn More" btn_position="cz_btn_right cz_mobile_btn_center" btn_effect="cz_btn_zoom_in" icon_position="after" id="cz_57736" link="url:%23|||" sk_button="font-size:11px;color:#ffffff;background-color:#e91e63;padding:5px 12px;margin-top:0px;margin-bottom:30px;border-color:#1e73be;border-radius:50px;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;" sk_button_mobile="margin-bottom:50px;"][/vc_column][vc_column width="1/3"][cz_service_box icon="fa fa-check-circle" title="Best Service" id="cz_16922" sk_icon_con="background-color:#e91e63;padding:5px;margin-top:8px;border-radius:100px;" sk_icon="font-size:2em;color:#ffffff;" sk_title="font-size:24px;border-style:solid;"]<div style="line-height: 1.5; text-align: justify; font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore.</div>[/cz_service_box][cz_button title="Learn More" btn_position="cz_btn_right cz_mobile_btn_center" btn_effect="cz_btn_zoom_in" icon_position="after" id="cz_31320" link="url:%23|||" sk_button="font-size:11px;color:#ffffff;background-color:#e91e63;padding:5px 12px;margin-top:0px;margin-bottom:30px;border-color:#1e73be;border-radius:50px;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;" sk_button_mobile="margin-bottom:50px;"][/vc_column][vc_column width="1/3"][cz_service_box icon="fa fa-check-circle" title="Best Service" id="cz_63110" sk_icon_con="background-color:#e91e63;padding:5px;margin-top:8px;border-radius:100px;" sk_icon="font-size:2em;color:#ffffff;" sk_title="font-size:24px;border-style:solid;"]<div style="line-height: 1.5; text-align: justify; font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore.</div>[/cz_service_box][cz_button title="Learn More" btn_position="cz_btn_right cz_mobile_btn_center" btn_effect="cz_btn_zoom_in" icon_position="after" id="cz_37708" link="url:%23|||" sk_button="font-size:11px;color:#ffffff;background-color:#e91e63;padding:5px 12px;margin-top:0px;margin-bottom:30px;border-color:#1e73be;border-radius:50px;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;" sk_button_mobile="margin-bottom:50px;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'service box services icon 3 columns solid hexagonal solid orange 4_jpg',
						'c' =>'[vc_row][vc_column width="1/3"][cz_service_box style="style9" icon="fa fa-check-circle" title="Best Service" id="cz_87261" sk_icon_con="padding:5px;margin-top:8px;border-radius:100px;" sk_icon="font-size:48px;color:#ffffff;background-color:#ffc107;" sk_title="font-size:24px;color:#000000;border-style:solid;" cz_service_box=""]<div style="line-height: 1.5; text-align: justify; font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore.</div>[/cz_service_box][cz_button title="Learn More" btn_position="cz_btn_right cz_mobile_btn_center" btn_effect="cz_btn_zoom_in" icon_position="after" id="cz_31467" link="url:%23|||" sk_button="font-size:11px;color:#ffffff;background-color:#ffc107;padding:5px 12px;margin-top:0px;margin-bottom:30px;border-color:#1e73be;" cz_button="" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;" sk_button_mobile="margin-bottom:50px;"][/vc_column][vc_column width="1/3"][cz_service_box style="style9" icon="fa fa-check-circle" title="Best Service" id="cz_68692" sk_icon_con="padding:5px;margin-top:8px;border-radius:100px;" sk_icon="font-size:48px;color:#ffffff;background-color:#ffc107;" sk_title="font-size:24px;color:#000000;border-style:solid;" cz_service_box=""]<div style="line-height: 1.5; text-align: justify; font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore.</div>[/cz_service_box][cz_button title="Learn More" btn_position="cz_btn_right cz_mobile_btn_center" btn_effect="cz_btn_zoom_in" icon_position="after" id="cz_79908" link="url:%23|||" sk_button="font-size:11px;color:#ffffff;background-color:#ffc107;padding:5px 12px;margin-top:0px;margin-bottom:30px;border-color:#1e73be;" cz_button="" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;" sk_button_mobile="margin-bottom:50px;"][/vc_column][vc_column width="1/3"][cz_service_box style="style9" icon="fa fa-check-circle" title="Best Service" id="cz_71607" sk_icon_con="padding:5px;margin-top:8px;border-radius:100px;" sk_icon="font-size:48px;color:#ffffff;background-color:#ffc107;" sk_title="font-size:24px;color:#000000;border-style:solid;" cz_service_box=""]<div style="line-height: 1.5; text-align: justify; font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore.</div>[/cz_service_box][cz_button title="Learn More" btn_position="cz_btn_right cz_mobile_btn_center" btn_effect="cz_btn_zoom_in" icon_position="after" id="cz_60545" link="url:%23|||" sk_button="font-size:11px;color:#ffffff;background-color:#ffc107;padding:5px 12px;margin-top:0px;margin-bottom:30px;border-color:#1e73be;" cz_button="" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;" sk_button_mobile="margin-bottom:50px;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'service box services icon green 4 columns shadow 5_jpg',
						'c' =>'[vc_row][vc_column width="1/4"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_34868" sk_overall="padding-bottom:35px;padding-top:5px;background-color:#ffffff;box-shadow:0px 0px 15px rgba(0,0,0,0.12) ;"][cz_service_box type="vertical" icon="fa fa-pagelines" title="Eco Friendly" id="cz_68977" sk_title="font-size:24px;color:#444444;" sk_icon="font-size:42px;color:#92c800;" sk_icon_con="margin-bottom:10px;" cz_service_box=""]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_button title="Read More" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_60111" sk_button="background-color:#92c800;padding-top:5px;margin-top:7px;position:relative;display: table;margin:0 auto;font-weight:400;font-size:13px;color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/4"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_69469" sk_overall="padding-bottom:35px;padding-top:5px;background-color:#ffffff;box-shadow:0px 0px 15px rgba(0,0,0,0.12) ;"][cz_service_box type="vertical" icon="fa fa-pencil-square-o" title="Business Plan" id="cz_43473" sk_title="font-size:24px;color:#444444;" sk_icon="font-size:42px;color:#92c800;" sk_icon_con="margin-bottom:10px;" cz_service_box=""]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_button title="Read More" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_14489" sk_button="background-color:#92c800;padding-top:5px;margin-top:7px;position:relative;display: table;margin:0 auto;font-weight:400;font-size:13px;color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/4"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_12221" sk_overall="padding-bottom:35px;padding-top:5px;background-color:#ffffff;box-shadow:0px 0px 15px rgba(0,0,0,0.12) ;"][cz_service_box type="vertical" icon="fa fa-globe" title="Global Design" id="cz_70284" sk_title="font-size:24px;color:#444444;" sk_icon="font-size:42px;color:#92c800;" sk_icon_con="margin-bottom:10px;" cz_service_box=""]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_button title="Read More" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_43577" sk_button="background-color:#92c800;padding-top:5px;margin-top:7px;position:relative;display: table;margin:0 auto;font-weight:400;font-size:13px;color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/4"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_79475" sk_overall="padding-bottom:35px;padding-top:5px;background-color:#ffffff;box-shadow:0px 0px 15px rgba(0,0,0,0.12) ;"][cz_service_box type="vertical" icon="fa fa-cog" title="Management" id="cz_85748" sk_title="font-size:24px;color:#444444;" sk_icon="font-size:42px;color:#92c800;" sk_icon_con="margin-bottom:10px;" cz_service_box=""]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_button title="Read More" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_20317" sk_button="background-color:#92c800;padding-top:5px;margin-top:7px;position:relative;display: table;margin:0 auto;font-weight:400;font-size:13px;color:#ffffff;"][/cz_content_box][/vc_column][/vc_row]
	',
					),
					array(
						'f' => 'service box services icon blue grey 4 columns gradient 6_jpg',
						'c' =>'[vc_row][vc_column width="1/4"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" id="cz_11587" sk_overall="border-radius:5px;border-bottom-style:solid;border-color:#dddddd;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-bottom:35px;padding-top:5px;border-width:1px 1px 1px 1px;background-color:unset !important;background-image:linear-gradient(180deg,#ffffff,#eeeeee);"][cz_service_box type="vertical" icon="fa fa-check-square-o" title="Best Services" id="cz_66403" sk_title="font-size:24px;color:#001e69;" sk_icon="font-size:36px;color:#1e73be;" sk_icon_con="margin-bottom:10px;" cz_service_box=""]
	<div style="line-height: 1.2; text-align: justify;"><span style="font-size: 13px; color: #666;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_button title="Read More" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_25313" sk_button="border-radius:3px;background-color:#1e73be;padding-top:5px;margin-top:7px;position:relative;display: table;margin:0 auto;font-weight:400;font-size:12px;color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/4"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" id="cz_34453" sk_overall="border-radius:5px;border-bottom-style:solid;border-color:#dddddd;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-bottom:35px;padding-top:5px;border-width:1px 1px 1px 1px;background-color:unset !important;background-image:linear-gradient(180deg,#ffffff,#eeeeee);"][cz_service_box type="vertical" icon="fa fa-pencil-square-o" title="Business Plan" id="cz_40528" sk_title="font-size:24px;color:#001e69;" sk_icon="font-size:36px;color:#1e73be;" sk_icon_con="margin-bottom:10px;" cz_service_box=""]
	<div style="line-height: 1.2; text-align: justify;"><span style="font-size: 13px; color: #666;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_button title="Read More" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_74303" sk_button="border-radius:3px;background-color:#1e73be;padding-top:5px;margin-top:7px;position:relative;display: table;margin:0 auto;font-weight:400;font-size:12px;color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/4"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" id="cz_99262" sk_overall="border-radius:5px;border-bottom-style:solid;border-color:#dddddd;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-bottom:35px;padding-top:5px;border-width:1px 1px 1px 1px;background-color:unset !important;background-image:linear-gradient(180deg,#ffffff,#eeeeee);"][cz_service_box type="vertical" icon="fa fa-diamond" title="Global Design" id="cz_41652" sk_title="font-size:24px;color:#001e69;" sk_icon="font-size:36px;color:#1e73be;" sk_icon_con="margin-bottom:10px;" cz_service_box=""]
	<div style="line-height: 1.2; text-align: justify;"><span style="font-size: 13px; color: #666;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_button title="Read More" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_77486" sk_button="border-radius:3px;background-color:#1e73be;padding-top:5px;margin-top:7px;position:relative;display: table;margin:0 auto;font-weight:400;font-size:12px;color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/4"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" id="cz_72239" sk_overall="border-radius:5px;border-bottom-style:solid;border-color:#dddddd;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-bottom:35px;padding-top:5px;border-width:1px 1px 1px 1px;background-color:unset !important;background-image:linear-gradient(180deg,#ffffff,#eeeeee);"][cz_service_box type="vertical" icon="fa fa-cogs" title="Management" id="cz_44337" sk_title="font-size:24px;color:#001e69;" sk_icon="font-size:36px;color:#1e73be;" sk_icon_con="margin-bottom:10px;" cz_service_box=""]
	<div style="line-height: 1.2; text-align: justify;"><span style="font-size: 13px; color: #666;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_button title="Read More" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_75879" sk_button="border-radius:3px;background-color:#1e73be;padding-top:5px;margin-top:7px;position:relative;display: table;margin:0 auto;font-weight:400;font-size:12px;color:#ffffff;"][/cz_content_box][/vc_column][/vc_row]',
					),
					array(
						'f' => 'service box services icon 3 columns border circle blue 7_jpg',
						'c' =>'[vc_row][vc_column width="1/3"][cz_service_box type="vertical" icon="fa fa-check-circle" title="Best Service" id="cz_88340" sk_title="font-size:24px;color:#001e69;" sk_icon="font-size:36px;color:#1e73be;" sk_icon_con="border-style:solid;border-width:3px;border-color:#1e73be;border-radius:100%;" cz_service_box=""]
	<div style="line-height: 1.3; text-align: center;"><span style="font-size: 13px; color: #666;"><span style="font-size: 14px; font-weight: 300;">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id, condimentum at, laoreet mattis, massa. Sed eleifend nonummy diam.</span>
	</span></div>
	[/cz_service_box][cz_button title="Learn More" btn_position="cz_btn_center" btn_effect="cz_btn_fill_up" link="url:%23|||" id="cz_29238" sk_button="position:relative;font-size:12px;color:#1e73be;background-color:rgba(255,255,255,0.01);padding:6px 18px;margin:0 auto;border-style:solid;border-width:3px;border-color:#1e73be;border-radius:50px;" sk_hover="color:#ffffff;background-color:#1e73be;" cz_button=""][/vc_column][vc_column width="1/3"][cz_service_box type="vertical" icon="fa fa-pie-chart" title="Business Analysis" id="cz_60745" sk_title="font-size:24px;color:#001e69;" sk_icon="font-size:36px;color:#1e73be;" sk_icon_con="border-radius:100%;border-bottom-style:solid;border-color:#1e73be;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:3px 3px 3px 3px;" cz_service_box=""]
	<div style="line-height: 1.3; text-align: center;"><span style="font-size: 13px; color: #666;"><span style="font-size: 14px; font-weight: 300;">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id, condimentum at, laoreet mattis, massa. Sed eleifend nonummy diam.</span>
	</span></div>
	[/cz_service_box][cz_button title="Learn More" btn_position="cz_btn_center" btn_effect="cz_btn_fill_up" link="url:%23|||" id="cz_93641" sk_button="position:relative;font-size:12px;color:#1e73be;background-color:rgba(255,255,255,0.01);padding:6px 18px;margin:0 auto;border-style:solid;border-width:3px;border-color:#1e73be;border-radius:50px;" sk_hover="color:#ffffff;background-color:#1e73be;" cz_button=""][/vc_column][vc_column width="1/3"][cz_service_box type="vertical" icon="fa fa-globe" title="Global Design" id="cz_35586" sk_title="font-size:24px;color:#001e69;" sk_icon="font-size:36px;color:#1e73be;" sk_icon_con="border-radius:100%;border-bottom-style:solid;border-color:#1e73be;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:3px 3px 3px 3px;" cz_service_box=""]
	<div style="line-height: 1.3; text-align: center;"><span style="font-size: 13px; color: #666;"><span style="font-size: 14px; font-weight: 300;">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id, condimentum at, laoreet mattis, massa. Sed eleifend nonummy diam.</span>
	</span></div>
	[/cz_service_box][cz_button title="Learn More" btn_position="cz_btn_center" btn_effect="cz_btn_fill_up" link="url:%23|||" id="cz_69296" sk_button="position:relative;font-size:12px;color:#1e73be;background-color:rgba(255,255,255,0.01);padding:6px 18px;margin:0 auto;border-style:solid;border-width:3px;border-color:#1e73be;border-radius:50px;" sk_hover="color:#ffffff;background-color:#1e73be;" cz_button=""][/vc_column][/vc_row]',
					),
					array(
						'f' => 'service box services icon 3 columns border square pink 8_jpg',
						'c' =>'[vc_row][vc_column width="1/3"][cz_service_box type="vertical" icon="fa fa-check" title="Best Service" id="cz_29202" sk_overall="border-bottom-style:solid;border-color:#cccccc;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:30px 40px 40px 40px;border-width:3px 3px 3px 3px;margin-top:0px;" sk_title="font-size:36px;color:#e91e63;font-weight:400;" sk_icon="font-size:36px;color:#e91e63;" sk_icon_con="border-bottom-style:solid;border-color:#cccccc;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:3px 3px 3px 3px;margin-top:5px;" cz_service_box=""]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_button title="Learn More" btn_position="cz_btn_block" icon_position="after" link="url:%23|||" icon="fa fa-long-arrow-right" id="cz_17510" sk_button="border-bottom-style:solid;border-color:#cccccc;border-top-style:solid;border-right-style:solid;border-left-style:solid;background-color:#ffffff;padding-bottom:10px;padding-top:10px;border-width:3px 3px 3px 3px;margin-top:-3px;position:relative;display: block;text-align:center;color:#e91e63;" sk_hover="border-bottom-style:solid;border-color:#e91e63;border-top-style:solid;border-right-style:solid;border-left-style:solid;background-color:#e91e63;border-width:3px 3px 3px 3px;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/vc_column][vc_column width="1/3"][cz_service_box type="vertical" icon="fa fa-check" title="Best Service" id="cz_97032" sk_overall="border-bottom-style:solid;border-color:#cccccc;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:30px 40px 40px 40px;border-width:3px 3px 3px 3px;margin-top:0px;" sk_title="font-size:36px;color:#e91e63;font-weight:400;" sk_icon="font-size:36px;color:#e91e63;" sk_icon_con="border-bottom-style:solid;border-color:#cccccc;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:3px 3px 3px 3px;margin-top:5px;" cz_service_box=""]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_button title="Learn More" btn_position="cz_btn_block" icon_position="after" link="url:%23|||" icon="fa fa-long-arrow-right" id="cz_17777" sk_button="border-bottom-style:solid;border-color:#cccccc;border-top-style:solid;border-right-style:solid;border-left-style:solid;background-color:#ffffff;padding-bottom:10px;padding-top:10px;border-width:3px 3px 3px 3px;margin-top:-3px;position:relative;display: block;text-align:center;color:#e91e63;" sk_hover="border-bottom-style:solid;border-color:#e91e63;border-top-style:solid;border-right-style:solid;border-left-style:solid;background-color:#e91e63;border-width:3px 3px 3px 3px;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/vc_column][vc_column width="1/3"][cz_service_box type="vertical" icon="fa fa-check" title="Best Service" id="cz_35015" sk_overall="border-bottom-style:solid;border-color:#cccccc;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:30px 40px 40px 40px;border-width:3px 3px 3px 3px;margin-top:0px;" sk_title="font-size:36px;color:#e91e63;font-weight:400;" sk_icon="font-size:36px;color:#e91e63;" sk_icon_con="border-bottom-style:solid;border-color:#cccccc;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:3px 3px 3px 3px;margin-top:5px;" cz_service_box=""]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_button title="Learn More" btn_position="cz_btn_block" icon_position="after" link="url:%23|||" icon="fa fa-long-arrow-right" id="cz_84724" sk_button="border-bottom-style:solid;border-color:#cccccc;border-top-style:solid;border-right-style:solid;border-left-style:solid;background-color:#ffffff;padding-bottom:10px;padding-top:10px;border-width:3px 3px 3px 3px;margin-top:-3px;position:relative;display: block;text-align:center;color:#e91e63;" sk_hover="border-bottom-style:solid;border-color:#e91e63;border-top-style:solid;border-right-style:solid;border-left-style:solid;background-color:#e91e63;border-width:3px 3px 3px 3px;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'service box services icon 3 columns border hexagonal blue 9_jpg',
						'c' =>'[vc_row][vc_column width="1/3"][cz_service_box style="style9" type="vertical" icon="fa fa-check-circle" title="Best Service" id="cz_15338" sk_title="font-size:30px;color:#3f51b5;" sk_icon="color:#3f51b5;"]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_button title="Read More" btn_position="cz_btn_center" btn_effect="cz_btn_fill_right" link="url:%23|||" icon="fa fa-angle-right" id="cz_67188" sk_button="position:relative;font-size:12px;color:#3f51b5;font-weight:500;background-color:#ffffff;padding-top:5px;padding-bottom:5px;margin:0 auto;border-style:solid;border-width:3px;border-color:#3f51b5;" sk_hover="background-color:#3f51b5;color:#ffffff;" sk_icon_hover="color:#ffffff;" cz_button=""][/vc_column][vc_column width="1/3"][cz_service_box style="style9" type="vertical" icon="fa fa-globe" title="Global Design" id="cz_40224" sk_title="font-size:30px;color:#3f51b5;" sk_icon="color:#3f51b5;"]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_button title="Read More" btn_position="cz_btn_center" btn_effect="cz_btn_fill_right" link="url:%23|||" icon="fa fa-angle-right" id="cz_72289" sk_button="position:relative;font-size:12px;color:#3f51b5;font-weight:500;background-color:#ffffff;padding-top:5px;padding-bottom:5px;margin:0 auto;border-style:solid;border-width:3px;border-color:#3f51b5;" sk_hover="background-color:#3f51b5;color:#ffffff;" sk_icon_hover="color:#ffffff;" cz_button=""][/vc_column][vc_column width="1/3"][cz_service_box style="style9" type="vertical" icon="fa fa-cog" title="Management" id="cz_85088" sk_title="font-size:30px;color:#3f51b5;" sk_icon="color:#3f51b5;"]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_button title="Read More" btn_position="cz_btn_center" btn_effect="cz_btn_fill_right" link="url:%23|||" icon="fa fa-angle-right" id="cz_28953" sk_button="position:relative;font-size:12px;color:#3f51b5;font-weight:500;background-color:#ffffff;padding-top:5px;padding-bottom:5px;margin:0 auto;border-style:solid;border-width:3px;border-color:#3f51b5;" sk_hover="background-color:#3f51b5;color:#ffffff;" sk_icon_hover="color:#ffffff;" cz_button=""][/vc_column][/vc_row]',
					),
					array(
						'f' => 'service box services icon blu 4 columns rounded border 10_jpg',
						'c' =>'[vc_row][vc_column width="1/4"][cz_service_box type="vertical" icon="fa fa-check" title="Best Service" id="cz_99557" cz_service_box="" sk_title="font-size:22px;color:#001e69;letter-spacing:2px;" sk_icon="font-size:30px;color:#ffffff;padding:5px;" sk_icon_con="border-radius:5px;background-color:#1e73be;"]
	<div style="line-height: 1.3; text-align: center;"><span style="font-size: 13px; color: #666;"><span style="font-size: 14px; font-weight: 300;">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nam cursus. Morbi ut mi.</span>
	</span></div>
	[/cz_service_box][cz_button title="Learn More" btn_position="cz_btn_center" btn_effect="cz_btn_fill_up" link="url:%23|||" id="cz_22630" cz_button="" sk_button="position:relative;font-size:10px;color:#ffffff;background-color:#1e73be;padding:3px 8px;margin:0 auto;border-style:solid;border-width:3px;border-color:#1e73be;border-radius:5px;" sk_hover="border-bottom-style:solid;border-color:#1e73be;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:3px 3px 3px 3px;color:#1e73be;background-color:#ffffff;"][/vc_column][vc_column width="1/4"][cz_service_box type="vertical" icon="fa fa-check" title="Best Service" id="cz_47201" cz_service_box="" sk_title="font-size:22px;color:#001e69;letter-spacing:2px;" sk_icon="font-size:30px;color:#ffffff;padding:5px;" sk_icon_con="border-radius:5px;background-color:#1e73be;"]
	<div style="line-height: 1.3; text-align: center;"><span style="font-size: 13px; color: #666;"><span style="font-size: 14px; font-weight: 300;">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nam cursus. Morbi ut mi.</span>
	</span></div>
	[/cz_service_box][cz_button title="Learn More" btn_position="cz_btn_center" btn_effect="cz_btn_fill_up" link="url:%23|||" id="cz_82216" cz_button="" sk_button="position:relative;font-size:10px;color:#ffffff;background-color:#1e73be;padding:3px 8px;margin:0 auto;border-style:solid;border-width:3px;border-color:#1e73be;border-radius:5px;" sk_hover="border-bottom-style:solid;border-color:#1e73be;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:3px 3px 3px 3px;color:#1e73be;background-color:#ffffff;"][/vc_column][vc_column width="1/4"][cz_service_box type="vertical" icon="fa fa-check" title="Best Service" id="cz_40018" cz_service_box="" sk_title="font-size:22px;color:#001e69;letter-spacing:2px;" sk_icon="font-size:30px;color:#ffffff;padding:5px;" sk_icon_con="border-radius:5px;background-color:#1e73be;"]
	<div style="line-height: 1.3; text-align: center;"><span style="font-size: 13px; color: #666;"><span style="font-size: 14px; font-weight: 300;">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nam cursus. Morbi ut mi.</span>
	</span></div>
	[/cz_service_box][cz_button title="Learn More" btn_position="cz_btn_center" btn_effect="cz_btn_fill_up" link="url:%23|||" id="cz_78685" cz_button="" sk_button="position:relative;font-size:10px;color:#ffffff;background-color:#1e73be;padding:3px 8px;margin:0 auto;border-style:solid;border-width:3px;border-color:#1e73be;border-radius:5px;" sk_hover="border-bottom-style:solid;border-color:#1e73be;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:3px 3px 3px 3px;color:#1e73be;background-color:#ffffff;"][/vc_column][vc_column width="1/4"][cz_service_box type="vertical" icon="fa fa-check" title="Best Service" id="cz_30252" cz_service_box="" sk_title="font-size:22px;color:#001e69;letter-spacing:2px;" sk_icon="font-size:30px;color:#ffffff;padding:5px;" sk_icon_con="border-radius:5px;background-color:#1e73be;"]
	<div style="line-height: 1.3; text-align: center;"><span style="font-size: 13px; color: #666;"><span style="font-size: 14px; font-weight: 300;">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nam cursus. Morbi ut mi.</span>
	</span></div>
	[/cz_service_box][cz_button title="Learn More" btn_position="cz_btn_center" btn_effect="cz_btn_fill_up" link="url:%23|||" id="cz_16551" cz_button="" sk_button="position:relative;font-size:10px;color:#ffffff;background-color:#1e73be;padding:3px 8px;margin:0 auto;border-style:solid;border-width:3px;border-color:#1e73be;border-radius:5px;" sk_hover="border-bottom-style:solid;border-color:#1e73be;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:3px 3px 3px 3px;color:#1e73be;background-color:#ffffff;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'pricing table price plan 4 columns blue simple 11_jpg',
						'c' =>'[vc_row][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" sk_overall="background-color:#ffffff;margin-bottom:30px;border-style:solid;border-width:1px;border-color:#dddddd;" id="cz_70537"][cz_title sk_overall="padding-top:0px;margin-bottom:10px;margin-top:-10px;" id="cz_42900"]
	<h4 style="text-align: center;"><span style="color: #999999; font-weight: 300;">Basic</span></h4>
	[/cz_title][cz_title title_pos="cz_title_pos_center" sk_overall="background-color:#aaaaaa;width:100%;padding:15px 30px;margin-top:15px;margin-right:-30px;margin-left:-30px;" id="cz_40613"]
	<h3 style="text-align: center;"><span style="color: #ffffff;">FREE</span></h3>
	[/cz_title][cz_gap height="30px" id="cz_59996"][vc_column_text]
	<div class="wpb_text_column wpb_content_element ">
	<div class="wpb_wrapper">
	<ul>
	 	<li><span style="font-size: 14px; color: #666666;">50 GB Disk Space</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">10 Databases List</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">Free Domain Registration</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">1 Hosting Space</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">FREE Ad Coupons</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">Account Control Panel</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">FREE 24/7 Support</span></li>
	</ul>
	</div>
	</div>
	[/vc_column_text][cz_gap height="30px" id="cz_63916"][cz_button title="Order Now" btn_position="cz_btn_center" sk_button="background-color:#aaaaaa;" sk_hover="color:#ffffff;" icon="fa fa-cart-plus" btn_effect="cz_btn_absorber" link="url:%23|||" id="cz_21196"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" sk_overall="background-color:#ffffff;margin-bottom:30px;border-style:solid;border-width:1px;border-color:#dddddd;" id="cz_11893"][cz_title sk_overall="margin-bottom:10px;margin-top:-10px;" id="cz_40645"]
	<h4 style="text-align: center;"><span style="color: #999999; font-weight: 300;">Standard</span></h4>
	[/cz_title][cz_title title_pos="cz_title_pos_center" sk_overall="background-color:#aaaaaa;width:100%;padding:15px 30px;margin-top:15px;margin-right:-30px;margin-left:-30px;" id="cz_24295"]
	<h3 style="text-align: center;"><span style="color: #ffffff;">$9.99</span></h3>
	[/cz_title][cz_gap height="30px" id="cz_94192"][vc_column_text]
	<div class="wpb_text_column wpb_content_element ">
	<div class="wpb_wrapper">
	<ul>
	 	<li><span style="font-size: 14px; color: #666666;">500 GB Disk Space</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">100 Databases List</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">Free Domain Registration</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">1 Hosting Space</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">FREE Ad Coupons</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">Account Control Panel</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">FREE 24/7 Support</span></li>
	</ul>
	</div>
	</div>
	[/vc_column_text][cz_gap height="30px" id="cz_19638"][cz_button title="Order Now" btn_position="cz_btn_center" sk_button="background-color:#aaaaaa;" sk_hover="color:#ffffff;" icon="fa fa-cart-plus" btn_effect="cz_btn_absorber" link="url:%23|||" id="cz_90339"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" fx="fx_zoom_1" sk_overall="background-color:#ffffff;border-style:solid;border-width:3px;border-color:#2980b9;" id="cz_42660" sk_overall_tablet="margin-top:30px;margin-bottom:60px;"][cz_title sk_overall="margin-bottom:10px;margin-top:-10px;" id="cz_65269"]
	<h4 style="text-align: center;"><span style="color: #999999; font-weight: 300;">Premium</span></h4>
	[/cz_title][cz_title title_pos="cz_title_pos_center" sk_overall="background-color:#2980b9;width:100%;padding:15px 30px;margin-top:15px;margin-right:-30px;margin-left:-30px;border-style:none;" id="cz_14987"]
	<h3 style="text-align: center;"><span style="color: #ffffff;">$19.99</span></h3>
	[/cz_title][cz_gap height="30px" id="cz_90384"][vc_column_text]
	<div class="wpb_text_column wpb_content_element ">
	<div class="wpb_wrapper">
	<ul>
	 	<li>1000 GB Disk Space</li>
	 	<li>200 Databases List</li>
	 	<li>Free Domain Registration</li>
	 	<li>2 Hosting Space</li>
	 	<li>FREE Ad Coupons</li>
	 	<li>Account Control Panel</li>
	 	<li>FREE 24/7 Support</li>
	</ul>
	</div>
	</div>
	[/vc_column_text][cz_gap height="30px" id="cz_50644"][cz_button title="Order Now" btn_position="cz_btn_center" sk_button="background-color:#2980b9;" sk_hover="color:#ffffff;" icon="fa fa-cart-plus" btn_effect="cz_btn_absorber" link="url:%23|||" id="cz_27010"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" sk_overall="border-bottom-style:solid;border-color:#dddddd;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:1px 1px 1px 1px;background-color:#ffffff;" id="cz_16276"][cz_title sk_overall="margin-bottom:10px;margin-top:-10px;" id="cz_89526"]
	<h4 style="text-align: center;"><span style="color: #999999; font-weight: 300;">Ultimate</span></h4>
	[/cz_title][cz_title title_pos="cz_title_pos_center" sk_overall="background-color:#aaaaaa;width:100%;padding:15px 30px;margin-top:15px;margin-right:-30px;margin-left:-30px;" id="cz_53911"]
	<h3 style="text-align: center;"><span style="color: #ffffff;">$29.99</span></h3>
	[/cz_title][cz_gap height="30px" id="cz_63229"][vc_column_text]
	<div class="wpb_text_column wpb_content_element ">
	<div class="wpb_wrapper">
	<ul>
	 	<li><span style="font-size: 14px; color: #666666;">Unlimited Disk Space</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">Unlimited Databases List</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">Free Domain Registration</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">5 Hosting Space</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">FREE Ad Coupons</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">Account Control Panel</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">FREE 24/7 Support</span></li>
	</ul>
	</div>
	</div>
	[/vc_column_text][cz_gap height="30px" id="cz_42947"][cz_button title="Order Now" btn_position="cz_btn_center" sk_button="background-color:#aaaaaa;" sk_hover="color:#ffffff;" icon="fa fa-cart-plus" btn_effect="cz_btn_absorber" link="url:%23|||" id="cz_12908"][/cz_content_box][/vc_column][/vc_row]',
					),
					array(
						'f' => 'pricing table price plan 4 columns orange rounded gradient 12_jpg',
						'c' =>'[vc_row][vc_column offset="vc_col-lg-4"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_80405" sk_overall="background-color:#ffffff;padding-right:0px;padding-bottom:40px;padding-left:0px;margin-bottom:30px;border-style:solid;border-width:1px 1px 3px;border-color:#dddddd;border-radius:5px;"][cz_title title_pos="cz_title_pos_block" id="cz_34966" sk_overall="background-color:#5f5fa7;padding:30px 0px 5px;margin-top:-30px;margin-left:0px;border-radius:5px 5px 0 0;"]
	<div style="line-height: 1.5; text-align: center;"><span style="font-size: 20px; color: #ffffff; font-weight: 200;">B A S I C</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="display: block; font-size: 36px; font-weight: bold; color: #ffffff;">FREE</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="color: #ffffff; font-weight: 300;">Life Time</span></div>
	[/cz_title][cz_separator style="cz_sep_10" css_position="relative" top_color="#5f5fa7" sep_height="40px" css_top="0px" id="cz_49201"][cz_gap height="30px" id="cz_34516"][vc_column_text]
	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px; color: #444444;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> FREE 24/7 Support</span></p>
	[/vc_column_text][cz_gap height="30px" id="cz_95954"][cz_button title="Get Started" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" icon="fa fa-cart-plus" link="url:%23|||" id="cz_18910" sk_button="border-radius:4px;background-color:#5f5fa7;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column offset="vc_col-lg-4"][cz_content_box type="1" fx="fx_up" fx_hover="fx_up_hover" id="cz_87183" sk_overall="background-color:#ffffff;padding-right:0px;padding-bottom:40px;padding-left:0px;border-style:solid;border-width:1px 1px 3px;border-color:#dddddd;border-radius:5px;" sk_overall_tablet="margin-top:30px;"][cz_title title_pos="cz_title_pos_block" id="cz_79904" sk_overall="background-color:#e54b81;padding:30px 0px 5px;margin-top:-30px;margin-left:0px;border-radius:5px 5px 0 0;" ]
	<div style="line-height: 1.5; text-align: center;"><span style="font-size: 20px; color: #ffffff; font-weight: 200;">S T A N D A R D</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="display: block; font-size: 36px; font-weight: bold; color: #ffffff;">$9.99</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="color: #ffffff; font-weight: 300;">Per Month</span></div>
	[/cz_title][cz_separator style="cz_sep_10" css_position="relative" top_color="#e54b81" sep_height="40px" css_top="0px" id="cz_93131"][cz_gap height="30px" id="cz_44271"][vc_column_text]
	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px; color: #444444;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> FREE 24/7 Support</span></p>
	[/vc_column_text][cz_gap height="30px" id="cz_77368"][cz_button title="Get Started" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" btn_effect="cz_btn_zoom_in" icon="fa fa-cart-plus" link="url:%23|||" id="cz_52838" sk_button="border-radius:4px;background-color:#e54b81;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column offset="vc_col-lg-4"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_56598" sk_overall="border-radius:5px;border-bottom-style:solid;border-color:#dddddd;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-left:0px;padding-bottom:40px;padding-right:0px;border-width:1px 1px 3px 1px;background-color:#ffffff;"][cz_title title_pos="cz_title_pos_block" id="cz_67056" sk_overall="background-color:#5f5fa7;padding:30px 0px 5px;margin-top:-30px;margin-left:0px;border-radius:5px 5px 0 0;"]
	<div style="line-height: 1.5; text-align: center;"><span style="font-size: 20px; color: #ffffff; font-weight: 200;">P R E M I U M</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="display: block; font-size: 36px; font-weight: bold; color: #ffffff;">$49.99</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="color: #ffffff; font-weight: 300;">Per Year</span></div>
	[/cz_title][cz_separator style="cz_sep_10" css_position="relative" top_color="#5f5fa7" sep_height="40px" css_top="0px" id="cz_85716"][cz_gap height="30px" id="cz_88096"][vc_column_text]
	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px; color: #444444;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> FREE 24/7 Support</span></p>
	[/vc_column_text][cz_gap height="30px" id="cz_19191"][cz_button title="Get Started" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" icon="fa fa-cart-plus" link="url:%23|||" id="cz_41509" sk_button="border-radius:4px;background-color:#5f5fa7;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][/vc_row]',
					),
					array(
						'f' => 'pricing table price plan 3 columns blue green rounded flat 13_jpg',
						'c' =>'[vc_row][vc_column offset="vc_col-lg-4"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_76141" sk_overall="background-color:#ffffff;padding-right:0px;padding-bottom:40px;padding-left:0px;margin-bottom:30px;border-style:solid;border-width:2px 2px 5px;border-color:#05285b;border-radius:7px;"][cz_title title_pos="cz_title_pos_block" id="cz_13603" sk_overall="background-color:#05285b;padding:30px 0px;margin-top:-30px;margin-left:0px;border-radius:5px 5px 0 0;"]
	<div style="line-height: 1.5; text-align: center;"><span style="font-size: 20px; color: #ffffff; font-weight: 200;">B A S I C</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="display: block; font-size: 36px; font-weight: bold; color: #f5b904;">FREE</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="color: #ffffff; font-weight: 300;">Life Time</span></div>
	[/cz_title][cz_separator style="cz_sep_18" css_position="relative" top_color="#05285b" id="cz_55104"][cz_gap height="30px" id="cz_13137"][vc_column_text]
	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px; color: #05285b;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> FREE 24/7 Support</span></p>
	[/vc_column_text][cz_gap height="30px" id="cz_13794"][cz_button title="Get Started" btn_position="cz_btn_center" btn_effect="cz_btn_fill_up" icon="fa fa-cart-plus" link="url:%23|||" id="cz_79189" sk_button="border-radius:4px;border-color:#05285b;border-width:2px 2px 2px 2px;color:#05285b;background-color:#ffffff;" sk_hover="border-radius:2px;border-bottom-style:solid;border-color:#05285b;border-top-style:solid;border-right-style:solid;border-left-style:solid;background-color:#05285b;border-width:2px 2px 2px 2px;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column offset="vc_col-lg-4"][cz_content_box type="1" fx="fx_up" fx_hover="fx_up_hover" id="cz_47875" sk_overall="background-color:#ffffff;padding-right:0px;padding-bottom:40px;padding-left:0px;border-style:solid;border-width:2px 2px 5px;border-color:#05285b;border-radius:7px;" sk_overall_tablet="margin-top:30px;"][cz_title title_pos="cz_title_pos_block" shape="square" id="cz_24931" sk_overall="background-color:#05285b;padding:50px 0px 30px;margin-top:-30px;margin-left:0px;border-radius:5px 5px 0 0;" sk_shape="font-size:50px;background-color:#ffffff;top:-225px;left:calc(50% - 53px);transform:rotate(45deg);" sk_shape_tablet="display:none;"]
	<div style="line-height: 1.5; text-align: center;"><span style="font-size: 20px; color: #ffffff; font-weight: 200;">P R O</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="display: block; font-size: 36px; font-weight: bold; color: #f5b904;">$9.99</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="color: #ffffff; font-weight: 300;">Per Month</span></div>
	[/cz_title][cz_separator style="cz_sep_18" css_position="relative" top_color="#05285b" id="cz_63273"][cz_gap height="30px" id="cz_88132"][vc_column_text]
	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px; color: #05285b;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> FREE Ad Coupons
	Email Server
	Website Builder</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> FREE 24/7 Support</span></p>
	[/vc_column_text][cz_gap height="30px" id="cz_58300"][cz_button title="Get Started" btn_position="cz_btn_center" btn_effect="cz_btn_fill_up" icon="fa fa-cart-plus" link="url:%23|||" id="cz_39011" sk_button="border-radius:4px;border-color:#05285b;border-width:2px 2px 2px 2px;color:#05285b;background-color:#ffffff;" sk_hover="border-radius:2px;border-bottom-style:solid;border-color:#05285b;border-top-style:solid;border-right-style:solid;border-left-style:solid;background-color:#05285b;border-width:2px 2px 2px 2px;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column offset="vc_col-lg-4"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_45837" sk_overall="border-radius:7px;border-bottom-style:solid;border-color:#05285b;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-left:0px;padding-bottom:40px;padding-right:0px;border-width:2px 2px 5px 2px;background-color:#ffffff;"][cz_title title_pos="cz_title_pos_block" id="cz_54934" sk_overall="background-color:#05285b;padding:30px 0px;margin-top:-30px;margin-left:0px;border-radius:5px 5px 0 0;"]
	<div style="line-height: 1.5; text-align: center;"><span style="font-size: 20px; color: #ffffff; font-weight: 200;">P R E M I U M</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="display: block; font-size: 36px; font-weight: bold; color: #f5b904;">$49.99</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="color: #ffffff; font-weight: 300;">Per Year</span></div>
	[/cz_title][cz_separator style="cz_sep_18" css_position="relative" top_color="#05285b" id="cz_60077"][cz_gap height="30px" id="cz_62356"][vc_column_text]
	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px; color: #05285b;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> FREE 24/7 Support</span></p>
	[/vc_column_text][cz_gap height="30px" id="cz_51452"][cz_button title="Get Started" btn_position="cz_btn_center" btn_effect="cz_btn_fill_up" icon="fa fa-cart-plus" link="url:%23|||" id="cz_36050" sk_button="border-radius:4px;border-color:#05285b;border-width:2px 2px 2px 2px;color:#05285b;background-color:#ffffff;" sk_hover="border-radius:2px;border-bottom-style:solid;border-color:#05285b;border-top-style:solid;border-right-style:solid;border-left-style:solid;background-color:#05285b;border-width:2px 2px 2px 2px;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][/vc_row]',
					),
					array(
						'f' => 'pricing table price plan 4 columns blue green orange red flat colorful 14_jpg',
						'c' =>'[vc_row el_class="no_padding"][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" sk_overall="background-color:#ffffff;margin-bottom:30px;box-shadow:0px 0px 15px rgba(0,0,0,0.22);" sk_hover="box-shadow:0px 0px 28px rgba(0,0,0,0.22) ;" id="cz_41808"][cz_title title_pos="cz_title_pos_center" sk_overall="background-color:#3399ff;width:100%;padding:5px 30px;margin:-30px -30px 0px;" id="cz_34759"]
	<p style="text-align: center;"><span style="font-size: 14px; font-weight: 400; color: #ffffff;">B A S I C P L A N</span></p>
	[/cz_title][cz_title title_pos="cz_title_pos_center" sk_overall="background-color:#0078f0;width:100%;padding:20px 30px;margin-top:0px;margin-right:-30px;margin-left:-30px;" id="cz_88598"]
	<h3 style="text-align: center;"><span style="color: #ffffff;">FREE</span></h3>
	[/cz_title][cz_gap height="30px" id="cz_47748"][vc_column_text]
	<div class="wpb_text_column wpb_content_element ">
	<div class="wpb_wrapper">
	<ul>
	 	<li><span style="font-size: 14px; color: #666666;">50 GB Disk Space</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">10 Databases List</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">Free Domain Registration</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">1 Hosting Space</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">FREE Ad Coupons</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">Account Control Panel</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">FREE 24/7 Support</span></li>
	</ul>
	</div>
	</div>
	[/vc_column_text][cz_gap height="30px" id="cz_35874"][cz_button title="Get Started" btn_position="cz_btn_block" sk_button="padding-bottom:7px;padding-top:7px;background-color:#0078f0;" sk_hover="color:#ffffff;" icon="fa fa-long-arrow-right" icon_position="after" sk_icon_hover="color:#ffffff;" text_effect="cz_btn_txt_move_right" link="url:%23|||" id="cz_38976"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" sk_overall="background-color:#ffffff;margin-bottom:30px;box-shadow:0px 0px 15px rgba(0,0,0,0.22);" sk_hover="box-shadow:0px 0px 28px rgba(0,0,0,0.26) ;" id="cz_36340"][cz_title title_pos="cz_title_pos_center" sk_overall="background-color:#93c230;width:100%;padding:5px 30px;margin:-30px -30px 0px;" id="cz_97990"]
	<p style="text-align: center;"><span style="font-size: 14px; font-weight: 400; color: #ffffff;">S T A N D A R D P L A N</span></p>
	[/cz_title][cz_title title_pos="cz_title_pos_center" sk_overall="background-color:#7ba428;width:100%;padding:20px 30px;margin-top:0px;margin-right:-30px;margin-left:-30px;" id="cz_14295"]
	<h3 style="text-align: center;"><span style="color: #ffffff;">$9.99</span></h3>
	[/cz_title][cz_gap height="30px" id="cz_73115"][vc_column_text]
	<div class="wpb_text_column wpb_content_element ">
	<div class="wpb_wrapper">
	<ul>
	 	<li><span style="font-size: 14px; color: #666666;">500 GB Disk Space</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">100 Databases List</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">Free Domain Registration</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">1 Hosting Space</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">FREE Ad Coupons</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">Account Control Panel</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">FREE 24/7 Support</span></li>
	</ul>
	</div>
	</div>
	[/vc_column_text][cz_gap height="30px" id="cz_60235"][cz_button title="Get Started" btn_position="cz_btn_block" sk_button="padding-bottom:7px;padding-top:7px;background-color:#7ba428;" sk_hover="color:#ffffff;" icon="fa fa-long-arrow-right" icon_position="after" sk_icon_hover="color:#ffffff;" text_effect="cz_btn_txt_move_right" link="url:%23|||" id="cz_63002"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" class="z2" sk_overall="background-color:#ffffff;margin-top:-42px;margin-bottom:30px;box-shadow:0px 0px 15px rgba(0,0,0,0.22);" sk_hover="box-shadow:0px 0px 28px rgba(0,0,0,0.25) ;" id="cz_95099" sk_overall_tablet="margin-top:0px;"][cz_title title_pos="cz_title_pos_center" sk_overall="background-color:#ffae35;width:100%;padding:5px 30px;margin:-30px -30px 0px;" id="cz_19771"]
	<p style="text-align: center;"><span style="font-size: 14px; font-weight: 400; color: #ffffff;">P R E M I U M P L A N</span></p>
	[/cz_title][cz_title title_pos="cz_title_pos_center" sk_overall="background-color:#ff8000;width:100%;padding:27px 30px 28px;margin-top:0px;margin-right:-30px;margin-left:-30px;" id="cz_23927"]
	<h3 style="text-align: center; line-height: 1.5;"><span style="color: #ffffff;">$19.99</span></h3>
	<div style="text-align: center; line-height: 1.5;"><span style="color: #ffffff; font-size: 13px;">per month</span></div>
	[/cz_title][cz_gap height="30px" id="cz_51498"][vc_column_text]
	<div class="wpb_text_column wpb_content_element ">
	<div class="wpb_wrapper">
	<ul>
	 	<li>1000 GB Disk Space</li>
	 	<li>200 Databases List</li>
	 	<li>Free Domain Registration</li>
	 	<li>2 Hosting Space</li>
	 	<li>FREE Ad Coupons</li>
	 	<li>Website Builder</li>
	 	<li>Email Forwarding</li>
	 	<li>Account Control Panel</li>
	 	<li>FREE 24/7 Support</li>
	</ul>
	</div>
	</div>
	[/vc_column_text][cz_gap height="30px" id="cz_61217"][cz_button title="Get Started" btn_position="cz_btn_block" sk_button="padding-bottom:7px;padding-top:7px;background-color:#ff8000;" sk_hover="color:#ffffff;" icon="fa fa-long-arrow-right" icon_position="after" sk_icon_hover="color:#ffffff;" text_effect="cz_btn_txt_move_right" link="url:%23|||" id="cz_29963"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" sk_overall="background-color:#ffffff;margin-bottom:30px;box-shadow:0px 0px 15px rgba(0,0,0,0.22);" sk_hover="box-shadow:0px 0px 28px rgba(0,0,0,0.25) ;" id="cz_91644"][cz_title title_pos="cz_title_pos_center" sk_overall="background-color:#f03d00;width:100%;padding:5px 30px;margin:-30px -30px 0px;" id="cz_26169"]
	<p style="text-align: center;"><span style="font-size: 14px; font-weight: 400; color: #ffffff;">U L T I M A T E P L A N</span></p>
	[/cz_title][cz_title title_pos="cz_title_pos_center" sk_overall="background-color:#cc3300;width:100%;padding:20px 30px;margin-top:0px;margin-right:-30px;margin-left:-30px;" id="cz_29480"]
	<h3 style="text-align: center;"><span style="color: #ffffff;">$29.99</span></h3>
	[/cz_title][cz_gap height="30px" id="cz_25408"][vc_column_text]
	<div class="wpb_text_column wpb_content_element ">
	<div class="wpb_wrapper">
	<ul>
	 	<li><span style="font-size: 14px; color: #666666;">Unlimited Disk Space</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">Unlimited Databases List</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">Free Domain Registration</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">5 Hosting Space</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">FREE Ad Coupons</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">Account Control Panel</span></li>
	 	<li><span style="font-size: 14px; color: #666666;">FREE 24/7 Support</span></li>
	</ul>
	</div>
	</div>
	[/vc_column_text][cz_gap height="30px" id="cz_75495"][cz_button title="Get Started" btn_position="cz_btn_block" sk_button="padding-bottom:7px;padding-top:7px;background-color:#cc3300;" sk_hover="color:#ffffff;" icon="fa fa-long-arrow-right" icon_position="after" sk_icon_hover="color:#ffffff;" text_effect="cz_btn_txt_move_right" link="url:%23|||" id="cz_36577"][/cz_content_box][/vc_column][/vc_row]',
					),
					array(
						'f' => 'pricing table price plan 3 columns green shadow flat 15_jpg',
						'c' =>'[vc_row][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" fx_hover="fx_shine_hover" id="cz_86398" sk_overall="border-radius:200px;border-bottom-style:solid;border-color:#eeeeee;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-bottom:60px;padding-top:90px;border-width:2px 2px 2px 2px;background-color:#ffffff;"][cz_title shape="circle" id="cz_32781" sk_shape="font-size:180px;background-color:#1fb4da;top:40px;"]
	<div style="text-align: center; line-height: 1.3;"><span style="font-size: 14px; font-weight: 300; color: #ffffff;">BASIC PLAN</span></div>
	<div style="text-align: center; line-height: 1.3;"><span style="color: #ffffff; display: block; font-size: 34px; font-weight: bold;">FREE</span></div>
	<div style="text-align: center; line-height: 1.3;"><span style="font-size: 13px; color: #ffffff;">Life Time</span></div>
	[/cz_title][cz_gap height="30px" id="cz_38494"][cz_gap id="cz_59742"][vc_column_text]
	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE 24/7 Support</span></p>
	[/vc_column_text][cz_gap height="30px" id="cz_21581"][cz_button title="Order Now" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_right" icon="fa fa-cart-plus" link="url:%23|||" id="cz_57140" sk_button="border-radius:50px;background-color:#1fb4da;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" fx="fx_zoom_1" fx_hover="fx_shine_hover" id="cz_71522" sk_overall="border-radius:200px;border-bottom-style:solid;border-color:#eeeeee;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-bottom:60px;padding-top:90px;border-width:2px 2px 2px 2px;background-color:#ffffff;"][cz_title shape="circle" id="cz_72031" sk_shape="font-size:180px;background-color:#1f69da;top:40px;"]
	<div style="text-align: center; line-height: 1.3;"><span style="font-size: 14px; font-weight: 300; color: #ffffff;">PRO PLAN</span></div>
	<div style="text-align: center; line-height: 1.3;"><span style="color: #ffffff; display: block; font-size: 34px; font-weight: bold;">$9.99</span></div>
	<div style="text-align: center; line-height: 1.3;"><span style="font-size: 13px; color: #ffffff;">Per Month</span></div>
	[/cz_title][cz_gap height="30px" id="cz_73190"][cz_gap id="cz_64041"][vc_column_text]
	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px;">500 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px;"> 100 Databases List</span>
	<span style="font-weight: 400; font-size: 14px;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px;"> 2 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE 24/7 Support</span></p>
	[/vc_column_text][cz_gap height="30px" id="cz_47459"][cz_button title="Order Now" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_right" btn_effect="cz_btn_zoom_in" icon="fa fa-cart-plus" link="url:%23|||" id="cz_77199" sk_button="border-radius:50px;background-color:#1f69da;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" fx_hover="fx_shine_hover" id="cz_51446" sk_overall="border-radius:200px;border-bottom-style:solid;border-color:#eeeeee;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-bottom:60px;padding-top:90px;border-width:2px 2px 2px 2px;background-color:#ffffff;"][cz_title shape="circle" id="cz_26428" sk_shape="font-size:180px;background-color:#1fb4da;top:40px;"]
	<div style="text-align: center; line-height: 1.3;"><span style="font-size: 14px; font-weight: 300; color: #ffffff;">PREMIUM PLAN</span></div>
	<div style="text-align: center; line-height: 1.3;"><span style="color: #ffffff; display: block; font-size: 34px; font-weight: bold;">$19.99</span></div>
	<div style="text-align: center; line-height: 1.3;"><span style="font-size: 13px; color: #ffffff;">Per Year</span></div>
	[/cz_title][cz_gap height="30px" id="cz_73138"][cz_gap id="cz_90771"][vc_column_text]
	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE 24/7 Support</span></p>
	[/vc_column_text][cz_gap height="30px" id="cz_11723"][cz_button title="Order Now" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_right" icon="fa fa-cart-plus" link="url:%23|||" id="cz_46100" sk_button="border-radius:50px;background-color:#1fb4da;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" fx_hover="fx_shine_hover" id="cz_21846" sk_overall="border-radius:200px;border-bottom-style:solid;border-color:#eeeeee;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-bottom:60px;padding-top:90px;border-width:2px 2px 2px 2px;background-color:#ffffff;"][cz_title shape="circle" id="cz_27179" sk_shape="font-size:180px;background-color:#1fb4da;top:40px;"]
	<div style="text-align: center; line-height: 1.3;"><span style="font-size: 14px; font-weight: 300; color: #ffffff;">ULTIMATE PLAN</span></div>
	<div style="text-align: center; line-height: 1.3;"><span style="color: #ffffff; display: block; font-size: 34px; font-weight: bold;">$39.99</span></div>
	<div style="text-align: center; line-height: 1.3;"><span style="font-size: 13px; color: #ffffff;">Per Year</span></div>
	[/cz_title][cz_gap height="30px" id="cz_87704"][cz_gap id="cz_45417"][vc_column_text]
	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE 24/7 Support</span></p>
	[/vc_column_text][cz_gap height="30px" id="cz_20070"][cz_button title="Order Now" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_right" icon="fa fa-cart-plus" link="url:%23|||" id="cz_16643" sk_button="border-radius:50px;background-color:#1fb4da;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][/vc_row]
	',
					),
					array(
						'f' => 'pricing table price plan 4 columns blue simple circle flat 16_jpg',
						'c' =>'[vc_row][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" id="cz_53008" sk_overall="background-color:#ffffff;margin-bottom:30px;border-style:solid;border-width:2px;border-color:#dddddd;border-radius:10px;"][cz_title id="cz_28733" sk_overall="padding-top:0px;margin-top:-10px;margin-bottom:25px;"]
	<h3 style="text-align: center;"><span style="color: #808080;">BASIC</span></h3>
	[/cz_title][cz_title shape="circle" id="cz_74157" sk_overall="margin-bottom:40px;margin-top:50px;" sk_shape="font-size:130px;background-color:#1fb4da;top:68px;"]
	<h3 style="text-align: center;"><span style="color: #ffffff;">FREE</span></h3>
	[/cz_title][cz_gap id="cz_38855"][vc_column_text]

	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_35846"][cz_button title="Order Now" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_right" icon="fa fa-cart-plus" link="url:%23|||" id="cz_43449" sk_button="border-radius:50px;background-color:#1fb4da;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" id="cz_31716" sk_overall="background-color:#ffffff;margin-bottom:30px;border-style:solid;border-width:2px;border-color:#dddddd;border-radius:10px;"][cz_title id="cz_52123" sk_overall="padding-top:0px;margin-top:-10px;margin-bottom:25px;"]
	<h3 style="text-align: center;"><span style="color: #808080;">STANDARD</span></h3>
	[/cz_title][cz_title shape="circle" id="cz_41375" sk_overall="margin-bottom:40px;margin-top:50px;" sk_shape="font-size:130px;background-color:#1fb4da;top:68px;"]
	<h3 style="text-align: center;"><span style="color: #ffffff;">$9.99</span></h3>
	[/cz_title][cz_gap id="cz_31756"][vc_column_text]

	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_21508"][cz_button title="Order Now" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_right" icon="fa fa-cart-plus" link="url:%23|||" id="cz_19298" sk_button="border-radius:50px;background-color:#1fb4da;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" fx="fx_zoom_1" id="cz_92188" sk_overall="background-color:#ffffff;padding-top:20px;margin-bottom:30px;border-style:solid;border-width:2px;border-color:#dddddd;border-radius:10px;" sk_overall_tablet="margin-top:50px;"][cz_title title_pos="cz_title_pos_center" id="cz_74857" sk_overall="border-radius:35px;background-color:#1f69da;padding-bottom:5px;padding-top:5px;margin-bottom:30px;margin-top:-44px;"]
	<div style="text-align: center; line-height: 2;"><span style="color: #ffffff; font-size: 14px;">BEST SELLER</span></div>
	[/cz_title][cz_title id="cz_14889" sk_overall="padding-top:0px;margin-bottom:20px;margin-top:0px;"]
	<h3 style="text-align: center;"><span style="color: #808080;">PREMIUM</span></h3>
	[/cz_title][cz_title shape="circle" id="cz_84796" sk_overall="margin-top:50px;margin-bottom:40px;" sk_shape="font-size:140px;background-color:#1f69da;top:68px;"]
	<h3 style="text-align: center;"><span style="color: #ffffff;">$19.99</span></h3>
	[/cz_title][cz_gap id="cz_34038"][vc_column_text]

	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_72709"][cz_button title="Order Now" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_right" icon="fa fa-cart-plus" link="url:%23|||" id="cz_90396" sk_button="border-radius:50px;background-color:#1f69da;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" id="cz_54139" sk_overall="background-color:#ffffff;margin-bottom:30px;border-style:solid;border-width:2px;border-color:#dddddd;border-radius:10px;"][cz_title id="cz_84648" sk_overall="padding-top:0px;margin-top:-10px;margin-bottom:25px;"]
	<h3 style="text-align: center;"><span style="color: #808080;">ULTIMATE</span></h3>
	[/cz_title][cz_title shape="circle" id="cz_95462" sk_overall="margin-bottom:40px;margin-top:50px;" sk_shape="font-size:130px;background-color:#1fb4da;top:68px;"]
	<h3 style="text-align: center;"><span style="color: #ffffff;">$29.99</span></h3>
	[/cz_title][cz_gap id="cz_56017"][vc_column_text]

	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_69114"][cz_button title="Order Now" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_right" icon="fa fa-cart-plus" link="url:%23|||" id="cz_36218" sk_button="border-radius:50px;background-color:#1fb4da;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][/vc_row]',
					),
					array(
						'f' => 'pricing table price plan 3 columns blue pink curved flat 17_jpg',
						'c' =>'[vc_row][vc_column offset="vc_col-lg-4"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_80405" sk_overall="background-color:#ffffff;padding-right:0px;padding-bottom:40px;padding-left:0px;margin-bottom:30px;border-style:solid;border-width:1px 1px 3px;border-color:#dddddd;border-radius:5px;"][cz_title title_pos="cz_title_pos_block" id="cz_34966" sk_overall="background-color:#5f5fa7;padding:30px 0px 5px;margin-top:-30px;margin-left:0px;border-radius:5px 5px 0 0;"]
	<div style="line-height: 1.5; text-align: center;"><span style="font-size: 20px; color: #ffffff; font-weight: 200;">B A S I C</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="display: block; font-size: 36px; font-weight: bold; color: #ffffff;">FREE</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="color: #ffffff; font-weight: 300;">Life Time</span></div>
	[/cz_title][cz_separator style="cz_sep_10" css_position="relative" top_color="#5f5fa7" sep_height="40px" css_top="0px" id="cz_49201"][cz_gap height="30px" id="cz_34516"][vc_column_text]

	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px; color: #444444;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_95954"][cz_button title="Get Started" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" icon="fa fa-cart-plus" link="url:%23|||" id="cz_18910" sk_button="border-radius:4px;background-color:#5f5fa7;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column offset="vc_col-lg-4"][cz_content_box type="1" fx="fx_up" fx_hover="fx_up_hover" id="cz_87183" sk_overall="background-color:#ffffff;padding-right:0px;padding-bottom:40px;padding-left:0px;border-style:solid;border-width:1px 1px 3px;border-color:#dddddd;border-radius:5px;" sk_overall_tablet="margin-top:30px;"][cz_title title_pos="cz_title_pos_block" id="cz_79904" sk_overall="background-color:#e54b81;padding:30px 0px 5px;margin-top:-30px;margin-left:0px;border-radius:5px 5px 0 0;"]
	<div style="line-height: 1.5; text-align: center;"><span style="font-size: 20px; color: #ffffff; font-weight: 200;">S T A N D A R D</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="display: block; font-size: 36px; font-weight: bold; color: #ffffff;">$9.99</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="color: #ffffff; font-weight: 300;">Per Month</span></div>
	[/cz_title][cz_separator style="cz_sep_10" css_position="relative" top_color="#e54b81" sep_height="40px" css_top="0px" id="cz_93131"][cz_gap height="30px" id="cz_44271"][vc_column_text]

	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px; color: #444444;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_77368"][cz_button title="Get Started" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" btn_effect="cz_btn_zoom_in" icon="fa fa-cart-plus" link="url:%23|||" id="cz_52838" sk_button="border-radius:4px;background-color:#e54b81;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column offset="vc_col-lg-4"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_56598" sk_overall="border-radius:5px;border-bottom-style:solid;border-color:#dddddd;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-left:0px;padding-bottom:40px;padding-right:0px;border-width:1px 1px 3px 1px;background-color:#ffffff;"][cz_title title_pos="cz_title_pos_block" id="cz_67056" sk_overall="background-color:#5f5fa7;padding:30px 0px 5px;margin-top:-30px;margin-left:0px;border-radius:5px 5px 0 0;"]
	<div style="line-height: 1.5; text-align: center;"><span style="font-size: 20px; color: #ffffff; font-weight: 200;">P R E M I U M</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="display: block; font-size: 36px; font-weight: bold; color: #ffffff;">$49.99</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="color: #ffffff; font-weight: 300;">Per Year</span></div>
	[/cz_title][cz_separator style="cz_sep_10" css_position="relative" top_color="#5f5fa7" sep_height="40px" css_top="0px" id="cz_85716"][cz_gap height="30px" id="cz_88096"][vc_column_text]

	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px; color: #444444;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_19191"][cz_button title="Get Started" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" icon="fa fa-cart-plus" link="url:%23|||" id="cz_41509" sk_button="border-radius:4px;background-color:#5f5fa7;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][/vc_row]
	',
					),
					array(
						'f' => 'pricing table price plan 3 columns blue orange triangle spiky flat 18_jpg',
						'c' =>'[vc_row][vc_column offset="vc_col-lg-4"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_76141" sk_overall="background-color:#ffffff;padding-right:0px;padding-bottom:40px;padding-left:0px;margin-bottom:30px;border-style:solid;border-width:2px 2px 5px;border-color:#05285b;border-radius:7px;"][cz_title title_pos="cz_title_pos_block" id="cz_13603" sk_overall="background-color:#05285b;padding:30px 0px;margin-top:-30px;margin-left:0px;border-radius:5px 5px 0 0;"]
	<div style="line-height: 1.5; text-align: center;"><span style="font-size: 20px; color: #ffffff; font-weight: 200;">B A S I C</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="display: block; font-size: 36px; font-weight: bold; color: #f5b904;">FREE</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="color: #ffffff; font-weight: 300;">Life Time</span></div>
	[/cz_title][cz_separator style="cz_sep_18" css_position="relative" top_color="#05285b" id="cz_55104"][cz_gap height="30px" id="cz_13137"][vc_column_text]

	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px; color: #05285b;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_13794"][cz_button title="Get Started" btn_position="cz_btn_center" btn_effect="cz_btn_fill_up" icon="fa fa-cart-plus" link="url:%23|||" id="cz_79189" sk_button="border-radius:4px;border-color:#05285b;border-width:2px 2px 2px 2px;color:#05285b;background-color:#ffffff;" sk_hover="border-radius:2px;border-bottom-style:solid;border-color:#05285b;border-top-style:solid;border-right-style:solid;border-left-style:solid;background-color:#05285b;border-width:2px 2px 2px 2px;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column offset="vc_col-lg-4"][cz_content_box type="1" fx="fx_up" fx_hover="fx_up_hover" id="cz_47875" sk_overall="background-color:#ffffff;padding-right:0px;padding-bottom:40px;padding-left:0px;border-style:solid;border-width:2px 2px 5px;border-color:#05285b;border-radius:7px;" sk_overall_tablet="margin-top:30px;"][cz_title title_pos="cz_title_pos_block" shape="square" id="cz_24931" sk_overall="background-color:#05285b;padding:50px 0px 30px;margin-top:-30px;margin-left:0px;border-radius:5px 5px 0 0;" sk_shape="font-size:50px;background-color:#ffffff;top:-225px;left:calc(50% - 53px);transform:rotate(45deg);" sk_shape_tablet="display:none;"]
	<div style="line-height: 1.5; text-align: center;"><span style="font-size: 20px; color: #ffffff; font-weight: 200;">P R O</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="display: block; font-size: 36px; font-weight: bold; color: #f5b904;">$9.99</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="color: #ffffff; font-weight: 300;">Per Month</span></div>
	[/cz_title][cz_separator style="cz_sep_18" css_position="relative" top_color="#05285b" id="cz_63273"][cz_gap height="30px" id="cz_88132"][vc_column_text]

	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px; color: #05285b;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> FREE Ad Coupons
	Email Server
	Website Builder</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_58300"][cz_button title="Get Started" btn_position="cz_btn_center" btn_effect="cz_btn_fill_up" icon="fa fa-cart-plus" link="url:%23|||" id="cz_39011" sk_button="border-radius:4px;border-color:#05285b;border-width:2px 2px 2px 2px;color:#05285b;background-color:#ffffff;" sk_hover="border-radius:2px;border-bottom-style:solid;border-color:#05285b;border-top-style:solid;border-right-style:solid;border-left-style:solid;background-color:#05285b;border-width:2px 2px 2px 2px;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column offset="vc_col-lg-4"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_45837" sk_overall="border-radius:7px;border-bottom-style:solid;border-color:#05285b;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-left:0px;padding-bottom:40px;padding-right:0px;border-width:2px 2px 5px 2px;background-color:#ffffff;"][cz_title title_pos="cz_title_pos_block" id="cz_54934" sk_overall="background-color:#05285b;padding:30px 0px;margin-top:-30px;margin-left:0px;border-radius:5px 5px 0 0;"]
	<div style="line-height: 1.5; text-align: center;"><span style="font-size: 20px; color: #ffffff; font-weight: 200;">P R E M I U M</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="display: block; font-size: 36px; font-weight: bold; color: #f5b904;">$49.99</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="color: #ffffff; font-weight: 300;">Per Year</span></div>
	[/cz_title][cz_separator style="cz_sep_18" css_position="relative" top_color="#05285b" id="cz_60077"][cz_gap height="30px" id="cz_62356"][vc_column_text]

	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px; color: #05285b;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px; color: #05285b;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_51452"][cz_button title="Get Started" btn_position="cz_btn_center" btn_effect="cz_btn_fill_up" icon="fa fa-cart-plus" link="url:%23|||" id="cz_36050" sk_button="border-radius:4px;border-color:#05285b;border-width:2px 2px 2px 2px;color:#05285b;background-color:#ffffff;" sk_hover="border-radius:2px;border-bottom-style:solid;border-color:#05285b;border-top-style:solid;border-right-style:solid;border-left-style:solid;background-color:#05285b;border-width:2px 2px 2px 2px;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][/vc_row]',
					),
					array(
						'f' => 'pricing table price plan 3 columns pink purple curved gradient 19_jpg',
						'c' =>'[vc_row][vc_column offset="vc_col-lg-4"][cz_content_box type="1" id="cz_71323" sk_overall="background-color:transparent;background-image:linear-gradient(315deg,#5f5fa7,#e54b81);padding-bottom:40px;margin-bottom:30px;border-width:1px 1px 3px;border-radius:100px 0 100px 0;" sk_hover="border-radius:0 100px 0 100px;"][cz_title title_pos="cz_title_pos_block" shape="circle" id="cz_52623" sk_overall="padding-bottom:0px;padding-top:30px;margin-left:25px;margin-top:20px;" sk_shape="background-color:rgba(0,0,0,0.28);"]
	<div style="line-height: 1.1; text-align: left;"><span style="display: block; font-size: 36px; font-weight: bold; color: #ffffff;">FREE</span></div>
	<div style="line-height: 1.1; text-align: left;"><span style="color: #ffffff; font-weight: 300; margin-left: 12px;">Life Time</span></div>
	[/cz_title][cz_gap id="cz_74618"][cz_title vertical="cz_title_vertical" title_pos="cz_title_pos_block" id="cz_83294" sk_overall="margin-top:55px;margin-left:5px;" sk_overall_mobile="display:none;"]<span style="color: #ffffff; font-weight: 200; font-size: 32px;">BASIC PLAN </span>[/cz_title][cz_title text_center="true" id="cz_69585" sk_overall="margin-left:75px;" sk_overall_mobile="margin-left:0px;"]<span style="color: #ffffff; font-size: 14px;">50 GB Disk Space</span>
	<span style="color: #ffffff; font-size: 14px;"> 10 Databases List</span>
	<span style="color: #ffffff; font-size: 14px;"> Free Domain Registration</span>
	<span style="color: #ffffff; font-size: 14px;"> 1 Hosting Space</span>
	<span style="color: #ffffff; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="color: #ffffff; font-size: 14px;"> Account Control Panel</span>
	<span style="color: #ffffff; font-size: 14px;"> FREE 24/7 Support</span>[/cz_title][cz_gap height="40px" id="cz_80245"][cz_button title="Get Started" btn_position="cz_btn_center" btn_effect="cz_btn_move_up" icon="fa fa-cart-plus" link="url:%23|||" id="cz_34315" sk_button="border-radius:100px;background-color:rgba(0,0,0,0.29);" sk_hover="box-shadow:0px 9px 21px rgba(0,0,0,0.18) ;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column offset="vc_col-lg-4"][cz_content_box type="1" id="cz_72925" sk_overall="background-color:transparent;background-image:linear-gradient(135deg,#5f5fa7,#e54b81);padding-bottom:40px;margin-bottom:30px;border-width:1px 1px 3px;border-radius:100px 0 100px 0;" sk_hover="border-radius:0 100px 0 100px;"][cz_title title_pos="cz_title_pos_block" shape="circle" id="cz_61780" sk_overall="padding-bottom:0px;padding-top:30px;margin-left:25px;margin-top:20px;" sk_shape="background-color:rgba(0,0,0,0.28);"]
	<div style="line-height: 1.1; text-align: left;"><span style="display: block; font-size: 36px; font-weight: bold; color: #ffffff;">$9.99</span></div>
	<div style="line-height: 1.1; text-align: left;"><span style="color: #ffffff; font-weight: 300; margin-left: 9px;">Per Month</span></div>
	[/cz_title][cz_gap id="cz_62355"][cz_title vertical="cz_title_vertical" title_pos="cz_title_pos_block" id="cz_93055" sk_overall="margin-top:55px;margin-left:5px;" sk_overall_mobile="display:none;"]<span style="color: #ffffff; font-weight: 200; font-size: 32px;">PRO PLAN </span>[/cz_title][cz_title text_center="true" id="cz_43815" sk_overall="padding-left:75px;" sk_overall_mobile="padding-left:0px;"]<span style="color: #ffffff; font-size: 14px;">50 GB Disk Space</span>
	<span style="color: #ffffff; font-size: 14px;"> 10 Databases List</span>
	<span style="color: #ffffff; font-size: 14px;"> Free Domain Registration</span>
	<span style="color: #ffffff; font-size: 14px;"> 1 Hosting Space</span>
	<span style="color: #ffffff; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="color: #ffffff; font-size: 14px;"> Account Control Panel</span>
	<span style="color: #ffffff; font-size: 14px;"> FREE 24/7 Support</span>

	&nbsp;[/cz_title][cz_gap height="40px" id="cz_94468"][cz_button title="Get Started" btn_position="cz_btn_center" btn_effect="cz_btn_move_up" icon="fa fa-cart-plus" link="url:%23|||" id="cz_68038" sk_button="border-radius:100px;background-color:rgba(0,0,0,0.29);" sk_hover="box-shadow:0px 9px 21px rgba(0,0,0,0.18) ;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column offset="vc_col-lg-4"][cz_content_box type="1" id="cz_97193" sk_overall="background-color:transparent;background-image:linear-gradient(315deg,#5f5fa7,#e54b81);padding-bottom:40px;margin-bottom:30px;border-width:1px 1px 3px;border-radius:100px 0 100px 0;" sk_hover="border-radius:0 100px 0 100px;"][cz_title title_pos="cz_title_pos_block" shape="circle" id="cz_35259" sk_overall="padding-bottom:0px;padding-top:30px;margin-left:15px;margin-top:20px;" sk_shape="background-color:rgba(0,0,0,0.28);"]
	<div style="line-height: 1.1; text-align: left;"><span style="display: block; font-size: 36px; font-weight: bold; color: #ffffff;">$19.99</span></div>
	<div style="line-height: 1.1; text-align: left;"><span style="color: #ffffff; font-weight: 300; margin-left: 28px;">Per Year</span></div>
	[/cz_title][cz_gap id="cz_12780"][cz_title vertical="cz_title_vertical" title_pos="cz_title_pos_block" text_center="true" id="cz_15270" sk_overall="margin-top:50px;margin-left:5px;" sk_overall_mobile="display:none;"]<span style="color: #ffffff; font-weight: 200; font-size: 32px;">ULTIMATE PRO </span>[/cz_title][cz_title text_center="true" id="cz_72290" sk_overall="padding-left:75px;" sk_overall_mobile="padding-left:0px;"]<span style="color: #ffffff; font-size: 14px;">50 GB Disk Space</span>
	<span style="color: #ffffff; font-size: 14px;"> 10 Databases List</span>
	<span style="color: #ffffff; font-size: 14px;"> Free Domain Registration</span>
	<span style="color: #ffffff; font-size: 14px;"> 1 Hosting Space</span>
	<span style="color: #ffffff; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="color: #ffffff; font-size: 14px;"> Account Control Panel</span>
	<span style="color: #ffffff; font-size: 14px;"> FREE 24/7 Support</span>[/cz_title][cz_gap height="40px" id="cz_63639"][cz_button title="Get Started" btn_position="cz_btn_center" btn_effect="cz_btn_move_up" icon="fa fa-cart-plus" link="url:%23|||" id="cz_92464" sk_button="border-radius:100px;background-color:rgba(0,0,0,0.29);" sk_hover="box-shadow:0px 9px 21px rgba(0,0,0,0.18) ;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][/vc_row]',
					),
					array(
						'f' => 'pricing table price plan 4 columns blue simple circle rounded capsule flat 20_jpg',
						'c' =>'[vc_row][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" fx_hover="fx_shine_hover" id="cz_86398" sk_overall="border-radius:200px;border-bottom-style:solid;border-color:#eeeeee;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-bottom:60px;padding-top:90px;border-width:2px 2px 2px 2px;background-color:#ffffff;"][cz_title shape="circle" id="cz_32781" sk_shape="font-size:180px;background-color:#1fb4da;top:40px;"]
	<div style="text-align: center; line-height: 1.3;"><span style="font-size: 14px; font-weight: 300; color: #ffffff;">BASIC PLAN</span></div>
	<div style="text-align: center; line-height: 1.3;"><span style="color: #ffffff; display: block; font-size: 34px; font-weight: bold;">FREE</span></div>
	<div style="text-align: center; line-height: 1.3;"><span style="font-size: 13px; color: #ffffff;">Life Time</span></div>
	[/cz_title][cz_gap height="30px" id="cz_38494"][cz_gap id="cz_59742"][vc_column_text]

	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_21581"][cz_button title="Order Now" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_right" icon="fa fa-cart-plus" link="url:%23|||" id="cz_57140" sk_button="border-radius:50px;background-color:#1fb4da;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" fx="fx_zoom_1" fx_hover="fx_shine_hover" id="cz_71522" sk_overall="border-radius:200px;border-bottom-style:solid;border-color:#eeeeee;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-bottom:60px;padding-top:90px;border-width:2px 2px 2px 2px;background-color:#ffffff;"][cz_title shape="circle" id="cz_72031" sk_shape="font-size:180px;background-color:#1f69da;top:40px;"]
	<div style="text-align: center; line-height: 1.3;"><span style="font-size: 14px; font-weight: 300; color: #ffffff;">PRO PLAN</span></div>
	<div style="text-align: center; line-height: 1.3;"><span style="color: #ffffff; display: block; font-size: 34px; font-weight: bold;">$9.99</span></div>
	<div style="text-align: center; line-height: 1.3;"><span style="font-size: 13px; color: #ffffff;">Per Month</span></div>
	[/cz_title][cz_gap height="30px" id="cz_73190"][cz_gap id="cz_64041"][vc_column_text]

	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px;">500 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px;"> 100 Databases List</span>
	<span style="font-weight: 400; font-size: 14px;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px;"> 2 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_47459"][cz_button title="Order Now" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_right" btn_effect="cz_btn_zoom_in" icon="fa fa-cart-plus" link="url:%23|||" id="cz_77199" sk_button="border-radius:50px;background-color:#1f69da;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" fx_hover="fx_shine_hover" id="cz_51446" sk_overall="border-radius:200px;border-bottom-style:solid;border-color:#eeeeee;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-bottom:60px;padding-top:90px;border-width:2px 2px 2px 2px;background-color:#ffffff;"][cz_title shape="circle" id="cz_26428" sk_shape="font-size:180px;background-color:#1fb4da;top:40px;"]
	<div style="text-align: center; line-height: 1.3;"><span style="font-size: 14px; font-weight: 300; color: #ffffff;">PREMIUM PLAN</span></div>
	<div style="text-align: center; line-height: 1.3;"><span style="color: #ffffff; display: block; font-size: 34px; font-weight: bold;">$19.99</span></div>
	<div style="text-align: center; line-height: 1.3;"><span style="font-size: 13px; color: #ffffff;">Per Year</span></div>
	[/cz_title][cz_gap height="30px" id="cz_73138"][cz_gap id="cz_90771"][vc_column_text]

	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_11723"][cz_button title="Order Now" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_right" icon="fa fa-cart-plus" link="url:%23|||" id="cz_46100" sk_button="border-radius:50px;background-color:#1fb4da;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" fx_hover="fx_shine_hover" id="cz_21846" sk_overall="border-radius:200px;border-bottom-style:solid;border-color:#eeeeee;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-bottom:60px;padding-top:90px;border-width:2px 2px 2px 2px;background-color:#ffffff;"][cz_title shape="circle" id="cz_27179" sk_shape="font-size:180px;background-color:#1fb4da;top:40px;"]
	<div style="text-align: center; line-height: 1.3;"><span style="font-size: 14px; font-weight: 300; color: #ffffff;">ULTIMATE PLAN</span></div>
	<div style="text-align: center; line-height: 1.3;"><span style="color: #ffffff; display: block; font-size: 34px; font-weight: bold;">$39.99</span></div>
	<div style="text-align: center; line-height: 1.3;"><span style="font-size: 13px; color: #ffffff;">Per Year</span></div>
	[/cz_title][cz_gap height="30px" id="cz_87704"][cz_gap id="cz_45417"][vc_column_text]

	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_20070"][cz_button title="Order Now" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_right" icon="fa fa-cart-plus" link="url:%23|||" id="cz_16643" sk_button="border-radius:50px;background-color:#1fb4da;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][/vc_row]',
					),
					array(
						'f' => 'pricing table price plan 4 columns blue pink slanted flat 21_jpg',
						'c' =>'[vc_row][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_32084" sk_overall="background-color:#ffffff;padding-right:0px;padding-bottom:40px;padding-left:0px;margin-bottom:30px;border-style:solid;border-width:1px 1px 3px;border-color:#dddddd;border-radius:5px;"][cz_title title_pos="cz_title_pos_block" class="cz_slanted_br_div" id="cz_45897" sk_overall="background-color:#5f5fa7;padding:30px 0px 50px;margin-top:-30px;margin-left:0px;border-radius:5px 5px 0 0;"]
	<div style="line-height: 1.5; text-align: center;"><span style="font-size: 20px; color: #ffffff; font-weight: 200;">B A S I C</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="display: block; font-size: 36px; font-weight: bold; color: #ffffff;">FREE</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="color: #ffffff; font-weight: 300;">Life Time</span></div>
	[/cz_title][cz_gap height="30px" id="cz_41900"][vc_column_text]
	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px; color: #444444;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_57114"][cz_button title="Get Started" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" icon="fa fa-cart-plus" link="url:%23|||" class="cz_slanted_tlbr" id="cz_84310" sk_button="padding-bottom:20px;padding-top:20px;background-color:#5f5fa7;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_64354" sk_overall="background-color:#ffffff;padding-right:0px;padding-bottom:40px;padding-left:0px;margin-bottom:30px;border-style:solid;border-width:1px 1px 3px;border-color:#dddddd;border-radius:5px;"][cz_title title_pos="cz_title_pos_block" class="cz_slanted_br_div" id="cz_22327" sk_overall="background-color:#e54b81;padding:30px 0px 50px;margin-top:-30px;margin-left:0px;border-radius:5px 5px 0 0;"]
	<div style="line-height: 1.5; text-align: center;"><span style="font-size: 20px; color: #ffffff; font-weight: 200;">S T A N D A R D</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="display: block; font-size: 36px; font-weight: bold; color: #ffffff;">$9.99</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="color: #ffffff; font-weight: 300;">Per Month</span></div>
	[/cz_title][cz_gap height="30px" id="cz_79438"][vc_column_text]

	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px; color: #444444;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_26687"][cz_button title="Get Started" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" icon="fa fa-cart-plus" link="url:%23|||" class="cz_slanted_tlbr" id="cz_28306" sk_button="padding-bottom:20px;padding-top:20px;background-color:#e54b81;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_91582" sk_overall="background-color:#ffffff;padding-right:0px;padding-bottom:40px;padding-left:0px;margin-bottom:30px;border-style:solid;border-width:1px 1px 3px;border-color:#dddddd;border-radius:5px;"][cz_title title_pos="cz_title_pos_block" class="cz_slanted_br_div" id="cz_45149" sk_overall="background-color:#5f5fa7;padding:30px 0px 50px;margin-top:-30px;margin-left:0px;border-radius:5px 5px 0 0;"]
	<div style="line-height: 1.5; text-align: center;"><span style="font-size: 20px; color: #ffffff; font-weight: 200;">P R O</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="display: block; font-size: 36px; font-weight: bold; color: #ffffff;">$29.99</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="color: #ffffff; font-weight: 300;">Per Year</span></div>
	[/cz_title][cz_gap height="30px" id="cz_38636"][vc_column_text]

	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px; color: #444444;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_14595"][cz_button title="Get Started" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" icon="fa fa-cart-plus" link="url:%23|||" class="cz_slanted_tlbr" id="cz_18830" sk_button="padding-bottom:20px;padding-top:20px;background-color:#5f5fa7;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_36119" sk_overall="background-color:#ffffff;padding-right:0px;padding-bottom:40px;padding-left:0px;margin-bottom:30px;border-style:solid;border-width:1px 1px 3px;border-color:#dddddd;border-radius:5px;"][cz_title title_pos="cz_title_pos_block" class="cz_slanted_br_div" id="cz_12788" sk_overall="background-color:#5f5fa7;padding:30px 0px 50px;margin-top:-30px;margin-left:0px;border-radius:5px 5px 0 0;"]
	<div style="line-height: 1.5; text-align: center;"><span style="font-size: 20px; color: #ffffff; font-weight: 200;">P R E M I U M</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="display: block; font-size: 36px; font-weight: bold; color: #ffffff;">$49.99</span></div>
	<div style="line-height: 1.5; text-align: center;"><span style="color: #ffffff; font-weight: 300;">Per Year</span></div>
	[/cz_title][cz_gap height="30px" id="cz_82046"][vc_column_text]

	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px; color: #444444;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px; color: #444444;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_78134"][cz_button title="Get Started" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" icon="fa fa-cart-plus" link="url:%23|||" class="cz_slanted_tlbr" id="cz_27532" sk_button="padding-bottom:20px;padding-top:20px;background-color:#5f5fa7;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][/vc_row]',
					),
					array(
						'f' => 'pricing table price plan 2 columns blue simple minimal flat 22_jpg',
						'c' =>'[vc_row full_width="stretch_row" css=".vc_custom_1503939343139{padding-top: 70px !important;padding-bottom: 70px !important;background-color: #5670e1 !important;}"][vc_column width="1/2"][cz_content_box type="1" id="cz_94795" sk_overall="padding-left:50px;padding-bottom:40px;padding-right:50px;background-color:#ffffff;"][cz_button title="Buy it now!" btn_position="cz_btn_right cz_mobile_btn_center" text_effect="cz_btn_show_hidden_icon" icon_position="after" icon="fa fa-shopping-cart" link="url:%23|||" id="cz_84269" sk_button="border-bottom-style:solid;border-color:rgba(86,112,225,0.35);border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-bottom:7px;padding-top:7px;border-width:2px 2px 2px 2px;margin-top:25px;color:#5670e1;background-color:#ffffff;" sk_hover="border-bottom-style:solid;border-color:#5670e1;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:2px 2px 2px 2px;"][cz_title text_center="true" id="cz_40961" sk_overall="margin-top:-5px;" sk_overall_tablet="margin-top:0px;"]
	<div style="line-height: 1.5;"><span style="font-size: 50px; font-weight: bold; color: #5670e1;"><sup style="font-size: 34px;">$</sup><span style="font-size: 70px;">29</span></span></div>
	<div style="line-height: 1.5;"><span style="display: block; color: #999999;">Basic Plan</span></div>
	[/cz_title][cz_free_line position="tac" id="cz_39271" sk_line="background-color:rgba(86,112,225,0.3);width:100%;height:2px;margin-top:30px;margin-bottom:30px;"][vc_column_text]<span style="font-size: 13px; font-weight: 400; color: #666666;">Lorem ipsum dolor sit amet, conse ctetuer adipi scing elit. Nam cursus. Morbi ut mi. Nullam enim leo.</span>[/vc_column_text][/cz_content_box][/vc_column][vc_column width="1/2"][cz_content_box type="1" id="cz_45222" sk_overall="padding-left:50px;padding-bottom:40px;padding-right:50px;background-color:#ffffff;"][cz_button title="Buy it now!" btn_position="cz_btn_right cz_mobile_btn_center" text_effect="cz_btn_show_hidden_icon" icon_position="after" icon="fa fa-shopping-cart" link="url:%23|||" id="cz_21659" sk_button="border-bottom-style:solid;border-color:rgba(86,112,225,0.35);border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-bottom:7px;padding-top:7px;border-width:2px 2px 2px 2px;margin-top:25px;color:#5670e1;background-color:#ffffff;" sk_hover="border-bottom-style:solid;border-color:#5670e1;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:2px 2px 2px 2px;"][cz_title text_center="true" id="cz_65198" sk_overall="margin-top:-5px;" sk_overall_tablet="margin-top:0px;"]
	<div style="line-height: 1.5;"><span style="font-size: 50px; font-weight: bold; color: #5670e1;"><sup style="font-size: 34px;">$</sup><span style="font-size: 70px;">49</span></span></div>
	<div style="line-height: 1.5;"><span style="display: block; color: #999999;">Premium Plan</span></div>
	[/cz_title][cz_free_line position="tac" id="cz_81432" sk_line="background-color:rgba(86,112,225,0.3);width:100%;height:2px;margin-top:30px;margin-bottom:30px;"][vc_column_text]<span style="font-size: 13px; font-weight: 400; color: #666666;">Lorem ipsum dolor sit amet, conse ctetuer adipi scing elit. Nam cursus. Morbi ut mi. Nullam enim leo.</span>[/vc_column_text][/cz_content_box][/vc_column][/vc_row]',
					),
					array(
						'f' => 'pricing table price plan 3 columns pink blue curved gradient 23_jpg',
						'c' =>'[vc_row][vc_column offset="vc_col-lg-4"][cz_content_box type="1" id="cz_57064" sk_overall="background-color:transparent;background-image:linear-gradient(180deg,#0e8dff,#002e5d);padding-bottom:40px;margin-bottom:30px;border-width:1px 1px 3px;border-radius:0 30px 30px 30px;" sk_overall_mobile="border-radius:30px;"][cz_title title_pos="cz_title_pos_left" text_center="true" id="cz_64395" sk_overall="background-color:rgba(0,0,0,0.25);padding:30px 40px;margin-top:20px;margin-left:25px;border-radius:0 100px 100px 100px;" sk_overall_mobile="margin-left:0px;border-radius:30px;"]
	<div style="line-height: 1.1; text-align: center;"><span style="display: block; font-size: 36px; font-weight: bold; color: #ffffff;">FREE</span></div>
	<div style="line-height: 1.1; text-align: center;"><span style="color: #ffffff; font-weight: 300;">Life Time</span></div>
	[/cz_title][cz_gap height="40px" id="cz_33509"][cz_title vertical="cz_title_vertical" title_pos="cz_title_pos_block" id="cz_88713" sk_overall="margin-top:27px;margin-left:5px;" sk_overall_mobile="display:none;"]<span style="color: #ffffff; font-weight: 200; font-size: 32px;">BASIC PLAN </span>[/cz_title][cz_title text_center="true" id="cz_22504" sk_overall="padding-left:75px;" sk_overall_mobile="padding-left:0px;"]<span style="color: #ffffff; font-size: 14px;">50 GB Disk Space</span>
	<span style="color: #ffffff; font-size: 14px;"> 10 Databases List</span>
	<span style="color: #ffffff; font-size: 14px;"> Free Domain Registration</span>
	<span style="color: #ffffff; font-size: 14px;"> 1 Hosting Space</span>
	<span style="color: #ffffff; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="color: #ffffff; font-size: 14px;"> Account Control Panel</span>
	<span style="color: #ffffff; font-size: 14px;"> FREE 24/7 Support</span>[/cz_title][cz_gap height="40px" id="cz_71717"][cz_button title="Get Started" btn_position="cz_btn_center" btn_effect="cz_btn_move_up" icon="fa fa-cart-plus" link="url:%23|||" id="cz_69298" sk_button="border-radius:100px;background-color:rgba(0,0,0,0.15);" sk_hover="box-shadow:0px 9px 21px rgba(0,0,0,0.18) ;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column offset="vc_col-lg-4"][cz_content_box type="1" id="cz_35710" sk_overall="background-color:transparent;background-image:linear-gradient(180deg,#fd0e8b,#5f002f);padding-bottom:40px;margin-bottom:30px;border-width:1px 1px 3px;border-radius:0 30px 30px 30px;" sk_overall_mobile="border-radius:30px;"][cz_title title_pos="cz_title_pos_left" text_center="true" id="cz_88175" sk_overall="background-color:rgba(0,0,0,0.25);padding:30px 40px;margin-top:20px;margin-left:25px;border-radius:0 100px 100px 100px;" sk_overall_mobile="margin-left:0px;border-radius:30px;"]
	<div style="line-height: 1.1; text-align: center;"><span style="display: block; font-size: 36px; font-weight: bold; color: #ffffff;"><span style="font-size: 28px; font-weight: 400;"><sup>$</sup></span>19.99</span></div>
	<div style="line-height: 1.1; text-align: center;"><span style="color: #ffffff; font-weight: 300;">Per Month</span></div>
	[/cz_title][cz_gap height="40px" id="cz_11964"][cz_title vertical="cz_title_vertical" title_pos="cz_title_pos_block" id="cz_44414" sk_overall="margin-top:27px;margin-left:5px;" sk_overall_mobile="display:none;"]<span style="color: #ffffff; font-weight: 200; font-size: 32px;">GOLD PLAN </span>[/cz_title][cz_title text_center="true" id="cz_66020" sk_overall="padding-left:75px;" sk_overall_mobile="padding-left:0px;"]<span style="color: #ffffff; font-size: 14px;">50 GB Disk Space</span>
	<span style="color: #ffffff; font-size: 14px;"> 10 Databases List</span>
	<span style="color: #ffffff; font-size: 14px;"> Free Domain Registration</span>
	<span style="color: #ffffff; font-size: 14px;"> 1 Hosting Space</span>
	<span style="color: #ffffff; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="color: #ffffff; font-size: 14px;"> Account Control Panel</span>
	<span style="color: #ffffff; font-size: 14px;"> FREE 24/7 Support</span>[/cz_title][cz_gap height="40px" id="cz_85419"][cz_button title="Get Started" btn_position="cz_btn_center" btn_effect="cz_btn_move_up" icon="fa fa-cart-plus" link="url:%23|||" id="cz_44214" sk_button="border-radius:100px;background-color:rgba(0,0,0,0.15);" sk_hover="box-shadow:0px 9px 21px rgba(0,0,0,0.18) ;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column offset="vc_col-lg-4"][cz_content_box type="1" id="cz_38057" sk_overall="background-color:transparent;background-image:linear-gradient(180deg,#0e8dff,#002e5d);padding-bottom:40px;margin-bottom:30px;border-width:1px 1px 3px;border-radius:0 30px 30px 30px;" sk_overall_mobile="border-radius:30px;"][cz_title title_pos="cz_title_pos_left" text_center="true" id="cz_71443" sk_overall="background-color:rgba(0,0,0,0.25);padding:30px 40px;margin-top:20px;margin-left:25px;border-radius:0 100px 100px 100px;" sk_overall_mobile="margin-left:0px;border-radius:30px;"]
	<div style="line-height: 1.1; text-align: center;"><span style="display: block; font-size: 36px; font-weight: bold; color: #ffffff;"><span style="font-size: 28px; font-weight: 400;"><sup>$</sup></span>79.99</span></div>
	<div style="line-height: 1.1; text-align: center;"><span style="color: #ffffff; font-weight: 300;">Per Year</span></div>
	[/cz_title][cz_gap height="40px" id="cz_45811"][cz_title vertical="cz_title_vertical" title_pos="cz_title_pos_block" id="cz_53032" sk_overall="margin-top:27px;margin-left:5px;" sk_overall_mobile="display:none;"]<span style="color: #ffffff; font-weight: 200; font-size: 32px;">SLIVER PLAN </span>[/cz_title][cz_title text_center="true" id="cz_44712" sk_overall="padding-left:75px;" sk_overall_mobile="padding-left:0px;"]<span style="color: #ffffff; font-size: 14px;">50 GB Disk Space</span>
	<span style="color: #ffffff; font-size: 14px;"> 10 Databases List</span>
	<span style="color: #ffffff; font-size: 14px;"> Free Domain Registration</span>
	<span style="color: #ffffff; font-size: 14px;"> 1 Hosting Space</span>
	<span style="color: #ffffff; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="color: #ffffff; font-size: 14px;"> Account Control Panel</span>
	<span style="color: #ffffff; font-size: 14px;"> FREE 24/7 Support</span>[/cz_title][cz_gap height="40px" id="cz_25599"][cz_button title="Get Started" btn_position="cz_btn_center" btn_effect="cz_btn_move_up" icon="fa fa-cart-plus" link="url:%23|||" id="cz_20440" sk_button="border-radius:100px;background-color:rgba(0,0,0,0.15);" sk_hover="box-shadow:0px 9px 21px rgba(0,0,0,0.18) ;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][/vc_row]',
					),
					array(
						'f' => 'pricing table price plan 3 columns blue white minimal flat 24_jpg',
						'c' =>'[vc_row full_width="stretch_row" css=".vc_custom_1516444117416{padding-top: 100px !important;padding-bottom: 100px !important;background-color: #eeeeee !important;}"][vc_column offset="vc_col-lg-4"][cz_content_box type="1" id="cz_14094" sk_overall="background-color:#ffffff;padding-bottom:40px;margin-bottom:30px;border-style:solid;border-top-width:10px;border-color:#8699e9;box-shadow:0px 0px 25px rgba(0,0,0,0.12);" sk_hover="border-color:#8699e9;border-top-width:20px;margin-top:-10px;"][cz_title id="cz_58405" sk_overall="margin-bottom:10px;margin-top:-10px;"]
	<h4 style="text-align: center;"><span style="color: #999999; font-weight: 300;">Standard</span></h4>
	[/cz_title][cz_title title_pos="cz_title_pos_block" id="cz_28338" sk_overall="margin-bottom:20px;margin-top:10px;"]
	<h3 style="text-align: center;"><span style="color: #8699e9; font-size: 50px;"><span style="font-size: 38px;"><sup>$</sup></span>9.99</span></h3>
	[/cz_title][vc_column_text]

	<p style="text-align: center;"><span style="color: #999999;">10 GB Disk Space</span>
	<span style="color: #999999;"> 20 Databases List</span>
	<span style="color: #999999;"> Free Domain Registration</span>
	<span style="color: #999999;"> 1 Hosting Space</span>
	<span style="color: #999999;"> FREE Ad Coupons</span>
	<span style="color: #999999;"> Account Control Panel</span>
	<span style="color: #999999;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_18573"][cz_button title="Order Now" btn_position="cz_btn_center" btn_effect="cz_btn_absorber" icon="fa fa-cart-plus" link="url:%23|||" id="cz_63115" sk_button="border-radius:50px;border-color:#8699e9;padding-bottom:6px;padding-top:6px;border-width:2px 2px 2px 2px;background-color:#ffffff;color:#8699e9;" sk_hover="background-color:#8699e9;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column offset="vc_col-lg-4"][cz_content_box type="1" id="cz_49176" sk_overall="background-color:#ffffff;padding-bottom:40px;margin-bottom:30px;border-style:solid;border-top-width:10px;border-color:#5670e1;box-shadow:0px 0px 25px rgba(0,0,0,0.12);" sk_hover="border-top-style:solid;border-color:#5670e1;border-top-width:20px;margin-top:-10px;"][cz_title id="cz_77824" sk_overall="margin-bottom:10px;margin-top:-10px;"]
	<h4 style="text-align: center;"><span style="color: #999999; font-weight: 300;">Premium</span></h4>
	[/cz_title][cz_title title_pos="cz_title_pos_block" id="cz_53817" sk_overall="margin-bottom:20px;margin-top:10px;"]
	<h3 style="text-align: center;"><span style="color: #5670e1; font-size: 50px;"><span style="font-size: 38px;"><sup>$</sup></span>19.99</span></h3>
	[/cz_title][vc_column_text]

	<p style="text-align: center;"><span style="color: #999999;">100 GB Disk Space</span>
	<span style="color: #999999;"> 20 Databases List</span>
	<span style="color: #999999;"> Free Domain Registration</span>
	<span style="color: #999999;"> 2 Hosting Space</span>
	<span style="color: #999999;"> FREE Ad Coupons</span>
	<span style="color: #999999;"> Account Control Panel</span>
	<span style="color: #999999;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_39245"][cz_button title="Order Now" btn_position="cz_btn_center" btn_effect="cz_btn_absorber" icon="fa fa-cart-plus" link="url:%23|||" id="cz_30808" sk_button="border-radius:50px;border-color:#5670e1;padding-bottom:6px;padding-top:6px;border-width:2px 2px 2px 2px;background-color:#ffffff;color:#5670e1;" sk_hover="background-color:#5670e1;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column offset="vc_col-lg-4"][cz_content_box type="1" id="cz_48653" sk_overall="background-color:#ffffff;padding-bottom:40px;margin-bottom:30px;border-style:solid;border-top-width:10px;border-color:#0e33d4;box-shadow:0px 0px 25px rgba(0,0,0,0.12);" sk_hover="border-top-style:solid;border-color:#0e33d4;border-top-width:20px;margin-top:-10px;"][cz_title id="cz_11408" sk_overall="margin-bottom:10px;margin-top:-10px;"]
	<h4 style="text-align: center;"><span style="color: #999999; font-weight: 300;">Ultimate</span></h4>
	[/cz_title][cz_title title_pos="cz_title_pos_block" id="cz_39775" sk_overall="margin-bottom:20px;margin-top:10px;"]
	<h3 style="text-align: center;"><span style="color: #0e33d4; font-size: 50px;"><span style="font-size: 38px;"><sup>$</sup></span>29.99</span></h3>
	[/cz_title][vc_column_text]

	<p style="text-align: center;"><span style="color: #999999;">1000 GB Disk Space</span>
	<span style="color: #999999;"> 200 Databases List</span>
	<span style="color: #999999;"> Free Domain Registration</span>
	<span style="color: #999999;"> 2 Hosting Space</span>
	<span style="color: #999999;"> FREE Ad Coupons</span>
	<span style="color: #999999;"> Account Control Panel</span>
	<span style="color: #999999;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_26234"][cz_button title="Order Now" btn_position="cz_btn_center" btn_effect="cz_btn_absorber" icon="fa fa-cart-plus" link="url:%23|||" id="cz_90916" sk_button="border-radius:50px;border-color:#0e33d4;padding-bottom:6px;padding-top:6px;border-width:2px 2px 2px 2px;background-color:#ffffff;color:#0e33d4;" sk_hover="background-color:#0e33d4;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][/vc_row]',
					),
					array(
						'f' => 'pricing table price plan 4 columns blue simple minimal flat 25_jpg',
						'c' =>'[vc_row full_width="stretch_row" css=".vc_custom_1516445052093{padding-top: 100px !important;padding-bottom: 100px !important;background-color: #eeeeee !important;}" el_class="no_padding"][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" id="cz_72185" sk_overall="padding-bottom:45px;padding-top:45px;background-color:#ffffff;" sk_hover="box-shadow:0px 0px 25px rgba(0,0,0,0.12) ;"][cz_title id="cz_89740" sk_overall="margin-bottom:10px;margin-top:-10px;"]

	<p style="text-align: center;"><span style="color: #aaaaaa; font-size: 15px;">STANDARD</span></p>
	[/cz_title][cz_title title_pos="cz_title_pos_block" id="cz_49581" sk_overall="margin-bottom:20px;margin-top:10px;"]
	<h3 style="text-align: center;"><span style="color: #6e85e5; font-size: 50px;"><span style="font-size: 38px;"><sup>$</sup></span>9.99</span></h3>
	[/cz_title][cz_button title="Order Now" btn_position="cz_btn_center" btn_effect="cz_btn_absorber" icon="fa fa-cart-plus" link="url:%23|||" id="cz_29882" sk_button="border-radius:50px;border-color:rgba(14,51,212,0.5);padding-bottom:6px;padding-top:6px;border-width:2px 2px 2px 2px;background-color:#ffffff;color:rgba(14,51,212,0.5);" sk_hover="background-color:#0e33d4;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" id="cz_85233" sk_overall="padding-bottom:45px;padding-top:45px;background-color:#ffffff;" sk_hover="box-shadow:0px 0px 25px rgba(0,0,0,0.12) ;"][cz_title id="cz_55782" sk_overall="margin-bottom:10px;margin-top:-10px;"]
	<p style="text-align: center;"><span style="color: #aaaaaa; font-size: 15px;">PREMIUM</span></p>
	[/cz_title][cz_title title_pos="cz_title_pos_block" id="cz_38492" sk_overall="margin-bottom:20px;margin-top:10px;"]
	<h3 style="text-align: center;"><span style="color: #6e85e5; font-size: 50px;"><span style="font-size: 38px;"><sup>$</sup></span>19.99</span></h3>
	[/cz_title][cz_button title="Order Now" btn_position="cz_btn_center" btn_effect="cz_btn_absorber" icon="fa fa-cart-plus" link="url:%23|||" id="cz_54717" sk_button="border-radius:50px;border-color:rgba(14,51,212,0.5);padding-bottom:6px;padding-top:6px;border-width:2px 2px 2px 2px;background-color:#ffffff;color:rgba(14,51,212,0.5);" sk_hover="background-color:#0e33d4;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" fx="fx_zoom_1" id="cz_37645" sk_overall="background-color:#ffffff;padding-top:50px;padding-bottom:50px;margin-top:-5px;box-shadow:0px 0px 25px rgba(0,0,0,0.12);" sk_hover="box-shadow:0px 0px 25px rgba(0,0,0,0.12) ;" class="z9"][cz_title id="cz_29978" sk_overall="margin-bottom:10px;margin-top:-10px;"]
	<p style="text-align: center;"><span style="color: #aaaaaa; font-size: 15px;">SPECIAL</span></p>
	[/cz_title][cz_title title_pos="cz_title_pos_block" id="cz_45467" sk_overall="margin-bottom:20px;margin-top:10px;"]
	<h3 style="text-align: center;"><span style="color: #0e33d4; font-size: 50px;"><span style="font-size: 38px;"><sup>$</sup></span>29.99</span></h3>
	[/cz_title][cz_button title="Order Now" btn_position="cz_btn_center" btn_effect="cz_btn_absorber" icon="fa fa-cart-plus" link="url:%23|||" id="cz_53307" sk_button="border-radius:50px;border-color:#0e33d4;padding-bottom:6px;padding-top:6px;border-width:2px 2px 2px 2px;background-color:#0e33d4;color:#ffffff;" sk_hover="background-color:#ffffff;color:#0e33d4;" sk_icon_hover="color:#0e33d4;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" id="cz_91261" sk_overall="padding-bottom:45px;padding-top:45px;background-color:#ffffff;" sk_hover="box-shadow:0px 0px 25px rgba(0,0,0,0.12) ;"][cz_title id="cz_65484" sk_overall="margin-bottom:10px;margin-top:-10px;"]
	<p style="text-align: center;"><span style="color: #aaaaaa; font-size: 15px;">ULTIMATE</span></p>
	[/cz_title][cz_title title_pos="cz_title_pos_block" id="cz_96964" sk_overall="margin-bottom:20px;margin-top:10px;"]
	<h3 style="text-align: center;"><span style="color: #6e85e5; font-size: 50px;"><span style="font-size: 38px;"><sup>$</sup></span>49.99</span></h3>
	[/cz_title][cz_button title="Order Now" btn_position="cz_btn_center" btn_effect="cz_btn_absorber" icon="fa fa-cart-plus" link="url:%23|||" id="cz_14319" sk_button="border-radius:50px;border-color:rgba(14,51,212,0.5);padding-bottom:6px;padding-top:6px;border-width:2px 2px 2px 2px;background-color:#ffffff;color:rgba(14,51,212,0.5);" sk_hover="background-color:#0e33d4;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][/vc_row]',
					),
					array(
						'f' => 'pricing table price plan 4 columns blue simple circle rounded dark flat 26_jpg',
						'c' =>'[vc_row full_width="stretch_row" css=".vc_custom_1516448754052{padding-top: 100px !important;padding-bottom: 100px !important;background-color: #282828 !important;}"][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" id="cz_27820" sk_overall="background-color:rgba(255,255,255,0.01);padding-top:40px;padding-bottom:40px;margin-bottom:30px;border-style:solid;border-width:2px;border-color:rgba(255,255,255,0.3);border-radius:10px;"][cz_title id="cz_72094" sk_overall="padding-top:0px;margin-top:-10px;margin-bottom:30px;"]
	<h3 style="text-align: center;"><span style="color: #ffffff;">BASIC</span></h3>
	[/cz_title][cz_title shape="circle" id="cz_17555" sk_overall="margin-top:50px;margin-bottom:60px;" sk_shape="font-size:130px;background-color:#1fb4da;top:70px;"]
	<h3 style="text-align: center;"><span style="color: #ffffff;">FREE</span></h3>
	[/cz_title][cz_gap height="30px" id="cz_69885"][vc_column_text]
	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px; color: #ffffff;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #ffffff;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px; color: #ffffff;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px; color: #ffffff;"> 1 Hosting Space
	FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_19552"][cz_button title="Order Now" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_right" icon="fa fa-cart-plus" link="url:%23|||" id="cz_13920" sk_button="border-radius:50px;background-color:#1fb4da;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" id="cz_86301" sk_overall="background-color:rgba(255,255,255,0.01);padding-top:40px;padding-bottom:40px;margin-bottom:30px;border-style:solid;border-width:2px;border-color:rgba(255,255,255,0.3);border-radius:10px;"][cz_title id="cz_12322" sk_overall="padding-top:0px;margin-top:-10px;margin-bottom:30px;"]
	<h3 style="text-align: center;"><span style="color: #ffffff;">STANDARD</span></h3>
	[/cz_title][cz_title shape="circle" id="cz_31126" sk_overall="margin-top:50px;margin-bottom:60px;" sk_shape="font-size:130px;background-color:#1fb4da;top:70px;"]
	<h3 style="text-align: center;"><span style="color: #ffffff;">$9.99</span></h3>
	[/cz_title][cz_gap height="30px" id="cz_37915"][vc_column_text]

	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px; color: #ffffff;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #ffffff;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px; color: #ffffff;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px; color: #ffffff;"> 1 Hosting Space
	FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_36712"][cz_button title="Order Now" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_right" icon="fa fa-cart-plus" link="url:%23|||" id="cz_92853" sk_button="border-radius:50px;background-color:#1fb4da;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" fx="fx_zoom_1" fx_hover="fx_zoom_1_hover" id="cz_89871" sk_overall="background-color:rgba(255,255,255,0.01);padding-top:20px;padding-bottom:40px;border-style:solid;border-width:2px;border-color:#ffffff;border-radius:10px;" sk_overall_tablet="margin-top:40px;margin-bottom:60px;"][cz_title title_pos="cz_title_pos_center" id="cz_41427" sk_overall="border-radius:35px;background-color:#1f69da;padding-bottom:5px;padding-top:5px;margin-top:-44px;"]
	<div style="text-align: center; line-height: 2;"><span style="color: #ffffff; font-size: 14px;">BEST SELLER</span></div>
	[/cz_title][cz_title id="cz_73409" sk_overall="padding-top:0px;margin-top:15px;margin-bottom:30px;"]
	<h3 style="text-align: center;"><span style="color: #ffffff;">PREMIUM</span></h3>
	[/cz_title][cz_title shape="circle" id="cz_37483" sk_overall="margin-top:50px;margin-bottom:60px;" sk_shape="font-size:140px;background-color:#1f69da;top:70px;"]
	<h3 style="text-align: center;"><span style="color: #ffffff;">$19.99</span></h3>
	[/cz_title][cz_gap height="30px" id="cz_18978"][vc_column_text]

	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px; color: #ffffff;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #ffffff;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px; color: #ffffff;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px; color: #ffffff;"> 1 Hosting Space
	FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_34462"][cz_button title="Order Now" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_right" icon="fa fa-cart-plus" link="url:%23|||" id="cz_78850" sk_button="border-radius:50px;background-color:#1f69da;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" id="cz_54203" sk_overall="background-color:rgba(255,255,255,0.01);padding-top:40px;padding-bottom:40px;margin-bottom:30px;border-style:solid;border-width:2px;border-color:rgba(255,255,255,0.3);border-radius:10px;"][cz_title id="cz_70726" sk_overall="padding-top:0px;margin-top:-10px;margin-bottom:30px;"]
	<h3 style="text-align: center;"><span style="color: #ffffff;">ULTIMATE</span></h3>
	[/cz_title][cz_title shape="circle" id="cz_34291" sk_overall="margin-top:50px;margin-bottom:60px;" sk_shape="font-size:130px;background-color:#1fb4da;top:70px;"]
	<h3 style="text-align: center;"><span style="color: #ffffff;">$49.99</span></h3>
	[/cz_title][cz_gap height="30px" id="cz_72641"][vc_column_text]

	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px; color: #ffffff;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px; color: #ffffff;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px; color: #ffffff;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px; color: #ffffff;"> 1 Hosting Space
	FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_47539"][cz_button title="Order Now" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_right" icon="fa fa-cart-plus" link="url:%23|||" id="cz_82895" sk_button="border-radius:50px;background-color:#1fb4da;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][/vc_row]',
					),
					array(
						'f' => 'pricing table price plan 3 columns orange simple dark flat 27_jpg',
						'c' =>'[vc_row][vc_column offset="vc_col-lg-4"][/vc_column][vc_column offset="vc_col-lg-4"][/vc_column][vc_column offset="vc_col-lg-4"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1503946964343{padding-top: 100px !important;padding-bottom: 100px !important;background-color: #2d2d35 !important;}" el_class="no_padding"][vc_column width="1/3"][cz_content_box type="1" id="cz_37555" sk_overall="background-color:rgba(255,255,255,0);padding-bottom:40px;margin-bottom:25px;border-style:solid;border-width:1px;border-color:#f9a711;box-shadow:0px 0px 25px rgba(0,0,0,0.12);"][cz_title id="cz_86384" sk_overall="margin-bottom:10px;margin-top:-10px;"]

	<p style="text-align: center;"><span style="font-size: 14px; color: #ffffff;">STANDARD</span></p>
	[/cz_title][cz_title title_pos="cz_title_pos_block" id="cz_74279" sk_overall="margin-bottom:40px;margin-top:30px;"]
	<div style="text-align: center; line-height: 1.2;"><span style="color: #f9a711; font-size: 50px;"><span style="font-size: 38px;"><sup>$</sup></span><span style="font-weight: bold;">9.99</span></span></div>
	<div style="text-align: center; line-height: 1.2;"><span style="display: block; color: #ffffff; font-weight: 300;">Per Month</span></div>
	[/cz_title][vc_column_text]
	<p style="text-align: center;"><span style="color: #ffffff;">1000 GB Disk Space</span>
	<span style="color: #ffffff;"> 200 Databases List</span>
	<span style="color: #ffffff;"> Free Domain Registration</span>
	<span style="color: #ffffff;"> 2 Hosting Space</span>
	<span style="color: #ffffff;"> FREE Ad Coupons</span>
	<span style="color: #ffffff;"> Account Control Panel</span>
	<span style="color: #ffffff;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="40px" id="cz_49971"][cz_button title="Sign Up Now" btn_position="cz_btn_center" btn_effect="cz_btn_absorber" link="url:%23|||" id="cz_87082" sk_button="border-radius:5px;border-color:#f9a711;padding-bottom:6px;padding-top:6px;border-width:1px 1px 1px 1px;background-color:#f9a711;color:#2d2d35;font-size:14px;" sk_hover="background-color:rgba(255,255,255,0);color:#f9a711;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/3"][cz_content_box type="1" class="z2" id="cz_97695" sk_overall="border-bottom-style:solid;border-color:#f9a711;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-bottom:60px;padding-top:50px;border-width:5px 5px 5px 5px;margin-left:-1px;margin-right:-1px;margin-top:-25px;background-color:rgba(255,255,255,0.01);box-shadow:0px 0px 25px rgba(0,0,0,0.12) ;"][cz_title id="cz_66053" sk_overall="margin-bottom:10px;margin-top:-10px;"]

	<p style="text-align: center;"><span style="font-size: 14px; color: #ffffff;">PREMIUM</span></p>
	[/cz_title][cz_title title_pos="cz_title_pos_block" id="cz_64817" sk_overall="margin-bottom:40px;margin-top:30px;"]
	<div style="text-align: center; line-height: 1.2;"><span style="color: #f9a711; font-size: 50px;"><span style="font-size: 38px;"><sup>$</sup></span><span style="font-weight: bold;">29.99</span></span></div>
	<div style="text-align: center; line-height: 1.2;"><span style="display: block; color: #ffffff; font-weight: 300;">Per Month</span></div>
	[/cz_title][vc_column_text]
	<p style="text-align: center;"><span style="color: #ffffff;">1000 GB Disk Space</span>
	<span style="color: #ffffff;"> 200 Databases List</span>
	<span style="color: #ffffff;"> Free Domain Registration</span>
	<span style="color: #ffffff;"> 2 Hosting Space</span>
	<span style="color: #ffffff;"> FREE Ad Coupons</span>
	<span style="color: #ffffff;"> Account Control Panel</span>
	<span style="color: #ffffff;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="40px" id="cz_56407"][cz_button title="Sign Up Now" btn_position="cz_btn_center" btn_effect="cz_btn_absorber" link="url:%23|||" id="cz_45276" sk_button="border-radius:5px;border-color:#f9a711;padding-bottom:6px;padding-top:6px;border-width:1px 1px 1px 1px;background-color:#f9a711;color:#2d2d35;font-size:14px;" sk_hover="background-color:rgba(255,255,255,0);color:#f9a711;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/3"][cz_content_box type="1" id="cz_16941" sk_overall="border-bottom-style:solid;border-color:#f9a711;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-bottom:40px;border-width:1px 1px 1px 1px;background-color:rgba(255,255,255,0);box-shadow:0px 0px 25px rgba(0,0,0,0.12) ;"][cz_title id="cz_31991" sk_overall="margin-bottom:10px;margin-top:-10px;"]

	<p style="text-align: center;"><span style="font-size: 14px; color: #ffffff;">ULTIMATE</span></p>
	[/cz_title][cz_title title_pos="cz_title_pos_block" id="cz_86429" sk_overall="margin-bottom:40px;margin-top:30px;"]
	<div style="text-align: center; line-height: 1.2;"><span style="color: #f9a711; font-size: 50px;"><span style="font-size: 38px;"><sup>$</sup></span><span style="font-weight: bold;">49.99</span></span></div>
	<div style="text-align: center; line-height: 1.2;"><span style="display: block; color: #ffffff; font-weight: 300;">Per Month</span></div>
	[/cz_title][vc_column_text]
	<p style="text-align: center;"><span style="color: #ffffff;">1000 GB Disk Space</span>
	<span style="color: #ffffff;"> 200 Databases List</span>
	<span style="color: #ffffff;"> Free Domain Registration</span>
	<span style="color: #ffffff;"> 2 Hosting Space</span>
	<span style="color: #ffffff;"> FREE Ad Coupons</span>
	<span style="color: #ffffff;"> Account Control Panel</span>
	<span style="color: #ffffff;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="40px" id="cz_66302"][cz_button title="Sign Up Now" btn_position="cz_btn_center" btn_effect="cz_btn_absorber" link="url:%23|||" id="cz_40159" sk_button="border-radius:5px;border-color:#f9a711;padding-bottom:6px;padding-top:6px;border-width:1px 1px 1px 1px;background-color:#f9a711;color:#2d2d35;font-size:14px;" sk_hover="background-color:rgba(255,255,255,0);color:#f9a711;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][/vc_row]',
					),
					array(
						'f' => 'pricing table price plan 4 columns white simple dark flat 28_jpg',
						'c' =>'[vc_row full_width="stretch_row" css=".vc_custom_1516449292844{padding-top: 100px !important;padding-bottom: 100px !important;background-color: #1c1c1c !important;}"][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" id="cz_11929" sk_overall="background-color:rgba(0,0,0,0);padding-bottom:40px;margin-bottom:30px;border-style:solid;border-width:1px;border-color:#555555;box-shadow:0px 0px 25px rgba(0,0,0,0.12);" sk_hover="background-color:rgba(255,255,255,0.05);"][cz_title id="cz_68670" sk_overall="margin-bottom:10px;margin-top:-10px;"]

	<p style="text-align: center;"><span style="font-size: 14px; color: #999999;">BASIC</span></p>
	[/cz_title][cz_title title_pos="cz_title_pos_block" id="cz_66595" sk_overall="margin-bottom:40px;margin-top:30px;"]
	<div style="text-align: center; line-height: 1.2;"><span style="color: #ffffff; font-size: 50px;"><span style="font-weight: bold;">FREE</span></span></div>
	<div style="text-align: center; line-height: 1.2;"><span style="display: block; color: #999999; font-weight: 300;">Life Time</span></div>
	[/cz_title][vc_column_text]
	<div style="text-align: center; line-height: 1.5;"><span style="color: #999999; font-weight: 300; font-size: 14px;">1000 GB Disk Space</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> 200 Databases List</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> Free Domain Registration</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> 2 Hosting Space</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> Account Control Panel</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> FREE 24/7 Support</span></div>
	[/vc_column_text][cz_gap height="40px" id="cz_68840"][cz_button title="Sign Up Now" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_88135" sk_button="border-radius:50px;border-color:#555555;padding-bottom:6px;padding-top:6px;border-width:1px 1px 1px 1px;background-color:rgba(0,0,0,0);color:#999999;font-size:14px;" sk_hover="background-color:rgba(255,255,255,0.01);color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" id="cz_13505" sk_overall="background-color:rgba(0,0,0,0);padding-bottom:40px;margin-bottom:30px;border-style:solid;border-width:1px;border-color:#555555;box-shadow:0px 0px 25px rgba(0,0,0,0.12);" sk_hover="background-color:rgba(255,255,255,0.05);"][cz_title id="cz_36793" sk_overall="margin-bottom:10px;margin-top:-10px;"]
	<p style="text-align: center;"><span style="font-size: 14px; color: #999999;">STANDARD</span></p>
	[/cz_title][cz_title title_pos="cz_title_pos_block" id="cz_40423" sk_overall="margin-bottom:40px;margin-top:30px;"]
	<div style="text-align: center; line-height: 1.2;"><span style="color: #ffffff; font-size: 50px;"><span style="font-size: 38px;"><sup>$</sup></span><span style="font-weight: bold;">9.99</span></span></div>
	<div style="text-align: center; line-height: 1.2;"><span style="display: block; color: #999999; font-weight: 300;">Per Month</span></div>
	[/cz_title][vc_column_text]
	<div style="text-align: center; line-height: 1.5;"><span style="color: #999999; font-weight: 300; font-size: 14px;">1000 GB Disk Space</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> 200 Databases List</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> Free Domain Registration</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> 2 Hosting Space</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> Account Control Panel</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> FREE 24/7 Support</span></div>
	[/vc_column_text][cz_gap height="40px" id="cz_52271"][cz_button title="Sign Up Now" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_87478" sk_button="border-radius:50px;border-color:#555555;padding-bottom:6px;padding-top:6px;border-width:1px 1px 1px 1px;background-color:rgba(0,0,0,0);color:#999999;font-size:14px;" sk_hover="background-color:rgba(255,255,255,0.01);color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" id="cz_15543" sk_overall="background-color:rgba(255,255,255,0.05);padding-top:50px;padding-bottom:60px;margin-top:-25px;margin-bottom:30px;border-style:solid;border-width:6px;border-color:#999999;box-shadow:0px 0px 25px rgba(0,0,0,0.12);" sk_hover="background-color:rgba(255,255,255,0.1);" sk_overall_tablet="margin-top:5px;"][cz_title id="cz_53719" sk_overall="margin-bottom:10px;margin-top:-10px;"]
	<p style="text-align: center;"><span style="font-size: 14px; color: #999999;">BEST SELLER</span></p>
	[/cz_title][cz_title title_pos="cz_title_pos_block" id="cz_42850" sk_overall="margin-bottom:40px;margin-top:30px;"]
	<div style="text-align: center; line-height: 1.2;"><span style="color: #ffffff; font-size: 50px;"><span style="font-size: 38px;"><sup>$</sup></span><span style="font-weight: bold;">19.99</span></span></div>
	<div style="text-align: center; line-height: 1.2;"><span style="display: block; color: #999999; font-weight: 300;">Per Month</span></div>
	[/cz_title][vc_column_text]
	<div style="text-align: center; line-height: 1.5;"><span style="color: #999999; font-weight: 300; font-size: 14px;">1000 GB Disk Space</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> 200 Databases List</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> Free Domain Registration</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> 2 Hosting Space</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> Account Control Panel</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> FREE 24/7 Support</span></div>
	[/vc_column_text][cz_gap height="40px" id="cz_25023"][cz_button title="Sign Up Now" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_15910" sk_button="border-radius:50px;border-color:#555555;padding-bottom:6px;padding-top:6px;border-width:1px 1px 1px 1px;background-color:rgba(0,0,0,0);color:#999999;font-size:14px;" sk_hover="background-color:rgba(255,255,255,0.01);color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_content_box type="1" id="cz_44274" sk_overall="background-color:rgba(0,0,0,0);padding-bottom:40px;margin-bottom:30px;border-style:solid;border-width:1px;border-color:#555555;box-shadow:0px 0px 25px rgba(0,0,0,0.12);" sk_hover="background-color:rgba(255,255,255,0.05);"][cz_title id="cz_60540" sk_overall="margin-bottom:10px;margin-top:-10px;"]
	<p style="text-align: center;"><span style="font-size: 14px; color: #999999;">ULTIMATE</span></p>
	[/cz_title][cz_title title_pos="cz_title_pos_block" id="cz_98855" sk_overall="margin-bottom:40px;margin-top:30px;"]
	<div style="text-align: center; line-height: 1.2;"><span style="color: #ffffff; font-size: 50px;"><span style="font-size: 38px;"><sup>$</sup></span><span style="font-weight: bold;">59.99</span></span></div>
	<div style="text-align: center; line-height: 1.2;"><span style="display: block; color: #999999; font-weight: 300;">Yearly</span></div>
	[/cz_title][vc_column_text]
	<div style="text-align: center; line-height: 1.5;"><span style="color: #999999; font-weight: 300; font-size: 14px;">1000 GB Disk Space</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> 200 Databases List</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> Free Domain Registration</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> 2 Hosting Space</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> Account Control Panel</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> FREE 24/7 Support</span></div>
	[/vc_column_text][cz_gap height="40px" id="cz_15802"][cz_button title="Sign Up Now" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_76902" sk_button="border-radius:50px;border-color:#555555;padding-bottom:6px;padding-top:6px;border-width:1px 1px 1px 1px;background-color:rgba(0,0,0,0);color:#999999;font-size:14px;" sk_hover="background-color:rgba(255,255,255,0.01);color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][/vc_row]
	',
					),
					array(
						'f' => 'pricing table price plan 4 columns blue simple circle rounded flat 29_jpg',
						'c' =>'[vc_row][vc_column width="1/2" offset="vc_col-lg-3"][cz_title shape="circle" class="z99" id="cz_66318" sk_overall="margin-bottom:-30px;" sk_shape="font-size:140px;background-color:#1fb4da;top:30px;"]
	<div style="text-align: center; line-height: 1.2;"><span style="color: #ffffff; font-size: 32px; font-weight: bold;">FREE</span></div>
	<div style="text-align: center; line-height: 1.3;"><span style="color: #ffffff; font-size: 14px;">Life Time</span></div>
	[/cz_title][cz_content_box type="1" id="cz_73012" sk_overall="background-color:#ffffff;padding-bottom:40px;margin-bottom:50px;border-style:solid;border-width:2px;border-color:#dddddd;border-radius:10px;"][cz_gap id="cz_99108"][cz_title title_pos="cz_title_pos_block" id="cz_33491" sk_overall="background-color:#1fb4da;padding:5px 32px;margin-top:15px;margin-right:-32px;margin-left:-32px;"]
	<p style="text-align: center;"><span style="color: #ffffff; font-size: 14px;">B A S I C</span></p>
	[/cz_title][cz_gap height="30px" id="cz_25999"][vc_column_text]
	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_43791"][cz_button title="Sign Up" btn_position="cz_btn_center" text_effect="cz_btn_show_hidden_icon" icon_position="after" icon="fa fa-long-arrow-right" link="url:%23|||" id="cz_80955" sk_button="border-radius:50px;padding:4px 30px 6px 30px;background-color:#1fb4da;font-size:14px;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_title shape="circle" class="z99" id="cz_94346" sk_overall="margin-bottom:-40px;" sk_shape="font-size:140px;background-color:#1fb4da;top:30px;"]
	<div style="text-align: center; line-height: 1.2;"><span style="color: #ffffff; font-size: 38px; font-weight: bold;">$9</span></div>
	<div style="text-align: center; line-height: 1.3;"><span style="color: #ffffff; font-size: 14px;">Monthly</span></div>
	[/cz_title][cz_content_box type="1" id="cz_77143" sk_overall="background-color:#ffffff;padding-bottom:40px;margin-bottom:50px;border-style:solid;border-width:2px;border-color:#dddddd;border-radius:10px;"][cz_gap id="cz_23119"][cz_title title_pos="cz_title_pos_block" id="cz_16414" sk_overall="background-color:#1fb4da;padding:5px 32px;margin-top:15px;margin-right:-32px;margin-left:-32px;"]

	<p style="text-align: center;"><span style="color: #ffffff; font-size: 14px;">S T A N D A R D</span></p>
	[/cz_title][cz_gap height="30px" id="cz_97038"][vc_column_text]
	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_54139"][cz_button title="Sign Up" btn_position="cz_btn_center" text_effect="cz_btn_show_hidden_icon" icon_position="after" icon="fa fa-long-arrow-right" link="url:%23|||" id="cz_43778" sk_button="border-radius:50px;padding:4px 30px 6px 30px;background-color:#1fb4da;font-size:14px;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_title shape="circle" class="z99" id="cz_37898" sk_overall="margin-bottom:-40px;" sk_shape="font-size:140px;background-color:#1f69da;top:30px;"]
	<div style="text-align: center; line-height: 1.2;"><span style="color: #ffffff; font-size: 38px; font-weight: bold;">$19</span></div>
	<div style="text-align: center; line-height: 1.3;"><span style="color: #ffffff; font-size: 14px;">Per Month</span></div>
	[/cz_title][cz_content_box type="1" id="cz_15406" sk_overall="background-color:#ffffff;padding-bottom:40px;margin-bottom:50px;border-style:solid;border-width:2px;border-color:#dddddd;border-radius:10px;"][cz_gap id="cz_58882"][cz_title title_pos="cz_title_pos_block" id="cz_48839" sk_overall="background-color:#1f69da;padding:5px 32px;margin-top:15px;margin-right:-32px;margin-left:-32px;"]

	<p style="text-align: center;"><span style="color: #ffffff; font-size: 14px;">P R E M I U M</span></p>
	[/cz_title][cz_gap height="30px" id="cz_58693"][vc_column_text]
	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_68607"][cz_button title="Sign Up" btn_position="cz_btn_center" text_effect="cz_btn_show_hidden_icon" icon_position="after" icon="fa fa-long-arrow-right" link="url:%23|||" id="cz_41524" sk_button="border-radius:50px;padding:4px 30px 6px 30px;background-color:#1f69da;font-size:14px;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_title shape="circle" class="z99" id="cz_27165" sk_overall="margin-bottom:-40px;" sk_shape="font-size:140px;background-color:#1fb4da;top:30px;"]
	<div style="text-align: center; line-height: 1.2;"><span style="color: #ffffff; font-size: 38px; font-weight: bold;">$79</span></div>
	<div style="text-align: center; line-height: 1.3;"><span style="color: #ffffff; font-size: 14px;">Yearly</span></div>
	[/cz_title][cz_content_box type="1" id="cz_44776" sk_overall="background-color:#ffffff;padding-bottom:40px;margin-bottom:50px;border-style:solid;border-width:2px;border-color:#dddddd;border-radius:10px;"][cz_gap id="cz_41641"][cz_title title_pos="cz_title_pos_block" id="cz_71037" sk_overall="background-color:#1fb4da;padding:5px 32px;margin-top:15px;margin-right:-32px;margin-left:-32px;"]

	<p style="text-align: center;"><span style="color: #ffffff; font-size: 14px;">U L T I M A T E</span></p>
	[/cz_title][cz_gap height="30px" id="cz_79605"][vc_column_text]
	<p style="text-align: center;"><span style="font-weight: 400; font-size: 14px;">50 GB Disk Space</span>
	<span style="font-weight: 400; font-size: 14px;"> 10 Databases List</span>
	<span style="font-weight: 400; font-size: 14px;"> Free Domain Registration</span>
	<span style="font-weight: 400; font-size: 14px;"> 1 Hosting Space</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="font-weight: 400; font-size: 14px;"> Account Control Panel</span>
	<span style="font-weight: 400; font-size: 14px;"> FREE 24/7 Support</span>

	[/vc_column_text][cz_gap height="30px" id="cz_81596"][cz_button title="Sign Up" btn_position="cz_btn_center" text_effect="cz_btn_show_hidden_icon" icon_position="after" icon="fa fa-long-arrow-right" link="url:%23|||" id="cz_79703" sk_button="border-radius:50px;padding:4px 30px 6px 30px;background-color:#1fb4da;font-size:14px;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][/vc_row]',
					),
					array(
						'f' => 'pricing table price plan 3 columns image product simple 30_jpg',
						'c' =>'[vc_row][vc_column offset="vc_col-lg-4"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_51529" sk_overall="background-color:#ffffff;padding-bottom:40px;margin-bottom:30px;border-style:solid;border-width:1px;border-color:#cccccc;"][cz_title title_pos="cz_title_pos_block" id="cz_49194" sk_overall="background-color:#f5f5f5;padding-right:30px;padding-left:30px;margin:-30px -30px 20px;border-style:solid;border-bottom-width:1px;border-color:#cccccc;"]<p style="text-align: center;"><span style="font-size: 15px; color: #999999;">BASIC</span></p>
	[/cz_title][cz_image image="'.$imgu.'pic81.jpg" id="cz_77315"][cz_title title_pos="cz_title_pos_block" id="cz_14142" sk_overall="background-color:#f5f5f5;padding:20px 30px;margin:10px -30px 20px;border-style:solid;border-top-width:1px;border-bottom-width:1px;border-color:#cccccc;"]
	<h3 style="text-align: center;"><span style="color: #235a96; font-size: 50px;"><span style="font-size: 38px;"><sup>$</sup></span>19.99</span></h3>
	[/cz_title][cz_gap height="20px" id="cz_68678"][cz_button title="Buy Now" btn_position="cz_btn_center" btn_effect="cz_btn_absorber" icon="fa fa-cart-plus" link="url:%23|||" id="cz_48646" sk_button="border-radius:5px;border-color:#235a96;padding:6px 30px 6px 30px;border-width:2px 2px 2px 2px;margin-bottom:10px;margin-top:10px;background-color:#ffffff;color:#235a96;" sk_hover="background-color:#235a96;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column offset="vc_col-lg-4"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_68175" sk_overall="background-color:#ffffff;padding-bottom:40px;margin-bottom:30px;border-style:solid;border-width:1px;border-color:#cccccc;"][cz_title title_pos="cz_title_pos_block" id="cz_56474" sk_overall="background-color:#f5f5f5;padding-right:30px;padding-left:30px;margin:-30px -30px 20px;border-style:solid;border-bottom-width:1px;border-color:#cccccc;"]
	<p style="text-align: center;"><span style="font-size: 15px; color: #999999;">PREMIUM</span></p>
	[/cz_title][cz_image image="'.$imgu.'pic81.jpg" id="cz_95671"][cz_title title_pos="cz_title_pos_block" id="cz_45737" sk_overall="background-color:#f5f5f5;padding:20px 30px;margin:10px -30px 20px;border-style:solid;border-top-width:1px;border-bottom-width:1px;border-color:#cccccc;"]
	<h3 style="text-align: center;"><span style="color: #8e3d76; font-size: 50px;"><span style="font-size: 38px;"><sup>$</sup></span>29.99</span></h3>
	[/cz_title][cz_gap height="20px" id="cz_28304"][cz_button title="Buy Now" btn_position="cz_btn_center" btn_effect="cz_btn_absorber" icon="fa fa-cart-plus" link="url:%23|||" id="cz_40073" sk_button="border-radius:5px;border-color:#8e3d76;padding:6px 30px 6px 30px;border-width:2px 2px 2px 2px;margin-bottom:10px;margin-top:10px;background-color:#ffffff;color:#8e3d76;" sk_hover="background-color:#8e3d76;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column offset="vc_col-lg-4"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_61520" sk_overall="border-bottom-style:solid;border-color:#cccccc;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-bottom:40px;border-width:1px 1px 1px 1px;background-color:#ffffff;"][cz_title title_pos="cz_title_pos_block" id="cz_71490" sk_overall="background-color:#f5f5f5;padding-right:30px;padding-left:30px;margin:-30px -30px 20px;border-style:solid;border-bottom-width:1px;border-color:#cccccc;"]
	<p style="text-align: center;"><span style="font-size: 15px; color: #999999;">ULTIMATE</span></p>
	[/cz_title][cz_image image="'.$imgu.'pic81.jpg" id="cz_19584"][cz_title title_pos="cz_title_pos_block" id="cz_15061" sk_overall="background-color:#f5f5f5;padding:20px 30px;margin:10px -30px 20px;border-style:solid;border-top-width:1px;border-bottom-width:1px;border-color:#cccccc;"]
	<h3 style="text-align: center;"><span style="color: #1e889f; font-size: 50px;"><span style="font-size: 38px;"><sup>$</sup></span>59.99</span></h3>
	[/cz_title][cz_gap height="20px" id="cz_97698"][cz_button title="Buy Now" btn_position="cz_btn_center" btn_effect="cz_btn_absorber" icon="fa fa-cart-plus" link="url:%23|||" id="cz_30963" sk_button="border-radius:5px;border-color:#1e889f;padding:6px 30px 6px 30px;border-width:2px 2px 2px 2px;margin-bottom:10px;margin-top:10px;background-color:#ffffff;color:#1e889f;" sk_hover="background-color:#1e889f;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][/vc_row]',
					),
					array(
						'f' => 'header hero 2 columns green play video full wide 43_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle"][vc_column width="1/2" css=".vc_custom_1513594389563{padding-left: 70px !important;background-color: #81d742 !important;}" offset="vc_col-xs-12"][cz_gap height="100px" id="cz_36081" height_tablet="0px" height_mobile="0px"][cz_title smart_fs="true" id="cz_21857"]<span style="font-weight: bold; font-size: 20px; color: #333333;">C R E A T I V E S T U D I O</span>[/cz_title][cz_gap height="70px" id="cz_54196" height_tablet="20px" height_mobile="0px"][cz_title smart_fs="true" id="cz_15397"]<div style="line-height: 1; letter-spacing: -2px;"><span style="font-size: 74px; font-weight: bold; display: block;">If you can </span></div><div style="line-height: 1; letter-spacing: -2px;"><span style="font-size: 74px; font-weight: bold; display: block;">imagine it,</span></div><div style="line-height: 1; letter-spacing: -2px;"><span style="font-size: 74px; font-weight: bold; display: block;">we can create it!</span></div>[/cz_title][cz_gap height="70px" id="cz_80319" height_tablet="20px" height_mobile="10px"][cz_button title="Learn More ..." text_effect="cz_btn_txt_move_up" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_90246" sk_button="font-size:18px;color:#81d742;background-color:#333333;padding:10px 45px;border-radius:50px;" sk_hover="color:#ffffff;" sk_button_tablet="font-size:16px;padding:8px 30px;" sk_button_mobile="font-size:13px;padding:7px 20px;"][cz_gap height="100px" id="cz_33541" height_tablet="0px" height_mobile="0px"][/vc_column][vc_column width="1/2" css=".vc_custom_1513587604029{background-image: url('.$imgu.'img32.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-xs-12"][cz_button btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" icon="fa fa-play-circle" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DAvWjf_RUy4c|||" id="cz_66574" class="lightbox" sk_button="background-color:rgba(0,0,0,0.01);border-radius:100px;text-shadow:0px 0px 15px rgba(0,0,0,0.36);" sk_hover="text-shadow:1px 1px 22px rgba(0,0,0,0.36) ;" sk_icon="font-size:110px;color:#81d742;" sk_button_tablet="margin-top:100px;margin-bottom:80px;" sk_button_mobile="margin-top:70px;margin-bottom:50px;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'header hero 2 columns gradient about blue purple full wide 44_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle"][vc_column width="1/2" css=".vc_custom_1513589022004{background-color: #f5f5f5 !important;}" offset="vc_col-xs-12"][cz_title id="cz_70249" sk_overall="margin-top:30px;margin-bottom:20px;"]<p style="text-align: center;"><span style="font-weight: 400; font-size: 20px;">F I N A L L Y</span></p>[/cz_title][cz_title smart_fs="true" text_center="true" id="cz_70094" sk_overall="padding-right:90px;padding-left:90px;" sk_overall_tablet="padding-right:20px;padding-left:20px;" sk_overall_mobile="padding-right:0px;padding-left:0px;"]<div style="line-height: 1; letter-spacing: -2px; text-align: center;"><span style="font-size: 90px; font-weight: bold; display: block;">YOU FOUND IT!</span></div>[/cz_title][cz_free_line position="tac" id="cz_75644" sk_line="background-color:transparent;background-image:linear-gradient(90deg,#8224e3,#1e73be);width:60px;height:12px;margin-top:40px;margin-bottom:40px;border-radius:20px;"][cz_title id="cz_73181" sk_overall="padding-right:120px;padding-left:120px;" sk_overall_tablet="padding-right:20px;padding-left:20px;"]<p style="text-align: center;"><span style="color: #666666;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</span></p>[/cz_title][cz_button title="Learn More " btn_position="cz_btn_center" text_effect="cz_btn_show_hidden_icon" icon_position="after" link="url:%23|||" icon="fa fa-long-arrow-right" id="cz_77485" sk_button="font-size:18px;color:#ffffff;background-color:transparent;background-image:linear-gradient(90deg,#8224e3,#1e73be);padding:10px 45px;margin-top:30px;margin-bottom:30px;border-radius:50px;" sk_hover="color:#ffffff;" sk_button_tablet="font-size:14px;" sk_button_mobile="font-size:13px;"][/vc_column][vc_column width="1/2" css=".vc_custom_1513594482684{background-image: url('.$imgu.'img13.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-xs-12"][cz_gap height="100px" id="cz_47673"][/vc_column][/vc_row]
	',
					),
					array(
						'f' => 'header hero 1 column about blue yellow orange construction engineer full wide 45_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" css=".vc_custom_1504128710378{background-image: url('.$imgu.'img100.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" css=".vc_custom_1513595076324{padding-left: 160px !important;}" offset="vc_col-xs-12"][cz_title text_center="true" id="cz_81367" sk_overall="margin-top:90px;margin-bottom:70px;" sk_overall_tablet="margin-top:30px;margin-bottom:30px;" sk_overall_mobile="margin-top:10px;"]<span style="font-weight: 300; font-size: 24px; color: #003a5d;">Hi,</span>[/cz_title][cz_title smart_fs="true" text_center="true" id="cz_57136" sk_overall="margin-bottom:90px;" sk_overall_tablet="margin-bottom:50px;" sk_overall_mobile="padding-right:0px;padding-left:0px;"]<div style="line-height: 1; letter-spacing: -2px;"><span style="font-size: 80px; font-weight: 300; display: block; color: #003a5d;">I\'m an</span></div><div style="line-height: 1; letter-spacing: -2px;"><span style="font-size: 110px; font-weight: bold; display: block; color: #003a5d;">Engineer</span></div>[/cz_title][cz_button title="About Me" btn_position="cz_btn_inline" text_effect="cz_btn_txt_move_up" btn_effect="cz_btn_move_up" link="url:%23|||" id="cz_33941" sk_button="font-size:18px;background-color:#003a5d;padding:10px 45px;margin-right:20px;border-radius:5px;" sk_hover="color:#ffffff;" sk_button_tablet="font-size:14px;padding:10px 30px;" cz_button=""][cz_button title="Contact Me" btn_position="cz_btn_inline" text_effect="cz_btn_txt_move_up" btn_effect="cz_btn_move_up" link="url:%23|||" id="cz_68734" sk_button="font-size:18px;background-color:#003a5d;padding:10px 45px;margin-right:20px;border-radius:5px;" sk_hover="color:#ffffff;" sk_button_tablet="font-size:14px;padding:10px 30px;" cz_button=""][cz_gap height="150px" id="cz_88038" height_mobile="50px"][/vc_column][vc_column width="1/2" css=".vc_custom_1516261947050{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_hidden-sm vc_col-xs-12 vc_hidden-xs"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'header hero 2 columns music player purple full wide mp3 sound 46_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle"][vc_column width="1/2" css=".vc_custom_1513596863916{background-image: url('.$imgu.'img14-2.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-xs-12"][cz_gap height="100px" id="cz_27032"][/vc_column][vc_column width="1/2" css=".vc_custom_1513596849146{background-color: #960dad !important;}" offset="vc_col-xs-12"][cz_title id="cz_76716" sk_overall="margin-top:50px;margin-bottom:30px;" sk_overall_tablet="margin-top:20px;"]<p style="text-align: center;"><span style="font-weight: 400; font-size: 20px; color: rgba(0,0,0,0.38);">N E W R E L E A S E</span></p>[/cz_title][cz_title smart_fs="true" id="cz_58823"]<h3 style="text-align: center;"><span style="font-family: Yesteryear; font-size: 120px; color: #ffffff;">Missing You</span></h3>[/cz_title][cz_music_player flat="true" css_background="rgba(0,0,0,0.38)" tracks="%5B%7B%22title%22%3A%22Missing%20You%22%2C%22badge%22%3A%22NEW%22%2C%22mp3%22%3A%22https%3A%2F%2F0.s3.envato.com%2Ffiles%2F10407161%2Fpreview.mp3%22%7D%5D" id="cz_70155" sk_player="background-color:transparent;background-image:linear-gradient(0deg,rgba(0,0,0,0.52),rgba(17,17,17,0.34));border-radius:5px;" sk_con="display:table;margin-top:60px;margin-right:auto;margin-left:auto;" css_width="280px"][cz_gap height="30px" id="cz_37938"][cz_button title="DOWNLOAD" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_down" icon_position="after" link="url:%23|||" icon="fa fa-download" id="cz_51004" sk_button="font-size:16px;color:#960dad;background-color:#ffffff;padding:10px 35px;margin-top:30px;margin-bottom:30px;border-radius:4px;" sk_button_tablet="font-size:14px;padding:8px 25px;margin-bottom:20px;" sk_button_mobile="font-size:13px;margin-bottom:10px;"][/vc_column][/vc_row][cz_google_font font="Yesteryear"]',
					),
					array(
						'f' => 'header hero 2 columns about medical blue full wide 47_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="top"][vc_column width="1/2" css=".vc_custom_1504361029353{padding-right: 50px !important;padding-left: 50px !important;background-color: #ffffff !important;}"][cz_title id="cz_46174" sk_overall="background-color:#74e7eb;padding-top:90px;border-radius:0 0 5px 5px;" sk_overall_tablet="padding-top:10px;margin-top:20px;border-radius:5px;"]<p style="text-align: center;"><span style="font-weight: 400; font-size: 20px; color: #004491;">Hi, I\'m</span></p>[/cz_title][cz_title smart_fs="true" id="cz_60801" sk_overall="margin-top:50px;margin-bottom:50px;"]<h2 style="font-size: 60px; color: #004491; text-align: center; font-family: Roboto Slab; font-weight: bold; font-style: normal;">Dr. Jennifer Huston</h2>[/cz_title][cz_free_line position="tac" id="cz_89584" sk_line="height:20px;width:20px;background-color:#74e7eb;transform:rotate(45deg);border-radius:4px;"][vc_row_inner][vc_column_inner css=".vc_custom_1504125921224{padding-right: 120px !important;padding-left: 120px !important;}"][vc_column_text]<p style="text-align: justify;"><span style="color: #004491;">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id, condi mentum at, laoreet mattis, massa. Sed eleifend nonummy diam. Praesent mauris ante, elementum et. </span></p>[/vc_column_text][/vc_column_inner][/vc_row_inner][cz_button title="Contact Me" btn_position="cz_btn_center" btn_effect="cz_btn_half_to_fill_v" link="url:%23|||" icon="fa fa-phone-square" id="cz_12206" sk_button="font-size:18px;color:#004491;background-color:#74e7eb;padding:12px 35px;margin-bottom:30px;" sk_hover="border-radius:4px;color:#ffffff;background-color:#004491;" sk_icon_hover="color:#ffffff;" sk_button_tablet="margin-bottom:20px;"][/vc_column][vc_column width="1/2" css=".vc_custom_1513597353931{background-image: url('.$imgu.'img55.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-xs-12"][cz_gap height="200px" id="cz_45006"][/vc_column][/vc_row][cz_google_font font="Roboto Slab"]',
					),
					array(
						'f' => 'header hero 2 columns about blue yellow orange construction engineer full wide 48_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" equal_height="yes" content_placement="middle" css=".vc_custom_1513599775066{background-image: url('.$imgu.'img45.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" css=".vc_custom_1504365231391{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column][vc_column width="1/2" css=".vc_custom_1516262135843{padding-right: 50px !important;padding-left: 50px !important;}" offset="vc_col-xs-12"][cz_title text_center="true" id="cz_55524" sk_overall="border-radius:4px;background-color:#ffd200;"]<p style="text-align: center;"><span style="font-weight: 400; font-size: 20px; color: #273284;">Hi, I\'m</span></p>[/cz_title][cz_title smart_fs="true" text_center="true" id="cz_35467" sk_overall="margin-top:50px;margin-bottom:50px;"]<div style="line-height: 1; letter-spacing: -2px; text-align: center;"><span style="font-size: 90px; font-weight: bold; display: block; color: #273284;">Mechanical Engineer</span></div>[/cz_title][cz_free_line position="tac" id="cz_18691" sk_line="background-color:#ffbe00;width:50px;height:14px;border-radius:3px;"][cz_title id="cz_71504" sk_overall="padding-right:90px;padding-left:90px;margin-top:40px;margin-bottom:40px;" sk_overall_tablet="padding-right:30px;padding-left:30px;" sk_overall_mobile="padding-right:10px;padding-left:10px;"]<p style="text-align: justify; line-height: 1.2;"><span style="color: #004491; line-height: 1.4;">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id, condi mentum at, laoreet mattis, massa sed eleifend.</span></p>[/cz_title][cz_button title="Contact Me" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" icon="fa fa-phone-square" id="cz_62193" sk_button="border-radius:4px;padding:12px 35px 12px 35px;background-color:#ffd200;font-size:18px;color:#273284;" sk_hover="border-radius:4px;box-shadow:0px 0px 15px rgba(0,0,0,0.24) ;color:#ffffff;background-color:#273284;" sk_icon_hover="color:#ffffff;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'header hero 2 columns about gray red consultation lawyer full wide 49_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="top" css=".vc_custom_1504367509075{background-image: url('.$imgu.'img50.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" offset="vc_col-xs-12"][cz_gap height="100px" id="cz_96298"][cz_title shape="icon" shape_icon="fa fa-balance-scale" id="cz_84618" sk_overall="border-radius:4px;" sk_shape="color:rgba(0,0,0,0.14);font-size:90px;top:25px;"]<p style="text-align: center;"><span style="font-weight: 400; font-size: 24px;">Legal Office</span></p>[/cz_title][cz_gap height="60px" id="cz_61692"][cz_title smart_fs="true" id="cz_49926" sk_overall_mobile="padding-right:0px;padding-left:0px;"]<div style="line-height: 1; letter-spacing: -2px; text-align: center;"><span style="font-size: 70px; font-weight: bold; display: block; line-height: 1.5;">Alex Someone</span></div><div style="text-align: center;"><span style="line-height: 1.5; font-size: 20px;">Financial Lawyer </span></div>[/cz_title][cz_gap height="30px" id="cz_74801"][cz_free_line position="tac" id="cz_95278" sk_line="height:20px;width:20px;background-color:#871926;transform:rotate(45deg);border-radius:3px;"][cz_gap height="30px" id="cz_83405"][cz_title id="cz_32910"]<div style="text-align: center;">Call for free consultation:</div><div style="line-height: 1; letter-spacing: -2px; text-align: center;"><span style="font-size: 36px; font-weight: bold; display: block; line-height: 1.5;">+1 (800) 123 4567</span></div><div style="text-align: center;"></div>[/cz_title][cz_button title="Free Consultation" btn_position="cz_btn_center" text_effect="cz_btn_ghost_icon" btn_effect="cz_btn_zoom_in" link="url:%23|||" icon="fa fa-comments" id="cz_85880" sk_button="font-size:16px;color:#ffffff;background-color:#871926;padding:12px 30px;margin-top:30px;border-radius:4px;" sk_hover="border-radius:4px;box-shadow:0px 0px 15px rgba(0,0,0,0.24) ;color:#ffffff;background-color:#333333;" sk_icon="color:rgba(255,255,255,0.3);" sk_icon_hover="color:#ffffff;" sk_button_tablet="font-size:14px;margin-top:20px;"][cz_gap height="90px" id="cz_63156"][/vc_column][vc_column width="1/2" css=".vc_custom_1513606109577{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_hidden-sm vc_hidden-xs"][/vc_column][/vc_row]
	',
					),
					array(
						'f' => 'header hero 2 columns about red sport martial full wide 50_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" equal_height="yes" content_placement="middle" css=".vc_custom_1504386633673{background-image: url('.$imgu.'img43-2.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" css=".vc_custom_1513606215350{padding-right: 20px !important;padding-left: 80px !important;}" offset="vc_col-xs-12"][cz_gap height="60px" id="cz_35029"][cz_title smart_fs="true" class="cz_slanted_tlbr_div" id="cz_11779" sk_overall="background-color:#c60b36;padding-bottom:25px;padding-top:25px;margin-left:10px;"]<p style="text-align: left;"><span style="font-weight: 400; font-size: 26px; color: #ffffff;">MARTIAL ART</span></p>[/cz_title][cz_gap height="60px" id="cz_84635"][cz_title smart_fs="true" id="cz_16885"]<div style="line-height: 1; letter-spacing: -2px; text-align: left;"><span style="font-size: 78px; font-weight: 200; display: block; line-height: 1;"><span style="font-weight: 500;">Force</span> has no place where there is need of <span style="font-weight: 500;">skill</span>.</span></div>[/cz_title][cz_gap height="60px" id="cz_56140"][cz_button title="LEARN MORE " text_effect="cz_btn_txt_move_up" link="url:%23|||" class="cz_slanted_tlbr_a" id="cz_88663" sk_button="padding:25px 30px 25px 30px;margin-left:8px;background-color:#c60b36;font-size:16px;color:#ffffff;" sk_hover="color:#ffffff;background-color:#81011e;" sk_icon="color:rgba(255,255,255,0.3);" sk_icon_hover="color:#ffffff;"][cz_gap height="60px" id="cz_42419"][/vc_column][vc_column width="1/2" css=".vc_custom_1504365231391{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'header hero 2 columns about brown fashion shop full wide 51_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" equal_height="yes" content_placement="middle" css=".vc_custom_1504386716139{background-image: url('.$imgu.'img36.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" css=".vc_custom_1504365231391{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column][vc_column width="1/2" css=".vc_custom_1516262332116{padding-right: 50px !important;padding-left: 80px !important;}" offset="vc_col-xs-12"][cz_gap height="60px" id="cz_60252"][cz_title title_pos="cz_title_pos_left" class="cz_slanted_tlbr_div" id="cz_13103" sk_overall="background-color:#c99062;padding-bottom:15px;padding-top:15px;margin-left:8px;"]<p style="text-align: center;"><span style="font-weight: 400; font-size: 22px; color: #ffffff;">2017</span></p>[/cz_title][cz_gap height="40px" id="cz_25398"][cz_title smart_fs="true" id="cz_18386"]<div style="line-height: 1; letter-spacing: -2px; text-align: left;"><span style="font-size: 100px; font-weight: bold; display: block; color: #6b4221;">SUMMER FASHION WEEK</span></div>[/cz_title][cz_gap height="20px" id="cz_16012"][cz_gap height="30px" id="cz_55031"][cz_button title="View Details" text_effect="cz_btn_txt_move_right" icon_position="after" link="url:%23|||" class="cz_slanted_tlbr_a" id="cz_28322" sk_button="padding-bottom:20px;padding-top:20px;margin-left:8px;background-color:#c99062;font-size:15px;color:#ffffff;" sk_hover="color:#ffffff;background-color:#6b4221;" sk_icon_hover="color:#ffffff;"][cz_gap height="60px" id="cz_70682"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'header hero 2 columns about red fashion shop full wide 52_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" equal_height="yes" content_placement="middle" css=".vc_custom_1504389798075{background-image: url('.$imgu.'img56.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="2/3" css=".vc_custom_1504384433068{padding-right: 100px !important;padding-left: 100px !important;}"][cz_gap height="60px" id="cz_16012"][cz_title class="cz_slanted_br_div" id="cz_88990" sk_overall="background-color:#b80000;padding-bottom:30px;margin-left:5px;"]<p style="text-align: left;"><span style="font-weight: 400; font-size: 36px; color: #ffffff;">20% OFF</span></p>[/cz_title][cz_gap height="75px" id="cz_98713"][cz_title smart_fs="true" id="cz_49019"]<span style="line-height: 1;"><span style="font-weight: 500;"><span style="font-weight: bold; font-size: 30px;">N E W A R R I V A L </span></span><span style="display: block; font-weight: 200; font-size: 130px;"> Summer Collection</span></span>[/cz_title][cz_gap height="40px" id="cz_94307"][cz_button title="SHOP ONLINE" btn_effect="cz_btn_half_to_fill_v" link="url:%23|||" icon="fa fa-shopping-cart" id="cz_25379" sk_button="padding-bottom:12px;padding-top:12px;margin-left:8px;background-color:#b80000;font-size:16px;color:#333333;" sk_hover="box-shadow:0px 0px 15px rgba(0,0,0,0.24) ;color:#ffffff;background-color:#b80000;" sk_icon="color:#333333;" sk_icon_hover="color:#ffffff;"][cz_gap height="80px" id="cz_90692"][/vc_column][vc_column width="1/3" css=".vc_custom_1504365231391{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'header hero 1 column full wide light blue purple 53_jpg',
						'c' =>'[vc_row full_width="stretch_row_content" parallax="content-moving" css=".vc_custom_1504569288399{background-image: url('.$imgu.'img29.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}][vc_column offset="vc_col-xs-12"][cz_gap height="120px" id="cz_71512" height_tablet="40px" height_mobile="20px"][cz_title smart_fs="true" id="cz_42132"]<p style="text-align: center;"><span style="font-weight: bold; font-size: 20px; color: #525252;">C R E A T I V E  S T U D I O</span></p>[/cz_title][cz_gap id="cz_93297"][cz_title smart_fs="true" text_center="true" id="cz_96176"]<div style="line-height: 1; letter-spacing: -2px; text-align: center;"><span style="font-size: 90px; font-weight: 300; display: block; color: #525252;">If you can <span style="font-weight: bold; color: #9e066a;">imagine</span> it,</span></div><div style="line-height: 1; letter-spacing: -2px; text-align: center;"><span style="font-size: 90px; font-weight: 300; display: block; color: #525252;">we can <span style="font-weight: bold; color: #09359b;">create </span>it!</span></div>[/cz_title][cz_gap height="70px" id="cz_68262" height_mobile="50px"][cz_button title="Learn More ..." btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_83476" sk_button="font-size:17px;color:#525252;font-weight:700;background-color:rgba(255,255,255,0.01);padding:10px 45px;border-style:solid;border-width:4px;border-color:#525252;border-radius:50px;" sk_hover="border-radius:10px;color:#525252;background-color:rgba(255,255,255,0.01);" sk_icon_hover="color:#525252;" sk_button_tablet="font-size:15px;padding-right:35px;padding-left:35px;border-style:solid;border-width:3px;" sk_button_mobile="font-size:13px;padding-right:25px;padding-left:25px;border-style:solid;border-width:2px;"][cz_gap height="70px" id="cz_26132" height_mobile="50px"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'header hero 1 column full wide dark sport gym 54_jpg',
						'c' =>'[vc_row full_width="stretch_row_content" parallax="content-moving" css=".vc_custom_1507847288399{background-image: url('.$imgu.'img1.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}][vc_column][cz_gap height="120px" id="cz_55320"][cz_title id="cz_19643" sk_overall="padding-left:30px;padding-right:30px;"]<p style="text-align: center;"><span style="font-weight: bold; font-size: 20px; color: #ffffff;"><span style="font-weight: 600; font-size: 28px;">X T R A G Y M &amp; F I T N E S S </span></span></p>[/cz_title][cz_gap id="cz_36966"][cz_title smart_fs="true" id="cz_61126" sk_overall="padding:10px 40px;border-style:solid;border-width:5px;border-color:#ffffff;" sk_overall_mobile="padding:0px;border-style:none;"]<div style="text-align: center; line-height: 1.3;"><span style="font-size: 100px; color: #ffffff; font-weight: bold;">NEVER GIVE UP</span></div>[/cz_title][cz_gap height="70px" id="cz_79318"][cz_button title="Start Workout" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" btn_effect="cz_btn_absorber" link="url:%23|||" id="cz_73235" sk_button="border-bottom-style:solid;border-color:#ffffff;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:10px 45px 10px 45px;border-width:4px 4px 4px 4px;font-weight:700;background-color:rgba(255,255,255,0.01);font-size:17px;color:#ffffff;" sk_hover="color:#ffffff;background-color:rgba(255,255,255,0.01);" sk_icon_hover="color:#ffffff;"][cz_gap height="120px" id="cz_16067" height_mobile="70px"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'header hero 1 column full wide dark creative gradient 55_jpg',
						'c' =>'[vc_row full_width="stretch_row_content" parallax="content-moving" css=".vc_custom_1507227288399{background-image: url('.$imgu.'img52.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}][vc_column offset="vc_col-xs-12"][cz_gap height="100px" id="cz_62246" height_mobile="50px"][cz_title id="cz_89543" sk_overall="padding-left:30px;padding-right:30px;"]<p style="text-align: center;"><span style="font-weight: bold; font-size: 20px; color: #ffffff;"><span style="font-weight: 600; font-size: 28px;">W E A R E X T R A</span></span></p>[/cz_title][cz_gap height="60px" id="cz_17896" height_mobile="30px"][cz_title smart_fs="true" text_center="true" id="cz_64955" sk_overall="padding:5px 50px;border-radius:15px;" sk_overall_mobile="padding:0px;"]<div style="text-align: center; line-height: 1.2;"><span style="font-size: 100px; color: #ffffff; font-weight: bold;">CREATIVE AGENCY</span></div>[/cz_title][cz_gap height="70px" id="cz_19329"][cz_button title="Download it!" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" btn_effect="cz_btn_absorber" link="url:%23|||" id="cz_82769" sk_button="font-size:17px;color:#ffffff;font-weight:400;letter-spacing:2px;background-color:rgba(255,255,255,0.01);padding:10px 35px;border-style:solid;border-width:2px;border-color:#ffffff;border-radius:50px;" sk_hover="color:#ffffff;background-color:rgba(255,255,255,0.12);" sk_icon_hover="color:#ffffff;" sk_button_mobile="font-size:14px;" cz_button=""][cz_gap height="140px" id="cz_51173" height_mobile="50px"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'header hero 1 column full wide dark photography 56_jpg',
						'c' =>'[vc_row full_width="stretch_row_content" css=".vc_custom_1504448919433{background-image: url('.$imgu.'img4.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][cz_gap height="40px" id="cz_73683"][cz_title smart_fs="true" text_center="true" id="cz_77250" sk_overall="padding-right:30px;padding-left:30px;" sk_overall_mobile="padding-right:0px;padding-left:0px;"]<p style="text-align: center;"><span style="font-weight: bold; font-size: 20px; color: #ffffff;"><span style="font-weight: 200; font-size: 28px; letter-spacing: 10px;">XTRA PHOTOGRAPHY</span></span></p>[/cz_title][cz_gap height="60px" id="cz_94494"][cz_gap height="200px" id="cz_47171" height_mobile="60px"][cz_title smart_fs="true" text_center="true" id="cz_52392" sk_overall="padding:5px 50px;border-radius:15px;" sk_overall_mobile="padding:0px;"]<div style="text-align: center; line-height: 1;"><span style="font-size: 100px; color: #ffffff; font-weight: 200;">CREATIVE PHOTOS</span></div>[/cz_title][cz_gap height="30px" id="cz_48901" height_mobile="20px"][cz_button title="PORTFOLIO" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" btn_effect="cz_btn_absorber" link="url:%23|||" id="cz_63400" sk_button="border-radius:50px;border-bottom-style:solid;border-color:#ffffff;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:10px 35px 10px 35px;border-width:2px 2px 2px 2px;font-weight:400;background-color:rgba(255,255,255,0.01);font-size:16px;color:#ffffff;letter-spacing:3px;" sk_hover="color:#ffffff;background-color:rgba(255,255,255,0.12);" sk_icon_hover="color:#ffffff;"][cz_gap id="cz_33718"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'header hero 2 columns fashion dark full wide 57_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" css=".vc_custom_1504449280945{background-image: url('.$imgu.'img8.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" css=".vc_custom_1504515607947{padding-right: 50px !important;padding-left: 50px !important;background-color: rgba(0,0,0,0.6) !important;*background-color: rgb(0,0,0) !important;}"][cz_gap height="60px" id="cz_11612"][cz_title id="cz_25448"]<p style="text-align: center;"><span style="font-size: 24px; color: #ffffff;">2 0 1 8 P A R I S</span></p>[/cz_title][cz_gap height="30px" id="cz_12739"][cz_title smart_fs="true" id="cz_87871"]<div style="line-height: 1; letter-spacing: -2px; text-align: center;"><span style="font-size: 90px; font-weight: 200; display: block; color: #ffffff;">F A S H I O N</span></div><div style="line-height: 1; letter-spacing: -2px; text-align: center;"><span style="font-size: 90px; font-weight: 200; display: block; color: #ffffff;">W E E K</span></div>[/cz_title][cz_gap height="60px" id="cz_88219"][cz_button title="REGISTER NOW" btn_position="cz_btn_center" text_effect="cz_btn_show_hidden_icon" icon_position="after" link="url:%23|||" icon="fa fa-long-arrow-right" id="cz_62960" sk_button="font-size:16px;color:#ffffff;background-color:rgba(225,97,11,0.01);padding:10px 45px;border-style:solid;border-width:2px;border-color:#ffffff;border-radius:50px;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;" sk_button_mobile="font-size:14px;" cz_button=""][cz_gap height="80px" id="cz_87639" height_mobile="30px"][/vc_column][vc_column width="1/2" css=".vc_custom_1504449221450{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'header hero 2 columns sport event countdown dark full wide 58_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="top" css=".vc_custom_1504512468335{background-image: url('.$imgu.'img44.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" offset="vc_col-xs-12"][cz_free_line position="tac" id="cz_77136" sk_line="height:100px;width:6px;background-color:#7ca8ff;border-radius:0 0 30px 30px;"][cz_gap height="30px" id="cz_98708"][cz_title shape="text" shape_text="c h a m p i o n s h i p" css_transform="-20deg" id="cz_48623" sk_shape="color:rgba(124,168,255,0.28);font-family:Six Caps;font-size:130px;top:75px;" sk_overall="margin-top:20px;margin-bottom:50px;" sk_overall_mobile="margin-top:0px;margin-bottom:20px;"]<div style="text-align: center; line-height: 1;"><span style="color: #ffffff; font-size: 86px; font-family: Yesteryear;">Sport Match</span></div>[/cz_title][cz_gap height="60px" id="cz_61263"][cz_countdown type="loop" loop="17120" id="cz_93857" sk_cols="background-color:#7ca8ff;width:60px;padding:5px 12px;margin-right:10px;margin-left:10px;border-radius:5px;" sk_nums="color:#ffffff;" sk_title="font-weight:400;color:rgba(0,0,0,0.47);font-size:11px;" sk_cols_mobile="margin-bottom:20px;" cz_countdown=""][cz_gap id="cz_48393"][cz_button title="Buy Ticket" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" btn_effect="cz_btn_move_up" link="url:%23|||" icon="fa fa-ticket" id="cz_33140" sk_button="border-radius:5px;padding:10px 35px 10px 35px;margin-left:18px;background-color:rgba(88,144,255,0.35);font-size:18px;" sk_hover="color:#ffffff;"][cz_gap id="cz_46198"][cz_free_line position="tac" id="cz_61543" sk_line="height:100px;width:6px;background-color:#7ca8ff;border-radius:30px 30px 0 0;"][/vc_column][vc_column width="1/2" css=".vc_custom_1504128561258{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column][/vc_row][cz_google_font font="Six Caps"][cz_google_font font="Yesteryear"]',
					),
					array(
						'f' => 'header hero 2 columns music event countdown dark red full wide 59_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" equal_height="yes" content_placement="middle" css=".vc_custom_1504521633270{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" css=".vc_custom_1504515946913{background-image: url('.$imgu.'img25.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][cz_gap height="320px" id="cz_17784"][cz_countdown type="loop" loop="18120" id="cz_41692" sk_cols="background-color:#c10010;width:68px;padding:10px 12px;margin-right:10px;margin-left:10px;border-radius:100px;" sk_nums="color:#ffffff;" sk_title="font-weight:400;color:rgba(0,0,0,0.5);font-size:11px;" sk_cols_mobile="margin-bottom:20px;" cz_countdown=""][/vc_column][vc_column width="1/2" css=".vc_custom_1513664177129{background-color: #c10010 !important;}" offset="vc_col-xs-12"][cz_gap height="120px" id="cz_27053"][cz_free_line position="tac" id="cz_66879" sk_line="height:30px;width:30px;background-color:rgba(0,0,0,0.35);border-radius:35px;" sk_circles="border-style:dotted;border-width:10px 10px 10px 10px;"][cz_gap height="20px" id="cz_56966"][cz_title shape="text" smart_fs="true" text_center="true" shape_text="MUSIC FESTIVAL" css_transform="-35deg" id="cz_51733" sk_shape="color:rgba(0,0,0,0.28);font-family:Impact;font-size:70px;letter-spacing:5px;top:110px;"]<p style="text-align: center;"><span style="color: #ffffff; font-size: 86px; font-family: Arizonia;"><span style="font-size: 110px;">Concert</span></span></p>[/cz_title][cz_gap height="30px" id="cz_71603"][cz_free_line position="tac" id="cz_25566" sk_line="height:30px;width:30px;background-color:rgba(0,0,0,0.35);border-radius:50px;"][cz_gap height="70px" id="cz_16925"][cz_button title="Buy Ticket" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" btn_effect="cz_btn_move_up" link="url:%23|||" icon="fa fa-ticket" id="cz_36709" sk_button="border-radius:100px;padding:10px 35px 10px 35px;margin-left:18px;background-color:#ffffff;font-size:18px;color:#c10010;" sk_icon="color:#c10010;"][cz_gap height="100px" id="cz_74276" height_mobile="30px"][/vc_column][/vc_row][cz_google_font font="Arizonia"]',
					),
					array(
						'f' => 'header hero 2 columns minimal light simple full wide 60_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle"][vc_column width="1/2" css=".vc_custom_1504521697610{padding-right: 50px !important;padding-left: 80px !important;background-color: #ffffff !important;}"][cz_gap height="120px" id="cz_14859" height_mobile="40px"][cz_title id="cz_83395"]<p style="text-align: center;"><span style="font-size: 24px; color: #254143;"><span style="font-size: 19px; font-weight: 500; color: #5d797b;">ALEX SOMEONE :</span></span></p>[/cz_title][cz_gap height="30px" id="cz_67502"][cz_title smart_fs="true" text_center="true" id="cz_37770"]<div style="line-height: 1.1; text-align: center;"><span style="color: #5d797b;"><strong><span style="font-size: 60px; font-family: Playfair Display;">The beauty of nature is hidden in details.</span></strong></span></div>[/cz_title][cz_gap height="40px" id="cz_11529" height_mobile="20px"][cz_free_line position="tac" id="cz_71631" sk_line="height:8px;width:60px;background-color:rgba(37,65,67,0.48);border-radius:15px;"][cz_gap height="60px" id="cz_94559" height_mobile="30px"][cz_button title="PORTFOLIO" btn_position="cz_btn_center" link="url:%23|||" id="cz_48531" sk_button="border-radius:5px;padding:12px 35px 12px 35px;background-color:#254143;font-size:16px;color:#ffffff;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;"][cz_gap height="120px" id="cz_29700" height_mobile="10px"][/vc_column][vc_column width="1/2" css=".vc_custom_1504521659812{padding-right: 50px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][cz_image image="'.$imgu.'img15.jpg" id="cz_42869" sk_css="position:relative;display: table;margin:0 auto;"][/vc_column][/vc_row][cz_google_font font="Playfair Display"]',
					),
					array(
						'f' => 'header hero 2 columns about sport gym dancer full wide 61_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle" css=".vc_custom_1504472182219{background-image: url('.$imgu.'img11.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" css=".vc_custom_1516267222990{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_hidden-sm vc_col-xs-12 vc_hidden-xs"][cz_gap height="650px" id="cz_23598" height_mobile="50px"][/vc_column][vc_column width="1/2" css=".vc_custom_1516267182142{padding-right: 70px !important;padding-left: 50px !important;}" offset="vc_col-xs-12"][cz_gap height="70px" id="cz_46147"][cz_title smart_fs="true" text_center="true" id="cz_53079" sk_overall="border-radius:0 30px 0 30px;background-color:#ff0000;margin-right:5px;"]<p style="text-align: right;"><span style="font-weight: 400; font-size: 20px; color: #ffffff;">Hi, I\'m</span></p>[/cz_title][cz_gap id="cz_57453"][cz_title smart_fs="true" text_center="true" id="cz_56699" sk_overall_mobile="padding-right:0px;padding-left:0px;"]<div style="line-height: 1; letter-spacing: -2px; text-align: right;"><span style="font-size: 90px; font-weight: bold; display: block; color: #273284;">Jessica Woodyard</span></div>[/cz_title][cz_gap height="30px" id="cz_41074"][vc_column_text]<p style="line-height: 1.2; text-align: right;"><span style="color: #004491; line-height: 1.4; font-size: 24px; font-weight: 300;">SPORT TRAINER &amp; DANCER</span></p>[/vc_column_text][cz_gap height="20px" id="cz_77772"][cz_button title="Contact Me" btn_position="cz_btn_right cz_mobile_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" icon="fa fa-phone-square" id="cz_43201" sk_button="border-radius:30px 0 30px 0;padding:12px 35px 12px 35px;background-color:#ff0000;font-size:18px;color:#ffffff;" sk_hover="border-radius:0 30px 0 30px;box-shadow:0px 0px 15px rgba(0,0,0,0.24) ;color:#ffffff;background-color:#e20000;" sk_icon_hover="color:#ffffff;" cz_button=""][cz_gap height="130px" id="cz_57212" height_mobile="10px"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'header hero 2 columns fashion light full wide 62_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" css=".vc_custom_1504508958119{background-image: url('.$imgu.'img24.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/3" css=".vc_custom_1516266832470{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_hidden-sm vc_hidden-xs"][/vc_column][vc_column width="2/3" css=".vc_custom_1516266804725{padding-right: 80px !important;padding-left: 80px !important;}" offset="vc_col-xs-12"][cz_gap height="80px" id="cz_91424" height_mobile="20px"][cz_free_line position="tac" id="cz_39827" sk_line="height:30px;width:30px;background-color:#4b9585;transform:rotate(45deg);"][cz_free_line position="tac" id="cz_46032" sk_line="height:30px;width:30px;background-color:#4b9585;transform:rotate(45deg);"][cz_free_line position="tac" id="cz_34335" sk_line="height:30px;width:30px;background-color:#4b9585;transform:rotate(45deg);"][cz_gap height="80px" id="cz_41666" height_mobile="30px"][cz_title smart_fs="true" id="cz_71408"]<div style="text-align: center; line-height: 0.8;"><span style="font-size: 120px; font-family: Playfair Display;"><strong>BEAUTY OF STYLE</strong></span></div>[/cz_title][cz_gap height="40px" id="cz_81339" height_mobile="20px"][cz_button title="LOOKBOOK" btn_position="cz_btn_center" btn_effect="cz_btn_blur" link="url:%23|||" id="cz_13223" sk_button="padding:12px 30px 12px 30px;background-color:#4b9585;font-size:16px;color:#ffffff;" sk_hover="border-radius:100px;padding-left:40px;padding-right:40px;color:#ffffff;" sk_icon="color:rgba(255,255,255,0.3);" sk_icon_hover="color:#ffffff;"][cz_gap height="100px" id="cz_97714" height_mobile="30px"][/vc_column][/vc_row][cz_google_font font="Playfair Display"]',
					),
					array(
						'f' => 'header hero 2 columns vacation travel colorful light full wide 63_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" equal_height="yes" content_placement="middle" css=".vc_custom_1504474115389{background-image: url('.$imgu.'img5.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" css=".vc_custom_1516267009750{padding-right: 20px !important;padding-left: 80px !important;}" offset="vc_col-xs-12"][cz_gap height="60px" id="cz_21201"][cz_title id="cz_95311" sk_overall="border-radius:100px 0 100px 0;background-color:unset !important;background-image:linear-gradient(180deg,rgba(181,12,204,0.45),#9e03a0);padding-left:40px;padding-right:40px;"]<p style="text-align: left;"><span style="font-weight: 400; font-size: 24px; color: #ffffff;">V A C A T I O N</span></p>[/cz_title][cz_gap height="25px" id="cz_44020"][cz_gradient_title id="cz_38796"]<div style="line-height: 1;"><span style="font-size: 110px; font-family: Baloo;">Work Hard</span></div>[/cz_gradient_title][cz_gradient_title id="cz_56863"]<p style="text-align: left;"><span style="display: block; font-size: 24px; line-height: 1;"><span style="font-size: 30px;">A N D G O</span></span></p>[/cz_gradient_title][cz_gradient_title smart_fs="true" id="cz_99542"]<span style="font-size: 110px; font-family: Baloo; line-height: 1;">More Travel</span>[/cz_gradient_title][cz_gap height="10px" id="cz_94474"][cz_button title="BOOK NOW" btn_effect="cz_btn_absorber" link="url:%23|||" id="cz_94367" sk_button="border-radius:0 100px 0 100px;padding-left:40px;padding-right:40px;background-color:unset !important;background-image:linear-gradient(180deg,rgba(3,191,131,0.59),#017f6c);font-size:16px;color:#ffffff;" sk_hover="box-shadow:0px 0px 15px rgba(0,0,0,0.24) ;color:#ffffff;background-color:#81011e;" sk_icon="color:rgba(255,255,255,0.3);" sk_icon_hover="color:#ffffff;"][cz_gap height="60px" id="cz_88370"][/vc_column][vc_column width="1/2" css=".vc_custom_1504365231391{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column][/vc_row][cz_google_font font="Baloo"]',
					),
					array(
						'f' => 'header hero 2 columns beauty hair spa brown light full wide 64_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" equal_height="yes" content_placement="middle" css=".vc_custom_1504472836696{background-image: url('.$imgu.'img20.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="2/3" css=".vc_custom_1516267077693{padding-right: 50px !important;padding-left: 80px !important;}" offset="vc_col-xs-12"][cz_gap height="60px" id="cz_13309"][cz_title title_pos="cz_title_pos_left" id="cz_98434" sk_overall="border-radius:0 100px 100px 0;background-color:#c99062;padding-left:105px;margin-left:-100px;"]<span style="color: #ffffff;">25% OFF</span>[/cz_title][cz_gap height="40px" id="cz_66806"][cz_title smart_fs="true" id="cz_37143"]<div style="line-height: 1; letter-spacing: -2px; text-align: left;"><span style="font-size: 100px; font-weight: bold; display: block; color: #6b4221;">BEAUTY <span style="font-family: Playfair Display; color: #c99062; font-size: 110px;">&amp;</span></span></div><div style="line-height: 1; letter-spacing: -2px; text-align: left;"><span style="font-size: 100px; font-weight: bold; display: block; color: #6b4221;"> SKIN CARE</span></div>[/cz_title][cz_gap id="cz_41503" height_mobile="40px"][cz_button title="MAKE AN APPOINTMENT" icon_position="after" link="url:%23|||" id="cz_16220" sk_button="border-radius:100px;padding:12px 25px 12px 25px;margin-left:8px;background-color:#c99062;font-size:15px;color:#ffffff;" sk_hover="box-shadow:0px 0px 15px rgba(0,0,0,0.24) ;color:#ffffff;background-color:#6b4221;" sk_icon_hover="color:#ffffff;"][cz_gap height="60px" id="cz_39443" height_mobile="20px"][/vc_column][vc_column width="1/3" css=".vc_custom_1504365231391{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column][/vc_row][cz_google_font font="Playfair Display"]',
					),
					array(
						'f' => 'header hero 1 column animated gray green full wide 65_jpg',
						'c' =>'[vc_row full_width="stretch_row_content" full_height="yes" columns_placement="stretch" content_placement="middle" css=".vc_custom_1504695774683{background-image: url('.$imgu.'img51-2.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_class="tac"][vc_column offset="vc_col-xs-12"][cz_gap height="150px" id="cz_50893"][cz_title id="cz_70418"]<p style="text-align: center;"><span style="font-size: 30px; color: #ffffff; font-family: Quicksand; font-weight: bold;">We Are Xtra Group</span><span style="font-weight: bold; font-size: 20px; color: #525252;"></span></p>[/cz_title][cz_gap height="10px" id="cz_21339"][cz_animated_text words="Wonderful,Awesome,Fantastic" fx="letters_rotate-3" tag="div" id="cz_88683" sk_words="font-size:110px;color:#6ced23;font-family:Playfair Display;font-weight:700;" sk_before="font-size:60px;color:rgba(255,255,255,0.8);font-family:Quicksand;font-weight:700;letter-spacing:1px;" sk_after="font-size:60px;color:rgba(255,255,255,0.8);font-family:Quicksand;font-weight:700;letter-spacing:1px;" sk_words_mobile="font-size:48px;" sk_words_tablet="font-size:64px;" sk_before_tablet="font-size:40px;" sk_before_mobile="font-size:32px;" sk_after_tablet="font-size:40px;" sk_after_mobile="font-size:32px;"][cz_gap height="20px" id="cz_36104" height_mobile="50px"][cz_button title="Portfolio" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" btn_effect="cz_btn_zoom_in" link="url:%23|||" icon="fa fa-th" id="cz_64570" sk_button="border-radius:50px;border-bottom-style:solid;border-color:#ffffff;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:10px 35px 10px 35px;border-width:3px 3px 3px 3px;font-weight:700;font-family:Quicksand;background-color:rgba(255,255,255,0.01);font-size:18px;color:#ffffff;letter-spacing:2px;" sk_hover="color:#ffffff;background-color:rgba(255,255,255,0.01);" sk_icon_hover="color:#ffffff;"][cz_gap height="160px" id="cz_16413"][/vc_column][/vc_row][cz_google_font font="Quicksand"][cz_google_font font="Playfair Display"]',
					),
					array(
						'f' => 'header hero 1 column music dark full wide 66_jpg',
						'c' =>'[vc_row full_width="stretch_row_content" full_height="yes" css=".vc_custom_1504527288399{background-image: url('.$imgu.'img6.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column offset="vc_col-xs-12"][cz_gap height="300px" id="cz_75158" height_tablet="200px" height_mobile="100px"][cz_title smart_fs="true" text_center="true" id="cz_39057" sk_overall="padding:30px 0px 10px;border-style:solid;border-width:0px 50px 3px 0px;border-color:#eeee22;border-radius:100%;text-shadow:1px 1px 2px rgba(0,0,0,0.55);" sk_overall_tablet="border-style:none;" sk_overall_mobile="padding:0px;"]<div style="text-align: center; line-height: 1.1;"><span style="font-size: 100px; color: #ffffff; font-weight: bold;">DJ ORTAMA</span></div>[/cz_title][cz_gap height="70px" id="cz_80958" height_mobile="30px"][cz_button title="LISTEN on SPOTIFY" btn_position="cz_btn_center" link="url:%23|||" icon="fa fa-spotify" id="cz_85689" sk_button="border-bottom-style:solid;border-color:#eeee22;padding:10px 30px 10px 30px;border-bottom-width:4px;font-weight:700;background-color:rgba(0,0,0,0.3);font-size:17px;color:#ffffff;" sk_hover="color:#ffffff;background-color:rgba(0,0,0,0.5);" sk_icon_hover="color:#ffffff;" sk_button_tablet="font-size:15px;" sk_button_mobile="font-size:13px;"][cz_gap height="120px" id="cz_75532" height_mobile="20px"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'header hero 1 column green dark full wide 67_jpg',
						'c' =>'[vc_row full_width="stretch_row_content" parallax="content-moving" css=".vc_custom_1504527288399{background-image: url('.$imgu.'img53.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}][vc_column][cz_gap height="100px" id="cz_76831" height_mobile="60px"][cz_title id="cz_15773" sk_overall="padding-left:30px;padding-right:30px;"]<p style="text-align: center;"><span style="font-weight: bold; font-size: 20px; color: #ffffff;"><span style="font-weight: 600; font-size: 28px; font-family: Oswald;">W E A R E X T R A</span></span></p>[/cz_title][cz_title smart_fs="true" text_center="true" id="cz_18730" sk_overall="border-radius:15px;" sk_overall_mobile="margin-top:20px;margin-bottom:20px;"]<div style="text-align: center; line-height: 1.2;"><span style="font-size: 130px; color: #00ff00; font-weight: bold; font-family: Oswald;">CREATIVE AGENCY</span></div>[/cz_title][vc_row_inner][vc_column_inner width="1/3" offset="vc_hidden-sm vc_hidden-xs"][/vc_column_inner][vc_column_inner width="1/3"][vc_column_text]<p style="text-align: center;"><span style="color: #ffffff;">Lorem ipsum dolor sit amet, conse ctetur adip isicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.</span></p>[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" offset="vc_hidden-sm vc_hidden-xs"][/vc_column_inner][/vc_row_inner][cz_button title="View Portfolio" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_right" icon_position="after" link="url:%23|||" icon="fa fa-long-arrow-right" id="cz_26942" sk_button="border-radius:4px;padding:10px 30px 10px 30px;font-weight:400;background-color:#00ff00;font-size:17px;color:#000000;letter-spacing:2px;" sk_hover="color:#ffffff;background-color:rgba(0,0,0,0.6);" sk_icon_hover="color:#ffffff;" sk_button_tablet="font-size:15;" sk_button_mobile="font-size:13px;"][cz_gap height="140px" id="cz_88649" height_mobile="60px"][/vc_column][/vc_row][cz_google_font font="Oswald"]',
					),
					array(
						'f' => 'header hero 1 column thin dark full wide 68_jpg',
						'c' =>'[vc_row full_width="stretch_row_content" css=".vc_custom_1504531673484{background-image: url('.$imgu.'img23.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][cz_gap height="200px" id="cz_24615" height_tablet="50px" height_mobile="20px"][cz_title id="cz_34688" sk_overall="padding-left:30px;padding-right:30px;"]<p style="text-align: center; line-height: 1.2;"><span style="font-weight: bold; font-size: 20px; color: #ffffff;"><span style="font-weight: 300; font-size: 28px;">WE PROVIDE YOU</span></span></p>[/cz_title][cz_title smart_fs="true" id="cz_52530" sk_overall="margin-top:30px;margin-bottom:50px;border-radius:15px;" sk_overall_tablet="padding:0px;"]<p style="text-align: center; line-height: 1;"><span style="font-size: 110px; color: #ffffff; font-weight: 200;">BUSINESS SOLUTION</span></p>[/cz_title][cz_button title="GET A FREE QUOTE" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" btn_effect="cz_btn_absorber" link="url:%23|||" id="cz_29965" sk_button="border-radius:100px;border-bottom-style:solid;border-color:#ffffff;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:10px 30px 10px 30px;border-width:2px 2px 2px 2px;font-weight:400;background-color:rgba(255,255,255,0.01);font-size:16px;color:#ffffff;letter-spacing:2px;" sk_hover="color:#ffffff;background-color:rgba(255,255,255,0.12);" sk_icon_hover="color:#ffffff;" sk_button_tablet="font-size:14px;" sk_button_mobile="font-size:13px;"][cz_gap height="200px" id="cz_95593" height_tablet="100px" height_mobile="50px"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'header hero 2 columns construction repair renovation building dark full wide 69_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" css=".vc_custom_1504532015662{background-image: url('.$imgu.'img12.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" css=".vc_custom_1513670806711{padding-right: 50px !important;padding-left: 50px !important;background-color: rgba(0,0,0,0.6) !important;*background-color: rgb(0,0,0) !important;}" offset="vc_col-xs-12"][cz_gap height="60px" id="cz_23452" height_tablet="30px" height_mobile="15px"][cz_title id="cz_35260"]<p style="text-align: center;"><span style="font-size: 24px; color: #ffffff;"><span style="font-weight: bold;">WE CAN FIX IT</span></span></p>[/cz_title][cz_gap height="30px" id="cz_28506"][cz_title smart_fs="true" id="cz_77857"]<div style="line-height: 1; letter-spacing: -2px; text-align: center;"><span style="font-size: 90px; font-weight: bold; display: block; color: #ffffff;">Repair</span></div><div style="line-height: 1; letter-spacing: -2px; text-align: center; margin-top: 20px;"><span style="font-size: 90px; font-weight: 200; color: #ffff00; font-family: Playfair Display;">&amp;</span></div><div style="line-height: 1; letter-spacing: -2px; text-align: center;"><span style="font-size: 90px; font-weight: 200; display: block; color: #ffffff;"><span style="font-weight: bold;">Renovation</span></span></div>[/cz_title][cz_gap height="60px" id="cz_91370"][cz_button title="GET FREE QUOTE" btn_position="cz_btn_center" text_effect="cz_btn_show_hidden_icon" icon_position="after" link="url:%23|||" icon="fa fa-long-arrow-right" id="cz_94364" sk_button="font-size:16px;color:#ffffff;background-color:rgba(225,97,11,0.01);padding:10px 35px;border-style:solid;border-width:3px;border-color:#ffffff;border-radius:5px;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;" sk_button_tablet="font-size:14px;" sk_button_mobile="font-size:13px;"][cz_gap height="80px" id="cz_18743" height_tablet="40px" height_mobile="20px"][/vc_column][vc_column width="1/2" css=".vc_custom_1516269432858{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_hidden-sm vc_col-xs-12 vc_hidden-xs"][cz_gap height="100px" id="cz_93751"][/vc_column][/vc_row][cz_google_font font="Playfair Display"]',
					),
					array(
						'f' => 'header hero 1 column countdown timer music dark full wide 70_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" equal_height="yes" css=".vc_custom_1504539998828{background-image: url('.$imgu.'img2.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column css=".vc_custom_1504128561258{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][cz_gap height="30px" id="cz_97322"][cz_gap height="70px" id="cz_98604"][cz_title shape="text" smart_fs="true" shape_text="MUSIC FESTIVAL" css_transform="-15deg" id="cz_48261" sk_shape="color:rgba(0,0,0,0.16);font-family:Six Caps;font-size:180px;letter-spacing:30px;top:100px;" sk_overall="margin-top:40px;margin-bottom:50px;" sk_overall_mobile="margin-top:0px;margin-bottom:30px;"]<div style="text-align: center; line-height: 1.1;"><span style="color: #ffffff; font-size: 86px; font-family: Yesteryear;"><span style="font-size: 110px;">Rock Metal</span></span></div>[/cz_title][cz_gap height="70px" id="cz_49591"][cz_countdown type="loop" loop="17120" size="cz_countdown_m" id="cz_63127" sk_cols="border-radius:3px;background-color:rgba(0,0,0,0.49);padding:20px 12px 20px 12px;margin-right:10px;width:94px;" sk_nums="color:#ffffff;" sk_title="font-weight:400;color:rgba(255,255,255,0.3);font-size:11px;" sk_cols_tablet="margin-bottom:10px;"][cz_gap height="80px" id="cz_99903" height_mobile="50px"][cz_button title="Buy Ticket" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" btn_effect="cz_btn_move_up" link="url:%23|||" icon="fa fa-ticket" id="cz_17396" sk_button="border-radius:5px;padding:10px 35px 10px 35px;margin-left:18px;background-color:#ffffff;font-size:18px;color:#8224e3;" sk_hover="color:#ffffff;background-color:rgba(0,0,0,0.49);"][cz_gap height="120px" id="cz_48345" height_mobile="40px"][/vc_column][/vc_row][cz_google_font font="Six Caps"][cz_google_font font="Yesteryear"]',
					),
					array(
						'f' => 'header hero 2 columns minimal white purple full wide 71_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" equal_height="yes" content_placement="middle" css=".vc_custom_1504521633270{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" offset="vc_col-xs-12"][cz_gap height="40px" id="cz_20196"][cz_title smart_fs="true" text_center="true" id="cz_19937"]<div style="line-height: 1; letter-spacing: -2px; text-align: right;"><span style="font-size: 100px; font-weight: bold; display: block; font-family: Playfair Display; color: #721970;">FURNITURE </span></div><div style="line-height: 1; letter-spacing: -2px; text-align: right;"><span style="font-size: 100px; font-weight: bold; display: block; font-family: Playfair Display; color: #d357d1;"><span style="font-size: 110px;">&amp;</span></span></div><div style="line-height: 1; letter-spacing: -2px; text-align: right;"><span style="font-size: 100px; font-weight: bold; display: block; color: #721970;"><span style="font-family: Playfair Display;">INTERIOR</span></span></div>[/cz_title][cz_gap height="100px" id="cz_21228" height_mobile="30px"][/vc_column][vc_column width="1/2" css=".vc_custom_1504552826276{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][cz_image image="'.$imgu.'img41.jpg" id="cz_62779" sk_css="position:relative;float:right;"][/vc_column][/vc_row][cz_google_font font="Playfair Display"]',
					),
					array(
						'f' => 'header hero 2 columns minimal product gradient buy full wide 72_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle"][vc_column width="1/2" css=".vc_custom_1504521659812{padding-right: 50px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][cz_image image="'.$imgu.'img26.jpg" id="cz_28696" sk_css="position:relative;display: table;margin:0 auto;"][/vc_column][vc_column width="1/2" css=".vc_custom_1516269606415{padding-right: 50px !important;padding-left: 10px !important;background-color: #ffffff !important;}" offset="vc_col-xs-12"][cz_gap height="90px" id="cz_73145" height_tablet="20px" height_mobile="20px"][cz_title text_center="true" id="cz_60769"]<p style="text-align: left;"><span style="font-size: 24px;"><span style="font-size: 19px; font-weight: 500;">BEST SELLER</span></span><span style="font-size: 24px; color: #254143;"></span></p> [/cz_title][cz_gradient_title smart_fs="true" text_center="true" id="cz_56171" sk_css="background-color:unset !important;background-image:linear-gradient(0deg,#1e73be,#8224e3);"]<span style="font-family: Playfair Display; font-size: 6em;"><span style="font-family: Alex Brush;"><sup>$</sup></span><span style="font-weight: bold;">399.00</span></span>[/cz_gradient_title][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][cz_gap height="30px" id="cz_80542"][cz_button title="ADD TO CART" btn_position="cz_btn_left cz_mobile_btn_center" text_effect="cz_btn_txt_move_up" btn_effect="cz_btn_zoom_in" link="url:%23|||" icon="fa fa-cart-plus" id="cz_49764" sk_button="border-radius:50px;padding:12px 30px 12px 30px;background-color:unset !important;background-image:linear-gradient(135deg,#8224e3,#1e73be);font-size:16px;color:#ffffff;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;" cz_button=""][cz_gap height="120px" id="cz_54679" height_tablet="20px" height_mobile="20px"][/vc_column][/vc_row][cz_google_font font="Alex Brush"][cz_google_font font="Playfair Display"]',
					),
					array(
						'f' => 'header hero 2 columns painting decoration light full wide 73_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle" css=".vc_custom_1504541343042{background-image: url('.$imgu.'img46.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" css=".vc_custom_1513671224590{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-xs-12"][cz_gap height="650px" id="cz_13100" height_mobile="50px" height_tablet="300px"][/vc_column][vc_column width="1/2" offset="vc_col-xs-12"][cz_gap height="100px" id="cz_91321"][cz_title smart_fs="true" text_center="true" id="cz_21849" sk_overall="margin-right:80px;" sk_overall_tablet="margin-right:30px;" sk_overall_mobile="margin-right:20px;"]<div style="line-height: 1; letter-spacing: -2px; text-align: right;"><span style="font-size: 90px; font-weight: bold; display: block; color: #273284; margin-bottom: 15px;">Painting </span></div><div style="line-height: 1; letter-spacing: -2px; text-align: right;"><span style="font-size: 98px; font-weight: bold; display: block; color: #00ccff; font-family: Playfair Display;">&amp; </span></div><div style="line-height: 1; letter-spacing: -2px; text-align: right;"><span style="font-size: 90px; font-weight: bold; display: block; color: #273284;">Decoration</span></div>[/cz_title][cz_gap height="60px" id="cz_37132"][cz_button title="Contact Me" btn_position="cz_btn_right cz_mobile_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" icon="fa fa-phone-square" id="cz_46760" sk_button="font-size:18px;color:#ffffff;background-color:#ff0000;padding:12px 35px;margin-right:80px;border-radius:50px;" sk_hover="border-radius:0 30px 0 30px;box-shadow:0px 0px 15px rgba(0,0,0,0.24) ;color:#ffffff;background-color:#e20000;" sk_icon_hover="color:#ffffff;" sk_button_tablet="font-size:16px;margin-right:30px;" sk_button_mobile="font-size:14px;margin-right:20px;" cz_button=""][cz_gap height="200px" id="cz_17980" height_mobile="50px"][/vc_column][/vc_row][cz_google_font font="Playfair Display"]',
					),
					array(
						'f' => 'header hero 1 column light white full wide 74_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" css=".vc_custom_1504869075811{background-image: url('.$imgu.'img62.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column css=".vc_custom_1513694175462{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-xs-12"][cz_gap height="20px" height_mobile="50px" id="cz_91424"][cz_button btn_position="cz_btn_center" icon="fa fa-play-circle-o" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DAvWjf_RUy4c|||" class="lightbox" id="cz_60748" sk_button="border-radius:100px;background-color:#ffffff;box-shadow:-1px 1px rgba(0,0,0,0.4) ;" sk_icon="padding:10px 3px 10px 3px;margin:0px 0px 0px 0px;font-size:34px;color:rgba(0,0,0,0.72);"][cz_title smart_fs="true" id="cz_45824" sk_overall="padding-right:60px;padding-left:60px;margin-top:30px;margin-bottom:60px;text-shadow:1px 1px 1px rgba(0,0,0,0.41);" sk_overall_tablet="padding:0px;"]<p style="text-align: center; line-height: 1.2;"><span style="font-family: Montserrat; font-size: 70px; color: #ffffff;"><span style="font-weight: 500;">Design</span> <span style="font-family: Playfair Display;">&amp;</span> <span style="font-weight: 500;">Creativity</span></span></p>[/cz_title][vc_row_inner][vc_column_inner width="1/3" offset="vc_hidden-sm vc_hidden-xs"][/vc_column_inner][vc_column_inner width="1/3"][cz_title id="cz_58743" sk_overall="text-shadow:-1px 1px rgba(0,0,0,0.55) ;"]<div style="line-height: 1.4; text-align: center;"><span style="font-weight: 400;"><span style="color: #ffffff;">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip.</span></span></div>[/cz_title][/vc_column_inner][vc_column_inner width="1/3"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][cz_google_font font="Montserrat"][cz_google_font font="Playfair Display"]',
					),
					array(
						'f' => 'header hero 1 column beauty gradient light full wide 75_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" css=".vc_custom_1504541863877{background-image: url('.$imgu.'img9.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column css=".vc_custom_1516269836255{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-xs-12"][cz_gradient_title smart_fs="true" text_center="true" id="cz_21147" sk_css="background-color:transparent;background-image:linear-gradient(0deg,#8224e3,#1e73be);"]<p style="text-align: center; line-height: 1;"><span style="font-family: Playball; letter-spacing: -4px; font-weight: bold; font-size: 150px;">Beauty Salon</span></p>[/cz_gradient_title][cz_button title="Make an Appointment" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" btn_effect="cz_btn_zoom_in" icon="fa fa-clock-o" link="url:%23|||" id="cz_35936" sk_button="background-color:transparent;background-image:linear-gradient(45deg,#1a34b2,#751599);padding-right:25px;padding-left:25px;margin-top:50px;border-radius:50px;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;" sk_button_mobile="font-size:14px;" cz_button=""][/vc_column][/vc_row][cz_google_font font="Playball"]',
					),
					array(
						'f' => 'header hero 1 column gradient vacation travel light full wide 76_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="top" css=".vc_custom_1504600494546{background-image: url('.$imgu.'img48-2.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column offset="vc_col-xs-12"][cz_gap height="15px" id="cz_88344"][cz_gap height="80px" id="cz_48110"][cz_gradient_title smart_fs="true" text_center="true" id="cz_38233" sk_css="background-color:unset !important;background-image:linear-gradient(0deg,#7124e5,#8224e3);"]<p style="text-align: center; line-height: 1;"><span style="font-family: Baloo; line-height: 1.4;"><span style="font-family: Lobster; font-weight: 400; font-size: 139px;">Dreamy Vacation</span></span></p>[/cz_gradient_title][cz_gap height="30px" id="cz_33960"][cz_button title="BOOK NOW" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_92102" sk_button="border-radius:100px;padding-left:40px;padding-right:40px;background-color:unset !important;background-image:linear-gradient(0deg,#8224e3,#a821d1);font-size:16px;color:#ffffff;" sk_hover="box-shadow:0px 0px 15px rgba(0,0,0,0.24) ;color:#ffffff;" sk_icon="color:rgba(255,255,255,0.3);" sk_icon_hover="color:#ffffff;"][/vc_column][/vc_row][cz_google_font font="Baloo"][cz_google_font font="Lobster"]',
					),
					array(
						'f' => 'header hero 2 columns app download solid black logo full wide 77_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="top" css=".vc_custom_1504694780077{background-image: url('.$imgu.'img57.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="2/3" css=".vc_custom_1504383314498{padding-right: 50px !important;padding-left: 80px !important;}"][cz_gap height="70px" id="cz_58752" height_tablet="30px" height_mobile="20px"][cz_image image="'.$imgu.'logo.png" id="cz_78846"][cz_gap height="100px" id="cz_23908" height_tablet="50px" height_mobile="30px"][cz_title id="cz_68022"]<span style="font-weight: bold;">IN TOP 10</span>[/cz_title][cz_title smart_fs="true" id="cz_36847" sk_overall="margin-bottom:50px;"]<span style="line-height: 1.2; font-size: 56px; font-weight: bold; color: #000000;"><span style="font-size: 64px;">FITNESS</span> <span style="font-size: 64px;">APP</span></span>[/cz_title][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit Ut elit tellus, luctus nec ullamcorper mattis, pulvinarda pibus leo.[/vc_column_text][cz_gap height="30px" id="cz_22915" height_mobile="10px"][cz_button title="Download Now" link="url:%23|||" icon="fa fa-cloud-download" id="cz_45226" sk_button="padding:12px 25px 12px 25px;background-color:#000000;font-size:15px;color:#ffffff;" sk_hover="background-color:unset !important;background-image:linear-gradient(45deg,#1e73be,#8224e3);color:#ffffff;" sk_icon_hover="color:#ffffff;"][cz_gap height="60px" id="cz_47652" height_mobile="20px"][/vc_column][vc_column width="1/3" css=".vc_custom_1516270775836{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_hidden-sm vc_col-xs-12 vc_hidden-xs"][cz_social_icons position="tar" fx="cz_social_fx_0" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22title%22%3A%22Linkedin%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-cloud-download%22%2C%22title%22%3A%22Download%22%2C%22link%22%3A%22%23%22%7D%5D" id="cz_97415" sk_icons="margin-left:10px;color:#f0f0f0;background-color:#000000;font-size:14px;" sk_con="margin-top:50px;margin-right:60px;" sk_con_tablet="margin-top:30px;margin-right:30px;" sk_con_mobile="margin-top:20px;margin-right:20px;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'header hero 1 column creative gradient full wide 78_jpg',
						'c' =>'[vc_row full_width="stretch_row_content" full_height="yes" columns_placement="stretch" content_placement="middle" css=".vc_custom_1516292125558{background-image: url('.$imgu.'img52.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column offset="vc_col-xs-12"][cz_content_box type="1" id="cz_82455" sk_overall="background-color:rgba(255,255,255,0.6);margin:80px;border-radius:30px;" sk_overall_tablet="margin:30px;" sk_overall_mobile="padding:20px;margin:30px 10px;"][cz_gap height="150px" id="cz_40294" height_tablet="50px" height_mobile="20px"][cz_gradient_title smart_fs="true" bg_mode="image" id="cz_74939" sk_css="background-image:url('.$imgu.'img52.jpg);"]<div style="line-height: 1; letter-spacing: -2px; text-align: center;"><span style="font-size: 90px; font-weight: 300; display: block;"><span style="font-weight: 200;">If you can</span> <span style="font-weight: bold;">imagine</span> <span style="font-weight: 200;">it,</span></span></div><div style="line-height: 1; letter-spacing: -2px; text-align: center;"><span style="font-size: 90px; font-weight: 300; display: block;"><span style="font-weight: 200;">we can</span> <span style="font-weight: bold;">create </span><span style="font-weight: 200;">it!</span></span></div>[/cz_gradient_title][cz_gap id="cz_92431"][cz_button title="Learn More ..." btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_45219" sk_button="border-radius:10px;background-image:url('.$imgu.'img52.jpg);padding:10px 45px 10px 45px;font-weight:400;font-size:18px;color:#ffffff;" sk_hover="border-radius:10px;color:#ffffff;box-shadow:0px 3px 15px rgba(0,0,0,0.5) ;" sk_icon_hover="color:#ffffff;"][cz_gap height="150px" id="cz_46210" height_tablet="50px" height_mobile="10px"][/cz_content_box][/vc_column][/vc_row]',
					),
					array(
						'f' => 'header hero 1 column dark full wide 79_jpg',
						'c' =>'[vc_row full_width="stretch_row_content" full_height="yes" columns_placement="stretch" content_placement="middle" parallax="content-moving" css=".vc_custom_1504527288719{background-image: url('.$imgu.'img63.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}][vc_column offset="vc_col-xs-12"][cz_gap height="120px" id="cz_50639" height_mobile="60px"][cz_title id="cz_77669" sk_overall="padding-left:30px;padding-right:30px;"]<p style="text-align: center;"><span style="font-weight: bold; font-size: 20px; color: #ffffff;"><span style="font-weight: 600; font-size: 28px; color: #ff9800;">X T R A B I K E</span></span></p>[/cz_title][cz_gap id="cz_18363"][cz_title smart_fs="true" id="cz_13740" sk_overall="padding:50px 80px;border-style:solid;border-width:5px;border-color:#ff9800;border-radius:150px;" sk_overall_mobile="padding:0px 10px;border-style:none;"]<div style="text-align: center; line-height: 1.1;"><span style="font-size: 100px; color: #ff9800; font-weight: bold;">Ride a Bike</span></div>[/cz_title][cz_gap height="70px" id="cz_95410"][cz_button title="Play Video" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" icon="fa fa-play-circle" id="cz_67833" sk_button="border-radius:100px;border-bottom-style:solid;border-color:#ff9800;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:10px 30px 10px 30px;border-width:4px 4px 4px 4px;font-weight:700;background-color:#ff9800;font-size:17px;color:#000000;" sk_hover="border-bottom-style:solid;border-color:#ff9800;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:4px 4px 4px 4px;color:#ff9800;background-color:rgba(255,255,255,0);" sk_icon="color:#000000;" sk_icon_hover="color:#ff9800;"][cz_gap height="120px" id="cz_83696" height_mobile="60px"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'header hero 2 columns gray minimal full wide 80_jpg',
						'c' =>'[vc_row full_width="stretch_row_content" full_height="yes" columns_placement="stretch" content_placement="middle" parallax="content-moving" css=".vc_custom_1507947288399{background-image: url('.$imgu.'img67.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}][vc_column offset="vc_col-xs-12"][cz_title smart_fs="true" text_center="true" id="cz_68349" sk_overall="padding:5px 50px;border-radius:15px;" sk_overall_mobile="padding:0px;"]<div style="text-align: left; line-height: 1.1;"><span style="font-size: 100px; font-weight: bold; line-height: 1.5; font-family: Raleway;"><span style="font-weight: 100;">WE ARE</span> <span style="font-weight: 900;">XTRA</span></span></div><p style="text-align: left;"><span style="line-height: 1.5;"><span style="font-weight: 400; font-size: 20px; font-family: Raleway;">Branding | Design | Web Development</span><span style="font-weight: bold; font-size: 20px; color: #ffffff;"></span></span></p>[/cz_title][cz_gap height="30px" id="cz_32871"][cz_button title="View Portfolio" btn_position="cz_btn_left cz_mobile_btn_center" text_effect="cz_btn_txt_move_up" btn_effect="cz_btn_absorber" link="url:%23|||" icon="fa fa-search-plus" id="cz_58437" sk_button="font-size:13px;color:#333333;font-weight:400;letter-spacing:1px;background-color:rgba(255,255,255,0.01);padding:6px 20px;margin-left:50px;border-style:solid;border-width:2px;border-color:#333333;border-radius:4px;" sk_hover="color:#333333;background-color:rgba(255,255,255,0);" sk_icon_hover="color:#333333;" sk_button_mobile="margin-left:0px;"][cz_button title="Contact Us" btn_position="cz_btn_left cz_mobile_btn_center" text_effect="cz_btn_txt_move_up" btn_effect="cz_btn_absorber" link="url:%23|||" icon="fa fa-phone" id="cz_70267" sk_button="font-size:13px;color:#333333;font-weight:400;letter-spacing:1px;background-color:rgba(255,255,255,0.01);padding:6px 20px;margin-left:25px;border-style:solid;border-width:2px;border-color:#333333;border-radius:4px;" sk_hover="color:#333333;background-color:rgba(255,255,255,0);" sk_icon_hover="color:#333333;" sk_button_mobile="margin-left:0px;"][cz_gap id="cz_94017"][/vc_column][/vc_row][cz_google_font font="Raleway"]',
					),
					array(
						'f' => 'header hero 1 column creative photo brown light full wide 81_jpg',
						'c' =>'[vc_row full_width="stretch_row_content" full_height="yes" columns_placement="stretch" content_placement="middle" css=".vc_custom_1504881571203{background-image: url('.$imgu.'img61.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column offset="vc_col-xs-12"][cz_gap height="30px" id="cz_24400"][cz_gap height="60px" id="cz_90591"][cz_gap height="200px" id="cz_93232" height_tablet="100px" height_mobile="50px"][cz_title smart_fs="true" text_center="true" id="cz_76863" sk_overall="background-color:#935d28;padding:5px 30px 5px 30px;margin-bottom:0px;"]<p style="text-align: center;"><span style="font-weight: 300; font-size: 18px; color: #ffffff;"><span style="font-size: 28px;">XTRA PHOTOGRAPHY</span></span><span style="font-weight: bold; font-size: 20px; color: #ffffff;"></span></p>[/cz_title][cz_title smart_fs="true" text_center="true" id="cz_13328" sk_overall="background-color:#ffffff;padding:30px 60px;box-shadow:0px 10px #935d28 ;" sk_overall_mobile="padding:0px;"]<div style="text-align: center; line-height: 1.1;"><span style="font-size: 100px; color: #935d28; font-weight: bold;">CREATIVE PHOTOS</span></div>[/cz_title][cz_button title="PORTFOLIO" btn_position="cz_btn_center" text_effect="cz_btn_show_hidden_icon" icon_position="after" link="url:%23|||" icon="fa fa-long-arrow-right" id="cz_81300" sk_button="background-color:#935d28;padding:10px 35px 10px 35px;font-weight:400;font-size:16px;color:#ffffff;letter-spacing:3px;"][cz_gap height="130px" id="cz_82076"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'header hero 2 columns dark yellow full wide 82_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" css=".vc_custom_1504882687611{background-image: url('.$imgu.'img68.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" css=".vc_custom_1516292945113{padding-right: 50px !important;padding-left: 50px !important;}" offset="vc_col-xs-12"][cz_gap height="60px" id="cz_66705" height_mobile="10px"][cz_title id="cz_52752"]<p style="text-align: center;"><span style="font-size: 24px; color: #cccccc;">X T R A</span></p>[/cz_title][cz_gap height="30px" id="cz_66762"][cz_gradient_title smart_fs="true" text_center="true" id="cz_41805" sk_css="background-color:transparent;background-image:linear-gradient(0deg,#eeee22,rgba(238,238,34,0.5));" sk_css_mobile="padding:0px;"]<div style="line-height: 1; letter-spacing: 28px; text-align: center; margin-left: 10px;"><span style="font-size: 90px; font-weight: 300; display: block; color: #ffffff;">THINK</span></div><div style="line-height: 1; letter-spacing: 16px; text-align: center;"><span style="font-size: 90px; font-weight: bold; display: block; color: #ffffff;">SMART</span></div>[/cz_gradient_title][cz_gap height="60px" id="cz_76139"][cz_button title="LEARN MORE" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_right" btn_effect="cz_btn_shine" icon_position="after" link="url:%23|||" icon="fa fa-long-arrow-right" id="cz_39772" sk_button="border-radius:5px;border-bottom-style:solid;border-color:#999999;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:10px 30px 10px 30px;border-width:2px 2px 2px 2px;background-color:rgba(225,97,11,0.01);font-size:14px;color:#ffffff;" sk_hover="color:#eeee22;" sk_icon="color:#eeee22;" sk_icon_hover="color:#ffffff;"][cz_gap height="80px" id="cz_50250" height_mobile="20px"][/vc_column][vc_column width="1/2" css=".vc_custom_1516293028750{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_hidden-sm vc_col-xs-12 vc_hidden-xs"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'header hero 2 columns countdown timer music full wide 83_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" css=".vc_custom_1505066453309{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" css=".vc_custom_1516293049650{background-color: #00015f !important;}" offset="vc_col-xs-12"][cz_title shape="text" smart_fs="true" shape_text="MUSIC CONCERT" css_transform="-22deg" id="cz_77133" sk_shape="color:rgba(124,168,255,0.28);font-family:Six Caps;font-size:130px;letter-spacing:7px;top:180px;"]<p style="text-align: center;"><span style="font-family: Playball; font-size: 150px; color: #ffffff;">Jazz</span></p>[/cz_title][cz_gap height="30px" id="cz_69311"][cz_button title="Buy Ticket" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" icon="fa fa-ticket" id="cz_14167" sk_button="border-radius:5px;padding:10px 20px 10px 10px;margin-left:18px;background-color:#ffffff;font-size:18px;color:#00015f;" sk_hover="background-color:#62e2e1;" sk_icon="border-radius:3px;background-color:#00015f;padding:10px 10px 10px 10px;margin-right:10px;color:#62e2e1;" sk_icon_hover="color:#ffffff;"][cz_gap id="cz_14491"][/vc_column][vc_column width="1/2" css=".vc_custom_1516293058300{padding-left: 100px !important;background-image: url('.$imgu.'img22.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-xs-12"][cz_countdown type="loop" loop="18120" pos="tal cz_countdown_left_v" id="cz_85555" sk_cols="border-radius:5px;background-color:#00015f;padding:10px 12px 10px 12px;margin-bottom:10px;width:66px;" sk_nums="color:#ffffff;" sk_title="font-weight:400;color:rgba(255,255,255,0.38);font-size:11px;" sk_overall_mobile="margin-left:calc(50% - 40px);"][/vc_column][/vc_row][cz_google_font font="Playball"][cz_google_font font="Six Caps"]',
					),
					array(
						'f' => 'header hero 2 columns about minimal light full wide 84_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle"][vc_column width="1/2" css=".vc_custom_1516293258824{padding-right: 50px !important;padding-left: 100px !important;background-color: #ffffff !important;}" offset="vc_col-xs-12"][cz_gap height="120px" id="cz_46061" height_mobile="30px"][cz_title id="cz_69418"]<p style="text-align: center;"><span style="color: #254143;"><span style="font-size: 19px; font-weight: bold; color: #000000; font-family: Poiret One;">Hi, I am</span></span><span style="font-size: 24px; color: #254143;"></span></p>[/cz_title][cz_gap height="30px" id="cz_58976"][cz_title shape="text" smart_fs="true" id="cz_24857" sk_shape="color:rgba(0,0,0,0.28);font-family:Impact;font-size:70px;letter-spacing:5px;" sk_overall="padding-top:40px;padding-bottom:40px;" sk_overall_mobile="padding:0px;"]<div style="text-align: center; line-height: 1.1;"><span style="color: #ffffff; font-size: 86px; font-family: Arizonia;"><span style="font-size: 80px; color: #000000; font-family: Poiret One; font-weight: 400;">Sarah Connero</span></span></div>[/cz_title][cz_gap height="60px" id="cz_19623"][cz_button title="PORTFOLIO" btn_position="cz_btn_center" text_effect="cz_btn_show_hidden_icon" link="url:%23|||" alt_title="VIEW GALLERY" icon="fa fa-th" id="cz_98389" sk_button="padding:12px 35px 12px 35px;font-weight:400;background-color:#9ca6a5;box-shadow:-15px 15px #000000 ;font-size:16px;color:#000000;" sk_hover="color:#000000;" sk_icon_hover="color:#000000;"][cz_gap height="120px" id="cz_38428" height_mobile="50px"][/vc_column][vc_column width="1/2" css=".vc_custom_1504521659812{padding-right: 50px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][cz_image image="'.$imgu.'img73.jpg" id="cz_45391" sk_css="position:relative;display: table;margin:0 auto;width:450px;box-shadow:-25px 25px #000000 ;"][/vc_column][/vc_row][cz_google_font font="Poiret One"][cz_google_font font="Arizonia"]',
					),
					array(
						'f' => 'header hero 2 columns fashion blue full wide 85_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" css=".vc_custom_1505037394346{background-image: url('.$imgu.'img72.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" css=".vc_custom_1516293722649{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_hidden-sm vc_col-xs-12 vc_hidden-xs"][cz_gap height="650px" id="cz_72479"][/vc_column][vc_column width="1/2" css=".vc_custom_1516293320755{padding-right: 0px !important;padding-left: 0px !important;background-color: #0d47a1 !important;}" offset="vc_col-xs-12"][cz_title text_center="true" class="z9" id="cz_55749" sk_overall="background-color:#1976d2;margin-right:5px;margin-bottom:-25px;margin-left:-20px;" sk_overall_mobile="margin:0px 0px -35px;"]<p style="text-align: left;"><span style="font-weight: 400; font-size: 20px; color: #ffffff;">2018</span></p>[/cz_title][cz_title smart_fs="true" text_center="true" id="cz_85303" sk_overall="background-color:#42a5f5;padding-top:50px;padding-bottom:50px;padding-left:80px;margin-left:-100px;" sk_overall_mobile="padding-bottom:60px;margin-left:-90px;"]<div style="line-height: 1; letter-spacing: 10px; text-align: left;"><span style="font-size: 90px; font-weight: bold; display: block; color: #273284;"><span style="font-family: Playfair Display; font-size: 110px; color: #ffffff;">WINTER STYLE</span></span></div>[/cz_title][cz_button title="View Collection" btn_position="cz_btn_right cz_mobile_btn_center" text_effect="cz_btn_show_hidden_icon" icon_position="after" icon="fa fa-angle-double-right" link="url:%23|||" id="cz_85697" class="cz_rel z1" sk_button="color:#ffffff;background-color:#002969;margin-top:-30px;margin-right:100px;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;" sk_button_mobile="margin-right:0px;"][/vc_column][/vc_row][cz_google_font font="Playfair Display"]',
					),
					array(
						'f' => 'header hero 2 columns fashion red full wide 86_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" css=".vc_custom_1505171952451{background-image: url('.$imgu.'img74.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" css=".vc_custom_1516293741329{padding-right: 0px !important;padding-left: 0px !important;background-color: #ffffff !important;}" offset="vc_col-xs-12"][cz_title class="z9" id="cz_98982" sk_overall="background-color:#000000;padding-bottom:4px;padding-top:4px;margin-left:80px;margin-bottom:-35px;margin-right:5px;"]<p style="text-align: left;"><span style="font-weight: 400; font-size: 20px; color: #ffffff;">2018</span></p>[/cz_title][cz_title smart_fs="true" text_center="true" id="cz_25249" sk_overall="background-color:#cc0000;padding:50px 40px 50px 50px;margin-top:-15px;margin-right:-100px;" sk_overall_mobile="margin-right:-90px;margin-left:-90px;"]<div style="line-height: 1; letter-spacing: 10px; text-align: right;"><span style="font-size: 90px; font-weight: bold; display: block; color: #273284;"><span style="font-family: Playfair Display; font-size: 100px; color: #ffffff;">SUNGLASSES</span></span></div>[/cz_title][cz_button title="View Collection" btn_position="cz_btn_right cz_mobile_btn_center" text_effect="cz_btn_txt_move_right" icon_position="after" icon="fa fa-chevron-right" link="url:%23|||" id="cz_51050" sk_button="font-size:15px;color:#ffffff;letter-spacing:2px;background-color:#000000;margin-top:-1px;margin-right:-100px;" sk_hover="color:#ffffff;" sk_icon="margin-left:10px;" sk_icon_hover="color:#ffffff;" sk_button_mobile="margin-right:0px;"][/vc_column][vc_column width="1/2" css=".vc_custom_1516293764158{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_hidden-sm vc_col-xs-12 vc_hidden-xs"][cz_gap height="650px" id="cz_41347"][/vc_column][/vc_row][cz_google_font font="Playfair Display"]',
					),
					array(
						'f' => 'header hero 2 columns minimal full wide 87_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" css=".vc_custom_1505037538309{background-image: url('.$imgu.'img58.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" css=".vc_custom_1516293935023{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_hidden-sm vc_col-xs-12 vc_hidden-xs"][/vc_column][vc_column width="1/2" offset="vc_col-xs-12"][cz_title smart_fs="true" text_center="true" id="cz_35248" sk_overall_mobile="padding:0px;"]<p style="text-align: center; letter-spacing: 8px;"><span style="font-family: Dosis; font-size: 100px;">MINIMALISM</span></p>[/cz_title][cz_gap height="10px" id="cz_62866"][cz_gap height="20px" id="cz_79018"][cz_button title="PORTFOLIO" btn_position="cz_btn_center" text_effect="cz_btn_show_hidden_icon" icon_position="after" link="url:%23|||" icon="fa fa-long-arrow-right" id="cz_62930" sk_button="border-radius:4px;padding:12px 30px 12px 30px;font-weight:400;background-color:#333333;font-size:13px;color:#eeeeee;font-family:Quicksand;letter-spacing:2px;" sk_hover="color:#ffffff;background-color:#333333;" sk_icon="color:rgba(255,255,255,0.3);" sk_icon_hover="color:#ffffff;"][cz_gap height="30px" id="cz_31018"][/vc_column][/vc_row][cz_google_font font="Dosis"][cz_google_font font="Quicksand"]',
					),
					array(
						'f' => 'header hero 2 columns pink beauty cosmetic light full wide 88_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" css=".vc_custom_1505047499755{background-image: url('.$imgu.'img66.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="2/3" css=".vc_custom_1516294087527{padding-right: 20px !important;padding-left: 100px !important;}" offset="vc_col-xs-12"][cz_title smart_fs="true" text_center="true" id="cz_24070"]<div style="line-height: 1; letter-spacing: -2px; text-align: left;"><span style="font-size: 130px; font-weight: bold; color: #ff44a2; font-family: Playfair Display;">BEAUTY</span><span style="color: #ad1457; font-size: 110px; font-family: Playfair Display; font-weight: bold;">&amp;</span><span style="font-size: 100px; font-weight: bold; display: block; color: #ff44a2; font-family: Playfair Display;">COSMETICS</span></div>[/cz_title][cz_gap height="20px" id="cz_91574"][cz_gap height="30px" id="cz_42298"][cz_button title="SHOP ONLINE" btn_position="cz_btn_left cz_mobile_btn_center" btn_effect="cz_btn_fill_right" link="url:%23|||" icon="fa fa-shopping-bag" id="cz_75058" sk_button="border-radius:100px;border-bottom-style:solid;border-color:#c2185b;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:12px 25px 12px 25px;border-width:2px 2px 2px 2px;margin-left:8px;background-color:rgba(255,255,255,0);font-size:15px;color:#c2185b;" sk_hover="color:#ffffff;background-color:#c2185b;" sk_icon="border-radius:50px;padding:10px 10px 10px 10px;margin:0px 10px 0px -10px;color:#ffffff;background-color:#f06292;" sk_icon_hover="color:#ffffff;"][cz_gap height="80px" id="cz_36465" height_mobile="20px"][/vc_column][vc_column width="1/3" css=".vc_custom_1516294166806{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_hidden-sm vc_hidden-xs"][/vc_column][/vc_row][cz_google_font font="Playfair Display"]',
					),
					array(
						'f' => 'header hero 2 columns animated dance dark full wide 89_jpg',
						'c' =>'[vc_row full_width="stretch_row_content" full_height="yes" columns_placement="stretch" content_placement="middle" css=".vc_custom_1505065743525{background-image: url('.$imgu.'img69.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_class="tac"][vc_column width="1/3" offset="vc_hidden-sm vc_col-xs-12 vc_hidden-xs"][/vc_column][vc_column width="2/3" offset="vc_col-xs-12"][cz_title id="cz_17378"]<p style="text-align: center;"><span style="font-size: 24px; color: #ffffff; font-family: Bree Serif; font-weight: 400;">The Royal Dance</span><span style="font-weight: bold; font-size: 20px; color: #525252;"></span></p>[/cz_title][cz_animated_text before_text="" words="Wonderful,Awesome,Fantastic" after_text="" fx="letters_rotate-3" tag="div" id="cz_27912" sk_words="font-size:150px;color:#26c6da;font-family:Playball;font-weight:400;" sk_before="font-weight:700;color:rgba(255,255,255,0.8);font-size:60px;letter-spacing:1px;" sk_after="font-weight:700;color:rgba(255,255,255,0.8);font-size:60px;letter-spacing:1px;" sk_words_tablet="font-size:80px;" sk_words_mobile="font-size:50px;" sk_overall="display:inline;"][cz_gap height="20px" id="cz_29483"][cz_button title="Play Video" btn_position="cz_btn_center" text_effect="cz_btn_txt_move_up" btn_effect="cz_btn_zoom_in" link="url:%23|||" icon="fa fa-play-circle" id="cz_12033" sk_button="border-radius:50px;border-bottom-style:solid;border-color:rgba(255,255,255,0.48);border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:5px 25px 7px 25px;border-width:2px 2px 2px 2px;font-weight:400;font-family:Bree Serif;background-color:rgba(255,255,255,0.01);font-size:18px;color:#ffffff;letter-spacing:2px;" sk_hover="border-bottom-style:solid;border-color:#ffffff;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:2px 2px 2px 2px;color:#ffffff;background-color:rgba(255,255,255,0.01);" sk_icon="margin-right:10px;color:rgba(255,255,255,0.45);" sk_icon_hover="color:#ffffff;"][cz_gap height="70px" id="cz_15984"][/vc_column][/vc_row][cz_google_font font="Bree Serif"][cz_google_font font="Playball"]',
					),
					array(
						'f' => 'header hero 1 column dark full wide 90_jpg',
						'c' =>'[vc_row full_width="stretch_row_content" full_height="yes" columns_placement="stretch" content_placement="top" css=".vc_custom_1505155279511{background-image: url('.$imgu.'img64.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column offset="vc_col-xs-12"][cz_gap height="90px" id="cz_67323"][cz_title smart_fs="true" text_center="true" id="cz_80407" sk_overall="background-color:rgba(255,255,255,0.2);padding:40px 50px;border-bottom-width:5px;border-color:#0066bf;text-shadow:1px 1px 2px rgba(0,0,0,0.55);" sk_overall_mobile="padding:0px;"]<div style="text-align: center; line-height: 1.1;"><span style="font-size: 100px; color: #ffffff; font-weight: bold;"><span style="font-weight: bold;">Think </span><span style="font-weight: 200;">Before</span> Jump</span></div>[/cz_title][cz_gap height="70px" id="cz_15085"][cz_button title="BUY IT ONLINE" btn_position="cz_btn_center" btn_effect="cz_btn_fill_up" link="url:%23|||" icon="fa fa-shopping-cart" id="cz_40714" sk_button="border-bottom-style:solid;border-color:#ff0000;padding:10px 20px 10px 20px;border-bottom-width:4px;font-weight:400;background-color:rgba(255,255,255,0.2);font-size:16px;color:#ffffff;letter-spacing:1px;" sk_hover="color:#ffffff;background-color:#ff0000;" sk_icon="margin-right:10px;font-size:18px;color:#ff0000;" sk_icon_hover="color:#ffffff;"][cz_gap height="120px" id="cz_53772"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'header hero 2 columns creative dark full wide 91_jpg',
						'c' =>'[vc_row full_width="stretch_row_content" full_height="yes" columns_placement="stretch" content_placement="middle" css=".vc_custom_1505156054274{background-image: url('.$imgu.'img7.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column css=".vc_custom_1516294558395{padding-right: 80px !important;}" offset="vc_col-xs-12"][cz_title text_center="true" id="cz_73508" sk_overall="margin-top:20px;text-shadow:-5px 6px #048281 ;" sk_overall_mobile="margin-bottom:20px;"]<p style="text-align: right;"><span style="font-weight: bold; font-size: 20px; color: #ffffff;"><span style="font-weight: 600; font-size: 28px; font-family: Oswald; color: #680907;">W E A R E X T R A</span></span></p>[/cz_title][cz_title smart_fs="true" text_center="true" id="cz_77556" sk_overall="padding-top:40px;padding-bottom:50px;border-radius:15px;text-shadow:-20px 16px rgba(4,130,129,0.71) ;" sk_overall_mobile="padding:0px;"]<div style="text-align: right; line-height: 1.1;"><span style="font-size: 110px; color: #680907; font-weight: bold; font-family: Oswald;">CREATIVE AGENCY</span></div>[/cz_title][vc_row_inner][vc_column_inner width="2/3"][/vc_column_inner][vc_column_inner width="1/3"][vc_column_text]<p style="text-align: right;"><span style="color: #000000;">Lorem ipsum dolor sit amet, conse ctetur adip isicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.</span></p>[/vc_column_text][cz_button title="View Portfolio" btn_position="cz_btn_right" text_effect="cz_btn_txt_move_right" icon_position="after" link="url:%23|||" icon="fa fa-long-arrow-right" id="cz_56900" sk_button="padding:10px 30px 10px 30px;font-weight:400;box-shadow:-9px 12px rgba(104,9,7,0.88) ;background-color:#048281;font-size:17px;color:#000000;letter-spacing:2px;" sk_hover="color:#ffffff;background-color:#680907;box-shadow:-9px 12px #048281 ;" sk_icon_hover="color:#ffffff;"][/vc_column_inner][/vc_row_inner][cz_gap height="100px" id="cz_50573"][/vc_column][/vc_row][cz_google_font font="Oswald"]',
					),
					array(
						'f' => 'header hero 1 column business dark or button full wide 92_jpg',
						'c' =>'[vc_row full_width="stretch_row_content" full_height="yes" columns_placement="stretch" content_placement="middle" css=".vc_custom_1505168657843{background-image: url('.$imgu.'img13.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column offset="vc_col-xs-12"][cz_title id="cz_19516" sk_overall="padding-right:30px;padding-left:30px;" sk_overall_mobile="margin-bottom:50px;"]<div style="text-align: center; line-height: 1;"><span style="font-weight: 300; font-size: 28px; color: #ffffff;">WE ARE EXPERT IN</span></div>[/cz_title][cz_title smart_fs="true" text_center="true" id="cz_46628" sk_overall="padding:40px 50px 50px;border-radius:15px;" sk_overall_mobile="padding:0px;"]<div style="text-align: center; line-height: 1.1;"><span style="font-size: 110px; color: #ffffff; font-family: Raleway; font-weight: bold;">BUSINESS <span style="font-weight: 100;">SOLUTIONS</span></span></div>[/cz_title][cz_2_buttons title="GET FREE QUOTE" title2="VIEW OUR PROJECTS" css_position="relative;display: table;margin:0 auto" separator="icon" link="url:%23|||" link2="url:%23|||" icon="fa fa-check" id="cz_18747" sk_icon="font-size:24px;border-width:0px;" sk_btn1="color:#ffffff;letter-spacing:1px;background-color:rgba(255,255,255,0.01);border-style:solid;border-width:2px;border-color:#ffffff;border-radius:100px 0 0 100px;" sk_btn2="color:#ffffff;background-color:rgba(255,255,255,0);border-width:2px;border-color:#ffffff;border-radius:0 100px 100px 0;" sk_btn1_hover="background-color:rgba(255,255,255,0.15);" sk_btn2_hover="background-color:rgba(255,255,255,0.15);" sk_btn1_mobile="font-size:12px;margin:50px auto 0px;border-radius:100px;display:table;" sk_btn2_mobile="font-size:12px;margin-right:auto;margin-left:auto;border-radius:100px;display:table;" sk_icon_mobile="display:none;"][/vc_column][/vc_row][cz_google_font font="Raleway"]',
					),
					array(
						'f' => 'header hero 2 columns faashion light color full wide 93_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" css=".vc_custom_1505169537161{background-image: url('.$imgu.'img75.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="2/3" css=".vc_custom_1516295723881{padding-right: 50px !important;padding-left: 50px !important;}" offset="vc_col-xs-12"][cz_gap height="30px" id="cz_28530"][cz_title smart_fs="true" text_center="true" id="cz_52669"]<div style="line-height: 1; letter-spacing: -2px; text-align: center;"><span style="font-size: 192px; font-weight: bold; display: block; color: #64bf37; font-family: Yesteryear; line-height: 1;">Spring</span><span style="font-size: 90px; font-weight: 200; color: #2e2ea8; font-family: Playfair Display; line-height: 1;">&amp;</span></div><div style="line-height: 1; letter-spacing: -2px; text-align: center;"><span style="font-size: 192px; font-weight: 200; display: block; color: #fd7b00; font-family: Yesteryear; line-height: 1;"><span style="font-weight: bold;">Summer</span></span></div>[/cz_title][cz_gap height="60px" id="cz_71176"][/vc_column][vc_column width="1/3" css=".vc_custom_1516295735537{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_hidden-sm vc_col-xs-12 vc_hidden-xs"][/vc_column][/vc_row][cz_google_font font="Playfair Display"][cz_google_font font="Yesteryear"]',
					),
					array(
						'f' => 'header hero 2 columns video about green full wide 94_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle" css=".vc_custom_1505171476007{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" offset="vc_col-xs-12"][cz_gap height="90px" id="cz_41065"][cz_title smart_fs="true" text_center="true" id="cz_37109"]<div style="line-height: 1; letter-spacing: -2px; text-align: right;"><span style="font-size: 90px; font-weight: bold; display: block; font-family: Playfair Display; color: #99cc00;">Expert Group</span></div><div style="line-height: 1; letter-spacing: -2px; text-align: right;"><span style="color: #339966; font-family: Alex Brush; font-size: 100px;">of</span></div><div style="line-height: 1; letter-spacing: -2px; text-align: right;"><span style="font-size: 90px; font-weight: bold; display: block; color: #99cc00;"><span style="font-family: Playfair Display;">Business Advisors</span></span></div>[/cz_title][cz_gap height="100px" id="cz_87732"][/vc_column][vc_column width="1/2" css=".vc_custom_1516295799077{background-image: url('.$imgu.'img37.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}" offset="vc_col-xs-12"][cz_button btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" icon="fa fa-play-circle" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DAvWjf_RUy4c|||" class="lightbox" id="cz_97626" sk_button="font-size:-1px;background-color:#ffffff;border-radius:7px;" sk_icon="font-size:50px;color:#ffffff;background-color:#81d742;padding:21px 25px;border-radius:100px;" sk_icon_hover="color:#000000;" sk_icon_mobile="font-size:80px;" cz_button=""][/vc_column][/vc_row][cz_google_font font="Playfair Display"][cz_google_font font="Alex Brush"]',
					),
					array(
						'f' => 'header hero 2 columns product buy gradient full wide 95_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" el_class="no_padding"][vc_column width="1/2" css=".vc_custom_1516295912339{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-xs-12"][cz_image image="'.$imgu.'img19.jpg" id="cz_21602" sk_css="position:relative;display: table;margin:0 auto;"][/vc_column][vc_column width="1/2" css=".vc_custom_1516297096389{background-color: #ffffff !important;}" offset="vc_col-xs-12"][cz_content_box type="1" id="cz_92613" sk_overall="background-color:transparent;background-image:linear-gradient(45deg,#031149,#66073f);padding:40px 50px;margin-left:-150px;" sk_overall_mobile="padding:10px;margin:0px;"][cz_title text_center="true" id="cz_15047" sk_overall_mobile="margin-top:30px;"]<span style="font-size: 18px; color: rgba(255,255,255,.4);">CLASSIC WATCH</span>[/cz_title][cz_title smart_fs="true" text_center="true" id="cz_90750"]<span style="font-family: Playfair Display; font-size: 96px; color: #ffffff;"><span style="font-family: Alex Brush;"><sup>$</sup></span><span style="font-weight: bold;">4399<sup><span style="font-weight: 100;">.00</span></sup></span></span>[/cz_title][vc_column_text]<span style="color: rgba(255,255,255,.4); font-size: 14px;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</span>[/vc_column_text][cz_gap height="35px" id="cz_71177"][cz_button title="ADD TO CART" btn_position="cz_btn_left cz_mobile_btn_center" text_effect="cz_btn_show_hidden_icon" link="url:%23|||" icon="fa fa-cart-plus" id="cz_30551" sk_button="font-size:14px;color:#031149;background-color:#ffffff;padding:10px 30px;" sk_hover="color:#66073f;background-color:#ffffff;" sk_icon_hover="color:#66073f;" cz_button="" sk_button_mobile="margin-bottom:20px;"][/cz_content_box][/vc_column][/vc_row][cz_google_font font="Alex Brush"][cz_google_font font="Playfair Display"]',
					),
					array(
						'f' => 'header hero 2 columns sport gym dark power full wide 96_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" css=".vc_custom_1505146434968{background-image: url('.$imgu.'img76.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/3" css=".vc_custom_1516297222964{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_hidden-sm vc_col-xs-12 vc_hidden-xs"][cz_gap height="650px" id="cz_96685"][/vc_column][vc_column width="2/3" css=".vc_custom_1516297242764{padding-right: 100px !important;padding-left: 50px !important;}" offset="vc_col-xs-12"][cz_title shape="text" smart_fs="true" text_center="true" shape_text="&amp;" id="cz_83573" sk_shape="font-size:544px;color:rgba(255,255,255,0.3);font-weight:900;top:150px;" sk_shape_mobile="display:none;"]<p style="text-align: center;"><span style="line-height: 1; color: #ffa726; font-size: 160px; font-family: Impact;">P O W E R <span style="display: block;">F I T N E S S</span></span></p>[/cz_title][cz_gap height="70px" id="cz_78036"][cz_button title="VIEW SCHEDULE" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" icon="fa fa-calendar" id="cz_97699" sk_button="font-size:16px;color:#ffffff;background-color:#ff6d00;padding:12px 35px;border-radius:0px;" sk_hover="border-radius:100px;color:#ffffff;background-color:#ffa726;" sk_icon_hover="color:#ffffff;" sk_button_mobile="font-size:13px;margin-bottom:20px;" cz_button=""][/vc_column][/vc_row]',
					),
					array(
						'f' => 'header hero 1 column left creative dark full wide 97_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" css=".vc_custom_1505147755698{background-image: url('.$imgu.'img59.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column css=".vc_custom_1516297381087{padding-right: 100px !important;padding-left: 100px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-xs-12"][cz_title smart_fs="true" id="cz_99104" sk_overall="border-radius:100px 0 100px 0;padding-top:0px;margin-bottom:30px;margin-top:0px;text-shadow:-1px 1px rgba(0,0,0,0.29) ;"]<p style="text-align: left;"><span style="line-height: 1;"><span style="font-family: Montserrat; font-size: 70px; color: #ffffff;"><span style="font-weight: 500; font-family: Six Caps; font-size: 3em;">design</span> <span style="font-family: Playfair Display; font-size: 1em;">&amp;</span> <span style="font-weight: 500; font-family: Six Caps; font-size: 3em;">creativity</span></span><span style="font-family: Playfair Display; font-size: 90px; color: #ff1cc9; font-weight: bold;"></span></span></p>[/cz_title][cz_title id="cz_35655" sk_overall="text-shadow:-1px 1px rgba(0,0,0,0.3) ;"]<div style="line-height: 1.4; text-align: left;"><span style="font-weight: 400;"><span style="color: #ffffff;">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sedix</span></span></div><div style="line-height: 1.4; text-align: left;"><span style="font-weight: 400;"><span style="color: #ffffff;">eiusmod tempor incididunt ut labore et dolore magna aliqua.</span></span></div><div style="line-height: 1.4; text-align: left;"><span style="font-weight: 400;"><span style="color: #ffffff;">Ut enim ad minim veniam. </span></span></div>[/cz_title][cz_button title="PLAY VIDEO" icon="fa fa-play-circle" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DAvWjf_RUy4c|||" class="lightbox" id="cz_22678" sk_button="border-radius:7px;margin-top:30px;background-color:#ffffff;box-shadow:-1px 1px rgba(0,0,0,0.26) ;color:#1e73be;font-size:13px;letter-spacing:2px;" sk_icon="margin-right:10px;font-size:18px;color:rgba(30,115,190,0.72);"][/vc_column][/vc_row][cz_google_font font="Montserrat"][cz_google_font font="Playfair Display"][cz_google_font font="Six Caps"]',
					),
					array(
						'f' => 'header hero 1 column mask bold full wide 98_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" css=".vc_custom_1505156131800{background-color: #eeeeee !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column css=".vc_custom_1516297423214{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-xs-12"][cz_gradient_title smart_fs="true" text_center="true" bg_mode="image" id="cz_39913" sk_css="background-image:url('.$imgu.'img52.jpg);"]<p style="text-align: center;"><span style="font-family: Oswald; font-weight: bold; font-size: 288px; line-height: 1; letter-spacing: 8px;">CREATIVE</span></p>[/cz_gradient_title][cz_gap height="60px" id="cz_51483"][cz_button title="VIEW PORTFOLIO" btn_position="cz_btn_center" text_effect="cz_btn_show_hidden_icon" icon_position="after" icon="fa fa-long-arrow-right" link="url:%23|||" id="cz_30170" sk_button="font-size:13px;letter-spacing:2px;background-color:transparent;background-image:linear-gradient(45deg,#1a34b2,#751599),url('.$imgu.'img52.jpg);padding:12px 25px;border-radius:3px;" sk_hover="color:#ffffff;" sk_icon_hover="color:#ffffff;" cz_button=""][/vc_column][/vc_row][cz_google_font font="Oswald"]',
					),
					array(
						'f' => 'header hero 1 column bold creative full wide 99_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="bottom" css=".vc_custom_1505170815782{background-image: url('.$imgu.'img30.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][cz_gradient_title smart_fs="true" text_center="true" id="cz_34423" sk_css="background-color:unset !important;background-image:linear-gradient(0deg,#000000,#9b25ea);"]<p style="text-align: center;"><span style="font-family: Baloo; line-height: 1.4;"><span style="font-family: Montserrat; font-weight: 900; font-size: 150px;">DO IT</span></span></p>[/cz_gradient_title][cz_gap height="30px" id="cz_21680"][cz_button title="VIEW PORTFOLIO" btn_position="cz_btn_center" btn_effect="cz_btn_absorber" link="url:%23|||" id="cz_45038" sk_button="border-radius:100px;padding-left:40px;padding-right:40px;background-color:unset !important;background-image:linear-gradient(0deg,#000000,#a821d1);font-size:16px;color:#ffffff;" sk_hover="box-shadow:0px 0px 15px rgba(0,0,0,0.24) ;color:#ffffff;" sk_icon="color:rgba(255,255,255,0.3);" sk_icon_hover="color:#ffffff;"][cz_gap height="100px" id="cz_37544"][/vc_column][/vc_row][cz_google_font font="Baloo"][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => 'header hero 2 columns light social icons minimal gray full wide 100_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" css=".vc_custom_1505170623988{background-image: url('.$imgu.'img78.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" css=".vc_custom_1504695165408{padding-right: 60px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][cz_gap height="60px" id="cz_91633"][/vc_column][vc_column width="1/2" css=".vc_custom_1505170579817{padding-right: 50px !important;padding-left: 0px !important;}"][cz_gap id="cz_31047"][cz_title smart_fs="true" id="cz_83992" sk_overall="padding-bottom:50px;margin-top:-15px;" sk_overall_mobile="padding:0px 0px 30px;"]<div style="line-height: 1;"><span style="font-size: 56px; font-weight: bold; color: #000000;"><span style="font-size: 80px; font-weight: 200;">TIME IS</span> <span style="font-size: 80px;">GOLD</span></span></div>[/cz_title][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit Ut elit tellus, luctus nec ullamcorper mattis, pulvinarda pibus leo.[/vc_column_text][cz_social_icons fx="cz_social_fx_0" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22title%22%3A%22Linkedin%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-cloud-download%22%2C%22title%22%3A%22Download%22%2C%22link%22%3A%22%23%22%7D%5D" id="cz_88237" sk_icons="margin-right:10px;color:#f0f0f0;background-color:#000000;font-size:18px;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'banner service 3 columns dark construction 101_jpg',
						'c' =>'[vc_row][vc_column width="1/3"][cz_banner title="Constructions" image="'.$imgu.'pic5.jpg" image_opacity="0.5" image_hover_opacity="0.2" sk_title="font-size:36px;color:#ffffff;font-family:Montserrat;text-align:center;font-weight:700;text-shadow:-1px 1px 1px rgba(0,0,0,0.59);" sk_box="background-color:#000000;margin-bottom:30px;border-radius:5px;" id="cz_15284" sk_title_tablet="font-size:18px;margin-top:-15px;" sk_title_mobile="font-size:24px;margin-top:-5px;"]
	<p style="text-align: center;"><span style="font-size: 14px; font-weight: 300;">Click here for more information</span></p>
	[/cz_banner][/vc_column][vc_column width="1/3"][cz_banner title="Cooperation" image="'.$imgu.'pic4.jpg" image_opacity="0.5" image_hover_opacity="0.2" sk_title="font-size:36px;color:#ffffff;font-family:Montserrat;text-align:center;font-weight:700;text-shadow:-1px 1px 1px rgba(0,0,0,0.59);" sk_box="background-color:#000000;margin-bottom:30px;border-radius:5px;" id="cz_83986" sk_title_tablet="font-size:18px;margin-top:-15px;" sk_title_mobile="font-size:24px;margin-top:-5px;"]
	<p style="text-align: center;"><span style="font-size: 14px; font-weight: 300;">Click here for more information</span></p>
	[/cz_banner][/vc_column][vc_column width="1/3"][cz_banner title="Land Analysis" image="'.$imgu.'pic3.jpg" image_opacity="0.5" image_hover_opacity="0.2" sk_title="font-size:36px;color:#ffffff;font-family:Montserrat;text-align:center;font-weight:700;text-shadow:-1px 1px 1px rgba(0,0,0,0.59);" sk_box="background-color:#000000;margin-bottom:30px;border-radius:5px;" id="cz_71177" sk_title_tablet="font-size:18px;margin-top:-15px;" sk_title_mobile="font-size:24px;margin-top:-5px;"]
	<p style="text-align: center;"><span style="font-size: 14px; font-weight: 300;">Click here for more information</span></p>
	[/cz_banner][/vc_column][/vc_row][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => 'banner service 3 columns dark business 102_jpg',
						'c' =>'[vc_row][vc_column width="1/3"][cz_banner title="MARKETING" style="style16" image="'.$imgu.'pic7.jpg" image_opacity="0.2" image_hover_opacity="0.6" sk_title="font-size:40px;color:#ffffff;font-family:Montserrat;font-weight:200;letter-spacing:0px;padding-top:16%;text-shadow:-1px 1px 1px rgba(0,0,0,0.4);" sk_box="background-color:#000000;margin-bottom:30px;" id="cz_31752" sk_title_tablet="font-size:20px;" sk_title_mobile="font-size:24px;"]<span style="font-size: 14px; font-weight: 300;">Learn More ...</span>[/cz_banner][/vc_column][vc_column width="1/3"][cz_banner title="BUSINESS" style="style16" image="'.$imgu.'pic6.jpg" image_opacity="0.2" image_hover_opacity="0.6" sk_title="font-size:40px;color:#ffffff;font-family:Montserrat;font-weight:200;letter-spacing:0px;padding-top:16%;text-shadow:-1px 1px 1px rgba(0,0,0,0.4);" sk_box="background-color:#000000;margin-bottom:30px;" id="cz_44960" sk_title_tablet="font-size:20px;" sk_title_mobile="font-size:24px;"]<span style="font-size: 14px; font-weight: 300;">Learn More ...</span>[/cz_banner][/vc_column][vc_column width="1/3"][cz_banner title="SOLUTION" style="style16" image="'.$imgu.'pic60.jpg" image_opacity="0.2" image_hover_opacity="0.6" sk_title="font-size:40px;color:#ffffff;font-family:Montserrat;font-weight:200;letter-spacing:0px;padding-top:16%;text-shadow:-1px 1px 1px rgba(0,0,0,0.4);" sk_box="background-color:#000000;margin-bottom:30px;" id="cz_97732" sk_title_tablet="font-size:20px;" sk_title_mobile="font-size:24px;"]<span style="font-size: 14px; font-weight: 300;">Learn More ...</span>[/cz_banner][/vc_column][/vc_row][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => 'banner service 3 columns light fashion 103_jpg',
						'c' =>'[vc_row][vc_column width="1/3"][cz_banner title="PERSONAL" style="style19" image="'.$imgu.'pic41.jpg" image_opacity="0.3" image_hover_opacity="0.6" css_animation="fadeInUp" sk_title="font-size:36px;color:#000000;font-family:Playfair Display;font-weight:100;letter-spacing:12px;padding-top:23%;" sk_box="background-color:#ffffff;margin-bottom:30px;" id="cz_95797" sk_title_tablet="font-size:20px;letter-spacing:6px;" sk_title_mobile="font-size:24px;"]<span style="font-size: 14px; font-weight: 300; color: #000000;">Learn More ...</span>[/cz_banner][/vc_column][vc_column width="1/3"][cz_banner title="FASHION" style="style19" image="'.$imgu.'pic42.jpg" image_opacity="0.3" image_hover_opacity="0.6" css_animation="fadeInUp" sk_title="font-size:36px;color:#000000;font-family:Playfair Display;font-weight:100;letter-spacing:12px;padding-top:23%;" sk_box="background-color:#ffffff;margin-bottom:30px;" id="cz_33550" sk_title_tablet="font-size:20px;letter-spacing:6px;" sk_title_mobile="font-size:24px;"]<span style="font-size: 14px; font-weight: 300; color: #000000;">Learn More ...</span>[/cz_banner][/vc_column][vc_column width="1/3"][cz_banner title="CLASSIC" style="style19" image="'.$imgu.'pic40.jpg" image_opacity="0.3" image_hover_opacity="0.6" css_animation="fadeInUp" sk_title="font-size:36px;color:#000000;font-family:Playfair Display;font-weight:100;letter-spacing:12px;padding-top:23%;" sk_box="background-color:#ffffff;margin-bottom:30px;" id="cz_85103" sk_title_tablet="font-size:20px;letter-spacing:6px;" sk_title_mobile="font-size:24px;"]<span style="font-size: 14px; font-weight: 300; color: #000000;">Learn More ...</span>[/cz_banner][/vc_column][/vc_row][cz_google_font font="Playfair Display"]',
					),
					array(
						'f' => 'banner service 4 columns light food menu price shop product 104_jpg',
						'c' =>'[vc_row][vc_column width="1/2" offset="vc_col-lg-3"][cz_banner title="CHICKEN BURGER" style="style4" image="'.$imgu.'pic63.jpg" image_opacity="0.9" image_hover_opacity="0.5" sk_title="font-family:Luckiest Guy;font-size:24px;color:#ffffff;" sk_box="background-color:#000000;margin-bottom:30px;" sk_caption="background-color:#bc0000;" id="cz_25539"]<span style="font-size: 24px; color: #ffffff;"> $9.99</span>[/cz_banner][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_banner title="DOUBLE BURGER" style="style4" image="'.$imgu.'pic64.jpg" image_opacity="0.9" image_hover_opacity="0.5" sk_title="font-family:Luckiest Guy;font-size:24px;color:#ffffff;" sk_box="background-color:#000000;margin-bottom:30px;" sk_caption="background-color:#bc0000;" id="cz_92796"]<span style="color: #ffffff; font-size: 24px;">$11.99</span>[/cz_banner][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_banner title="FRIED BURGER" style="style4" image="'.$imgu.'pic65.jpg" image_opacity="0.9" image_hover_opacity="0.5" sk_title="font-family:Luckiest Guy;font-size:24px;color:#ffffff;" sk_box="background-color:#000000;margin-bottom:30px;" sk_caption="background-color:#bc0000;" id="cz_54759"]<span style="color: #ffffff; font-size: 24px;">$9.99</span>[/cz_banner][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_banner title="CHEESE BURGER" style="style4" image="'.$imgu.'pic66.jpg" image_opacity="0.9" image_hover_opacity="0.5" sk_title="font-family:Luckiest Guy;font-size:24px;color:#ffffff;" sk_box="background-color:#000000;margin-bottom:30px;" sk_caption="background-color:#bc0000;" id="cz_69357"]<span style="color: #ffffff; font-size: 24px;">$7.99</span>[/cz_banner][/vc_column][/vc_row][cz_google_font font="Luckiest Guy"]',
					),
					array(
						'f' => 'banner service 3 columns dark construction 105_jpg',
						'c' =>'[vc_row][vc_column width="1/3"][cz_banner title="MODERN" style="style22" image="'.$imgu.'pic78.jpg" image_opacity="0.2" image_hover_opacity="0.5" sk_title="font-size:48px;color:#eded00;font-family:Playfair Display;font-weight:700;letter-spacing:-2px;" sk_box="background-color:#1a237e;margin-bottom:30px;" id="cz_82671" sk_title_tablet="font-size:30px;" sk_title_mobile="font-size:36px;"]<span style="color: #ffffff;">Lear More ...</span>[/cz_banner][/vc_column][vc_column width="1/3"][cz_banner title="CLASSIC" style="style22" image="'.$imgu.'pic79.jpg" image_opacity="0.2" image_hover_opacity="0.5" sk_title="font-size:48px;color:#eded00;font-family:Playfair Display;font-weight:700;letter-spacing:-2px;" sk_box="background-color:#1a237e;margin-bottom:30px;" id="cz_14730" sk_title_tablet="font-size:30px;" sk_title_mobile="font-size:36px;"]<span style="color: #ffffff;">Lear More ...</span>[/cz_banner][/vc_column][vc_column width="1/3"][cz_banner title="AWESOME" style="style22" image="'.$imgu.'pic80.jpg" image_opacity="0.2" image_hover_opacity="0.5" sk_title="font-size:48px;color:#eded00;font-family:Playfair Display;font-weight:700;letter-spacing:-2px;" sk_box="background-color:#1a237e;margin-bottom:30px;" id="cz_71330" sk_title_tablet="font-size:30px;" sk_title_mobile="font-size:36px;"]<span style="color: #ffffff;">Lear More ...</span>[/cz_banner][/vc_column][/vc_row][cz_google_font font="Playfair Display"]',
					),
					array(
						'f' => 'banner service 2 columns dark 106_jpg',
						'c' =>'[vc_row][vc_column width="1/2"][cz_banner title="CREATIVE AGENCY" style="style14" image="'.$imgu.'pic57.jpg" image_opacity="0.2" image_hover_opacity="0.6" sk_title="font-size:42px;color:#ffffff;font-family:Montserrat;font-weight:700;letter-spacing:-2px;padding-top:32%;" sk_box="background-color:#421174;margin-bottom:30px;" id="cz_43138" sk_title_tablet="font-size:30px;line-height:30px;padding-top:25%;"]<span style="color: #8224e3; font-size: 14px;">VIEW ALL PROJECTS</span>[/cz_banner][/vc_column][vc_column width="1/2"][cz_banner title="BUSINESS SOLUTION" style="style14" image="'.$imgu.'pic59.jpg" image_opacity="0.2" image_hover_opacity="0.6" sk_title="font-size:42px;color:#ffffff;font-family:Montserrat;font-weight:700;letter-spacing:-2px;padding-top:32%;" sk_box="background-color:#421174;margin-bottom:30px;" id="cz_63870" sk_title_tablet="font-size:30px;line-height:30px;padding-top:25%;"]<span style="color: #8224e3; font-size: 14px;">VIEW ALL PROJECTS</span>[/cz_banner][/vc_column][/vc_row][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => 'banner service 3 columns shop product 107_jpg',
						'c' =>'[vc_row][vc_column width="1/3"][cz_banner title="Air Max" style="style17" image="'.$imgu.'pic33.jpg" image_opacity="0.9" image_hover_opacity="0.6" sk_title="font-size:36px;color:#013a89;font-family:Baloo;text-align:left;font-weight:700;" sk_box="background-color:#013a89;margin-bottom:30px;box-shadow:-10px 10px #013a89 ;" id="cz_67408" sk_title_tablet="font-size:24px;"]<span style="font-size: 14px; color: #ffffff;">Buy Now!</span>[/cz_banner][/vc_column][vc_column width="1/3"][cz_banner title="Maxxx" style="style17" image="'.$imgu.'pic32.jpg" image_opacity="0.9" image_hover_opacity="0.6" sk_title="font-size:36px;color:#d61900;font-family:Baloo;text-align:left;font-weight:700;" sk_box="background-color:#d61900;margin-bottom:30px;box-shadow:-10px 10px #d61900 ;" id="cz_96532" sk_title_tablet="font-size:24px;"]<span style="font-size: 14px; color: #ffffff;">Buy Now!</span>[/cz_banner][/vc_column][vc_column width="1/3"][cz_banner title="Sport" style="style17" image="'.$imgu.'pic31.jpg" image_opacity="0.9" image_hover_opacity="0.6" sk_title="font-size:36px;color:#01a1ac;font-family:Baloo;text-align:left;font-weight:700;" sk_box="background-color:#01a1ac;margin-bottom:30px;box-shadow:-10px 10px #01a1ac ;" id="cz_79757" sk_title_tablet="font-size:24px;"]<span style="font-size: 14px; color: #ffffff;">Buy Now!</span>[/cz_banner][/vc_column][/vc_row][cz_google_font font="Baloo"]',
					),
					array(
						'f' => 'banner service 3 columns dark 108_jpg',
						'c' =>'[vc_row][vc_column width="1/3"][cz_banner title="Journey" style="style5" image="'.$imgu.'pic21.jpg" image_opacity="0.7" image_hover_opacity="0.3" sk_title="font-size:54px;color:#ffffff;font-family:Playball;" sk_box="background-color:#000000;margin-bottom:30px;" id="cz_42210" sk_title_tablet="font-size:42px;"]<span style="font-size: 13px;">View More</span>[/cz_banner][/vc_column][vc_column width="1/3"][cz_banner title="Nature" style="style5" image="'.$imgu.'pic24.jpg" image_opacity="0.7" image_hover_opacity="0.3" sk_title="font-size:54px;color:#ffffff;font-family:Playball;" sk_box="background-color:#000000;margin-bottom:30px;" id="cz_21715" sk_title_tablet="font-size:42px;"]<span style="font-size: 13px;">View More</span>[/cz_banner][/vc_column][vc_column width="1/3"][cz_banner title="Mountain" style="style5" image="'.$imgu.'pic22.jpg" image_opacity="0.7" image_hover_opacity="0.3" sk_title="font-size:54px;color:#ffffff;font-family:Playball;" sk_box="background-color:#000000;margin-bottom:30px;" id="cz_64688" sk_title_tablet="font-size:42px;"]<span style="font-size: 13px;">View More</span>[/cz_banner][/vc_column][/vc_row][cz_google_font font="Playball"]',
					),
					array(
						'f' => 'banner service 3 columns dark metro category photography grid 109_jpg',
						'c' =>'[vc_row][vc_column width="1/3"][cz_banner title="Modeling" style="style5" image="'.$imgu.'pic68.jpg" image_opacity="0.3" image_hover_opacity="0.1" css_animation="flipInX" sk_title="font-size:42px;color:#ffffff;font-family:Playfair Display;letter-spacing:-3px;padding-top:87%;" sk_box="background-color:#000000;margin-bottom:30px;" id="cz_86484" sk_title_tablet="font-size:36px;"]<span style="font-size: 13px;">View More</span>[/cz_banner][/vc_column][vc_column width="1/3"][cz_banner title="Architecture" style="style5" image="'.$imgu.'pic70.jpg" image_opacity="0.3" image_hover_opacity="0.1" css_animation="flipInY" sk_title="font-size:42px;color:#ffffff;font-family:Playfair Display;letter-spacing:-3px;" sk_box="background-color:#000000;" id="cz_54670" sk_title_tablet="font-size:30px;"]<span style="font-size: 13px;">View More</span>[/cz_banner][cz_gap height="31px" id="cz_49812"][cz_banner title="Nature" style="style5" image="'.$imgu.'pic72.jpg" image_opacity="0.3" image_hover_opacity="0.1" css_animation="flipInY" sk_title="font-size:42px;color:#ffffff;font-family:Playfair Display;letter-spacing:-3px;" sk_box="background-color:#000000;margin-bottom:30px;" id="cz_26984" sk_title_tablet="font-size:30px;"]<span style="font-size: 13px;">View More</span>[/cz_banner][/vc_column][vc_column width="1/3"][cz_banner title="Martial Art" style="style5" image="'.$imgu.'pic69.jpg" image_opacity="0.3" image_hover_opacity="0.1" css_animation="flipInY" sk_title="font-size:42px;color:#ffffff;font-family:Playfair Display;letter-spacing:-3px;" sk_box="background-color:#000000;" id="cz_40484" sk_title_tablet="font-size:30px;"]<span style="font-size: 13px;">View More</span>[/cz_banner][cz_gap height="31px" id="cz_44288"][cz_banner title="Baby &amp; Child" style="style5" image="'.$imgu.'pic71.jpg" image_opacity="0.3" image_hover_opacity="0.1" css_animation="flipInY" sk_title="font-size:42px;color:#ffffff;font-family:Playfair Display;letter-spacing:-3px;" sk_box="background-color:#000000;" id="cz_29782" sk_title_tablet="font-size:30px;"]<span style="font-size: 13px;">View More</span>[/cz_banner][/vc_column][/vc_row][cz_google_font font="Playfair Display"]',
					),
					array(
						'f' => 'banner service 3 columns light metro category photography grid 110_jpg',
						'c' =>'[vc_row][vc_column width="1/3"][cz_banner title="Architecture" style="style16" image="'.$imgu.'pic70.jpg" image_opacity="0.3" image_hover_opacity="0" css_animation="fadeInLeft" sk_title="font-size:42px;color:#bc0000;font-family:Poppins;font-weight:900;letter-spacing:-3px;padding-top:17%;" sk_box="background-color:#ffffff;" id="cz_46360" sk_title_tablet="font-size:32px;"]<span style="font-size: 13px; color: #000000;">View Gallery
	</span>[/cz_banner][cz_gap height="31px" id="cz_54153"][cz_banner title="Nature" style="style16" image="'.$imgu.'pic72.jpg" image_opacity="0.3" image_hover_opacity="0" css_animation="fadeInLeft" sk_title="font-size:42px;color:#bc0000;font-family:Poppins;font-weight:900;letter-spacing:-3px;padding-top:17%;" sk_box="background-color:#ffffff;margin-bottom:30px;" id="cz_51945" sk_title_tablet="font-size:32px;"]<span style="font-size: 13px; color: #000000;">View Gallery
	</span>[/cz_banner][/vc_column][vc_column width="1/3"][cz_banner title="Modeling" style="style16" image="'.$imgu.'pic68.jpg" image_opacity="0.3" image_hover_opacity="0" css_animation="fadeInUp" sk_title="font-size:42px;color:#bc0000;font-family:Poppins;font-weight:900;letter-spacing:-3px;padding-top:84%;" sk_box="background-color:#ffffff;margin-bottom:30px;" id="cz_80958" sk_title_tablet="font-size:32px;" cz_banner=""]<span style="font-size: 13px; color: #000000;">View Gallery
	</span>[/cz_banner][/vc_column][vc_column width="1/3"][cz_banner title="Martial Art" style="style16" image="'.$imgu.'pic69.jpg" image_opacity="0.3" image_hover_opacity="0" css_animation="fadeInRight" sk_title="font-size:42px;color:#bc0000;font-family:Poppins;font-weight:900;letter-spacing:-3px;padding-top:17%;" sk_box="background-color:#ffffff;" id="cz_27855" sk_title_tablet="font-size:32px;"]<span style="font-size: 13px; color: #000000;">View Gallery
	</span>[/cz_banner][cz_gap height="31px" id="cz_53621"][cz_banner title="Baby &amp; Child" style="style16" image="'.$imgu.'pic71.jpg" image_opacity="0.3" image_hover_opacity="0" css_animation="fadeInRight" sk_title="font-size:42px;color:#bc0000;font-family:Poppins;font-weight:900;letter-spacing:-3px;padding-top:17%;" sk_box="background-color:#ffffff;" id="cz_29290" sk_title_tablet="font-size:32px;"]<span style="font-size: 13px; color: #000000;">View Gallery
	</span>[/cz_banner][/vc_column][/vc_row][cz_google_font font="Poppins"]',
					),
					array(
						'f' => 'process 4 columns dark box full wide brown 111_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes"][vc_column width="1/4"][cz_content_box type="1" fx_hover="fx_up_hover" sk_overall="background-color:#947759;padding-right:50px;padding-bottom:50px;padding-left:50px;" id="cz_17833" sk_overall_tablet="padding:15px;"][cz_title id="cz_62217"]<span style="font-family: Montserrat; font-size: 48px; font-weight: 100; color: #ffffff;">01.</span>[/cz_title][cz_gap id="cz_37545"][cz_title id="cz_20112"]<span style="font-size: 24px; font-weight: bold; font-family: Montserrat; color: #ffffff; display: block; line-height: 2;">Free Consultation</span>
	<div style="font-size: 14px; color: #ffffff; font-weight: 300; line-height: 1.5; text-align: justify;">Lorem ipsum dolor sit amet, consec tetuer adipi scing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id, condim entum at.</div>
	[/cz_title][/cz_content_box][/vc_column][vc_column width="1/4"][cz_content_box type="1" fx_hover="fx_up_hover" sk_overall="background-color:#aa8a68;padding-right:50px;padding-bottom:50px;padding-left:50px;" id="cz_41999" sk_overall_tablet="padding:15px;"][cz_title id="cz_44034"]<span style="font-family: Montserrat; font-size: 48px; font-weight: 100; color: #ffffff;">02.</span>[/cz_title][cz_gap id="cz_11303"][cz_title id="cz_12430"]<span style="font-size: 24px; font-weight: bold; font-family: Montserrat; color: #ffffff; display: block; line-height: 2;">Sign a Contract
	</span>
	<div style="font-size: 14px; color: #ffffff; font-weight: 300; line-height: 1.5; text-align: justify;">Lorem ipsum dolor sit amet, consec tetuer adipi scing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id, condim entum at.</div>
	[/cz_title][/cz_content_box][/vc_column][vc_column width="1/4"][cz_content_box type="1" fx_hover="fx_up_hover" sk_overall="background-color:#b79978;padding-right:50px;padding-bottom:50px;padding-left:50px;" id="cz_34883" sk_overall_tablet="padding:15px;"][cz_title id="cz_41411"]<span style="font-family: Montserrat; font-size: 48px; font-weight: 100; color: #ffffff;">03.</span>[/cz_title][cz_gap id="cz_55998"][cz_title id="cz_45873"]<span style="font-size: 24px; font-weight: bold; font-family: Montserrat; color: #ffffff; display: block; line-height: 2;">Research &amp; Planning
	</span>
	<div style="font-size: 14px; color: #ffffff; font-weight: 300; line-height: 1.5; text-align: justify;">Lorem ipsum dolor sit amet, consec tetuer adipi scing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id, condim entum at.</div>
	[/cz_title][/cz_content_box][/vc_column][vc_column width="1/4"][cz_content_box type="1" fx_hover="fx_up_hover" sk_overall="background-color:#c8aa89;padding-right:50px;padding-bottom:50px;padding-left:50px;" id="cz_35021" sk_overall_tablet="padding:15px;"][cz_title id="cz_27935"]<span style="font-family: Montserrat; font-size: 48px; font-weight: 100; color: #ffffff;">04.</span>[/cz_title][cz_gap id="cz_81931"][cz_title id="cz_53314"]<span style="font-size: 24px; font-weight: bold; font-family: Montserrat; color: #ffffff; display: block; line-height: 2;">Project Done!
	</span>
	<div style="font-size: 14px; color: #ffffff; font-weight: 300; line-height: 1.5; text-align: justify;">Lorem ipsum dolor sit amet, consec tetuer adipi scing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id, condim entum at.</div>
	[/cz_title][/cz_content_box][/vc_column][/vc_row][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => 'contact address working hours 4 columns dark box full wide blue 112_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes"][vc_column width="1/4"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" sk_overall="background-color:#002f79;padding-right:50px;padding-bottom:50px;padding-left:50px;" id="cz_51629" sk_overall_tablet="padding:20px;"][cz_gap id="cz_48024"][cz_image image="'.$imgu.'logo2.png" sk_css="width:70px;" id="cz_22162"][cz_gap id="cz_74125"][cz_title id="cz_17456"]
	<div style="font-size: 14px; color: #ffffff; font-weight: 300; line-height: 1.5; text-align: justify;"><span style="color: #e3f2fd; font-size: 13px;">Lorem ipsum dolor sit amet, consec tetuer adipi scing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id, condim entum at.</span></div>
	[/cz_title][/cz_content_box][/vc_column][vc_column width="1/4" offset="vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" sk_overall="background-color:#e3f2fd;padding-right:50px;padding-bottom:55px;padding-left:50px;" id="cz_54565" sk_overall_tablet="padding:20px;"][cz_gap id="cz_60973"][cz_social_icons social="%5B%7B%22icon%22%3A%22fa%20fa-map-marker%22%2C%22title%22%3A%22Address%22%7D%5D" sk_icons="color:#ffffff;background-color:#002f79;font-size:34px;" id="cz_81225"][cz_gap id="cz_99478"][cz_title id="cz_30727"]<span style="font-size: 24px; font-weight: bold; font-family: Montserrat; color: #002f79; display: block; line-height: 2;">ADDRESS
	</span>
	<div style="font-size: 14px; color: #ffffff; font-weight: 300; line-height: 1.5; text-align: justify;"><span style="color: #002f79;">Unit4, No. 23 Some Ave. New York USA 90020</span></div>
	[/cz_title][/cz_content_box][/vc_column][vc_column width="1/4" offset="vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" sk_overall="background-color:#bbdefb;padding-right:50px;padding-bottom:55px;padding-left:50px;" id="cz_17619" sk_overall_tablet="padding:20px;"][cz_gap id="cz_41938"][cz_social_icons social="%5B%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22Phone%22%2C%22link%22%3A%22%23%22%7D%5D" sk_icons="color:#ffffff;background-color:#002f79;font-size:34px;" id="cz_74724"][cz_gap id="cz_98646"][cz_title id="cz_28975"]<span style="font-size: 24px; font-weight: bold; font-family: Montserrat; color: #002f79; display: block; line-height: 2;">PHONE
	</span>
	<div style="font-size: 14px; color: #ffffff; font-weight: 300; line-height: 1.5; text-align: justify;"><span style="color: #002f79;">Phone: +1 (300) 123 4567
	<span style="display: block;">Mobile: +1 (300) 123 4568</span>
	</span></div>
	[/cz_title][/cz_content_box][/vc_column][vc_column width="1/4" offset="vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" sk_overall="background-color:#90caf9;padding-right:50px;padding-bottom:55px;padding-left:50px;" id="cz_52551" sk_overall_tablet="padding:20px;"][cz_gap id="cz_87841"][cz_social_icons social="%5B%7B%22icon%22%3A%22fa%20fa-clock-o%22%2C%22title%22%3A%22Working%20Hours%22%2C%22link%22%3A%22%23%22%7D%5D" sk_icons="color:#ffffff;background-color:#002f79;font-size:34px;" id="cz_62243"][cz_gap id="cz_18517"][cz_title id="cz_98772"]<span style="font-size: 24px; font-weight: bold; font-family: Montserrat; color: #002f79; display: block; line-height: 2;">Working Hours
	</span>
	<div style="font-size: 14px; color: #ffffff; font-weight: 300; line-height: 1.5; text-align: justify;"><span style="color: #002f79;">Monday ~ Friday: 9:00 to 17:00
	<span style="display: block;">Saturday: 10:00 to 15:00</span>
	</span></div>
	[/cz_title][/cz_content_box][/vc_column][/vc_row][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => 'icon service box 6 columns light 113_jpg',
						'c' =>'[/vc_row][vc_row equal_height="yes" el_class="no_padding"][vc_column width="1/6" offset="vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_up_hover" sk_overall="background-color:#dddddd;padding-top:45px;padding-bottom:45px;" id="cz_45865" sk_overall_tablet="padding:20px;"][vc_icon icon_fontawesome="fa fa-globe" color="custom" align="center" css=".vc_custom_1505823089225{margin-bottom: 0px !important;}" custom_color="#666666"][cz_title id="cz_25513"]
	<p style="text-align: center;"><span style="font-size: 18px; font-family: Montserrat; font-weight: 300; color: #666666;">Global Design</span></p>
	[/cz_title][/cz_content_box][/vc_column][vc_column width="1/6" offset="vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_up_hover" sk_overall="background-color:#eeeeee;padding-top:45px;padding-bottom:45px;" id="cz_86425" sk_overall_tablet="padding:20px;"][vc_icon icon_fontawesome="fa fa-language" color="custom" align="center" css=".vc_custom_1505823173399{margin-bottom: 0px !important;}" custom_color="#666666"][cz_title id="cz_38693"]
	<p style="text-align: center;"><span style="font-size: 18px; font-family: Montserrat; font-weight: 300; color: #666666;">Multilingual</span></p>
	[/cz_title][/cz_content_box][/vc_column][vc_column width="1/6" offset="vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_up_hover" class="z99" sk_overall="background-color:#dddddd;padding-top:45px;padding-bottom:45px;" id="cz_94057" sk_overall_tablet="padding:20px;"][vc_icon icon_fontawesome="fa fa-arrows" color="custom" align="center" css=".vc_custom_1505823206792{margin-bottom: 0px !important;}" custom_color="#666666"][cz_title id="cz_65956"]
	<p style="text-align: center;"><span style="font-size: 18px; font-family: Montserrat; font-weight: 300; color: #666666;">Drag &amp; Drop</span></p>
	[/cz_title][/cz_content_box][/vc_column][vc_column width="1/6" offset="vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_up_hover" sk_overall="background-color:#eeeeee;padding-top:45px;padding-bottom:45px;" id="cz_38193" sk_overall_tablet="padding:20px;"][vc_icon icon_fontawesome="fa fa-shopping-cart" color="custom" align="center" css=".vc_custom_1505823239566{margin-bottom: 0px !important;}" custom_color="#666666"][cz_title id="cz_13861"]
	<p style="text-align: center;"><span style="font-size: 18px; font-family: Montserrat; font-weight: 300; color: #666666;">Shop Ready</span></p>
	[/cz_title][/cz_content_box][/vc_column][vc_column width="1/6" offset="vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_up_hover" sk_overall="background-color:#dddddd;padding-top:45px;padding-bottom:45px;" id="cz_12663" sk_overall_tablet="padding:20px;"][vc_icon icon_fontawesome="fa fa-life-ring" color="custom" align="center" css=".vc_custom_1505823269590{margin-bottom: 0px !important;}" custom_color="#666666"][cz_title id="cz_49187"]
	<p style="text-align: center;"><span style="font-size: 18px; font-family: Montserrat; font-weight: 300; color: #666666;">24/7 Support</span></p>
	[/cz_title][/cz_content_box][/vc_column][vc_column width="1/6" offset="vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_up_hover" sk_overall="background-color:#eeeeee;padding-top:45px;padding-bottom:45px;" id="cz_25975" sk_overall_tablet="padding:20px;"][vc_icon icon_fontawesome="fa fa-check" color="custom" align="center" css=".vc_custom_1505823296871{margin-bottom: 0px !important;}" custom_color="#666666"][cz_title id="cz_95706"]
	<p style="text-align: center;"><span style="font-size: 18px; font-family: Montserrat; font-weight: 300; color: #666666;">Easy to Use</span></p>
	[/cz_title][/cz_content_box][/vc_column][/vc_row][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => 'process 4 columns light box full wide 114_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1505824670434{background-color: #eeeeee !important;}"][vc_column width="1/4"][cz_content_box type="1" sk_overall="padding:70px 40px 90px 40px;background-color:rgba(0,0,0,0);" id="cz_15712"][vc_row_inner][vc_column_inner width="1/4"][cz_title sk_overall="text-shadow:0px 5px 15px rgba(0,0,0,0.19) ;" id="cz_77237"]<span style="font-size: 48px; font-family: Montserrat; font-weight: bold; color: #ffffff;">01</span>[/cz_title][/vc_column_inner][vc_column_inner width="3/4"][cz_title sk_overall="margin-top:12px;" id="cz_87739"]<span style="font-size: 24px; font-weight: bold; display: block;">Consultation</span>

	<span style="font-size: 14px; font-weight: 300; line-height: 1.3;"><span style="display: block; color: #808080;">Mauris vel lacus vitae felis vestib ulum volut pat. Etiam est nunc vene natis in, tris tique.</span>
	</span>[/cz_title][/vc_column_inner][/vc_row_inner][/cz_content_box][/vc_column][vc_column width="1/4"][cz_content_box type="1" sk_overall="padding:70px 40px 90px 40px;background-color:rgba(0,0,0,0);" id="cz_41577"][vc_row_inner][vc_column_inner width="1/4"][cz_title sk_overall="text-shadow:0px 5px 15px rgba(0,0,0,0.19) ;" id="cz_16250"]<span style="font-size: 48px; font-family: Montserrat; font-weight: bold; color: #ffffff;">02</span>[/cz_title][/vc_column_inner][vc_column_inner width="3/4"][cz_title sk_overall="margin-top:12px;" id="cz_14607"]<span style="font-size: 24px; font-weight: bold; display: block;">Research
	</span>

	<span style="font-size: 14px; font-weight: 300; line-height: 1.3;"><span style="display: block; color: #808080;">Mauris vel lacus vitae felis vestib ulum volut pat. Etiam est nunc vene natis in, tris tique.</span>
	</span>[/cz_title][/vc_column_inner][/vc_row_inner][/cz_content_box][/vc_column][vc_column width="1/4"][cz_content_box type="1" sk_overall="padding:70px 40px 90px 40px;background-color:rgba(0,0,0,0);" id="cz_46426"][vc_row_inner][vc_column_inner width="1/4"][cz_title sk_overall="text-shadow:0px 5px 15px rgba(0,0,0,0.19) ;" id="cz_18749"]<span style="font-size: 48px; font-family: Montserrat; font-weight: bold; color: #ffffff;">03</span>[/cz_title][/vc_column_inner][vc_column_inner width="3/4"][cz_title sk_overall="margin-top:12px;" id="cz_63995"]<span style="font-size: 24px; font-weight: bold; display: block;">Launch
	</span>

	<span style="font-size: 14px; font-weight: 300; line-height: 1.3;"><span style="display: block; color: #808080;">Mauris vel lacus vitae felis vestib ulum volut pat. Etiam est nunc vene natis in, tris tique.</span>
	</span>[/cz_title][/vc_column_inner][/vc_row_inner][/cz_content_box][/vc_column][vc_column width="1/4"][cz_gap height="100px" id="cz_74725" height_mobile="40px"][cz_button title="Get Started" btn_position="cz_btn_center" btn_effect="cz_btn_fill_up" link="url:%23|||" sk_button="color:#222222;font-size:20px;background-color:#ffffff;box-shadow:0px 8px 30px rgba(0,0,0,0.13) ;" sk_hover="background-color:#eded00;" id="cz_96981"][cz_gap height="100px" id="cz_99142"][/vc_column][/vc_row][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => 'our services 2 columns light 6 box full wide 115_jpg',
						'c' =>'[vc_row full_width="stretch_row" css=".vc_custom_1505827233535{padding-top: 60px !important;padding-bottom: 60px !important;background-color: #f5f5f5 !important;}"][vc_column width="1/2" css=".vc_custom_1505830599961{padding-right: 80px !important;}"][cz_gap height="60px" id="cz_70885"][cz_title id="cz_51550"]<span style="font-size: 48px; font-family: Montserrat; color: #444444;"><span style="font-weight: 200;">OUR</span> <span style="font-weight: 500;">SERVICES</span></span>[/cz_title][cz_gap height="25px" id="cz_74424"][cz_free_line sk_line="height:6px;width:80px;background-color:#e91e63;" id="cz_71472"][cz_gap height="40px" id="cz_42841"][vc_column_text]<span style="font-size: 16px; font-family: Montserrat; font-weight: 300;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</span>[/vc_column_text][/vc_column][vc_column width="1/2"][vc_row_inner][vc_column_inner width="1/3" css=".vc_custom_1505826756104{padding-top: 40px !important;padding-bottom: 50px !important;background-color: #dddddd !important;}"][vc_icon icon_fontawesome="fa fa-globe" color="custom" align="center" css=".vc_custom_1505829740377{margin-bottom: 0px !important;}" custom_color="#e91e63"][cz_title id="cz_28983"]
	<p style="text-align: center;"><span style="font-size: 18px; font-family: Montserrat; font-weight: 300; color: #666666;">Global Design</span></p>
	[/cz_title][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1505827305330{padding-top: 40px !important;padding-bottom: 50px !important;background-color: #ffffff !important;}"][vc_icon icon_fontawesome="fa fa-language" color="custom" align="center" css=".vc_custom_1505829752327{margin-bottom: 0px !important;}" custom_color="#e91e63"][cz_title id="cz_46579"]
	<p style="text-align: center;"><span style="font-size: 18px; font-family: Montserrat; font-weight: 300; color: #333333;">Multilingual</span></p>
	[/cz_title][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1505826669883{padding-top: 40px !important;padding-bottom: 50px !important;background-color: #dddddd !important;}"][vc_icon icon_fontawesome="fa fa-arrows" color="custom" align="center" css=".vc_custom_1505829770121{margin-bottom: 0px !important;}" custom_color="#e91e63"][cz_title id="cz_88926"]
	<p style="text-align: center;"><span style="font-size: 18px; font-family: Montserrat; font-weight: 300; color: #333333;">Drag &amp; Drop</span></p>
	[/cz_title][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3" css=".vc_custom_1505827391160{padding-top: 40px !important;padding-bottom: 50px !important;background-color: #ffffff !important;}"][vc_icon icon_fontawesome="fa fa-shopping-cart" color="custom" align="center" css=".vc_custom_1505829782558{margin-bottom: 0px !important;}" custom_color="#e91e63"][cz_title id="cz_77439"]
	<p style="text-align: center;"><span style="font-size: 18px; font-family: Montserrat; font-weight: 300; color: #333333;">Shop Ready</span></p>
	[/cz_title][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1505826669883{padding-top: 40px !important;padding-bottom: 50px !important;background-color: #dddddd !important;}"][vc_icon icon_fontawesome="fa fa-life-ring" color="custom" align="center" css=".vc_custom_1505829796344{margin-bottom: 0px !important;}" custom_color="#e91e63"][cz_title id="cz_69011"]
	<p style="text-align: center;"><span style="font-size: 18px; font-family: Montserrat; font-weight: 300; color: #333333;">24/7 Support</span></p>
	[/cz_title][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1505827413582{padding-top: 40px !important;padding-bottom: 50px !important;background-color: #ffffff !important;}"][vc_icon icon_fontawesome="fa fa-check" color="custom" align="center" css=".vc_custom_1505829812538{margin-bottom: 0px !important;}" custom_color="#e91e63"][cz_title id="cz_48066"]
	<p style="text-align: center;"><span style="font-size: 18px; font-family: Montserrat; font-weight: 300; color: #333333;">Easy to Use</span></p>
	[/cz_title][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => 'why choose us 2 columns light accordion full wide 116_jpg',
						'c' =>'[vc_row full_width="stretch_row" css=".vc_custom_1505827233535{padding-top: 60px !important;padding-bottom: 60px !important;background-color: #f5f5f5 !important;}"][vc_column width="1/2" css=".vc_custom_1505830599961{padding-right: 80px !important;}"][cz_gap height="10px" id="cz_64952"][cz_title text_center="true" id="cz_85668"]
	<div style="line-height: 1.3;"><span style="font-size: 48px; font-family: Montserrat; color: #444444;"><span style="font-weight: 200;">WHY</span> <span style="color: #7100e2;">CHOOSE</span> <span style="font-weight: 200;">US?</span></span></div>
	[/cz_title][cz_gap height="25px" id="cz_65587"][cz_free_line id="cz_42099" sk_line="height:8px;width:60px;background-color:unset !important;background-image:linear-gradient(45deg,#0066bf,#7100e2);border-radius:2px;"][cz_gap height="40px" id="cz_95886"][cz_title text_center="true" id="cz_66025"]<span style="font-size: 16px; font-family: Montserrat; font-weight: 300;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</span>[/cz_title][cz_gap height="20px" id="cz_59276"][cz_button title="Get Started" btn_position="cz_btn_left cz_mobile_btn_center" btn_effect="cz_btn_absorber" link="url:%23|||" id="cz_76983" sk_button="color:#ffffff;background-color:transparent;background-image:linear-gradient(45deg,#0066bf,#7100e2);padding-right:25px;padding-left:25px;border-radius:4px;box-shadow:0px 5px 20px rgba(0,0,0,0.25);" sk_button_mobile="margin-bottom:30px;"][/vc_column][vc_column width="1/2"][cz_accordion close_icon="fa fa-angle-up" open_icon="fa fa-angle-down" first_open="true" id="cz_87980" sk_title="background-color:rgba(255,255,255,0.49);padding-bottom:10px;padding-top:10px;color:#777777;" sk_active="background-color:#ffffff;color:#333333;" sk_content="background-color:#ffffff;" sk_open_icon="color:#7100e2;"][cz_acc_child title="Features" icon="fa fa-diamond" icon_color="#7100e2" id="cz_76216"][vc_row_inner][vc_column_inner width="1/3"][cz_stylish_list items="%5B%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22Drag%20and%20Drop%22%7D%2C%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22Responsive%22%7D%2C%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22Multilingual%22%7D%2C%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22Shop%20Ready%22%7D%5D" id="cz_93047" sk_lists="font-size:14px;" sk_icons="color:#7100e2;"][/vc_column_inner][vc_column_inner width="1/3"][cz_stylish_list items="%5B%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22Drag%20and%20Drop%22%7D%2C%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22Responsive%22%7D%2C%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22Multilingual%22%7D%2C%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22Shop%20Ready%22%7D%5D" id="cz_96435" sk_lists="font-size:14px;" sk_icons="color:#7100e2;"][/vc_column_inner][vc_column_inner width="1/3"][cz_stylish_list items="%5B%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22Drag%20and%20Drop%22%7D%2C%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22Responsive%22%7D%2C%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22Multilingual%22%7D%2C%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22Shop%20Ready%22%7D%5D" id="cz_64945" sk_lists="font-size:14px;" sk_icons="color:#7100e2;"][/vc_column_inner][/vc_row_inner][/cz_acc_child][cz_acc_child title="Benefits" icon="fa fa-bolt" icon_color="#7100e2" id="cz_99351"][vc_column_text]<span style="font-weight: 300; font-family: Montserrat;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</span>[/vc_column_text][/cz_acc_child][cz_acc_child title="Services" icon="fa fa-cog" icon_color="#7100e2" id="cz_87657"][vc_column_text]<span style="font-weight: 300; font-family: Montserrat;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</span>[/vc_column_text][/cz_acc_child][/cz_accordion][/vc_column][/vc_row][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => 'timeline history 2 columns light purple full wide 117_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_col-xs-12"][cz_title smart_fs="true" text_center="true" id="cz_53928" sk_overall="padding-right:100px;" sk_overall_tablet="padding-right:50px;" sk_overall_mobile="padding-right:10px;"]
	<p style="text-align: right;"><span style="font-size: 48px; font-family: Montserrat; color: #444444; line-height: 1.3;"><span style="font-weight: 200; display: block; font-size: 74px;">ABOUT </span><span style="color: #7100e2; display: block; font-size: 100px; font-weight: bold;">COMPANY</span><span style="font-weight: 200; font-size: 74px;"> VISIONS</span></span></p>
	[/cz_title][/vc_column][vc_column width="1/2"][cz_history_line year="2016" id="cz_74795" sk_year="color:#ffffff;background-color:#7100e2;border-style:none;" sk_circle="background-color:#7100e2;border-color:#7100e2;" sk_line="border-color:#cccccc;" sk_overall="padding-right:50px;padding-left:50px;" sk_overall_tablet="padding-right:30px;padding-left:30px;" sk_overall_mobile="padding-right:20px;padding-left:20px;"][vc_column_text]<span style="font-weight: 300; line-height: 1.5; font-size: 14px;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</span>[/vc_column_text][/cz_history_line][cz_history_line id="cz_93175" sk_year="color:#ffffff;background-color:#7100e2;border-style:none;" sk_circle="border-color:#7100e2;background-color:#7100e2;" sk_line="border-color:#cccccc;" sk_overall="padding-right:50px;padding-left:50px;" sk_overall_tablet="padding-right:30px;padding-left:30px;" sk_overall_mobile="padding-right:20px;padding-left:20px;"][vc_column_text]<span style="font-weight: 300; line-height: 1.5; font-size: 14px;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</span>[/vc_column_text][/cz_history_line][cz_history_line year="2018" id="cz_51484" sk_year="color:#ffffff;background-color:#7100e2;border-style:none;" sk_circle="background-color:#7100e2;border-color:#7100e2;" sk_line="border-color:#cccccc;" sk_overall="padding-right:50px;padding-left:50px;" sk_overall_tablet="padding-right:30px;padding-left:30px;" sk_overall_mobile="padding-right:20px;padding-left:20px;"][vc_column_text]<span style="font-weight: 300; line-height: 1.5; font-size: 14px;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</span>[/vc_column_text][/cz_history_line][cz_history_line year="2019" id="cz_71145" sk_year="color:#ffffff;background-color:#7100e2;border-style:none;" sk_circle="background-color:#7100e2;border-color:#7100e2;" sk_line="border-color:#ffffff;" sk_overall="padding-right:50px;padding-left:50px;" sk_overall_tablet="padding-right:30px;padding-left:30px;" sk_overall_mobile="padding-right:20px;padding-left:20px;"][vc_column_text]<span style="font-weight: 300; font-size: 14px;">Coming Soon</span>[/vc_column_text][/cz_history_line][/vc_column][/vc_row][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => 'service box 3 columns light box full wide brown 118_jpg',
						'c' =>'[vc_row][vc_column offset="vc_col-lg-8"][cz_title smart_fs="true" text_center="true" id="cz_46484"]<span style="font-size: 48px; font-family: Montserrat; color: #444444;"><span style="font-weight: 200; color: #dd9933;">WHAT</span> <span style="color: #956328;">WE DO?</span></span>[/cz_title][cz_gap height="20px" id="cz_80574"][vc_row_inner][vc_column_inner width="1/2" css=".vc_custom_1512034414076{padding-right: 20px !important;padding-left: 0px !important;}"][cz_service_box icon="fa fa-check-square-o" icon_fx="cz_sbi_fx_3" title="Best Service" id="cz_51848" sk_title="font-weight:500;font-size:24px;color:#956328;font-family:Montserrat;letter-spacing:-1px;" sk_icon="color:#dd9933;" sk_icon_con="margin-left:20px;margin-top:-7px;"]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666666; font-family: Montserrat; font-weight: 300;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_gap id="cz_99847"][cz_service_box icon="fa fa-globe" title="Global Design" id="cz_95257" sk_title="font-weight:500;font-size:24px;color:#956328;font-family:Montserrat;letter-spacing:-1px;" sk_icon="color:#dd9933;" sk_icon_con="margin-left:20px;margin-top:-7px;"]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; font-family: Montserrat; font-weight: 300; color: #666666;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1512034399325{padding-right: 20px !important;padding-left: 0px !important;}"][cz_service_box icon="fa fa-pencil-square-o" title="Business Plan" id="cz_59760" sk_title="font-weight:500;font-size:24px;color:#956328;font-family:Montserrat;letter-spacing:-1px;" sk_icon="color:#dd9933;" sk_icon_con="margin-left:20px;margin-top:-7px;"]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #808080; font-family: Montserrat; font-weight: 300;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_gap id="cz_60039"][cz_service_box icon="fa fa-cogs" title="Management" id="cz_82972" sk_title="font-weight:500;font-size:24px;color:#956328;font-family:Montserrat;letter-spacing:-1px;" sk_icon="color:#dd9933;" sk_icon_con="margin-left:20px;margin-top:-7px;"]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666666; font-family: Montserrat; font-weight: 300;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][/vc_column_inner][/vc_row_inner][cz_gap height="40px" id="cz_68177"][/vc_column][vc_column offset="vc_col-lg-4"][cz_image cbg="cz_bg_border cz_bg_br" cbg_color="#dd9933" image="'.$imgu.'img17.jpg" id="cz_40905"][/vc_column][/vc_row][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => 'service box 6 columns light box colorful 119_jpg',
						'c' =>'[vc_row full_height="yes" equal_height="yes" content_placement="middle"][vc_column width="1/3" offset="vc_col-lg-2 vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" height_equal="true" id="cz_36562" sk_overall="background-color:#ffffff;margin-bottom:30px;border-style:solid;border-width:1px;border-color:#cccccc;border-radius:10px;"][vc_icon icon_fontawesome="fa fa-check" color="custom" align="center" custom_color="#8e44ad" css=".vc_custom_1505838819596{margin-bottom: 0px !important;}"][cz_title id="cz_43955"]
	<p style="text-align: center;"><span style="font-size: 20px; color: #4a4a4a; line-height: 1.1;"><strong><span style="font-family: Ubuntu;">Bug Free Codes</span></strong></span></p>
	[/cz_title][/cz_content_box][/vc_column][vc_column width="1/3" offset="vc_col-lg-2 vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" height_equal="true" id="cz_27465" sk_overall="background-color:#ffffff;margin-bottom:30px;border-style:solid;border-width:1px;border-color:#cccccc;border-radius:10px;"][vc_icon icon_fontawesome="fa fa-check" color="custom" align="center" custom_color="#27ae60" css=".vc_custom_1505839144359{margin-bottom: 0px !important;}"][cz_title id="cz_76830"]
	<p style="text-align: center;"><span style="font-size: 20px; color: #4a4a4a; line-height: 1.1;"><strong><span style="font-family: Ubuntu;">Shop Ready
	</span></strong></span></p>
	[/cz_title][/cz_content_box][/vc_column][vc_column width="1/3" offset="vc_col-lg-2 vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" id="cz_21993" sk_overall="background-color:#ffffff;margin-bottom:30px;border-style:solid;border-width:1px;border-color:#cccccc;border-radius:10px;"][vc_icon icon_fontawesome="fa fa-check" color="custom" align="center" custom_color="#c0392b" css=".vc_custom_1505839264822{margin-bottom: 0px !important;}"][cz_title id="cz_88821"]
	<p style="text-align: center;"><span style="font-size: 20px; color: #4a4a4a; line-height: 1.1;"><strong><span style="font-family: Ubuntu;">Best Live Editor
	</span></strong></span></p>
	[/cz_title][/cz_content_box][/vc_column][vc_column width="1/3" offset="vc_col-lg-2 vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" height_equal="true" id="cz_48252" sk_overall="background-color:#ffffff;margin-bottom:30px;border-style:solid;border-width:1px;border-color:#cccccc;border-radius:10px;"][vc_icon icon_fontawesome="fa fa-check" color="custom" align="center" custom_color="#f1c40f" css=".vc_custom_1505839184795{margin-bottom: 0px !important;}"][cz_title id="cz_40672"]
	<p style="text-align: center;"><span style="font-size: 20px; color: #4a4a4a; line-height: 1.1;"><strong><span style="font-family: Ubuntu;">Drag &amp; Drop
	</span></strong></span></p>
	[/cz_title][/cz_content_box][/vc_column][vc_column width="1/3" offset="vc_col-lg-2 vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" id="cz_32560" sk_overall="background-color:#ffffff;margin-bottom:30px;border-style:solid;border-width:1px;border-color:#cccccc;border-radius:10px;"][vc_icon icon_fontawesome="fa fa-check" color="custom" align="center" custom_color="#e67e22" css=".vc_custom_1505839218600{margin-bottom: 0px !important;}"][cz_title id="cz_38548"]
	<p style="text-align: center;"><span style="font-size: 20px; color: #4a4a4a; line-height: 1.1;"><strong><span style="font-family: Ubuntu;">Awesome Sliders
	</span></strong></span></p>
	[/cz_title][/cz_content_box][/vc_column][vc_column width="1/3" offset="vc_col-lg-2 vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" height_equal="true" id="cz_50139" sk_overall="background-color:#ffffff;margin-bottom:30px;border-style:solid;border-width:1px;border-color:#cccccc;border-radius:10px;"][vc_icon icon_fontawesome="fa fa-check" color="custom" align="center" custom_color="#2980b9" css=".vc_custom_1505839128013{margin-bottom: 0px !important;}"][cz_title id="cz_11949"]
	<p style="text-align: center;"><span style="font-size: 20px; color: #4a4a4a; line-height: 1.1;"><strong><span style="font-family: Ubuntu;">Free Support
	</span></strong></span></p>
	[/cz_title][/cz_content_box][/vc_column][/vc_row][cz_google_font font="Ubuntu"]',
					),
					array(
						'f' => 'process box 4 columns light box full wide how work 120_jpg',
						'c' =>'[vc_row full_width="stretch_row" parallax="content-moving" css=".vc_custom_1516565200518{padding-top: 100px !important;padding-bottom: 60px !important;background-color: #f5f5f5 !important;}"][vc_column][cz_title bline="cz_line_both_side" id="cz_56267" sk_lines="background-color:rgba(15,53,119,0.39);width:30px;" sk_icon_before="border-radius:3px;background-color:#eeeeee;margin-right:10px;margin-top:4px;"]
	<p style="text-align: center;"><span style="font-size: 32px; color: #0f3577;"><strong><span style="font-family: Raleway;">How We Work?</span></strong></span></p>
	[/cz_title][cz_gap height="20px" id="cz_90477"][vc_row_inner el_class="no_padding"][vc_column_inner width="1/2" offset="vc_col-lg-3"][cz_process_road road="cz_road_rb" line_height="150px" type="number" icon_style="cz_road_icon_rhombus_2" line_border-color="rgba(15,53,119,0.3)" id="cz_62244" sk_icon="font-weight:700;font-family:Raleway;background-color:#0f3577;color:#ffffff;"][cz_service_box type="vertical" icon="fa fa-comments-o" title="Free Consultation" separator="icon" sep_icon="fa fa-sort-desc" id="cz_45093" sk_overall="background-color:#ffffff;padding:25px;margin-right:15px;margin-left:15px;border-radius:5px;" sk_title="font-weight:700;color:#0f3577;font-size:20px;" sk_icon="font-size:36px;color:#0f3577;" sk_sep="font-size:24px;color:rgba(15,53,119,0.3);" sk_overall_mobile="margin:0px;"]<span style="font-family: Raleway; color: #0f3577;">Lorem ipsum dolor sit amet, conse ctetuer adipi scing elit nam cursus orbi ut mi.</span>[/cz_service_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-3"][cz_process_road road="cz_road_hd" line_height="150px" type="number" number="2" icon_style="cz_road_icon_rhombus_2" line_border-color="rgba(15,53,119,0.3)" id="cz_41623" sk_icon="font-weight:700;font-family:Raleway;background-color:#0f3577;color:#ffffff;"][cz_service_box type="vertical" icon="fa fa-pencil-square-o" title="Sign a Contract" separator="icon" sep_icon="fa fa-sort-desc" id="cz_51466" sk_overall="background-color:#ffffff;padding:25px;margin-right:15px;margin-left:15px;border-radius:5px;" sk_title="font-weight:700;color:#0f3577;font-size:20px;" sk_icon="font-size:36px;color:#0f3577;" sk_sep="font-size:24px;color:rgba(15,53,119,0.3);" sk_overall_mobile="margin:0px;"]<span style="font-family: Raleway; color: #0f3577;">Lorem ipsum dolor sit amet, conse ctetuer adipi scing elit nam cursus orbi ut mi.</span>[/cz_service_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-3"][cz_process_road road="cz_road_hd" line_height="150px" type="number" number="3" icon_style="cz_road_icon_rhombus_2" line_border-color="rgba(15,53,119,0.3)" id="cz_73567" sk_icon="font-weight:700;font-family:Raleway;background-color:#0f3577;color:#ffffff;"][cz_service_box type="vertical" icon="fa fa-search" title="Investigation" separator="icon" sep_icon="fa fa-sort-desc" id="cz_55214" sk_overall="background-color:#ffffff;padding:25px;margin-right:15px;margin-left:15px;border-radius:5px;" sk_title="font-weight:700;color:#0f3577;font-size:20px;" sk_icon="font-size:36px;color:#0f3577;" sk_sep="font-size:24px;color:rgba(15,53,119,0.3);" sk_overall_mobile="margin:0px;"]<span style="font-family: Raleway; color: #0f3577;">Lorem ipsum dolor sit amet, conse ctetuer adipi scing elit nam cursus orbi ut mi.</span>[/cz_service_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-3"][cz_process_road road="cz_road_lb" line_height="150px" type="number" number="4" icon_style="cz_road_icon_rhombus_2" line_border-color="rgba(15,53,119,0.3)" id="cz_52334" sk_icon="font-weight:700;font-family:Raleway;background-color:#0f3577;color:#ffffff;"][cz_service_box type="vertical" icon="fa fa-gavel" title="Fight in Court" separator="icon" sep_icon="fa fa-sort-desc" id="cz_51189" sk_overall="background-color:#ffffff;padding:25px;margin-right:15px;margin-left:15px;border-radius:5px;" sk_title="font-weight:700;color:#0f3577;font-size:20px;" sk_icon="font-size:36px;color:#0f3577;" sk_sep="font-size:24px;color:rgba(15,53,119,0.3);" sk_overall_mobile="margin:0px;"]<span style="font-family: Raleway; color: #0f3577;">Lorem ipsum dolor sit amet, conse ctetuer adipi scing elit nam cursus orbi ut mi.</span>[/cz_service_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][cz_google_font font="Raleway"]',
					),
					array(
						'f' => 'light box full wide 2 columns before after 121_jpg',
						'c' =>'[vc_row][vc_column width="1/2"][cz_title bline="cz_line_right_side" text_center="true" id="cz_50727" sk_lines="background-color:#74c5da;width:8px;height:8px;top:7px;"]
	<p style="text-align: left;"><span style="font-family: inherit; color: #5dddac; font-size: 38px;"><span style="font-weight: 900; color: #74c5da;">Before </span><span style="font-weight: 100;">After</span></span></p>
	 [/cz_title][cz_free_line id="cz_58338" sk_line="height:5px;width:50px;background-color:#74c5da;"][cz_gap height="25px" id="cz_69755"][vc_column_text]Plastic surgery is a surgical specialty involving the restoration, reconstruction, or alteration of the human body. It includes cosmetic or aesthetic surgery, reconstructive surgery, craniofacial surgery, hand surgery, microsurgery, and the treatment of burns.[/vc_column_text][cz_button title="View Our Gallery" effect="cz_btn_fx_7" icon="fa fa-th" link="url:%23|||" id="cz_24788" sk_button="border-radius:5px;background-color:unset !important;background-image:linear-gradient(45deg,#74c5da,#5dddac);position:relative;float:left;" sk_hover="color:#ffffff;" sk_icon="border-radius:5px;"][/vc_column][vc_column width="1/2"][cz_before_after image_2="928" image_1="927" id="cz_17547" sk_overall="border-radius:5px;" sk_handle="color:#74c5da;background-color:#ffffff;"][/vc_column][/vc_row]',
					),
					array(
						'f' => '3 columns light testimonial quote 122_jpg',
						'c' =>'[vc_row][vc_column][cz_gap height="60px" id="cz_44727"][cz_title bline="cz_line_both_side" id="cz_75282" sk_lines="background-color:#74c5da;width:8px;height:8px;top:7px;" sk_lines_mobile="display:none;"]
	<p style="text-align: center;"><span style="font-family: inherit; color: #5dddac; font-size: 38px;"><span style="font-weight: 900; color: #74c5da;">Our </span><span style="font-weight: 100;">Happy Clients</span>
	</span></p>
	 [/cz_title][cz_gap id="cz_68955"][cz_gap height="20px" id="cz_48459"][cz_gap height="30px" id="cz_75252"][/vc_column][/vc_row][vc_row][vc_column width="1/3"][cz_testimonials name="Julia Hernandez" subname="Model" style="6" avatar="'.$imgu.'80x80.jpg" id="cz_92071" sk_content="background-color:transparent;background-image:linear-gradient(135deg,#74c5da,#5dddac);box-shadow:1px 1px 1px rgba(0,0,0,0.01);" sk_avatar="border-radius:100%;border-bottom-style:solid;border-color:#ffffff;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:10px 10px 10px 10px;" sk_name="color:#ffffff;" sk_subname="color:#ffffff;" sk_content_mobile="margin-bottom:60px;"]
	<div style="line-height: 1.3;"><span style="color: #ffffff; font-family: Poppins; font-size: 15px;">Dr. Plastic Surgery have been great at keeping me in work, they always line something else up.</span></div>
	[/cz_testimonials][/vc_column][vc_column width="1/3"][cz_testimonials name="Jane Someone" subname="Photographer" style="6" avatar="'.$imgu.'80x80.jpg" id="cz_85011" sk_content="background-color:transparent;background-image:linear-gradient(135deg,#5dddac,#74c5da);box-shadow:1px 1px 1px rgba(0,0,0,0.01);" sk_avatar="border-radius:100%;border-bottom-style:solid;border-color:#ffffff;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:10px 10px 10px 10px;" sk_name="color:#ffffff;" sk_subname="color:#ffffff;" sk_content_mobile="margin-bottom:60px;"]
	<div style="line-height: 1.3;"><span style="color: #ffffff; font-family: Poppins; font-size: 15px;">Dr. Plastic Surgery have been great at keeping me in work, they always line something else up.</span></div>
	[/cz_testimonials][/vc_column][vc_column width="1/3"][cz_testimonials name="Alexia Blackwood" subname="Housewife" style="6" avatar="'.$imgu.'80x80.jpg" id="cz_73285" sk_content="background-color:unset !important;background-image:linear-gradient(135deg,#74c5da,#5dddac);box-shadow:1px 1px 1px rgba(0,0,0,0.01) ;" sk_avatar="border-radius:100%;border-bottom-style:solid;border-color:#ffffff;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:10px 10px 10px 10px;" sk_name="color:#ffffff;" sk_subname="color:#ffffff;"]
	<div style="line-height: 1.3;"><span style="color: #ffffff; font-family: Poppins; font-size: 15px;">Dr. Plastic Surgery have been great at keeping me in work, they always line something else up.</span></div>
	[/cz_testimonials][/vc_column][/vc_row][cz_google_font font="Poppins"]',
					),
					array(
						'f' => 'service box 4 columns light box full wide odd even image 123_jpg',
						'c' =>'[vc_row full_width="stretch_row" parallax="content-moving" css=".vc_custom_1505898137855{background-image: url('.$imgu.'img53.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;padding-top: 100px !important;padding-bottom: 100px !important;background-color: #242c43 !important;}" el_class="no_padding"][vc_column width="1/2"][cz_content_box type="2" split_box_position="cz_split_box_left" fx_hover="fx_shine_hover" split_box_image="'.$imgu.'pic78.jpg" id="cz_93090" sk_overall="background-color:#ffffff;animation:fadeIn;"][cz_title bline="cz_line_after_title" text_center="true" id="cz_36457" sk_overall="margin-bottom:10px;" sk_lines="background-color:rgba(12,20,94,0.3);height:3px;top:-5px;"]
	<h4><span style="color: #0c145e;">About Us</span></h4>
	[/cz_title][vc_column_text]<span style="font-size: 14px;">Architecture is both the process and the product of planning, designing, and constructing buildings and other physical structures.</span>[/vc_column_text][cz_gap height="20px" id="cz_26225"][cz_button title="Read More" btn_position="cz_btn_right cz_mobile_btn_center" effect="cz_btn_fx_1" link="url:about%2F|||" id="cz_75875" sk_button="border-bottom-style:solid;border-color:rgba(12,20,94,0.4);border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-bottom:5px;padding-top:5px;border-width:1px 1px 1px 1px;position:relative;float:right;background-color:#ffffff;font-size:13px;color:rgba(12,20,94,0.7);" sk_hover="border-color:#0c145e;border-width:1px 1px 1px 1px;color:#0c145e;"][/cz_content_box][cz_content_box type="2" fx_hover="fx_shine_hover" split_box_image="'.$imgu.'pic79.jpg" id="cz_99968" sk_overall="background-color:#ffffff;animation:fadeIn;"][cz_title bline="cz_line_after_title" text_center="true" id="cz_78984" sk_overall="margin-bottom:10px;" sk_lines="background-color:rgba(12,20,94,0.3);height:3px;top:-5px;"]
	<h4><span style="color: #0c145e;">Careers</span></h4>
	[/cz_title][vc_column_text]<span style="font-size: 14px;">Architecture is both the process and the product of planning, designing, and constructing buildings and other physical structures.</span>[/vc_column_text][cz_gap height="20px" id="cz_13796"][cz_button title="Apply Now" btn_position="cz_btn_right cz_mobile_btn_center" effect="cz_btn_fx_1" link="url:%23|||" id="cz_65727" sk_button="border-bottom-style:solid;border-color:rgba(12,20,94,0.4);border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-bottom:5px;padding-top:5px;border-width:1px 1px 1px 1px;position:relative;float:right;background-color:#ffffff;font-size:13px;color:rgba(12,20,94,0.7);" sk_hover="border-color:#0c145e;border-width:1px 1px 1px 1px;color:#0c145e;"][/cz_content_box][/vc_column][vc_column width="1/2"][cz_content_box type="2" split_box_position="cz_split_box_left" fx_hover="fx_shine_hover" split_box_image="'.$imgu.'pic80.jpg" id="cz_61625" sk_overall="background-color:#ffffff;animation:fadeIn;"][cz_title bline="cz_line_after_title" text_center="true" id="cz_31566" sk_overall="margin-bottom:10px;" sk_lines="background-color:rgba(12,20,94,0.3);height:3px;top:-5px;"]
	<h4><span style="color: #0c145e;">Our Projects</span></h4>
	[/cz_title][vc_column_text]<span style="font-size: 14px;">Architecture is both the process and the product of planning, designing, and constructing buildings and other physical structures.</span>[/vc_column_text][cz_gap height="20px" id="cz_83611"][cz_button title="View Portfolio" btn_position="cz_btn_right cz_mobile_btn_center" effect="cz_btn_fx_1" link="url:%23|||" id="cz_23304" sk_button="border-bottom-style:solid;border-color:rgba(12,20,94,0.4);border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-bottom:5px;padding-top:5px;border-width:1px 1px 1px 1px;position:relative;float:right;background-color:#ffffff;font-size:13px;color:rgba(12,20,94,0.7);" sk_hover="border-color:#0c145e;border-width:1px 1px 1px 1px;color:#0c145e;"][/cz_content_box][cz_content_box type="2" fx_hover="fx_shine_hover" split_box_image="'.$imgu.'pic79.jpg" id="cz_52160" sk_overall="background-color:#ffffff;animation:fadeIn;"][cz_title bline="cz_line_after_title" text_center="true" id="cz_57122" sk_overall="margin-bottom:10px;" sk_lines="background-color:rgba(12,20,94,0.3);height:3px;top:-5px;"]
	<h4><span style="color: #0c145e;">We are social
	</span></h4>
	[/cz_title][vc_column_text]<span style="font-size: 14px;">Architecture is both the process and the product of planning, designing, and constructing buildings and other physical structures.</span>[/vc_column_text][cz_gap height="20px" id="cz_81290"][cz_button title="Join us!" btn_position="cz_btn_right cz_mobile_btn_center" effect="cz_btn_fx_1" link="url:about%2F|||" id="cz_85120" sk_button="border-bottom-style:solid;border-color:rgba(12,20,94,0.4);border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-bottom:5px;padding-top:5px;border-width:1px 1px 1px 1px;position:relative;float:right;background-color:#ffffff;font-size:13px;color:rgba(12,20,94,0.7);" sk_hover="border-color:#0c145e;border-width:1px 1px 1px 1px;color:#0c145e;"][/cz_content_box][/vc_column][/vc_row]',
					),
					array(
						'f' => '3 columns dark team member carousel full wide 124_jpg',
						'c' =>'[vc_row full_width="stretch_row" parallax="content-moving" parallax_speed_bg="3" css=".vc_custom_1505898540157{background-image: url('.$imgu.'img53.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;padding-top: 100px !important;padding-bottom: 100px !important;background-color: #172240 !important;}"][vc_column][cz_title css_animation="fadeInDown" id="cz_63592" sk_overall="margin-top:-30px;"]
	<p style="text-align: center;"><span style="color: #808080;">Our Experts</span></p>

	<h3 style="text-align: center;"><span style="color: #ffffff;"><strong>Our Team</strong></span></h3>
	[/cz_title][cz_gap id="cz_94638"][cz_carousel speed="2000" prev_icon="fa fa-angle-left" next_icon="fa fa-angle-right" slidestoshow_tablet="1" infinite="true" centermode="true" arrows_show_on_hover="true" greyscale="true" gap="20px" id="cz_81037" sk_prev_icon="font-size:16px;color:#ffffff;background-color:rgba(255,255,255,0.01);border-style:solid;border-color:rgba(255,255,255,0.31);border-radius:1px;" sk_next_icon="font-size:16px;color:#ffffff;background-color:rgba(255,255,255,0.01);border-style:solid;border-color:rgba(255,255,255,0.31);border-radius:1px;" sk_slides="scale:0.8;opacity:1;" sk_center="scale:1;" sk_prev_icon_mobile="background-color:#172240 !important;margin-left:30px;border-style:none;" sk_next_icon_mobile="background-color:#172240;margin-right:30px;border-style:none;"][cz_team style="cz_team_2" image="'.$imgu.'450x450.jpg" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22%23%22%7D%5D" id="cz_55560"]
	<h4><span style="color: #ffffff;"><strong>John Doe</strong></span></h4>
	<span style="color: #ffffff;">Architect</span>[/cz_team][cz_team style="cz_team_2" image="'.$imgu.'450x450.jpg" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-dribbble%22%2C%22link%22%3A%22%23%22%7D%5D" id="cz_78908"]
	<h4><span style="color: #ffffff;"><strong>Mark Smith</strong></span></h4>
	<span style="color: #ffffff;">Designer</span>[/cz_team][cz_team style="cz_team_2" image="'.$imgu.'450x450.jpg" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22link%22%3A%22%23%22%7D%5D" id="cz_57510"]
	<h4><span style="color: #ffffff;"><strong>Alexander Wood</strong></span></h4>
	<span style="color: #ffffff;">Architect</span>[/cz_team][cz_team style="cz_team_2" image="'.$imgu.'450x450.jpg" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22link%22%3A%22%23%22%7D%5D" id="cz_97347"]
	<h4><span style="color: #ffffff;"><strong>Kevin Karamano</strong></span></h4>
	<span style="color: #ffffff;">Manager</span>[/cz_team][/cz_carousel][/vc_column][/vc_row]',
					),
					array(
						'f' => 'world map agent hotspot 125_jpg',
						'c' =>'[vc_row][vc_column][cz_gap height="80px" id="cz_35279"][cz_title id="cz_87177"]
	<h3 style="text-align: center;"><span style="color: #54aa22;">Where to buy?</span></h3>
	[/cz_title][cz_gap id="cz_90703"][cz_image image="'.$imgu.'world.png" id="cz_62408"][cz_hotspot icon="fa fa-shopping-cart" position="cz_hotspot_top cz_hotspot_tl" css_top="69.55419745746913%" css_left="90.33333460489908%" id="cz_58960" sk_icon="color:#ece425;background-color:#54aa22;" sk_icon_mobile="display:none;"]
	<h4><span style="color: #54aa22;">Australia</span></h4>
	<span style="color: #54aa22;"><span style="color: #808080;">Address: <strong>Some address in some place</strong></span></span>
	<span style="color: #54aa22;"><span style="color: #808080;">Tel: <strong>+1800-123456</strong></span></span>

	[/cz_hotspot][cz_hotspot icon="fa fa-shopping-cart" css_top="44.34244632720947%" css_left="79.66666793823242%" id="cz_35480" sk_icon="color:#ece425;background-color:#54aa22;" sk_icon_mobile="display:none;"]
	<h4><span style="color: #54aa22;"> Asia &amp; East</span></h4>
	<span style="color: #54aa22;"><span style="color: #808080;">Address: <strong>Some address in some place</strong></span></span>
	<span style="color: #54aa22;"><span style="color: #808080;">Tel: <strong>+1800-123456</strong></span></span>

	[/cz_hotspot][cz_hotspot icon="fa fa-shopping-cart" position="cz_hotspot_top cz_hotspot_tr" css_top="43.355033795038864%" css_left="61.25000127156576%" id="cz_98178" sk_icon="color:#ece425;background-color:#54aa22;" sk_icon_mobile="display:none;"]
	<h4><span style="color: #54aa22;">Middle East</span></h4>
	<span style="color: #54aa22;"><span style="color: #808080;">Address: <strong>Some address in some place</strong></span></span>
	<span style="color: #54aa22;"><span style="color: #808080;">Tel: <strong>+1800-123456</strong></span></span>

	[/cz_hotspot][cz_hotspot icon="fa fa-shopping-cart" css_top="69.62239543596903%" css_left="25.000001271565754%" id="cz_81745" sk_icon="color:#ece425;background-color:#54aa22;" sk_icon_mobile="display:none;"]
	<h4><span style="color: #54aa22;">South America
	</span></h4>
	<span style="color: #54aa22;"><span style="color: #808080;">Address: <strong>Some address in some place</strong></span></span>
	<span style="color: #54aa22;"><span style="color: #808080;">Tel: <strong>+1800-123456</strong></span></span>

	[/cz_hotspot][cz_hotspot icon="fa fa-shopping-cart" position="cz_hotspot_right" css_top="31.992189089457195%" css_left="12.833334604899088%" id="cz_66762" sk_icon="color:#ece425;background-color:#54aa22;" sk_icon_mobile="display:none;"]
	<h4><span style="color: #54aa22;">Canada
	</span></h4>
	<span style="color: #54aa22;"><span style="color: #808080;">Address: <strong>Some address in some place</strong></span></span>
	<span style="color: #54aa22;"><span style="color: #808080;">Tel: <strong>+1800-123456</strong></span></span>

	[/cz_hotspot][cz_hotspot icon="fa fa-shopping-cart" position="cz_hotspot_bottom cz_hotspot_br" css_top="42.955728371938065%" css_left="9.250001271565756%" id="cz_64919" sk_icon="color:#ece425;background-color:#54aa22;" sk_icon_mobile="display:none;"]
	<h4><span style="color: #54aa22;">North America
	</span></h4>
	<span style="color: #54aa22;"><span style="color: #808080;">Address: <strong>Some address in some place</strong></span></span>
	<span style="color: #54aa22;"><span style="color: #808080;">Tel: <strong>+1800-123456</strong></span></span>

	[/cz_hotspot][cz_hotspot icon="fa fa-shopping-cart" css_top="61.2217903137207%" css_left="56.333334604899086%" id="cz_38155" sk_icon="color:#ece425;background-color:#54aa22;" sk_icon_mobile="display:none;"]
	<h4><span style="color: #54aa22;">Africa
	</span></h4>
	<span style="color: #54aa22;"><span style="color: #808080;">Address: <strong>Some address in some place</strong></span></span>
	<span style="color: #54aa22;"><span style="color: #808080;">Tel: <strong>+1800-123456</strong></span></span>

	[/cz_hotspot][cz_hotspot icon="fa fa-shopping-cart" css_top="33.6718458711241%" css_left="51.833334604899086%" id="cz_50993" sk_icon="color:#ece425;background-color:#54aa22;" sk_icon_mobile="display:none;"]
	<h4><span style="color: #54aa22;">Europe</span></h4>
	<span style="color: #54aa22;"><span style="color: #808080;">Address: <strong>Some address in some place</strong></span></span>
	<span style="color: #54aa22;"><span style="color: #808080;">Tel: <strong>+1800-123456</strong></span></span>

	[/cz_hotspot][cz_button title="Shop Online Now" btn_position="cz_btn_center" effect="cz_btn_fx_12" icon="fa fa-shopping-cart" link="url:shop%2F|||" id="cz_96315" sk_button="color:#4c4c4c;background-color:#ece425;margin:0 auto;border-radius:5px;" sk_hover="color:#ffffff;background-color:#54aa22;" sk_button_mobile="margin-top:30px;" cz_button=""][cz_gap id="cz_98947"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'service box 4 columns box hexagonal construction 126_jpg',
						'c' =>'[vc_row][vc_column][cz_title bline="cz_line_after_title" id="cz_14736" sk_lines="background-color:#f5b904;height:5px;top:-75px;"]
	<h2 style="text-align: center;"><span style="line-height: 1.5; color: #000;">Our Services</span></h2>
	&nbsp;
	<p style="text-align: center;"><span style="color: #999999; line-height: 1.5;">What We Do?
	</span></p>
	[/cz_title][/vc_column][/vc_row][vc_row][vc_column width="1/4"][cz_service_box type="vertical" icon="fa fa-wrench" title="Renovation" id="cz_78796" class="cz_slanted_br" sk_overall="background-color:#f5b904;padding-bottom:105px;" sk_title="color:#000000;" sk_icon="font-size:36px;color:#000000;" sk_title_tablet="font-size:16px;" sk_title_mobile="font-size:24px;" sk_overall_mobile="margin-bottom:30px;"]
	<div style="line-height: 1.3;"><span style="font-size: 14px; color: #041c3f;">Construction is the process of constructing a building or infrastructure.</span></div>
	[/cz_service_box][/vc_column][vc_column width="1/4"][cz_service_box type="vertical" icon="fa fa-map" title="Planning" id="cz_77180" class="cz_slanted_br" sk_overall="background-color:#f5b904;padding-bottom:80px;" sk_title="color:#000000;" sk_icon="font-size:36px;color:#000000;" sk_title_tablet="font-size:16px;" sk_title_mobile="font-size:24px;" sk_overall_mobile="margin-bottom:30px;"]
	<div style="line-height: 1.3;"><span style="font-size: 14px;">Construction is the process of constructing a building or infrastructure.</span></div>
	[/cz_service_box][/vc_column][vc_column width="1/4"][cz_service_box type="vertical" icon="fa fa-building" title="Construction" id="cz_27755" class="cz_slanted_bl" sk_overall="background-color:#f5b904;padding-bottom:105px;" sk_title="color:#000000;" sk_icon="font-size:36px;color:#000000;" sk_title_tablet="font-size:16px;" sk_title_mobile="font-size:24px;" sk_overall_mobile="margin-bottom:30px;"]
	<div style="line-height: 1.3;"><span style="font-size: 14px; color: #041c3f;">Construction is the process of constructing a building or infrastructure.</span></div>
	[/cz_service_box][/vc_column][vc_column width="1/4"][cz_service_box type="vertical" icon="fa fa-building-o" title="Architecture" id="cz_80433" class="cz_slanted_bl" sk_overall="background-color:#f5b904;padding-bottom:105px;" sk_title="color:#000000;" sk_icon="font-size:36px;color:#000000;" sk_title_tablet="font-size:16px;" sk_title_mobile="font-size:24px;" sk_overall_mobile="margin-bottom:30px;"]
	<div style="line-height: 1.3;"><span style="font-size: 14px; color: #041c3f;">Construction is the process of constructing a building or infrastructure.</span></div>
	[/cz_service_box][/vc_column][/vc_row]',
					),
					array(
						'f' => 'about 2 columns light contruction image 127_jpg',
						'c' =>'[vc_row][vc_column width="1/2"][cz_title bline="cz_line_left_side" id="cz_13533" sk_lines="background-color:#f5b904;width:4px;height:60px;top:-1px;left:0px;"]
	<h3 style="text-align: left;"><span style="color: #000000;">About Us</span></h3>
	<p style="text-align: left;"><span style="color: #999999;">Who We Are?</span></p>
	[/cz_title][cz_gap height="25px" id="cz_59733"][vc_column_text]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 14px;">Construction is the process of constructing a building or infrastructure. Construction differs from manufacturing in that manufacturing typically involves mass production of similar items without a designated purchaser, while construction typically takes place on location for a known client. Construction as an industry comprises six to nine percent of the gross domestic product of developed countries. Construction starts with planning, design, and financing; and continues until the project is built and ready for use.</span></div>
	[/vc_column_text][cz_button title="Read more" icon_position="after" effect="cz_btn_fx_7" link="url:%23|||" icon="fa fa-long-arrow-right" id="cz_23189" sk_button="border-color:#f5b904;padding:7px 15px 7px 15px;border-width:0px 0px 0px 5px;position:relative;float:left;color:#ffffff;background-color:#000000;font-size:14px;" sk_hover="border-left-style:solid;border-color:#f5b904;border-left-width:10px;" sk_icon="color:rgba(255,255,255,0.51);"][/vc_column][vc_column width="1/2"][cz_image image="'.$imgu.'pic3.jpg" id="cz_14866" sk_css_mobile="margin-top:40px;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'clients sponsors 2 columns testimonial quote carousel light construction 128_jpg',
						'c' =>'[vc_row][vc_column width="1/2" css=".vc_custom_1501953592590{padding-right: 30px !important;}"][cz_gap height="80px" id="cz_48584"][cz_title bline="cz_line_left_side" id="cz_90628" sk_lines="background-color:#f5b904;width:4px;height:60px;top:-1px;left:0px;"]
	<h3 style="text-align: left;"><span style="color: #000000;">Our Clients</span></h3>
	<p style="text-align: left;"><span style="color: #999999;">Who Are Satisfy?</span></p>
	[/cz_title][cz_gap height="30px" id="cz_89828"][vc_row_inner][vc_column_inner width="1/3"][cz_image image="'.$imgu.'client.png" id="cz_88508" sk_css="padding:15px;margin-bottom:35px;border-style:solid;border-width:1px;border-color:#dddddd;"][/vc_column_inner][vc_column_inner width="1/3"][cz_image image="'.$imgu.'client.png" id="cz_26192" sk_css="padding:15px;margin-bottom:35px;border-style:solid;border-width:1px;border-color:#dddddd;"][/vc_column_inner][vc_column_inner width="1/3"][cz_image image="'.$imgu.'client.png" id="cz_99497" sk_css="padding:15px;margin-bottom:35px;border-style:solid;border-width:1px;border-color:#dddddd;"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3"][cz_image image="'.$imgu.'client.png" id="cz_38193" sk_css="padding:15px;margin-bottom:35px;border-style:solid;border-width:1px;border-color:#dddddd;"][/vc_column_inner][vc_column_inner width="1/3"][cz_image image="'.$imgu.'client.png" id="cz_60014" sk_css="padding:15px;margin-bottom:35px;border-style:solid;border-width:1px;border-color:#dddddd;"][/vc_column_inner][vc_column_inner width="1/3"][cz_image image="'.$imgu.'client.png" id="cz_96311" sk_css="padding:15px;margin-bottom:35px;border-style:solid;border-width:1px;border-color:#dddddd;"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" css=".vc_custom_1501953576061{padding-left: 30px !important;}"][cz_gap height="80px" id="cz_98170"][cz_title bline="cz_line_left_side" id="cz_46403" sk_lines="background-color:#f5b904;width:4px;height:60px;top:-1px;left:0px;"]
	<h3 style="text-align: left;"><span style="color: #000000;">Happy Clients</span></h3>
	<p style="text-align: left;"><span style="color: #999999;">What Our Clients Say?</span></p>
	[/cz_title][cz_gap height="30px" id="cz_58956"][cz_carousel slidestoshow="1" autoplayspeed="3000" arrows_position="arrows_br" dots_style="dots_square" slidestoshow_tablet="1" infinite="true" autoplay="true" arrows_inner="true" arrows_show_on_hover="true" id="cz_86457" sk_prev_icon="font-size:12px;color:#f5b904;background-color:#000000;" sk_next_icon="font-size:12px;color:#f5b904;background-color:#000000;"][cz_testimonials name="Jane Carter" arrow="cz_testimonials_bottom_arrow" arrow_background="rgba(4,28,63,0.08)" avatar="'.$imgu.'80x80.jpg" id="cz_25145" sk_content="background-color:rgba(4,28,63,0.08);"]
	<div style="line-height: 1.3;"><span style="font-size: 15px;">Codevz have been great at keeping me in work, they always line something else up.</span></div>
	[/cz_testimonials][cz_testimonials name="Jennifer Hernandez" subname="Interior Designer" arrow="cz_testimonials_bottom_arrow" arrow_background="rgba(4,28,63,0.08)" avatar="'.$imgu.'80x80.jpg" id="cz_40570" sk_content="background-color:rgba(4,28,63,0.08);"]
	<div style="line-height: 1.3;"><span style="font-size: 15px;">Codevz have been great at keeping me in work, they always line something else up.</span></div>
	[/cz_testimonials][cz_testimonials name="Emily Brown" subname="Interior Designer" arrow="cz_testimonials_bottom_arrow" arrow_background="rgba(4,28,63,0.08)" avatar="'.$imgu.'80x80.jpg" id="cz_41232" sk_content="background-color:rgba(4,28,63,0.08);"]
	<div style="line-height: 1.3;"><span style="font-size: 15px;">Codevz have been great at keeping me in work, they always line something else up.</span></div>
	[/cz_testimonials][/cz_carousel][/vc_column][/vc_row]',
					),
					array(
						'f' => 'about 3 columns green full wide social icons 129_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1505855783460{margin-top: -40px !important;padding-top: 30px !important;padding-bottom: 30px !important;background-color: #00e676 !important;}"][vc_column width="1/3" css=".vc_custom_1505855805433{padding-right: 60px !important;}"][cz_gap height="40px" id="cz_24345"][cz_title text_center="true" id="cz_38321"]
	<div style="line-height: 1; text-align: right;"><span style="font-size: 66px; color: #000000; font-weight: 100; font-family: Quicksand;">WHO</span></div>
	<div style="line-height: 1; text-align: right;"><span style="font-size: 66px; color: #000000; font-weight: 100; font-family: Quicksand;">WE</span></div>
	<div style="line-height: 1; text-align: right;"><span style="font-size: 66px; color: #000000; font-weight: 100; font-family: Quicksand;">ARE?</span></div>
	[/cz_title][cz_gap height="40px" id="cz_85206"][/vc_column][vc_column width="1/3" css=".vc_custom_1505856041955{padding-left: 30px !important;}"][cz_gap height="40px" id="cz_97417"][vc_column_text]
	<p style="text-align: justify;">An advertising agency, often referred to as a creative agency, is a business dedicated to creating, planning, and handling advertising and sometimes other forms of promotion and marketing for its clients.</p>
	[/vc_column_text][cz_button title="Read More" btn_position="cz_btn_left cz_mobile_btn_center" icon_position="after" effect="cz_btn_fx_7" icon="fa fa-long-arrow-right" link="url:%23|||" id="cz_60533" sk_button="border-radius:100px;border-bottom-style:solid;border-color:#000000;border-top-style:solid;border-right-style:solid;border-left-style:solid;background-color:#00e676;padding:5px 20px 7px 20px;border-width:3px 3px 3px 3px;font-weight:700;position:relative;float:left;color:#000000;font-size:14px;" sk_hover="background-color:#000000;color:#00e676;"][/vc_column][vc_column width="1/3" css=".vc_custom_1505856064928{padding-right: 100px !important;}"][cz_gap height="40px" id="cz_64754"][cz_social_icons position="tac" fx="cz_social_fx_9" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-dribbble%22%2C%22title%22%3A%22Dribbble%22%2C%22link%22%3A%22%23%22%7D%5D" id="cz_48999" sk_icons="border-radius:100px;border-bottom-style:solid;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:3px 3px 3px 3px;margin-left:10px;margin-right:10px;" sk_hover="border-bottom-style:solid;border-color:#000000;border-top-style:solid;border-right-style:solid;border-left-style:solid;background-color:#000000;border-width:3px 3px 3px 3px;color:#00e676;"][cz_gap height="20px" id="cz_60971"][cz_social_icons position="tac" fx="cz_social_fx_9" social="%5B%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22title%22%3A%22Linkedin%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-skype%22%2C%22title%22%3A%22Skype%22%2C%22link%22%3A%22%23%22%7D%5D" id="cz_35144" sk_icons="border-radius:100px;border-bottom-style:solid;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:3px 3px 3px 3px;margin-left:10px;margin-right:10px;" sk_hover="border-bottom-style:solid;border-color:#000000;border-top-style:solid;border-right-style:solid;border-left-style:solid;background-color:#000000;border-width:3px 3px 3px 3px;color:#00e676;"][cz_gap height="20px" id="cz_55827"][cz_social_icons position="tac" fx="cz_social_fx_9" social="%5B%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22title%22%3A%22Instagram%22%2C%22link%22%3A%22%23%22%7D%5D" id="cz_84727" sk_icons="border-radius:100px;border-bottom-style:solid;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:3px 3px 3px 3px;margin-left:10px;margin-right:10px;" sk_hover="border-bottom-style:solid;border-color:#000000;border-top-style:solid;border-right-style:solid;border-left-style:solid;background-color:#000000;border-width:3px 3px 3px 3px;"][/vc_column][/vc_row][cz_google_font font="Quicksand"]',
					),
					array(
						'f' => 'progress bar skills 2 columns testimonial quote carousel light 130_jpg',
						'c' =>'[vc_row full_width="stretch_row"][vc_column width="1/2" css=".vc_custom_1502889302465{padding-right: 40px !important;padding-left: 40px !important;}"][cz_gap height="80px" id="cz_64290"][cz_title icon_before_type="icon" icon="fa fa-dot-circle-o" id="cz_97135" sk_overall="margin-left:-20px;" sk_icon_before="color:#00e676;font-size:28px;"]
	<h3><span style="color: #000000;">What is our Skills?</span></h3>
	[/cz_title][cz_gap height="20px" id="cz_80991"][cz_progress_bar title="Branding" number="93%" icon="fa fa-dot-circle-o" id="cz_70884" sk_icon="color:#00e676;" sk_title="font-weight:500;font-size:20px;" sk_num="color:#00e676;font-size:18px;" sk_bar="border-radius:30px;"][cz_gap height="10px" id="cz_78098"][cz_progress_bar title="Advertisement" number="87%" icon="fa fa-dot-circle-o" id="cz_12675" sk_icon="color:#00e676;" sk_title="font-weight:500;font-size:20px;" sk_num="color:#00e676;font-size:18px;" sk_bar="border-radius:30px;"][cz_gap height="10px" id="cz_93257"][cz_progress_bar title="Copyrighting" icon="fa fa-dot-circle-o" id="cz_79221" sk_icon="color:#00e676;" sk_title="font-weight:500;font-size:20px;" sk_num="color:#00e676;font-size:18px;" sk_bar="border-radius:30px;"][cz_gap height="10px" id="cz_66083"][cz_progress_bar title="Graphic &amp; Web Design" number="100%" icon="fa fa-dot-circle-o" id="cz_14549" sk_icon="color:#00e676;" sk_title="font-weight:500;font-size:20px;" sk_num="color:#00e676;font-size:18px;" sk_bar="border-radius:30px;"][cz_gap height="10px" id="cz_83795"][/vc_column][vc_column width="1/2"][cz_gap height="80px" id="cz_57267"][cz_title icon_before_type="icon" icon="fa fa-dot-circle-o" id="cz_95152" sk_icon_before="color:#00e676;font-size:28px;"]
	<h3><span style="color: #000000;">What they said?</span></h3>
	[/cz_title][cz_gap height="30px" id="cz_43360"][cz_carousel slidestoshow="1" autoplayspeed="3000" arrows_position="no_arrows" dots_position="dots_bc" dots_style="dots_circle" slidestoshow_tablet="1" vertical="true" autoplay="true" gap="20px" id="cz_92713"][cz_testimonials name="Jane Carter" subname="CEO of Company" arrow="cz_testimonials_bottom_arrow" arrow_background="#00e676" avatar="'.$imgu.'80x80.jpg" id="cz_76882" sk_content="border-radius:15px 15px 15px 0;background-color:#00e676;"]Codevz have been great at keeping me in work, they always line something else up.[/cz_testimonials][cz_testimonials name="Marry Someone" subname="Manager" arrow="cz_testimonials_bottom_arrow" arrow_background="#00e676" avatar="'.$imgu.'80x80.jpg" id="cz_88366" sk_content="border-radius:15px 15px 15px 0;background-color:#00e676;"]Nothing comes from nothing. You must continuously feed the inner beast that sparks and inspires.[/cz_testimonials][cz_testimonials arrow="cz_testimonials_bottom_arrow" arrow_background="#00e676" avatar="'.$imgu.'80x80.jpg" id="cz_35368" sk_content="border-radius:15px 15px 15px 0;background-color:#00e676;"]Advertising is the ability to sense, interpret . . . to put the very heart throbs of a business into type, paper and ink[/cz_testimonials][/cz_carousel][/vc_column][/vc_row]',
					),
					array(
						'f' => '3 columns contact address phone book now working hours dark 131_jpg',
						'c' =>'[vc_row equal_height="yes" css=".vc_custom_1517147245558{margin-top: -115px !important;background-color: #ffffff !important;}" el_class="no_padding"][vc_column width="1/3" offset="vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_shine_hover" id="cz_36720" sk_overall="background-color:#3d474e;"][cz_title icon_before_type="icon" icon="fa fa-clock-o" id="cz_28640" sk_icon_before="margin-right:20px;color:#3d474e;background-color:rgba(255,255,255,0.5);font-size:24px;"]<span style="line-height: 1.4;"><span style="font-size: 24px; color: #ffffff; display: block;"><strong><span style="font-family: Playfair Display;">Working Hours</span></strong></span><span style="font-family: inherit; color: #ffffff; font-size: 15px;">Mon - Fri 9:00 to 21:00</span></span>[/cz_title][/cz_content_box][/vc_column][vc_column width="1/3" offset="vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_shine_hover" id="cz_49804" sk_overall="background-color:rgba(61,71,78,0.85);"][cz_title icon_before_type="icon" icon="fa fa-map-marker" id="cz_76796" sk_icon_before="margin-right:20px;color:#3d474e;background-color:rgba(255,255,255,0.5);font-size:24px;"]<span style="font-size: 24px; color: #ffffff; display: block; line-height: 1.4;"><strong><span style="font-family: Playfair Display;">Location</span></strong></span><span style="font-family: inherit; color: #ffffff; line-height: 1.4; font-size: 14px;">#23, unit 5 Some Ave, NY 90054</span>[/cz_title][/cz_content_box][/vc_column][vc_column width="1/3" offset="vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_shine_hover" id="cz_77430" sk_overall="background-color:rgba(61,71,78,0.73);animation:none;"][cz_title icon_before_type="icon" icon="fa fa-phone" id="cz_62781" sk_icon_before="margin-right:20px;color:#3d474e;background-color:rgba(255,255,255,0.5);font-size:24px;"]<span style="font-size: 24px; color: #ffffff; display: block; line-height: 1.4;"><strong><span style="font-family: Playfair Display;">Book Now</span></strong></span><span style="font-family: inherit; color: #ffffff; line-height: 1.4;">Call Us: +1 (800) 333 44 55</span>[/cz_title][/cz_content_box][/vc_column][/vc_row][cz_google_font font="Playfair Display"]',
					),
					array(
						'f' => 'about 2 columns light 132_jpg',
						'c' =>'[vc_row full_width="stretch_row" css=".vc_custom_1505925557108{padding-top: 50px !important;padding-bottom: 80px !important;background-color: #f5f5f5 !important;}"][vc_column width="1/3"][cz_gradient_title smart_fs="true" bg_mode="image" id="cz_55590" sk_css="background-color:transparent;background-image:linear-gradient(45deg,#000000,#8e8e8e,#000000);"]
	<div style="line-height: 1; text-align: center; margin-top: -40px;"><span style="font-size: 90px;"><strong><span style="font-family: Playfair Display;"><span style="font-size: 3em;">15 </span><span style="font-size: 86px;">Years</span></span></strong></span></div>
	<div style="line-height: 1;"></div>
	[/cz_gradient_title][/vc_column][vc_column width="2/3"][cz_gap height="45px" id="cz_71899"][cz_title bline="cz_line_after_title" css_animation="fadeIn" text_center="true" id="cz_38310" sk_lines_con="top:10px;" sk_lines="background-color:#000000;top:0px;"]
	<h3><span style="color: #000000; font-family: Playfair Display;">About Me &amp; Barber Shop</span></h3>
	[/cz_title][cz_gap height="40px" id="cz_75745"][vc_column_text css_animation="fadeInUp"]
	<p style="text-align: justify;">A hairstyle or haircut refers to the styling of hair, usually on the human scalp. Sometimes, this could also mean an editing of beard hair. The fashioning of hair can be considered an aspect of personal grooming, fashion, and cosmetics.</p>
	[/vc_column_text][cz_button title="Read More" btn_position="cz_btn_left cz_mobile_btn_center" btn_effect="cz_btn_fill_up" link="url:%23|||" id="cz_28218" sk_button="border-bottom-style:solid;border-color:#000000;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding-bottom:4px;padding-top:4px;border-width:2px 2px 2px 2px;animation:fadeInRight;position:relative;float:right;background-color:rgba(255,255,255,0.01);color:#000000;font-family:Playfair Display;" sk_hover="color:#ffffff;background-color:#000000;"][/vc_column][/vc_row][cz_google_font font="Playfair Display"]',
					),
					array(
						'f' => 'about 2 columns minimal black 133_jpg',
						'c' =>'[vc_row][vc_column width="1/2" css=".vc_custom_1506005312941{padding-right: 40px !important;}"][cz_title bline="cz_line_after_title" id="cz_50499" sk_lines="background-color:#cccccc;width:50px;height:6px;top:8px;"]
	<h3 style="text-align: left;"><span style="font-family: Montserrat; color: #333333;">About Us</span></h3>
	[/cz_title][cz_gap height="40px" id="cz_89027"][vc_column_text]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 14px; font-weight: 300; font-family: Montserrat; line-height: 1.5;">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id, condimentum at, laoreet mattis, massa. Sed eleifend nonummy diam. Praesent mauris ante, elementum et, bibendum at, posuere sit amet, nibh. Duis tincidunt lectus quis dui viverra vestibulum. Suspendisse vulputate aliquam dui. Nulla elementum dui ut augue. Aliquam vehicula mi at mauris. Maecenas placerat.</span></div>
	[/vc_column_text][cz_gap height="10px" id="cz_56895"][cz_button title="Read more" text_effect="cz_btn_show_hidden_icon" icon_position="after" effect="cz_btn_fx_7" link="url:%23|||" icon="fa fa-long-arrow-right" id="cz_60657" sk_button="padding:7px 15px 7px 15px;border-bottom-width:0px;border-right-width:0px;border-top-width:0px;font-weight:300;color:#ffffff;background-color:#000000;font-size:13px;" sk_icon="color:rgba(255,255,255,0.51);"][/vc_column][vc_column width="1/2"][cz_image image_opacity="op_3" image="'.$imgu.'pic70.jpg" id="cz_42370" sk_css="background-color:#000000;"][/vc_column][/vc_row][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => 'services 4 columns black minimal box 134_jpg',
						'c' =>'[vc_row][vc_column][cz_title bline="cz_line_after_title" id="cz_15837" sk_lines="background-color:#cccccc;width:50px;height:6px;top:5px;"]
	<h3 style="text-align: center;"><span style="font-family: Montserrat; color: #333333;">Our Services
	</span></h3>
	[/cz_title][cz_gap id="cz_24804"][/vc_column][/vc_row][vc_row][vc_column width="1/2" offset="vc_col-lg-3 vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_45306" sk_overall="background-size:cover;background-image:linear-gradient(0deg,rgba(0,0,0,0.9),rgba(0,0,0,0.9)),url('.$imgu.'pic70.jpg);padding-top:5px;padding-bottom:35px;margin-bottom:30px;"][cz_service_box type="vertical" icon="fa fa-pagelines" title="Eco Friendly" id="cz_30252" sk_title="font-size:24px;color:#ffffff;" sk_icon="font-size:36px;color:#999999;"]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_button title="Read More" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_84722" sk_button="background-color:#999999;padding-left:20px;padding-right:20px;padding-top:5px;margin-bottom:0px;margin-top:10px;font-weight:400;font-size:13px;color:#000000;" sk_hover="background-color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3 vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_92772" sk_overall="background-size:cover;background-image:linear-gradient(0deg,rgba(0,0,0,0.9),rgba(0,0,0,0.9)),url('.$imgu.'pic70.jpg);padding-top:5px;padding-bottom:35px;margin-bottom:30px;"][cz_service_box type="vertical" icon="fa fa-diamond" title="Business Plan" id="cz_20569" sk_title="font-size:24px;color:#ffffff;" sk_icon="font-size:36px;color:#999999;"]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_button title="Read More" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_74318" sk_button="background-color:#999999;padding-left:20px;padding-right:20px;padding-top:5px;margin-bottom:0px;margin-top:10px;font-weight:400;font-size:13px;color:#000000;" sk_hover="background-color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3 vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_63163" sk_overall="background-size:cover;background-image:linear-gradient(0deg,rgba(0,0,0,0.9),rgba(0,0,0,0.9)),url('.$imgu.'pic70.jpg);padding-top:5px;padding-bottom:35px;margin-bottom:30px;"][cz_service_box type="vertical" icon="fa fa-globe" title="Global Design" id="cz_50019" sk_title="font-size:24px;color:#ffffff;" sk_icon="font-size:36px;color:#999999;"]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_button title="Read More" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_69599" sk_button="background-color:#999999;padding-left:20px;padding-right:20px;padding-top:5px;margin-bottom:0px;margin-top:10px;font-weight:400;font-size:13px;color:#000000;" sk_hover="background-color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3 vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_up_hover" id="cz_96228" sk_overall="background-size:cover;background-image:linear-gradient(0deg,rgba(0,0,0,0.9),rgba(0,0,0,0.9)),url('.$imgu.'pic70.jpg);padding-top:5px;padding-bottom:35px;margin-bottom:30px;"][cz_service_box type="vertical" icon="fa fa-cogs" title="Management" id="cz_70053" sk_title="font-size:24px;color:#ffffff;" sk_icon="font-size:36px;color:#999999;"]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_button title="Read More" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_33845" sk_button="background-color:#999999;padding-left:20px;padding-right:20px;padding-top:5px;margin-bottom:0px;margin-top:10px;font-weight:400;font-size:13px;color:#000000;" sk_hover="background-color:#ffffff;"][/cz_content_box][/vc_column][/vc_row][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => 'about skill progress 2 columns minimal 135_jpg',
						'c' =>'[vc_row][vc_column width="1/2" css=".vc_custom_1506005312941{padding-right: 40px !important;}"][cz_title bline="cz_line_after_title" id="cz_45716" sk_lines="background-color:#cccccc;width:50px;height:6px;top:7px;"]
	<h3 style="text-align: left;"><span style="font-family: Montserrat; color: #333333;">About Us</span></h3>
	[/cz_title][cz_gap height="40px" id="cz_83942"][vc_column_text]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 14px; font-weight: 300; font-family: Montserrat; line-height: 1.5;">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id, condimentum at, laoreet mattis, massa. Sed eleifend nonummy diam. Praesent mauris ante, elementum et, bibendum at, posuere sit amet, nibh. Duis tincidunt lectus quis dui viverra vestibulum. Suspendisse vulputate aliquam dui. Nulla elementum dui ut augue. Aliquam vehicula mi at mauris. Maecenas placerat.</span></div>
	[/vc_column_text][cz_gap height="10px" id="cz_60902"][cz_button title="Read more" text_effect="cz_btn_show_hidden_icon" icon_position="after" effect="cz_btn_fx_7" link="url:%23|||" icon="fa fa-long-arrow-right" id="cz_38073" sk_button="padding:7px 15px 7px 15px;border-bottom-width:0px;border-right-width:0px;border-top-width:0px;font-weight:300;color:#ffffff;background-color:#000000;font-size:13px;" sk_icon="color:rgba(255,255,255,0.51);"][/vc_column][vc_column width="1/2" css=".vc_custom_1506097549001{padding-right: 30px !important;padding-left: 30px !important;}"][cz_title bline="cz_line_after_title" id="cz_97932" sk_lines="background-color:#cccccc;width:50px;height:6px;top:7px;"]
	<h3 style="text-align: left;"><span style="font-family: Montserrat; color: #333333;">Our Skills
	</span></h3>
	[/cz_title][cz_gap height="28px" id="cz_86906"][cz_progress_bar title="Branding" number="93%" style="pbar2" id="cz_73355" sk_title="font-weight:300;font-size:18px;color:#000000;" sk_num="border-radius:0px;padding:0px 10px 0px 10px;color:#aaaaaa;font-size:12px;" sk_progress="background-color:#888888;" sk_bar="height:5px;"][cz_progress_bar title="Quality" number="92%" style="pbar2" id="cz_72217" sk_title="font-weight:300;font-size:18px;color:#000000;" sk_num="border-radius:0px;padding:0px 10px 0px 10px;color:#aaaaaa;font-size:12px;" sk_progress="background-color:#888888;" sk_bar="height:5px;"][cz_progress_bar title="Management" number="96%" style="pbar2" id="cz_20603" sk_title="font-weight:300;font-size:18px;color:#000000;" sk_num="border-radius:0px;padding:0px 10px 0px 10px;color:#aaaaaa;font-size:12px;" sk_progress="background-color:#888888;" sk_bar="height:5px;"][cz_progress_bar title="Design" number="88%" style="pbar2" id="cz_50826" sk_title="font-weight:300;font-size:18px;color:#000000;" sk_num="border-radius:0px;padding:0px 10px 0px 10px;color:#aaaaaa;font-size:12px;" sk_progress="background-color:#888888;" sk_bar="height:5px;"][/vc_column][/vc_row][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => '4 columns black minimal counter stats number 136_jpg',
						'c' =>'[vc_row full_width="stretch_row" css=".vc_custom_1506181527893{padding-top: 100px !important;padding-bottom: 100px !important;background-color: #000000 !important;}"][vc_column width="1/4"][cz_counter number="1350" after="PROJECTS" position="tac cz_2rows" duration="2" id="cz_29701" sk_num="font-weight:100;font-family:Montserrat;color:#ffffff;" sk_ba="font-weight:700;font-family:Montserrat;color:#666666;font-size:18px;letter-spacing:2px;" sk_after="font-weight:700;font-family:Montserrat;color:#666666;font-size:18px;letter-spacing:2px;"][/vc_column][vc_column width="1/4"][cz_counter number="18" symbol="+" after="YEARS" position="tac cz_2rows" duration="2" id="cz_69516" sk_num="font-weight:100;font-family:Montserrat;color:#ffffff;" sk_ba="font-weight:700;font-family:Montserrat;color:#666666;font-size:18px;letter-spacing:2px;" sk_after="font-weight:700;font-family:Montserrat;color:#666666;font-size:18px;letter-spacing:2px;"][cz_free_line hide_on_tablet="true" hide_on_mobile="true" id="cz_66166" sk_line="height:2px;width:150px;background-color:#444444;transform:rotate(120deg);left:-65px;top:-60px;"][/vc_column][vc_column width="1/4"][cz_counter number="367" after="CLIENTS" position="tac cz_2rows" duration="2" id="cz_83642" sk_num="font-weight:100;font-family:Montserrat;color:#ffffff;" sk_ba="font-weight:700;font-family:Montserrat;color:#666666;font-size:18px;letter-spacing:2px;" sk_after="font-weight:700;font-family:Montserrat;color:#666666;font-size:18px;letter-spacing:2px;"][cz_free_line hide_on_tablet="true" hide_on_mobile="true" id="cz_67074" sk_line="height:2px;width:150px;background-color:#444444;transform:rotate(120deg);left:-90px;top:-60px;"][/vc_column][vc_column width="1/4"][cz_counter number="74" symbol="+" after="EXPERTS" position="tac cz_2rows" duration="2" id="cz_93865" sk_num="font-weight:100;font-family:Montserrat;color:#ffffff;" sk_ba="font-weight:700;font-family:Montserrat;color:#666666;font-size:18px;letter-spacing:2px;" sk_after="font-weight:700;font-family:Montserrat;color:#666666;font-size:18px;letter-spacing:2px;"][cz_free_line hide_on_tablet="true" hide_on_mobile="true" id="cz_97288" sk_line="height:2px;width:150px;background-color:#444444;transform:rotate(120deg);left:-85px;top:-60px;"][/vc_column][/vc_row][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => '3 columns service box minimal mobile black 137_jpg',
						'c' =>'[vc_row][vc_column width="1/2" offset="vc_col-lg-4 vc_col-xs-12"][cz_gap height="55px" id="cz_50631"][cz_service_box align="right" icon="fa fa-diamond" title="Valuable Clients" id="cz_46181" sk_title="font-size:24px;color:#000000;" sk_icon_con="margin-right:15px;margin-top:-5px;"]
	<div style="line-height: 1.3; text-align: right;"><span style="font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_gap height="45px" id="cz_39511"][cz_service_box align="right" icon="fa fa-line-chart" title="Global Market" id="cz_43687" sk_title="font-size:24px;color:#000000;" sk_icon_con="margin-right:15px;margin-top:-5px;"]
	<div style="line-height: 1.3; text-align: right;"><span style="font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_gap height="45px" id="cz_62377"][cz_service_box align="right" icon="fa fa-desktop" title="Responsive Design" id="cz_57795" sk_title="font-size:24px;color:#000000;" sk_icon_con="margin-right:15px;margin-top:-5px;"]
	<div style="line-height: 1.3; text-align: right;"><span style="font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][/vc_column][vc_column width="1/3" offset="vc_hidden-sm vc_hidden-xs"][cz_image image="'.$imgu.'pic76.jpg" id="cz_72384"][/vc_column][vc_column width="1/2" offset="vc_col-lg-4 vc_col-xs-12"][cz_gap height="55px" id="cz_63631"][cz_service_box icon="fa fa-pencil-square-o" title="Business Plan" id="cz_24834" sk_title="font-size:24px;color:#000000;" sk_icon_con="margin-left:20px;margin-top:-7px;"]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_gap height="45px" id="cz_85573"][cz_service_box icon="fa fa-credit-card" title="Credit Card" id="cz_82707" sk_title="font-size:24px;color:#000000;" sk_icon_con="margin-left:20px;margin-top:-7px;"]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_gap height="45px" id="cz_90443"][cz_service_box icon="fa fa-flag-o" title="Location Service" id="cz_70060" sk_title="font-size:24px;color:#000000;" sk_icon_con="margin-left:20px;margin-top:-7px;"]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][/vc_column][/vc_row]',
					),
					array(
						'f' => 'testimonial quote 3 columns black minimal 138_jpg',
						'c' =>'[vc_row][vc_column][cz_gap height="60px" id="cz_40680"][cz_title bline="cz_line_after_title" id="cz_52615" sk_lines="background-color:#cccccc;height:6px;top:5px;"]
	<h3 style="text-align: center;"><span style="font-family: Montserrat; color: #333333;">Our Happy Clients
	</span></h3>
	[/cz_title][cz_gap height="45px" id="cz_48843"][cz_gap height="20px" id="cz_49960"][cz_gap height="30px" id="cz_60012"][/vc_column][/vc_row][vc_row][vc_column width="1/3"][cz_testimonials name="James Hernandez" subname="CEO" style="6" avatar="'.$imgu.'80x80.jpg" id="cz_96140" sk_content="background-color:#000000;margin-bottom:80px;box-shadow:1px 1px 1px rgba(0,0,0,0.01);" sk_avatar="border-radius:0px;border-bottom-style:solid;border-color:#ffffff;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:8px 8px 8px 8px;" sk_name="margin-top:5px;color:#ffffff;" sk_subname="margin-top:8px;font-weight:300;color:rgba(255,255,255,0.5);font-size:13px;"]
	<div style="line-height: 1.3;"><span style="color: #999999; font-family: Poppins; font-size: 14px;">Lorem ipsum dolor sit amet, conse ctet uer adipi scing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id.</span></div>
	[/cz_testimonials][/vc_column][vc_column width="1/3"][cz_testimonials name="Alex Deramatonov" subname="Co-Founder" style="6" avatar="'.$imgu.'80x80.jpg" id="cz_55863" sk_content="background-color:#000000;margin-bottom:80px;box-shadow:1px 1px 1px rgba(0,0,0,0.01);" sk_avatar="border-radius:0px;border-bottom-style:solid;border-color:#ffffff;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:8px 8px 8px 8px;" sk_name="margin-top:5px;color:#ffffff;" sk_subname="margin-top:8px;font-weight:300;color:rgba(255,255,255,0.5);font-size:13px;"]
	<div style="line-height: 1.3;"><span style="color: #999999; font-family: Poppins; font-size: 14px;">Lorem ipsum dolor sit amet, conse ctet uer adipi scing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id.</span></div>
	[/cz_testimonials][/vc_column][vc_column width="1/3"][cz_testimonials name="Mark Smith" subname="Manager" style="6" avatar="'.$imgu.'80x80.jpg" id="cz_97654" sk_content="background-color:#000000;box-shadow:1px 1px 1px rgba(0,0,0,0.01) ;" sk_avatar="border-radius:0px;border-bottom-style:solid;border-color:#ffffff;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:8px 8px 8px 8px;" sk_name="margin-top:5px;color:#ffffff;" sk_subname="margin-top:8px;font-weight:300;color:rgba(255,255,255,0.5);font-size:13px;"]
	<div style="line-height: 1.3;"><span style="color: #999999; font-family: Poppins; font-size: 14px;">Lorem ipsum dolor sit amet, conse ctet uer adipi scing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id.</span></div>
	[/cz_testimonials][/vc_column][/vc_row][cz_google_font font="Montserrat"][cz_google_font font="Poppins"]',
					),
					array(
						'f' => 'price pricing table 4 columns black minimal 139_jpg',
						'c' =>'[vc_row][vc_column][cz_title bline="cz_line_after_title" id="cz_95382" sk_lines="background-color:#ffffff;width:70px;height:15px;top:3px;"]
	<h2 style="text-align: center;"><span style="font-family: Montserrat; color: #333333;">Pricing
	</span></h2>
	[/cz_title][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1506193968146{padding-top: 100px !important;padding-bottom: 100px !important;background-color: #000000 !important;}" el_class="no_padding"][vc_column width="1/4"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" id="cz_86967" sk_overall="padding-bottom:40px;"][cz_title id="cz_22504" sk_overall="margin-bottom:10px;margin-top:-10px;"]
	<p style="text-align: center;"><span style="font-size: 14px; color: #999999;">BASIC</span></p>
	[/cz_title][cz_title id="cz_13094" sk_overall="margin-bottom:40px;margin-top:30px;"]
	<div style="text-align: center; line-height: 1.2;"><span style="color: #ffffff; font-size: 50px;"><span style="font-weight: bold;">FREE</span></span></div>
	<div style="text-align: center; line-height: 1.2;"><span style="display: block; color: #999999; font-weight: 300;">Life Time</span></div>
	[/cz_title][vc_column_text]
	<div style="text-align: center; line-height: 1.5;"><span style="color: #999999; font-weight: 300; font-size: 14px;">1000 GB Disk Space</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> 200 Databases List</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> Free Domain Registration</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> 2 Hosting Space</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> Account Control Panel</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> FREE 24/7 Support</span></div>
	[/vc_column_text][cz_gap height="40px" id="cz_76247"][cz_button title="Sign Up Now" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_55515" sk_button="padding-bottom:6px;padding-top:6px;background-color:rgba(255,255,255,0.19);color:#cccccc;font-size:14px;" sk_hover="background-color:#ffffff;color:#000000;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/4"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" id="cz_62146" sk_overall="padding-bottom:40px;"][cz_title id="cz_31957" sk_overall="margin-bottom:10px;margin-top:-10px;"]
	<p style="text-align: center;"><span style="font-size: 14px; color: #999999;">STANDARD</span></p>
	[/cz_title][cz_title id="cz_51174" sk_overall="margin-bottom:40px;margin-top:30px;"]
	<div style="text-align: center; line-height: 1.2;"><span style="color: #ffffff; font-size: 50px;"><span style="font-size: 38px;"><sup>$</sup></span><span style="font-weight: bold;">9.99</span></span></div>
	<div style="text-align: center; line-height: 1.2;"><span style="display: block; color: #999999; font-weight: 300;">Per Month</span></div>
	[/cz_title][vc_column_text]
	<div style="text-align: center; line-height: 1.5;"><span style="color: #999999; font-weight: 300; font-size: 14px;">1000 GB Disk Space</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> 200 Databases List</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> Free Domain Registration</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> 2 Hosting Space</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> Account Control Panel</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> FREE 24/7 Support</span></div>
	[/vc_column_text][cz_gap height="40px" id="cz_84485"][cz_button title="Sign Up Now" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_97324" sk_button="padding-bottom:6px;padding-top:6px;background-color:rgba(255,255,255,0.19);color:#cccccc;font-size:14px;" sk_hover="background-color:#ffffff;color:#000000;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/4"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" id="cz_45452" sk_overall="padding-bottom:60px;padding-top:50px;margin-top:-25px;background-color:#ffffff;"][cz_title id="cz_11662" sk_overall="margin-bottom:10px;margin-top:-10px;"]
	<p style="text-align: center;"><span style="font-size: 14px; color: #999999;">BEST SELLER</span></p>
	[/cz_title][cz_title id="cz_84809" sk_overall="margin-bottom:40px;margin-top:30px;"]
	<div style="text-align: center; line-height: 1.2;"><span style="color: #000000; font-size: 50px;"><span style="font-size: 38px;"><sup>$</sup></span><span style="font-weight: bold;">19.99</span></span></div>
	<div style="text-align: center; line-height: 1.2;"><span style="display: block; color: #999999; font-weight: 300;">Per Month</span></div>
	[/cz_title][vc_column_text]
	<div style="text-align: center; line-height: 1.5;"><span style="color: #666666; font-weight: 300; font-size: 14px;">1000 GB Disk Space</span>
	<span style="color: #666666; font-weight: 300; font-size: 14px;"> 200 Databases List</span>
	<span style="color: #666666; font-weight: 300; font-size: 14px;"> Free Domain Registration</span>
	<span style="color: #666666; font-weight: 300; font-size: 14px;"> 2 Hosting Space</span>
	<span style="color: #666666; font-weight: 300; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="color: #666666; font-weight: 300; font-size: 14px;"> Account Control Panel</span>
	<span style="color: #666666; font-weight: 300; font-size: 14px;"> FREE 24/7 Support</span></div>
	[/vc_column_text][cz_gap height="40px" id="cz_20107"][cz_button title="Sign Up Now" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_28893" sk_button="padding-bottom:6px;padding-top:6px;background-color:rgba(0,0,0,0.46);color:#ffffff;font-size:14px;" sk_hover="background-color:#000000;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/4"][cz_content_box type="1" fx_hover="fx_zoom_1_hover" id="cz_72463" sk_overall="padding-bottom:40px;background-color:rgba(0,0,0,0.01);"][cz_title id="cz_73279" sk_overall="margin-bottom:10px;margin-top:-10px;"]
	<p style="text-align: center;"><span style="font-size: 14px; color: #999999;">ULTIMATE</span></p>
	[/cz_title][cz_title id="cz_80234" sk_overall="margin-bottom:40px;margin-top:30px;"]
	<div style="text-align: center; line-height: 1.2;"><span style="color: #ffffff; font-size: 50px;"><span style="font-size: 38px;"><sup>$</sup></span><span style="font-weight: bold;">59.99</span></span></div>
	<div style="text-align: center; line-height: 1.2;"><span style="display: block; color: #999999; font-weight: 300;">Yearly</span></div>
	[/cz_title][vc_column_text]
	<div style="text-align: center; line-height: 1.5;"><span style="color: #999999; font-weight: 300; font-size: 14px;">1000 GB Disk Space</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> 200 Databases List</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> Free Domain Registration</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> 2 Hosting Space</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> Account Control Panel</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> FREE 24/7 Support</span></div>
	[/vc_column_text][cz_gap height="40px" id="cz_50279"][cz_button title="Sign Up Now" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_32059" sk_button="padding-bottom:6px;padding-top:6px;background-color:rgba(255,255,255,0.19);color:#cccccc;font-size:14px;" sk_hover="background-color:#ffffff;color:#000000;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][/vc_row][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => 'about info 2 columns image 2 buttons minimal 140_jpg',
						'c' =>'[vc_row][vc_column width="1/3"][cz_image image_opacity="op_5" image="'.$imgu.'pic35.jpg" hover_image="'.$imgu.'pic35.jpg" id="cz_42435" sk_css="background-color:#000000;" sk_css_mobile="margin-bottom:40px;"][/vc_column][vc_column width="2/3" css=".vc_custom_1506332874733{padding-right: 30px !important;padding-left: 30px !important;}"][cz_title bline="cz_line_after_title" id="cz_23944" sk_lines="background-color:#cccccc;width:50px;height:6px;top:2px;"]
	<h3><span style="color: #000000;">Everyone has something important to say!</span></h3>
	[/cz_title][cz_gap height="33px" id="cz_56703"][vc_column_text]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 14px; font-weight: 300; font-family: Montserrat; line-height: 1.5;">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id, condimentum at, laoreet mattis, massa. Sed eleifend nonummy diam. Praesent mauris ante, elementum et, bibendum at, posuere sit amet, nibh. Duis tincidunt lectus quis dui viverra vestibulum. Suspendisse vulputate aliquam dui. Nulla elementum dui ut augue. Aliquam vehicula mi at mauris. Maecenas placerat.</span></div>
	[/vc_column_text][cz_gap height="10px" id="cz_88689"][cz_button title="Free Consultation" btn_position="cz_btn_inline" btn_effect="cz_btn_fill_left" icon_position="after" effect="cz_btn_fx_7" link="url:%23|||" icon="fa fa-comments-o" id="cz_41479" sk_button="font-size:13px;color:#000000;font-weight:300;background-color:#ffffff;padding-top:7px;padding-bottom:7px;margin-right:10px;border-style:solid;border-width:1px;border-color:#000000;" sk_hover="color:#ffffff;background-color:#000000;" sk_icon="color:#000000;" sk_icon_hover="color:#ffffff;"][cz_button title="Learn More" btn_position="cz_btn_inline" btn_effect="cz_btn_fill_right" icon_position="after" effect="cz_btn_fx_7" link="url:%23|||" icon="fa fa-long-arrow-right" id="cz_82786" sk_button="font-size:13px;color:#ffffff;font-weight:300;background-color:#000000;padding:7px 15px;border-style:solid;border-width:1px;border-color:#000000;" sk_hover="color:#000000;background-color:#ffffff;" sk_icon="color:rgba(255,255,255,0.51);" sk_icon_hover="color:#000000;"][/vc_column][/vc_row][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => 'client carousel 5 columns minimal slider logo image 141_jpg',
						'c' =>'[vc_row][vc_column][cz_title bline="cz_line_after_title" id="cz_16938" sk_lines="background-color:#cccccc;width:50px;height:6px;top:5px;"]
	<h3 style="text-align: center;"><span style="font-family: Montserrat; color: #333333;">Our Clients
	</span></h3>
	[/cz_title][cz_gap height="45px" id="cz_29774"][cz_carousel slidestoshow="5" arrows_position="arrows_bc" slidestoshow_tablet="1" infinite="true" gap="15px" id="cz_96885" sk_prev_icon="color:#ffffff;background-color:#000000;font-size:13px;margin-left:5px;margin-bottom:-30px;" sk_next_icon="color:#ffffff;background-color:#000000;font-size:13px;margin-left:5px;margin-bottom:-30px;"][cz_image image="'.$imgu.'client.png" id="cz_85895" sk_css="border-bottom-style:solid;border-color:#000000;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:10px 20px 10px 20px;border-width:1px 1px 1px 1px;"][cz_image image="'.$imgu.'client.png" id="cz_12855" sk_css="border-bottom-style:solid;border-color:#000000;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:10px 20px 10px 20px;border-width:1px 1px 1px 1px;"][cz_image image="'.$imgu.'client.png" id="cz_98189" sk_css="border-bottom-style:solid;border-color:#000000;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:10px 20px 10px 20px;border-width:1px 1px 1px 1px;"][cz_image image="'.$imgu.'client.png" id="cz_34829" sk_css="border-bottom-style:solid;border-color:#000000;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:10px 20px 10px 20px;border-width:1px 1px 1px 1px;"][cz_image image="'.$imgu.'client.png" id="cz_15702" sk_css="border-bottom-style:solid;border-color:#000000;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:10px 20px 10px 20px;border-width:1px 1px 1px 1px;"][cz_image image="'.$imgu.'client.png" id="cz_57264" sk_css="border-bottom-style:solid;border-color:#000000;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:10px 20px 10px 20px;border-width:1px 1px 1px 1px;"][/cz_carousel][cz_gap height="120px" id="cz_25319"][/vc_column][/vc_row]',
					),
					array(
						'f' => '1 column info section cta button minimal black 142_jpg',
						'c' =>'[vc_row full_width="stretch_row" parallax="content-moving" css=".vc_custom_1504527457399{background-image: url('.$imgu.'img53.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}][vc_column][cz_gap height="100px" id="cz_98587"][cz_title id="cz_47704"]
	<h2 style="text-align: center;"><span style="color: #ffffff; font-family: Montserrat; line-height: 2;">Do you want new modern website?</span></h2>
	<h4 style="text-align: center;"><span style="color: #ffffff; font-family: Montserrat; font-weight: 300; line-height: 2;">Yes, of course! So let’s buy xtra now</span></h4>
	[/cz_title][cz_gap height="35px" id="cz_46100"][cz_button title="Buy it Now!" btn_position="cz_btn_center" btn_effect="cz_btn_fill_up" effect="cz_btn_fx_7" link="url:%23|||" icon="fa fa-shopping-cart" id="cz_51928" sk_button="font-size:16px;color:#ffffff;font-weight:300;letter-spacing:2px;background-color:rgba(0,0,0,0.01);padding-top:7px;padding-bottom:7px;margin-right:10px;border-style:solid;border-width:1px;border-color:#ffffff;" sk_hover="color:#000000;background-color:#ffffff;" sk_icon="color:#ffffff;" sk_icon_hover="color:#000000;"][cz_gap height="120px" id="cz_61169"][/vc_column][/vc_row][cz_google_font font="Montserrat"]'
					),	
					array(
						'f' => 'about 2 columns 143_jpg',
						'c' =>'[vc_row][vc_column width="1/2"][cz_image tilt="on" image="'.$imgu.'pic12-2.jpg" id="cz_56116" sk_css="border-radius:5px;background-color:#099aad;"][/vc_column][vc_column width="1/2" css=".vc_custom_1506519213325{padding-left: 35px !important;}"][cz_title bline="cz_line_after_title" id="cz_68181" sk_lines="background-color:#cccccc;width:50px;height:6px;top:5px;border-radius:5px;"]
	<h3 style="text-align: left;"><span style="font-family: Ubuntu; color: #099aad;">About Us</span></h3>
	[/cz_title][cz_gap height="45px" id="cz_87451"][vc_column_text]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 14px; font-weight: 300; font-family: Montserrat; line-height: 1.5;">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id, condimentum at, laoreet mattis, massa. Sed eleifend nonummy diam. Praesent mauris ante, elementum et, bibendum at, posuere sit amet, nibh. Duis tincidunt lectus quis dui viverra vestibulum. Suspendisse vulputate aliquam dui. Nulla elementum dui ut augue. Aliquam vehicula mi at mauris. Maecenas placerat.</span></div>
	[/vc_column_text][cz_gap height="10px" id="cz_33487"][cz_button title="Read more" text_effect="cz_btn_show_hidden_icon" icon_position="after" effect="cz_btn_fx_7" link="url:%23|||" icon="fa fa-long-arrow-right" id="cz_72843" sk_button="border-radius:5px;padding:7px 20px 7px 20px;border-bottom-width:0px;border-right-width:0px;border-top-width:0px;font-weight:300;color:#ffffff;background-color:#099aad;font-size:13px;" sk_icon="color:rgba(255,255,255,0.51);"][/vc_column][/vc_row][cz_google_font font="Ubuntu"][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => 'services 4 columns radius curved box 144_jpg',
						'c' =>'[vc_row][vc_column][cz_title bline="cz_line_after_title" id="cz_36939" sk_lines="background-color:#cccccc;width:50px;height:6px;top:5px;border-radius:5px;"]
	<h3 style="text-align: center;"><span style="font-family: Montserrat; color: #333333;"><span style="color: #099aad; font-family: Ubuntu;">Our Services</span>
	</span></h3>
	[/cz_title][/vc_column][/vc_row][vc_row][vc_column][cz_gap id="cz_43633"][/vc_column][/vc_row][vc_row][vc_column width="1/2" offset="vc_col-lg-3 vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_bob_hover" id="cz_64789" sk_overall="background-color:rgba(255,255,255,0.9);padding-top:10px;padding-bottom:40px;margin-bottom:30px;border-style:solid;border-width:1px;border-color:#cccccc;border-radius:5px;" sk_hover="box-shadow:0px 10px 20px rgba(0,0,0,0.12) ;"][cz_service_box type="vertical" icon="fa fa-heart-o" title="Eco Friendly" id="cz_55070" sk_title="font-size:26px;color:#333333;font-family:Ubuntu;" sk_icon="font-size:32px;color:#099aad;" sk_icon_con="margin-bottom:10px;margin-top:0px;"]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_gap height="10px" id="cz_70412"][cz_button title="Read more" btn_position="cz_btn_center" text_effect="cz_btn_show_hidden_icon" icon_position="after" effect="cz_btn_fx_7" link="url:%23|||" icon="fa fa-long-arrow-right" id="cz_75107" sk_button="border-radius:5px;padding:7px 20px 7px 20px;border-bottom-width:0px;border-right-width:0px;border-top-width:0px;font-weight:300;color:#ffffff;background-color:#099aad;font-size:13px;" sk_icon="color:rgba(255,255,255,0.51);"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3 vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_bob_hover" id="cz_62262" sk_overall="background-color:rgba(255,255,255,0.9);padding-top:10px;padding-bottom:40px;margin-bottom:30px;border-style:solid;border-width:1px;border-color:#cccccc;border-radius:5px;" sk_hover="box-shadow:0px 10px 20px rgba(0,0,0,0.12) ;"][cz_service_box type="vertical" icon="fa fa-comment-o" title="Free Support" id="cz_57411" sk_title="font-size:26px;color:#333333;font-family:Ubuntu;" sk_icon="font-size:32px;color:#099aad;" sk_icon_con="margin-bottom:10px;margin-top:0px;"]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_gap height="10px" id="cz_63286"][cz_button title="Read more" btn_position="cz_btn_center" text_effect="cz_btn_show_hidden_icon" icon_position="after" effect="cz_btn_fx_7" link="url:%23|||" icon="fa fa-long-arrow-right" id="cz_19950" sk_button="border-radius:5px;padding:7px 20px 7px 20px;border-bottom-width:0px;border-right-width:0px;border-top-width:0px;font-weight:300;color:#ffffff;background-color:#099aad;font-size:13px;" sk_icon="color:rgba(255,255,255,0.51);"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3 vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_bob_hover" id="cz_54617" sk_overall="background-color:rgba(255,255,255,0.9);padding-top:10px;padding-bottom:40px;margin-bottom:30px;border-style:solid;border-width:1px;border-color:#cccccc;border-radius:5px;" sk_hover="box-shadow:0px 10px 20px rgba(0,0,0,0.12) ;"][cz_service_box type="vertical" icon="fa fa-television" title="Global Market" id="cz_93274" sk_title="font-size:26px;color:#333333;font-family:Ubuntu;" sk_icon="font-size:32px;color:#099aad;" sk_icon_con="margin-bottom:10px;"]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_gap height="10px" id="cz_17654"][cz_button title="Read more" btn_position="cz_btn_center" text_effect="cz_btn_show_hidden_icon" icon_position="after" effect="cz_btn_fx_7" link="url:%23|||" icon="fa fa-long-arrow-right" id="cz_35595" sk_button="border-radius:5px;padding:7px 20px 7px 20px;border-bottom-width:0px;border-right-width:0px;border-top-width:0px;font-weight:300;color:#ffffff;background-color:#099aad;font-size:13px;" sk_icon="color:rgba(255,255,255,0.51);"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3 vc_col-xs-12"][cz_content_box type="1" fx_hover="fx_bob_hover" id="cz_29801" sk_overall="background-color:rgba(255,255,255,0.9);padding-top:10px;padding-bottom:40px;margin-bottom:30px;border-style:solid;border-width:1px;border-color:#cccccc;border-radius:5px;" sk_hover="box-shadow:0px 10px 20px rgba(0,0,0,0.12) ;"][cz_service_box type="vertical" icon="fa fa-envelope-open-o" title="Free Contact" id="cz_37222" sk_title="font-size:26px;color:#333333;font-family:Ubuntu;" sk_icon="font-size:32px;color:#099aad;" sk_icon_con="margin-bottom:10px;margin-top:0px;"]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_gap height="10px" id="cz_85584"][cz_button title="Read more" btn_position="cz_btn_center" text_effect="cz_btn_show_hidden_icon" icon_position="after" effect="cz_btn_fx_7" link="url:%23|||" icon="fa fa-long-arrow-right" id="cz_64818" sk_button="border-radius:5px;padding:7px 20px 7px 20px;border-bottom-width:0px;border-right-width:0px;border-top-width:0px;font-weight:300;color:#ffffff;background-color:#099aad;font-size:13px;" sk_icon="color:rgba(255,255,255,0.51);"][/cz_content_box][/vc_column][/vc_row][cz_google_font font="Ubuntu"][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => 'about skill progress 2 columns radius curved 145_jpg',
						'c' =>'[vc_row][vc_column width="1/2" css=".vc_custom_1506005312941{padding-right: 40px !important;}"][cz_title bline="cz_line_after_title" id="cz_31710" sk_lines="background-color:#cccccc;width:50px;height:6px;top:5px;border-radius:5px;"]
	<h3 style="text-align: left;"><span style="font-family: Ubuntu; color: #099aad;">About Us</span></h3>
	[/cz_title][cz_gap height="40px" id="cz_64443"][vc_column_text]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 14px; font-weight: 300; font-family: Montserrat; line-height: 1.5;">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id, condimentum at, laoreet mattis, massa. Sed eleifend nonummy diam. Praesent mauris ante, elementum et, bibendum at, posuere sit amet, nibh. Duis tincidunt lectus quis dui viverra vestibulum. Suspendisse vulputate aliquam dui. Nulla elementum dui ut augue. Aliquam vehicula mi at mauris. Maecenas placerat.</span></div>
	[/vc_column_text][cz_button title="Read more" text_effect="cz_btn_show_hidden_icon" icon_position="after" effect="cz_btn_fx_7" link="url:%23|||" icon="fa fa-long-arrow-right" id="cz_25870" sk_button="border-radius:5px;padding:7px 20px 7px 20px;border-bottom-width:0px;border-right-width:0px;border-top-width:0px;font-weight:300;color:#ffffff;background-color:#099aad;font-size:13px;" sk_icon="color:rgba(255,255,255,0.51);"][cz_gap height="10px" id="cz_24565"][/vc_column][vc_column width="1/2" css=".vc_custom_1506097549001{padding-right: 30px !important;padding-left: 30px !important;}"][cz_title bline="cz_line_after_title" id="cz_40107" sk_lines="background-color:#cccccc;width:50px;height:6px;top:5px;border-radius:5px;"]<h3 style="text-align: left;"><span style="font-family: Ubuntu; color: #099aad;">Our Skills</span></h3>[/cz_title][cz_gap height="28px" id="cz_99105"][cz_progress_bar title="Branding" number="93%" style="pbar2" id="cz_13863" sk_title="font-weight:400;font-size:18px;color:#666666;font-family:Ubuntu;" sk_num="border-radius:3px;padding:0px 10px 0px 10px;color:#ffffff;font-size:12px;background-color:#099aad;" sk_progress="background-color:#bbbbbb;" sk_bar="height:5px;border-radius:3px;"][cz_progress_bar title="Design" number="88%" style="pbar2" id="cz_67807" sk_title="font-weight:400;font-size:18px;color:#666666;font-family:Ubuntu;" sk_num="border-radius:3px;padding:0px 10px 0px 10px;color:#ffffff;font-size:12px;background-color:#099aad;" sk_progress="background-color:#bbbbbb;" sk_bar="height:5px;border-radius:3px;"][cz_progress_bar title="Management" number="96%" style="pbar2" id="cz_69994" sk_title="font-weight:400;font-size:18px;color:#666666;font-family:Ubuntu;" sk_num="border-radius:3px;padding:0px 10px 0px 10px;color:#ffffff;font-size:12px;background-color:#099aad;" sk_progress="background-color:#bbbbbb;" sk_bar="height:5px;border-radius:3px;"][cz_progress_bar title="Quality" number="91%" style="pbar2" id="cz_68215" sk_title="font-weight:400;font-size:18px;color:#666666;font-family:Ubuntu;" sk_num="border-radius:3px;padding:0px 10px 0px 10px;color:#ffffff;font-size:12px;background-color:#099aad;" sk_progress="background-color:#bbbbbb;" sk_bar="height:5px;border-radius:3px;"][/vc_column][/vc_row][cz_google_font font="Ubuntu"][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => '4 columns radius curved counter stats number 146_jpg',
						'c' =>'[vc_row full_width="stretch_row" css=".vc_custom_1506356717149{padding-top: 110px !important;padding-bottom: 100px !important;background-color: #099aad !important;}"][vc_column width="1/4"][cz_counter number="18" symbol="+" after="YEARS" position="tac cz_2rows" duration="2" id="cz_21051" sk_num="border-radius:5px;background-color:#ffffff;padding:10px 20px 10px 20px;margin-bottom:10px;font-size:60px;font-family:Ubuntu;color:#099aad;" sk_ba="font-weight:700;font-family:Ubuntu;color:#ffffff;font-size:18px;letter-spacing:2px;" sk_after="font-weight:700;font-family:Ubuntu;color:#ffffff;font-size:18px;letter-spacing:2px;"][/vc_column][vc_column width="1/4"][cz_counter number="1350" after="PROJECTS" position="tac cz_2rows" duration="2" id="cz_18819" sk_num="border-radius:5px;background-color:#ffffff;padding:10px 20px 10px 20px;margin-bottom:10px;font-size:60px;font-family:Ubuntu;color:#099aad;" sk_ba="font-weight:700;font-family:Ubuntu;color:#ffffff;font-size:18px;letter-spacing:2px;" sk_after="font-weight:700;font-family:Ubuntu;color:#ffffff;font-size:18px;letter-spacing:2px;"][/vc_column][vc_column width="1/4"][cz_counter number="367" after="CLIENTS" position="tac cz_2rows" duration="2" id="cz_18543" sk_num="border-radius:5px;background-color:#ffffff;padding:10px 20px 10px 20px;margin-bottom:10px;font-size:60px;font-family:Ubuntu;color:#099aad;" sk_ba="font-weight:700;font-family:Ubuntu;color:#ffffff;font-size:18px;letter-spacing:2px;" sk_after="font-weight:700;font-family:Ubuntu;color:#ffffff;font-size:18px;letter-spacing:2px;"][/vc_column][vc_column width="1/4"][cz_counter number="74" symbol="+" after="EXPERTS" position="tac cz_2rows" duration="2" id="cz_74873" sk_num="border-radius:5px;background-color:#ffffff;padding:10px 20px 10px 20px;margin-bottom:10px;font-size:60px;font-family:Ubuntu;color:#099aad;" sk_ba="font-weight:700;font-family:Ubuntu;color:#ffffff;font-size:18px;letter-spacing:2px;" sk_after="font-weight:700;font-family:Ubuntu;color:#ffffff;font-size:18px;letter-spacing:2px;"][/vc_column][/vc_row][cz_google_font font="Ubuntu"]',
					),
					array(
						'f' => '3 columns service box radius curved mobile  147_jpg',
						'c' =>'[vc_row][vc_column width="1/2" offset="vc_col-lg-4 vc_col-xs-12"][cz_gap height="55px" id="cz_29365"][cz_service_box align="right" icon="fa fa-diamond" title="Valuable Clients" id="cz_68998" sk_overall="animation:fadeInLeft;" sk_title="font-size:26px;color:#099aad;font-family:Ubuntu;" sk_icon="font-size:28px;color:#ffffff;padding:5px;" sk_icon_con="border-radius:5px;background-color:#099aad;margin-top:10px;"]
	<div style="line-height: 1.3; text-align: right;"><span style="font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_gap height="45px" id="cz_50722"][cz_service_box align="right" icon="fa fa-line-chart" title="Global Market" id="cz_87865" sk_overall="animation:fadeInLeft;" sk_title="font-size:26px;color:#099aad;font-family:Ubuntu;" sk_icon="font-size:28px;color:#ffffff;padding:5px;" sk_icon_con="border-radius:5px;background-color:#099aad;margin-top:10px;"]
	<div style="line-height: 1.3; text-align: right;"><span style="font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_gap height="45px" id="cz_78083"][cz_service_box align="right" icon="fa fa-desktop" title="Responsive Design" id="cz_77699" sk_overall="animation:fadeInLeft;" sk_title="font-size:26px;color:#099aad;font-family:Ubuntu;" sk_icon="font-size:28px;color:#ffffff;padding:5px;" sk_icon_con="border-radius:5px;background-color:#099aad;margin-top:10px;"]
	<div style="line-height: 1.3; text-align: right;"><span style="font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][/vc_column][vc_column width="1/3" offset="vc_hidden-md vc_hidden-sm vc_hidden-xs"][cz_image tilt="on" glare="1" image="'.$imgu.'pic77.jpg" id="cz_40913" sk_css="animation:fadeInUp;"][/vc_column][vc_column width="1/2" offset="vc_col-lg-4 vc_col-xs-12"][cz_gap height="55px" id="cz_73319"][cz_service_box icon="fa fa-pencil-square-o" title="Business Plan" id="cz_52567" sk_overall="animation:fadeInRight;" sk_title="font-size:26px;color:#099aad;font-family:Ubuntu;" sk_icon="font-size:28px;color:#ffffff;padding:5px 3px 5px 8px;" sk_icon_con="border-radius:5px;background-color:#099aad;margin-top:10px;"]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_gap height="45px" id="cz_71439"][cz_service_box icon="fa fa-credit-card" title="Credit Card" id="cz_33314" sk_overall="animation:fadeInRight;" sk_title="font-size:26px;color:#099aad;font-family:Ubuntu;" sk_icon="font-size:28px;color:#ffffff;padding:5px;" sk_icon_con="border-radius:5px;background-color:#099aad;margin-top:10px;"]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][cz_gap height="45px" id="cz_12348"][cz_service_box icon="fa fa-flag-o" title="Location Service" id="cz_87082" sk_overall="animation:fadeInRight;" sk_title="font-size:26px;color:#099aad;font-family:Ubuntu;" sk_icon="font-size:28px;color:#ffffff;padding:5px;" sk_icon_con="border-radius:5px;background-color:#099aad;margin-top:10px;"]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 13px; color: #666666; font-weight: 300;">Lorem ipsum dolor sit amet, conse ctetur adipi scing elit. Duis odio nisl, tincidunt et urna sed, mollis lacinia velit.</span></div>
	[/cz_service_box][/vc_column][/vc_row][cz_google_font font="Ubuntu"]',
					),
					array(
						'f' => 'testimonial quote 3 columns radius curved 148_jpg',
						'c' =>'[vc_row][vc_column][cz_gap height="60px" id="cz_28980"][cz_title bline="cz_line_after_title" id="cz_32142" sk_lines="background-color:#cccccc;width:50px;height:6px;top:5px;border-radius:5px;"]
	<h3 style="text-align: center;"><span style="font-family: Montserrat; color: #333333;"><span style="font-family: Ubuntu; color: #099aad;">Our Happy Clients</span>
	</span></h3>
	[/cz_title][cz_gap height="20px" id="cz_28295"][cz_gap height="30px" id="cz_27387"][/vc_column][/vc_row][vc_row css=".vc_custom_1506361131322{padding-bottom: 100px !important;}"][vc_column width="1/3"][cz_testimonials name="James Hernandez" subname="CEO" style="5" avatar="'.$imgu.'80x80.jpg" id="cz_72107" sk_content="border-radius:10px;animation:flipInY;background-color:#099aad;" sk_avatar="border-radius:100px;border-bottom-style:solid;border-color:#ffffff;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:4px 4px 4px 4px;box-shadow:0px 6px 10px rgba(0,0,0,0.24) ;" sk_name="margin-top:20px;color:#ffffff;" sk_subname="margin-top:23px;font-weight:300;color:rgba(255,255,255,0.5);font-size:13px;"]
	<div style="line-height: 1.3;"><span style="color: #ffffff; font-family: Poppins; font-size: 14px;">Lorem ipsum dolor sit amet, conse ctet uer adipi scing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id.
	</span></div>
	[/cz_testimonials][/vc_column][vc_column width="1/3"][cz_testimonials name="Dimitry Karakov" subname="CEO" style="5" avatar="'.$imgu.'80x80.jpg" id="cz_21791" sk_content="border-radius:10px;animation:flipInY;background-color:#099aad;" sk_avatar="border-radius:100px;border-bottom-style:solid;border-color:#ffffff;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:4px 4px 4px 4px;box-shadow:0px 6px 10px rgba(0,0,0,0.24) ;" sk_name="margin-top:20px;color:#ffffff;" sk_subname="margin-top:23px;font-weight:300;color:rgba(255,255,255,0.5);font-size:13px;"]
	<div style="line-height: 1.3;"><span style="color: #ffffff; font-family: Poppins; font-size: 14px;">Lorem ipsum dolor sit amet, conse ctet uer adipi scing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id.
	</span></div>
	[/cz_testimonials][/vc_column][vc_column width="1/3"][cz_testimonials name="Alex Smithson" subname="Designer" style="5" avatar="'.$imgu.'80x80.jpg" id="cz_78727" sk_content="border-radius:10px;animation:flipInY;background-color:#099aad;" sk_avatar="border-radius:100px;border-bottom-style:solid;border-color:#ffffff;border-top-style:solid;border-right-style:solid;border-left-style:solid;border-width:4px 4px 4px 4px;box-shadow:0px 6px 10px rgba(0,0,0,0.24) ;" sk_name="margin-top:20px;color:#ffffff;" sk_subname="margin-top:23px;font-weight:300;color:rgba(255,255,255,0.5);font-size:13px;"]
	<div style="line-height: 1.3;"><span style="color: #ffffff; font-family: Poppins; font-size: 14px;">Lorem ipsum dolor sit amet, conse ctet uer adipi scing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id.
	</span></div>
	[/cz_testimonials][/vc_column][/vc_row][cz_google_font font="Poppins"][cz_google_font font="Ubuntu
Poppins"][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => 'price pricing table 4 columns radius curved 149_jpg',
						'c' =>'[vc_row][vc_column][cz_title bline="cz_line_after_title" id="cz_28284" sk_lines="background-color:#cccccc;width:50px;height:6px;top:5px;border-radius:5px;"]
	<h3 style="text-align: center;"><span style="font-family: Montserrat; color: #333333;"><span style="font-family: Ubuntu; color: #099aad;">Pricing</span>
	</span></h3>
	[/cz_title][cz_gap height="40px" id="cz_91420"][/vc_column][/vc_row][vc_row][vc_column width="1/2" offset="vc_col-lg-3 vc_col-xs-12"][cz_content_box type="1" id="cz_36586" sk_overall="padding-top:0px;padding-bottom:40px;margin-bottom:30px;border-style:solid;border-width:1px;border-color:#cccccc;border-radius:10px;"][cz_title id="cz_21616" sk_overall="border-radius:0 0 10px 10px;padding:5px 20px 5px 20px;margin-bottom:10px;margin-top:-1px;background-color:#cccccc;"]
	<p style="text-align: center;"><span style="font-size: 14px; color: #ffffff;">BASIC
	</span>

	[/cz_title][cz_title title_pos="cz_title_pos_block" id="cz_57325" sk_overall="margin-bottom:40px;margin-top:30px;"]
	<div style="text-align: center; line-height: 1.2;"><span style="color: #099aad; font-size: 50px; font-family: Ubuntu;"><span style="font-weight: bold;">FREE</span></span></div>
	<div style="text-align: center; line-height: 1.2;"><span style="display: block; color: #999999; font-weight: 300; font-family: Ubuntu;">Life Time
	</span></div>
	[/cz_title][vc_column_text]
	<div style="text-align: center; line-height: 1.5;"><span style="color: #999999; font-weight: 300; font-size: 14px;">100 GB Disk Space</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> 50 Databases List</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> Free Domain Registration</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> 1 Hosting Space</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> Account Control Panel</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> FREE 24/7 Support</span></div>
	[/vc_column_text][cz_gap height="40px" id="cz_23880"][cz_button title="Sign Up Now" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_89634" sk_button="border-radius:5px;padding-bottom:6px;padding-top:6px;background-color:#aaaaaa;color:#ffffff;font-size:14px;" sk_hover="background-color:#099aad;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3 vc_col-xs-12"][cz_content_box type="1" id="cz_28657" sk_overall="padding-top:0px;padding-bottom:40px;margin-bottom:30px;border-style:solid;border-width:1px;border-color:#cccccc;border-radius:10px;"][cz_title id="cz_11527" sk_overall="border-radius:0 0 10px 10px;padding:5px 20px 5px 20px;margin-bottom:10px;margin-top:-1px;background-color:#cccccc;"]

	<p style="text-align: center;"><span style="font-size: 14px; color: #ffffff;">STANDARD
	</span>

	[/cz_title][cz_title title_pos="cz_title_pos_block" id="cz_36999" sk_overall="margin-bottom:40px;margin-top:30px;"]
	<div style="text-align: center; line-height: 1.2;"><span style="color: #099aad; font-size: 50px; font-family: Ubuntu;"><span style="font-size: 38px;"><sup>$</sup></span><span style="font-weight: bold;">9.99</span></span></div>
	<div style="text-align: center; line-height: 1.2;"><span style="display: block; color: #999999; font-weight: 300; font-family: Ubuntu;">Per Month</span></div>
	[/cz_title][vc_column_text]
	<div style="text-align: center; line-height: 1.5;"><span style="color: #999999; font-weight: 300; font-size: 14px;">500 GB Disk Space</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> 100 Databases List</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> Free Domain Registration</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> 1 Hosting Space</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> Account Control Panel</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> FREE 24/7 Support</span></div>
	[/vc_column_text][cz_gap height="40px" id="cz_92912"][cz_button title="Sign Up Now" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_80753" sk_button="border-radius:5px;padding-bottom:6px;padding-top:6px;background-color:#aaaaaa;color:#ffffff;font-size:14px;" sk_hover="background-color:#099aad;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3 vc_col-xs-12"][cz_content_box type="1" id="cz_83625" sk_overall="background-color:#099aad;padding-top:0px;padding-bottom:40px;margin-bottom:30px;border-radius:10px;"][cz_title id="cz_57847" sk_overall="border-radius:0 0 10px 10px;padding:5px 20px 5px 20px;margin-bottom:10px;margin-top:-1px;background-color:#ffffff;"]

	<p style="text-align: center;"><span style="font-size: 14px; color: #099aad;">BEST SELLER</span></p>
	[/cz_title][cz_title title_pos="cz_title_pos_block" id="cz_16456" sk_overall="margin-bottom:40px;margin-top:30px;"]
	<div style="text-align: center; line-height: 1.2;"><span style="color: #ffffff; font-size: 50px; font-family: Ubuntu;"><span style="font-size: 38px;"><sup>$</sup></span><span style="font-weight: bold;">19.99</span></span></div>
	<div style="text-align: center; line-height: 1.2;"><span style="display: block; color: #ffffff; font-weight: 300; font-family: Ubuntu;">Per Month</span></div>
	[/cz_title][vc_column_text]
	<div style="text-align: center; line-height: 1.5;"><span style="color: #ffffff; font-weight: 300; font-size: 14px;">1000 GB Disk Space</span>
	<span style="color: #ffffff; font-weight: 300; font-size: 14px;"> 200 Databases List</span>
	<span style="color: #ffffff; font-weight: 300; font-size: 14px;"> Free Domain Registration</span>
	<span style="color: #ffffff; font-weight: 300; font-size: 14px;"> 2 Hosting Space</span>
	<span style="color: #ffffff; font-weight: 300; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="color: #ffffff; font-weight: 300; font-size: 14px;"> Account Control Panel</span>
	<span style="color: #ffffff; font-weight: 300; font-size: 14px;"> FREE 24/7 Support</span></div>
	[/vc_column_text][cz_gap height="40px" id="cz_33353"][cz_button title="Sign Up Now" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_24354" sk_button="border-radius:5px;padding-bottom:6px;padding-top:6px;background-color:rgba(255,255,255,0.3);color:#ffffff;font-size:14px;" sk_hover="background-color:#ffffff;color:#099aad;" sk_icon_hover="color:#099aad;"][/cz_content_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3 vc_col-xs-12"][cz_content_box type="1" id="cz_17842" sk_overall="padding-top:0px;padding-bottom:40px;margin-bottom:30px;border-style:solid;border-width:1px;border-color:#cccccc;border-radius:10px;"][cz_title id="cz_80884" sk_overall="border-radius:0 0 10px 10px;padding:5px 20px 5px 20px;margin-bottom:10px;margin-top:-1px;background-color:#cccccc;"]

	<p style="text-align: center;"><span style="font-size: 14px; color: #ffffff;">ULTIMATE
	</span>

	[/cz_title][cz_title title_pos="cz_title_pos_block" id="cz_52614" sk_overall="margin-bottom:40px;margin-top:30px;"]
	<div style="text-align: center; line-height: 1.2;"><span style="color: #099aad; font-size: 50px; font-family: Ubuntu;"><span style="font-size: 38px;"><sup>$</sup></span><span style="font-weight: bold;">39.99</span></span></div>
	<div style="text-align: center; line-height: 1.2;"><span style="display: block; color: #999999; font-weight: 300; font-family: Ubuntu;">Yearly</span></div>
	[/cz_title][vc_column_text]
	<div style="text-align: center; line-height: 1.5;"><span style="color: #999999; font-weight: 300; font-size: 14px;">Unlimited Disk Space</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;">  Unlimited Databases List</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> Free Domain Registration</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;">  Unlimited Hosting Space</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> FREE Ad Coupons</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> Account Control Panel</span>
	<span style="color: #999999; font-weight: 300; font-size: 14px;"> FREE 24/7 Support</span></div>
	[/vc_column_text][cz_gap height="40px" id="cz_98728"][cz_button title="Sign Up Now" btn_position="cz_btn_center" btn_effect="cz_btn_zoom_in" link="url:%23|||" id="cz_74677" sk_button="border-radius:5px;padding-bottom:6px;padding-top:6px;background-color:#aaaaaa;color:#ffffff;font-size:14px;" sk_hover="background-color:#099aad;color:#ffffff;" sk_icon_hover="color:#ffffff;"][/cz_content_box][/vc_column][/vc_row][cz_google_font font="Montserrat"][cz_google_font font="Ubuntu"]',
					),
					array(
						'f' => 'about info 2 columns image 2 buttons radius curved 150_jpg',
						'c' =>'[vc_row][vc_column width="1/3"][cz_image image="'.$imgu.'img26.jpg" id="cz_18630" sk_css="background-color:#ffffff;"][/vc_column][vc_column width="2/3" css=".vc_custom_1506332874733{padding-right: 30px !important;padding-left: 30px !important;}"][cz_title bline="cz_line_after_title" id="cz_68420" sk_lines="background-color:#cccccc;width:50px;height:6px;top:2px;border-radius:5px;"]
	<h3><span style="color: #099aad; font-family: Ubuntu;">Everyone has something important to say!</span></h3>
	[/cz_title][cz_gap height="33px" id="cz_51137"][vc_column_text]
	<div style="line-height: 1.3; text-align: justify;"><span style="font-size: 14px; font-weight: 300; font-family: Montserrat; line-height: 1.5;">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id, condimentum at, laoreet mattis, massa. Sed eleifend nonummy diam. Praesent mauris ante, elementum et, bibendum at, posuere sit amet, nibh. Duis tincidunt lectus quis dui viverra vestibulum. Suspendisse vulputate aliquam dui. Nulla elementum dui ut augue. Aliquam vehicula mi at mauris. Maecenas placerat.</span></div>
	[/vc_column_text][cz_gap height="10px" id="cz_17825"][cz_button title="Free Consultation" btn_position="cz_btn_inline" btn_effect="cz_btn_fill_left" icon_position="after" effect="cz_btn_fx_7" link="url:%23|||" icon="fa fa-comments-o" id="cz_59613" sk_button="font-size:13px;color:#099aad;font-weight:300;background-color:#ffffff;padding:7px 15px;margin-right:10px;border-style:solid;border-bottom-style:solid;border-width:2px;border-color:#099aad;border-radius:5px;" sk_hover="color:#ffffff;background-color:#099aad;" sk_icon="color:#099aad;" sk_icon_hover="color:#ffffff;"][cz_button title="Learn More" btn_position="cz_btn_inline" btn_effect="cz_btn_fill_right" icon_position="after" effect="cz_btn_fx_7" link="url:%23|||" icon="fa fa-long-arrow-right" id="cz_92387" sk_button="font-size:13px;color:#ffffff;font-weight:300;background-color:#099aad;padding:7px 15px;border-style:solid;border-bottom-style:solid;border-width:2px;border-color:#099aad;border-radius:5px;" sk_hover="color:#099aad;background-color:#ffffff;" sk_icon="color:rgba(255,255,255,0.51);" sk_icon_hover="color:#099aad;"][/vc_column][/vc_row][cz_google_font font="Ubuntu"][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => 'client carousel 5 columns radius curved slider logo image 151_jpg',
						'c' =>'[vc_row][vc_column][cz_title bline="cz_line_after_title" id="cz_55118" sk_lines="background-color:#cccccc;width:50px;height:6px;top:5px;border-radius:5px;"]
	<h3 style="text-align: center;"><span style="font-family: Montserrat; color: #333333;"><span style="color: #099aad;">Our Clients</span>
	</span></h3>
	[/cz_title][cz_gap height="45px" id="cz_37414"][cz_carousel slidestoshow="5" arrows_position="arrows_bc" slidestoshow_tablet="2" infinite="true" gap="15px" id="cz_64254" sk_prev_icon="font-size:13px;color:#ffffff;background-color:#099aad;margin-bottom:-30px;margin-left:0px;border-radius:5px;" sk_next_icon="border-radius:5px;color:#ffffff;background-color:#099aad;font-size:13px;margin-left:5px;margin-bottom:-30px;"][cz_image image="'.$imgu.'client.png" id="cz_88790" sk_css="border-radius:5px;border-bottom-style:solid;border-color:#cccccc;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:10px 20px 10px 20px;border-width:1px 1px 1px 1px;"][cz_image image="'.$imgu.'client.png" id="cz_77045" sk_css="border-radius:5px;border-bottom-style:solid;border-color:#cccccc;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:10px 20px 10px 20px;border-width:1px 1px 1px 1px;"][cz_image image="'.$imgu.'client.png" id="cz_37673" sk_css="border-radius:5px;border-bottom-style:solid;border-color:#cccccc;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:10px 20px 10px 20px;border-width:1px 1px 1px 1px;"][cz_image image="'.$imgu.'client.png" id="cz_69403" sk_css="border-radius:5px;border-bottom-style:solid;border-color:#cccccc;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:10px 20px 10px 20px;border-width:1px 1px 1px 1px;"][cz_image image="'.$imgu.'client.png" id="cz_37690" sk_css="border-radius:5px;border-bottom-style:solid;border-color:#cccccc;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:10px 20px 10px 20px;border-width:1px 1px 1px 1px;"][cz_image image="'.$imgu.'client.png" id="cz_87123" sk_css="border-radius:5px;border-bottom-style:solid;border-color:#cccccc;border-top-style:solid;border-right-style:solid;border-left-style:solid;padding:10px 20px 10px 20px;border-width:1px 1px 1px 1px;"][/cz_carousel][cz_gap height="120px" id="cz_32149"][/vc_column][/vc_row][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => '1 column info section cta button radius curved  152_jpg',
						'c' =>'[vc_row full_width="stretch_row" parallax="content-moving" css=".vc_custom_1503827288399{background-image: url('.$imgu.'img29.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}][vc_column][cz_gap height="100px" id="cz_28785"][cz_title id="cz_27311"]
	<h2 style="text-align: center;"><span style="color: #099aad; font-family: Montserrat; line-height: 2;">Do you want new modern website?</span></h2>
	<h4 style="text-align: center;"><span style="color: #808080; font-family: Montserrat; font-weight: 300; line-height: 2;">Yes, of course! So let’s buy xtra now</span></h4>
	[/cz_title][cz_gap height="35px" id="cz_23830"][cz_button title="Buy it Now!" btn_position="cz_btn_center" btn_effect="cz_btn_fill_up" effect="cz_btn_fx_7" link="url:%23|||" icon="fa fa-shopping-cart" id="cz_86840" sk_button="font-size:16px;color:#099aad;font-weight:300;letter-spacing:2px;background-color:rgba(0,0,0,0.01);padding-top:7px;padding-bottom:7px;margin-right:10px;border-style:solid;border-bottom-style:solid;border-width:2px;border-color:#099aad;border-radius:5px;" sk_hover="color:#ffffff;background-color:#099aad;" sk_icon="color:#099aad;border-style:solid;" sk_icon_hover="color:#ffffff;"][cz_gap height="120px" id="cz_56529"][/vc_column][/vc_row][cz_google_font font="Montserrat"]',
					),
					array(
						'f' => 'call phone cta wide button 153_jpg',
						'c' =>'[vc_row full_width="stretch_row_content" el_class="no_padding"][vc_column][cz_button title="Call Us +1 (800) 123 4567" btn_position="cz_btn_block" btn_effect="cz_btn_fill_up" icon="fa fa-phone" link="url:%23|||" id="cz_63672" sk_button="font-size:32px;font-family:Ubuntu;background-color:#099aad;padding-top:30px;padding-bottom:30px;" sk_hover="color:#ffffff;background-color:#066c79;" sk_icon="border-radius:100px;background-color:#ffffff;padding:12px 15px 12px 15px;margin-right:15px;color:#099aad;" sk_icon_hover="color:#066c79;" sk_button_tablet="font-size:24px;" sk_button_mobile="font-size:20px;" cz_button=""][/vc_column][/vc_row][cz_google_font font="Ubuntu"]',
					),
					array(
						'f' => 'gallery photo image instagram masonry 4 columns square 154_jpg',
						'c' =>'[vc_row][vc_column][cz_gallery img_fx="cz_grid_blur" id="cz_72653" gap="0px" overlay_css_background="rgba(10,10,10,0.55)" sk_overlay="background-color:rgba(255,235,59,0.7);" sk_icon="color:#000000;" images="0,0,0,0,0,0,0,0"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'gallery photo image instagram masonry fit row justified 155_jpg',
						'c' =>'[vc_row][vc_column][cz_gallery layout="cz_justified" img_fx="cz_grid_blur" overlay_outer_space="cz_grid_overlay_20px" last_row="true" id="cz_18816" overlay_css_background="rgba(0,30,105,0.64)" css_font-size="14px" overlay_css_background_2="rgba(40,255,190,0.03)" icon_css_background="rgba(0,30,105,0.64)" icon_css_color="#eeee22" icon_css_font-size="20px" icon_css=".vc_custom_1511781945160{padding-top: 10px !important;padding-right: 10px !important;padding-bottom: 10px !important;padding-left: 10px !important;border-radius: 63px !important;}" images="0,0,0,0,0,0" gap="10px" sk_overlay="background-color:rgba(255,0,0,0.75);"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'gallery photo image instagram metro grid 3 columns 156_jpg',
						'c' =>'[vc_row][vc_column][cz_gallery layout="cz_metro_2 cz_grid_c4" hover_pos="cz_grid_1_bot tar" hover_vis="cz_grid_1_always_show" img_fx="cz_grid_blur" id="cz_39485" overlay_css_background="rgba(0,30,105,0.64)" css_font-size="14px" overlay_css_background_2="rgba(255,255,255,0.04)" icon_css_color="#ffffff" icon_css_font-size="18px" icon_css=".vc_custom_1511782007686{margin-right: -20px !important;margin-bottom: -20px !important;padding-top: 8px !important;padding-right: 8px !important;padding-bottom: 8px !important;padding-left: 8px !important;}" overlay_css_gradient_orientation="-45deg" overlay_css_background_3="rgba(255,255,255,0.01)" icon_css_background="rgba(0,30,105,0.21)" images="0,0,0,0,0"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'gallery photo image instagram metro grid 3 columns 157_jpg',
						'c' =>'[vc_row][vc_column][cz_gallery layout="cz_metro_4 cz_grid_c4" hover="cz_grid_1_no_title cz_grid_1_w_info" hover_fx="cz_grid_zou" img_fx="cz_grid_zoom_rotate" overlay_outer_space="cz_grid_overlay_20px" subtitle_css_display="table;margin: 0 auto" id="cz_63364" overlay_css_background="rgba(255,255,255,0.5)" css_font-size="14px" icon_css_color="#ffffff" icon_css_font-size="22px" icon_css=".vc_custom_1511776021690{padding-top: 8px !important;padding-right: 8px !important;padding-bottom: 8px !important;padding-left: 8px !important;border-radius: 5px !important;}" images_radius="5px" icon_css_background="#000000" subtitle_css=".vc_custom_1511776021698{padding-top: 5px !important;padding-right: 10px !important;padding-bottom: 5px !important;padding-left: 10px !important;background-color: #000000 !important;border-radius: 5px !important;}" sk_overlay="background-color:rgba(255,255,255,0.7);" sk_icon="color:#000000;" sk_subtitle="color:#000000;" images="0,0,0,0,0"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'gallery photo image instagram masonry grid 4 columns 158_jpg',
						'c' =>'[vc_row][vc_column][cz_gallery layout="cz_hr_grid cz_grid_c4" hover_fx="cz_grid_sil" img_fx="cz_grid_shine" subtitle_css_display="table;margin: 0 auto" id="cz_35877" overlay_css_background="rgba(0,0,0,0.6)" css_font-size="14px" icon_css_color="#000000" icon_css_font-size="22px" icon_css=".vc_custom_1511776323020{padding-top: 8px !important;padding-right: 8px !important;padding-bottom: 8px !important;padding-left: 8px !important;border-radius: 60px !important;}" icon_css_background="#ffffff" subtitle_css=".vc_custom_1511776323024{padding-top: 5px !important;padding-right: 10px !important;padding-bottom: 5px !important;padding-left: 10px !important;background-color: #000000 !important;border-radius: 5px !important;}" box_css_box-shadow="horizontal:1px|vertical:8px|blur:34px|color:rgba(0,0,0,0.2)|style:outset|" box_css=".vc_custom_1511776323016{border-radius: 10px !important;}" images="0,0,0,0"][/vc_column][/vc_row][vc_row]',
					),
					array(
						'f' => 'gallery photo image instagram metro 4 columns 159_jpg',
						'c' =>'[vc_row][vc_column][cz_gallery layout="cz_metro_8 cz_hr_grid cz_grid_c4" hover="cz_grid_1_no_desc" hover_fx="cz_grid_sih" img_fx="cz_grid_flash" subtitle_css_display="table;margin: 0 auto" id="cz_73551" overlay_css_background="rgba(0,30,105,0.76)" css_font-size="14px" icon_css_color="#000000" icon_css_font-size="24px" icon_css=".vc_custom_1511782020616{padding-top: 8px !important;padding-right: 8px !important;padding-bottom: 8px !important;padding-left: 8px !important;}" icon_css_background="#ffffff" box_css_box-shadow="horizontal:1px|vertical:8px|blur:34px|color:rgba(0,0,0,0.1)|style:outset|" title_limit="8" images="0,0,0,0,0,0"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'gallery photo image instagram metro 6 columns 160_jpg',
						'c' =>'[vc_row][vc_column][cz_gallery layout="cz_metro_9 cz_grid_c6" hover="cz_grid_1_w_info cz_grid_1_no_icon cz_grid_1_no_title " subtitle_pos="cz_grid_1_title_rev" hover_fx="cz_grid_zin" img_fx="cz_grid_zoom_in" subtitle_css_display="table;margin: 0 auto" id="cz_64787" overlay_css_background="rgba(0,30,105,0.75)" css_font-size="14px" title_limit="8" gap="35px" icon_css_color="#000000" icon_css_font-size="24px" icon_css_background="#ffffff" icon_css=".vc_custom_1511782034684{padding-top: 8px !important;padding-right: 8px !important;padding-bottom: 8px !important;padding-left: 8px !important;}" subtitle_css_font-size="14px" images_radius="4px" sk_overall="border-radius:20px;" sk_overlay="background-color:rgba(156,37,158,0.75);" images="0,0,0,0,0,0,0,0"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'gallery photo image instagram grid 5 columns 161_jpg',
						'c' =>'[vc_row][vc_column][cz_gallery type="instagram" insta_username="newlinewordpress" insta_count="10" insta_size="original" layout="cz_grid_c5" hover="cz_grid_1_no_title cz_grid_1_w_info" subtitle_pos="cz_grid_1_title_rev" hover_vis="cz_grid_1_hide_on_hover" hover_fx="cz_grid_fir" img_fx="cz_grid_zoom_rotate" icon="fa fa-instagram" subtitle_css_display="table;margin: 0 auto" id="cz_37818" overlay_css_background="rgba(0,0,0,0.54)" css_font-size="14px" title_limit="8" gap="2px" icon_css_font-size="20px" icon_css=".vc_custom_1511777021128{padding-top: 8px !important;padding-right: 8px !important;padding-bottom: 8px !important;padding-left: 8px !important;}" subtitle_css_font-size="14px" images_radius="2px"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'gallery photo image instagram grid 4 columns 162_jpg',
						'c' =>'[vc_row][vc_column][cz_gallery hover="cz_grid_1_no_title cz_grid_1_w_info" subtitle_pos="cz_grid_1_title_rev" hover_fx="cz_grid_zin" img_fx="cz_grid_zoom_in" icon="fa fa-instagram" subtitle_css_display="table;margin: 0 auto" id="cz_47328" overlay_css_background="rgba(0,0,0,0.54)" css_font-size="14px" title_limit="8" gap="40px" icon_css_font-size="32px" icon_css=".vc_custom_1511777567782{margin-bottom: 0px !important;padding-top: 8px !important;padding-right: 8px !important;padding-bottom: 8px !important;padding-left: 8px !important;}" subtitle_css_font-size="14px" box_css=".vc_custom_1511777567779{border-radius: 100% !important;}" box_css_box-shadow="horizontal:1px|vertical:10px|blur:40px|color:rgba(0,0,0,0.1)|style:outset|" sk_overall="border-radius:100%;box-shadow:0px 6px 30px rgba(0,0,0,0.1);" sk_overlay="background-color:transparent;background-image:linear-gradient(-45deg,rgba(0,0,0,0.9),rgba(0,0,0,0.6),rgba(0,0,0,0.9));" images="0,0,0,0,0,0,0,0"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'gallery photo image instagram grid 3 columns 163_jpg',
						'c' =>'[vc_row][vc_column][cz_gallery layout="cz_grid_c3" hover_vis="cz_grid_1_always_show" hover_fx="cz_grid_fir" img_fx="cz_grid_grayscale_remove" icon="fa fa-file-picture-o" subtitle_css_display="table;margin: 0 auto" id="cz_33882" overlay_css_background="rgba(0,0,0,0.72)" css_font-size="14px" title_limit="8" gap="60px" icon_css_font-size="26px" icon_css=".vc_custom_1511780321715{margin-bottom: -20px !important;margin-left: -20px !important;padding-top: 8px !important;padding-right: 8px !important;padding-bottom: 8px !important;padding-left: 8px !important;}" subtitle_css_font-size="14px" icon_css_color="#ffffff" overlay_css_gradient_orientation="45deg" overlay_css_background_2="rgba(255,255,255,0.01)" overlay_css_background_3="rgba(255,255,255,0.01)" box_css_box-shadow="horizontal:-10px|vertical:10px|blur:30px|color:rgba(0,0,0,0.2)|style:outset|" images="195,194,193,192,190,191"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'gallery photo image instagram metro grid 4 columns 164_jpg',
						'c' =>'[vc_row][vc_column][cz_gallery layout="cz_masonry cz_grid_c4 cz_grid_1big" hover_fx="cz_grid_zin" img_fx="cz_grid_zoom_in" subtitle_css_display="table;margin: 0 auto" id="cz_13293" overlay_css_background="rgba(0,30,105,0.75)" css_font-size="14px" title_limit="8" gap="30px" icon_css_color="#000000" icon_css_font-size="24px" icon_css_background="#ffffff" icon_css=".vc_custom_1511782034684{padding-top: 8px !important;padding-right: 8px !important;padding-bottom: 8px !important;padding-left: 8px !important;}" subtitle_css_font-size="14px" images_radius="4px" sk_overall="border-radius:10px;" sk_overlay="background-color:transparent;background-image:linear-gradient(-45deg,rgba(63,81,181,0.75),rgba(156,37,158,0.75));" images="0,0,0,0,0,0,0,0,0"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'gallery photo image instagram masonry 3 columns 165_jpg',
						'c' =>'[vc_row][vc_column][cz_gallery layout="cz_masonry cz_grid_c3" hover_fx="cz_grid_zin" img_fx="cz_grid_zoom_in" overlay_outer_space="cz_grid_overlay_20px" subtitle_css_display="table;margin: 0 auto" id="cz_61805" overlay_css_background="rgba(0,30,105,0.75)" css_font-size="14px" title_limit="8" gap="10px" icon_css_color="#000000" icon_css_font-size="24px" icon_css_background="#ffffff" icon_css=".vc_custom_1511782034684{padding-top: 8px !important;padding-right: 8px !important;padding-bottom: 8px !important;padding-left: 8px !important;}" subtitle_css_font-size="14px" images_radius="4px" sk_overlay="background-color:transparent;background-image:linear-gradient(45deg,rgba(62,16,89,0.75),rgba(0,255,232,0.75));" images="0,0,0,0,0,0,0,0,0,0,0,0,0"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'gallery photo image instagram masonry 4 columns 166_jpg',
						'c' =>'[vc_row][vc_column][cz_gallery layout="cz_masonry cz_grid_c4" hover_pos="cz_grid_1_bot tal" hover_fx="cz_grid_fib" img_fx="cz_grid_zoom_in" subtitle_css_display="table;margin: 0 auto" id="cz_97089" overlay_css_background="rgba(0,30,105,0.75)" css_font-size="14px" title_limit="8" gap="5px" icon_css_color="#000000" icon_css_font-size="24px" icon_css_background="#ffffff" icon_css=".vc_custom_1511782034684{padding-top: 8px !important;padding-right: 8px !important;padding-bottom: 8px !important;padding-left: 8px !important;}" subtitle_css_font-size="14px" images_radius="4px" sk_overlay="background-color:transparent;background-image:linear-gradient(-45deg,rgba(255,0,8,0.75),rgba(96,0,3,0.75));" images="0,0,0,0,0,0,0,0,0,0,0,0,0"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'blog posts 4 columns grid 167_jpg',
						'c' =>'[vc_row][vc_column][cz_posts hover="cz_grid_1_no_icon cz_grid_1_no_desc" hover_vis="cz_grid_1_hide_on_hover" id="cz_30575" query="" subtitles="%5B%7B%22t%22%3A%22author_full_date%22%7D%5D" posts_per_page="8" sk_overlay="background-color:transparent;background-image:linear-gradient(0deg,rgba(0,0,0,0.7),rgba(0,0,0,0.2));" sk_title="line-height:22px;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'blog posts 3 columns grid 168_jpg',
						'c' =>'[vc_row][vc_column][cz_posts layout="cz_grid_c3" hover="cz_grid_1_title_sub_after" img_fx="cz_grid_blur" icon="fa fa-file-text-o" id="cz_28543" query="" subtitles="%5B%7B%22t%22%3A%22author_icon_date%22%2C%22i%22%3A%22fa%20fa-pencil%22%7D%5D" posts_per_page="3" si_css_font-size="18px" si_css=".vc_custom_1511696646267{border-radius: 50px !important;}" subtitle_css_font-size="13px" sk_meta="color:#111111;line-height:16px;" sk_meta_icons="background-color:#ff5722;padding:2px;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'blog posts 4 columns grid 169_jpg',
						'c' =>'[vc_row][vc_column][cz_posts hover="cz_grid_1_title_sub_after" hover_vis="cz_grid_1_hide_on_hover" img_fx="cz_grid_blur" icon="fa fa-file-text-o" order="ASC" subtitle_all_center="true" id="cz_12665" query="" subtitles="%5B%7B%22t%22%3A%22cats_4%22%7D%5D" posts_per_page="4" si_css_font-size="18px" si_css=".vc_custom_1511696646267{border-radius: 50px !important;}" subtitle_css_font-size="13px" sk_meta="color:#eeeeee;font-weight:300;line-height:16px;margin-top:20px;margin-bottom:30px;" sk_title="font-size:18px;text-align:center;padding-top:15px;padding-bottom:5px;" sk_overall="border-style:solid;border-width:1px;border-color:rgba(0,0,0,0.2);border-radius:5px;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'blog posts 4 columns grid dark 170_jpg',
						'c' =>'[vc_row][vc_column][cz_posts hover="cz_grid_1_title_sub_after" hover_vis="cz_grid_1_hide_on_hover" icon="fa fa-file-text-o" order="ASC" subtitle_all_center="true" id="cz_18340" query="" subtitles="%5B%7B%22t%22%3A%22date%22%7D%5D" posts_per_page="4" si_css_font-size="18px" si_css=".vc_custom_1511696646267{border-radius: 50px !important;}" subtitle_css_font-size="13px" sk_meta="color:rgba(255,255,255,0.3);font-weight:300;font-style:italic;line-height:16px;margin-top:15px;margin-bottom:15px;" sk_meta_icons="background-color:#ff5722;padding:2px;" sk_title="font-size:17px;color:#ffffff;text-align:center;margin-top:30px;margin-bottom:10px;" sk_overall="background-color:#111111;padding:20px;border-color:rgba(0,0,0,0.2);"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'blog posts 3 columns grid 171_jpg',
						'c' =>'[vc_row][vc_column][cz_posts layout="cz_grid_c3" hover="cz_grid_1_title_sub_after" img_fx="cz_grid_blur" icon="fa fa-file-text-o" subtitle_all_center="true" id="cz_84842" query="" subtitles="%5B%7B%22t%22%3A%22date%22%7D%5D" posts_per_page="3" si_css_font-size="18px" si_css=".vc_custom_1511696646267{border-radius: 50px !important;}" subtitle_css_font-size="13px" sk_meta="color:#ffffff;font-weight:300;font-style:italic;line-height:16px;background-color:#ff5722;padding-top:10px;padding-bottom:10px;margin-top:0px;" sk_meta_icons="background-color:#ff5722;padding:2px;" sk_title="color:#ffffff;text-align:center;font-weight:300;background-color:#000000;padding-top:30px;padding-bottom:30px;margin-top:-20px;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'blog posts 4 columns grid 172_jpg',
						'c' =>'[vc_row][vc_column][cz_posts img_fx="cz_grid_blur" subtitle_all_center="true" id="cz_33998" query="" subtitles="%5B%7B%22t%22%3A%22date%22%7D%5D" posts_per_page="4" si_css_font-size="18px" si_css=".vc_custom_1511696646267{border-radius: 50px !important;}" subtitle_css_font-size="13px" sk_meta="line-height:16px;background-color:#ff5722;padding-top:5px;padding-bottom:5px;margin-top:0px;" sk_meta_icons="background-color:#ff5722;padding:2px;" sk_title="color:#ffffff;text-align:center;font-weight:300;line-height:20px;background-color:rgba(0,0,0,0.6);padding-top:20px;padding-bottom:20px;margin-top:-20px;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'blog posts 2 columns grid simple 173_jpg',
						'c' =>'[vc_row][vc_column][cz_posts layout="cz_grid_c2" hover="cz_grid_1_title_sub_after cz_grid_1_has_excerpt cz_grid_1_no_image" id="cz_56114" query="" subtitles="%5B%7B%22t%22%3A%22author_icon_date%22%2C%22i%22%3A%22fa%20fa-pencil%22%7D%5D" posts_per_page="4" si_css_font-size="18px" si_css=".vc_custom_1511696646267{border-radius: 50px !important;}" subtitle_css_font-size="13px" sk_meta="color:rgba(0,0,0,0.5);line-height:16px;" sk_meta_icons="background-color:#ff5722;padding:2px;" sk_excerpt="font-size:13px;color:rgba(0,0,0,0.65);font-weight:400;line-height:16px;" sk_overall="padding:30px;margin-bottom:20px;" sk_overall_hover="box-shadow:0px 0px 35px rgba(0,0,0,0.13);"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'blog posts 5 columns grid simple 174_jpg',
						'c' =>'[vc_row][vc_column][cz_posts layout="cz_grid_c5" hover="cz_grid_1_title_sub_after cz_grid_1_has_excerpt cz_grid_1_no_image" order="ASC" id="cz_87705" query="" subtitles="%5B%7B%22t%22%3A%22date%22%7D%5D" posts_per_page="5" si_css_font-size="18px" si_css=".vc_custom_1511696646267{border-radius: 50px !important;}" subtitle_css_font-size="13px" sk_meta="font-size:11px;color:#aaaaaa;font-weight:300;font-style:italic;line-height:16px;" sk_meta_icons="background-color:#ff5722;padding:2px;" sk_excerpt="font-size:13px;color:#000000;font-weight:200;line-height:16px;" sk_overall="padding:30px;margin-bottom:20px;" sk_overall_hover="box-shadow:0px 5px 35px rgba(0,0,0,0.09);" sk_title="font-size:32px;color:#3f51b5;font-weight:200;line-height:32px;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'blog posts 4 columns grid simple 175_jpg',
						'c' =>'[vc_row equal_height="yes"][vc_column][cz_posts hover="cz_grid_1_title_sub_after cz_grid_1_no_image" order="ASC" id="cz_90382" query="" subtitles="%5B%7B%22t%22%3A%22date%22%7D%5D" posts_per_page="4" si_css_font-size="18px" si_css=".vc_custom_1511696646267{border-radius: 50px !important;}" subtitle_css_font-size="13px" sk_meta="color:rgba(0,0,0,0.44);font-style:italic;line-height:16px;margin-top:60px;" sk_meta_icons="background-color:#ff5722;padding:2px;" sk_excerpt="font-size:13px;color:rgba(0,0,0,0.65);font-weight:400;line-height:16px;" sk_overall="padding:25px 15px;margin-bottom:20px;" sk_title="font-size:32px;color:#ff5722;line-height:30px;" sk_overall_hover="border-style:solid;border-bottom-width:5px;border-color:#ff5722;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'blog posts 3 columns grid metro 176_jpg',
						'c' =>'[vc_row][vc_column][cz_posts layout="cz_metro_2 cz_grid_c4" subtitle_pos="cz_grid_1_title_rev" hover_vis="cz_grid_1_hide_on_hover" hover_fx="cz_grid_fir" id="cz_95496" query="" subtitles="%5B%7B%22t%22%3A%22date%22%2C%22i%22%3A%22fa%20fa-clock-o%22%7D%5D" posts_per_page="5" si_css=".vc_custom_1511781160135{border-radius: 50px !important;}" subtitle_css_font-size="13px" overlay_css_background="#00145f" overlay_css_background_2="rgba(155,240,255,0.17)" si_css_font-size="20px" subtitle_css_color="#eeee22" css=".vc_custom_1511781160129{padding-right: 10px !important;padding-bottom: 10px !important;padding-left: 10px !important;}" subtitle_css=".vc_custom_1511781160134{padding-right: 10px !important;padding-left: 10px !important;}" sk_overlay="background-color:transparent;background-image:linear-gradient(0deg,rgba(0,0,0,0.7),rgba(0,0,0,0.15));" gap="5px" sk_meta="color:rgba(255,255,255,0.5);font-weight:200;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'blog posts 2 columns grid 177_jpg',
						'c' =>'[vc_row][vc_column][cz_posts layout="cz_justified" hover_pos="cz_grid_1_mid tac" hover_vis="cz_grid_1_hide_on_hover" hover_fx="cz_grid_zin" img_fx="cz_grid_zoom_out" last_row="true" subtitle_all_center="true" id="cz_31520" query="" subtitles="%5B%7B%22t%22%3A%22date%22%2C%22i%22%3A%22fa%20fa-clock-o%22%7D%2C%7B%22t%22%3A%22author%22%2C%22i%22%3A%22fa%20fa-user%22%7D%5D" posts_per_page="4" si_css=".vc_custom_1511770713501{border-radius: 50px !important;}" subtitle_css_font-size="13px" overlay_css_background="rgba(0,0,0,0.1)" overlay_css_background_2="rgba(0,0,0,0.75)" subtitle_css_color="#c1c1c1" css=".vc_custom_1511770713493{padding-right: 10px !important;padding-left: 10px !important;}" subtitle_css=".vc_custom_1511770713501{padding-right: 10px !important;padding-left: 10px !important;}" overlay_css_background_3="rgba(0,0,0,0.1)" css_font-size="20px" sk_title="font-size:41px;line-height:52px;text-shadow:1px 1px 1px rgba(0,0,0,0.43);" sk_meta="text-shadow:1px 1px 1px rgba(0,0,0,0.5);"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'blog posts 4 columns grid blue 178_jpg',
						'c' =>'[vc_row][vc_column][cz_posts hover_pos="cz_grid_1_bot tac" hover_vis="cz_grid_1_hide_on_hover" img_fx="cz_grid_grayscale_remove" subtitle_all_center="true" id="cz_36125" query="" subtitles="%5B%7B%22t%22%3A%22date%22%7D%5D" posts_per_page="4" si_css=".vc_custom_1511765321220{border-radius: 50px !important;}" subtitle_css_font-size="13px" overlay_css_background="rgba(0,20,95,0.89)" subtitle_css_color="#c1c1c1" css=".vc_custom_1511765321212{padding-right: 10px !important;padding-left: 10px !important;}" subtitle_css=".vc_custom_1511765321216{padding-right: 10px !important;padding-left: 10px !important;}" subtitle_css_letter-spacing="4px" sk_overlay="background-color:rgba(0,27,181,0.7);"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'blog posts 3 columns grid metro blue 179_jpg',
						'c' =>'[vc_row][vc_column][cz_posts layout="cz_metro_3 cz_grid_c4" hover_pos="cz_grid_1_bot tac" hover_vis="cz_grid_1_hide_on_hover" img_fx="cz_grid_grayscale_remove" subtitle_all_center="true" id="cz_40799" query="" subtitles="%5B%7B%22t%22%3A%22date%22%7D%5D" posts_per_page="5" si_css=".vc_custom_1511765321220{border-radius: 50px !important;}" subtitle_css_font-size="13px" overlay_css_background="rgba(0,20,95,0.89)" subtitle_css_color="#c1c1c1" css=".vc_custom_1511765321212{padding-right: 10px !important;padding-left: 10px !important;}" subtitle_css=".vc_custom_1511765321216{padding-right: 10px !important;padding-left: 10px !important;}" subtitle_css_letter-spacing="4px" sk_overlay="background-color:transparent;background-image:linear-gradient(0deg,rgba(17,23,196,0.7),rgba(17,23,196,0.3));" gap="2px"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'blog posts 3 columns grid gradient 180_jpg',
						'c' =>'[vc_row][vc_column][cz_posts layout="cz_grid_c3" hover_pos="cz_grid_1_bot tac" hover_vis="cz_grid_1_hide_on_hover" img_fx="cz_grid_grayscale_remove" subtitle_all_center="true" id="cz_12087" query="" subtitles="%5B%7B%22t%22%3A%22date%22%7D%5D" posts_per_page="6" si_css=".vc_custom_1511765321220{border-radius: 50px !important;}" subtitle_css_font-size="13px" overlay_css_background="rgba(0,20,95,0.89)" subtitle_css_color="#c1c1c1" css=".vc_custom_1511765321212{padding-right: 10px !important;padding-left: 10px !important;}" subtitle_css=".vc_custom_1511765321216{padding-right: 10px !important;padding-left: 10px !important;}" subtitle_css_letter-spacing="4px" sk_overlay="background-color:transparent;background-image:linear-gradient(-45deg,rgba(0,27,181,0.7),rgba(156,37,158,0.75));" sk_overall="border-radius:7px;" gap="0px" sk_meta="font-weight:300;font-style:italic;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'blog posts 2 columns grid metro 181_jpg',
						'c' =>'[vc_row][vc_column][cz_posts layout="cz_metro_5 cz_grid_c3" hover_vis="cz_grid_1_hide_on_hover" hover_fx="cz_grid_fir" img_fx="cz_grid_flash" css_display="table" subtitle_css_display="inline-block" id="cz_78092" query="" subtitles="%5B%7B%22t%22%3A%22date%22%2C%22p%22%3A%22On%20%22%2C%22tc%22%3A%223%22%7D%2C%7B%22t%22%3A%22author%22%2C%22p%22%3A%22By%22%7D%5D" posts_per_page="3" si_css=".vc_custom_1511767633613{border-radius: 50px !important;}" subtitle_css_font-size="12px" css=".vc_custom_1511767633605{margin-bottom: -5px !important;padding-top: 10px !important;padding-right: 20px !important;padding-bottom: 10px !important;padding-left: 20px !important;background-color: #0a0a0a !important;border-radius: 5px !important;}" subtitle_css=".vc_custom_1511767633609{padding-top: 2px !important;padding-right: 5px !important;padding-bottom: 3px !important;padding-left: 15px !important;background-color: #0a0a0a !important;border-radius: 5px !important;}" overlay_css_background_2="rgba(0,0,0,0.02)" box_css=".vc_custom_1511767633597{background-color: #000000 !important;}" css_color="#ffffff" images_radius="4px" overlay_css_background="rgba(255,255,255,0.01)" sk_overlay="background-color:rgba(0,0,0,0.7);" sk_title="font-size:32px;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'blog posts 3 columns grid 182_jpg',
						'c' =>'[vc_row][vc_column][cz_posts layout="cz_grid_c3" hover_vis="cz_grid_1_always_show" hover_fx="cz_grid_fir" img_fx="cz_grid_flash" css_display="table" subtitle_css_display="inline-block" id="cz_63019" query="" subtitles="%5B%7B%22t%22%3A%22date%22%2C%22p%22%3A%22On%20%22%2C%22tc%22%3A%223%22%7D%5D" posts_per_page="3" si_css=".vc_custom_1511767633613{border-radius: 50px !important;}" subtitle_css_font-size="12px" css=".vc_custom_1511767633605{margin-bottom: -5px !important;padding-top: 10px !important;padding-right: 20px !important;padding-bottom: 10px !important;padding-left: 20px !important;background-color: #0a0a0a !important;border-radius: 5px !important;}" subtitle_css=".vc_custom_1511767633609{padding-top: 2px !important;padding-right: 5px !important;padding-bottom: 3px !important;padding-left: 15px !important;background-color: #0a0a0a !important;border-radius: 5px !important;}" overlay_css_background_2="rgba(0,0,0,0.02)" box_css=".vc_custom_1511767633597{background-color: #000000 !important;}" css_color="#ffffff" images_radius="4px" overlay_css_background="rgba(255,255,255,0.01)" sk_title="line-height:20px;background-color:rgba(0,0,0,0.7);padding:10px;" sk_overall_hover="border-style:solid;border-width:10px;border-color:#ff0000;" sk_overall="border-style:solid;border-width:10px;border-color:#000000;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'blog posts 3 columns grid curved radius 183_jpg',
						'c' =>'[vc_row][vc_column][cz_posts layout="cz_grid_c3" hover_vis="cz_grid_1_always_show" hover_fx="cz_grid_fir" subtitle_css_display="inline-block" id="cz_42353" query="" subtitles="%5B%7B%22t%22%3A%22date%22%2C%22p%22%3A%22On%20%22%2C%22tc%22%3A%223%22%7D%2C%7B%22t%22%3A%22author%22%2C%22p%22%3A%22By%22%7D%5D" posts_per_page="3" si_css=".vc_custom_1511767951255{border-radius: 50px !important;}" subtitle_css_font-size="12px" css=".vc_custom_1511767951247{border-bottom-width: 1px !important;border-left-width: 1px !important;padding-bottom: 10px !important;padding-left: 20px !important;border-left-color: rgba(255,255,255,0.47) !important;border-left-style: solid !important;border-bottom-color: rgba(255,255,255,0.47) !important;border-bottom-style: solid !important;}" overlay_css_background_2="rgba(255,255,255,0.01)" box_css=".vc_custom_1511767951239{background-color: #000000 !important;}" css_color="#ffffff" images_radius="4px" overlay_css_background="rgba(10,0,0,0.8)" overlay_css_gradient_orientation="90deg" sk_overall_hover="margin-top:-20px;" sk_img="border-radius:10px;" gap="30px"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'blog posts 4 columns grid wide 184_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces"][vc_column][cz_posts hover="cz_grid_1_no_icon cz_grid_1_has_excerpt" hover_pos="cz_grid_1_mid tac" hover_fx="cz_grid_sih" subtitle_all_center="true" subtitle_css_display="inline-block" id="cz_62178" query="" subtitles="%5B%7B%22t%22%3A%22date%22%2C%22r%22%3A%22cz_post_data_r%22%2C%22tc%22%3A%223%22%7D%5D" posts_per_page="4" si_css=".vc_custom_1511781269220{border-radius: 50px !important;}" subtitle_css_font-size="12px" css_color="#ffffff" overlay_css_background="rgba(0,0,75,0.8)" overlay_css_gradient_orientation="90deg" gap="0px" css=".vc_custom_1511781269214{padding-top: 20px !important;padding-right: 20px !important;padding-left: 20px !important;}" subtitle_css=".vc_custom_1511781269219{padding-right: 20px !important;padding-left: 20px !important;}" excerpt_css=".vc_custom_1511781269222{padding-right: 20px !important;padding-left: 20px !important;}" sk_excerpt="font-size:14px;color:#000000;font-weight:400;line-height:16px;" sk_overlay="background-color:rgba(255,255,255,0.69);" sk_title="font-size:28px;color:#000000;line-height:32px;" sk_meta="font-size:10px;color:#ffffff;text-align:center;font-weight:400;background-color:#000000;padding:2px 10px 2px 0px;margin-top:15px;display:inline-block;" sk_overall_hover="box-shadow:1px 10px 25px rgba(0,0,0,0.24);CDVZtransform:scale(1.1);z-index:999;CDVZ"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'blog posts 5 columns grid wide 185_jpg',
						'c' =>'[vc_row full_width="stretch_row_content_no_spaces"][vc_column][cz_posts layout="cz_grid_c5" hover="cz_grid_1_no_icon cz_grid_1_no_desc" hover_pos="cz_grid_1_mid tac" hover_vis="cz_grid_1_hide_on_hover" hover_fx="cz_grid_zou" subtitle_all_center="true" subtitle_css_display="inline-block" id="cz_77476" query="" subtitles="%5B%7B%22t%22%3A%22date%22%2C%22r%22%3A%22cz_post_data_r%22%2C%22tc%22%3A%223%22%7D%5D" posts_per_page="5" si_css=".vc_custom_1511781269220{border-radius: 50px !important;}" subtitle_css_font-size="12px" css_color="#ffffff" overlay_css_background="rgba(0,0,75,0.8)" overlay_css_gradient_orientation="90deg" gap="0px" css=".vc_custom_1511781269214{padding-top: 20px !important;padding-right: 20px !important;padding-left: 20px !important;}" subtitle_css=".vc_custom_1511781269219{padding-right: 20px !important;padding-left: 20px !important;}" excerpt_css=".vc_custom_1511781269222{padding-right: 20px !important;padding-left: 20px !important;}" sk_excerpt="font-size:14px;color:#000000;font-weight:400;line-height:16px;" sk_overlay="background-color:rgba(255,255,255,0.5);" sk_title="font-size:28px;color:#000000;line-height:32px;" sk_meta="font-size:10px;color:#ffffff;text-align:center;font-weight:400;background-color:#000000;padding:2px 10px 2px 0px;margin-top:15px;display:inline-block;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'blog posts 3 columns grid carousel 186_jpg',
						'c' =>'[vc_row][vc_column][cz_carousel slidestoshow_tablet="2" infinite="true" centermode="true" id="cz_29470" sk_next_icon="font-size:13px;color:#ffffff;background-color:#ff5722;" sk_prev_icon="font-size:13px;color:#ffffff;background-color:#ff5722;"][cz_posts layout="cz_grid_c3" hover="cz_grid_1_title_sub_after" img_fx="cz_grid_blur" icon="fa fa-file-text-o" id="cz_84037" query="" subtitles="%5B%7B%22t%22%3A%22author_icon_date%22%2C%22i%22%3A%22fa%20fa-pencil%22%7D%5D" posts_per_page="6" si_css_font-size="18px" si_css=".vc_custom_1511696646267{border-radius: 50px !important;}" subtitle_css_font-size="13px" sk_meta="color:#111111;line-height:16px;" sk_meta_icons="background-color:#ff5722;padding:2px;"][/cz_carousel][/vc_column][/vc_row]',
					),
					array(
						'f' => 'blog posts 3 columns grid carousel 187_jpg',
						'c' =>'[vc_row][vc_column][cz_carousel arrows_position="arrows_bc" slidestoshow_tablet="2" infinite="true" centermode="true" id="cz_41440" sk_next_icon="font-size:10px;color:#ffffff;background-color:#001bb5;margin-left:5px;" sk_prev_icon="font-size:10px;color:#ffffff;background-color:#001bb5;margin-right:5px;"][cz_posts hover_pos="cz_grid_1_bot tac" hover_vis="cz_grid_1_hide_on_hover" img_fx="cz_grid_grayscale_remove" subtitle_all_center="true" id="cz_38138" query="" subtitles="%5B%7B%22t%22%3A%22date%22%7D%5D" posts_per_page="6" si_css=".vc_custom_1511765321220{border-radius: 50px !important;}" subtitle_css_font-size="13px" overlay_css_background="rgba(0,20,95,0.89)" subtitle_css_color="#c1c1c1" css=".vc_custom_1511765321212{padding-right: 10px !important;padding-left: 10px !important;}" subtitle_css=".vc_custom_1511765321216{padding-right: 10px !important;padding-left: 10px !important;}" subtitle_css_letter-spacing="4px" sk_overlay="background-color:rgba(0,27,181,0.7);"][/cz_carousel][/vc_column][/vc_row]',
					),
					array(
						'f' => 'blog posts 3 columns grid carousel 188_jpg',
						'c' =>'[vc_row][vc_column][cz_carousel arrows_position="no_arrows" dots_position="dots_bc" dots_style="dots_circle dots_circle_2" slidestoshow_tablet="2" infinite="true" centermode="true" id="cz_48426" sk_next_icon="font-size:10px;color:#ffffff;background-color:#001bb5;margin-left:5px;" sk_prev_icon="font-size:10px;color:#ffffff;background-color:#001bb5;margin-right:5px;" dots_color="#000000"][cz_posts layout="cz_grid_c3" hover_vis="cz_grid_1_hide_on_hover" hover_fx="cz_grid_fil" subtitle_css_display="inline-block" id="cz_31430" query="" subtitles="%5B%7B%22t%22%3A%22date%22%2C%22p%22%3A%22On%20%22%2C%22tc%22%3A%223%22%7D%2C%7B%22t%22%3A%22author%22%2C%22p%22%3A%22By%22%7D%5D" posts_per_page="6" si_css=".vc_custom_1511767951255{border-radius: 50px !important;}" subtitle_css_font-size="12px" css=".vc_custom_1511767951247{border-bottom-width: 1px !important;border-left-width: 1px !important;padding-bottom: 10px !important;padding-left: 20px !important;border-left-color: rgba(255,255,255,0.47) !important;border-left-style: solid !important;border-bottom-color: rgba(255,255,255,0.47) !important;border-bottom-style: solid !important;}" overlay_css_background_2="rgba(255,255,255,0.01)" box_css=".vc_custom_1511767951239{background-color: #000000 !important;}" css_color="#ffffff" images_radius="4px" overlay_css_background="rgba(10,0,0,0.8)" overlay_css_gradient_orientation="90deg" sk_img="border-radius:10px;" gap="30px"][/cz_carousel][/vc_column][/vc_row]',
					),
					array(
						'f' => 'service services 3 columns blue flat dark 189_jpg',
						'c' =>'[vc_row full_width="stretch_row" css=".vc_custom_1510344315101{background-color: #4d61ff !important;}"][vc_column][cz_gap height="140px" height_tablet="80px" id="cz_37620"][cz_title id="cz_24150"]<h3><span style="font-size: 42px;">Our <em><span style="font-family: \'Playfair Display\';">Services</span></em></span></h3><p>[/cz_title][cz_gap height="80px" height_tablet="30px" height_mobile="30px" id="cz_89834"][vc_row_inner][vc_column_inner offset="vc_col-lg-4 vc_col-md-6"][cz_title icon_before_type="icon" id="cz_62706" icon="fa fa-wordpress" rotate_before="-45deg" sk_icon_before="font-size:28px;color:#4d61ff;background-color:#ffffff;margin-top:-16px;margin-right:25px;border-radius:50px 50px 0 50px;" sk_icon_before_mobile="font-size:24px;margin-top:10px;margin-bottom:10px;"]</p><h4><span style="line-height: 1; font-size: 24px;">WordPress <em><span style="font-family: \'Playfair Display\';">Installation</span></em></span></h4><p><span style="color: #cfd4ff; line-height: 1;">Installing WordPress and Plugins</span>[/cz_title][cz_gap height_tablet="40px" height_mobile="30px" id="cz_88078"][cz_title icon_before_type="icon" id="cz_33605" icon="fa fa-user-secret" rotate_before="-45deg" sk_overall="margin-bottom:30px;" sk_icon_before="font-size:28px;color:#4d61ff;background-color:#ffffff;margin-top:-16px;margin-right:25px;border-radius:50px 50px 0 50px;" sk_icon_before_mobile="font-size:24px;margin-top:10px;margin-bottom:10px;"]</p><h4><span style="line-height: 1; font-size: 24px;">Security <em><span style="font-family: \'Playfair Display\';">Solutions</span></em></span></h4><p><span style="color: #cfd4ff; line-height: 1;">Increase your server security risk</span>[/cz_title][/vc_column_inner][vc_column_inner offset="vc_col-lg-4 vc_col-md-6"][cz_title icon_before_type="icon" id="cz_39069" icon="fa fa-check" rotate_before="-45deg" sk_icon_before="font-size:28px;color:#4d61ff;background-color:#ffffff;margin-top:-16px;margin-right:25px;border-radius:50px 50px 0 50px;" sk_icon_before_mobile="font-size:24px;margin-top:10px;margin-bottom:10px;"]</p><h4><span style="line-height: 1; font-size: 24px;">Website <em><span style="font-family: \'Playfair Display\';">Optimization</span></em></span></h4><p><span style="color: #cfd4ff; line-height: 1;">Optimizing your site Load Speed</span>[/cz_title][cz_gap height_tablet="40px" height_mobile="30px" id="cz_55856"][cz_title icon_before_type="icon" id="cz_78882" icon="fa fa-code" rotate_before="-45deg" sk_overall="margin-bottom:30px;" sk_icon_before="font-size:28px;color:#4d61ff;background-color:#ffffff;margin-top:-16px;margin-right:25px;border-radius:50px 50px 0 50px;" sk_icon_before_mobile="font-size:24px;margin-top:10px;margin-bottom:10px;"]</p><h4><span style="line-height: 1; font-size: 24px;">Website <em><span style="font-family: \'Playfair Display\';">Development</span></em></span></h4><p><span style="color: #cfd4ff;">Developing website from wireframe</span>[/cz_title][/vc_column_inner][vc_column_inner offset="vc_col-lg-4 vc_col-md-6"][cz_title icon_before_type="icon" id="cz_23886" icon="fa fa-leaf" rotate_before="-45deg" sk_icon_before="font-size:28px;color:#4d61ff;background-color:#ffffff;margin-top:-16px;margin-right:25px;border-radius:50px 50px 0 50px;" sk_icon_before_mobile="font-size:24px;margin-top:10px;margin-bottom:10px;"]</p><h4><span style="line-height: 1; font-size: 24px;">Website <em><span style="font-family: \'Playfair Display\';">Design</span></em></span></h4><p><span style="color: #cfd4ff; line-height: 1;">Photoshop layered web design</span>[/cz_title][cz_gap height_tablet="40px" height_mobile="30px" id="cz_35681"][cz_title icon_before_type="icon" id="cz_58452" icon="fa fa-life-ring" rotate_before="-45deg" sk_icon_before="font-size:28px;color:#4d61ff;background-color:#ffffff;margin-top:-16px;margin-right:25px;border-radius:50px 50px 0 50px;" sk_icon_before_mobile="font-size:24px;margin-top:10px;margin-bottom:10px;"]</p><h4><span style="line-height: 1; font-size: 24px;">Unlimited <em><span style="font-family: \'Playfair Display\';">Support</span></em></span></h4><p><span style="color: #cfd4ff; line-height: 1;">Supporting you with any problems</span>[/cz_title][/vc_column_inner][/vc_row_inner][cz_gap height="140px" height_tablet="80px" id="cz_85987"][/vc_column][/vc_row][cz_google_font font="Playfair Display"]',
					),
					array(
						'f' => 'team member 4 columns experts dark 190_jpg',
						'c' =>'[vc_row][vc_column][cz_gap height="140px" height_tablet="80px" id="cz_51423"][cz_title id="cz_47008"]</p><h3 style="text-align: center;"><span style="font-size: 42px;">Our <em><span style="font-family: \'Playfair Display\';">Expert</span></em> Team</span></h3><p>[/cz_title][cz_title id="cz_97078"]</p><h4 style="text-align: center;"><span style="font-weight: 300; color: #808080;">Meet our professional team meambers</span></h4><p>[/cz_title][cz_gap height="80px" height_tablet="40px" id="cz_19919" height_mobile="40px"][/vc_column][/vc_row][vc_row][vc_column width="1/2" offset="vc_col-lg-3 vc_col-md-3"][cz_team style="cz_team_2" image="'.$imgu.'450x450.jpg" size="300x300" color_mode="cz_social_colored_bg_hover" social_align="tac" fx="cz_social_fx_4" image_img_css_opacity="0.9" image_img_hover_css_opacity="0.3" id="cz_76762" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22%23%22%7D%5D" sk_icons="border-radius:100%;background-color:rgba(255,255,255,0.08);padding:10px 10px 10px 10px;color:#ffffff;" sk_icons_hover="color:#ffffff;" sk_image_con="background-color:transparent;background-image:linear-gradient(0deg,#000000,rgba(77,97,255,0.4));margin-bottom:40px;border-style:solid;border-bottom-width:2px;border-color:#4d61ff;border-radius:20px;" sk_image_img_hover="opacity:0.4;"]</p><h4 style="text-align: center;"><span style="font-size: 24px;"><strong>Jimmy <em><span style="font-family: \'Playfair Display\';">Roland</span></em></strong></span></h4><p style="text-align: center;"><span style="color: #999999; font-size: 15px;">Founder, Developer</span></p><p>[/cz_team][/vc_column][vc_column width="1/2" offset="vc_col-lg-3 vc_col-md-3"][cz_team style="cz_team_2" image="'.$imgu.'450x450.jpg" size="300x300" color_mode="cz_social_colored_bg_hover" social_align="tac" fx="cz_social_fx_4" image_img_css_opacity="0.9" image_img_hover_css_opacity="0.3" id="cz_80870" social="%5B%7B%22icon%22%3A%22fa%20fa-youtube-play%22%2C%22title%22%3A%22Youtube%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22%23%22%7D%5D" sk_icons="border-radius:100%;background-color:rgba(255,255,255,0.08);padding:10px 10px 10px 10px;color:#ffffff;" sk_icons_hover="color:#ffffff;" sk_image_con="background-color:transparent;background-image:linear-gradient(0deg,#0a0202,rgba(77,97,255,0.4));margin-bottom:40px;border-style:solid;border-bottom-width:2px;border-color:#4d61ff;border-radius:20px;" sk_image_img_hover="opacity:0.4;"]</p><h4 style="text-align: center;"><span style="font-size: 24px;"><strong>Nicolas <span style="font-family: \'Playfair Display\';"><i>Xavier</i></span></strong></span></h4><p style="text-align: center;"><span style="color: #999999; font-size: 15px;">Web Developer</span></p><p>[/cz_team][/vc_column][vc_column width="1/2" offset="vc_col-lg-3 vc_col-md-3"][cz_team style="cz_team_2" image="'.$imgu.'450x450.jpg" size="300x300" color_mode="cz_social_colored_bg_hover" social_align="tac" fx="cz_social_fx_4" image_img_css_opacity="0.9" image_img_hover_css_opacity="0.3" id="cz_59593" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22title%22%3A%22Instagram%22%2C%22link%22%3A%22%23%22%7D%5D" sk_icons="border-radius:100%;background-color:rgba(255,255,255,0.08);padding:10px 10px 10px 10px;color:#ffffff;" sk_icons_hover="color:#ffffff;" sk_image_con="background-color:transparent;background-image:linear-gradient(0deg,#000000,rgba(77,97,255,0.4));margin-bottom:40px;border-style:solid;border-bottom-width:2px;border-color:#4d61ff;border-radius:20px;" sk_image_img_hover="opacity:0.4;"]</p><h4 style="text-align: center;"><span style="font-size: 24px;"><strong>Alex <span style="font-family: \'Playfair Display\';"><i>Hernandez</i></span></strong></span></h4><p style="text-align: center;"><span style="color: #999999; font-size: 15px;">Web Designer</span></p><p>[/cz_team][/vc_column][vc_column width="1/2" offset="vc_col-lg-3 vc_col-md-3"][cz_team style="cz_team_2" image="'.$imgu.'450x450.jpg" size="300x300" color_mode="cz_social_colored_bg_hover" social_align="tac" fx="cz_social_fx_4" image_img_css_opacity="0.9" image_img_hover_css_opacity="0.3" id="cz_40840" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22title%22%3A%22Linkedin%22%2C%22link%22%3A%22%23%22%7D%5D" sk_icons="border-radius:100%;background-color:rgba(255,255,255,0.08);padding:10px 10px 10px 10px;color:#ffffff;" sk_icons_hover="color:#ffffff;" sk_image_con="background-color:transparent;background-image:linear-gradient(0deg,#0a0101,rgba(77,97,255,0.4));margin-bottom:40px;border-style:solid;border-bottom-width:2px;border-color:#4d61ff;border-radius:20px;" sk_image_img_hover="opacity:0.4;"]</p><h4 style="text-align: center;"><span style="font-size: 24px;"><strong>Robert <span style="font-family: \'Playfair Display\';"><i>Gary</i></span></strong></span></h4><p style="text-align: center;"><span style="color: #999999; font-size: 15px;">Support Staff</span></p><p>[/cz_team][/vc_column][/vc_row][cz_google_font font="Playfair Display"]',
					),
					array(
						'f' => 'carousel testimonial quote slider full wide dark 191_jpg',
						'c' =>'[vc_row][vc_column width="1/6"][/vc_column][vc_column width="2/3"][cz_gap height="120px" id="cz_37719"][cz_carousel slidestoshow="1" slidestoshow_tablet="1" overflow_visible="true" infinite="true" centermode="true" id="cz_94700" sk_prev_icon="background-color:#ffffff;border-radius:100%;margin-left:15px;margin-right:15px;font-size:12px;color:#212121;" sk_next_icon="background-color:#ffffff;border-radius:100%;margin-left:15px;margin-right:15px;font-size:12px;color:#212121;" sk_slides="opacity:0.2;" sk_center="opacity:1;box-shadow:1px 10px 32px rgba(77,97,255,0.2) ;"][cz_testimonials style="6" id="cz_58169" avatar="'.$imgu.'80x80.jpg" sk_content="background-color:#ffffff;border-radius:20px;" sk_name="color:#4d61ff;" sk_subname="color:#0a0a0a;"]<p style="text-align: center;"><span style="color: #000000;">Proin eget tortor risus. Donec rutrum congue leo eget malesuada. Praesent sapien massa, convallis a pellentesque nec, egestas non nisi. Proin eget tortor risus. Proin eget tortor risus. Nulla lorem porttitor accumsan tincidunt.</span></p>[/cz_testimonials][cz_testimonials name="Miss. Greener" subname="Artist" style="6" id="cz_76363" avatar="'.$imgu.'80x80.jpg" sk_content="background-color:#ffffff;border-radius:20px;" sk_name="color:#4d61ff;" sk_subname="color:#0a0a0a;"]<p style="text-align: center;"><span style="color: #000000;">Proin eget tortor risus. Donec rutrum congue leo eget malesuada. Praesent sapien massa, convallis a pellentesque nec, egestas non nisi. Proin eget tortor risus. Proin eget tortor risus. Nulla porttitor accumsan tincidunt.</span></p>[/cz_testimonials][cz_testimonials subname="Student" style="6" id="cz_55957" avatar="'.$imgu.'80x80.jpg" sk_content="background-color:#ffffff;border-radius:20px;" sk_name="color:#4d61ff;"]<p style="text-align: center;"><span style="color: #333333;">Sed porttitor lectus nibh. Vestibulum ac diam sit amet quam vehicula elementum sed sit amet dui. Nulla porttitor accumsan tincidunt. Sed porttitor lectus nibh. Sed porttitor lectus nibh. Sed porttitor lectus nibh. Vestibulum ac diam sit amet quam vehicula elementum sed sit amet dui.</span></p>[/cz_testimonials][/cz_carousel][/vc_column][vc_column width="1/6"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'misc 2columns app parallax mobile 192_jpg',
						'c' =>'[vc_row css=".vc_custom_1516451263843{border-bottom-width: 2px !important;border-bottom-color: #c9c9c9 !important;border-bottom-style: solid !important;}"][vc_column offset="vc_col-lg-6"][cz_title shape="rhombus_radius cz_title_shape_outline" id="cz_13262" sk_shape="color:rgba(255,229,101,0.4);width:60px;height:60px;top:-20px;left:-20px;" sk_overall="margin-bottom:50px;" sk_shape_mobile="left:-10px;"]</p><div style="line-height: 2;"><em><span style="color: #808080; font-size: 18px; font-weight: 300;">INFORMATION</span></em></div><h3><span style="font-size: 38px;">What is <span style="font-weight: 300;">Xtra Application</span> ?</span></h3><p>[/cz_title][vc_column_text]<span style="font-size: 18px;">Track recent charges and payments with a timeline of your activity. Check your spending power to find out if your charges will be approved, so you can make purchases with confidence. Before you arrive, check in from the train, plane, or road. As you depart, leave your key and hit the road.</span>[/vc_column_text][vc_row_inner][vc_column_inner width="1/2"][cz_counter number="89" after="Top Reviews" id="cz_66431" sk_num="font-size:90px;font-weight:100;" sk_ba="font-weight:300;font-size:24px;color:#9e9e9e;" sk_after="font-weight:300;font-size:24px;color:#9e9e9e;"][/vc_column_inner][vc_column_inner width="1/2"][cz_counter number="57" after="User Ratings" duration="3" delay="1" id="cz_78695" sk_num="font-size:90px;font-weight:100;" sk_ba="font-weight:300;font-size:24px;color:#9e9e9e;" sk_after="font-weight:300;font-size:24px;color:#9e9e9e;" sk_overall_mobile="margin-bottom:70px;"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column offset="vc_col-lg-6"][cz_image css_position="relative;display: table;margin:0 auto" parallax="5" parallax_h="true" image="http://xtratheme.com/app/wp-content/uploads/sites/8/2018/01/mob4-1.png" id="cz_88052"][/vc_column][/vc_row][vc_row][vc_column offset="vc_col-lg-6"][cz_image css_position="relative;display: table;margin:0 auto" parallax="-5" parallax_h="true" image="http://xtratheme.com/app/wp-content/uploads/sites/8/2018/01/mob41-1.png" id="cz_97174" sk_css="margin-left:-10px;"][/vc_column][vc_column offset="vc_col-lg-6"][cz_gap height="80px" id="cz_56188"][cz_title shape="rhombus_radius cz_title_shape_outline" smart_fs="true" tablet_shape_font-size="2em" mobile_shape_font-size="2em" id="cz_86825" sk_shape="color:rgba(255,229,101,0.4);width:60px;height:60px;top:-20px;left:-20px;" sk_overall="margin-bottom:50px;" sk_shape_mobile="left:-10px;"]</p><div style="line-height: 2;"><em><span style="color: #808080; font-size: 18px; font-weight: 300;">REASONS</span></em></div><h3><span style="font-size: 38px;">Why choose <span style="font-weight: 300;">Xtra App</span> ?</span></h3><p>[/cz_title][vc_column_text]<span style="font-size: 18px;">Before you arrive, check in from the train, plane, or road. As you depart, leave your key and hit the road. Track recent charges and payments with a timeline of your activity. Check your spending power to find out if your charges will be approved, so you can make purchases.</span>[/vc_column_text][vc_row_inner][vc_column_inner width="1/2"][cz_stylish_list items="%5B%7B%22title%22%3A%22Easy%20to%20Use%22%2C%22icon%22%3A%22fa%20fa-check%22%7D%2C%7B%22title%22%3A%22Mobile%20Check-In%22%2C%22icon%22%3A%22fa%20fa-check%22%7D%2C%7B%22title%22%3A%22Account%20Activity%22%2C%22icon%22%3A%22fa%20fa-check%22%7D%5D" id="cz_23735" sk_lists="font-size:18px;font-weight:700;" sk_icons="border-radius:50px;background-color:#ffe565;color:#232323;"][/vc_column_inner][vc_column_inner width="1/2"][cz_stylish_list items="%5B%7B%22title%22%3A%22Fast%20Connection%22%2C%22icon%22%3A%22fa%20fa-check%22%7D%2C%7B%22title%22%3A%22Great%20Security%22%2C%22icon%22%3A%22fa%20fa-check%22%7D%2C%7B%22title%22%3A%22Friendly%20Support%22%2C%22icon%22%3A%22fa%20fa-check%22%7D%5D" id="cz_37346" sk_lists="font-size:18px;font-weight:700;" sk_icons="border-radius:50px;background-color:#ffe565;color:#232323;"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',
					),
					array(
						'f' => 'cta button app download android apple 193_jpg',
						'c' =>'[vc_row][vc_column offset="vc_col-lg-6"][cz_title shape="rhombus_radius cz_title_shape_outline" smart_fs="true" tablet_shape_font-size="2em" mobile_shape_font-size="2em" id="cz_17724" sk_shape="color:rgba(255,229,101,0.4);width:60px;height:60px;top:-20px;left:-20px;" sk_overall="margin-bottom:50px;" sk_shape_mobile="left:-10px;"]</p><div style="line-height: 2;"><em><span style="color: #808080; font-size: 18px; font-weight: 300;">Downloading</span></em></div><h3><span style="font-size: 38px;">Download <span style="font-weight: 300;">Trial Version</span></span></h3><p>[/cz_title][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_button title="Google Play" btn_position="cz_btn_center" effect="cz_btn_fx_1" subtitle="Download" icon="fa fa-android" link="url:%23|||" id="cz_13952" sk_button="color:#0a0a0a;font-weight:900;line-height:20px;background-color:#ffe565;padding:24px 40px;margin-top:10px;border-radius:100px;" sk_hover="background-color:#110606;color:#ffe565;" sk_icon="font-size:50px;margin-right:20px;"][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][cz_button title="App Store" btn_position="cz_btn_center" effect="cz_btn_fx_1" subtitle="Download" icon="fa fa-apple" link="url:%23|||" id="cz_74367" sk_button="color:#ffffff;font-weight:900;line-height:20px;background-color:#000000;padding:24px 40px;margin-top:10px;border-radius:100px;" sk_hover="background-color:#ffe565;color:#161616;" sk_icon="margin-right:20px;font-size:50px;" sk_button_mobile="margin-top:30px;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'service services box 2 columns half image 194_jpg',
						'c' =>'[vc_row][vc_column offset="vc_col-lg-6"][cz_gap height="40px" height_mobile="20px" height_tablet="30px" id="cz_72882"][cz_title bline="cz_line_left_side" shape="text" smart_fs="true" shape_text="CONSTRUCTION" mobile_shape_font-size="2.2em" id="cz_19315" tablet_shape_font-size="3em" sk_shape="font-size:4em;color:rgba(239,174,22,0.1);top:-40px;" sk_lines="background-color:#efae16;width:100px;top:-5px;" sk_overall="margin-left:-90px;" sk_overall_mobile="margin-left:0px;" sk_shape_mobile="font-size:2em;"]<h3><span style="font-size: 40px;">Welcome to <span style="color: #efae16;">Construction</span></span></h3><span style="color: #808080;">The Department of Buildings promotes the safety build</span>[/cz_title][cz_gap height="112px" height_tablet="80px" id="cz_33800"][vc_row_inner][vc_column_inner width="1/2"][cz_title icon_before_type="icon" shape="text" icon="fa fa-location-arrow" shape_text="01" id="cz_21155" mobile_shape_font-size="5em" sk_shape="font-size:6em;color:rgba(239,174,22,0.2);top:-50px;" sk_icon_before="margin-left:-10px;color:#efae16;font-size:24px;"]<h4>Design &amp; Building</h4>[/cz_title][vc_column_text]<span style="color: #999999;">Services currently available at the Department’s Development HUB have been enhanced.</span>[/vc_column_text][cz_gap height="30px" id="cz_36292"][cz_title icon_before_type="icon" shape="text" icon="fa fa-location-arrow" shape_text="03" id="cz_35578" sk_shape="font-size:6em;color:rgba(239,174,22,0.2);top:-50px;" sk_icon_before="margin-left:-10px;color:#efae16;font-size:24px;"]<h4>Remodeling</h4>[/cz_title][vc_column_text]<span style="color: #808080;">The virtual review software eliminates the need for developers to visit a borough office.</span>[/vc_column_text][cz_gap height="30px" id="cz_36075"][/vc_column_inner][vc_column_inner width="1/2"][cz_title icon_before_type="icon" shape="text" icon="fa fa-location-arrow" shape_text="02" id="cz_19728" sk_shape="font-size:6em;color:rgba(239,174,22,0.2);top:-50px;" sk_icon_before="margin-left:-10px;color:#efae16;font-size:24px;"]<h4>Safe Construction</h4>[/cz_title][vc_column_text]<span style="color: #999999;">Applicants and Owners can review plans and objections alongside their plan examiner virtually.</span>[/vc_column_text][cz_gap height="30px" id="cz_87768"][cz_title icon_before_type="icon" shape="text" icon="fa fa-location-arrow" shape_text="04" id="cz_72691" sk_shape="font-size:6em;color:rgba(239,174,22,0.2);top:-50px;" sk_icon_before="margin-left:-10px;color:#efae16;font-size:24px;"]<h4>Tiling Painting</h4>[/cz_title][vc_column_text]<span style="color: #808080;">Will allow the applicant to access reviewer comments and objections online.</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column offset="vc_col-lg-6"][cz_image css_position="relative;float:right" image="http://xtratheme.com/building/wp-content/uploads/sites/9/2018/02/model2.jpg" id="cz_16272"][/vc_column][/vc_row]',
					),
					array(
						'f' => '2 columns half image service about video 195_jpg',
						'c' =>'[vc_row][vc_column offset="vc_col-lg-6"][cz_video_popup video="https://www.youtube.com/watch?v=m5MdL6_eJg8" ripple="true" image="http://xtratheme.com/building/wp-content/uploads/sites/9/2017/06/w1-1.jpg" title="Watch Video" id="cz_11226" sk_title="color:#efae16;" sk_icon="color:#0f0000;background-color:#efae16;" sk_overall="margin-bottom:40px;"][cz_gap height="1px" height_tablet="30px" id="cz_35991"][/vc_column][vc_column offset="vc_col-lg-6"][cz_title bline="cz_line_left_side" shape="text" smart_fs="true" shape_text="WHY US ?" mobile_shape_font-size="3em" id="cz_37381" sk_overall="margin-bottom:40px;margin-left:-90px;" sk_shape="font-size:4em;color:rgba(239,174,22,0.1);top:-36px;" sk_lines="background-color:#efae16;width:100px;top:-5px;" sk_overall_mobile="margin-left:0px;" sk_shape_mobile="font-size:3em;"]
	<h3><span style="font-size: 40px;">Why <span style="color: #efae16;">Choose Us </span>?</span></h3>
	<span style="color: #808080;">The Department of Buildings promotes the safety build</span>[/cz_title][vc_column_text]From the High-Risk Construction Oversight Study (HRCO), 41 recommendations were developed to strengthen the safety and oversight of these activities recommendations.[/vc_column_text][vc_row_inner][vc_column_inner width="1/2"][cz_stylish_list items="%5B%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22We%20Are%20Creative%20Team%22%7D%2C%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22Honest%20and%20Dependable%22%7D%5D" id="cz_87345" sk_lists="margin-bottom:0px;font-weight:500;font-size:18px;" sk_icons="color:#efae16;font-size:26px;"][/vc_column_inner][vc_column_inner width="1/2"][cz_stylish_list items="%5B%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22Quality%20Commitment%22%7D%2C%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22We%20Are%20Always%20Improving%22%7D%5D" id="cz_55866" sk_lists="margin-bottom:0px;font-weight:500;font-size:18px;" sk_icons="color:#efae16;font-size:26px;"][/vc_column_inner][/vc_row_inner][cz_gap height="30px" id="cz_74933"][cz_button title="Read more details" text_effect="cz_btn_txt_move_up" effect="cz_btn_fx_3" icon="fa fa-angle-right" link="url:http%3A%2F%2Fxtratheme.com%2Fbuilding%2Fthe-company%2F|||" id="cz_98163" sk_button="border-radius:50px;background-color:#efae16;padding-left:28px;padding-right:28px;font-weight:500;color:#232323;" sk_hover="background-color:#212121;color:#efae16;"][cz_gap height="80px" height_tablet="40px" height_mobile="30px" id="cz_76872"][/vc_column][/vc_row][vc_row][vc_column offset="vc_col-lg-6"][cz_gap height="40px" id="cz_61781"][cz_title bline="cz_line_left_side" shape="text" smart_fs="true" shape_text="WHY US ?" mobile_shape_font-size="3em" id="cz_13256" sk_overall="margin-bottom:40px;margin-left:-90px;" sk_shape="font-size:4em;color:rgba(239,174,22,0.1);top:-36px;" sk_lines="background-color:#efae16;width:100px;top:-5px;" sk_overall_mobile="margin-left:0px;" sk_shape_mobile="font-size:3em;"]
	<h3><span style="font-size: 40px;">Who <span style="color: #efae16;">We Are </span>?</span></h3>
	<span style="color: #808080;">Meet our team members and our work places</span>[/cz_title][vc_column_text]From the High-Risk Construction Oversight Study (HRCO), 41 recommendations were developed to strengthen the safety and oversight of these activities recommendations.
	Construction is a dangerous business and workers must take every precaution to protect themselves from the risks of the job. Employers are required by law to provide construction workers with safety harnesses.[/vc_column_text][cz_button title="Read more details" text_effect="cz_btn_txt_move_up" effect="cz_btn_fx_3" icon="fa fa-angle-right" link="url:http%3A%2F%2Fxtratheme.com%2Fbuilding%2Fthe-company%2F|||" id="cz_93511" sk_button="color:#232323;font-weight:500;background-color:#efae16;padding-right:28px;padding-left:28px;margin-bottom:50px;border-radius:50px;" sk_hover="background-color:#212121;color:#efae16;"][cz_gap height="1px" height_tablet="20px" height_mobile="20px" id="cz_82485"][/vc_column][vc_column offset="vc_col-lg-6"][cz_video_popup video="https://www.youtube.com/watch?v=m5MdL6_eJg8" ripple="true" image="http://xtratheme.com/building/wp-content/uploads/sites/9/2017/06/w2-1.jpg" title="Team Video" id="cz_25601" subtitle="Our Company" sk_title="color:#efae16;" sk_icon="color:#160000;background-color:#efae16;"][cz_gap height="140px" height_tablet="80px" id="cz_51024"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'testimonials carousel 2 columns quote clients 196_jpg',
						'c' =>'[vc_row full_width="stretch_row" css=".vc_custom_1498841417972{background-color: #f5f5f5 !important;}"][vc_column][cz_gap height="80px" id="cz_73258"][cz_title bline="cz_line_left_side" shape="text" smart_fs="true" shape_text="CLIENTS" mobile_shape_font-size="3em" id="cz_21204" sk_overall="margin-bottom:40px;margin-left:-90px;" sk_shape="font-size:4em;color:rgba(239,174,22,0.16);top:-36px;" sk_lines="background-color:#efae16;width:100px;top:-5px;" sk_overall_mobile="margin-bottom:50px;margin-left:0px;" sk_shape_mobile="font-size:3em;"]<h3><span style="font-size: 40px;">Testimonials</span></h3>Check out why our customers loves us in each projects[/cz_title][cz_carousel slidestoshow="2" arrows_position="arrows_tr" dots_style="dots_circle" slidestoshow_tablet="1" infinite="true" gap="20px" dots_color="#efae16" id="cz_88784" sk_prev_icon="font-size:18px;color:#efae16;background-color:rgba(255,255,255,0.18);border-radius:50px;top: -24px;right: 14px;" sk_next_icon="font-size:18px;color:#efae16;background-color:rgba(255,255,255,0.18);border-radius:50px;top: -24px;right: 14px;" sk_prev_icon_mobile="margin-top:30px;margin-right:-40px;" sk_next_icon_mobile="margin-top:30px;margin-right:-20px;"][cz_quote style="cz_quote_arrow" quote_position="absolute;bottom: 10%;right: 10%" name="John Carter" rating="" image="'.$imgu.'80x80.jpg" id="cz_20718" quote_color="#efae16" sk_overall="background-color:#ffffff;border-style:solid;border-width:1px;border-color:#ffffff;border-radius:10px;" sk_name="font-weight:900;font-size:20px;"]Praesent sapien massa, convallis a pellentesque nec, egestas non nisi. Proin eget tortor risus. Vivamus magna justo, lacinia eget consectetur sed, convallis at tellus. Curabitur arcu erat, accumsan id imperdiet et, porttitor at sem.[/cz_quote][cz_quote style="cz_quote_arrow" quote_position="absolute;bottom: 10%;right: 10%" name="Jessica Rosseta" subname="Doctor" rating="" image="'.$imgu.'80x80.jpg" id="cz_40093" quote_color="#efae16" sk_overall="background-color:#ffffff;border-style:solid;border-width:1px;border-color:#ffffff;border-radius:10px;" sk_name="font-weight:900;font-size:20px;"]Vestibulum ac diam sit amet quam vehicula elementum sed sit amet dui. Curabitur arcu erat, accumsan id imperdiet et, porttitor at sem. Nulla quis lorem ut libero malesuada feugiat. Vivamus magna justo, lacinia eget consectetur sed lorem ipsum.[/cz_quote][cz_quote style="cz_quote_arrow" quote_position="absolute;bottom: 10%;right: 10%" name="Nicolas Anelka" subname="Gentelman" rating="" image="'.$imgu.'80x80.jpg" id="cz_11679" quote_color="#efae16" sk_overall="background-color:#ffffff;border-style:solid;border-width:1px;border-color:#ffffff;border-radius:10px;" sk_name="font-weight:900;font-size:20px;"]Vivamus magna justo, lacinia eget consectetur sed, convallis at tellus. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Donec velit neque, auctor sit amet aliquam vel, ullamcorper sit amet ligula.[/cz_quote][/cz_carousel][cz_gap height="40px" id="cz_55141"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'clients logo 6 columns sponsors partners 197_jpg',
						'c' =>'[vc_row][vc_column][cz_title bline="cz_line_left_side" shape="text" smart_fs="true" shape_text="CERTIFICATES" mobile_shape_font-size="2em" tablet_shape_font-size="3em" id="cz_60893" sk_overall="margin-bottom:40px;margin-left:-90px;" sk_shape="font-size:4em;color:rgba(239,174,22,0.1);" sk_lines="background-color:#efae16;width:100px;top:-5px;" sk_overall_mobile="margin-left:0px;" sk_shape_mobile="font-size:2em;top:-20px;" sk_overall_tablet="margin-bottom:20px;"]<h3><span style="font-size: 40px;">Clients &amp; <span style="color: #efae16;">Partners</span></span></h3><span style="color: #808080;">Lorem ipsum dolor sit amet, consectetur adipiscing elit</span>[/cz_title][vc_row_inner][vc_column_inner width="1/3" offset="vc_col-lg-2"][cz_image css_position="relative;display: table;margin:0 auto" link_type="custom" image="'.$imgu.'client.png" link="url:http%3A%2F%2Fcodevz.com%2F|||" id="cz_81396" tooltip="Precision" sk_css="padding:14px 34px;margin:0 auto;border-style:solid;border-width:1px;border-color:#e5e5e5;border-radius:10px;" sk_css_tablet="margin-bottom:20px;"][/vc_column_inner][vc_column_inner width="1/3" offset="vc_col-lg-2"][cz_image css_position="relative;display: table;margin:0 auto" link_type="custom" image="'.$imgu.'client.png" link="url:http%3A%2F%2Fcodevz.com%2F|||" id="cz_20943" tooltip="RtAlkin" sk_css="padding:14px 34px;margin:0 auto;border-style:solid;border-width:1px;border-color:#e5e5e5;border-radius:10px;" sk_css_tablet="margin-bottom:20px;"][/vc_column_inner][vc_column_inner width="1/3" offset="vc_col-lg-2"][cz_image css_position="relative;display: table;margin:0 auto" link_type="custom" image="'.$imgu.'client.png" link="url:http%3A%2F%2Fcodevz.com%2F|||" id="cz_51423" tooltip="BayView" sk_css="padding:14px 34px;margin:0 auto;border-style:solid;border-width:1px;border-color:#e5e5e5;border-radius:10px;" sk_css_tablet="margin-bottom:20px;"][/vc_column_inner][vc_column_inner width="1/3" offset="vc_col-lg-2"][cz_image css_position="relative;display: table;margin:0 auto" link_type="custom" image="'.$imgu.'client.png" link="url:http%3A%2F%2Fcodevz.com%2F|||" id="cz_80220" tooltip="Logo Tooltip" sk_css="padding:14px 34px;margin:0 auto;border-style:solid;border-width:1px;border-color:#e5e5e5;border-radius:10px;" sk_css_mobile="margin-bottom:20px;"][/vc_column_inner][vc_column_inner width="1/3" offset="vc_col-lg-2"][cz_image css_position="relative;display: table;margin:0 auto" link_type="custom" image="'.$imgu.'client.png" link="url:http%3A%2F%2Fcodevz.com%2F|||" id="cz_35638" tooltip="House Rental" sk_css="padding:14px 34px;margin:0 auto;border-style:solid;border-width:1px;border-color:#e5e5e5;border-radius:10px;" sk_css_mobile="margin-bottom:20px;"][/vc_column_inner][vc_column_inner width="1/3" offset="vc_col-lg-2"][cz_image css_position="relative;display: table;margin:0 auto" link_type="custom" image="'.$imgu.'client.png" link="url:http%3A%2F%2Fcodevz.com%2F|||" id="cz_24858" tooltip="Complete" sk_css="padding:14px 34px;margin:0 auto;border-style:solid;border-width:1px;border-color:#e5e5e5;border-radius:10px;"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',
					),
					array(
						'f' => 'cta button full width row call action 198_jpg',
						'c' =>'[vc_row full_width="stretch_row" css=".vc_custom_1509889937886{padding-top: 60px !important;padding-bottom: 60px !important;background-color: #efae16 !important;}"][vc_column offset="vc_col-lg-8"][cz_title icon_before_type="icon" smart_fs="true" text_center="true" icon="fa fa-building-o" id="cz_66107" sk_icon_before="font-size:50px;color:#efae16;background-color:#191919;margin-right:30px;border-radius:50px;" sk_icon_before_tablet="font-size:40px;margin-right:0px;margin-bottom:20px;" sk_overall_tablet="text-align:center;"]<h3 style="line-height: 1.4;"><span style="font-size: 34px;">Start New Project Today ...</span></h3>Proin eget tortor risus nulla porttitor accumsan tincidunt donec rutrum leo[/cz_title][/vc_column][vc_column offset="vc_col-lg-4"][cz_gap height="25px" id="cz_94658"][cz_button title="Start Today" btn_position="cz_btn_right" icon_position="after" effect="cz_btn_fx_3" icon="fa fa-angle-double-right" link="url:http%3A%2F%2Fxtratheme.com%2Fbuilding%2Fthe-company%2F|||" id="cz_17100" sk_button="color:#efae16;font-weight:500;background-color:#212121;padding-right:30px;padding-left:30px;margin-top:20px;border-radius:50px;" sk_hover="background-color:#efae16;color:#161616;box-shadow:1px 5px 17px rgba(0,0,0,0.13) ;" class="cz_mobile_btn_center"][/vc_column][/vc_row]',
					),
					array(
						'f' => '3 columns image zoom parallax  199_jpg',
						'c' =>'[vc_row full_width="stretch_row" css=".vc_custom_1497437106728{background-color: #fbfbfb !important;}"][vc_column offset="vc_col-lg-4 vc_col-md-12"][cz_title css_animation="bottom-to-top" smart_fs="true" text_center="true" id="cz_96257" sk_overall="margin-bottom:40px;" sk_lines="width:30px;"]<h3><span style="font-size: 36px;"><strong>Helping you to <span class="cz_underline cz_underline_solid" style="color: #e32f56; margin: 0px 2px; padding: 1px 0px 2px; border-bottom: 1px solid;">Increase</span> your website traffic</strong></span></h3>[/cz_title][cz_title text_center="true" id="cz_87346" sk_overall="margin-bottom:30px;"]<span style="color: #808080; font-size: 20px;">Our service encompasses consultation, keyword research, copywriting, creating incoming links, submitting to search engines and finally, reporting on optimization results.</span>[/cz_title][cz_button title="Get More Visitors" btn_position="cz_btn_left cz_mobile_btn_center" css_animation="bottom-to-top" effect="cz_btn_fx_3" icon="fa fa-bolt" link="url:http%3A%2F%2Fxtratheme.com%2Fseo%2Fcontact%2F|||" id="cz_26839" sk_button="color:#ffffff;background-color:#e32f56;border-radius:4px;" sk_hover="color:#e32f56;background-color:rgba(227,47,86,0.1);box-shadow:1px 10px 32px rgba(227,47,86,0.15);" sk_button_mobile="margin-bottom:40px;"][/vc_column][vc_column width="1/2" offset="vc_col-lg-4 vc_col-md-6 vc_col-xs-12" css=".vc_custom_1514274414648{margin-right: 10px !important;}"][cz_image_hover_zoom size="370x500" parallax="8" css_animation="bottom-to-top" image="'.$img.'" id="cz_88897" sk_css="border-radius:4px;" sk_css_tablet="margin-top:30px;margin-bottom:30px;"][/vc_column][vc_column width="1/2" offset="vc_col-lg-4 vc_col-md-6 vc_col-xs-12"][cz_image_hover_zoom size="370x450" parallax="-8" css_animation="bottom-to-top" image="'.$img.'" id="cz_66930" sk_css="border-radius:4px;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'cta action button link box dark purple 200_jpg',
						'c' =>'[vc_row full_width="stretch_row"][vc_column][cz_gap height="140px" height_tablet="80px" id="cz_65416"][cz_content_box type="1" fx="fx_bob" css_animation="bottom-to-top" id="cz_47952" sk_overall="color:#ffffff;background-color:#4829a0;padding-right:50px;padding-left:50px;border-radius:4px;box-shadow:1px 10px 32px rgba(72,41,160,0.15);" sk_overall_mobile="padding:30px 20px 40px;"][vc_row_inner][vc_column_inner offset="vc_col-lg-9 vc_col-md-12 vc_col-xs-12"][cz_title icon_before_type="icon" smart_fs="true" icon="fa fa-check" id="cz_62005" sk_icon_before="font-size:38px;color:#e32f56;background-color:rgba(255,255,255,0.05);margin-right:20px;border-radius:4px;" sk_overall_tablet="text-align:center;" sk_icon_before_tablet="margin-right:0px;margin-bottom:25px;"]<h3><span style="font-size: 32px;">Better SEO will make More Visitors</span></h3><span style="color: #d4d4d4;">Submit your website to hundreds of search engines, directories and links pages.</span>[/cz_title][/vc_column_inner][vc_column_inner offset="vc_col-lg-3 vc_col-md-12 vc_col-xs-12"][cz_button title="Choose SEO Packages" btn_position="cz_btn_center" effect="cz_btn_fx_3" link="url:http%3A%2F%2Fxtratheme.com%2Fseo%2Fcontact%2F|||" id="cz_18189" sk_button="color:#ffffff;background-color:#e32f56;margin:26px auto 0px;border-radius:4px;" sk_hover="color:#e32f56;background-color:#ffffff;box-shadow:1px 10px 32px rgba(227,47,86,0.16);" icon="fa fa-angle-right" sk_button_mobile="font-size:14px;"][/vc_column_inner][/vc_row_inner][/cz_content_box][cz_gap height="110px" height_tablet="40px" height_mobile="20px" id="cz_34424"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'testimonials carousel 3 columns quote clients stars 201_jpg',
						'c' =>'[vc_row full_width="stretch_row" css=".vc_custom_1497442185297{background-color: #4829a0 !important;}"][vc_column][cz_gap height="200px" height_tablet="140px" height_mobile="140px" id="cz_59470"][cz_title css_animation="fadeIn" smart_fs="true" id="cz_87437" sk_overall="margin-bottom:40px;"]<h3 style="text-align: center;"><span style="font-size: 38px;"><strong><span style="color: #ffffff;">Our Customers </span> <span style="color: #e32f56;">Love Us</span> <span style="color: #ffffff;">, Find Out Why</span></strong></span></h3><p style="text-align: center;"><span style="color: #dedede; font-size: 20px;">Over 22000 happy customers over past two years</span></p>[/cz_title][cz_carousel arrows_position="no_arrows" dots_position="dots_bc" dots_style="dots_circle_outline" slidestoshow_tablet="1" css_animation="bottom-to-top" infinite="true" centermode="true" dots_inner="true" dots_color="#ffffff" id="cz_78115"][cz_quote style="cz_quote_center" quote_position="absolute;bottom: 10%;right: 10%" name="Alexander Doe" subname="" rating="4.5" image="'.$imgu.'80x80.jpg" id="cz_43889" sk_overall="border-radius:4px;border-bottom-style:solid;border-color:rgba(255,255,255,0.02);border-top-style:solid;border-right-style:solid;border-left-style:solid;background-color:#4829a0;border-width:0px 0px 0px 0px;color:#ffffff;"]Great things in business are never done by one person. They are done by a team of people.[/cz_quote][cz_quote style="cz_quote_center" quote_position="absolute;bottom: 10%;right: 10%" name="Angela Doe" subname="" rating="4.5" image="'.$imgu.'80x80.jpg" id="cz_68804" sk_overall="border-radius:4px;border-bottom-style:solid;border-color:rgba(255,255,255,0.02);border-top-style:solid;border-right-style:solid;border-left-style:solid;background-color:#4829a0;border-width:0px 0px 0px 0px;color:#ffffff;"]Vivamus magna justo, lacinia eget consectetur sed, convallis at tellus.[/cz_quote][cz_quote style="cz_quote_center" quote_position="absolute;bottom: 10%;right: 10%" name="Martin Macmaneman" subname="" rating="5" image="'.$imgu.'80x80.jpg" id="cz_85948" sk_overall="border-radius:4px;border-bottom-style:solid;border-color:rgba(255,255,255,0.02);border-top-style:solid;border-right-style:solid;border-left-style:solid;background-color:#4829a0;border-width:0px 0px 0px 0px;color:#ffffff;"]Great things in business are never done by one person. They are done by a team of people.[/cz_quote][cz_quote style="cz_quote_center" quote_position="absolute;bottom: 10%;right: 10%" name="Alexis Jordan" subname="" rating="5" image="'.$imgu.'80x80.jpg" id="cz_66368" sk_overall="border-radius:4px;border-bottom-style:solid;border-color:rgba(255,255,255,0.02);border-top-style:solid;border-right-style:solid;border-left-style:solid;background-color:#4829a0;border-width:0px 0px 0px 0px;color:#ffffff;"]Vivamus magna justo, lacinia eget consectetur sed, convallis at tellus.[/cz_quote][/cz_carousel][cz_gap height="40px" height_tablet="20px" height_mobile="20px" id="cz_72742"][/vc_column][/vc_row]',
					),
					array(
						'f' => ' 202_jpg',
						'c' =>'[vc_row][vc_column css=".vc_custom_1515504487225{padding-top: 50px !important;}"][cz_carousel slidestoshow="6" arrows_position="no_arrows" dots_position="dots_bc" dots_style="dots_circle_outline" css_animation="bottom-to-top" overflow_visible="true" infinite="true" autoplay="true" id="cz_43507" sk_prev_icon="font-size:16px;color:#e32f56;background-color:#f7f7f7;border-radius:4px;" sk_next_icon="border-radius:4px;color:#e32f56;background-color:#f9f9f9;font-size:16px;" dots_color="#e32f56"][cz_image image="'.$imgu.'client.png" id="cz_75740" tooltip="Spotify" sk_css="padding-right:15px;padding-left:15px;"][cz_image image="'.$imgu.'client.png" id="cz_54070" tooltip="Envato Market" sk_css="padding-right:15px;padding-left:15px;"][cz_image image="'.$imgu.'client.png" id="cz_28981" tooltip="jQuery" sk_css="padding-right:15px;padding-left:15px;"][cz_image image="'.$imgu.'client.png" id="cz_66302" tooltip="Github" sk_css="padding-right:15px;padding-left:15px;"][cz_image image="'.$imgu.'client.png" id="cz_50898" tooltip="Google" sk_css="padding-right:15px;padding-left:15px;"][cz_image image="'.$imgu.'client.png" id="cz_49326" tooltip="WordPress" sk_css="padding-right:15px;padding-left:15px;"][cz_image image="'.$imgu.'client.png" id="cz_30529" tooltip="XTRA Theme" sk_css="padding-right:15px;padding-left:15px;"][/cz_carousel][/vc_column][/vc_row]',
					),
					array(
						'f' => 'services 4 columns icon stylish list 203_jpg',
						'c' =>'[vc_row css=".vc_custom_1500473744762{padding-top: 70px !important;padding-bottom: 70px !important;}"][vc_column offset="vc_col-lg-4"][cz_gap height="10px" height_tablet="20px" height_mobile="1px" id="cz_73202"][cz_title icon_before_type="image" shape="circle cz_title_shape_outline" image_as_icon="http://xtratheme.com/dentist/wp-content/uploads/sites/11/2017/06/title_icon-1.png" mobile_shape_font-size="3em" tablet_shape_font-size="4em" id="cz_35934" sk_shape="font-size:10em;color:rgba(54,95,243,0.06);width:80px;height:80px;top:-5px;left:-20px;" sk_icon_before="background-color:#365ff3;padding:14px;margin:-6px 20px -10px -10px;border-radius:50px;"]<span style="color: #808080;">Know Before You Go</span><h3>Our <span style="color: #365ff3;">Services</span></h3>[/cz_title][cz_gap height="1px" height_tablet="1px" height_mobile="20px" id="cz_31716"][/vc_column][vc_column offset="vc_col-lg-8"][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][cz_stylish_list items="%5B%7B%22icon%22%3A%22fa%20fa-envira%22%2C%22title%22%3A%22Tooth%20Filling%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envira%22%2C%22title%22%3A%22Root%20Canals%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envira%22%2C%22title%22%3A%22Extractions%22%7D%5D" id="cz_71938" sk_lists="padding-bottom:0px;margin-bottom:0px;font-weight:500;" sk_icons="color:#365ff3;font-size:20px;"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][cz_stylish_list items="%5B%7B%22icon%22%3A%22fa%20fa-envira%22%2C%22title%22%3A%22Full%20Exams%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envira%22%2C%22title%22%3A%22X-Rays%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envira%22%2C%22title%22%3A%22Cleaning%22%7D%5D" id="cz_70891" sk_lists="padding-bottom:0px;margin-bottom:0px;font-weight:500;" sk_icons="color:#365ff3;font-size:20px;"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][cz_stylish_list items="%5B%7B%22icon%22%3A%22fa%20fa-envira%22%2C%22title%22%3A%22Whitening%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envira%22%2C%22title%22%3A%22Dentures%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envira%22%2C%22title%22%3A%22Implants%22%7D%5D" id="cz_48229" sk_lists="padding-bottom:0px;margin-bottom:0px;font-weight:500;" sk_icons="color:#365ff3;font-size:20px;"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][cz_stylish_list items="%5B%7B%22icon%22%3A%22fa%20fa-envira%22%2C%22title%22%3A%22Bridges%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envira%22%2C%22title%22%3A%22Crowns%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envira%22%2C%22title%22%3A%22Orthodontist%22%7D%5D" id="cz_38873" sk_lists="padding-bottom:0px;margin-bottom:0px;font-weight:500;" sk_icons="color:#365ff3;font-size:20px;"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',
					),
					array(
						'f' => 'team member doctor 4 columns boss 204_jpg',
						'c' =>'[vc_row][vc_column offset="vc_col-md-4"][cz_team style="cz_team_5" hover_mode="cz_team_always_show" image="http://xtratheme.com/dentist/wp-content/uploads/sites/11/2017/06/d1-1.jpg" overal_border-radius="10px" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-skype%22%2C%22title%22%3A%22Skype%22%2C%22link%22%3A%22%23%22%7D%5D" id="cz_69719" sk_icons="color:#365ff0;" sk_overall="margin-top:42px;" sk_overall_tablet="margin-top:20px;"]<h4><span style="margin: 0px 2px; padding: 1px 7px 2px; background: #365ff3; border-radius: 2px; color: #ffffff; font-size: 30px;"><strong>John Carter</strong></span></h4><span style="margin: 0 2px 0 0; padding: 1px 7px 2px; background: #ffffff; border-radius: 2px; color: #365ff3;">Dentist, Founder</span>[/cz_team][/vc_column][vc_column css=".vc_custom_1514812386990{padding-left: 40px !important;}" offset="vc_col-md-8"][cz_gap height="66px" height_tablet="20px" height_mobile="20px" id="cz_60598"][cz_title icon_before_type="image" shape="text" image_as_icon="http://xtratheme.com/dentist/wp-content/uploads/sites/11/2017/06/title_icon-1.png" shape_text="DENTISTS" mobile_shape_font-size="3em" tablet_shape_font-size="4em" id="cz_60783" sk_shape="font-size:7em;color:#365ff3;top:-35px;left:-10px;opacity:0.1;" sk_icon_before="background-color:#365ff3;padding:14px;margin:-6px 20px -10px -10px;border-radius:50px;" sk_shape_tablet="font-size:6em;" sk_shape_mobile="font-size:3em;top:10px;left:70px;" sk_overall="margin-bottom:20px;" sk_icon_before_mobile="margin-bottom:10px;"]<span style="color: #808080;">Our dentists and nurses</span><h3>Meet Our <span style="color: #365ff3;">Dentists</span></h3>[/cz_title][vc_column_text css=".vc_custom_1499433377219{margin-bottom: 20px !important;}"]<span style="font-size: 15px;">We love to help patients work better with their dentists. Dr. Mark Burhenne will help to ask the right questions.</span>[/vc_column_text][vc_row_inner][vc_column_inner width="1/3"][cz_team style="cz_team_4" hover_mode="cz_team_always_show" image="http://xtratheme.com/dentist/wp-content/uploads/sites/11/2017/06/d4-1.jpg" overal_border-radius="10px" social="%5B%7B%7D%5D" id="cz_39436"]<h4><strong>David Jerry</strong></h4>Dentist[/cz_team][/vc_column_inner][vc_column_inner width="1/3"][cz_team image="http://xtratheme.com/dentist/wp-content/uploads/sites/11/2017/06/d3-1.jpg" overal_border-radius="10px" social="%5B%7B%7D%5D" id="cz_82643"]<h4><strong>Jennifer Lora</strong></h4>Dentist[/cz_team][/vc_column_inner][vc_column_inner width="1/3"][cz_team image="http://xtratheme.com/dentist/wp-content/uploads/sites/11/2017/06/d2-1.jpg" overal_border-radius="10px" social="%5B%7B%7D%5D" id="cz_94811"]<h4><strong>Andy Cage</strong></h4>Dentist[/cz_team][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',
					),
					array(
						'f' => 'banner 2 columns filp box image 205_jpg',
						'c' =>'[vc_row][vc_column][cz_gap height="110px" id="cz_15885"][cz_title shape="circle cz_title_shape_outline" shape2="icon" smart_fs="true" id="cz_96567" sk_shape="font-size:2em;color:rgba(0,6,255,0.05);top:20px;" sk_overall="margin-bottom:70px;" sk_shape2="font-size:44px;color:#0006ff;text-align:center;top:-17px;" shape_icon2="fa fa-caret-down"]<h3 style="text-align: center;"><span style="font-size: 36px;">New <em><span style="font-weight: 300;">Collections</span></em> Of Arrivals</span></h3><p style="text-align: center;">Sweatshirt, Hoodie, Lingerie, etc.</p>[/cz_title][/vc_column][/vc_row][vc_row][vc_column offset="vc_col-md-6"][cz_content_box type="1" back_content_position="cz_box_back_pos_mc" back_box="true" id="cz_81535" sk_overall="background-size:cover;background-image:url(//xtratheme.com/fashion-shop/wp-content/uploads/sites/17/2017/06/b1-1.jpg);padding-top:160px;padding-bottom:50px;padding-left:50px;border-radius:10px;" back_content="Quickly foster with resource maximizing" sk_back="background-color:#ff0090;border-radius:10px;" sk_back_in="color:#ffffff;" back_btn_link="url:http%3A%2F%2Fxtratheme.com%2Ffashion-shop%2Fproducts%2F|||" sk_back_btn="color:#000000;background-color:#ffffff;border-radius:4px;" sk_back_btn_hover="color:#ffffff;background-color:rgba(0,0,0,0.76);" back_title="59% OFF FOR WOMEN CLOTHES" back_btn_title="Check Collection"][cz_title id="cz_46450"]<h3><span style="color: #ff0090;">WOMEN</span> CLOTHES</h3><span style="color: #5c5c5c;">NEW ARRIVALS</span>[/cz_title][/cz_content_box][cz_gap height="30px" id="cz_62034"][/vc_column][vc_column offset="vc_col-md-6"][cz_content_box type="1" back_content_position="cz_box_back_pos_mc" back_box="true" id="cz_38233" sk_overall="background-position:center bottom;background-size:cover;background-image:url(//xtratheme.com/fashion-shop/wp-content/uploads/sites/17/2017/06/b2.jpg);padding-top:160px;padding-bottom:50px;padding-left:50px;border-radius:10px;" back_content="Quickly foster with resource maximizing" sk_back="background-color:#0006ff;border-radius:10px;" sk_back_in="color:#ffffff;" back_btn_link="url:http%3A%2F%2Fxtratheme.com%2Ffashion-shop%2Fproducts%2F|||" sk_back_btn="color:#000000;background-color:#ffffff;border-radius:4px;" sk_back_btn_hover="color:#ffffff;background-color:rgba(0,0,0,0.76);" back_title="50% OFF FOR MEN CLOTHES" back_btn_title="Check Collection"][cz_title id="cz_66386"]<h3><span style="color: #0006ff;">MEN</span> CLOTHES</h3><span style="color: #5c5c5c;">NEW ARRIVALS</span>[/cz_title][/cz_content_box][cz_gap height="30px" id="cz_20875"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'image 4 columns banner services zoom 206_jpg',
						'c' =>'[vc_row][vc_column][cz_gap height="110px" height_tablet="100px" height_mobile="80px" id="cz_25260"][cz_title shape="text" smart_fs="true" text_center="true" shape_text="WELCOME" tablet_shape_font-size="4em" mobile_shape_font-size="3em" id="cz_44767" sk_shape="color:rgba(237,187,95,0.2);" sk_shape_tablet="font-size:6em;" sk_shape_mobile="font-size:3em;" sk_overall="margin-bottom:60px;" sk_overall_tablet="margin-bottom:30px;"]<h2 style="text-align: center;"><span style="font-size: 46px;">Welcome To <span style="color: #edbb5f;">Xtra Hotel</span></span></h2><p style="text-align: center;"><span style="color: #808080; font-size: 18px;">Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae.</span></p>[/cz_title][/vc_column][/vc_row][vc_row][vc_column width="1/2" offset="vc_col-md-3"][cz_title bline="cz_line_after_title" id="cz_41941" sk_overall="margin-bottom:12px;" sk_lines="background-color:#edbb5f;width:30px;top:-10px;"]<h4 style="text-align: center;"><span style="font-weight: 400;">Swimming Tool</span></h4>[/cz_title][cz_image_hover_zoom size="270x400" image="'.$imgu.'600x800.jpg" id="cz_89314"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][cz_title bline="cz_line_after_title" id="cz_63365" sk_overall="margin-bottom:12px;" sk_lines="background-color:#edbb5f;width:30px;top:-10px;"]<h4 style="text-align: center;"><span style="font-weight: 400;">Romantic Dinner</span></h4>[/cz_title][cz_image_hover_zoom size="270x400" image="'.$imgu.'600x800.jpg" id="cz_44170"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][cz_title bline="cz_line_after_title" id="cz_51269" sk_overall="margin-bottom:12px;" sk_lines="background-color:#edbb5f;width:30px;top:-10px;"]<h4 style="text-align: center;"><span style="font-weight: 400;">Astonishing View</span></h4>[/cz_title][cz_image_hover_zoom size="270x400" image="'.$imgu.'600x800.jpg" id="cz_93411"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][cz_title bline="cz_line_after_title" id="cz_67624" sk_overall="margin-bottom:12px;" sk_lines="background-color:#edbb5f;width:30px;top:-10px;"]<h4 style="text-align: center;"><span style="font-weight: 400;">Wellness &amp; SPA</span></h4>[/cz_title][cz_image_hover_zoom size="270x400" image="'.$imgu.'600x800.jpg" id="cz_23106"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'gym sport services two 2 columns stylish list icon 207_jpg',
						'c' =>'[vc_row][vc_column offset="vc_col-lg-4"][cz_image parallax="-6" parallax_h="true" image="http://xtratheme.com/gym/wp-content/uploads/sites/6/2017/06/m1-1-1.jpg" id="cz_43512" sk_css="margin-left:-40px;position:relative;display: table;margin:0 auto;"][/vc_column][vc_column offset="vc_col-lg-8"][cz_gap height="40px" id="cz_13892" height_tablet="30px"][cz_title bline="cz_line_after_title" smart_fs="true" id="cz_90508" sk_lines="background-color:#ff4938;width:60px;top:0px;"]<span style="font-size: 20px; color: #999999; font-weight: 300;">Welcome to Body Building</span><h3><span style="font-size: 52px; font-weight: bold;"><strong><span style="font-weight: 300;">Start</span> <span style="color: #ff4938; font-weight: 900;">Workout</span> <span style="font-weight: 300;">Routines</span></strong></span></h3>[/cz_title][cz_gap height="30px" id="cz_58641"][vc_column_text css=".vc_custom_1497685631875{margin-bottom: 40px !important;}"]<span style="font-size: 20px;">All you need to eliminate your belly is a few square feet whether it\'s at the gym or in your living room to complete this flab-blasting bodyweight circuit.</span>[/vc_column_text][vc_row_inner][vc_column_inner offset="vc_col-md-4"][cz_stylish_list items="%5B%7B%22title%22%3A%22Abs%20workouts%22%2C%22icon%22%3A%22fa%20fa-check%22%7D%2C%7B%22title%22%3A%22Anywhere%20Workouts%22%2C%22icon%22%3A%22fa%20fa-check%22%7D%2C%7B%22title%22%3A%22Arms%20Workouts%22%2C%22icon%22%3A%22fa%20fa-check%22%7D%2C%7B%22title%22%3A%22Bodyweight%20Workouts%22%2C%22icon%22%3A%22fa%20fa-check%22%7D%5D" id="cz_73067" sk_lists="font-weight:500;font-size:18px;" sk_icons="color:#ffffff;background-color:#ff4938;border-radius:100%;"][cz_gap id="cz_54378" height_tablet="20px"][/vc_column_inner][vc_column_inner offset="vc_col-md-4"][cz_stylish_list items="%5B%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22Back%20Workouts%22%7D%2C%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22Biceps%20Workouts%22%7D%2C%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22Cardio%20Workouts%22%7D%2C%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22Chest%20Workouts%22%7D%5D" id="cz_44029" sk_lists="font-weight:500;font-size:18px;" sk_icons="border-radius:100%;background-color:#ff4938;color:#ffffff;"][cz_gap id="cz_50513" height_tablet="20px"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][cz_stylish_list items="%5B%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22CrossFit%20Workouts%22%7D%2C%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22Kettlebell%20Workouts%22%7D%2C%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22Quick%20Workouts%22%7D%2C%7B%22icon%22%3A%22fa%20fa-check%22%2C%22title%22%3A%22Triceps%20Workouts%22%7D%5D" id="cz_55593" sk_lists="font-weight:500;font-size:18px;" sk_icons="border-radius:100%;background-color:#ff4938;color:#ffffff;"][cz_gap id="cz_34253"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',
					),
					array(
						'f' => 'tab video parallax gym 208_jpg',
						'c' =>'[vc_row full_width="stretch_row" parallax="content-moving" css=".vc_custom_1515727288399{background-image: url(//xtratheme.com/gym/wp-content/uploads/sites/6/2017/06/parallax1-1.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}][vc_column offset="vc_col-lg-6"][cz_tabs id="cz_31294" sk_row="border-style:solid;border-bottom-width:4px;border-color:rgba(255,255,255,0.1);display:inline-block;" sk_tabs="font-size:20px;color:#eaeaea;font-weight:500;padding-top:10px;padding-bottom:10px;margin-right:36px;" sk_active="border-bottom-style:solid;border-color:#ff4938;background-color:rgba(0,0,0,0.15);border-bottom-width:4px;font-weight:900;color:#ff4938;" sk_con="margin-top:100px;margin-bottom:100px;" sk_con_tablet="margin-top:40px;margin-bottom:0px;" sk_tabs_tablet="margin-bottom:0px;"][cz_tab title="Cardio" id="cz_28690"][vc_column_text css=".vc_custom_1496659692877{margin-bottom: 20px !important;}"]<span style="font-size: 18px;"><span style="color: #ffffff;">Run on a track or field. Note a spot on the track that’s 20 meters away to one side of you and one that’s 20 meters to the opposite side. Turn and run 20 meters to one marker. Stop, turn the other direction, and run all the way back till you hit the second marker.</span></span>[/vc_column_text][cz_title icon_before_type="icon" icon="fa fa-male" id="cz_33200" sk_icon_before="color:#ff4938;background-color:#ffffff;margin-right:10px;margin-left:-6px;border-radius:100%;" sk_icon_before_mobile="margin-bottom:20px;"]<h3><span style="color: #ffffff;">1,000 Meter Shuttle Run</span></h3><span style="color: #999999;">Four Days Every Week</span>[/cz_title][/cz_tab][cz_tab title="Pro Tips" id="cz_43561"][vc_column_text css=".vc_custom_1496659437663{margin-bottom: 20px !important;}"]<span style="font-size: 18px;"><span style="color: #ffffff;">The most important part of bench pressing might just be your set-up. When you lay back on the bench, make sure you line up your eyes directly under the bar. This will help for two reasons. First, it will allow you to pull the bar forward, setting your shoulders and back in the proper shelf position.</span></span>[/vc_column_text][cz_title icon_before_type="icon" icon="fa fa-thumbs-up" id="cz_53143" sk_icon_before="color:#ff4938;background-color:#ffffff;margin-right:10px;margin-left:-6px;border-radius:100%;" sk_icon_before_mobile="margin-bottom:20px;"]<h3><span style="color: #ffffff;">Increase Bench Press</span></h3><span style="color: #999999;">Some New Tips To Increase Your Bench Press</span>[/cz_title][/cz_tab][cz_tab title="Workout Routines" id="cz_81625"][vc_column_text css=".vc_custom_1496659240662{margin-bottom: 20px !important;}"]<span style="font-size: 18px;"><span style="color: #ffffff;">You\'ll start first with the dumbbell hang clean before moving on to the dumbbell squat and clean, which will work your quads, hamstrings, and glutes even harder. Finish off the set with a dumbbell hang clean and squat and press to bring the progression full circle ...</span></span>[/vc_column_text][cz_title icon_before_type="icon" icon="fa fa-users" id="cz_35894" sk_icon_before="color:#ff4938;background-color:#ffffff;margin-right:10px;margin-left:-6px;border-radius:100%;" sk_icon_before_mobile="margin-bottom:20px;"]<h3><span style="color: #ffffff;">The 5 High Intensity Workouts</span></h3><span style="color: #999999;">High-intensity Hurricane Workouts</span>[/cz_title][/cz_tab][cz_tab title="Build Muscle" id="cz_52970"][vc_column_text css=".vc_custom_1496658924277{margin-bottom: 20px !important;}"]<span style="font-size: 18px;"><span style="color: #ffffff;">This muscle building, Progressive circuit may start with one ordinary exercise: the dumbbell hang clean, also known as the motion you make to rack a heavy dumbbell after a grueling set of curls. The transformation you\'ll see as a result of this routine.</span></span>[/vc_column_text][cz_title icon_before_type="icon" icon="fa fa-clock-o" id="cz_24561" sk_icon_before="color:#ff4938;background-color:#ffffff;margin-right:10px;margin-left:-6px;border-radius:100%;" sk_icon_before_mobile="margin-bottom:20px;"]<h3><span style="color: #ffffff;">The Progressive Dumbbell</span></h3><span style="color: #999999;">45 Minutes Daily</span>[/cz_title][/cz_tab][/cz_tabs][/vc_column][vc_column offset="vc_col-lg-6"][cz_video_popup video="https://vimeo.com/119692469" size="cz_video_popup_size_3" ripple="true" title="GYM SHOW" subtitle="Watch Video" title_background="#ff4938" icon_color="#ff4938" id="cz_39565" sk_overall="margin-top:170px;margin-bottom:100px;" sk_title="background-color:transparent;background-image:linear-gradient(90deg,#0a0101,rgba(0,0,0,0.01));" sk_icon="color:#ffffff;background-color:#ff4938;" sk_overall_tablet="margin-top:20px;margin-bottom:50px;" sk_icon_mobile="font-size:14px;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'testimonials quote client 2 columns dark 209_jpg',
						'c' =>'[vc_row][vc_column][cz_gap height="80px" height_tablet="60px" id="cz_32176"][cz_title bline="cz_line_after_title" smart_fs="true" id="cz_99940" sk_lines="background-color:#ff4938;width:60px;top:0px;"]<p style="text-align: center;"><span style="font-size: 20px; color: #999999; font-weight: 300;">Our Clients Testimonials</span></p><h3 style="text-align: center; font-size: 52px;"><span style="font-weight: bold;"><strong><span style="font-weight: 300;">People </span></strong></span><span style="font-weight: bold;"><strong><span style="color: #ff4938; font-weight: 900;">Believe </span></strong></span><span style="font-weight: bold;"><strong><span style="font-weight: 300;">Other People</span></strong></span></h3>[/cz_title][cz_gap height="60px" id="cz_46856" height_tablet="80px"][/vc_column][/vc_row][vc_row][vc_column offset="vc_col-md-6"][cz_testimonials subname="Bodybuilder" style="6" id="cz_22689" avatar="'.$imgu.'80x80.jpg" sk_content="color:#ffffff;background-size:cover;background-color:transparent;background-image:linear-gradient(0deg,rgba(0,0,0,0.68),rgba(56,1,1,0.67)),url(http://xtratheme.com/gym/wp-content/uploads/sites/6/2017/06/c6-1-1.jpg);border-style:solid;border-width:0px 0px 5px;border-color:#ff4938;" sk_avatar="border-style:solid;border-width:5px;border-color:#ff4938;" sk_content_tablet="margin-bottom:60px;"]<p style="text-align: center;">Fitness is not about being better than someone else... It\'s about being better than you used to be.</p>[/cz_testimonials][/vc_column][vc_column offset="vc_col-md-6"][cz_testimonials name="Lisa Smith" subname="Bodybuilder" style="6" id="cz_55645" avatar="'.$imgu.'80x80.jpg" sk_content="color:#ffffff;background-size:cover;background-color:transparent;background-image:linear-gradient(0deg,rgba(0,0,0,0.68),rgba(56,1,1,0.67)),url(http://xtratheme.com/gym/wp-content/uploads/sites/6/2017/06/a5-1.jpg);border-style:solid;border-width:0px 0px 5px;border-color:#ff4938;" sk_avatar="border-style:solid;border-width:5px;border-color:#ff4938;"]<p style="text-align: center;">Fitness is not about being better than someone else... It\'s about being better than you used to be.</p>[/cz_testimonials][/vc_column][/vc_row]',
					),
					array(
						'f' => 'work process steps 3 columns full wide dark 210_jpg',
						'c' =>'[vc_row full_width="stretch_row" parallax="content-moving" css=".vc_custom_1515727288399{background-image: url(//xtratheme.com/business/wp-content/uploads/sites/12/2017/06/parallax1-1.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}][vc_column][cz_separator style="cz_sep_26" id="cz_59684" top_color="#ffffff"][cz_gap height="120px" height_tablet="100px" id="cz_83577"][cz_title shape="icon" smart_fs="true" text_center="true" shape_icon="fa fa-fire" id="cz_84706" sk_shape="color:rgba(246,132,32,0.1);"]<p style="text-align: center;"><span style="color: #d9d9d9; font-size: 18px;">Work Process</span></p><h3 style="text-align: center;"><span style="font-size: 40px; color: #ffffff;">With</span><span style="font-size: 40px;"><span style="color: #f68420;"> Exprience </span><span style="color: #ffffff;">We Complete Any Projects</span></span></h3>[/cz_title][cz_gap height="80px" height_tablet="50px" id="cz_79228"][vc_row_inner][vc_column_inner css=".vc_custom_1514561288282{margin-right: 0px !important;padding-right: 0px !important;}" offset="vc_col-md-4"][cz_process_road line_height="100px" line_border-style="dashed" type="image" icon_style="cz_road_icon_rhombus_2" line_border-color="rgba(255,255,255,0.3)" id="cz_96718" image="http://xtratheme.com/business/wp-content/uploads/sites/12/2017/06/pr1-1-1.png" sk_icon="background-color:#ffffff;color:#0a0a0a;font-size:60px;border-radius:30%;"][cz_gap height="60px" id="cz_17863"][cz_title id="cz_47755" sk_overall="padding-right:30px;padding-left:30px;margin-bottom:40px;" sk_overall_tablet="margin-bottom:50px;"]<h4 style="text-align: center;"><span style="color: #ffffff; font-size: 28px; display: inline-block; margin-bottom: 20px;"><span style="color: #707070; font-weight: 300;">01. </span><span style="font-weight: bold;">IDEA</span></span></h4><p style="text-align: center;"><span style="color: #ffffff;">Based on client information, First we finding some new idea\'s for project</span></p>[/cz_title][/vc_column_inner][vc_column_inner css=".vc_custom_1514561307208{margin-right: 0px !important;margin-left: 0px !important;padding-right: 6px !important;padding-left: 6px !important;}" offset="vc_col-md-4"][cz_process_road road="cz_road_lr" line_height="100px" line_border-style="dashed" type="image" icon_style="cz_road_icon_rhombus_2" line_border-color="rgba(255,255,255,0.3)" id="cz_40694" image="http://xtratheme.com/business/wp-content/uploads/sites/12/2017/06/pr2-1.png" sk_icon="background-color:#ffffff;color:#0a0a0a;font-size:60px;border-radius:30%;"][cz_gap height="60px" id="cz_83067"][cz_title id="cz_69978" sk_overall="padding-right:30px;padding-left:30px;margin-bottom:40px;" sk_overall_tablet="margin-bottom:50px;"]<h4 style="text-align: center;"><span style="color: #ffffff; font-size: 28px; display: inline-block; margin-bottom: 20px;"><span style="color: #707070; font-weight: 300;">02. </span><span style="font-weight: bold;">DESIGNING</span></span></h4><p style="text-align: center;"><span style="color: #ffffff;">Based on idea, we will start to design wireframing in photo shop</span></p>[/cz_title][/vc_column_inner][vc_column_inner css=".vc_custom_1514561317946{margin-left: 0px !important;padding-left: 0px !important;}" offset="vc_col-md-4"][cz_process_road road="cz_road_tl cz_road_cl" line_height="100px" line_border-style="dashed" type="image" icon_style="cz_road_icon_rhombus_2" line_border-color="rgba(255,255,255,0.3)" id="cz_31705" image="http://xtratheme.com/business/wp-content/uploads/sites/12/2017/06/pr3-1.png" sk_icon="background-color:#ffffff;color:#0a0a0a;font-size:60px;border-radius:30%;"][cz_gap height="60px" id="cz_39297"][cz_title id="cz_58172" sk_overall="padding-right:30px;padding-left:30px;margin-bottom:40px;"]<h4 style="text-align: center;"><span style="color: #ffffff; font-size: 28px; display: inline-block; margin-bottom: 20px;"><span style="color: #707070; font-weight: 300;">03. </span><span style="font-weight: bold;">DEVELOPMENT</span></span></h4><p style="text-align: center;"><span style="color: #ffffff;">After completing photo shop design, we\'re going to complete coding</span></p>[/cz_title][/vc_column_inner][/vc_row_inner][cz_gap height="100px" height_tablet="50px" id="cz_30658"][cz_separator style="cz_sep_26" rotate="cz_sep_rotate" id="cz_65425" top_color="#ffffff"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'image about 2 columns service 211_jpg',
						'c' =>'[vc_row][vc_column][cz_gap height="100px" id="cz_36743"][cz_title shape="icon" smart_fs="true" text_center="true" shape_icon="fa fa-fire" id="cz_22961" sk_shape="color:rgba(246,132,32,0.1);"]<p style="text-align: center;"><span style="color: #808080; font-size: 18px;">Available For Any Projects</span></p><h3 style="text-align: center;"><span style="font-size: 40px;">How Can We</span><span style="font-size: 40px;"><span style="color: #f68420;"> Help You ?</span></span></h3>[/cz_title][cz_gap height="70px" height_tablet="40px" id="cz_95662"][/vc_column][/vc_row][vc_row][vc_column css=".vc_custom_1514560851792{margin-right: 0px !important;padding-right: 0px !important;}" offset="vc_col-lg-6"][cz_image image="'.$imgu.'800x600.jpg" id="cz_97962" sk_css="position:relative;display: table;margin:0 auto;"][/vc_column][vc_column offset="vc_col-lg-6"][cz_gap height="44px" id="cz_12878"][cz_content_box type="1" id="cz_94500" sk_overall="background-color:rgba(255,255,255,0.9);padding-left:120px;margin-left:-100px;border-style:solid;border-width:1px;border-color:#f4f4f4;border-radius:20px;" sk_overall_tablet="padding-left:30px;margin-left:0px;"][cz_title bline="cz_line_after_title" id="cz_48705" sk_lines="background-color:#f68420;height:2px;top:-10px;" sk_overall="margin-bottom:14px;"]<h3><span style="font-size: 28px;">Product <span style="color: #f68420;">Design</span></span></h3>[/cz_title][vc_column_text]<span style="color: #808080;">Mauris blandit aliquet elit, eget tincidunt nibh pulvinar a. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices</span>[/vc_column_text][cz_button title="READ MORE" icon_position="after" icon="fa fa-long-arrow-right" link="url:http%3A%2F%2Fxtratheme.com%2Fbusiness%2Fservices%2F|||" id="cz_74346" sk_button="font-size:14px;color:#595959;font-weight:500;background-color:rgba(0,0,0,0);padding:0px;margin-top:24px;" sk_icon="font-size:20px;"][/cz_content_box][cz_free_position_element hide_on_tablet="true" hide_on_mobile="true" css_top="43.18139792899408%" css_left="-20%" id="cz_82151"][vc_icon icon_fontawesome="fa fa-handshake-o" color="white" align="center" css=".vc_custom_1510353296537{padding: 8px !important;background-color: #f68420 !important;border-radius: 30% !important;}"][/cz_free_position_element][/vc_column][/vc_row][vc_row][vc_column offset="vc_col-lg-6"][cz_gap id="cz_59822"][cz_content_box type="1" id="cz_57156" class="z9" sk_overall="background-color:rgba(255,255,255,0.9);padding-right:120px;margin-right:-100px;border-style:solid;border-width:1px;border-color:#f4f4f4;border-radius:20px;" sk_overall_tablet="padding-right:30px;margin-right:0px;"][cz_title bline="cz_line_after_title" id="cz_90071" sk_lines="background-color:#f68420;height:2px;top:-10px;" sk_overall="margin-bottom:14px;"]<h3 style="text-align: right;"><span style="font-size: 28px;">Business <span style="color: #f68420;">Solutions</span></span></h3>[/cz_title][vc_column_text]<p style="text-align: right;"><span style="color: #808080;">Mauris blandit aliquet elit, eget tincidunt nibh pulvinar a. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices </span></p>[/vc_column_text][cz_button title="READ MORE" btn_position="cz_btn_right" icon_position="after" icon="fa fa-long-arrow-right" link="url:http%3A%2F%2Fxtratheme.com%2Fbusiness%2Fservices%2F|||" id="cz_19150" sk_button="font-size:14px;color:#595959;font-weight:500;background-color:rgba(0,0,0,0.01);padding:0px;margin-top:24px;" sk_icon="font-size:20px;"][/cz_content_box][cz_free_position_element hide_on_tablet="true" hide_on_mobile="true" css_top="44.008190883190885%" css_left="107.83333333333334%" id="cz_73688"][vc_icon icon_fontawesome="fa fa-check" color="white" align="center" css=".vc_custom_1510008072209{padding-top: 8px !important;padding-right: 8px !important;padding-bottom: 8px !important;padding-left: 8px !important;background-color: #f68420 !important;border-radius: 30% !important;}"][/cz_free_position_element][/vc_column][vc_column css=".vc_custom_1516110007856{margin-right: 0px !important;margin-left: 0px !important;padding-right: 0px !important;padding-left: 0px !important;}" offset="vc_col-lg-6"][cz_gap height="1px" id="cz_63589" height_tablet="50px"][cz_image image="'.$imgu.'800x600.jpg" id="cz_93236" sk_css="margin:0 auto;" sk_css_tablet="margin-bottom:30px;"][/vc_column][/vc_row]',
					),
					array(
						'f' => 'about skill progress about image 212_jpg',
						'c' =>'[vc_row][vc_column][cz_gap height="110px" height_tablet="100px" id="cz_37266"][cz_title shape="icon" shape_icon="fa fa-fire" id="cz_87570" sk_shape="color:rgba(246,132,32,0.1);"]<p style="text-align: center;"><span style="color: #808080; font-size: 18px;">We\'re Professional</span></p><h3 style="text-align: center;"><span style="font-size: 40px;">Our</span><span style="font-size: 40px;"><span style="color: #f68420;"> Skills</span></span></h3>[/cz_title][cz_gap height="70px" height_tablet="20px" height_mobile="20px" id="cz_62699"][/vc_column][/vc_row][vc_row][vc_column css=".vc_custom_1514560967896{padding-right: 30px !important;}" offset="vc_col-lg-4"][cz_gap id="cz_28959"][cz_title smart_fs="true" text_center="true" id="cz_61962" sk_overall="margin-bottom:30px;"]<h4 style="text-align: right;"><span style="font-size: 24px;"><span style="font-weight: 300;">Essential</span> <span class="cz_underline" style="margin: 0px 2px; padding: 1px 0px 2px; border-bottom: 1px solid; color: #f68420;">Business</span> <span style="font-weight: 300;">Skills</span></span></h4>[/cz_title][cz_title text_center="true" id="cz_23071" sk_overall="margin-bottom:30px;"]<p style="text-align: right;"><span style="color: #808080;">You will require a number of skills to start and run a business. It is important to identify the skills you need to develop or improve so that you can succeed in your day-to-day business operations. It is important to be able to promote your products or services effectively. Providing good customer service and having a marketing strategy in place will help you to generate sales.</span></p>[/cz_title][/vc_column][vc_column offset="vc_col-lg-4 vc_col-md-6"][cz_image parallax="9" image="'.$imgu.'600x800.jpg" id="cz_31265" sk_css="margin-bottom:-20px;"][/vc_column][vc_column css=".vc_custom_1514560996568{padding-left: 30px !important;}" offset="vc_col-lg-4 vc_col-md-6"][cz_gap height="40px" id="cz_89643"][cz_progress_bar title="Marketing" style="pbar2" id="cz_84598" sk_title="font-size:18px;" sk_num="border-radius:20px;background-color:#f68420;padding-left:16px;padding-right:16px;color:#ffffff;" sk_progress="background-color:transparent;background-image:linear-gradient(90deg,#ffffff,#f68420);" sk_bar="height:2px;"][cz_progress_bar title="Business Solutions" number="81%" style="pbar2" id="cz_17465" sk_title="font-size:18px;" sk_num="border-radius:20px;background-color:#f68420;padding-left:16px;padding-right:16px;color:#ffffff;" sk_progress="background-color:transparent;background-image:linear-gradient(90deg,#ffffff,#f68420);" sk_bar="height:2px;"][cz_progress_bar title="Development" number="72%" style="pbar2" id="cz_83101" sk_title="font-size:18px;" sk_num="border-radius:20px;background-color:#f68420;padding-left:16px;padding-right:16px;color:#ffffff;" sk_progress="background-color:transparent;background-image:linear-gradient(90deg,#ffffff,#f68420);" sk_bar="height:2px;"][cz_progress_bar title="Design & Branding" number="80%" style="pbar2" id="cz_65830" sk_title="font-size:18px;" sk_num="border-radius:20px;background-color:#f68420;padding-left:16px;padding-right:16px;color:#ffffff;" sk_progress="background-color:transparent;background-image:linear-gradient(90deg,#ffffff,#f68420);" sk_bar="height:2px;"][cz_progress_bar title="Search Engines" number="88%" style="pbar2" id="cz_50154" sk_title="font-size:18px;" sk_num="border-radius:20px;background-color:#f68420;padding-left:16px;padding-right:16px;color:#ffffff;" sk_progress="background-color:transparent;background-image:linear-gradient(90deg,#ffffff,#f68420);" sk_bar="height:2px;"][cz_progress_bar title="Consulting" number="73%" style="pbar2" id="cz_78113" sk_title="font-size:18px;" sk_num="border-radius:20px;background-color:#f68420;padding-left:16px;padding-right:16px;color:#ffffff;" sk_progress="background-color:transparent;background-image:linear-gradient(90deg,#ffffff,#f68420);" sk_bar="height:2px;"][/vc_column][/vc_row]',
					)

			);

			$p = apply_filters( 'codevz_templates', $p, $color );

			return isset( $p[ $n ] ) ? $p[ $n ] : $p;
		}
		
	}

	// Run
	Codevz_Templates::instance();

}