
jQuery(function($) {
    $('#pageContent .owl-carousel').owlCarousel({
        singleItem: true,
        pagination: false,
        navigation: true,
        autoHeight: true
    });
});

var default_content = "";
var default_title = "";
var last_url = '';
var loading_flag = false;

$(document).ready(function() {
    $(document).on('click', 'a', function(e) {
        if (checkURL($(this).attr('href'))) {
            e.preventDefault();
            return false;
        }
        return true;
    });
    //filling in the default content
    default_content = $('#pageContent').html();
    default_title = $('#page-title').html();
    checkURL(window.location.hash);
});

$(window).on('hashchange', function() {
    checkURL(window.location.hash);
});

function checkURL(hash) {
    if (loading_flag)
        return;

    loading_flag = true;
    if (typeof hash === 'undefined') {
        loading_flag = false;
        return false;
    }

    if (!hash) {
        $('#pageContent').html(default_content);
        $('#page-title').html(default_title);
        last_url = '';
        loading_flag = false;
        return true;
    }

    loading_flag = false;
    return loadPage(hash);
}

function refreshPage(msg) {
    $('#loading').css('visibility','hidden');
    $('#pageContent').css('opacity','1');
    $('#pageContent').html(msg);
    $('#page-title').html($('#pageContent .heading').html());
    $('#pageContent [data-plugin-toggle]').each(function() {
        var $this = $( this ),
            opts = {};

        var pluginOptions = $this.data('plugin-options');
        if (pluginOptions)
            opts = pluginOptions;

        $this.themePluginToggle(opts);
    });
    $('[data-plugin-lightbox], .lightbox:not(.manual)').each(function() {
        var $this = $( this ),
            opts = {};

        var pluginOptions = $this.data('plugin-options');
        if (pluginOptions)
            opts = pluginOptions;

        $this.themePluginLightbox(opts);
    });

    $('#pageContent .owl-carousel').owlCarousel({
        singleItem: true,
        pagination: false,
        navigation: true,
        autoHeight: true
    });

    window.scrollTo(0, 0);
}

function loadPage(url) {
    url = url.replace('#','');
    ajax_page = false;
    switch (url) {
        case 'install':
        case 'theme_install':
        case 'theme_update':
        case 'plugin_install':
        case 'plugin_configuration':
        case 'demo_install':
        
        case 'video_tutorials':
        case 'theme-getting-started':
        case 'theme-update':
        case 'theme-mega-menu':
        case 'wc-installation':
        case 'wc-general-setting':
        case 'wc-product-setting':
        case 'wc-tax-setting':
        case 'wc-shipping-setting':
        case 'wc-checkout-setting':
        case 'wc-account-setting':
        case 'wc-cat-tag-setting':
        case 'wc-simple-product-setting':
        case 'wc-group-product-setting':
        case 'wc-affiliate-product-setting':
        case 'wc-variable-product-setting':
        case 'wc-downloadable-product-setting':
        case 'wc-woozone-plugin':
        case 'wc-multi-vendor':
        
        
        case 'update':
        case 'update_theme':
        case 'update_plugin':
        case 'build_site':
        case 'configuration':
        case 'theme_layout':
        case 'theme_options':
        case 'header_setup':
        case 'menu_setup':
        case 'one_page_setup':
        case 'woo_setup':
        case 'extra_class':
        case 'porto_settings':
        case 'option_general':
        case 'option_import':
        case 'option_skin':
        case 'option_header':
        case 'option_menu':
        case 'option_breadcrumbs':
        case 'option_footer':
        case 'option_page':
        case 'option_blog':
        case 'option_portfolio':
        case 'option_member':
        case 'option_faq':
        case 'option_404':
        case 'option_woocommerce':
        case 'option_bb':
        case 'option_social':
        case 'option_slider':
        case 'option_import_export':
        case 'option_font_control':       
        case 'content_types':
        case 'pageSetting':
        case 'post':
        case 'portfolio':
        case 'member':
        case 'faq':
        case 'block':
        case 'widgets':
        case 'widget_block':
        case 'widget_contact':
        case 'widget_follow':
        case 'widget_posts':
        case 'widget_portfolios':
        case 'widget_tweets':        
        case 'shortcodes':
        case 'shortcodes_banner':
        case 'shortcodes_product_tab':
        case 'shortcodes_other':
        case 'shortcode_animation':
        case 'shortcode_block':
        case 'shortcode_container':
        case 'shortcode_testimonial':
        case 'shortcode_content_box':
        case 'shortcode_history':
        case 'shortcode_grid':
        case 'shortcode_links':
        case 'shortcode_recent_posts':
        case 'shortcode_blog':
        case 'shortcode_portfolios':
        case 'shortcode_faqs':
        case 'shortcode_members':
        case 'translation':
        case 'speedup':
        case 'faqs':
        case 'comingfeatures':
        case 'support':
        case 'changelog':
            window.location.hash = url;
            ajax_page = true;
            break;
    }

    switch (url) {
        case 'install':
        case 'theme_install':
        case 'theme_update':
        case 'plugin_install':
        case 'plugin_configuration':
        case 'demo_install':
            $('.nav-main > li.nav-expanded').removeClass('nav-expanded');
            $('.nav-main > li.nav-expanded > ul').stop().slideUp();
            $('.nav-main > li:eq(1)').addClass('nav-expanded');
            $('.nav-main > li:eq(1) > ul').stop().slideDown();
            break;
        case 'video_tutorials':
        case 'theme-getting-started':
        case 'theme-update':
        case 'theme-mega-menu':
        case 'wc-installation':
        case 'wc-general-setting':
        case 'wc-product-setting':
        case 'wc-tax-setting':
        case 'wc-shipping-setting':
        case 'wc-checkout-setting':
        case 'wc-account-setting':
        case 'wc-cat-tag-setting':
        case 'wc-simple-product-setting':
        case 'wc-group-product-setting':
        case 'wc-affiliate-product-setting':
        case 'wc-variable-product-setting':
        case 'wc-downloadable-product-setting':
        case 'wc-woozone-plugin':
        case 'wc-multi-vendor':
            
            $('.nav-main > li.nav-expanded').removeClass('nav-expanded');
            $('.nav-main > li.nav-expanded > ul').stop().slideUp();
            $('.nav-main > li:eq(2)').addClass('nav-expanded');
            $('.nav-main > li:eq(2) > ul').stop().slideDown();
            break;
        case 'update':
        case 'update_theme':
        case 'update_plugin':
            $('.nav-main > li.nav-expanded').removeClass('nav-expanded');
            $('.nav-main > li.nav-expanded > ul').stop().slideUp();
            $('.nav-main > li:eq(3)').addClass('nav-expanded');
            $('.nav-main > li:eq(3) > ul').stop().slideDown();
            break;
        case 'build_site':
        case 'configuration':
        case 'theme_layout':
        case 'theme_options':
        case 'header_setup':
        case 'menu_setup':
        case 'one_page_setup':
        case 'woo_setup':
        case 'extra_class':
            $('.nav-main > li.nav-expanded').removeClass('nav-expanded');
            $('.nav-main > li.nav-expanded > ul').stop().slideUp();
            $('.nav-main > li:eq(4)').addClass('nav-expanded');
            $('.nav-main > li:eq(4) > ul').stop().slideDown();
            break;
        case 'porto_settings':
        case 'option_general':
        case 'option_import':
        case 'option_skin':
        case 'option_header':
        case 'option_menu':
        case 'option_breadcrumbs':
        case 'option_footer':
        case 'option_page':
        case 'option_blog':
        case 'option_portfolio':
        case 'option_member':
        case 'option_faq':
        case 'option_404':
        case 'option_woocommerce':
        case 'option_bb':
        case 'option_social':
        case 'option_slider':
        case 'option_import_export':
        case 'option_font_control':
            $('.nav-main > li.nav-expanded').removeClass('nav-expanded');
            $('.nav-main > li.nav-expanded > ul').stop().slideUp();
            $('.nav-main > li:eq(5)').addClass('nav-expanded');
            $('.nav-main > li:eq(5) > ul').stop().slideDown();
            break;        
        case 'content_types':        
        case 'pageSetting':
        case 'post':
        case 'portfolio':
        case 'member':
        case 'faq':
        case 'block':
            $('.nav-main > li.nav-expanded').removeClass('nav-expanded');
            $('.nav-main > li.nav-expanded > ul').stop().slideUp();
            $('.nav-main > li:eq(6)').addClass('nav-expanded');
            $('.nav-main > li:eq(6) > ul').stop().slideDown();
            break;
        case 'widgets':
        case 'widget_block':
        case 'widget_contact':
        case 'widget_follow':
        case 'widget_posts':
        case 'widget_portfolios':
        case 'widget_tweets':
            $('.nav-main > li.nav-expanded').removeClass('nav-expanded');
            $('.nav-main > li.nav-expanded > ul').stop().slideUp();
            $('.nav-main > li:eq(8)').addClass('nav-expanded');
            $('.nav-main > li:eq(8) > ul').stop().slideDown();
            break;        
        case 'shortcodes':
        case 'shortcodes_banner':
        case 'shortcodes_product_tab':
        case 'shortcodes_other':
        case 'shortcode_animation':
        case 'shortcode_block':
        case 'shortcode_container':
        case 'shortcode_testimonial':
        case 'shortcode_content_box':
        case 'shortcode_history':
        case 'shortcode_grid':
        case 'shortcode_links':
        case 'shortcode_recent_posts':
        case 'shortcode_blog':
        case 'shortcode_portfolios':
        case 'shortcode_faqs':
        case 'shortcode_members':
            $('.nav-main > li.nav-expanded').removeClass('nav-expanded');
            $('.nav-main > li.nav-expanded > ul').stop().slideUp();
            $('.nav-main > li:eq(7)').addClass('nav-expanded');
            $('.nav-main > li:eq(7) > ul').stop().slideDown();
            break;
        case 'translation':
        case 'speedup':
        case 'faqs':
        case 'comingfeatures':
        case 'support':
        case 'changelog':
            $('.nav-main > li.nav-expanded').removeClass('nav-expanded');
            $('.nav-main > li.nav-expanded > ul').stop().slideUp();
            break;
    }

    if (ajax_page) {

        if (last_url == url)
            return true;

        last_url = url;

        $('#loading').css('visibility','visible');
        $('#pageContent').css('opacity','0.3');

        var page_content = $('.section-' + url).html();

        if (page_content)
            refreshPage(page_content);

        window.scrollTo(0, 0);
        return true;
    } else if (url != '') {
        if ($('#'+url).length) {
            window.scrollTo(0, $('#'+url).offset().top - $('#pageContent').offset().top);
            return true;
        }
    }
    return false;
}
