<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
/**
 * @author  themepiko
 */
add_action( 'init', 'pikoworks_VC_setup');
if(!function_exists('pikoworks_VC_setup')) {
	function pikoworks_VC_setup() {
		vc_remove_element("vc_tour");
	}
}

if( defined( 'VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG' ) ) {
	add_filter(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, 'pikoworks_vc_custom_css_class', 10, 3);
	if( ! function_exists('pikoworks_vc_custom_css_class') ) {
		function pikoworks_vc_custom_css_class( $classes, $base, $atts ) {
			if( ! empty( $atts['fixed_background'] ) ) {
				$classes .= ' piko-parallax-' . $atts['fixed_background'];
			}
			if( ! empty( $atts['off_center'] ) ) {
				$classes .= ' off-center-' . $atts['off_center'];
			}
			return $classes;
		}
	}
}

// **********************************************************************//
// ! Add new option to vc_column
// **********************************************************************//
add_action( 'init', 'pikoworks_columns_options');
if(!function_exists('pikoworks_columns_options')) {
	function pikoworks_columns_options() {
		if(!function_exists('vc_map')) return;
		vc_add_param('vc_column', array(
			"type" => "dropdown",
			"heading" => esc_html__("Fixed background position", 'xstore'),
			"param_name" => "fixed_background",
			"group" => esc_html__('Design Options', 'xstore'),
			"edit_field_class" => 'vc_col-sm-5 vc_column',
			"value" => array(
				esc_html__( '--- Select option ---', 'pikoworks_core' ) => '',
				esc_html__("Left center", 'pikoworks_core') => 'left',
				esc_html__("Right center", 'pikoworks_core') => 'right',
				esc_html__("Center center", 'pikoworks_core') => 'center',
			)
		));

		vc_add_param('vc_column', array(
			"type" => "dropdown",
			"heading" => esc_html__("Off center", 'pikoworks_core'),
			"param_name" => "off_center",
			"value" => array(
				esc_html__( '--- Select option ---', 'pikoworks_core' ) => '',
				esc_html__("Left", 'pikoworks_core') => 'left',
				esc_html__("Right", 'pikoworks_core') => 'right',
			)
		));

		vc_add_param('vc_row', array(
			"type" => "dropdown",
			"heading" => esc_html__("Fixed background position", 'pikoworks_core'),
			"param_name" => "fixed_background",
			"group" => esc_html__('Design Options', 'pikoworks_core'),
			"edit_field_class" => 'vc_col-sm-5 vc_column',
			"value" => array(
				esc_html__( '--- Select option ---', 'pikoworks_core' ) => '',
				esc_html__("Left center", 'pikoworks_core') => 'left',
				esc_html__("Right center", 'pikoworks_core') => 'right',
				esc_html__("Center center", 'pikoworks_core') => 'center',
			)
		));
	}
}



global $pikoworks_vc_anim_effects_in, $pikoworks_vc_anim_effects_out, $pikoworks_vc_animate_effects;
 $pikoworks_vc_anim_effects_in = array(
        esc_html__( '--- No Animation ---', 'pikoworks_core' ) => '',
        esc_html__( 'bounce', 'pikoworks_core' ) => 'bounce',
        esc_html__( 'flash', 'pikoworks_core' ) => 'flash',
        esc_html__( 'pulse', 'pikoworks_core' ) => 'pulse',
        esc_html__( 'rubberBand', 'pikoworks_core' ) => 'rubberBand',
        esc_html__( 'shake', 'pikoworks_core' ) => 'shake',
        esc_html__( 'swing', 'pikoworks_core' ) => 'swing',
        esc_html__( 'tada', 'pikoworks_core' ) => 'tada',
        esc_html__( 'wobble', 'pikoworks_core' ) => 'wobble',
        esc_html__( 'jello', 'pikoworks_core' ) => 'jello',
        esc_html__( 'bounceIn', 'pikoworks_core' ) => 'bounceIn',
        esc_html__( 'bounceInDown', 'pikoworks_core' ) => 'bounceInDown',
        esc_html__( 'bounceInLeft', 'pikoworks_core' ) => 'bounceInLeft',
        esc_html__( 'bounceInRight', 'pikoworks_core' ) => 'bounceInRight',
        esc_html__( 'bounceInUp', 'pikoworks_core' ) => 'bounceInUp',
        esc_html__( 'fadeIn', 'pikoworks_core' ) => 'fadeIn',
        esc_html__( 'fadeInDown', 'pikoworks_core' ) => 'fadeInDown',
        esc_html__( 'fadeInDownBig', 'pikoworks_core' ) => 'fadeInDownBig',
        esc_html__( 'fadeInLeft', 'pikoworks_core' ) => 'fadeInLeft',
        esc_html__( 'fadeInLeftBig', 'pikoworks_core' ) => 'fadeInLeftBig',
        esc_html__( 'fadeInRight', 'pikoworks_core' ) => 'fadeInRight',
        esc_html__( 'fadeInRightBig', 'pikoworks_core' ) => 'fadeInRightBig',
        esc_html__( 'fadeInUp', 'pikoworks_core' ) => 'fadeInUp',
        esc_html__( 'fadeInUpBig', 'pikoworks_core' ) => 'fadeInUpBig',
        esc_html__( 'flip', 'pikoworks_core' ) => 'flip',
        esc_html__( 'flipInX', 'pikoworks_core' ) => 'flipInX',
        esc_html__( 'flipInY', 'pikoworks_core' ) => 'flipInY',
        esc_html__( 'lightSpeedIn', 'pikoworks_core' ) => 'lightSpeedIn',
        esc_html__( 'rotateIn', 'pikoworks_core' ) => 'rotateIn',
        esc_html__( 'rotateInDownLeft', 'pikoworks_core' ) => 'rotateInDownLeft',
        esc_html__( 'rotateInDownRight', 'pikoworks_core' ) => 'rotateInDownRight',
        esc_html__( 'rotateInUpLeft', 'pikoworks_core' ) => 'rotateInUpLeft',
        esc_html__( 'rotateInUpRight', 'pikoworks_core' ) => 'rotateInUpRight',
        esc_html__( 'slideInUp', 'pikoworks_core' ) => 'slideInUp',
        esc_html__( 'slideInDown', 'pikoworks_core' ) => 'slideInDown',
        esc_html__( 'slideInLeft', 'pikoworks_core' ) => 'slideInLeft',
        esc_html__( 'slideInRight', 'pikoworks_core' ) => 'slideInRight',
        esc_html__( 'zoomIn', 'pikoworks_core' ) => 'zoomIn',
        esc_html__( 'zoomInDown', 'pikoworks_core' ) => 'zoomInDown',
        esc_html__( 'zoomInLeft', 'pikoworks_core' ) => 'zoomInLeft',
        esc_html__( 'zoomInRight', 'pikoworks_core' ) => 'zoomInRight',
        esc_html__( 'zoomInUp', 'pikoworks_core' ) => 'zoomInUp',
        esc_html__( 'rollIn', 'pikoworks_core' ) => 'rollIn',
    );
        $pikoworks_vc_anim_effects_out = array(
        esc_html__( '--- No Animation ---', 'pikoworks_core' ) => '',
        esc_html__( 'bounceOut', 'pikoworks_core' ) => 'bounceOut',
        esc_html__( 'bounceOutDown', 'pikoworks_core' ) => 'bounceOutDown',
        esc_html__( 'bounceOutLeft', 'pikoworks_core' ) => 'bounceOutLeft',
        esc_html__( 'bounceOutRight', 'pikoworks_core' ) => 'bounceOutRight',
        esc_html__( 'bounceOutUp', 'pikoworks_core' ) => 'bounceOutUp',
        esc_html__( 'fadeOut', 'pikoworks_core' ) => 'fadeOut',
        esc_html__( 'fadeOutDown', 'pikoworks_core' ) => 'fadeOutDown',
        esc_html__( 'fadeOutDownBig', 'pikoworks_core' ) => 'fadeOutDownBig',
        esc_html__( 'fadeOutLeft', 'pikoworks_core' ) => 'fadeOutLeft',
        esc_html__( 'fadeOutLeftBig', 'pikoworks_core' ) => 'fadeOutLeftBig',
        esc_html__( 'fadeOutRight', 'pikoworks_core' ) => 'fadeOutRight',
        esc_html__( 'fadeOutRightBig', 'pikoworks_core' ) => 'fadeOutRightBig',
        esc_html__( 'fadeOutUp', 'pikoworks_core' ) => 'fadeOutUp',
        esc_html__( 'fadeOutUpBig', 'pikoworks_core' ) => 'fadeOutUpBig',
        esc_html__( 'flipOutX', 'pikoworks_core' ) => 'flipOutX',
        esc_html__( 'flipOutY', 'pikoworks_core' ) => 'flipOutY',
        esc_html__( 'lightSpeedOut', 'pikoworks_core' ) => 'lightSpeedOut',
        esc_html__( 'rotateOut', 'pikoworks_core' ) => 'rotateOut',
        esc_html__( 'rotateOutDownLeft', 'pikoworks_core' ) => 'rotateOutDownLeft',
        esc_html__( 'rotateOutDownRight', 'pikoworks_core' ) => 'rotateOutDownRight',
        esc_html__( 'rotateOutUpLeft', 'pikoworks_core' ) => 'rotateOutUpLeft',
        esc_html__( 'rotateOutUpRight', 'pikoworks_core' ) => 'rotateOutUpRight',
        esc_html__( 'slideOutUp', 'pikoworks_core' ) => 'slideOutUp',
        esc_html__( 'slideOutDown', 'pikoworks_core' ) => 'slideOutDown',
        esc_html__( 'slideOutLeft', 'pikoworks_core' ) => 'slideOutLeft',
        esc_html__( 'slideOutRight', 'pikoworks_core' ) => 'slideOutRight',
        esc_html__( 'zoomOut', 'pikoworks_core' ) => 'zoomOut',
        esc_html__( 'zoomOutDown', 'pikoworks_core' ) => 'zoomOutDown',
        esc_html__( 'zoomOutLeft', 'pikoworks_core' ) => 'zoomOutLeft',
        esc_html__( 'zoomOutRight', 'pikoworks_core' ) => 'zoomOutRight',
        esc_html__( 'zoomOutUp', 'pikoworks_core' ) => 'zoomOutUp',
        esc_html__( 'rollOut', 'pikoworks_core' ) => 'rollOut',
        esc_html__( 'hinge', 'pikoworks_core' ) => 'hinge',
    );
    $pikoworks_vc_animate_effects = array(
        esc_html__( '--- No Animation ---', 'pikoworks_core' ) => '',
        esc_html__( 'bounce', 'pikoworks_core' ) => 'bounce',
        esc_html__( 'flash', 'pikoworks_core' ) => 'flash',
        esc_html__( 'pulse', 'pikoworks_core' ) => 'pulse',
        esc_html__( 'rubberBand', 'pikoworks_core' ) => 'rubberBand',
        esc_html__( 'shake', 'pikoworks_core' ) => 'shake',
        esc_html__( 'swing', 'pikoworks_core' ) => 'swing',
        esc_html__( 'tada', 'pikoworks_core' ) => 'tada',
        esc_html__( 'wobble', 'pikoworks_core' ) => 'wobble',
        esc_html__( 'jello', 'pikoworks_core' ) => 'jello',
        esc_html__( 'bounceIn', 'pikoworks_core' ) => 'bounceIn',
        esc_html__( 'bounceInDown', 'pikoworks_core' ) => 'bounceInDown',
        esc_html__( 'bounceInLeft', 'pikoworks_core' ) => 'bounceInLeft',
        esc_html__( 'bounceInRight', 'pikoworks_core' ) => 'bounceInRight',
        esc_html__( 'bounceInUp', 'pikoworks_core' ) => 'bounceInUp',
        esc_html__( 'bounceOut', 'pikoworks_core' ) => 'bounceOut',
        esc_html__( 'bounceOutDown', 'pikoworks_core' ) => 'bounceOutDown',
        esc_html__( 'bounceOutLeft', 'pikoworks_core' ) => 'bounceOutLeft',
        esc_html__( 'bounceOutRight', 'pikoworks_core' ) => 'bounceOutRight',
        esc_html__( 'bounceOutUp', 'pikoworks_core' ) => 'bounceOutUp',
        esc_html__( 'fadeIn', 'pikoworks_core' ) => 'fadeIn',
        esc_html__( 'fadeInDown', 'pikoworks_core' ) => 'fadeInDown',
        esc_html__( 'fadeInDownBig', 'pikoworks_core' ) => 'fadeInDownBig',
        esc_html__( 'fadeInLeft', 'pikoworks_core' ) => 'fadeInLeft',
        esc_html__( 'fadeInLeftBig', 'pikoworks_core' ) => 'fadeInLeftBig',
        esc_html__( 'fadeInRight', 'pikoworks_core' ) => 'fadeInRight',
        esc_html__( 'fadeInRightBig', 'pikoworks_core' ) => 'fadeInRightBig',
        esc_html__( 'fadeInUp', 'pikoworks_core' ) => 'fadeInUp',
        esc_html__( 'fadeInUpBig', 'pikoworks_core' ) => 'fadeInUpBig',
        esc_html__( 'fadeOut', 'pikoworks_core' ) => 'fadeOut',
        esc_html__( 'fadeOutDown', 'pikoworks_core' ) => 'fadeOutDown',
        esc_html__( 'fadeOutDownBig', 'pikoworks_core' ) => 'fadeOutDownBig',
        esc_html__( 'fadeOutLeft', 'pikoworks_core' ) => 'fadeOutLeft',
        esc_html__( 'fadeOutLeftBig', 'pikoworks_core' ) => 'fadeOutLeftBig',
        esc_html__( 'fadeOutRight', 'pikoworks_core' ) => 'fadeOutRight',
        esc_html__( 'fadeOutRightBig', 'pikoworks_core' ) => 'fadeOutRightBig',
        esc_html__( 'fadeOutUp', 'pikoworks_core' ) => 'fadeOutUp',
        esc_html__( 'fadeOutUpBig', 'pikoworks_core' ) => 'fadeOutUpBig',
        esc_html__( 'flip', 'pikoworks_core' ) => 'flip',
        esc_html__( 'flipInX', 'pikoworks_core' ) => 'flipInX',
        esc_html__( 'flipInY', 'pikoworks_core' ) => 'flipInY',
        esc_html__( 'flipOutX', 'pikoworks_core' ) => 'flipOutX',
        esc_html__( 'flipOutY', 'pikoworks_core' ) => 'flipOutY',
        esc_html__( 'lightSpeedIn', 'pikoworks_core' ) => 'lightSpeedIn',
        esc_html__( 'lightSpeedOut', 'pikoworks_core' ) => 'lightSpeedOut',
        esc_html__( 'rotateIn', 'pikoworks_core' ) => 'rotateIn',
        esc_html__( 'rotateInDownLeft', 'pikoworks_core' ) => 'rotateInDownLeft',
        esc_html__( 'rotateInDownRight', 'pikoworks_core' ) => 'rotateInDownRight',
        esc_html__( 'rotateInUpLeft', 'pikoworks_core' ) => 'rotateInUpLeft',
        esc_html__( 'rotateInUpRight', 'pikoworks_core' ) => 'rotateInUpRight',
        esc_html__( 'rotateOut', 'pikoworks_core' ) => 'rotateOut',
        esc_html__( 'rotateOutDownLeft', 'pikoworks_core' ) => 'rotateOutDownLeft',
        esc_html__( 'rotateOutDownRight', 'pikoworks_core' ) => 'rotateOutDownRight',
        esc_html__( 'rotateOutUpLeft', 'pikoworks_core' ) => 'rotateOutUpLeft',
        esc_html__( 'rotateOutUpRight', 'pikoworks_core' ) => 'rotateOutUpRight',
        esc_html__( 'slideInUp', 'pikoworks_core' ) => 'slideInUp',
        esc_html__( 'slideInDown', 'pikoworks_core' ) => 'slideInDown',
        esc_html__( 'slideInLeft', 'pikoworks_core' ) => 'slideInLeft',
        esc_html__( 'slideInRight', 'pikoworks_core' ) => 'slideInRight',
        esc_html__( 'slideOutUp', 'pikoworks_core' ) => 'slideOutUp',
        esc_html__( 'slideOutDown', 'pikoworks_core' ) => 'slideOutDown',
        esc_html__( 'slideOutLeft', 'pikoworks_core' ) => 'slideOutLeft',
        esc_html__( 'slideOutRight', 'pikoworks_core' ) => 'slideOutRight',
        esc_html__( 'zoomIn', 'pikoworks_core' ) => 'zoomIn',
        esc_html__( 'zoomInDown', 'pikoworks_core' ) => 'zoomInDown',
        esc_html__( 'zoomInLeft', 'pikoworks_core' ) => 'zoomInLeft',
        esc_html__( 'zoomInRight', 'pikoworks_core' ) => 'zoomInRight',
        esc_html__( 'zoomInUp', 'pikoworks_core' ) => 'zoomInUp',
        esc_html__( 'zoomOut', 'pikoworks_core' ) => 'zoomOut',
        esc_html__( 'zoomOutDown', 'pikoworks_core' ) => 'zoomOutDown',
        esc_html__( 'zoomOutLeft', 'pikoworks_core' ) => 'zoomOutLeft',
        esc_html__( 'zoomOutRight', 'pikoworks_core' ) => 'zoomOutRight',
        esc_html__( 'zoomOutUp', 'pikoworks_core' ) => 'zoomOutUp',
        esc_html__( 'hinge', 'pikoworks_core' ) => 'hinge',
        esc_html__( 'rollIn', 'pikoworks_core' ) => 'rollIn',
        esc_html__( 'rollOut', 'pikoworks_core' ) => 'rollOut',
    );
    
add_filter( 'vc_iconpicker-type-stroke', 'pikoworks_vc_icon_stroke' );    
function pikoworks_vc_icon_stroke( $icons ) {
	$stroke_icons = array(
		array( 'pe-7s-album' => 'Album' ),
		array( 'pe-7s-arc' => 'Arc' ),
		array( 'pe-7s-back-2' => 'Back-2' ),
		array( 'pe-7s-bandaid' => 'Bandaid' ),
		array( 'pe-7s-car' => 'Car' ),
		array( 'pe-7s-diamond' => 'Diamond' ),
		array( 'pe-7s-door-lock' => 'Door-lock' ),
		array( 'pe-7s-eyedropper' => 'Eyedropper' ),
		array( 'pe-7s-female' => 'Female' ),
		array( 'pe-7s-gym' => 'Gym' ),
		array( 'pe-7s-hammer' => 'Hammer' ),
		array( 'pe-7s-headphones' => 'Headphones' ),
		array( 'pe-7s-helm' => 'Helm' ),
		array( 'pe-7s-hourglass' => 'Hourglass' ),
		array( 'pe-7s-leaf' => 'Leaf' ),
		array( 'pe-7s-magic-wand' => 'Magic-wand' ),
		array( 'pe-7s-male' => 'Male' ),
		array( 'pe-7s-map-2' => 'Map-2' ),
		array( 'pe-7s-next-2' => 'Next-2' ),
		array( 'pe-7s-paint-bucket' => 'Paint-bucket' ),
		array( 'pe-7s-pendrive' => 'Pendrive' ),
		array( 'pe-7s-photo' => 'Photo' ),
		array( 'pe-7s-piggy' => 'Piggy' ),
		array( 'pe-7s-plugin' => 'Plugin' ),
		array( 'pe-7s-refresh-2' => 'Refresh-2' ),
		array( 'pe-7s-rocket' => 'Rocket' ),
		array( 'pe-7s-settings' => 'Settings' ),
		array( 'pe-7s-shield' => 'Shield' ),
		array( 'pe-7s-smile' => 'Smile' ),
		array( 'pe-7s-usb' => 'Usb' ),
		array( 'pe-7s-vector' => 'Vector' ),
		array( 'pe-7s-wine' => 'Wine' ),
		array( 'pe-7s-cloud-upload' => 'Cloud-upload' ),
		array( 'pe-7s-cash' => 'Cash' ),
		array( 'pe-7s-close' => 'Close' ),
		array( 'pe-7s-bluetooth' => 'Bluetooth' ),
		array( 'pe-7s-cloud-download' => 'Cloud-download' ),
		array( 'pe-7s-way' => 'Way' ),
		array( 'pe-7s-close-circle' => 'Close-circle' ),
		array( 'pe-7s-id' => 'Id' ),
		array( 'pe-7s-angle-up' => 'Angle-up' ),
		array( 'pe-7s-wristwatch' => 'Wristwatch' ),
		array( 'pe-7s-angle-up-circle' => 'Angle-up-circle' ),
		array( 'pe-7s-world' => 'World' ),
		array( 'pe-7s-angle-right' => 'Angle-right' ),
		array( 'pe-7s-volume' => 'Volume' ),
		array( 'pe-7s-angle-right-circle' => 'Angle-right-circle' ),
		array( 'pe-7s-users' => 'Users' ),
		array( 'pe-7s-angle-left' => 'Angle-left' ),
		array( 'pe-7s-user-female' => 'User-female' ),
		array( 'pe-7s-angle-left-circle' => 'Angle-left-circle' ),
		array( 'pe-7s-up-arrow' => 'Up-arrow' ),
		array( 'pe-7s-angle-down' => 'Angle-down' ),
		array( 'pe-7s-switch' => 'Switch' ),
		array( 'pe-7s-angle-down-circle' => 'Angle-down-circle' ),
		array( 'pe-7s-scissors' => 'Scissors' ),
		array( 'pe-7s-wallet' => 'Wallet' ),
		array( 'pe-7s-safe' => 'Safe' ),
		array( 'pe-7s-volume2' => 'Volume2' ),
		array( 'pe-7s-volume1' => 'Volume1' ),
		array( 'pe-7s-voicemail' => 'Voicemail' ),
		array( 'pe-7s-video' => 'Video' ),
		array( 'pe-7s-user' => 'User' ),
		array( 'pe-7s-upload' => 'Upload' ),
		array( 'pe-7s-unlock' => 'Unlock' ),
		array( 'pe-7s-umbrella' => 'Umbrella' ),
		array( 'pe-7s-trash' => 'Trash' ),
		array( 'pe-7s-tools' => 'Tools' ),
		array( 'pe-7s-timer' => 'Timer' ),
		array( 'pe-7s-ticket' => 'Ticket' ),
		array( 'pe-7s-target' => 'Target' ),
		array( 'pe-7s-sun' => 'Sun' ),
		array( 'pe-7s-study' => 'Study' ),
		array( 'pe-7s-stopwatch' => 'Stopwatch' ),
		array( 'pe-7s-star' => 'Star' ),
		array( 'pe-7s-speaker' => 'Speaker' ),
		array( 'pe-7s-signal' => 'Signal' ),
		array( 'pe-7s-shuffle' => 'Shuffle' ),
		array( 'pe-7s-shopbag' => 'Shopbag' ),
		array( 'pe-7s-share' => 'Share' ),
		array( 'pe-7s-server' => 'Server' ),
		array( 'pe-7s-search' => 'Search' ),
		array( 'pe-7s-film' => 'Film' ),
		array( 'pe-7s-science' => 'Science' ),
		array( 'pe-7s-disk' => 'Disk' ),
		array( 'pe-7s-ribbon' => 'Ribbon' ),
		array( 'pe-7s-repeat' => 'Repeat' ),
		array( 'pe-7s-refresh' => 'Refresh' ),
		array( 'pe-7s-add-user' => 'Add-user' ),
		array( 'pe-7s-refresh-cloud' => 'Refresh-cloud' ),
		array( 'pe-7s-paperclip' => 'Paperclip' ),
		array( 'pe-7s-radio' => 'Radio' ),
		array( 'pe-7s-note2' => 'Note2' ),
		array( 'pe-7s-print' => 'Print' ),
		array( 'pe-7s-network' => 'Network' ),
		array( 'pe-7s-prev' => 'Prev' ),
		array( 'pe-7s-mute' => 'Mute' ),
		array( 'pe-7s-power' => 'Power' ),
		array( 'pe-7s-medal' => 'Medal' ),
		array( 'pe-7s-portfolio' => 'Portfolio' ),
		array( 'pe-7s-like2' => 'Like2' ),
		array( 'pe-7s-plus' => 'Plus' ),
		array( 'pe-7s-left-arrow' => 'Left-arrow' ),
		array( 'pe-7s-play' => 'Play' ),
		array( 'pe-7s-key' => 'Key' ),
		array( 'pe-7s-plane' => 'Plane' ),
		array( 'pe-7s-joy' => 'Joy' ),
		array( 'pe-7s-photo-gallery' => 'Photo-gallery' ),
		array( 'pe-7s-pin' => 'Pin' ),
		array( 'pe-7s-phone' => 'Phone' ),
		array( 'pe-7s-plug' => 'Plug' ),
		array( 'pe-7s-pen' => 'Pen' ),
		array( 'pe-7s-right-arrow' => 'Right-arrow' ),
		array( 'pe-7s-paper-plane' => 'Paper-plane' ),
		array( 'pe-7s-delete-user' => 'Delete-user' ),
		array( 'pe-7s-paint' => 'Paint' ),
		array( 'pe-7s-bottom-arrow' => 'Bottom-arrow' ),
		array( 'pe-7s-notebook' => 'Notebook' ),
		array( 'pe-7s-note' => 'Note' ),
		array( 'pe-7s-next' => 'Next' ),
		array( 'pe-7s-news-paper' => 'News-paper' ),
		array( 'pe-7s-musiclist' => 'Musiclist' ),
		array( 'pe-7s-music' => 'Music' ),
		array( 'pe-7s-mouse' => 'Mouse' ),
		array( 'pe-7s-more' => 'More' ),
		array( 'pe-7s-moon' => 'Moon' ),
		array( 'pe-7s-monitor' => 'Monitor' ),
		array( 'pe-7s-micro' => 'Micro' ),
		array( 'pe-7s-menu' => 'Menu' ),
		array( 'pe-7s-map' => 'Map' ),
		array( 'pe-7s-map-marker' => 'Map-marker' ),
		array( 'pe-7s-mail' => 'Mail' ),
		array( 'pe-7s-mail-open' => 'Mail-open' ),
		array( 'pe-7s-mail-open-file' => 'Mail-open-file' ),
		array( 'pe-7s-magnet' => 'Magnet' ),
		array( 'pe-7s-loop' => 'Loop' ),
		array( 'pe-7s-look' => 'Look' ),
		array( 'pe-7s-lock' => 'Lock' ),
		array( 'pe-7s-lintern' => 'Lintern' ),
		array( 'pe-7s-link' => 'Link' ),
		array( 'pe-7s-like' => 'Like' ),
		array( 'pe-7s-light' => 'Light' ),
		array( 'pe-7s-less' => 'Less' ),
		array( 'pe-7s-keypad' => 'Keypad' ),
		array( 'pe-7s-junk' => 'Junk' ),
		array( 'pe-7s-info' => 'Info' ),
		array( 'pe-7s-home' => 'Home' ),
		array( 'pe-7s-help2' => 'Help2' ),
		array( 'pe-7s-help1' => 'Help1' ),
		array( 'pe-7s-graph3' => 'Graph3' ),
		array( 'pe-7s-graph2' => 'Graph2' ),
		array( 'pe-7s-graph1' => 'Graph1' ),
		array( 'pe-7s-graph' => 'Graph' ),
		array( 'pe-7s-global' => 'Global' ),
		array( 'pe-7s-gleam' => 'Gleam' ),
		array( 'pe-7s-glasses' => 'Glasses' ),
		array( 'pe-7s-gift' => 'Gift' ),
		array( 'pe-7s-folder' => 'Folder' ),
		array( 'pe-7s-flag' => 'Flag' ),
		array( 'pe-7s-filter' => 'Filter' ),
		array( 'pe-7s-file' => 'File' ),
		array( 'pe-7s-expand1' => 'Expand1' ),
		array( 'pe-7s-exapnd2' => 'Exapnd2' ),
		array( 'pe-7s-edit' => 'Edit' ),
		array( 'pe-7s-drop' => 'Drop' ),
		array( 'pe-7s-drawer' => 'Drawer' ),
		array( 'pe-7s-download' => 'Download' ),
		array( 'pe-7s-display2' => 'Display2' ),
		array( 'pe-7s-display1' => 'Display1' ),
		array( 'pe-7s-diskette' => 'Diskette' ),
		array( 'pe-7s-date' => 'Date' ),
		array( 'pe-7s-cup' => 'Cup' ),
		array( 'pe-7s-culture' => 'Culture' ),
		array( 'pe-7s-crop' => 'Crop' ),
		array( 'pe-7s-credit' => 'Credit' ),
		array( 'pe-7s-copy-file' => 'Copy-file' ),
		array( 'pe-7s-config' => 'Config' ),
		array( 'pe-7s-compass' => 'Compass' ),
		array( 'pe-7s-comment' => 'Comment' ),
		array( 'pe-7s-coffee' => 'Coffee' ),
		array( 'pe-7s-cloud' => 'Cloud' ),
		array( 'pe-7s-clock' => 'Clock' ),
		array( 'pe-7s-check' => 'Check' ),
		array( 'pe-7s-chat' => 'Chat' ),
		array( 'pe-7s-cart' => 'Cart' ),
		array( 'pe-7s-camera' => 'Camera' ),
		array( 'pe-7s-call' => 'Call' ),
		array( 'pe-7s-calculator' => 'Calculator' ),
		array( 'pe-7s-browser' => 'Browser' ),
		array( 'pe-7s-box2' => 'Box2' ),
		array( 'pe-7s-box1' => 'Box1' ),
		array( 'pe-7s-bookmarks' => 'Bookmarks' ),
		array( 'pe-7s-bicycle' => 'Bicycle' ),
		array( 'pe-7s-bell' => 'Bell' ),
		array( 'pe-7s-battery' => 'Battery' ),
		array( 'pe-7s-ball' => 'Ball' ),
		array( 'pe-7s-back' => 'Back' ),
		array( 'pe-7s-attention' => 'Attention' ),
		array( 'pe-7s-anchor' => 'Anchor' ),
		array( 'pe-7s-albums' => 'Albums' ),
		array( 'pe-7s-alarm' => 'Alarm' ),
		array( 'pe-7s-airplay' => 'Airplay' ),
	);

	return array_merge( $icons, $stroke_icons );
}
add_filter( 'vc_iconpicker-type-fontpiko', 'vc_iconpicker_type_fontpiko' );
function vc_iconpicker_type_fontpiko( $icons ) {    
    $fontpiko_icons = array(
        array( 'icon-backward-arrow' => 'Icon backward arrow' ),
        array( 'icon-checkmark' => 'Icon checkmark' ),
        array( 'icon-check-squre' => 'Icon check squre' ),
        array( 'icon-clip' => 'Icon clip' ),
        array( 'icon-computer' => 'Icon computer' ),
        array( 'icon-computer2' => 'Icon computer2' ),
        array( 'icon-computer-monitor' => 'Icon computer monitor' ),
        array( 'icon-computer-screen' => 'Icon computer screen' ),
        array( 'icon-cross1' => 'Icon cross1' ),
        array( 'icon-cross2' => 'Icon cross2' ),
        array( 'icon-cross3' => 'Icon cross3' ),
        array( 'icon-dj' => 'Icon dj' ),
        array( 'icon-envalop' => 'Icon envalop' ),
        array( 'icon-envalop2' => 'Icon envalop2' ),
        array( 'icon-envalop3' => 'Icon envalop3' ),
        array( 'icon-envalop4' => 'Icon envalop4' ),
        array( 'icon-food' => 'Icon food' ),
        array( 'icon-food' => 'Icon food' ),
        array( 'icon-grid-squre' => 'Icon grid squre' ),
        array( 'icon-grid' => 'Icon grid' ),
        array( 'icon-list' => 'Icon list' ),
        array( 'icon-list2' => 'Icon list2' ),
        array( 'icon-heart' => 'Icon heart' ),
        array( 'icon-kitchen-pack' => 'Icon kitchen-pack' ),
        array( 'icon-kitchen-pack2' => 'Icon kitchen-pack2' ),
        array( 'icon-kitchen-pack3' => 'Icon kitchen-pack3' ),
        array( 'icon-line3' => 'Icon line3' ),
        array( 'icon-line3-1' => 'Icon line3-1' ),
        array( 'icon-location1' => 'Icon location1' ),
        array( 'icon-location2' => 'Icon location2' ),
        array( 'icon-location3' => 'Icon location3' ),
        array( 'icon-location4' => 'Icon location4' ),
        array( 'icon-location5' => 'Icon location5' ),
        array( 'icon-logotype' => 'Icon logotype' ),
        array( 'icon-pencil' => 'Icon pencil' ),
        array( 'icon-search' => 'Icon search' ),
        array( 'icon-socket' => 'Icon socket' ),
        array( 'icon-suitcase' => 'Icon suitcase' ),
        array( 'icon-suitcase2' => 'Icon suitcase2' ),
        array( 'icon-technology' => 'Icon technology' ),
        array( 'icon-technology2' => 'Icon technology2' ),
        array( 'icon-technology3' => 'Icon technology3' ),
        array( 'icon-cell-phone' => 'Icon cell phone' ),
        array( 'icon-cell-phone2' => 'Icon cell phone2' ),
        array( 'icon-telephone' => 'Icon telephone' ),
        array( 'icon-telephone2' => 'Icon telephone2' ),
        array( 'icon-telephone3' => 'Icon telephone3' ),
        array( 'icon-telephone4' => 'Icon telephone4' ),
        array( 'icon-user' => 'Icon user' ),
        array( 'icon-user2' => 'Icon user2' ),
        array( 'icon-world' => 'Icon world' ),
        array( 'icon-word2' => 'Icon world2' ),
        array( 'icon-arrow-left' => 'Icon arrow left' ),        
        array( 'icon-arrow-right' => 'Icon arrow right' ),
        array( 'icon-arrow-left2' => 'Icon arrow left2' ),
        array( 'icon-arrow-right2' => 'Icon arrow right2' ),
        array( 'icon-angle-left' => ' icon angle left' ),
        array( 'icon-angle-right' => ' icon angle right' ),
        array( 'icon-arrow-long-left' => ' icon arrow long left' ),
        array( 'icon-arrow-long-right' => ' icon arrow long right' ),
        array( 'icon-book' => ' icon book' ),
        array( 'icon-coffee-shop' => ' icon coffee shop' ),
        array( 'icon-drayer' => ' icon drayer' ),
        array( 'icon-gift-box' => ' icon gift box' ),
        array( 'icon-gym' => ' icon gym' ),
        array( 'icon-info' => ' icon info' ),
        array( 'icon-lock' => ' icon lock' ),
        array( 'icon-lock2' => ' icon lock2' ),
        array( 'icon-lock3' => ' icon lock3' ),
        array( 'icon-memory-stick' => ' icon memory-stick' ),
        array( 'icon-postcode' => ' icon postcode' ),
        array( 'icon-settings' => ' icon settings' ),
        array( 'icon-setting2' => ' icon setting2' ),
        array( 'icon-sound' => ' icon sound' ),
        array( 'icon-sound' => ' icon sound' ),
        array( 'icon-truck' => ' icon truck' ),
        array( 'icon-camera' => ' icon camera' ),
        array( 'icon-camera2' => ' icon amera2' ),
        array( 'icon-city' => ' icon city' ),
        array( 'icon-compare' => ' icon compare' ),
        array( 'icon-dinner' => ' icon dinner' ),
        array( 'icon-dinner2' => ' icon dinner2' ),
        array( 'icon-dinner2' => ' icon dinner2' ),
        array( 'icon-eye' => ' icon eye' ),
        array( 'icon-headphone' => ' icon headphone' ),
        array( 'icon-headphone2' => ' icon headphone2' ),
        array( 'icon-microphone' => ' icon microphone' ),
        array( 'icon-iron' => ' icon iron' ),
        array( 'icon-lens' => ' icon lens' ),
        array( 'icon-printer' => ' icon printer' ),
        array( 'icon-star' => ' icon star' ),
        array( 'icon-start2' => ' icon star2' ),
        array( 'icon-t-shirt' => ' icon t-shirt' ),
        array( 'icon-wishlist' => ' icon wishlist' ),
        array( 'icon-chat' => ' icon chat' ),
        array( 'icon-clean' => ' icon clean' ),
        array( 'icon-flag' => ' icon flag' ),
        array( 'icon-lifeguard' => ' icon lifeguard' ),
        array( 'icon-music' => ' icon music' ),
        array( 'icon-quote' => ' icon quote' ),
        array( 'icon-sew' => ' icon sew' ),
        array( 'icon-tv' => ' icon tv' ),
        array( 'icon-armchair' => ' icon armchair' ),
        
    );
    
    return array_merge( $icons, $fontpiko_icons );
}


//icon configure
global $icon_type, $icon_font, $icon_fontawesome, $icon_lineacons, $icon_linecons, $icon_openiconic, $icon_typicons, $icon_entypo,
       $icon_image, $color_element, $color_element_custom, $color_element2, $color_element_custom2, $hover_effect, $hover_slide;
$icon_type = array(
        'type' => 'dropdown',
        'heading' => esc_html__('Icon library', 'pikoworks_core'),
        'value' => array(
            esc_html__('-- None -- ', 'pikoworks_core') => '',
            esc_html__('Font Awesome', 'pikoworks_core') => 'fontawesome',
            esc_html__('Lineacons', 'pikoworks_core') => 'lineacons',
            esc_html__('Linecons', 'pikoworks_core') => 'linecons',
            esc_html__('Open Iconic', 'pikoworks_core') => 'openiconic',
            esc_html__('Typicons', 'pikoworks_core') => 'typicons',
            esc_html__('Entypo', 'pikoworks_core') => 'entypo',
            esc_html__('Image', 'pikoworks_core') => 'image',
        ),
        'param_name' => 'icon_type',
        'description' => esc_html__('Select icon library.', 'pikoworks_core'),
    );    
    $icon_fontawesome = array(
        'type' => 'iconpicker',
        'heading' => esc_html__('Icon', 'pikoworks_core'),
        'param_name' => 'icon_fontawesome',
        'value' => 'fa fa-adjust', // default value to backend editor admin_label
        'settings' => array(
            'emptyIcon' => false,
            // default true, display an "EMPTY" icon?
            'iconsPerPage' => 1000,
            // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
        ),
        'dependency' => array('element' => 'icon_type', 'value' => 'fontawesome'),
        'description' => esc_html__('Select icon from library.', 'pikoworks_core'),
    );    
    $icon_lineacons = array(
        'type' => 'iconpicker',
        'param_name' => 'linea_icon',
        'heading' => esc_html__('Icon', 'pikoworks_core'),
        'settings' => array(
                'emptyIcon' => true, // default true, display an "EMPTY" icon?
                'type' => 'linea',
                'iconsPerPage' => 1000, // default 100, how many icons per/page to display
        ),
        'dependency' => array('element' => 'icon_type', 'value' => 'lineacons'),

    );
    $icon_linecons = array(
        'type' => 'iconpicker',
        'param_name' => 'line_icon',
        'heading' => esc_html__('Icon', 'pikoworks_core'),
        'settings' => array(
                'emptyIcon' => true, // default true, display an "EMPTY" icon?
                'type' => 'line',
                'iconsPerPage' => 1000, // default 100, how many icons per/page to display
        ),
        'dependency' => array('element' => 'icon_type', 'value' => 'linecons'),

    );
    $icon_openiconic = array(
        'type' => 'iconpicker',
        'heading' => esc_html__('Icon', 'pikoworks_core'),
        'param_name' => 'icon_openiconic',
        'value' => 'vc-oi vc-oi-dial', // default value to backend editor admin_label
        'settings' => array(
            'emptyIcon' => false, // default true, display an "EMPTY" icon?
            'type' => 'openiconic',
            'iconsPerPage' => 1000, // default 100, how many icons per/page to display
        ),
        'dependency' => array(
            'element' => 'icon_type',
            'value' => 'openiconic',
        ),
        'description' => esc_html__('Select icon from library.', 'pikoworks_core'),
    );
    $icon_typicons = array(
        'type' => 'iconpicker',
        'heading' => esc_html__('Icon', 'pikoworks_core'),
        'param_name' => 'icon_typicons',
        'value' => 'typcn typcn-adjust-brightness', // default value to backend editor admin_label
        'settings' => array(
            'emptyIcon' => false, // default true, display an "EMPTY" icon?
            'type' => 'typicons',
            'iconsPerPage' => 1000, // default 100, how many icons per/page to display
        ),
        'dependency' => array(
            'element' => 'icon_type',
            'value' => 'typicons',
        ),
        'description' => esc_html__('Select icon from library.', 'pikoworks_core'),
    );
    $icon_entypo = array(
        'type' => 'iconpicker',
        'heading' => esc_html__('Icon', 'pikoworks_core'),
        'param_name' => 'icon_entypo',
        'value' => 'entypo-icon entypo-icon-note', // default value to backend editor admin_label
        'settings' => array(
            'emptyIcon' => false, // default true, display an "EMPTY" icon?
            'type' => 'entypo',
            'iconsPerPage' => 1000, // default 100, how many icons per/page to display
        ),
        'dependency' => array(
            'element' => 'icon_type',
            'value' => 'entypo',
        ),
    );
    $icon_image = array(
        'type' => 'attach_image',
        'heading' => esc_html__('Upload Image Icon:', 'pikoworks_core'),
        'param_name' => 'icon_image',
        'value' => '',
        'description' => esc_html__('Upload the custom image icon.', 'pikoworks_core'),
        'dependency' => Array('element' => 'icon_type', 'value' => array('image')),
    );
    $color_element = array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Icon color', 'pikoworks_core' ),
            'param_name' => 'color',
            'value' => array_merge( getVcShared( 'colors' ), array( esc_html__( 'Custom color', 'pikoworks_core' ) => 'custom' ) ),
            'description' => esc_html__( 'Select icon color.', 'pikoworks_core' ),
            'param_holder_class' => 'vc_colored-dropdown',
    );
    $color_element_custom = array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Custom color', 'pikoworks_core' ),
            'param_name' => 'custom_color',
            'description' => esc_html__( 'Select custom icon color.', 'pikoworks_core' ),
            'dependency' => array( 'element' => 'color', 'value' => 'custom'),
    );
    $color_element2 = array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Icon color', 'pikoworks_core' ),
            'param_name' => 'color2',
            'value' => array_merge( getVcShared( 'colors' ), array( esc_html__( 'Custom color', 'pikoworks_core' ) => 'custom2' ) ),
            'description' => esc_html__( 'Select icon color.', 'pikoworks_core' ),
            'param_holder_class' => 'vc_colored-dropdown',
    );
    $color_element_custom2 = array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Custom color', 'pikoworks_core' ),
            'param_name' => 'custom_color2',
            'description' => esc_html__( 'Select custom icon color.', 'pikoworks_core' ),
            'dependency' => array( 'element' => 'color2', 'value' => 'custom2'),
    );
    $hover_effect = array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Image hover effect', 'pikoworks_core' ),
            'param_name' => 'no_hover',                    
            'value' => array(
                esc_html__('hover effect 01', 'pikoworks_core') => 'hover01',
                esc_html__('hover effect 02', 'pikoworks_core') => 'hover02',
                esc_html__('hover effect 03', 'pikoworks_core') => 'hover03',
                esc_html__('hover effect 04', 'pikoworks_core') => 'hover04',
                esc_html__('hover effect 05', 'pikoworks_core') => 'hover05',
            ),
        );