<?php
/**
 * The template created for displaying general optimization options
 *
 * @version 0.0.1
 * @since 9.0.3
 */
add_filter( 'et/customizer/add/sections', function($sections) {

    $args = array(
        'general-seo'	 => array(
            'name'        => 'general-seo',
            'title'          => esc_html__( 'SEO', 'xstore-core' ),
            'icon' => 'dashicons-megaphone',
            'priority' => 17,
            'type'		=> 'kirki-lazy',
            'dependency'    => array()
        )
    );
    return array_merge( $sections, $args );
});

add_filter( 'et/customizer/add/fields/general-seo', function ( $fields ) use ( $separators, $strings, $choices, $sep_style, $is_rtl ) {

    $args = array();

    // Array of fields
    $args = array(
        'et_seo_switcher'	=> array(
            'name'		  => 'et_seo_switcher',
            'type'        => 'toggle',
            'settings'    => 'et_seo_switcher',
            'label'       => esc_html__( 'SEO extra settings', 'xstore-core' ),
            'description' => esc_html__('It can be safely disabled if any SEO plugin is used.', 'xstore-core'),
            'section'     => 'general-seo',
            'default'     => 0,
        ),

        // et_seo_meta_description
        'et_seo_meta_description'             => array(
            'name'            => 'et_seo_meta_description',
            'type'            => 'etheme-textarea',
            'settings'        => 'et_seo_meta_description',
            'label'           => esc_html__( 'Custom meta description', 'xstore-core' ),
            'description' => sprintf(esc_html__('Leave empty to use site tagline set in %s', 'xstore-core'),
                '<a href="'.admin_url('options-general.php').'" target="_blank">'.esc_html__('General settings', 'xstore-core').'</a>'),
            'section'         => 'general-seo',
            'default'         => '',
            'active_callback' => array(
                array(
                    'setting'  => 'et_seo_switcher',
                    'operator' => '!=',
                    'value'    => '0',
                ),
            ),
        ),

        // et_seo_meta_description
        'et_seo_meta_keywords'             => array(
            'name'            => 'et_seo_meta_keywords',
            'type'            => 'etheme-textarea',
            'settings'        => 'et_seo_meta_keywords',
            'label'           => esc_html__( 'Meta keywords', 'xstore-core' ),
            'section'         => 'general-seo',
            'default'         => '',
            'active_callback' => array(
                array(
                    'setting'  => 'et_seo_switcher',
                    'operator' => '!=',
                    'value'    => '0',
                ),
            ),
        ),

        'et_seo_og-image'          => array(
            'name'        => 'et_seo_og-image',
            'type'        => 'image',
            'settings'    => 'et_seo_og-image',
            'label'       => esc_html__( 'Open Graph image', 'xstore-core' ),
            'description' => esc_html__( 'Facebook share image', 'xstore-core' ),
            'section'     => 'general-seo',
            'default'     => '',
            'choices'     => array(
                'save_as' => 'array',
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'et_seo_switcher',
                    'operator' => '!=',
                    'value'    => '0',
                ),
            ),
        ),

        'et_seo_noindex' => array(
            'name'        => 'et_seo_noindex',
            'type'        => 'toggle',
            'settings'    => 'et_seo_noindex',
            'label'       => esc_html__( 'SEO: "noindex" tag for url\'s', 'xstore-core' ),
            'description' => esc_html__( 'Enable this option if you want to use "noindex" tag for shop url\'s with parameters.', 'xstore-core' ),
            'section'     => 'general-seo',
            'default'     => 0,
            'active_callback' => array(
                array(
                    'setting'  => 'et_seo_switcher',
                    'operator' => '!=',
                    'value'    => '0',
                ),
            ),
        ),

    );

    return array_merge( $fields, $args );

});