<?php
/**
 * Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
namespace Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1;

use \ArrayAccess;
use \Amazon\ProductAdvertisingAPI\v1\ObjectSerializer;

/**
 * SearchResult Class Doc Comment
 *
 * @category Class
 * @package  Amazon\ProductAdvertisingAPI\v1
 * @author   Product Advertising API team
 */
class SearchResult implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'SearchResult';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'totalResultCount' => 'int',
        'searchURL' => 'string',
        'items' => '\Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\Item[]',
        'searchRefinements' => '\Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\SearchRefinements'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'totalResultCount' => 'int64',
        'searchURL' => null,
        'items' => null,
        'searchRefinements' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'totalResultCount' => 'TotalResultCount',
        'searchURL' => 'SearchURL',
        'items' => 'Items',
        'searchRefinements' => 'SearchRefinements'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'totalResultCount' => 'setTotalResultCount',
        'searchURL' => 'setSearchURL',
        'items' => 'setItems',
        'searchRefinements' => 'setSearchRefinements'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'totalResultCount' => 'getTotalResultCount',
        'searchURL' => 'getSearchURL',
        'items' => 'getItems',
        'searchRefinements' => 'getSearchRefinements'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['totalResultCount'] = isset($data['totalResultCount']) ? $data['totalResultCount'] : null;
        $this->container['searchURL'] = isset($data['searchURL']) ? $data['searchURL'] : null;
        $this->container['items'] = isset($data['items']) ? $data['items'] : null;
        $this->container['searchRefinements'] = isset($data['searchRefinements']) ? $data['searchRefinements'] : null;
        //var_dump('<pre>', $this->container , '</pre>'); //echo __FILE__ . ":" . __LINE__;die . PHP_EOL;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        return true;
    }


    /**
     * Gets totalResultCount
     *
     * @return int
     */
    public function getTotalResultCount()
    {
        return $this->container['totalResultCount'];
    }

    /**
     * Sets totalResultCount
     *
     * @param int $totalResultCount totalResultCount
     *
     * @return $this
     */
    public function setTotalResultCount($totalResultCount)
    {
        $this->container['totalResultCount'] = $totalResultCount;

        return $this;
    }

    /**
     * Gets searchURL
     *
     * @return string
     */
    public function getSearchURL()
    {
        return $this->container['searchURL'];
    }

    /**
     * Sets searchURL
     *
     * @param string $searchURL searchURL
     *
     * @return $this
     */
    public function setSearchURL($searchURL)
    {
        $this->container['searchURL'] = $searchURL;

        return $this;
    }

    /**
     * Gets items
     *
     * @return \Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\Item[]
     */
    public function getItems()
    {
        return $this->container['items'];
    }

    /**
     * Sets items
     *
     * @param \Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\Item[] $items items
     *
     * @return $this
     */
    public function setItems($items)
    {
        $this->container['items'] = $items;

        return $this;
    }

    /**
     * Gets searchRefinements
     *
     * @return \Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\SearchRefinements
     */
    public function getSearchRefinements()
    {
        return $this->container['searchRefinements'];
    }

    /**
     * Sets searchRefinements
     *
     * @param \Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\SearchRefinements $searchRefinements searchRefinements
     *
     * @return $this
     */
    public function setSearchRefinements($searchRefinements)
    {
        $this->container['searchRefinements'] = $searchRefinements;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


