<?php

return [

  // Shared
  // ------

  'shared-accordion'     => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>blog</title><g><path d="M14,0H2A1,1,0,0,0,1,1V7A1,1,0,0,0,2,8H14a1,1,0,0,0,1-1V1A1,1,0,0,0,14,0Z"></path><rect x="1" y="10" width="14" height="2"></rect><rect x="1" y="14" width="14" height="2"></rect></g></svg>',
  'shared-alert'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>bell</title><g><path d="M14.4,7.8C13.6,7.1,13,6.7,13,6V5c0-2.8-2.2-5-5-5S3,2.2,3,5v1c0,0.7-0.6,1.1-1.4,1.8C0.8,8.4,0,9,0,10 c0,2.8,6.1,3,8,3s8-0.2,8-3C16,9,15.2,8.4,14.4,7.8z"></path><path d="M10.9,13.9C9.8,14,8.9,14,8,14s-1.8,0-2.9-0.1C5.5,15.1,6.6,16,8,16S10.5,15.1,10.9,13.9z"></path></g></svg>',
  'shared-audio'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>sound</title><g><path d="M12.8,12.2c-0.4-0.4-0.4-1,0-1.4c1.6-1.6,1.6-4.1,0-5.7c-0.4-0.4-0.4-1,0-1.4s1-0.4,1.4,0 c2.3,2.3,2.3,6.1,0,8.5C13.9,12.6,13.2,12.6,12.8,12.2z"></path><path d="M11,1c0-0.8-0.9-1.3-1.6-0.8L3.7,4H1C0.4,4,0,4.4,0,5v6c0,0.6,0.4,1,1,1h2.7l5.7,3.8c0.7,0.4,1.6,0,1.6-0.8 V1z"></path></g></svg>',
  'shared-button'        => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>select</title><g><path d="M14.586,16l-3.793-3.793L9,15L7,7l8,2l-2.793,1.793L16,14.586L14.586,16z"></path><path d="M7,16H1c-0.552,0-1-0.448-1-1V1c0-0.552,0.448-1,1-1h14c0.552,0,1,0.448,1,1v6h-2V2H2v12h5V16z"></path></g></svg>',
  'shared-card'          => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>transform-2d</title><g><polygon points="2 16 14 13 14 3 2 0 2 16"></polygon></g></svg>',
  'shared-cart'          => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>shopping-cart</title><g><path d="M15,3H4.5L4,0.8C3.9,0.3,3.5,0,3,0H0v2h2.2L4,10.2C4.1,10.7,4.5,11,5,11h8c0.4,0,0.8-0.3,0.9-0.7l2-6 C16.1,3.8,15.8,3,15,3z"></path><circle cx="5" cy="14" r="2"></circle><circle cx="13" cy="14" r="2"></circle></g></svg>',
  'shared-comments'      => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>b-chat</title><g><path d="M15,4h-1v6c0,0.552-0.448,1-1,1H6.828L5,13h5l3,3v-3h2c0.552,0,1-0.448,1-1V5 C16,4.448,15.552,4,15,4z"></path><path d="M1,0h10c0.552,0,1,0.448,1,1v7c0,0.552-0.448,1-1,1H6l-3,3V9H1C0.448,9,0,8.552,0,8V1C0,0.448,0.448,0,1,0z"></path></g></svg>',
  'shared-content'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>tool-select</title><g><path d="M0,1V4H2V2H4V0H1A1,1,0,0,0,0,1Z"></path><path d="M15,0H12V2h2V4h2V1A1,1,0,0,0,15,0Z"></path><rect x="6" width="4" height="2"></rect><path d="M2,12H0v3a1,1,0,0,0,1,1H4V14H2Z"></path><path d="M14,14H12v2h3a1,1,0,0,0,1-1V12H14Z"></path><rect x="6" y="14" width="4" height="2"></rect><rect y="6" width="2" height="4"></rect><rect x="14" y="6" width="2" height="4"></rect></g></svg>',
  'shared-counter'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>hash-mark</title><g><path d="M2.99,15H5.01l.429-3H9.418L8.99,15h2.02l.429-3H14V10H11.725L12.3,6H15V4H12.582l.428-3H10.99l-.429,3H6.582L7.01,1H4.99L4.561,4H2V6H4.275L3.7,10H1v2H3.418ZM6.3,6h3.979L9.7,10H5.725Z"></path></g></svg>',
  'shared-cube'          => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>app</title><g><path d="M15.4,3.1l-7-3C8.1,0,7.9,0,7.6,0.1l-7,3C0.2,3.2,0,3.6,0,4v8c0,0.4,0.2,0.8,0.6,0.9l7,3C7.7,16,7.9,16,8,16 s0.3,0,0.4-0.1l7-3c0.4-0.2,0.6-0.5,0.6-0.9V4C16,3.6,15.8,3.2,15.4,3.1z M8,2.1L12.5,4L8,5.9L3.5,4L8,2.1z M2,5.5l5,2.1v5.8l-5-2.1 V5.5z M9,13.5V7.7l5-2.1v5.8L9,13.5z"></path></g></svg>',
  'shared-dropdown'      => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>copy-2</title><g><path d="M15,5H8C7.4,5,7,5.4,7,6v9c0,0.6,0.4,1,1,1h7c0.6,0,1-0.4,1-1V6C16,5.4,15.6,5,15,5z"></path><path d="M5,4c0-0.6,0.4-1,1-1h6V1c0-0.6-0.4-1-1-1H1C0.4,0,0,0.4,0,1v12c0,0.6,0.4,1,1,1h4V4z"></path></g></svg>',
  'shared-dropzone'      => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>square-add-11</title><g><polygon points="7,12 9,12 9,9 12,9 12,7 9,7 9,4 7,4 7,7 4,7 4,9 7,9 "></polygon><path d="M15,0H1C0.4,0,0,0.4,0,1v14c0,0.6,0.4,1,1,1h14c0.6,0,1-0.4,1-1V1C16,0.4,15.6,0,15,0z M14,14H2V2h12V14z"></path></g></svg>',
  'shared-feature-box'   => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>paragraph</title><g><path d="M6,0H1C0.4,0,0,0.4,0,1v5c0,0.6,0.4,1,1,1h5c0.6,0,1-0.4,1-1V1C7,0.4,6.6,0,6,0z"></path><path d="M6,9H1c-0.6,0-1,0.4-1,1v5c0,0.6,0.4,1,1,1h5c0.6,0,1-0.4,1-1v-5C7,9.4,6.6,9,6,9z"></path><rect x="9" y="1" width="7" height="2"></rect><rect x="9" y="4" width="7" height="2"></rect><rect x="9" y="10" width="7" height="2"></rect><rect x="9" y="13" width="7" height="2"></rect></g></svg>',
  'shared-filter'        => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>sort-tool</title><g><path d="M9,15H7c-0.552,0-1-0.448-1-1v0c0-0.552,0.448-1,1-1h2c0.552,0,1,0.448,1,1v0 C10,14.552,9.552,15,9,15z"></path><path d="M11,11H5c-0.552,0-1-0.448-1-1v0c0-0.552,0.448-1,1-1h6c0.552,0,1,0.448,1,1v0C12,10.552,11.552,11,11,11z"></path><path d="M13,7H3C2.448,7,2,6.552,2,6v0c0-0.552,0.448-1,1-1h10c0.552,0,1,0.448,1,1v0 C14,6.552,13.552,7,13,7z"></path><path d="M15,3H1C0.448,3,0,2.552,0,2v0c0-0.552,0.448-1,1-1h14c0.552,0,1,0.448,1,1v0C16,2.552,15.552,3,15,3z"></path></g></svg>',
  'shared-gap'           => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>backward</title><g><path d="M9,11V4H7v7H4l4,5l4-5H9z"></path><path d="M15,2H1C0.448,2,0,1.552,0,1v0c0-0.552,0.448-1,1-1l14,0c0.552,0,1,0.448,1,1v0 C16,1.552,15.552,2,15,2z"></path><path d="M5,6H1C0.448,6,0,6.448,0,7v0c0,0.552,0.448,1,1,1h4V6z"></path><path d="M15,6h-4v2h4c0.552,0,1-0.448,1-1v0C16,6.448,15.552,6,15,6z"></path></g></svg>',
  'shared-headline'      => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>edit-2</title><g><path d="M8,0H1v4h1l0.72361-1.44721C2.893,2.214,3.23926,2,3.61803,2H7v11.27924 c0,0.43043-0.27543,0.81257-0.68377,0.94868L4,15v1h4h4v-1l-2.31623-0.77208C9.27543,14.09181,9,13.70967,9,13.27924V2h3.38197 c0.37877,0,0.72504,0.214,0.89443,0.55279L14,4h1V0H8z"></path></g></svg>',
  'shared-icon'          => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>sticker</title><g><path d="M5,13.986A8.894,8.894,0,0,1,15.453,5.124,7.993,7.993,0,1,0,5.136,15.458,8.873,8.873,0,0,1,5,13.986Z"></path><path d="M14,5.987a7.977,7.977,0,0,0-7.788,9.8l9.581-9.6A7.962,7.962,0,0,0,14,5.987Z"></path></g></svg>',
  'shared-image'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>photo</title><g><path d="M15,0H1C0.4,0,0,0.4,0,1v14c0,0.6,0.4,1,1,1h14c0.6,0,1-0.4,1-1V1C16,0.4,15.6,0,15,0z M6,4c0.6,0,1,0.4,1,1 S6.6,6,6,6C5.4,6,5,5.6,5,5S5.4,4,6,4z M3,12l2-4l2,2l3-4l3,6H3z"></path></g></svg>',
  'shared-layout-parent' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>dock-top-e</title><g><path d="M15,15H1c-0.552,0-1-0.447-1-1V2c0-0.552,0.448-1,1-1h14c0.552,0,1,0.448,1,1v12C16,14.553,15.552,15,15,15z M2,13h12V3H2V13z"></path><rect x="6.5" y="0.5" transform="matrix(5.578186e-11 1 -1 5.578186e-11 13.5 -2.5)" width="3" height="10"></rect></g></svg>',
  'shared-line'          => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>divider</title><g><path d="M1,1v3c0,0.552,0.448,1,1,1h12c0.552,0,1-0.448,1-1V1c0-0.552-0.448-1-1-1H2C1.448,0,1,0.448,1,1z"></path><path d="M1,12v3c0,0.552,0.448,1,1,1h12c0.552,0,1-0.448,1-1v-3c0-0.552-0.448-1-1-1H2C1.448,11,1,11.448,1,12z"></path><path d="M15,9H1C0.448,9,0,8.552,0,8v0c0-0.552,0.448-1,1-1h14c0.552,0,1,0.448,1,1v0 C16,8.552,15.552,9,15,9z"></path></g></svg>',
  'shared-map'           => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>pin-3</title><g><path d="M8,0C4.1,0,1,3.1,1,7c0,1.9,0.7,3.7,2.1,5c0.1,0.1,4.1,3.7,4.2,3.8c0.4,0.3,1,0.3,1.3,0 c0.1-0.1,4.2-3.7,4.2-3.8c1.4-1.3,2.1-3.1,2.1-5C15,3.1,11.9,0,8,0z M8,9C6.9,9,6,8.1,6,7s0.9-2,2-2c1.1,0,2,0.9,2,2S9.1,9,8,9z"></path></g></svg>',
  'shared-marketing'     => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>notification-69</title><g><path d="M3.5,4C1.6,4,0,5.6,0,7.5S1.6,11,3.5,11h0.1l2.6,4.3c0.4,0.7,1.3,0.9,2.1,0.5c0.7-0.4,0.9-1.3,0.5-2.1 L7.1,11H9l7,4V0L9,4H3.5z"></path></g></svg>',
  'shared-modal'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>frame-effect</title><g><rect x="4" y="4" width="8" height="8"></rect><path d="M0,1V15a1,1,0,0,0,1,1H15a1,1,0,0,0,1-1V1a1,1,0,0,0-1-1H1A1,1,0,0,0,0,1ZM14,14H2V2H14Z"></path></g></svg>',
  'shared-navigation'    => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>roadmap</title><g><path d="M15.707,9.293,13,6.586V9a3,3,0,0,1-3,3H5v1a1,1,0,0,0,1,1h6a1,1,0,0,0,.707-.293l3-3A1,1,0,0,0,15.707,9.293Z"></path><path d="M10,10H4a1,1,0,0,1-.707-.293l-3-3a1,1,0,0,1,0-1.414l3-3A1,1,0,0,1,4,2h6a1,1,0,0,1,1,1V9A1,1,0,0,1,10,10Z"></path></g></svg>',
  'shared-off-canvas'    => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>size-large</title><g><rect x="7" y="1" width="9" height="14" rx="1" ry="1"></rect><rect y="9" width="4" height="2"></rect><rect y="5" width="4" height="2"></rect><rect y="1" width="4" height="2"></rect><rect y="13" width="4" height="2"></rect></g></svg>',
  'shared-pagination'    => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>split-33</title><g><polygon points="4,4 0,8 4,12 "></polygon><polygon points="12,4 16,8 12,12 "></polygon><circle cx="8" cy="8" r="2"></circle></g></svg>', // '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>enlarge-h</title><g><path d="M4.844,14.405l-4.625-5.78c-0.292-0.365-0.292-0.885,0-1.25l4.625-5.78l1.562,1.249L2.28,8l4.125,5.156 L4.844,14.405z"></path><path d="M11.156,14.405l-1.562-1.249L13.72,8L9.595,2.844l1.562-1.249l4.625,5.78 c0.292,0.365,0.292,0.885,0,1.25L11.156,14.405z"></path></g></svg>',
  'shared-products'      => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>box-2</title><g><path d="M15.4,2l-1.7-1.7C13.5,0.1,13.3,0,13,0H9l0.7,2H15.4z"></path><path d="M6.3,2L7,0H3C2.7,0,2.5,0.1,2.3,0.3L0.6,2H6.3z"></path><path d="M10,9L8,8L6,9V3H0v12c0,0.6,0.4,1,1,1h14c0.6,0,1-0.4,1-1V3h-6V9z"></path></g></svg>',
  'shared-quote'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>quote</title><g><path d="M3.02362,4.56063c-1.18508,1.48134-1.35607,2.9743-1.00787,4.0189 C3.33164,7.53456,5.16042,7.75337,6.27402,8.7937c1.12491,1.05091,1.2217,2.89822,0.50394,4.09449 c-0.60379,1.00632-1.66412,1.6126-2.84724,1.6126C1.23817,14.50079,0,12.12601,0,9.46142C0,7.73123,0.44094,6.18163,1.32283,4.8126 s2.21312-2.47349,3.9937-3.31339L5.79528,2.4315C4.72021,2.88504,3.79633,3.59475,3.02362,4.56063z M11.79213,4.56063 c-1.18507,1.48134-1.35607,2.9743-1.00787,4.0189c0.58793-0.45354,1.22625-0.68032,1.91496-0.68032 C14.51086,7.89921,16,9.10579,16,11.2c0,1.92572-1.47785,3.30079-3.30079,3.30079c-2.69254,0-3.93071-2.37478-3.93071-5.03937 c0-1.73018,0.44094-3.27979,1.32283-4.64882c0.88189-1.36903,2.21312-2.47349,3.9937-3.31339l0.47874,0.93228 C13.48871,2.88504,12.56483,3.59475,11.79213,4.56063z"></path></g></svg>',
  'shared-rating'        => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>star</title><g><path d="M15.144,5.438l-4.316-0.627L8.897,0.9c-0.338-0.683-1.456-0.683-1.794,0l-1.93,3.911L0.856,5.438 C0.039,5.557-0.292,6.565,0.302,7.145l3.124,3.044l-0.737,4.299c-0.139,0.814,0.717,1.439,1.451,1.054L8,13.513l3.861,2.03 c0.728,0.381,1.591-0.234,1.451-1.054l-0.737-4.299l3.124-3.044C16.292,6.565,15.961,5.557,15.144,5.438z"></path></g></svg>',
  'shared-raw-content'   => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>html5</title><g><path d="M14.738,0.326C14.549,0.118,14.281,0,14,0H2C1.719,0,1.451,0.118,1.262,0.326S0.979,0.811,1.004,1.09l1,11 c0.029,0.317,0.208,0.603,0.481,0.767l5,3C7.644,15.952,7.822,16,8,16s0.356-0.048,0.515-0.143l5-3 c0.273-0.164,0.452-0.449,0.481-0.767l1-11C15.021,0.811,14.928,0.533,14.738,0.326z M12,4H6v2h6v5.721l-4,1.333l-4-1.333V9h2v1.279 l2,0.667l2-0.667V8H4V2h8V4z"></path></g></svg>',
  'shared-row'           => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>grid-system</title><g><rect y="12" width="16" height="3"></rect><rect y="7" width="7" height="3"></rect><rect y="2" width="4" height="3"></rect><rect x="6" y="2" width="4" height="3"></rect><rect x="12" y="2" width="4" height="3"></rect><rect x="9" y="7" width="7" height="3"></rect></g></svg>',
  'shared-search'        => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>zoom-split</title><g><path d="M7,14c-3.86,0-7-3.14-7-7s3.14-7,7-7s7,3.14,7,7S10.86,14,7,14z M7,2C4.243,2,2,4.243,2,7s2.243,5,5,5 s5-2.243,5-5S9.757,2,7,2z"></path><path d="M15.707,14.293L13.314,11.9c-0.411,0.529-0.885,1.003-1.414,1.414l2.393,2.393 C14.488,15.902,14.744,16,15,16s0.512-0.098,0.707-0.293C16.098,15.316,16.098,14.684,15.707,14.293z"></path></g></svg>',
  'shared-social'        => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>logo-facebook</title><g><path d="M16,8.048a8,8,0,1,0-9.25,7.9V10.36H4.719V8.048H6.75V6.285A2.822,2.822,0,0,1,9.771,3.173a12.2,12.2,0,0,1,1.791.156V5.3H10.554a1.155,1.155,0,0,0-1.3,1.25v1.5h2.219l-.355,2.312H9.25v5.591A8,8,0,0,0,16,8.048Z"></path></g></svg>',
  'shared-slider'        => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>slider</title><g><path d="M15,10H1c-0.552,0-1-0.448-1-1V1c0-0.552,0.448-1,1-1h14c0.552,0,1,0.448,1,1v8C16,9.552,15.552,10,15,10z"></path><circle cx="8" cy="14" r="2"></circle><circle cx="3" cy="14" r="1"></circle><circle cx="13" cy="14" r="1"></circle></g></svg>',
  'shared-statbar'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>progress-indicator</title><g><path d="M15,13H1a1,1,0,0,1-1-1V8A1,1,0,0,1,1,7H15a1,1,0,0,1,1,1v4A1,1,0,0,1,15,13ZM8,11h6V9H8Z"></path><polygon points="8 5 11 1 5 1 8 5"></polygon></g></svg>',
  'shared-tabs'          => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>open-in-browser</title><g><polygon points="8,7 4,11 7,11 7,16 9,16 9,11 12,11 "></polygon><path d="M0,1v12c0,0.552,0.448,1,1,1h4v-2H2V6h12v6h-3v2h4c0.552,0,1-0.448,1-1V1c0-0.552-0.448-1-1-1H1 C0.448,0,0,0.448,0,1z M2,4V2h12v2H2z"></path></g></svg>',
  'shared-text'          => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>cursor-text</title><g><path d="M9,4c0-1.103,0.897-2,2-2h1V0h-1C9.8,0,8.734,0.542,8,1.382C7.266,0.542,6.2,0,5,0H4v2h1 c1.103,0,2,0.897,2,2v1v4H4v2h3v1c0,1.103-0.897,2-2,2H4v2h1c1.2,0,2.266-0.542,3-1.382C8.734,15.458,9.8,16,11,16h1v-2h-1 c-1.103,0-2-0.897-2-2v-1h3V9H9V5V4z"></path></g></svg>',
  'shared-video'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>video-playlist</title><g><path d="M15,4H1A.945.945,0,0,0,0,5V15a.945.945,0,0,0,1,1H15a.945.945,0,0,0,1-1V5A.945.945,0,0,0,15,4ZM6,13V7l5,3Z"></path><path d="M3,0H13a1,1,0,0,1,1,1V2a0,0,0,0,1,0,0H2A0,0,0,0,1,2,2V1A1,1,0,0,1,3,0Z"></path></g></svg>',
  'shared-widget-area'   => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>dock-right-e</title><g><path d="M0 14V2a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H1a1 1 0 0 1-1-1zM14 3H2v10h12V3z"></path><path d="M13 12h-3V4h3z"></path></g></svg>',


  // Default
  // -------

  'default' => 'alias:shared-cube',


  // Standard
  // --------

  'accordion'               => 'alias:shared-accordion',
  'accordion-item'          => 'alias:shared-accordion',
  'alert'                   => 'alias:shared-alert',
  'audio'                   => 'alias:shared-audio',
  'breadcrumbs'             => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>steps</title><g><path d="M2,11h4c0-2.9,0.8-3.4,0.8-5.2C6.8,3.5,5.5,2,3.9,2h0C2.3,2,1,3.5,1,5.8S2,11,2,11z"></path><path d="M4.2,15.6L4.2,15.6c1.7,0,2.3-1.5,1.8-3.6H2l-0.2,0.8C1.5,14.3,2.7,15.6,4.2,15.6z"></path><path d="M14,9h-4c0-2.9-0.8-3.4-0.8-5.2c0-2.3,1.3-3.8,2.9-3.8h0C13.7,0,15,1.5,15,3.8S14,9,14,9z"></path><path d="M11.8,13.6L11.8,13.6c-1.7,0-2.3-1.5-1.8-3.6h4l0.2,0.8C14.5,12.3,13.3,13.6,11.8,13.6z"></path></g></svg>',
  'button'                  => 'alias:shared-button',
  'creative-cta'            => 'alias:shared-button',
  'card'                    => 'alias:shared-card',
  'content-area'            => 'alias:shared-content',
  'content-area-dropdown'   => 'alias:shared-content',
  'content-area-modal'      => 'alias:shared-content',
  'content-area-off-canvas' => 'alias:shared-content',
  'countdown'               => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>countdown-2</title><g><path d="M9.4,6.6c0.8,0.8,0.8,2,0,2.8c-0.8,0.8-2,0.8-2.8,0C5.8,8.6,1.6,1.6,1.6,1.6S8.6,5.8,9.4,6.6 z"></path><path d="M8,16c-4.4,0-8-3.6-8-8c0-0.6,0.4-1,1-1s1,0.4,1,1c0,3.3,2.7,6,6,6s6-2.7,6-6s-2.7-6-6-6C7.4,2,7,1.6,7,1 s0.4-1,1-1c4.4,0,8,3.6,8,8S12.4,16,8,16z"></path></g></svg>',
  'counter'                 => 'alias:shared-counter',
  'form-integration'        => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>text-2</title><g><path d="M15,16H1c-0.553,0-1-0.447-1-1V1c0-0.552,0.447-1,1-1h14c0.553,0,1,0.448,1,1v14C16,15.553,15.553,16,15,16z M2,14h12V2H2V14z"></path><path d="M10,5h1V3h-1C9.229,3,8.532,3.301,8,3.78C7.468,3.301,6.771,3,6,3H5v2h1c0.551,0,1,0.449,1,1 v2H5v2h2c0,0.551-0.449,1-1,1H5v2h1c0.771,0,1.468-0.301,2-0.78C8.532,12.699,9.229,13,10,13h1v-2h-1c-0.551,0-1-0.449-1-1h2V8H9V6 C9,5.449,9.449,5,10,5z"></path></g></svg>',
  'gap'                     => 'alias:shared-gap',
  'global-block'            => 'alias:shared-cube',
  'headline'                => 'alias:shared-headline',
  'icon'                    => 'alias:shared-icon',
  'image'                   => 'alias:shared-image',
  'line'                    => 'alias:shared-line',
  'map'                     => 'alias:shared-map',
  'nav-collapsed'           => 'alias:shared-navigation',
  'nav-dropdown'            => 'alias:shared-navigation',
  'nav-inline'              => 'alias:shared-navigation',
  'nav-layered'             => 'alias:shared-navigation',
  'nav-modal'               => 'alias:shared-navigation',
  'quote'                   => 'alias:shared-quote',
  'rating'                  => 'alias:shared-rating',
  'raw-content'             => 'alias:shared-raw-content',
  'search-dropdown'         => 'alias:shared-search',
  'search-inline'           => 'alias:shared-search',
  'search-modal'            => 'alias:shared-search',
  'social'                  => 'alias:shared-social',
  'statbar'                 => 'alias:shared-statbar',
  'tabs'                    => 'alias:shared-tabs',
  'testimonial'             => 'alias:shared-quote',
  'text'                    => 'alias:shared-text',
  'video'                   => 'alias:shared-video',
  'widget-area'             => 'alias:shared-widget-area',


  // Layout
  // ------

  'section'                => 'alias:shared-layout-parent',
  'layout-div'             => 'alias:shared-dropzone',
  'layout-grid'            => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>components</title><g><rect width="4" height="16" rx="1" ry="1"></rect><rect x="6" width="10" height="4" rx="1" ry="1"></rect><rect x="6" y="6" width="4" height="4" rx="1" ry="1"></rect><rect x="6" y="12" width="4" height="4" rx="1" ry="1"></rect><rect x="12" y="6" width="4" height="10" rx="1" ry="1"></rect></g></svg>',
  'layout-cell'            => 'alias:shared-dropzone',
  'layout-row'             => 'alias:shared-row',
  'layout-column'          => 'alias:shared-dropzone',
  'layout-dropdown'        => 'alias:shared-dropdown',
  'layout-modal'           => 'alias:shared-modal',
  'layout-off-canvas'      => 'alias:shared-off-canvas',
  'bar'                    => 'alias:shared-layout-parent',
  'container'              => 'alias:shared-dropzone',
  'row'                    => 'alias:shared-row',
  'column'                 => 'alias:shared-dropzone',


  // Dynamic
  // -------

  'the-content'        => 'alias:shared-cube',
  'comment-form'       => 'alias:shared-comments',
  'comment-list'       => 'alias:shared-comments',
  'comment-pagination' => 'alias:shared-pagination',
  'post-nav'           => 'alias:shared-pagination',
  'post-pagination'    => 'alias:shared-pagination',


  // Sliders
  // -------

  // 'layout-slide-container' => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"><title>fullsize</title><g><rect x="4" y="4" width="8" height="8"></rect><rect width="2" height="16"></rect><rect x="14" width="2" height="16"></rect></g></svg>',
  'layout-slide-container' => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"><title>calendar-day-view</title><g><rect y="1" width="16" height="2"></rect><rect y="13" width="16" height="2"></rect><path d="M16,11H0V5H16Z"></path></g></svg>',
  'layout-slide'           => 'alias:layout-slide-container',
  'slide-pagination'       => 'alias:shared-pagination',
  'slide-navigation'       => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"><title>circle-arrow-right</title><g><path d="M8,0C3.6,0,0,3.6,0,8s3.6,8,8,8s8-3.6,8-8S12.4,0,8,0z M8,12V9H4V7h4V4l4,4L8,12z"></path></g></svg>',
  'slider-inline'          => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"><title>based-on-floors</title><g><path d="M1,16h2c0.6,0,1-0.4,1-1V1c0-0.6-0.4-1-1-1H1C0.4,0,0,0.4,0,1v14C0,15.6,0.4,16,1,16z"/><path d="M7,16h2c0.6,0,1-0.4,1-1V1c0-0.6-0.4-1-1-1H7C6.4,0,6,0.4,6,1v14C6,15.6,6.4,16,7,16z"/><path d="M13,16h2c0.6,0,1-0.4,1-1V1c0-0.6-0.4-1-1-1h-2c-0.6,0-1,0.4-1,1v14C12,15.6,12.4,16,13,16z"/></g></svg>',
  'slider-stacked'         => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"><title>file-copies</title><g><path d="M7,8H1C0.4,8,0,8.4,0,9v6c0,0.6,0.4,1,1,1h6c0.6,0,1-0.4,1-1V9C8,8.4,7.6,8,7,8z"></path><path d="M11,4H2v2h8v8h2V5C12,4.4,11.6,4,11,4z"></path><path d="M15,0H6v2h8v8h2V1C16,0.4,15.6,0,15,0z"></path></g></svg>',


  // WooCommerce
  // -----------

  'tp-wc-add-to-cart-form'   => 'alias:shared-cart',
  'tp-wc-cart'               => 'alias:shared-cart',
  'tp-wc-cart-dropdown'      => 'alias:shared-cart',
  'tp-wc-cart-inline'        => 'alias:shared-cart',
  'tp-wc-cart-modal'         => 'alias:shared-cart',
  'tp-wc-cart-off-canvas'    => 'alias:shared-cart',
  'tp-wc-product-pagination' => 'alias:shared-pagination',
  'tp-wc-products'           => 'alias:shared-products',
  'tp-wc-cross-sells'        => 'alias:shared-products',
  'tp-wc-related-products'   => 'alias:shared-products',
  'tp-wc-upsells'            => 'alias:shared-products',
  'tp-wc-product-gallery'    => 'alias:shared-slider',
  'tp-wc-shop-sort'          => 'alias:shared-filter',
  'tp-wc-shop-notices'       => 'alias:shared-alert',
  'tp-wc-product-rating'     => 'alias:shared-rating',


  // Classic
  // -------

  'classic:accordion'         => 'alias:shared-accordion',
  'classic:alert'             => 'alias:shared-alert',
  'classic:self-hosted-audio' => 'alias:shared-audio',
  'classic:author'            => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>face-man</title><g><circle cx="5" cy="9" r="1"></circle><circle cx="11" cy="9" r="1"></circle><path d="M8,0C3.589,0,0,3.589,0,8s3.589,8,8,8s8-3.589,8-8S12.411,0,8,0z M8,14c-3.309,0-6-2.691-6-6 c0-0.563,0.083-1.105,0.229-1.622c2.092-0.878,5.097,0.717,8.317-2.196c1.131,1.79,2.471,2.571,3.379,2.914 C13.969,7.391,14,7.692,14,8C14,11.309,11.309,14,8,14z"></path></g></svg>',
  'classic:block-grid'        => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>selection</title><g><rect y="6.016" width="4" height="4"></rect><rect y="12" width="4" height="4"></rect><rect x="6" width="4" height="4"></rect><rect width="4" height="4"></rect><rect x="12" width="4" height="4"></rect><rect x="6" y="6.016" width="4" height="4"></rect><rect x="13" y="7" width="2" height="2"></rect><rect x="13" y="13" width="2" height="2"></rect><rect x="7" y="13" width="2" height="2"></rect></g></svg>',
  'classic:blockquote'        => 'alias:shared-quote',
  'classic:button'            => 'alias:shared-button',
  'classic:callout'           => 'alias:shared-marketing',
  'classic:card'              => 'alias:shared-card',
  'classic:code'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>code</title><g><path d="M12.7,11.7l-1.4-1.4L13.6,8l-2.3-2.3l1.4-1.4l3,3c0.4,0.4,0.4,1,0,1.4L12.7,11.7z"></path><path d="M3.3,11.7l-3-3c-0.4-0.4-0.4-1,0-1.4l3-3l1.4,1.4L2.4,8l2.3,2.3L3.3,11.7z"></path><path d="M6,15c-0.1,0-0.2,0-0.3-0.1c-0.5-0.2-0.8-0.7-0.6-1.3l4-12c0.2-0.5,0.7-0.8,1.3-0.6 c0.5,0.2,0.8,0.7,0.6,1.3l-4,12C6.8,14.7,6.4,15,6,15z"></path></g></svg>',
  'classic:columnize'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>data-table</title><g><rect y="10" width="7" height="2"></rect><rect x="9" y="10" width="7" height="2"></rect><rect y="14" width="7" height="2"></rect><rect x="9" y="14" width="7" height="2"></rect><path d="M0,0V8H16V0ZM7,6H2V2H7Zm7,0H9V2h5Z"></path></g></svg>',
  'classic:counter'           => 'alias:shared-counter',
  'classic:creative-cta'      => 'alias:shared-button',
  'classic:custom-headline'   => 'alias:shared-headline',
  'classic:embedded-audio'    => 'alias:shared-audio',
  'classic:embedded-video'    => 'alias:shared-video',
  'classic:feature-box'       => 'alias:shared-feature-box',
  'classic:feature-headline'  => 'alias:shared-feature-box',
  'classic:feature-list'      => 'alias:shared-feature-box',
  'classic:gap'               => 'alias:shared-gap',
  'classic:google-map'        => 'alias:shared-map',
  'classic:icon'              => 'alias:shared-icon',
  'classic:icon-list'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>bullet-list-67</title><g><circle cx="2" cy="2" r="2"></circle><rect x="6" y="1" width="10" height="2"></rect><circle cx="2" cy="8" r="2"></circle><rect x="6" y="7" width="10" height="2"></rect><circle cx="2" cy="14" r="2"></circle><rect x="6" y="13" width="10" height="2"></rect></g></svg>',
  'classic:image'             => 'alias:shared-image',
  'classic:line'              => 'alias:shared-line',
  'classic:map-embed'         => 'alias:shared-map',
  'classic:pricing-table'     => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>money-12</title><g><path d="M15,4H1C0.4,4,0,4.4,0,5v10c0,0.6,0.4,1,1,1h14c0.6,0,1-0.4,1-1V5C16,4.4,15.6,4,15,4z M11.1,14H4.9 c-0.4-1.4-1.5-2.5-2.9-2.9V8.9C3.4,8.5,4.5,7.4,4.9,6h6.3c0.4,1.4,1.5,2.5,2.9,2.9v2.3C12.6,11.5,11.5,12.6,11.1,14z"></path><circle cx="8" cy="10" r="2"></circle><rect x="2" width="12" height="2"></rect></g></svg>',
  'classic:promo'             => 'alias:shared-marketing',
  'classic:prompt'            => 'alias:shared-marketing',
  'classic:protect'           => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>lock</title><g><path d="M8,0C5.8,0,4,1.8,4,4v1H2C1.4,5,1,5.4,1,6v9c0,0.6,0.4,1,1,1h12c0.6,0,1-0.4,1-1V6c0-0.6-0.4-1-1-1h-2V4 C12,1.8,10.2,0,8,0z M9,11.7V13H7v-1.3c-0.6-0.3-1-1-1-1.7c0-1.1,0.9-2,2-2s2,0.9,2,2C10,10.7,9.6,11.4,9,11.7z M10,5H6V4 c0-1.1,0.9-2,2-2s2,0.9,2,2V5z"></path></g></svg>',
  'classic:raw-content'       => 'alias:shared-raw-content',
  'classic:recent-posts'      => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><title>n-edit</title><g><path d="M14.1,0.3c-0.4-0.4-1-0.4-1.4,0L6,7v3h3l6.7-6.7c0.4-0.4,0.4-1,0-1.4L14.1,0.3z"></path><path d="M15,9c-0.6,0-1,0.4-1,1v4H2V2h4c0.6,0,1-0.4,1-1S6.6,0,6,0H1C0.4,0,0,0.4,0,1v14c0,0.6,0.4,1,1,1h14 c0.6,0,1-0.4,1-1v-5C16,9.4,15.6,9,15,9z"></path></g></svg>',
  'classic:search'            => 'alias:shared-search',
  'classic:skill-bar'         => 'alias:shared-statbar',
  'classic:slider'            => 'alias:shared-slider',
  'classic:social-sharing'    => 'alias:shared-social',
  'classic:tabs'              => 'alias:shared-tabs',
  'classic:text'              => 'alias:shared-text',
  'classic:text-type'         => 'alias:shared-text',
  'classic:self-hosted-video' => 'alias:shared-video',
  'classic:widget-area'       => 'alias:shared-widget-area',
  'classic:section'           => 'alias:shared-layout-parent',
  'classic:row'               => 'alias:shared-row',
  'classic:column'            => 'alias:shared-dropzone',

];
