<?php
/**
 * AJDE wp-admin all the other required parts for wp-admin
 *
 * @version 2.6.13
 */

if(class_exists('ajde_wp_admin')) return;

class ajde_wp_admin{
	public $content = '';
	public function __construct(){}
	
	// lightbox content box
		function lightbox_content($arg){
			$defaults = array(
				'content'=>'',
				'class'=>'regular',
				'attr'=>'',
				'title'=>'',
				'subtitle'=>'',
				'type'=>'normal',
				'hidden_content'=>'',
				'width'=>'',
				'outside_click'=>true,
				'preloading'=>false, // preloading will replace content with loading text
			);
			$args = (!empty($arg) && is_array($arg) && count($arg)>0) ? 
				array_merge($defaults, $arg) : $defaults;

			$ajdeCLASSES = array();

			// ajde_popup classes
				if(!empty($args['type']) && $args['type']=='padded')	$ajdeCLASSES[] = 'padd';
				if(!$args['outside_click']) $ajdeCLASSES[] = 'nooutside';
				
				$ajdeCLASSES[] = $args['class'];				

				$ajdeCLASSES = implode(' ', $ajdeCLASSES);

			//print_r($args);
			$content='';
			$content .= 
				"<div id='ajde_popup_outter' class='ajde_admin_lightbox {$ajdeCLASSES}'>
				<div class='evo_content_in'>
				<div class='evo_content_inin'>
				<div class='ajde_popup {$ajdeCLASSES}' {$args['attr']} style='". ( (!empty($args['width']))? 'width:'.$args['width'].'px;':null )."'>	
					<div class='ajde_header'>
						<a class='ajde_backbtn' style='display:none'><i class='fa fa-angle-left'></i></a>
						<p id='ajde_title' class='ajde_lightbox_title'>{$args['title']}</p>
						". ( (!empty($args['subtitle']))? "<p id='ajde_subtitle'>{$args['subtitle']}</p>":null) ."
						<a class='ajde_close_pop_btn'>X</a>
					</div>							
					<div id='ajde_loading'></div>";
				// preloading
					$innner = ($args['preloading'])? '<p class="loading">Loading</p>':$args['content'];

				$content .= (!empty($args['max_height']))? "<div class='ajde_lightbox_outter maxbox' >":null;
				$content .= "<div class='ajde_popup_text'>{$innner}</div>";
				$content .= (!empty($args['max_height']))? "</div>":null;
				$content .= "<p class='message'></p>
					
				</div>
				</div>
				</div>
				</div>";
			
			$this->content .= $content;
			add_action('admin_footer', array($this, 'actual_output_popup'));
		}
		function actual_output_popup($content){
			echo "<div class='ajde_admin_lightboxes'>";		
			echo $this->content;
			echo "</div>";
		}

	// YES NO Button
		function html_yesnobtn($args=''){

			$defaults = array(
				'id'=>'',
				'var'=>'',
				'no'=>'',
				'default'=>'',
				'input'=>false,
				'inputAttr'=>'',
				'label'=>'',
				'guide'=>'',
				'guide_position'=>'',
				'abs'=>'no',// absolute positioning of the button
				'attr'=>'', // array
				'afterstatement'=>'',
				'nesting'=>false
			);
			
			$args = shortcode_atts($defaults, $args);

			$_attr = $no = '';

			if(!empty($args['var'])){
				$no = ($args['var']	=='yes')? 
					 null: 
					 ( (!empty($args['default']) && $args['default']=='yes')? null:'NO');
			}else{
				$no = (!empty($args['default']) && $args['default']=='yes')? null:'NO';
			}

			if(!empty($args['attr'])){
				foreach($args['attr'] as $at=>$av){
					$_attr .= $at.'="'.$av.'" ';
				}
			}

			// afterstatement
				if(!empty($args['afterstatement'])){
					$_attr .= 'afterstatement="' . $args['afterstatement'] .'"';
				}
				
			// input field
			$input = '';
			if($args['input']){
				$input_value = (!empty($args['var']))? 
					$args['var']: (!empty($args['default'])? $args['default']:'no');

				// Attribut values for input field
				$inputAttr = '';
				if(!empty($args['inputAttr'])){
					foreach($args['inputAttr'] as $at=>$av){
						$inputAttr .= $at.'="'.$av.'" ';
					}
				}

				// input field
				$input = "<input {$inputAttr} type='hidden' name='{$args['id']}' value='{$input_value}'/>";
			}

			$guide = '';
			if(!empty($args['guide'])){
				$guide = $this->tooltips($args['guide'], $args['guide_position']);
			}

			$label = '';
			if(!empty($args['label']))
				$label = "<label class='ajde_yn_btn_label' for='{$args['id']}'>{$args['label']}{$guide}</label>";

			// nesting
				$nesting_start = $nesting_end = '';
				if($args['nesting']){
					$nesting_start = "<p class='yesno_row'>";
					$nesting_end = "</p>";
				}

			return $nesting_start.'<span id="'.$args['id'].'" class="ajde_yn_btn '.($no? 'NO':null).''.(($args['abs']=='yes')? ' absolute':null).'" '.$_attr.'><span class="btn_inner" style=""><span class="catchHandle"></span></span></span>'.$input.$label.$nesting_end;
		}
	
	// tool tips
		function tooltips($content, $position='', $echo = false){
			// tool tip position
				if(!empty($position)){
					$L = ' L';
					
					if($position=='UL')
						$L = ' UL';
					if($position=='U')
						$L = ' U';
				}else{
					$L = null;
				}

			$output = "<span class='ajdeToolTip{$L} fa'><em>{$content}</em></span>";

			if(!$echo)
				return $output;			
			
			echo $output;
		}
		function echo_tooltips($content, $position=''){
			$this->tooltips($content, $position,true);
		}

	// icon selector
		function icons(){
			include_once('fa_fonts.php');
			ob_start();?>			
			<div class='ajde_fa_icons_selector'>
				<div class="fai_in">
					<ul class="faicon_ul">
					<?php
					// $font_ passed from incldued font awesome file above
					if(!empty($font_)){
						foreach($font_ as $fa){
							echo "<li><i data-name='".$fa."' class='fa ".$fa."' title='{$fa}'></i></li>";
						}
					}
					?>						
					</ul>
				</div>
			</div>
			<?php return ob_get_clean();
		}
		function get_font_icons_data(){
			include_once('fa_fonts.php');
			return $font_;
		}

	// Options panel for custom posts
		function options_panel($fields, $PMV){

			global $ajde;
			$ajde->load_colorpicker();

			ob_start();

			echo "<div class='ajde_options_panel'>";
			foreach($fields as $field){
				$VAL = (!empty($field['id']) && !empty($PMV[$field['id']]))? $PMV[$field['id']][0]:false;
				$DEFAULT = (!empty($field['default']) && !empty($PMV[$field['default']]))? $PMV[$field['default']][0]:false;
				$TOOLTIP = !empty($field['tooltip'])? $this->tooltips($field['tooltip']):false;

				switch ($field['type']) {
					case 'note':
						echo "<p>{$field['content']}</p>";
					break;	
					case 'text':
						$DEF = !empty($field['default'])? $field['default']:'';
						echo "<p><label>{$field['label']}{$TOOLTIP}</label><input name='{$field['id']}' value='{$VAL}' placeholder='{$DEF}'/></p>";
					break;	
					case 'textarea':
						$content = $VAL? stripcslashes($VAL): 
							( !empty($field['default'])? $field['default']:'');
						echo "<p><label>{$field['label']}{$TOOLTIP}</label><textarea name='{$field['id']}'>{$content}</textarea></p>";
					break;
					case 'image':
						$image = ''; 
						
						echo "<p><label>{$field['label']}{$TOOLTIP}</label></p>";
						$preview_img_size = (empty($field['preview_img_size']))?'medium': $field['preview_img_size'];
						echo '<span class="custom_default_image" style="display:none">'.$image.'</span>';  
						if ($VAL) { $image = wp_get_attachment_image_src($VAL, $preview_img_size); $image = $image[0]; } 
						
						$img_code = (empty($image))? "<p class='custom_no_preview_img'><i>No Image Selected</i></p><img src='' style='display:none' class='custom_preview_image' />"
							: '<p class="custom_no_preview_img" style="display:none"><i>No Image Selected</i></p><img src="'.$image.'" class="custom_preview_image" alt="" />';
						
						echo '<input name="'.$field['id'].'" type="hidden" class="custom_upload_image" value="'.$VAL.'" /> 
							'.$img_code.'<br /> 
		                    <input class="custom_upload_image_button button" type="button" value="Choose Image" /> 
		                    <small> <a href="#" class="custom_clear_image_button">Remove Image</a></small> 
		                    <br clear="all" />';
					break;
					case 'color':
						$DEF = (!empty($field['default'])? $field['default']:'3d3d3d');
						$color = $VAL? $VAL: $DEF;
						echo "<p class='row_color'><label>{$field['label']}{$TOOLTIP}</label><em>
							<span id='{$field['id']}' class='colorselector' style='background-color:#{$color}' hex='{$color}'></span>
							<input type='hidden' name='{$field['id']}' data-default='{$DEF}'/>
						</em></p>";
					break;
					case 'wysiwyg':
						echo "<p><label>{$field['label']}{$TOOLTIP}</label></p>";
						$content = $VAL? stripcslashes($VAL): 
							( !empty($field['default'])? $field['default']:'');
						wp_editor($content, $field['id']);
					
					break;
					case 'select':
						if(empty($field['options'])) break;
						echo "<p><label>{$field['label']}</label> <select name='{$field['id']}'>";
						foreach($field['options'] as $sfield=>$sval){							
							echo "<option value='{$sfield}' ".($VAL==$sfield?'selected="selected"':'').">{$sval}</option>";
						}
						echo "</select>{$TOOLTIP}</p>";
					break;
					case 'yesno':
						echo "<p id='ajde_field_{$field['id']}'>".$this->html_yesnobtn(array('label'=>$field['label'],'input'=>true, 'default'=>$DEFAULT,
							'abs'=>'yes',
							'attr'=> (!empty($field['attr'])? $field['attr']:''),
							'var'=>$VAL,
							'id'=>$field['id'], 
							))."{$TOOLTIP}</p>";
					break;
					case 'beginafterstatement':	
						$yesno_val = (!empty($PMV[$field['val']]))? $PMV[$field['val']][0]:'no';
						echo "<div id='{$field['id']}' class='ajde_options_inner' style='display:".(($yesno_val=='yes')?'block':'none')."'>";
					break;
					case 'endafterstatement':
						echo "</div>";
					break;
					// for show if select
					case 'beginShowIf':
						$showIf = (!empty($PMV[$field['varname']]))? $PMV[$field['varname']][0]:false;
						$classes = implode(' ', $field['values']);

						echo "<div class='ajdeShowIf {$classes} {$field['varname']}' class='ajde_options_inner' style='display:".(($showIf && in_array($showIf, $field['values']))?'block':'none')."'>";
					break;
					case 'endShowIf':
						echo "</div>";
					break;
				}
			}
			echo "</div>";
			echo "<div id='ajde_clr_picker' class='cp cp-default' style='display:none; position:absolute; z-index:99;'></div>";

			return ob_get_clean();
			

		}

	// SHORTCODE GENERATOR
	// @version 1.0
	// shortcode generator interpret fields
		private $_in_select_step=false;
		public function shortcodeInterpret($var){
			global $ajde;

			// initial values
				$line_class = array('fieldline');
				$textDomain = $ajde->domain;

			ob_start();		
			
			// GUIDE popup
			$guide = (!empty($var['guide']))? $ajde->wp_admin->tooltips($var['guide'], 'L',false):null;

			// afterstatemnt class
			if(!empty($var['afterstatement'])){	$line_class[]='trig_afterst'; }

			// select step class
			if($this->_in_select_step){ $line_class[]='ss_in'; }


			if(!empty($var['type'])):

			switch($var['type']){
				// custom type and its html pluggability
				case has_action("ajde_shortcode_box_interpret_{$var['type']}"):
					do_action("ajde_shortcode_box_interpret_{$var['type']}", $var, $guide);
				break;
				case 'YN':
					$line_class[]='ajdeYN_row';

					echo "<div class='".implode(' ', $line_class)."'>";
					echo $ajde->wp_admin->html_yesnobtn(array(
						'var'=>$var['var'],
						'default'=>( ($var['default']=='no')? 'NO':null ),
						'guide'=>(!empty($var['guide'])? $var['guide']:''), 
						'guide_position'=>(!empty($var['guide_position'])? $var['guide_position']:'L'),
						'label'=>$var['name'],
						'abs'=>'yes',
						'attr'=>array('codevar'=>$var['var'])
						));
					echo "</div>";					
				break;

				case 'customcode':	echo !empty($var['value'])? $var['value']:'';	break;
				
				case 'note':
					echo 
					"<div class='".implode(' ', $line_class)."'><p class='label'>".$var['name']."</p></div>";
				break;
				case 'text':
					echo 
					"<div class='".implode(' ', $line_class)."'>
						<p class='label'><input class='ajdePOSH_input' type='text' codevar='".$var['var']."' placeholder='".( (!empty($var['placeholder']))?$var['placeholder']:null) ."'/> ".$var['name']."".$guide."</p>
					</div>";
				break;

				case 'fmy':
					$line_class[]='fmy';
					echo 
					"<div class='".implode(' ', $line_class)."'>
						<p class='label'>
							<input class='ajdePOSH_input short' type='text' codevar='fixed_month' placeholder='eg. 11' title='Month'/><input class='ajdePOSH_input short' type='text' codevar='fixed_year' placeholder='eg. 2014' title='Year'/> ".$var['name']."".$guide."</p>
					</div>";
				break;
				case 'fdmy':
					$line_class[]='fdmy';
					echo 
					"<div class='".implode(' ', $line_class)."'>
						<p class='label'>
							<input class='ajdePOSH_input short shorter' type='text' codevar='fixed_date' placeholder='eg. 31' title='Date'/><input class='ajdePOSH_input short shorter' type='text' codevar='fixed_month' placeholder='eg. 11' title='Month'/><input class='ajdePOSH_input short shorter' type='text' codevar='fixed_year' placeholder='eg. 2014' title='Year'/> ".$var['name']."".$guide."</p>
					</div>";
				break;
				
				case 'taxonomy':
					
					$terms = get_terms($var['var']);

					$possible_values = (isset($var['possible_values']) && $var['possible_values']=='yes')?true:false;
					$view_html = '';
					
					if($possible_values){
						$view ='';
						if(!empty($terms) && count($terms)>0){
							foreach($terms as $term){
								if(!isset($term)) continue;
								if(empty($term)) continue;
								$view.= '<em>'.$term->name .' ('.$term->term_id.')</em>';
							}
						}

						$view_html = (!empty($view))? '<span class="ajdePOSH_tax">'.__('Possible Values','eventon').' <span >'. $view .'</span></span>': null;	
					}			
					
					echo 
					"<div class='".implode(' ', $line_class)."'>
						<p class='label'><input class='ajdePOSH_input' type='text' codevar='".$var['var']."' placeholder='".( (!empty($var['placeholder']))? $var['placeholder']:null) ."'/> ".$var['name']." {$view_html}</p>
					</div>";
				break;
				
				case 'select':
					echo 
					"<div class='".implode(' ', $line_class)."'>
						<p class='label'>
							<select class='ajdePOSH_select' codevar='".$var['var']."'>";
							$default = (!empty($var['default']))? $var['default']: null;
							foreach($var['options'] as $valf=>$val){
								echo "<option value='".$valf."' ".( $default==$valf? 'selected="selected"':null).">".$val."</option>";
							}						
							echo 
							"</select> ".$var['name']."".$guide."</p>
					</div>";
				break;

				// select steps
				case 'select_step':
					$line_class[]='select_step_line';
					echo 
					"<div class='".implode(' ', $line_class)."'>
						<p class='label '>
							<select class='ajdePOSH_select_step' data-codevar='".$var['var']."'>";
							
							foreach($var['options'] as $f=>$val){
								echo (!empty($val))? "<option value='".$f."'>".$val."</option>":null;
							}		
							echo 
							"</select> ".__($var['name'],$textDomain)."".$guide."</p>
					</div>";
				break;

				case 'open_select_steps':
					echo "<div id='".$var['id']."' class='ajde_open_ss' style='display:none' data-step='".$var['id']."' >";
					$this->_in_select_step=true;	// set select step section to on
				break;

				case 'close_select_step':	echo "</div>";	$this->_in_select_step=false; break;
				
			}// end switch

			endif;

			// afterstatement
			if(!empty($var['afterstatement'])){
				echo "<div class='ajde_afterst ".$var['afterstatement']."' style='display:none'>";
			}

			// closestatement
			if(!empty($var['closestatement'])){
				echo "</div>";
			}
			
			return ob_get_clean();
		}
	// get the HTML content for the shortcode generator
		public function get_content($shortcode_guide_array, $base_shortcode){
			global $ajde;
				
			$__text_a = __('Select option below to customize shortcode variable values','eventon');
			ob_start();

			?>		
				<div id='ajdePOSH_outter' class='<?php echo $base_shortcode;?>'>
					<h3 class='notifications '><em id='ajdePOSH_back' class='fa'></em><span id='ajdePOSH_subtitle' data-section='' data-bf='<?php echo $__text_a;?>'><?php echo $__text_a;?></span></h3>
					<div class='ajdePOSH_inner'>
						<div class='step1 steps'>
						<p style='    background-color: #ff896e; color: #fff;padding: 10px; font-size: 12px;'><?php _e('WARNING! If you are interchangeably using shortcode parameters between other calendar shortcodes, bare in mind, that the shortcode parameters not available in its shortcode options may not be fully supported!','eventon');?></p>
						<?php					
							foreach($shortcode_guide_array as $options){
								$__step_2 = (empty($options['variables']))? ' nostep':null;
								
								echo "<div class='ajdePOSH_btn{$__step_2}' step2='".$options['id']."' code='".$options['code']."'>".$options['name']."</div>";
							}	
						?>				
						</div>
						<div class='step2 steps' >
							<?php
								foreach($shortcode_guide_array as $options){
									if(!empty($options['variables']) ) {
										echo "<div id='".$options['id']."' class='step2_in' style='display:none'>";										
										// each shortcode option variable row
										foreach($options['variables'] as $var){
											echo $this->shortcodeInterpret($var);
										}	echo "</div>";
									}
								}						
							?>					
						</div><!-- step 2-->
						<div class='clear'></div>
					</div>
					<div class='ajdePOSH_footer'>
						<p id='ajdePOSH_var_'></p>
						<p id='ajdePOSH_code' data-defsc='<?php echo $base_shortcode;?>' data-curcode='<?php echo $base_shortcode;?>' code='<?php echo $base_shortcode;?>' >[<?php echo $base_shortcode;?>]</p>
						<span class='ajdePOSH_insert' title='Click to insert shortcode'></span>
					</div>
				</div>
			
			<?php
			return ob_get_clean();
		
		}

	// wp admin tables
		function start_table_header($id, $column_headers, $args=''){ 

			$defaults = array(
				'classes'=>'',
				'display'=>'table'
			);
			$args = !empty($args)? array_merge($defaults, $args): $defaults;
			?>
			<table id="<?php echo $id;?>" class='evo_admin_table <?php echo !empty($args['classes'])? implode(' ',$args['classes']):'';?>' style='display:<?php echo $args['display'];?>'>
				<thead width="100%">
					<tr>
						<?php
						foreach($column_headers as $key=>$value){
							// width for column
							$width = (!empty($args['width'][$key]))? 'width="'.$args['width'][$key].'px"':'';
							echo "<th id='{$key}' class='column column-{$key}' {$width}>".$value."</th>";
						}
						?>
					</tr>
				</thead>
				<tbody id='list_items' width="100%">
			<?php
		}
		function table_row($data='', $args=''){
			$defaults = array(
				'classes'=>'',
				'tr_classes'=>'',
				'tr_attr'=>'',
				'colspan'=>'none'
			);
			$args = !empty($args) ?array_merge($defaults, $args): $defaults;

			// attrs
				$tr_attr = '';
				if(!empty($args['tr_attr']) && sizeof($args['tr_attr'])>0){
					foreach($args['tr_attr'] as $key=>$value){
						$tr_attr .= $key ."='". $value ."' ";
					}
				}
			
			if($args['colspan']=='all'){
				echo "<tr class='colspan-row ".(!empty($args['tr_classes'])? implode(' ',$args['tr_classes']):'')."' ".$tr_attr.">";
				echo "<td class='column span_column ".(!empty($args['classes'])? implode(' ',$args['classes']):'')."' colspan='{$args['colspan_count']}'>".$args['content']."</td>";
			}else{
				echo "<tr class='regular-row ".(!empty($args['tr_classes'])? implode(' ',$args['tr_classes']):'')."' ".$tr_attr.">";
				foreach($data as $key=>$value){
				
					echo "<td class='column column-{$key} ".(!empty($args['classes'])? implode(' ',$args['classes']):'')."'>".$value."</td>";
				}
			}
			
			echo "</tr>";
		}
		function table_footer(){
			?>
			</tbody>
			</table>
			<?php
		}

}