<?php
do_action('wplms_before_single_assignment');
get_header(wplms_modern_get_header());
if ( have_posts() ) : while ( have_posts() ) : the_post();

$user_id = get_current_user_id();
$marks=get_post_meta($post->ID,'vibe_assignment_marks',true);
$course=get_post_meta($post->ID,'vibe_assignment_course',true);

$time=get_post_meta($post->ID,'vibe_assignment_duration',true);
$evaluation=get_post_meta($post->ID,'vibe_assignment_evaluation',true);
$assignment_submission_type=get_post_meta($post->ID,'vibe_assignment_submission_type',true);


if(is_user_logged_in()){
    $assignment_taken = get_user_meta($user_id,$post->ID,true);
    $assignment_finished = get_post_meta($post->ID,$user_id,true);
}
$flag=0;
if(isset($assignment_taken) && $assignment_taken !=''){
    $assignment_duration_parameter = apply_filters('vibe_assignment_duration_parameter',86400);
    $timelimit = $assignment_taken + $time*$assignment_duration_parameter;
    if($timelimit > time())
        $flag=1;
    else
        $flag=3;
}

if(isset($assignment_finished) && is_numeric($assignment_finished) && $assignment_finished>0)
    $flag=2;


if($user_id == $post->post_author || current_user_can('manage_options'))
    $flag=1;
?>
<section id="title" class="title-area">
    <div class="title-content">
        <div class="container">
            <div class="title-text">
                <div class="row">
                    <div class="col-md-10 col-md-offset-1">
                        <div class="pagetitle">
                            <?php
                            $course_id = get_post_meta(get_the_ID(),'vibe_assignment_course',true);
                                if(isset($course_id) && is_numeric($course_id)){
                                    if(is_user_logged_in()){
                                        $user_id = get_current_user_id();
                                        if(wplms_user_course_active_check($user_id,$course_id)){
                                            $take_course_page=get_permalink(vibe_get_option('take_course_page'));
                                            echo '<form action="'.$take_course_page.'" method="post">';
                                            echo '<input type="submit" value="'.__('Back to Course','wplms_modern').'">';
                                            wp_nonce_field('continue_course'.$user_id,'continue_course'); 
                                            echo  '<input type="hidden" name="course_id" value="'.$course_id.'" />';
                                            echo  '</form>';
                                        }else{
                                            echo '<a href="'.get_permalink($course_id).'" class="button ">'.__('Back to Course','wplms_modern').'</a>';
                                        }
                                    }else{
                                        echo '<a href="'.get_permalink($course_id).'" class="button">'.__('Back to Course','wplms_modern').'</a>';
                                    }
                                    
                                     
                                }else {
                               vibe_breadcrumbs(); 
                            }  
                            ?>
                            <h1 id="unit" data-unit="<?php echo get_the_ID(); ?>"><?php the_title(); ?></h1>
                            <?php the_sub_title(); ?>
                        </div>
                    </div>
                </div>    
            </div>
        </div>
    </div>
</section>
<section id="content">
    <div class="container">
        <div class="row">
            <div class="col-md-9 col-sm-8">
                    <div class="content">
                        <div id="assignment" class="main_content">
                            <?php do_action('wplms_assignment_before_content'); 
                            ?>
                            <?php
                            switch($flag){
                                case 0:
                                the_excerpt();
                                assignment_start_button();
                                break;
                                case 1:
                                the_content(); 
                                if(isset($assignment_submission_type)){
                                    switch($assignment_submission_type){
                                        case 'upload': comments_template('/assignment-upload.php',true); 
                                        break;
                                        case 'textarea':  comments_template('/assignment-textarea.php',true); 
                                        break;
                                        
                                    }
                                 }else{
                                    comments_template('/assignment-upload.php',true); 
                                 }
                                break;
                                case 2:
                                the_content(); 
                                assignment_results_button();
                                break;
                                case 3:
                                the_content(); 
                                assignment_results_button();
                                break;
                            }
                            if(current_user_can('manage_options') || ($user_id == $post->post_author)){
                                echo '<h3 class="heading">'.__('All Assignment Submissions','wplms_modern').'</h3>';?>
                                <div class="assignment_submissionlist"> 
                                <?php 
                                  comments_template();
                                ?>  
                                </div> <?php
                            }
                            ?>
                        </div>
                        <?php do_action('wplms_assignment_after_content'); ?> 
                    </div>
                <?php
                
                endwhile;
                endif;

                ?>
            </div>
            <div class="col-md-3 col-sm-4">
                <div class="assignment_details">
                <?php
                    if(isset($marks) && is_numeric($marks)){
                        echo '<div class="assignment_marks">';
                        echo '<h2>'.$marks.'<span>'.__('Maximum Marks','wplms_modern').'</span></h2>';
                        echo '</div>';
                    }
                    if(isset($time) && is_numeric($time)){
                        echo '<div class="assignment_duration">';
                        the_assignment_timer($time);
                        echo '</div>';
                    }
                ?>
                </div>
                <?php       
                    if(isset($_GET['edit']) || isset($wp_query->query_vars['edit']) ){
                        do_action('wplms_front_end_assignment_controls');    
                    }else{
                        
                    $sidebar = apply_filters('wplms_sidebar','coursesidebar',get_the_ID());
                    if ( !function_exists('dynamic_sidebar')|| !dynamic_sidebar($sidebar) ) {}
                   }
                   ?>
            </div>
        </div>
    </div>
</section>
<?php
    do_action('wplms_after_assignment');
?>
<?php
get_footer(wplms_modern_get_footer());
?>