<?php if ( ! defined( 'ABSPATH' ) ) exit;
/**
 * Task settings
 *
 * @package     Workreap
 * @subpackage  Workreap/admin/Theme_Settings/Settings
 * @author      Amentotech <info@amentotech.com>
 * @link        http://amentotech.com/
 * @version     1.0
 * @since       1.0
*/
$social_list	= function_exists('workreap_get_social_media_icons_list') ? apply_filters('workreap_get_social_media_icons_list','yes')	: array();
$workreap_freelancers = array(
	array(
		'id'        => 'hide_english_level',
		'type'      => 'select',
		'title'     => esc_html__('Hide english level', 'workreap'),
		'subtitle'      => esc_html__('Hide english level from freelancer settings and profile page.', 'workreap'),
		'options'   => array(
			'yes'         => esc_html__('Yes', 'workreap'),
			'no'         => esc_html__('No', 'workreap')
		),
		'default'   => 'no',
	),
	array(
		'id'        => 'hide_skills',
		'type'      => 'select',
		'title'     => esc_html__('Hide skills', 'workreap'),
		'subtitle'      => esc_html__('Hide skills from freelancer settings and profile page.', 'workreap'),
		'options'   => array(
			'yes'         => esc_html__('Yes', 'workreap'),
			'no'         => esc_html__('No', 'workreap')
		),
		'default'   => 'no',
	),
	array(
		'id'        => 'hide_languages',
		'type'      => 'select',
		'title'     => esc_html__('Hide languages', 'workreap'),
		'subtitle'      => esc_html__('Hide languages from freelancer settings and profile page', 'workreap'),
		'options'   => array(
			'yes'         => esc_html__('Yes', 'workreap'),
			'no'         => esc_html__('No', 'workreap')
		),
		'default'   => 'no',
	),
	array(
		'id'        => 'hide_freelancer_without_avatar',
		'type'      => 'select',
		'title'     => esc_html__('Hide freelancers', 'workreap'),
		'subtitle'      => esc_html__('Hide freelancers without a profile image.', 'workreap'),
		'options'   => array(
			'yes'	=> esc_html__('Yes, hide profiles', 'workreap'),
			'no'	=> esc_html__('No', 'workreap'),
		),
		'default'   => 'no',
	),
	array(
		'id' 		    => 'portf_max_images',
		'type' 		=> 'slider',
		'title' 	    => esc_html__('Portfolio gallery images', 'workreap'),
		'subtitle' 		=> esc_html__('Set max number portfolio gallery images.', 'workreap'),
		'default' 	=> 3,
		'min' 		=> 1,
		'step' 		=> 1,
		'max'		    => 100,
		'display_value' => 'label',
	),
	array(
		'id'        => 'hide_freelancer_hourly_rate',
		'type'      => 'switch',
		'default'   => false,
		'title'     => esc_html__('Hide hourly rate', 'workreap'),
		'subtitle'     => esc_html__( 'Enabling this option will hide the hourly field on the freelancer\'s profile.', 'workreap' ),
	),
    array(
        'id'        => 'freelancer_description_editor',
        'type'      => 'switch',
        'default'   => true,
        'title'     => esc_html__('Description editor', 'workreap'),
    ),
	array(
		'id'        => 'enable_freelancer_socials',
		'type'      => 'switch',
		'default'   => false,
		'title'     => esc_html__('Social profile', 'workreap'),
	),
	array(
		'id'        => 'freelancer_socials',
		'type'      => 'select',
		'title'     => esc_html__('Social Profile Items', 'workreap'),
		'subtitle'  => esc_html__('Select social profile items. Leave empty to hide.', 'workreap'),
		'options'   => $social_list, // Ensure $social_list is properly defined as an array
		'multi'     => true,
		'default'   => array(), // Default should be an empty array for multiple selection
		'required'  => array('enable_freelancer_socials', '=', true),
	)
	
);


Redux::setSection( $opt_name, array(
	'title'            => esc_html__( 'Freelancer settings ', 'workreap' ),
	'id'               => 'freelancer_settings',
	'desc'       	   => '',
	'subsection'       => false,
	'icon'			   => 'el el-adult',
	'fields'           => $workreap_freelancers
	)
);