<?php
/**
 * 
 * Class 'Workreap_Admin_CPT_Employer' defines the custom post type Employers
 *
 * @package     Workreap
 * @subpackage  Workreap/admin/cpt
 * @author      Amentotech <info@amentotech.com>
 * @link        http://amentotech.com/
 * @version     1.0
 * @since       1.0
 */
class Workreap_Admin_CPT_Employer {

	/**
	 * Employers post type
	 *
	 * @since    1.0.0
	 * @access   public
	 */
	public function __construct() {
		add_action('init', array(&$this, 'init_post_type'));		
		add_filter('manage_employers_posts_columns', array(&$this, 'employers_columns_add'));
		add_action('manage_employers_posts_custom_column', array(&$this, 'employers_columns'),10, 2);
	}
	/**
	 * @Prepare Columns
	 * @return {post}
	 */
	public function employers_columns_add($columns) {
		$columns['user_email'] 			= esc_html__('Email Address','workreap');
		$columns['wallet_balance'] 		= esc_html__('Wallet balance','workreap');
		$columns['image'] 				= esc_html__('Image','workreap');
		$columns['posted_jobs'] 		= esc_html__('Jobs Posted','workreap');
		return $columns;
	}

		/**
	 * @Get Columns
	 * @return {}
	 */
	public function employers_columns($case) {
		global $post;
		$user_identity		= workreap_get_linked_profile_id($post->ID,'post');
		$user_balance    	= get_user_meta( $user_identity, '_employer_balance', true );
	    $user_balance    	= ! empty( $user_balance ) ? $user_balance : 0;
		$user_data			= get_user($user_identity);
		switch ($case) {
			case 'posted_jobs':
				$total_jobs = workreap_get_user_projects($user_identity);
				if(empty($total_jobs)){
					echo esc_html__('No jobs posted','workreap');
				} else{
					$url = add_query_arg(
						array(
							'post_type' 	=> 'product',
							'product_type' 	=> 'projects',
							'author'    	=> $user_identity,
						),
						admin_url('edit.php')
					);
					echo '<a href="'.esc_url($url).'" target="_blank">'.esc_html($total_jobs).'</a>';
				}
			break;
			case 'image':
				$avatar = apply_filters(
					'workreap_avatar_fallback',
					workreap_get_user_avatar(array('width' => 50, 'height' => 50), $post->ID),
					array('width' => 50, 'height' => 50)
				);
				if (!empty($avatar)) {
					echo '<img src="' . esc_url($avatar) . '" alt="' . esc_attr__('Employer Image', 'workreap') . '" width="50" height="50" />';
				}
			break;
			case 'wallet_balance':
				workreap_price_format($user_balance);
			break;
			case 'user_email':
				if(!empty($user_data->user_email)){
					echo esc_html($user_data->user_email);
				} else{
					echo esc_html__('No email address','workreap');
				}
			break;
		}
	}
	/**
	 * @Init post type
	*/
	public function init_post_type() {
		$this->register_posttype();
	}

	/**
	 *Regirster employer post type
	*/ 
	public function register_posttype() {
		$labels = array(
			'name'                  => esc_html__( 'Employers', 'workreap' ),
			'singular_name'         => esc_html__( 'Employer', 'workreap' ),
			'menu_name'             => esc_html__( 'Employers', 'workreap' ),
			'name_admin_bar'        => esc_html__( 'Employers', 'workreap' ),
			'parent_item_colon'     => esc_html__( 'Parent employer:', 'workreap' ),
			'all_items'             => esc_html__( 'All employers', 'workreap' ),
			'add_new_item'          => esc_html__( 'Add new employer', 'workreap' ),
			'add_new'               => esc_html__( 'Add new employer', 'workreap' ),
			'new_item'              => esc_html__( 'New employer', 'workreap' ),
			'edit_item'             => esc_html__( 'Edit employer', 'workreap' ),
			'update_item'           => esc_html__( 'Update employer', 'workreap' ),
			'view_item'             => esc_html__( 'View employers', 'workreap' ),
			'view_items'            => esc_html__( 'View employers', 'workreap' ),
			'search_items'          => esc_html__( 'Search employers', 'workreap' ),
		);
		
		$args = array(
			'label'                 => esc_html__( 'Employer', 'workreap' ),
			'description'           => esc_html__( 'All employer.', 'workreap' ),
			'labels'                => apply_filters('workreap_product_taxonomy_duration_labels', $labels),
			'taxonomies'            => array( 'product_cat'),
			'public' 				=> true,
			'supports' 				=> array('title','editor','author','excerpt','thumbnail'),
			'show_ui' 				=> true,
			'capability_type' 		=> 'post',
			'map_meta_cap' 			=> true,
			'publicly_queryable' 	=> false,
			'exclude_from_search' 	=> true,
			'hierarchical' 			=> false,
			'menu_position' 		=> 10,
			'rewrite' 				=> array('slug' => 'employer', 'with_front' => true),
			'query_var' 			=> false,
			'has_archive' 			=> false,
			'show_in_menu' 			=> 'edit.php?post_type=freelancers',
			'capabilities' 			=> array(
										'create_posts' => false
									),	
			'rest_base'             => 'employer',
			'rest_controller_class' => 'WP_REST_Posts_Controller',
		);
		
		register_post_type( apply_filters('workreap_employer_post_type_name', 'employers'), $args );

	}  
}

new Workreap_Admin_CPT_Employer();