<?php

/**
 * WC_Bookings_Calendar.
 */
class WC_Bookings_Calendar {

	/**
	 * Stores Bookings/Availability.
	 *
	 * @var array Mixed type of WC_Global_Availability and WC_Booking
	 */
	private $events;

	/**
	 * Maximum number of bookings to display in each day of the monthly calendar view.
	 */
	const MAX_BOOKINGS_PER_DAY = 3;

	const CALENDAR_VIEWS = array(
		'month',
		'day',
		'schedule',
	);

	/**
	 * Output the calendar view.
	 */
	public function output() {
		global $wp_version;

		wp_enqueue_script( 'wc-enhanced-select' );
		wp_enqueue_script( 'wc_bookings_admin_js' );

		$product_filter  = isset( $_REQUEST['filter_bookings_product'] ) ? absint( $_REQUEST['filter_bookings_product'] ) : '';
		$resource_filter = isset( $_REQUEST['filter_bookings_resource'] ) ? absint( $_REQUEST['filter_bookings_resource'] ) : '';
		$default_view    = wp_is_mobile() ? 'schedule' : 'day';
		$view            = isset( $_REQUEST['view'] ) && in_array( $_REQUEST['view'], self::CALENDAR_VIEWS ) ? $_REQUEST['view'] : $default_view;
		$booking_filter = array();
		if ( $product_filter ) {
			array_push( $booking_filter, $product_filter );
		}
		if ( $resource_filter ) {
			array_push( $booking_filter, $resource_filter );
		}

		$month = isset( $_REQUEST['calendar_month'] ) ? absint( $_REQUEST['calendar_month'] ) : current_time( 'n' );
		$year  = isset( $_REQUEST['calendar_year'] ) ? absint( $_REQUEST['calendar_year'] ) : current_time( 'Y' );
		$day   = isset( $_REQUEST['calendar_day'] ) ? wc_clean( $_REQUEST['calendar_day'] ) : current_time( 'Y-m-d' );

		if ( 'day' === $view ) {
			$day          = isset( $_REQUEST['calendar_day'] ) ? wc_clean( $_REQUEST['calendar_day'] ) : date( 'Y-m-d' );
			$day_start    = strtotime( 'midnight', strtotime( $day ) );
			$day_end      = strtotime( 'midnight +1 day', strtotime( $day ) ) - 1;
			$this->events = WC_Global_Availability_Data_Store::get_events_in_date_range(
				$day_start,
				$day_end,
				$booking_filter,
				false
			);
			$this->global_availability_minutes = $this->get_available_minutes_for_calendar_day( $day );
			$this->day                         = strtotime( $day );
		} else {
			if ( $year < ( date( 'Y' ) - 10 ) || $year > 2100 ) {
				$year = date( 'Y' );
			}

			if ( $month > 12 ) {
				$month = 1;
				$year ++;
			}

			if ( $month < 1 ) {
				$month = 12;
				$year --;
			}

			if ( 'month' === $view ) {
				/*
				* WordPress start_of_week is in date format 'w'.
				* We are changing it to 'N' because we want ISO-8601.
				* Monday is our reference first day of the week.
				*/
				$start_of_week           = absint( get_option( 'start_of_week', 1 ) );
				$start_of_week           = $start_of_week === 0 ? 7 : $start_of_week;

				// On which day of the week the month starts
				$month_start_day_of_week = absint( date( 'N', strtotime( "$year-$month-01" ) ) );

				/*
				* Calculate column where the month start will be placed.
				* This calculates true modulo ( never negative ).
				*/
				$start_column            = ( 7 + ( $month_start_day_of_week - $start_of_week ) % 7 ) % 7;

				/*
				* Calcu start date: how many days from the previous month we need to include,
				* in order to have calendar without empty days in the first row.
				*/
				$start_time              = strtotime( "-{$start_column} day", strtotime( "$year-$month-01" ) );

				// How many days the month has.
				$month_number_of_days    = date( 't', strtotime( "$year-$month-01" ) );

				// On which day of the week the month ends.
				$month_end_day_of_week   = absint( date( 'N', strtotime( "$year-$month-$month_number_of_days" ) ) );

				/*
				* Calculate column where the last day of month will be placed.
				* This calculates true modulo ( never negative ).
				*/
				$end_column             = ( 7 + ( $month_end_day_of_week - $start_of_week ) % 7 ) % 7;

				/*
				* Calculate end date: how many days from the next month we need to include.
				* We want to have calendar without empty days in the last row.
				*/
				$end_padding            = 6 - $end_column;
				$end_time               = strtotime( "+{$end_padding} day midnight", strtotime( "$year-$month-$month_number_of_days" ) );

				$this->events           = WC_Global_Availability_Data_Store::get_events_in_date_range(
					$start_time,
					$end_time,
					$booking_filter,
					false
				);
			} elseif ( 'schedule' === $view ) {
				$day          = strtotime( "$year-$month-01" );
				$start_time   = strtotime( 'first day of this month', $day );
				$end_time     = strtotime( 'first day of next month', $day );
				$this->events = WC_Global_Availability_Data_Store::get_events_in_date_range(
					$start_time,
					$end_time,
					$booking_filter,
					false
				);

				$this->days = new DatePeriod(
					new DateTime( '@' . $start_time ),
					new DateInterval('P1D'),
					new DateTime( '@' . $end_time )
				);
				$this->day  = strtotime( $day );
				$this->events_data = $this->get_events_data_for_days( $this->days, $this->events );
			}
		}

		$calendar_params = array(
			'default_month' => esc_html( date_i18n( 'F', mktime( 0, 0, 0, $month, 10 ) ) ),
			'default_year'  => esc_html( $year ),
			'default_day'   => esc_html( isset( $_REQUEST['calendar_day'] ) ? date( 'F d, Y', strtotime( wc_clean( $_REQUEST['calendar_day'] ) ) ) : current_time( 'F d, Y' ) ),
		);
		// First day of currently selected year/month for datepicker default.
		$default_date = "$year-$month-01";

		wp_localize_script( 'wc_bookings_admin_calendar_gutenberg_js', 'wc_bookings_admin_calendar_js_params', $calendar_params );

		include( 'views/html-calendar-' . $view . '.php' );
	}


	/**
	 * Pull out array of event data needed for schedule view from an
	 * array of bookings and global availability rules for a range of days.
	 *
	 * @param array $days   Array of dates to generate event data array for.
	 * @param array $events Mixed array of 'WC_Global_Availability' and 'WC_Booking' objects.
	 *
	 * @return array Array of data needed for schedule view.
	 */
	protected function get_events_data_for_days( $days, $events ) {
		$events_data = array();
		foreach ( $events as $event ) {
			if ( 'WC_Booking' === get_class( $event ) ) {
				$booking      = $event;
				$booking_data = $this->get_booking_data( $booking );
				$order        = $booking->get_order();
				if ( ( false !== $order ) && method_exists( $order, 'get_customer_note' ) ) {
					$note = $order->get_customer_note();
				}
				$events_data[] = array(
					'customer' => $booking_data['customer'],
					'title'    => $booking_data['title'],
					'time'     => $booking_data['time'],
					'resource' => $booking_data['resource'],
					'persons'  => $booking_data['persons'],
					'url'      => $booking_data['url'],
					'note'     => isset( $note ) ? $note : '',
					'start'    => $event->get_start(),
				);
			} else { // Extract global availability data.
				$availability = $event;

				// Check for applicable occurences of the availability rules for each day in range.
				foreach ( $days as $day ) {
					$range        = $availability->get_time_range_for_date( $day->getTimestamp() );
					if ( is_null( $range ) ) {
						// Rule not applicable to this day, so skip it.
						continue;
					}
					$start            = $range['start'];
					$short_start_time = $this->get_short_time( $range['start'] );
					$short_end_time   = $this->get_short_time( $range['end'] );
					$time             = $availability->is_all_day() ? __( 'All Day', 'woocommerce-bookings' ) : sprintf( __( '%1$s — %2$s', 'woocommerce-bookings' ), $short_start_time, $short_end_time );
					$title            = ! empty( $availability->get_title() ) ? $availability->get_title() : __( 'Unavailable', 'woocommerce_bookings' );
					$title           .= ' ' . __( '(From Google Calendar)', 'woocommerce-bookings' );
					$detail_href     = admin_url( 'edit.php?post_type=wc_booking&page=wc_bookings_settings' );
					if ( $availability->date_starts_today( $start ) ) {
						$start_date = $availability->get_formatted_date( $start, '', wc_time_format() );
					} else {
						$start_date = '';
					}
					$events_data[] = array(
						'customer' => '',
						'title'    => $title,
						'time'     => $time,
						'resource' => '',
						'persons'  => '',
						'url'      => $detail_href,
						'note'     => '',
						'start'    => $start,
					);
				}
			}
		}
		usort( $events_data, function( $a, $b ) {
			return $a['start'] > $b['start'];
		} );
		return $events_data;
	}

	/**
	 * List bookings for a day.
	 */
	public function list_bookings( $day, $month, $year ) {
		$date_start    = strtotime( "$year-$month-$day midnight" ); // Midnight today.
		$date_end      = strtotime( "$year-$month-$day tomorrow" ); // Midnight next day.
		$booking_count = 0;

		foreach ( $this->events as $event ) {
			$event_classes = array( 'wc-bookings-event-link' );
			$title         = '';
			$id            = '';
			$style         = '';

			if ( 'WC_Booking' === get_class( $event ) ) {
				$booking = $event;
				$start   = $booking->get_start();
				$end     = $booking->get_end();
				if ( $start >= $date_end || $end < $date_start ) {
					continue;
				}
				$multi_day = false;
				// Mark an event if it will be present in multiple days.
				if ( $start < $date_start || $end > $date_end ) {
					$multi_day = true;
				}

				$product     = $booking->get_product();
				$start_date  = $booking->get_start_date( '', wc_time_format() );
				$is_all_day  = $booking->is_all_day();
				$detail_href = admin_url( 'post.php?post=' . $booking->get_id() . '&action=edit' );

				if ( $product ) {
					$title = $product->get_title();
				}

				$id    = $booking->get_id();
				$style .= $multi_day ? 'color:' . $this->colours[ $id ]['color'] . ';background-color:' . $this->colours[ $id ]['background'] . ';' : '';
			} else { // Extract global availability data.
				$availability = $event;
				$range        = $availability->get_time_range_for_date( $date_start );
				if ( is_null( $range ) ) {
					continue;
				}
				$start           = $range['start'];
				$is_all_day      = $availability->is_all_day();
				$title           = ! empty( $availability->get_title() ) ? $availability->get_title() : __( 'Unavailable', 'woocommerce_bookings' );
				$title          .= ' ' . __( '(From Google Calendar)', 'woocommerce-bookings' );
				$detail_href     = admin_url( 'edit.php?post_type=wc_booking&page=wc_bookings_settings' );
				$event_classes[] = 'no_availability';
				$id              = $event->get_gcal_event_id();
				if ( $availability->date_starts_today( $start ) ) {
					$start_date = $availability->get_formatted_date( $start, '', wc_time_format() );
				                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     