<?php get_header(); ?>	

<div id="main" class="<?php echo leap_main_col_class(); ?>">

	<?php
	// Content top widget position
	get_template_part( 'includes/sidebar/content-top' );
	?>

	<div class="content-section">

		<?php if ( have_posts() ) { ?>
			<div class="archive-info">
				<?php
				$tag_id				 = get_query_var( 'tag_id' );
				$tag_page_settings	 = ot_get_option( 'tag_page_settings', array() );
				if ( in_array( 'tag_rss', $tag_page_settings ) ) {
					?>
					<div class="archive-rss"><a class="archive-rss-icon" title="<?php esc_attr_e( 'Feed Subscription', 'wiz' ); ?>" href="<?php echo get_term_feed_link( $tag_id, 'post_tag', "rss2" ) ?>"><i class="fa fa-rss-square fa-lg"></i></a></div>
				<?php } ?>

				<?php
				if ( in_array( 'tag_desc', $tag_page_settings ) ) :
					$tag_description = tag_description();
					if ( !empty( $tag_description ) )
						echo '<div class="archive-description">' . $tag_description . '</div>';
				endif;
				?>
			</div>
			<?php
			$blog_layout = ot_get_option( 'archive_layout', 'medium' );
			?>
			<div class="archive-wrapper">
				<div class="entry-layout archive-<?php echo $blog_layout ?>">
					<?php while ( have_posts() ) : the_post(); ?>
						<?php get_template_part( 'includes/content/archive' ); ?>
					<?php endwhile; ?>
				</div>
			</div>
			<?php leap_page_navi(); ?>

			<?php
		} else {
			get_template_part( 'includes/content/none' );
		}
		?>

	</div>

	<?php
	// Content bottom widget position
	get_template_part( 'includes/sidebar/content-bottom' );
	?>

</div> <!-- end #main -->

<?php get_footer(); ?>
