<?php get_header(); ?>
<div id="main" class="<?php echo leap_main_col_class(); ?>">

    <?php
    // Content top widget position
    get_template_part( 'includes/sidebar/content-top' );
    ?>

    <div class="content-section">

        <?php
        // Above post banner
        get_template_part( 'includes/banners/above-post' );
        ?>

        <?php while ( have_posts() ) : the_post(); ?>

            <?php get_template_part( 'includes/content/single' ); ?>

        <?php endwhile; ?>	


        <?php
        // Display Author information
        $author_info = leap_get_option_with_default( 'author_info', 'leap_author_info' );
        if ( $author_info == 'yes' ) {
            ?>
            <div class="about-author">
                <div class="title">
                    <h4><?php the_author_posts_link(); ?></h4>
                </div>
                <div class="archive-info">
                    <div class="author-avatar">
                        <?php echo get_avatar( get_the_author_meta( 'email' ), '80' ); ?>
                    </div>
                    <div class="author-description">
                        <?php the_author_meta( "description" ); ?>
                    </div>
                </div>
            </div>
        <?php } ?>


        <?php
        // Display Posts navigation
        $posts_nav = leap_get_option_with_default( 'posts_nav', 'leap_posts_nav' );
        if ( $posts_nav == 'yes' ) :
            ?>
            <div class="post-navigation">
                <div class="post-previous"><?php previous_post_link( '%link', '<span></span>%title' ); ?></div>
                <div class="post-next"><?php next_post_link( '%link', '<span></span>%title' ); ?></div>
            </div>
        <?php endif; ?>


        <?php
        // Display Related posts
        $related_posts = leap_get_option_with_default( 'related_posts', 'leap_related_posts' );
        if ( $related_posts == 'yes' ) {
            get_template_part( 'includes/related-posts' );
        }
        ?>

        <?php
        // Below post banner
        get_template_part( 'includes/banners/below-post' );
        ?>

        <?php
        // Display comment
        if ( ot_get_option( 'posts_comment', 'yes' ) == 'yes' ) {
            comments_template();
        }
        ?>

    </div> <!-- end .content-section -->

    <?php
    // Content bottom widget position
    get_template_part( 'includes/sidebar/content-bottom' );
    ?>

</div> <!-- end #main -->

<?php get_footer(); ?>
