<?php get_header(); ?>

<div id="main" class="<?php echo leap_main_col_class(); ?>">

    <?php
    // Content top widget position
    get_template_part( 'includes/sidebar/content-top' );
    ?>

    <div class="content-section">

        <?php while ( have_posts() ) : the_post(); ?>

            <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

                <div class="entry-wrapper">

                    <?php
                    if ( has_post_thumbnail() ) {
                        $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'large' );
                        ?>
                        <div class="entry-header">
                            <div class="entry-head">				
                                <div class="entry-img">
                                    <a data-rel="prettyPhoto" href="<?php echo $large_image_url[ 0 ]; ?>"  title="<?php the_title_attribute(); ?>"><?php echo get_the_post_thumbnail( get_the_ID(), 'leap-portfolio-single' ); ?></a>
                                </div>
                            </div>
                        </div>
                    <?php } ?>

                    <div class="entry-content">

                        <div class="row">
                            <div class="<?php echo leap_bws_col_class( 8 ) ?>">
                                <div class="post-content">
                                    <div class="title">
                                        <h4><?php _e( 'Project Description', 'wiz' ) ?></h4>
                                    </div>
                                    <?php the_content(); ?>
                                    <?php wp_link_pages( array( 'before' => '<p><strong>' . esc_html__( 'Pages', 'wiz' ) . ':</strong> ', 'after' => '</p>', 'next_or_number' => 'number' ) ); ?></div>
                            </div>

                            <div class="<?php echo leap_bws_col_class( 4 ) ?>">
                                <div class="title">
                                    <h4><?php _e( 'Project Details', 'wiz' ) ?></h4>
                                </div>

                                <?php
                                $portfolio_fields = ot_get_option( 'portfolio_fields', array() );

                                $portfolio_fields_right  = leap_search_multidimensional_array( 'right', 'position', $portfolio_fields );
                                $portfolio_fields_bottom = leap_search_multidimensional_array( 'bottom', 'position', $portfolio_fields );

                                if ( count( $portfolio_fields_right ) > 0 ) {
                                    echo '<div class="project-details">';
                                    foreach ( $portfolio_fields_right as $portfolio_field_right ) {
                                        $field_value = leap_portfolio_field_type( $portfolio_field_right, get_the_ID() );
                                        if ( !empty( $field_value ) ) {
                                            echo '<div class="box"><span>' . $portfolio_field_right[ "title" ] . '</span><div>' . $field_value . '</div></div>';
                                        }
                                    }
                                    echo '</div>';
                                }
                                ?>

                            </div>
                        </div>

                    </div>

                    <?php if ( count( $portfolio_fields_bottom ) > 0 ) { ?>
                        <div class="portfolio-fields-bottom">
                            <div class="project-details">
                                <?php
                                foreach ( $portfolio_fields_bottom as $portfolio_field_bottom ) {
                                    $field_value = leap_portfolio_field_type( $portfolio_field_bottom, get_the_ID() );
                                    if ( !empty( $field_value ) ) {
                                        ?>
                                        <div class="box">
                                            <span><?php echo $portfolio_field_bottom[ "title" ]; ?></span>
                                            <div><?php echo leap_portfolio_field_type( $portfolio_field_bottom, get_the_ID() ); ?></div>
                                        </div>
                                        <?php
                                    }
                                }
                                ?>
                            </div>
                        </div>
                    <?php } ?>


                    <?php
                    // Display related projects
                    $related_porjects = leap_get_option_with_default( 'related_porjects', 'leap_related_posts' );
                    if ( $related_porjects == 'yes' ) {
                        get_template_part( 'includes/related-projects' );
                    }
                    ?>

                </div>
            </div>

        <?php endwhile; ?>

    </div>

    <?php
    // Content bottom widget position
    get_template_part( 'includes/sidebar/content-bottom' );
    ?>

</div> <!-- end #main -->

<?php get_footer(); ?>