<?php get_header(); ?>	

<div id="main" class="<?php echo leap_main_col_class(); ?>">

	<?php
	// Content top widget position
	get_template_part( 'includes/sidebar/content-top' );
	?>

	<div class="content-section">

		<?php if ( have_posts() ) { ?>
			<div class="archive-info">
				<p><?php echo __( 'If you are not happy with the results below please do another search.', 'wiz' ); ?></p>
				<div class="search-form">
					<form class="navbar-search" method="get" action="<?php echo home_url( '/' ); ?>">
						<div class="form-group">
							<input name="s" type="text" class="form-control search-query" placeholder="<?php _e( 'Enter your search keywords', 'wiz' ); ?>" value="<?php echo get_search_query(); ?>" />
						</div>
						<button type="submit" class="btn btn-default btn-leap pull-right"><?php _e( 'Search', 'wiz' ); ?></button>
					</form>
				</div>
			</div>
			<?php
			$blog_layout = ot_get_option( 'search_layout', 'medium' );
			?>
			<div class="archive-wrapper">
				<div class="entry-layout archive-<?php echo $blog_layout; ?>">
					<?php while ( have_posts() ) : the_post(); ?>
						<?php get_template_part( 'includes/content/search' ); ?>
					<?php endwhile; ?>
				</div>
			</div>
			<?php leap_page_navi(); ?>

		<?php } else { ?>

			<div id="post-not-found">
				<h4><?php _e( "Nothing Found", 'wiz' ); ?> </h4>
				<div class="post-content">
					<p><?php _e( "Sorry, but nothing matched your search criteria. Please try again with some different keywords.", 'wiz' ); ?> </p>
					<div class="search-form">
						<form class="navbar-search" method="get" action="<?php echo home_url( '/' ); ?>">
							<div class="form-group">
								<input name="s" type="text" class="form-control search-query" placeholder="<?php _e( 'Enter your search keywords', 'wiz' ); ?>" value=" <?php echo get_search_query(); ?>" />
							</div>
							<button type="submit" class="btn btn-default btn-leap pull-right"><?php _e( 'Search', 'wiz' ); ?></button>
						</form>
					</div>
				</div>
			</div>

		<?php } ?>

	</div>

	<?php
	// Content bottom widget position
	get_template_part( 'includes/sidebar/content-bottom' );
	?>

</div> <!-- end #main -->

<?php get_footer(); ?>
