<?php get_header(); ?>

<div id="main" class="<?php echo leap_main_col_class(); ?>">

	<?php
	// Content top widget position
	get_template_part( 'includes/sidebar/content-top' );
	?>

    <div class="content-section">
		<?php
		// Above post banner
		get_template_part( 'includes/banners/above-post' );
		?>

		<?php while ( have_posts() ) : the_post(); ?>

			<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				<div class="entry-wrapper">

					<?php
					if ( has_post_thumbnail() ) {
						$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'large' );
						?>
						<div class="entry-header">
							<div class="entry-head">				
								<div class="entry-img">
									<a data-rel="prettyPhoto" href="<?php echo $large_image_url[ 0 ]; ?>"  title="<?php the_title_attribute(); ?>"><?php echo get_the_post_thumbnail( get_the_ID(), 'leap-portfolio-1col' ); ?></a>
								</div>
							</div>
						</div>
						<?php
					}
					?>


					<div class="entry-content" itemprop="mainContentOfPage">
						<div class="post-content">
							<?php the_content(); ?>
							<?php wp_link_pages( array( 'before' => '<p><strong>' . esc_html__( 'Pages', 'wiz' ) . ':</strong> ', 'after' => '</p>', 'next_or_number' => 'number' ) ); ?>
						</div>
					</div>

					<div class="entry-footer">
						<?php
						// Sharing buttons
						if ( !is_home() || !is_front_page() ) {
							$show_share_buttons = ot_get_option( 'show_share_buttons', array() );
							if ( in_array( 'page', $show_share_buttons ) ) {
								get_template_part( 'includes/share-buttons' );
							}
						}
						?>
					</div>
				</div>

			</div>

		<?php endwhile; ?>

		<?php
		// Below post banner
		get_template_part( 'includes/banners/below-post' );
		?>

		<?php
		// Display comment
		if ( !is_home() || !is_front_page() ) {
			if ( ot_get_option( 'pages_comment', 'no' ) == 'yes' ) {
				comments_template( '', true );
			}
		}
		?>

    </div>

	<?php
	// Content bottom widget position
	get_template_part( 'includes/sidebar/content-bottom' );
	?>



</div> <!-- end #main -->
<?php get_footer(); ?>
   