<?php
/*
  Template Name: Contact
 */
?>
<?php
$leap_error_message	 = '';
$leap_contact_error	 = false;

$enable_recaptcha		 = apply_filters( 'leap_enable_recaptcha', ot_get_option( 'enable_recaptcha', 'off' ) );
$recaptcha_site_key		 = apply_filters( 'leap_recaptcha_site_key', ot_get_option( 'recaptcha_site_key', '' ) );
$recaptcha_secret_key	 = apply_filters( 'leap_recaptcha_secret_key', ot_get_option( 'recaptcha_secret_key', '' ) );

if ( isset( $_POST[ 'leap_submit' ] ) ) {

	if ( $enable_recaptcha == 'on' ) {
		if ( isset( $_POST[ 'g-recaptcha-response' ] ) ) {
			$response = wp_remote_get( "https://www.google.com/recaptcha/api/siteverify?secret=" . $recaptcha_secret_key . "&response=" . $_POST[ 'g-recaptcha-response' ], array( 'sslverify' => false ) );

			$response_data = json_decode( $response[ 'body' ], true );

			if ( $response_data[ 'success' ] == true ) {
				$recaptcha_success = true;
			} else {
				$recaptcha_success = false;
			}
		} else {
			$recaptcha_success = false;
		}

		if ( !$recaptcha_success ) {
			$leap_error_message .= '<p class="leap-error-msg">' . esc_html__( 'You entered a wrong captcha.', 'wiz' ) . '</p>';
			$leap_contact_error = true;
		}
	}


	if ( empty( $_POST[ 'leap_name' ] ) || empty( $_POST[ 'leap_email' ] ) || empty( $_POST[ 'leap_subject' ] ) || empty( $_POST[ 'leap_message' ] ) ) {
		$leap_error_message .= '<p class="leap-error-msg">' . esc_html__( 'Make sure you fill all fields with valid information.', 'wiz' ) . '</p>';
		$leap_contact_error = true;
	}

	if ( !is_email( $_POST[ 'leap_email' ] ) ) {
		$leap_error_message .= '<p class="leap-error-msg">' . esc_html__( 'Invalid Email. ', 'wiz' ) . '</p>';
		$leap_contact_error = true;
	}
} else {
	$leap_contact_error = true;
}



if ( !$leap_contact_error && isset( $_POST[ '_wpnonce-leap-contact-form-submitted' ] ) && wp_verify_nonce( $_POST[ '_wpnonce-leap-contact-form-submitted' ], 'leap-contact-form-submit' ) ) {

	$leap_email_to = ot_get_option( 'contact_email_to', '' );
	if ( !is_email( $leap_email_to ) ) {
		$leap_email_to = get_site_option( 'admin_email' );
	}

	$leap_site_name = is_multisite() ? $current_site->site_name : get_bloginfo( 'name' );

	$contact_name	 = sanitize_text_field( $_POST[ 'leap_name' ] );
	$contact_email	 = sanitize_email( $_POST[ 'leap_email' ] );

	$contact_message = __( 'Name', 'wiz' ) . ': ' . $contact_name . "\n";
	$contact_message .= __( 'Message', 'wiz' ) . ': ' . "\n";
	$contact_message .= wp_strip_all_tags( $_POST[ 'leap_message' ] );

	$headers = 'From: ' . $contact_name . ' <' . $contact_email . '>' . "\r\n";
	$headers .= 'Reply-To: ' . $contact_name . ' <' . $contact_email . '>';

	wp_mail( apply_filters( 'leap_contact_page_email_to', $leap_email_to ), sprintf( '[%s] ' . sanitize_text_field( $_POST[ 'leap_subject' ] ), $leap_site_name ), $contact_message, apply_filters( 'leap_contact_page_headers', $headers, $contact_name, $contact_email ) );

	$leap_error_message = '<p class="leap-success-msg">' . esc_html__( 'Thanks for contacting us', 'wiz' ) . '</p>';
}
?>

<?php get_header(); ?>

<div id="main" class="<?php echo leap_main_col_class(); ?>">


	<?php
	/**
	 * Content top sidebar
	 */
	get_template_part( 'includes/sidebar/content-top' );
	?>


	<div class="content-section">

		<?php while ( have_posts() ) : the_post(); ?>

			<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				<div class="entry-wrapper">

					<div class="entry-header">
						<?php
						if ( has_post_thumbnail() ) {
							$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'large' );
							?>
							<div class="post-head">				
								<div class="post-img">
									<a data-rel="prettyPhoto" href="<?php echo $large_image_url[ 0 ]; ?>"  title="<?php the_title_attribute(); ?>"><?php echo get_the_post_thumbnail( get_the_ID(), 'leap-portfolio-1col' ); ?></a>
								</div>
							</div>
							<?php
						}
						?>
					</div>

					<div class="entry-content" itemprop="mainContentOfPage">
						<div class="post-content">
							<?php the_content(); ?>
							<?php wp_link_pages( array( 'before' => '<p><strong>' . esc_html__( 'Pages', 'wiz' ) . ':</strong> ', 'after' => '</p>', 'next_or_number' => 'number' ) ); ?>

							<div id="leap-contact">
								<div class="leap-contact-details row">
									<div class="<?php echo leap_bws_col_class( 8 ) ?>">
										<?php if ( !empty( $leap_error_message ) ) : ?>
											<div id="leap-contact-message"><?php echo($leap_error_message); ?> </div>
										<?php endif; ?>

										<?php if ( $leap_contact_error ) { ?> 
											<form class="leap-contact-form" action="<?php the_permalink(); ?>" method="post">

												<div class="row">
													<div class="<?php echo leap_bws_col_class( 6 ) ?>">
														<div class="form-group">
															<label class="sr-only" for="name"><?php echo esc_attr_e( 'Name (required)', 'wiz' ); ?></label>
															<input id="name" class="form-control" type="text" name="leap_name" value="<?php if ( isset( $_POST[ 'leap_name' ] ) ) echo esc_attr( $_POST[ 'leap_name' ] ); ?>" placeholder="<?php echo esc_attr_e( 'Name (required)', 'wiz' ); ?>" required="required" />
														</div>
													</div>
													<div class="<?php echo leap_bws_col_class( 6 ) ?>">
														<div class="form-group">
															<label class="sr-only" for="inputEmail"><?php echo esc_attr_e( 'Email (required)', 'wiz' ); ?></label>
															<input id="inputEmail" class="form-control" type="email" name="leap_email" value="<?php if ( isset( $_POST[ 'leap_email' ] ) ) echo esc_attr( $_POST[ 'leap_email' ] ); ?>" placeholder="<?php echo esc_attr_e( 'Email (required)', 'wiz' ); ?>" required="required" />
														</div>
													</div>
												</div>

												<div class="row">
													<div class="<?php echo leap_bws_col_class( 12 ) ?>">
														<div class="controls-row">
															<div class="form-group"><input id="subject" class="form-control" type="text" name="leap_subject" value="<?php if ( isset( $_POST[ 'leap_subject' ] ) ) echo esc_attr( $_POST[ 'leap_subject' ] ); ?>" placeholder="<?php echo esc_attr_e( 'Subject (required)', 'wiz' ); ?>" required="required"/></div>
														</div>
													</div>
												</div>


												<div class="row">
													<div class="<?php echo leap_bws_col_class( 12 ) ?>">
														<div class="form-group">
															<textarea id="message" class="form-control" name="leap_message" rows="5" placeholder="<?php echo esc_attr_e( 'Message', 'wiz' ); ?>" required="required"><?php if ( isset( $_POST[ 'leap_message' ] ) ) echo esc_textarea( $_POST[ 'leap_message' ] ); ?></textarea>
														</div>
													</div>
												</div>

												<?php if ( $enable_recaptcha == 'on' ) { ?>
													<div class="row">
														<div class="<?php echo leap_bws_col_class( 12 ) ?>">
															<div class="form-group">

																<div class="g-recaptcha" data-sitekey="<?php echo $recaptcha_site_key; ?>" data-theme="<?php echo ot_get_option( 'recaptcha_theme', 'light' ); ?>"></div>

															</div>
														</div>
													</div>
												<?php } ?>

												<input id="submit-form" class=" btn btn-leap" type="submit" name="leap_submit" value="<?php _e( 'Submit', 'wiz' ); ?>" />


												<?php wp_nonce_field( 'leap-contact-form-submit', '_wpnonce-leap-contact-form-submitted' ); ?>
											</form>
										<?php } ?>
									</div>
									<div class="contact-info <?php echo leap_bws_col_class( 4 ); ?>">
										<?php
										$contact_address = ot_get_option( 'contact_address', '' );
										if ( !empty( $contact_address ) ) :
											?>
											<div>
												<strong><?php esc_html_e( 'Address', 'wiz' ); ?>:</strong>
												<span><?php echo esc_html( $contact_address ); ?></span>
											</div>
										<?php endif; ?>


										<?php
										$contact_phone = ot_get_option( 'contact_phone', '' );
										if ( !empty( $contact_phone ) ) :
											?>
											<div>
												<strong><?php esc_html_e( 'Phone', 'wiz' ); ?>:</strong>
												<span><?php echo esc_html( $contact_phone ); ?></span>
											</div>
										<?php endif; ?>

										<?php
										$contact_mobile = ot_get_option( 'contact_mobile', '' );
										if ( !empty( $contact_mobile ) ) :
											?>
											<div>
												<strong><?php esc_html_e( 'Mobile', 'wiz' ); ?>:</strong>
												<span><?php echo esc_html( $contact_mobile ); ?></span>
											</div>
										<?php endif; ?>

										<?php
										$contact_fax = ot_get_option( 'contact_fax', '' );
										if ( !empty( $contact_fax ) ) :
											?>
											<div>
												<strong><?php esc_html_e( 'Fax', 'wiz' ); ?>:</strong>
												<span><?php echo esc_html( $contact_fax ); ?></span>
											</div>
										<?php endif; ?>

										<?php
										$contact_email = ot_get_option( 'contact_email', '' );
										if ( !empty( $contact_email ) ) :
											?>
											<div>
												<strong><?php esc_html_e( 'Email', 'wiz' ); ?>: </strong>
												<span><a href="mailto:<?php echo $contact_email; ?>"><?php echo $contact_email; ?></a></span>
											</div>
										<?php endif; ?>

									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		<?php endwhile; ?>


	</div>

	<?php
	/**
	 * Content bottom sidebar
	 */
	get_template_part( 'includes/sidebar/content-bottom' );
	?>



</div> <!-- end #main -->

<?php get_footer(); ?>