<?php

$social_links = ot_get_option( 'social_links', array() );
if ( !empty( $social_links ) ) {
    echo '<p class="social-networks">';
    foreach ( $social_links as $social_link ) {

        switch ( $social_link[ 'media_network' ] ) {
            case 'googleplus':
                $social_link[ 'media_network' ] = 'google-plus';
                break;
            case 'pinterest':
                $social_link[ 'media_network' ] = 'pinterest-p';
                break;
            case 'dribble':
                $social_link[ 'media_network' ] = 'dribbble';
                break;
        }

        echo '<a target="_blank" class="' . sanitize_html_class( $social_link[ 'media_network' ] ) . '" data-toggle="tooltip" title="' . esc_attr( $social_link[ 'title' ] ) . '" href="' . esc_url( $social_link[ 'media_network_url' ] ) . '"><i class="fa fa-' . sanitize_html_class( $social_link[ 'media_network' ] ) . '"></i></a>';
    }
    echo '</p>';
}
