<?php
if ( ot_get_option( 'enable_header_sidebar', 'off' ) == 'on' ) {
	$header_sidebar = leap_override_widget_position( 'header_sidebar', 'leap_header_sidebar' );
	if ( $header_sidebar != 'none' ) {

		$header_sidebar	 = explode( '-', $header_sidebar );
		$col_count		 = count( $header_sidebar );

		$active_sidebar = array();
		for ( $i = 1; $i <= $col_count; $i++ ) {
			$replacement_sidebar = leap_get_replacement_sidebar( 'header' . $i );
			$active_sidebar[]	 = is_active_sidebar( $replacement_sidebar );
			unset( $replacement_sidebar );
		}

		if ( in_array( 1, $active_sidebar ) ) {
			$sidebar_id		 = leap_get_current_sidebar_style();
			$header_parallax = leap_get_sidebar_option_with_default( 'leap_header_sidebar_parallax_background_image', $sidebar_id );
			?>
			<div id="header-sidebar" <?php echo ($header_parallax == 'on' ? 'class="leap-parallax"' : '') ?>>
				<div class="<?php echo apply_filters( 'leap_container_class', 'container-fluid' ); ?>">
					<div class="row">
						<?php
						for ( $i = 1; $i <= $col_count; $i++ ) {
							echo '<div class="' . leap_bws_col_class( $header_sidebar[ $i - 1 ] ) . '" >';
							leap_dynamic_sidebar( 'header' . $i );
							echo '</div>';
						}
						?>
					</div>
				</div>
			</div>
			<?php
		}
	}
}