<?php
$related_leap_projects_query = leap_related_projects( get_the_ID() );
if ( $related_leap_projects_query->have_posts() ) {
	?>
	<div class="related-projects">
		<div class="title">
			<h4><?php _e( 'Related Projects', 'wiz' ) ?></h4>
		</div>
		<?php
		$output = '<div class="list_carousel responsive"><ul class="portfolio-slider">';
		while ( $related_leap_projects_query->have_posts() ) {
			$related_leap_projects_query->the_post();
			if ( has_post_thumbnail() ) {
				$output .= '<li class="leap-overlay item-img">';
				$output .= get_the_post_thumbnail( get_the_ID(), 'leap-related-thumbnail' );
				$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'large' );
				$output .= '<div class="item-overlay one">';
				$output .= '<div class="item-img-color"></div>';
				$output .= '<div class="item-details">';
				$output .= '<h4 class="item-title"><a href="' . get_permalink() . '" title="' . the_title_attribute( 'echo=0' ) . '">' . get_the_title() . '</a></h4>';
				$output .= '<div class="item-links">';
				$output .= '<a class="item-link" href="' . get_permalink() . '" title="' . the_title_attribute( 'echo=0' ) . '">' . __( 'Link', 'wiz' ) . '</a>';
				$output .= '<a class="enlarge" data-rel="prettyPhoto[sc_portfolio_gal]" href="' . $large_image_url[ 0 ] . '" title="' . the_title_attribute( 'echo=0' ) . '">' . __( 'Enlarge', 'wiz' ) . '</a>';
				$output .= '</div>';
				$output .= '</div>';
				$output .= '</div>';
				$output .= '</li>';
			}
		}
		$output .= '</ul><div class="cfs-nav"><span class="cfs-prev">Previous</span><span class="cfs-next">Next</span></div></div>';
		wp_reset_postdata();
		echo $output;
		?>

	</div>


<?php } ?>