<?php
$header_phone		 = ot_get_option( 'header_phone', '' );
$header_email		 = ot_get_option( 'header_email', '' );
$social_links		 = ot_get_option( 'social_links', array() );
$sticky_header		 = leap_get_option_with_default( 'sticky_header', 'leap_sticky_header' );
$sticky_headerclass	 = '';
if ( $sticky_header == 'yes' ) {
	$sticky_headerclass = 'navbar-fixed-top';
}
?>
<div id="leap-header" class="header header9">

	<?php
	if ( !empty( $header_phone ) || !empty( $header_email ) || !empty( $social_links ) ) {
		?>

		<div class="topbar-block">
			<div class="<?php echo apply_filters( 'leap_container_class', 'container-fluid' ); ?>">
				<div class="row">
					<div class="<?php echo leap_bws_col_class( 6 ); ?>">
						<div class="pull-left contact-info">
							<?php echo $header_phone; ?><?php if ( $header_phone && $header_email ): ?><span class="sep">|</span><?php endif; ?><?php echo $header_email; ?>
						</div>
					</div>
					<div class="<?php echo leap_bws_col_class( 6 ); ?>">
						<div class="pull-right social-icons">
							<?php get_template_part( 'includes/social', 'icons' ); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
	?>


    <div class="header-placholder"></div>
    <div class="navbar-inner <?php echo $sticky_headerclass; ?>">
	    <div class="mainmenu-logo-container <?php echo (ot_get_option('main_menu_logo_style', 'boxed') == 'boxed') ? 'boxed-header' : ''; ?>">
			<div class="<?php echo apply_filters( 'leap_container_class', 'container-fluid' ); ?> nav-container">
                <div class="row">
                <div class="col-sm-12">
				<div class="mainmenu-logo">
	
					<div class="pull-left left-menu">
	
						<?php
						$left_menu = leap_get_assigned_menu_on_theme_location( 'left-menu' );
	
						$left_menu_obj = wp_get_nav_menu_object( $left_menu );
						if ( !empty( $left_menu_obj ) && $left_menu_obj->count > 0 ) {
							wp_nav_menu( array(
								'theme_location' => 'left-menu',
								'menu'			 => $left_menu,
								'container'		 => 'div',
								'container_id'	 => 'left-menu-container',
								'menu_id'		 => 'left-menu',
								'menu_class'	 => 'sf-menu main-menu',
								'depth'			 => 0,
								'walker'		 => new Leap_Mega_Menu_Walker(),
								'fallback_cb'	 => false,
								'link_before'	 => '<span>',
								'link_after'	 => '</span>'
							) );
						}
						?>
					</div>
	
					<div class="logo text-center">
						<a title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" href="<?php echo esc_url( home_url( '/' ) ); ?>">
							<?php
							$logo = ot_get_option( 'logo', '' );
							if ( $logo ) {
								?>
								<img alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" src="<?php echo esc_url( $logo ) ?>" />
								<?php
							} else {
								echo '<h1>' . esc_html( get_bloginfo( 'name', 'display' ) ) . '</h1>';
							}
							?>
						</a>
					</div>
	
	
					<div class="pull-right right-menu">
	
						<?php
						$right_menu = leap_get_assigned_menu_on_theme_location( 'right-menu' );
	
						$right_menu_obj = wp_get_nav_menu_object( $right_menu );
						if ( !empty( $right_menu_obj ) && $right_menu_obj->count > 0 ) {
							wp_nav_menu( array(
								'theme_location' => 'right-menu',
								'menu'			 => $right_menu,
								'container'		 => 'div',
								'container_id'	 => 'right-menu-container',
								'menu_id'		 => 'right-menu',
								'menu_class'	 => 'sf-menu main-menu',
								'depth'			 => 0,
								'walker'		 => new Leap_Mega_Menu_Walker(),
								'fallback_cb'	 => false,
								'link_before'	 => '<span>',
								'link_after'	 => '</span>'
							) );
						}
						?>
					</div>
	
					<?php
					$mobile_menu = leap_get_assigned_menu_on_theme_location( 'mobile-main-menu' );
	
					$mobile_menu_obj = wp_get_nav_menu_object( $mobile_menu );
					if ( !empty( $mobile_menu_obj ) && $mobile_menu_obj->count > 0 ) {
						wp_nav_menu( array(
							'theme_location' => 'mobile-main-menu',
							'menu'			 => $mobile_menu,
							'container'		 => 'div',
							'container_id'	 => 'main-menu-mobile-container',
							'menu_id'		 => 'main-menu-mobile',
							'menu_class'	 => 'main-menu-mobile hidden',
							'depth'			 => 0,
							'walker'		 => '',
							'fallback_cb'	 => false,
						) );
					} else {
						?>
						<ul id="main-menu-mobile" class="main-menu-mobile hidden">
							<?php wp_nav_menu( array( 'menu' => $left_menu, 'items_wrap' => '%3$s', 'container' => false ) ); ?>
							<?php wp_nav_menu( array( 'menu' => $right_menu, 'items_wrap' => '%3$s', 'container' => false ) ); ?>
						</ul>
						<?php
					}
					?>
					<div id="mobile-menu"></div>
				</div>
	        </div>
	    </div>
    </div>
</div>
        </div>
    </div>