<?php
$header_phone		 = ot_get_option( 'header_phone', '' );
$header_email		 = ot_get_option( 'header_email', '' );
$social_links		 = ot_get_option( 'social_links', array() );
$sticky_header		 = leap_get_option_with_default( 'sticky_header', 'leap_sticky_header' );
$sticky_headerclass	 = '';
if ( $sticky_header == 'yes' ) {
	$sticky_headerclass = 'navbar-fixed-top';
}
?>
<div id="leap-header" class="header header6">
	<?php
	if ( !empty( $header_phone ) || !empty( $header_email ) || !empty( $social_links ) ) {
		?>
		<div class="topbar-block">
			<div class="<?php echo apply_filters( 'leap_container_class', 'container-fluid' ); ?>">
				<div class="row">
					<div class="<?php echo leap_bws_col_class( 6 ); ?>">
						<div class="pull-left contact-info">
							<?php echo $header_phone; ?><?php if ( $header_phone && $header_email ): ?><span class="sep">|</span><?php endif; ?><?php echo $header_email; ?>
						</div>

					</div>
					<div class="<?php echo leap_bws_col_class( 6 ); ?>">
						<div class="pull-right social-icons">
							<?php get_template_part( 'includes/social', 'icons' ); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
	?>


    <div class="logo-block">
        <div class="<?php echo apply_filters( 'leap_container_class', 'container-fluid' ); ?>">
			<div class="row">
				<div class="<?php echo leap_bws_col_class( 4 ); ?>">
					<div class="logo pull-left">
						<a title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" href="<?php echo esc_url( home_url( '/' ) ); ?>">
							<?php
							$logo = ot_get_option( 'logo', '' );
							if ( !empty( $logo ) ) {
								echo '<img alt="' . esc_attr( get_bloginfo( 'name', 'display' ) ) . '" src="' . esc_url( $logo ) . '" />';
							} else {
								echo '<h1>' . esc_html( get_bloginfo( 'name', 'display' ) ) . '</h1>';
							}
							?>
						</a>
					</div>
				</div>
				<div class="<?php echo leap_bws_col_class( 8 ); ?>">
					<?php
					/**
					 * Above post banner
					 */
					get_template_part( 'includes/banners/top' );
					?>
				</div>
			</div>

        </div>
    </div>

	<div class="header-placholder"></div>


    <div class="navbar-inner <?php echo $sticky_headerclass; ?>">
        <div class="<?php echo apply_filters( 'leap_container_class', 'container-fluid' ); ?> nav-container">
            <div class="row">
                <div class="col-sm-12">
            <div class="logo pull-left">        
                <a title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" href="<?php echo esc_url( home_url( '/' ) ); ?>">
					<?php
					$logo = ot_get_option( 'logo', '' );
					if ( !empty( $logo ) ) {
						?>
						<img alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" src="<?php echo esc_url( $logo ) ?>" />
						<?php
					} else {
						echo '<h1>' . esc_html( get_bloginfo( 'name', 'display' ) ) . '</h1>';
					}
					?>
                </a>
            </div>
			<?php
			$header_search = ot_get_option( 'header_search', 'on' );
			if ( $header_search == 'on' ) {
				?>
				<div class="static-search pull-right">
					<form class="navbar-search" role="search" method="get" action="<?php echo esc_attr( home_url( '/' ) ); ?>">
						<input name="s" type="text" class="form-control search-query" value="<?php echo get_search_query(); ?>" placeholder="<?php esc_html_e( 'Search ...', 'wiz' ); ?>"/>
						<button type="submit" class="btn"></button>
					</form>
				</div>
				<div class="search fixed-search pull-right hidden-xs">
					<a href="javascript:void(0)" id="searchbutton"></a>
					<div class="searchform" style="display: none;">
						<form class="navbar-search pull-right" role="search" method="get" action="<?php echo esc_attr( home_url( '/' ) ); ?>">
							<input name="s" type="text" class="form-control search-query" value="<?php echo get_search_query(); ?>" placeholder="<?php esc_html_e( 'Search ...', 'wiz' ); ?>"/>
							<button type="submit" class="btn"></button>
						</form>
					</div>
				</div>
			<?php } ?>
			<?php
			$main_menu		 = leap_get_assigned_menu_on_theme_location( 'main-menu' );
			$page_id		 = leap_get_current_page_id();
			$page_main_menu	 = get_post_meta( $page_id, 'leap_main_menu', TRUE );

			if ( $page_main_menu ) {
				$main_menu = $page_main_menu;
			}

			$main_menu_obj = wp_get_nav_menu_object( $main_menu );
			if ( !empty( $main_menu_obj ) && $main_menu_obj->count > 0 ) {
				wp_nav_menu( array(
					'theme_location' => 'main-menu',
					'menu'			 => $main_menu,
					'container'		 => 'div',
					'container_id'	 => 'main-menu-container',
					'menu_id'		 => 'main-menu',
					'menu_class'	 => 'sf-menu main-menu',
					'depth'			 => 0,
					'walker'		 => new Leap_Mega_Menu_Walker(),
					'fallback_cb'	 => false,
					'link_before'	 => '<span>',
					'link_after'	 => '</span>'
				) );
			}
			?>

			<?php
			$mobile_menu = leap_get_assigned_menu_on_theme_location( 'mobile-main-menu' );

			if ( empty( $mobile_menu ) ) {
				$mobile_menu = $main_menu;
			}

			$mobile_menu_obj = wp_get_nav_menu_object( $mobile_menu );
			if ( !empty( $mobile_menu_obj ) && $mobile_menu_obj->count > 0 ) {
				wp_nav_menu( array(
					'theme_location' => 'mobile-main-menu',
					'menu'			 => $mobile_menu,
					'container'		 => 'div',
					'container_id'	 => 'main-menu-mobile-container',
					'menu_id'		 => 'main-menu-mobile',
					'menu_class'	 => 'main-menu-mobile hidden',
					'depth'			 => 0,
					'walker'		 => '',
					'fallback_cb'	 => false,
				) );
			}
			?>
			<div id="mobile-menu"></div>

        </div>
    </div>
</div>
        </div>
</div>