<?php
$page_id			 = leap_get_current_page_id();
$header_phone		 = ot_get_option( 'header_phone', '' );
$header_email		 = ot_get_option( 'header_email', '' );
$sticky_header		 = leap_get_option_with_default( 'sticky_header', 'leap_sticky_header' );
$sticky_headerclass	 = '';
if ( $sticky_header == 'yes' ) {
	$sticky_headerclass = 'navbar-fixed-top';
}
?>

<div id="leap-header" class="header header5">
	<div class="topbar-block">
		<div class="<?php echo apply_filters( 'leap_container_class', 'container-fluid' ); ?>">
			<div class="row">
				<div class="<?php echo leap_bws_col_class( 4 ); ?>">
					<div class="pull-left social-icons">
						<?php get_template_part( 'includes/social', 'icons' ); ?>
					</div>
				</div>
				<div class="<?php echo leap_bws_col_class( 8 ); ?>">
					<div class="pull-right">
						<?php
						$top_menu		 = leap_get_assigned_menu_on_theme_location( 'top-menu' );
						$page_top_menu	 = get_post_meta( $page_id, 'leap_top_menu', TRUE );

						if ( $page_top_menu ) {
							$top_menu = $page_top_menu;
						}

						$top_menu_obj = wp_get_nav_menu_object( $top_menu );
						if ( !empty( $top_menu_obj ) && $top_menu_obj->count > 0 ) {
							wp_nav_menu( array(
								'theme_location' => 'top-menu',
								'menu'			 => $top_menu,
								'container'		 => 'div',
								'container_id'	 => 'top-menu-container',
								'menu_id'		 => 'top-menu',
								'menu_class'	 => 'sf-menu top-menu',
								'depth'			 => 0,
								'fallback_cb'	 => false
							) );
						}
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="logo-block">
		<div class="<?php echo apply_filters( 'leap_container_class', 'container-fluid' ); ?>">
			<div class="row">
				<div class="<?php echo leap_bws_col_class( 6 ); ?>">
					<div class="logo pull-left">
						<a title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" href="<?php echo esc_url( home_url( '/' ) ); ?>">
							<?php
							$logo = ot_get_option( 'logo', '' );
							if ( !empty( $logo ) ) {
								?>
								<img alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" src="<?php echo esc_url( $logo ); ?>" />
								<?php
							} else {
								echo '<h1>' . esc_html( get_bloginfo( 'name', 'display' ) ) . '</h1>';
							}
							?>
						</a>
					</div>
				</div>
				<div class="<?php echo leap_bws_col_class( 6 ); ?>">
					<?php
					$header_search = ot_get_option( 'header_search', 'on' );
					if ( $header_search == 'on' ) {
						?>
						<div class="pull-right static-search">
							<form class="navbar-search" role="search" method="get" action="<?php echo esc_attr( home_url( '/' ) ); ?>">
								<input name="s" type="text" class="form-control search-query" value="<?php echo get_search_query(); ?>" placeholder="<?php esc_attr_e( 'Search ...', 'wiz' ); ?>"/>
								<button type="submit" class="btn"></button>
							</form>
						</div>
					<?php } ?>
				</div>
			</div>




		</div>
	</div>

	<div class="header-placholder"></div>

	<div class="navbar-inner <?php echo $sticky_headerclass; ?>">
		<div class="<?php echo apply_filters( 'leap_container_class', 'container-fluid' ); ?> nav-container">
            <div class="row">
                <div class="col-sm-12">
			<div class="logo pull-left">
				<a title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" href="<?php echo esc_url( home_url( '/' ) ); ?>">
					<?php
					$logo = ot_get_option( 'logo', '' );
					if ( !empty( $logo ) ) {
						?>
						<img alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" src="<?php echo esc_url( $logo ) ?>" />
						<?php
					} else {
						echo '<h1>' . esc_html( get_bloginfo( 'name', 'display' ) ) . '</h1>';
					}
					?>
				</a>
			</div> 
			<?php if ( $header_search == 'on' ) {
				?>
				<div class="search fixed-search hidden-xs">
					<a href="javascript:void(0)" id="searchbutton"></a>
					<div class="searchform" style="display: none;">
						<form class="navbar-search pull-right" role="search" method="get" action="<?php echo esc_attr( home_url( '/' ) ); ?>">
							<input name="s" type="text" class="form-control search-query" value="<?php echo get_search_query(); ?>" placeholder="<?php esc_attr_e( 'Search ...', 'wiz' ); ?>"/>
							<button type="submit" class="btn"></button>
						</form>
					</div>
				</div>
			<?php } ?>

			<?php
			$main_menu		 = leap_get_assigned_menu_on_theme_location( 'main-menu' );
			$page_main_menu	 = get_post_meta( $page_id, 'leap_main_menu', TRUE );

			if ( $page_main_menu ) {
				$main_menu = $page_main_menu;
			}

			$main_menu_obj = wp_get_nav_menu_object( $main_menu );
			if ( !empty( $main_menu_obj ) && $main_menu_obj->count > 0 ) {
				wp_nav_menu( array(
					'theme_location' => 'main-menu',
					'menu'			 => $main_menu,
					'container'		 => 'div',
					'container_id'	 => 'main-menu-container',
					'menu_id'		 => 'main-menu',
					'menu_class'	 => 'sf-menu main-menu',
					'depth'			 => 0,
					'walker'		 => new Leap_Mega_Menu_Walker(),
					'fallback_cb'	 => false,
					'link_before'	 => '<span>',
					'link_after'	 => '</span>'
				) );
			}
			?>

			<?php
			$mobile_menu = leap_get_assigned_menu_on_theme_location( 'mobile-main-menu' );

			if ( empty( $mobile_menu ) ) {
				$mobile_menu = $main_menu;
			}

			$mobile_menu_obj = wp_get_nav_menu_object( $mobile_menu );
			if ( !empty( $mobile_menu_obj ) && $mobile_menu_obj->count > 0 ) {
				wp_nav_menu( array(
					'theme_location' => 'mobile-main-menu',
					'menu'			 => $mobile_menu,
					'container'		 => 'div',
					'container_id'	 => 'main-menu-mobile-container',
					'menu_id'		 => 'main-menu-mobile',
					'menu_class'	 => 'main-menu-mobile hidden',
					'depth'			 => 0,
					'walker'		 => '',
					'fallback_cb'	 => false,
				) );
			}
			?>
			<div id="mobile-menu"></div>



        </div>
    </div>
            </div>
    </div>
</div>