<?php
$header_phone = ot_get_option('header_phone', '');
$header_email = ot_get_option('header_email', '');
$social_links = ot_get_option('social_links', array());
$sticky_header = leap_get_option_with_default('sticky_header', 'leap_sticky_header');
$sticky_headerclass = '';
if ($sticky_header == 'yes') {
    $sticky_headerclass = 'navbar-fixed-top';
}

?>

<div id="leap-header" class="header header15">
	<div class="header-placholder"></div>
    <div class="navbar-inner <?php echo esc_attr($sticky_headerclass); ?>">
        
        <div class="top-header-content" >
        <div>
            <div class="nav-container">

                <?php
                $main_menu = leap_get_assigned_menu_on_theme_location('main-menu');
                $page_id = leap_get_current_page_id();
                $page_main_menu = get_post_meta($page_id, 'leap_main_menu', true);

                if ($page_main_menu) {
                    $main_menu = $page_main_menu;
                }

                $main_menu_obj = wp_get_nav_menu_object($main_menu);
                if (!empty($main_menu_obj) && $main_menu_obj->count > 0) {
                    wp_nav_menu(array(
                        'theme_location' => 'main-menu',
                        'menu' => $main_menu,
                        'container' => 'div',
                        'container_id' => 'main-menu-container',
                        'menu_id' => 'main-menu',
                        'menu_class' => 'sf-menu main-menu ' . ot_get_option('main_menu_item_effects'),
                        'depth' => 0,
                        'walker' => new Leap_Mega_Menu_Walker(),
                        'fallback_cb' => false,
                        'link_before' => '<span>',
                        'link_after' => '</span>'
                    ));
                }

                ?>
                <?php
                $mobile_menu = leap_get_assigned_menu_on_theme_location('mobile-main-menu');

                if (empty($mobile_menu)) {
                    $mobile_menu = $main_menu;
                }

                $mobile_menu_obj = wp_get_nav_menu_object($mobile_menu);
                if (!empty($mobile_menu_obj) && $mobile_menu_obj->count > 0) {
                    wp_nav_menu(array(
                        'theme_location' => 'mobile-main-menu',
                        'menu' => $mobile_menu,
                        'container' => 'div',
                        'container_id' => 'main-menu-mobile-container',
                        'menu_id' => 'main-menu-mobile',
                        'menu_class' => 'main-menu-mobile hidden',
                        'depth' => 0,
                        'walker' => '',
                        'fallback_cb' => false,
                    ));
                }

                ?>
                <div id="mobile-menu"></div>
            </div>
        </div>
    </div>
        

    <div class="icon-header">

            <div class="logo">
                <a title="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" href="<?php echo esc_url(home_url('/')); ?>">
                    <?php
                    $logo = ot_get_option('logo', '');
                    if ($logo) {
                        ?>
                        <img alt="<?php echo esc_attr(get_bloginfo('name', 'display'));
                        ?>" src="<?php echo esc_url($logo) ?>" />
                        <?php

                    } else {
                        echo '<h1>' . esc_html(get_bloginfo('name', 'display')) . '</h1>';
                    }

                    ?>
                </a>
            </div>
            <div class="pull-right icon-social-block">
                <a href="#" id="nav-icon" class="menu-icon">
                    <span></span>
                    <span></span>
                    <span></span>
                </a>
                <div class="social-icons">
                    <?php get_template_part('includes/social', 'icons'); ?>
                </div>
            </div> 
        

    </div>
</div></div>


